function im3=lum2true(imATD)

%Convierte una matriz NxMx3 de valores ATD en una imagen de color verdadero NxMx3
%
%USO: im3=lum2true(imATD)
%
%     imY: matriz de luminancias NxM  
%     im3: matriz de color verdadero NxMx3


%Carga el sistema de referencia y los datos del monitor
[T_l,Yw,Msx]=loadsysm([matlabroot '\toolbox\colorlab\colordat\systems\ciexyz']);
[tm,a,g]=loadmonm([matlabroot '\toolbox\colorlab\colordat\monitor\std_crt'],Msx);



[imindprob,ATD]=true2pal(imATD,256);
mapT=atd2xyz(ATD,1,6);
[np,saturatp,Tnp]=tri2val(mapT,Yw,tm,a,g,8);
im3=pal2true(imindprob,np);


