function [im3,imATD0,Ym0]=cargimcsfa;

%Permite cargar una imagen de color verdadero cualquiera, transformarla al espacio ATD
%de Boynton y convertirla en una imagen NxMx3 de valores de ATD.
%
%Para elegir la imagen, se abre un cuadro de dilogo.
%
%USO: [im3,imATD,Ym0]=cargimcsfa;
%
%      im3= imagen en color verdadero
%      imATD= matriz NxMx3 con las valores ATD de cada punto
%      Ym0= luminancia media de la imagen.


%Carga el sistema de referencia y los datos del monitor
[T_l,Yw,Msx]=loadsysm([matlabroot '\toolbox\colorlab\colordat\systems\ciexyz']);
[tm,a,g]=loadmonm([matlabroot '\toolbox\colorlab\colordat\monitor\std_crt'],Msx);

%Permite cargar un archivo mediante un cuadro de dialogo
cd([matlabroot '\toolbox\practicas\procsf\imagenes\']);
[nombre,sendero]=uigetfile('*.*', 'Selecciona un fichero de imagen');
im3=imread([sendero nombre]);

%Transforma los niveles digitales en valores triestmulo
[imind0,mapn0]=true2pal(im3,256);
mapT0=val2tri(mapn0,Yw,tm,a,g); 

%Transforma la imagen al espacio de Boynton
ATD0=xyz2atd(mapT0,6);
imATD0=pal2true(imind0,ATD0);

%Calcula la luminancia media
Ym0=mean(mean(imATD0(:,:,1)));



