function csf3=csf3d(csf,fmax,Nfrec)

%A partir de la csf unidimensional, se genera una figura de revolucion
%csf3, siendo Nfrec^2 el numero de puntos (fx,fy) del nuevo dominio y fmax
%su lmite.
%
%csf3=csf3d(csf,fmax,Nfrec)

[fx,fy]=meshgrid(linspace(-fmax,fmax,Nfrec));
Nang=19;
ang=linspace(0,2*pi,Nang);
xa=[0;csf(:,1)];ya=[0;0*csf(:,1)];fa=[1;csf(:,2)];
for i=2:Nang-1
    xa=[xa;csf(:,1)*cos(ang(i))];
    ya=[ya;csf(:,1)*sin(ang(i))];
    fa=[fa;csf(:,2)];
end
[csf3(:,:,1),csf3(:,:,2),f]=griddata(xa,ya,fa,fx,fy);
n=find(isnan(f));
f(n)=1e-6;
csf3(:,:,3)=f;