function [x,y,f]=revolucion(x0,f0,Nx)

%A partir de la function unidimensional f0=f(x0), se genera una figura de revolucion
%f=f(x,y), siendo Nx^2 el numero de puntos (x,y) del nuevo dominio.
%
%[x,y,f]=revolucion(x0,f0,Nx)

[x,y]=meshgrid(linspace(-max(x0),max(x0),Nx));
Nang=19;
ang=linspace(0,2*pi,Nang);
xa=x0';ya=0*x0';fa=f0';
for i=2:Nang-1
    xa=[xa;x0'*cos(ang(i))];
    ya=[ya;x0'*sin(ang(i))];
    fa=[fa;f0'];
end
[x,y,f]=griddata(xa,ya,fa,x,y);
n=find(isnan(f));
f(n)=0;