# ------------------------------
# 1. Datos
# ---1---------------------------
x <- 0:20

lx <- c(
  912376.8746, 905990.2365, 899648.3048, 893350.7667, 887097.3113,
  880887.6301, 854062.085,   837753.9845, 826724.8737, 818355.3831,
  811335.6872, 805010.7333, 799052.8561, 793298.085, 787664.2979,
  782110.2976, 776615.3504, 771168.9554, 765765.7289, 760402.8469,
  755039.9649
)

# ------------------------------
# 2. Preparar variables
# ------------------------------
ln_lx <- log(lx)
x2 <- x^2

# ------------------------------
# 3. Ajuste del modelo
# ------------------------------
modelo <- lm(ln_lx ~ x + x2)
summary(modelo)

coeficientes <- coef(modelo)
ln_l0 <- coeficientes[1]
ln_S1 <- coeficientes[2]
ln_S2 <- coeficientes[3]

l0 <- exp(ln_l0)
S1 <- exp(ln_S1)
S2 <- exp(ln_S2)

cat("l0 =", l0, "\n")
cat("S1 =", S1, "\n")
cat("S2 =", S2, "\n")

# ------------------------------
# 4. Predicciones
# ------------------------------
ln_lx_pred <- predict(modelo)
lx_pred <- exp(ln_lx_pred)
residuales <- ln_lx - ln_lx_pred

# ------------------------------
# 5. Data frame resumen
# ------------------------------
resultado <- data.frame(
  x = x,
  lx = lx,
  ln_lx = ln_lx,
  ln_lx_pred = ln_lx_pred,
  lx_pred = lx_pred,
  residuales = residuales
)

print(resultado)

# ------------------------------
# 6. Gráficos
# ------------------------------

# --- Observado vs Predicho (escala original)
plot(x, lx, type="b", pch=19, col="blue",
     main="lx observado vs predicho",
     xlab="x", ylab="lx")
lines(x, lx_pred, type="b", pch=17, col="red")
legend("topright", legend=c("Observado","Predicho"),
       col=c("blue","red"), pch=c(19,17))

# --- Observado vs Predicho (logaritmos)
plot(x, ln_lx, type="b", pch=19, col="blue",
     main="ln(lx) observado vs predicho",
     xlab="x", ylab="ln(lx)")
lines(x, ln_lx_pred, type="b", pch=17, col="red")
legend("topright", legend=c("Observado","Predicho"),
       col=c("blue","red"), pch=c(19,17))

# --- Residuales vs x
plot(x, residuales, pch=19, col="purple",
     main="Residuales vs x",
     xlab="x", ylab="Residuales (ln)")
abline(h=0, col="gray")

# --- Histograma de residuales
hist(residuales, col="lightblue",
     main="Histograma de residuales",
     xlab="Residuales (ln)")

# --- QQ-plot de residuales
qqnorm(residuales, main="QQ-plot de residuales")
qqline(residuales, col="red")
