library(shiny)
library(ggplot2)
library(gridExtra)

ui <- fluidPage(
  titlePanel("Analisis del modelo de Dormoy 1 con  w, s y x(edad)"),
  
  sidebarLayout(
    sidebarPanel(
      numericInput("lo", "lo:", 
      value = 1000, min = 1, max =1000000, step = 100),
      sliderInput("w", "Valor de w:", 
                  min = 1, max = 120, value = 100, step = 0.1),
      sliderInput("n", "edad:", 
                  min = 1, max = 110, value = 20, step = 1),
      sliderInput("s", "S:", 
                  min = 0.9, max = 0.99999, value = 0.997, step = 0.001),
      
      #numericInput("n", "Edad:", 
                   #value = 10, min = 0, max =110, step = 1),
      
     #numericInput("s", "Número de puntos:", 
                  #value = 0,97, min = 0.8, max = 0.999999),
      
      selectInput("funcion", "Modelo :",
                  choices = c("Dormoy 1" = "dormoy"))
                              
                   # "dormoy1" = "dormoy1",
                             # "Exponencial" = "exponencial",
                             # "Seno" = "seno"))
     
    ),
    
    mainPanel(
      plotOutput("graficos_combinados"),
      verbatimTextOutput("resultados_completos")
      
  )
)
)

server <- function(input, output) {

  calcular_funcion <- function(s=input$s, x=input$x,dormoy=input$dormoy, w=input$w,lo=input$lo) {
    switch(dormoy,
           "dormoy" =lo*s^(x),
           "moivre" = 1-x/w,
          "exponencial" = exp(w * x),
          "seno" = sin(w * x))
  }
  
  calcular_mx <- function(s=input$s, x) {
    if (s == 0) return(NA)
    return(-log(s)) 
  }
  calcular_px <- function(w,s=input$s,n) {
    if (w == 0) return(NA)
    return(s=input$s)
  }
  calcular_ex <- function(w=input$w,s=input$s,n=input$n,x) {
    if (w == 0) return(NA)
    z<-(w=input$w)-(n=input$n)
    d<-input$s^z
    dd<-d-1
    l<-log(input$s)
    return(dd/l)
  }
  datos_reactivos <- reactive({
    #num_puntos<-100
    x <- seq(0, input$w, length.out = 1000)
    y <- calcular_funcion(input$s, x, input$funcion)
    mx <- calcular_mx(input$s, x)
    px <- calcular_px(input$s, x)
    ex<-calcular_ex(input$w,input$x,input$s,n=input$n)
    data.frame(x = x, y = y, mx = mx, px=px, ex=ex)
  })
  
  output$graficos_combinados <- renderPlot({
    datos <- datos_reactivos()
    w <- input$w
    n <- input$n
    s<-input$s
    n_valido <- n >= 0 & n <= w
    
    # Gráfico de la función principal
    p1 <- ggplot(datos, aes(x = x, y = y)) +
      geom_line(color = "darkblue", size = 1) +
      labs(title = paste("f(x) con lo =", input$lo),
           x = "x", y = "f(x)") +
      theme_minimal()
    
    # Gráfico de mx
    p2 <- ggplot(datos, aes(x = x, y = mx)) +
      geom_line(color = "darkred", size = 1) +
      labs(title = "Tanto x = -ln(s)",
           x = "x", y = "mx") +
      theme_minimal()
    # Gráfico de px
    p3 <- ggplot(datos, aes(x = x, y = px)) +
      geom_line(color = "darkred", size = 1) +
      labs(title = "px = S",
           x = "x", y = "px") +
      theme_minimal()
    
    p4 <- ggplot(datos, aes(x = x, y = ex)) +
      geom_line(color = "darkred", size = 1) +
      labs(title = "esperanza = (w-x)/2",
           x = "x", y = "ex") +
      theme_minimal()
    
    # Agregar puntos en n si es válido
    if (n_valido) {
      y_n <- calcular_funcion(w,s=input$s, input$funcion)
      mx_n <- calcular_mx(s, n)
      px_n <- calcular_px(w, n)
      ex_n <- calcular_ex(w, n,s)
      
      
      p1 <- p1 + 
        geom_point(aes(x = n, y = y_n), color = "red", size = 3) +
        geom_vline(xintercept = n, linetype = "dashed", color = "red")
      
      p2 <- p2 + 
        geom_point(aes(x = n, y = mx_n), color = "red", size = 3) +
        geom_vline(xintercept = n, linetype = "dashed", color = "red")
      p3 <- p3 + 
        geom_point(aes(x = n, y = px_n), color = "red", size = 3) +
        geom_vline(xintercept = n, linetype = "dashed", color = "red")
      p4 <- p4 + 
        geom_point(aes(x = n, y = ex_n), color = "red", size = 3) +
        geom_vline(xintercept = n, linetype = "dashed", color = "red")
    }
    
    grid.arrange(p1, p2, p3,   ncol = 2)
  })
  
  output$resultados_completos <- renderPrint({
    datos <- datos_reactivos()
    w <- input$w
    n <- input$n
    s<-input$s
    
    valor_funcion_n <- calcular_funcion(n, s=input$s, input$funcion)
    valor_mx_n <- calcular_mx(s, n)
    valor_px_n <- calcular_px(w, n)
    valor_ex_n<-calcular_ex(w,n,s)
    n_valido <- n >= 0 & n <= w
    
    cat("RESULTADOS PARA w =", w, "y x =", n, "\n")
    cat("=====================================\n\n")
    
    cat("EN x = n:\n")
    cat("---------\n")
    cat("f(n) =", round(valor_funcion_n, 6), "\n")
    cat("Tanto x = -ln(S) =", round(valor_mx_n, 6), "\n")
    cat("px = S =", round(valor_px_n, 6), "\n")
    cat(" aprox. esperanza de vida = (S^(w-x)-1)/ln(S) =", round(valor_ex_n, 6), "\n")
    if (!n_valido) cat("⚠️ Nota: n fuera del rango [0, w]\n")
    
    cat("Juan\n")
   
    
  })
}

shinyApp(ui = ui, server = server)