/***********************************
 *								   *
 *	Scatter Search C code		   *	
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *	
 *								   *	
 ***********************************/

#ifndef SS_H
#define SS_H

#include "stdio.h"
#include "stdlib.h"
#include "malloc.h"
#include "math.h"
#include "string.h"

typedef struct REFSET
{
	int		b;				/* Size									*/
	double	**sol;			/* Solutions							*/ 
	double  *ObjVal;		/* Objective value of solutions			*/
	int		*order;			/* Order of solutions 					*/
	int		*iter;			/* Input iteration number of solutions	*/
	int		NewSolutions;	/* =1 if a new elements has been added	*/

} REFSET;

typedef struct P
{
	int		PSize;		/* Size of the Set P				  */
	double	**sol;		/* Solutions in the Set				  */ 
	double  *ObjVal;	/* Objective value of sols. 		  */

} P;

typedef struct SS
{
	int		nvar;		 /* Number of variables of the problem	*/
	double  *high;		 /* Upper bound of variables			*/
	double  *low;		 /* Lower bound of variables			*/
	
	int		**freq;		 /* Frequency count for div. generator  */
	int		CurrentIter; /* Number of Current Iteration			*/

	REFSET  *rs;
	P		*p;

} SS;


/* Functions in file SSMemory.c */
double	*SSDouble_array(int size);
double	**SSDouble_matrix(int nrows,int ncolumns);
void	SSFree_DataStructures(SS *pb);
void	SSFree_double_matrix(double **matrix,int nrows);
void	SSFree_int_matrix(int **matrix,int nrows);
int		*SSInt_array(int size);
int		**SSInt_matrix(int nrows,int ncolumns);
SS		*SSProblem_Definition(int nvar,int b,int PSize);

/* Functions in file SSTools.c */
void	SSAbort(char texto[]);

#endif  /* SS_H */