/***********************************
 *								   *
 *	Scatter Search C code		   *	
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *	
 *								   *	
 ***********************************/

#include "SS.h"

SS *SSProblem_Definition(int nvar,int b,int PSize)
{
	SS *pb;

	pb = (SS*) calloc(1,sizeof(SS));
    if(!pb) SSAbort("Memory allocation problem: SS");

	/* Problem Parameters */
	pb->CurrentIter = 0;
	pb->freq        = SSInt_matrix(nvar,4);

	/* Variable definition */
	pb->nvar = nvar;
	pb->high = SSDouble_array(nvar);
	pb->low	 = SSDouble_array(nvar);

	/* Diverse Set */
	pb->p = (P*) calloc(1,sizeof(P));
    if(!pb->p) SSAbort("Memory allocation problem: P");

	pb->p->PSize  = PSize;
	pb->p->sol    = SSDouble_matrix(PSize,nvar);
	pb->p->ObjVal = SSDouble_array(PSize);

	/* Reference Set */
	pb->rs = (REFSET*) calloc(1,sizeof(REFSET));
    if(!pb->rs) SSAbort("Memory allocation problem: REFSET");

	pb->rs->b	   = b;
	pb->rs->sol    = SSDouble_matrix(b,nvar);
	pb->rs->ObjVal = SSDouble_array(b);
	pb->rs->order  = SSInt_array(b);
	pb->rs->iter   = SSInt_array(b);

	return pb;
}

void SSFree_DataStructures(SS *pb)
{
	SSFree_int_matrix(pb->freq,pb->nvar);
	free(pb->high+1);
	free(pb->low+1);

	/* Reference Set */
	SSFree_double_matrix(pb->rs->sol,pb->rs->b);
	free(pb->rs->ObjVal+1);
	free(pb->rs->order+1);
	free(pb->rs->iter+1);
	free(pb->rs);

	/* Diverse Set */
	SSFree_double_matrix(pb->p->sol,pb->p->PSize);
	free(pb->p->ObjVal+1);
	free(pb->p);

	free(pb);
}

int **SSInt_matrix(int nrows,int ncolumns)
/* Allocate an int matrix with "nrows" rows and "ncolumns" columns */
{
	int i,**aux;

	aux = (int**)calloc(nrows,sizeof(int*));
	if(!aux) SSAbort("Memory allocation problem: SSint_matrix");

	aux--;
	for(i=1;i<=nrows;i++)
		aux[i] = SSInt_array(ncolumns);

	return aux;
}

double **SSDouble_matrix(int nrows,int ncolumns)
/* Allocate a double matrix with "nrows" rows and "ncolumns" columns */
{
	double **aux;
	int i;

	aux = (double**)calloc(nrows,sizeof(double*));
	if(!aux) SSAbort("Memory allocation problem: SSdouble_matrix");

	aux--;
	for(i=1;i<=nrows;i++)
		aux[i] = SSDouble_array(ncolumns);
		
	return aux;
}

double *SSDouble_array(int size)
/* Allocate a double array from 1 to size */
{
	double *aux;

	aux = (double*)calloc(size,sizeof(double));
	if(!aux) SSAbort("Memory allocation problem: SSdouble_array");
	return aux-1;
}

int *SSInt_array(int size)
/* Allocate an int array from 1 to size */
{
	int *aux;

	aux = (int*)calloc(size,sizeof(int));
	if(!aux) SSAbort("Memory allocation problem: SSint_array");
	return aux-1;
}

void SSFree_double_matrix(double **matrix,int nrows)
/* Free a double matrix allocated with SSdouble_matrix */
{
	int i;

	for(i=1;i<=nrows;i++)
		free(matrix[i]+1);
	free(matrix+1);
}

void SSFree_int_matrix(int **matrix,int nrows)
/* Free an int matrix allocated with SSint_matrix */
{
	int i;

	for(i=1;i<=nrows;i++)
		free(matrix[i]+1);
	free(matrix+1);
}




