/***********************************
 *								   *
 *	Scatter Search C code		   *	
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *	
 *								   *	
 ***********************************/

#ifndef SS_H
#define SS_H

#include "stdio.h"
#include "stdlib.h"
#include "malloc.h"
#include "math.h"
#include "string.h"

typedef struct REFSET
{
	int		b;				/* Size									*/
	double	**sol;			/* Solutions							*/ 
	double  *ObjVal;		/* Objective value of solutions			*/
	int		*order;			/* Order of solutions 					*/
	int		*iter;			/* Input iteration number of solutions	*/
	int		NewSolutions;	/* =1 if a new elements has been added	*/

} REFSET;

typedef struct P
{
	int		PSize;		/* Size of the Set P				  */
	double	**sol;		/* Solutions in the Set				  */ 
	double  *ObjVal;	/* Objective value of sols. 		  */

} P;

typedef struct SS
{
	int		nvar;		 /* Number of variables of the problem	*/
	double  *high;		 /* Upper bound of variables			*/
	double  *low;		 /* Lower bound of variables			*/
	
	int		**freq;		 /* Frequency count for div. generator  */
	int		CurrentIter; /* Number of Current Iteration			*/

	double  **pool;		 /* Combined solutions					*/
	int     pool_size;   /* Number of elements in pool			*/

	REFSET  *rs;
	P		*p;

} SS;

/* Definitions */
#define SSGetrandom(min,max)	(int)( (SSRandNum()*(max+1-min)) + (min))
#define MAXPOSITIVE				10000000

/* User defined function */
double sol_value(double sol[]);

/* Functions in file SSImprove1.c */
void	SSImprove_solution(SS *pb, double sol[],double *value);
double	SSMove(SS *pb,double *worst_point,double *worst_value, double *psum, double factor);
void	SS_Simplex(SS *pb,double **simplex,double *values,int max_eval);

/* Functions in file SSMemory1.c */
double	*SSDouble_array(int size);
double	**SSDouble_matrix(int nrows,int ncolumns);
void	SSFree_DataStructures(SS *pb);
void	SSFree_double_matrix(double **matrix,int nrows);
void	SSFree_int_matrix(int **matrix,int nrows);
int		*SSInt_array(int size);
int		**SSInt_matrix(int nrows,int ncolumns);
SS		*SSProblem_Definition(int nvar,int b,int PSize);

/* Functions in file SSP1.c */
void	SSCreate_P(SS *pb);
void	SSGenerate_Sol(SS *pb,double sol[]);
void	SSPrint_P(SS *pb);

/* Functions in file SSRefSet1.c */
void	SSCombine(SS *pb,double sol1[],double sol2[],double **newsols);
void	SSCombine_RefSet(SS *pb);
void	SSCreate_RefSet(SS *pb);
void	SSPrint_RefSet(SS *pb);
void	SSRebuild_RefSet(SS *pb);
void	SSTryAdd_RefSet(SS *pb,double sol[],double value);
void	SSUpdate_RefSet(SS *pb);

/* Functions in file SSTools1.c */
void	SSAbort(char texto[]);
void    SSBestSol(SS *pb,double sol[],double *value);
double  SSDist_RefSet(SS *pb,int num,double sol[]);
int		SSEqualSol(double sol1[],double sol2[],int dim);
int		SSIsInRefSet(SS *pb,double sol[]);
int		SSMax_dist_index(SS *pb,double dist[]);
int		*SSOrder(double weights[],int num,int type);
float	SSRandNum(void);
void    SSUpdate_distances(SS *pb,double min_dist[],int rs_index);

#endif  /* SS_H */