/***********************************
 *								   *
 *	Scatter Search C code		   *
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *
 *								   *
 ***********************************/

#include "SS1.h"

void SSImprove_solution(SS *pb,double sol[],double *value)
{
	double **simplex,*values;
	int i,j,best_sol;

	simplex = SSDouble_matrix(pb->nvar+1,pb->nvar);
	values  = SSDouble_array(pb->nvar+1);
	
	/* Copy original solution in nvar+1 vertices */
	for(j=1;j<=pb->nvar+1;j++)
	for(i=1;i<=pb->nvar;i++)
		simplex[j][i]=sol[i];
	values[1]=*value;

	/* Perturb nvar vertices */
	for(j=1;j<=pb->nvar;j++)
	{
		simplex[j+1][j] += 0.1*(pb->high[j]-pb->low[j]);
		if(simplex[j+1][j]>pb->high[j])
		   simplex[j+1][j]=pb->high[j];
		if(simplex[j+1][j]<pb->low[j])
		   simplex[j+1][j]=pb->low[j];

		values[j+1] = sol_value(simplex[j+1]);
	}

	/* Call the Simplex method for 50 evaluations */
	SS_Simplex(pb,simplex,values,50);

	/* Select the best vertex */
	best_sol=0;
	for(i=1;i<=pb->nvar+1;i++)
		if( *value>values[i])
		{
			*value=values[i];
			best_sol=i;
		}

	if(best_sol>0)
	{
		for(i=1;i<=pb->nvar;i++)
		{
			sol[i]=simplex[best_sol][i];

			if(sol[i]<pb->low[i])
				sol[i]=pb->low[i];
			if(sol[i]>pb->high[i])
				sol[i]=pb->high[i];
		}
		*value = sol_value(sol);
	}

	free(values+1);
	SSFree_double_matrix(simplex,pb->nvar+1);
}



void SS_Simplex(SS *pb,double **simplex,double *values,int max_eval)
{
	int i,j,best_index,worst_index,nextworst_index,evalnum;
	double factor,new_value, move_value,sum,*cum_simplex;

	cum_simplex = SSDouble_array(pb->nvar);
	evalnum=0;factor=1.0;

	/* Add solutions */
	for (j=1;j<=pb->nvar;j++)
	{ 
		sum=0.0;
		for (i=1;i<=pb->nvar+1;i++)
			sum += simplex[i][j];
		cum_simplex[j]=sum;
	}

	while(evalnum < max_eval)
	{
		/* Compute best, worst and next worst points */
		best_index = 1;
		if(values[1] > values[2])
		{
			nextworst_index = 2;
			worst_index =1;
		}
		else
		{
			nextworst_index = 1;
			worst_index =2;
		}


		for (i = 1; i <= pb->nvar+1; i++)
		{
			if (values[i] < values[best_index])
				best_index = i;
			if (values[i] > values[worst_index])
			{
				nextworst_index = worst_index;
				worst_index = i;
			}
			else if (values[i] > values[nextworst_index] && i != worst_index)
				nextworst_index = i;
		}

		new_value = SSMove(pb,simplex[worst_index],&(values[worst_index]),cum_simplex,-factor);
		evalnum++;

		if (new_value <= values[best_index])
		{
			new_value = SSMove(pb,simplex[worst_index],&(values[worst_index]),cum_simplex,2*factor);
			evalnum++;
		}
		else if (new_value >= values[nextworst_index])
		{
			move_value = values[worst_index];
			new_value  = SSMove(pb,simplex[worst_index],&(values[worst_index]),cum_simplex,factor/2);
			evalnum++;

			if (new_value >= move_value)
			{
				for (i = 1; i <= pb->nvar+1; i++)
					if (i != best_index)
					{
						for (j = 1; j <= pb->nvar; j++)
						{
							cum_simplex[j] = 0.5*(simplex[i][j]+simplex[best_index][j]);
							simplex[i][j] = cum_simplex[j];
						}
						values[i] = sol_value(cum_simplex);
						evalnum++;
					}
							
				/* Add solutions */
				for (j=1;j<=pb->nvar;j++)
				{ 
					for (i=1, sum=0.0;i<=pb->nvar+1;i++)
						sum += simplex[i][j];
					cum_simplex[j]=sum;
				}
			}
		}
	}
	free(cum_simplex+1);
}


double SSMove(SS *pb,double *worst_point,double *worst_value, double *cum_simplex, double factor)
{
	int i;
	double rfac,*new_point,new_value;

	/* Generate a new point */
	new_point = SSDouble_array(pb->nvar);
	rfac = (1.0-factor)/(double)pb->nvar;
	for (i=1;i<=pb->nvar;i++)
		new_point[i]=cum_simplex[i]*rfac - worst_point[i]*(rfac-factor);
	new_value = sol_value(new_point);

	/* Check worst_point replacement */
	if (new_value < *worst_value)
	{
		*worst_value = new_value;
		for (i=1;i<=pb->nvar;i++)
		{
			cum_simplex[i] += new_point[i]-worst_point[i];
			worst_point[i] = new_point[i];
		}
	}
	free(new_point+1);
	return new_value;
}

