/***********************************
 *								   *
 *	Scatter Search C code		   *
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *
 *								   *
 ***********************************/

#include "SS1.h"

int main(void)
{
	SS *pb;					/* Pointer problem				*/
	int nvar    =    4;		/* Number of problem variables	*/
	int b       =   10;		/* Size of Reference Set		*/
	int PSize   =  100;		/* Size of P					*/
	int Iter    =    1;		/* Number of Current Iteration	*/
	int MaxIter =  100;		/* Maximum number of iterations */
	double  *sol,value;
	int i;

	pb = SSProblem_Definition(nvar,b,PSize);

	SSCreate_P(pb);
	SSCreate_RefSet(pb);

	for(Iter=1; Iter<MaxIter; Iter++)
	{
		if(pb->rs->NewSolutions)
			SSUpdate_RefSet(pb);
		else
			SSRebuild_RefSet(pb);
	}

	/* Print Best Solution Found */
	sol	= SSDouble_array(pb->nvar);
	SSBestSol(pb,sol,&value);
	printf("\n\nBest Solution Found:\nValue = %f\n",value);
	for(i=1;i<=nvar;i++) printf("x[%d]  = %f\n",i,sol[i]);
	free(sol+1);

	SSFree_DataStructures(pb);
	return 0;
}

double sol_value(double sol[])
{
	double value=0;

	value  = 100*pow(sol[2]-pow(sol[1],2),2)+pow(1-sol[1],2);
	value += 90 *pow(sol[4]-pow(sol[3],2),2)+pow(1-sol[3],2);
	value += 10.1*(pow(sol[2]-1,2)+pow(sol[4]-1,2));
	value += 19.8*(sol[2]-1)*(sol[4]-1);

	return value;
}