/***********************************
 *								   *
 *	Scatter Search C code		   *	
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *	
 *								   *	
 ***********************************/

#include "SS1.h"

void SSCreate_P(SS *pb)
{
	double *sol,obj_val;
	int currentPSize,j,equal;

	sol	= SSDouble_array(pb->nvar);

	currentPSize=1;
	while(currentPSize<=pb->p->PSize)
	{
		SSGenerate_Sol(pb,sol);
		obj_val = sol_value(sol);

		SSImprove_solution(pb,sol,&obj_val);

		/* Check whether sol is a new solution */
		j=1;equal=0;
		while(j<currentPSize && !equal)
			equal=SSEqualSol(sol,pb->p->sol[j++],pb->nvar);

		/* Add improved solution to P */
		if(!equal)
		{
			for(j=1;j<=pb->nvar;j++)
				pb->p->sol[currentPSize][j] = sol[j];
			pb->p->ObjVal[currentPSize++] = obj_val;
		}
	}
	free(sol+1);
}

void SSGenerate_Sol(SS *pb,double sol[])
{
	int i,j,var,total,sum,index,*rfreq;
	double r,value,range;

	rfreq = SSInt_array(4);

	for(var=1;var<=pb->nvar;var++)
	{
		/* Compute frequency complements */
		sum=total=0;
		for(i=1;i<=4;i++)
			sum += pb->freq[var][i];
		
		for(i=1;i<=4;i++)
		{
			rfreq[i] = sum - pb->freq[var][i];
			total   += rfreq[i];
		}

		/* Choose a sub-range (index) */
		if(total==0)
			index = SSGetrandom(1,4);
		else {
			j = SSGetrandom(1,total);
			index=1;
			while(j>rfreq[index])
				j -= rfreq[index++];
		}

		if(index>4) SSAbort("Failure in SSGenerate_Sol");

		/* Update freq */
		pb->freq[var][index]++;

		/* Select a value in the index sub-range */
		range= pb->high[var]-pb->low[var];
		r = SSRandNum();
		value=pb->low[var]+(index-1)*(range/4) + (r*range/4);

		sol[var]=value;
	}
	free(rfreq+1);


}

void SSPrint_P(SS *pb)
{
	FILE *pf;
	int i,j;

	pf=fopen("setP.txt","w");
	if(!pf) SSAbort("File opening failure");

	for(i=1;i<=pb->p->PSize;i++)
	{
		fprintf(pf,"\n%2d:",i);
		fprintf(pf,"  %f",pb->p->ObjVal[i]);
		for(j=1;j<=pb->nvar;j++)
			fprintf(pf," %3.2f",pb->p->sol[i][j]);
	}
	fclose(pf);
}






