/***********************************
 *								   *
 *	Scatter Search C code		   *
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *
 *								   *
 ***********************************/

#include "SS1.h"

void SSCreate_RefSet(SS *pb)
{
	double *min_dist;
	int b1,i,j,a,*p_order,*rs_order;

	/* Order solutions in P */
	p_order = SSOrder(pb->p->ObjVal,pb->p->PSize,-1);

	/* Add the b1 best solutions in P to RefSet */
	b1 = pb->rs->b / 2;
	for(i=1;i<=b1;i++)
	{
		for(j=1;j<=pb->nvar;j++)
			pb->rs->sol[i][j] = pb->p->sol[p_order[i]][j];
		pb->rs->ObjVal[i] = pb->p->ObjVal[p_order[i]];
		pb->rs->iter[i]   = 1;
		pb->rs->order[i]  = i;
	}

	/* Compute minimum distances from P to RefSet */
	min_dist = SSDouble_array(pb->p->PSize);	
	for(i=1;i<=pb->p->PSize;i++)
		min_dist[i]= SSDist_RefSet(pb,b1,pb->p->sol[i]);

	/* Add the diverse b-b1 solutions to RefSet */
	for(i=b1+1;i<=pb->rs->b;i++)
	{
		a=SSMax_dist_index(pb,min_dist);

		for(j=1;j<=pb->nvar;j++)
			pb->rs->sol[i][j] = pb->p->sol[a][j];
		pb->rs->ObjVal[i] = pb->p->ObjVal[a];
		pb->rs->iter[i]   = 1;

		SSUpdate_distances(pb,min_dist,i);
	}

	/* Compute the order in RefSet */
	rs_order = SSOrder(pb->rs->ObjVal,pb->rs->b,-1);
	for(i=1;i<=pb->rs->b;i++)	
		pb->rs->order[i] = rs_order[i];

	pb->rs->NewSolutions = 1;
	pb->CurrentIter      = 1;

	free(rs_order+1);free(p_order+1);free(min_dist+1);
}

void SSRebuild_RefSet(SS *pb)
{	
	double *min_dist;
	int b1,i,j,a,index,*rs_order;

	b1 = pb->rs->b / 2;

	/* Create a new set P */
	SSCreate_P(pb);

	/* Compute minimum distances from P to RefSet */
	min_dist = SSDouble_array(pb->p->PSize);	
	for(i=1;i<=pb->p->PSize;i++)
		min_dist[i]= SSDist_RefSet(pb,b1,pb->p->sol[i]);
	
	/* Add the diverse b-b1 solutions to RefSet
	   (remove the worst b1 sols. in Refset) */
	for(i=b1+1;i<=pb->rs->b;i++)
	{
		a=SSMax_dist_index(pb,min_dist);
		index = pb->rs->order[i];

		for(j=1;j<=pb->nvar;j++)
			pb->rs->sol[index][j] = pb->p->sol[a][j];
		pb->rs->ObjVal[index] = pb->p->ObjVal[a];
		pb->rs->iter[index] = pb->CurrentIter;

		SSUpdate_distances(pb,min_dist,index);
	}

	/* Compute the order in RefSet */
	rs_order = SSOrder(pb->rs->ObjVal,pb->rs->b,-1);
	for(i=1;i<=pb->rs->b;i++)	
		pb->rs->order[i] = rs_order[i];

	pb->rs->NewSolutions = 1;

	free(min_dist+1);free(rs_order+1);
}


void SSUpdate_RefSet(SS *pb)
{
	int a;
	double value;

	pb->rs->NewSolutions=0;
	SSCombine_RefSet(pb);
	pb->CurrentIter++;

	for(a=1;a<=pb->pool_size;a++)
	{
		value=sol_value(pb->pool[a]);
		SSImprove_solution(pb,pb->pool[a],&value);
		SSTryAdd_RefSet(pb,pb->pool[a],value);
	}

	pb->pool_size=0;
}


void SSCombine_RefSet(SS *pb)
{
	int i,j,a,s;
	double **newsols;

	newsols = SSDouble_matrix(3,pb->nvar);

	/* Combine elements in RefSet */
	for(i=1;i<pb->rs->b;i++)
	for(j=i+1;j<=pb->rs->b;j++)
	{
		/* Combine solutions that have not been previously
		   combined (3 new trial solutions for each pair) */
		if(pb->rs->iter[i] == pb->CurrentIter ||
		   pb->rs->iter[j] == pb->CurrentIter)
		{
			SSCombine(pb,pb->rs->sol[i],pb->rs->sol[j],newsols);
			for(a=1;a<=3;a++)
			{
				pb->pool_size++;
				for(s=1;s<=pb->nvar;s++)
					pb->pool[pb->pool_size][s]=newsols[a][s];
			}
		}
	}

	SSFree_double_matrix(newsols,3);
}


void SSTryAdd_RefSet(SS *pb,double sol[],double value)
/* If solution sol qualifies, it is added to RefSet 
   (the worst one is replaced) */
{
	int i,j,worst_index;

	worst_index=pb->rs->order[pb->rs->b];
	if(!SSIsInRefSet(pb,sol) && value<pb->rs->ObjVal[worst_index])
	{
		/* Find position i for sol. insertion */
		i=pb->rs->b;
		while(i>=1 && value<pb->rs->ObjVal[pb->rs->order[i]])
			i--;
		i++;

		/* Replace solution */
		for(j=1;j<=pb->nvar;j++)
			pb->rs->sol[worst_index][j]=sol[j];
		pb->rs->ObjVal[worst_index]=value;
		pb->rs->iter[worst_index]=pb->CurrentIter;

		/* Update ReSet order */
		for(j=pb->rs->b;j>i;j--)
			pb->rs->order[j]=pb->rs->order[j-1];
		pb->rs->order[i]=worst_index;

		pb->rs->NewSolutions=1;
	}
}

void SSCombine(SS *pb,double sol1[],double sol2[],double **newsols)
{
	int j;
	double *d,r;

	d=SSDouble_array(pb->nvar);
	for(j=1;j<=pb->nvar;j++)
		d[j] = (sol2[j]-sol1[j])/2;
	
	/* Generate a C1 solution */
	r=SSRandNum();
	for(j=1;j<=pb->nvar;j++)
	{
		newsols[1][j] = sol1[j] - r*d[j];
		if(newsols[1][j]>pb->high[j]) newsols[1][j]=pb->high[j];
		if(newsols[1][j]<pb->low[j])  newsols[1][j]=pb->low[j];
	}

	/* Generate a C2 solution */
	r=SSRandNum();
	for(j=1;j<=pb->nvar;j++)
	{
		newsols[2][j] = sol1[j] + r*d[j];
		if(newsols[2][j]>pb->high[j]) newsols[2][j]=pb->high[j];
		if(newsols[2][j]<pb->low[j])  newsols[2][j]=pb->low[j];
	}

	/* Generate a C3 solution */
	r=SSRandNum();
	for(j=1;j<=pb->nvar;j++)
	{
		newsols[3][j] = sol2[j] + r*d[j];
		if(newsols[3][j]>pb->high[j]) newsols[3][j]=pb->high[j];
		if(newsols[3][j]<pb->low[j])  newsols[3][j]=pb->low[j];
	}

	free(d+1);
}

void SSPrint_RefSet(SS *pb)
{
	int i,j;
	FILE *pf;

	pf=fopen("RefSet.txt","w");
	if(!pf) SSAbort("File opening failure");

	for(i=1;i<=pb->rs->b;i++)
	{
		fprintf(pf,"\n%2d ",i);
		fprintf(pf,"  %4.10f    ",pb->rs->ObjVal[pb->rs->order[i]]);
		for(j=1;j<=pb->nvar;j++)
			fprintf(pf," %3.4f",pb->rs->sol[pb->rs->order[i]][j]);
	}
	fclose(pf);
}



