/***********************************
 *								   *
 *	Scatter Search C code		   *	
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *	
 *								   *	
 ***********************************/

#include "SS1.h"

#define M  714025
#define IA 1366
#define IC 150889

float SSRandNum(void)
{
	int j;
	static long ir[98],iy,idum = 13171191;
	static int iff=0;

	if (idum < 0 || iff == 0) {
		iff=1;
		if ((idum=(IC-(idum)) % M) < 0) idum = -(idum);
		for (j=1;j<=97;j++) {
			idum=(IA*(idum)+IC) % M;
			ir[j]=(idum);
		}
		idum=(IA*(idum)+IC) % M;
		iy=(idum);
	}
	j=(int)(1 + 97.0*(iy)/M);  

	if (j > 97 || j < 1)
		SSAbort("Failure in random number generator");

	iy=ir[j];
	idum=(IA*(idum)+IC) % M;
	ir[j]=(idum);

	return (float) (iy)/M;
}

#undef M
#undef IA
#undef IC

void SSAbort(char text[])
/* Prints a message and exit the program */
{
	printf("\n%s",text);
	exit(1);
}

int SSEqualSol(double sol1[],double sol2[],int dim)
/* Checks whether two solutions are the same (returns 1)
   or not (returns 0) */
{
	int i;

	for(i=1;i<=dim;i++)
		if(sol1[i] != sol2[i]) 
			return 0;

	return 1;
}

int SSIsInRefSet(SS *pb,double sol[])
/* Checks whether sol is in RefSet (returns 1)
   or not (returns 0) */
{
	int i;

	for(i=1;i<=pb->rs->b;i++)
		if(SSEqualSol(pb->rs->sol[i],sol,pb->nvar))
			return 1;
	return 0;
}

int *SSOrder(double weights[],int num,int type)
/* Orders an array of num elements (double).
   Returns an array with the indexes ordered.
   type =1 for high to low, -1 for low to high */
{
	int *index,b,t,j,i,tempi;
	double temp,*cost;
	
	cost=SSDouble_array(num);
	index=SSInt_array(num);

	for(i=1;i<=num;i++)
	{
		cost[i]=weights[i];
		index[i]=i;
	}
	
	b=num;
	while(b!=0)
	{   
		t=0;              
		for(j=1;j<=b-1;j++)
		{
			if( (type==1  && cost[j]<cost[j+1]) ||
				(type==-1 && cost[j]>cost[j+1])    )
			{
				temp=cost[j+1];
				cost[j+1]=cost[j];
				cost[j]=temp;
				
				tempi=index[j+1];
				index[j+1]=index[j];
				index[j]=tempi;
				
				t=j;
			}		
		}
		b=t;
	}	
	free(cost+1);
	return index;
}

double SSDist_RefSet(SS *pb,int num,double sol[])
/* Minimum distance from sol to the first num
   elements (according to rs->order) in RefSet */
{
	double dist,min_dist;
	int a,j,i;

	min_dist = (double) MAXPOSITIVE;
	for(a=1;a<=num;a++)
	{
		i=pb->rs->order[a];
		dist=0;
		for(j=1;j<=pb->nvar;j++)
			dist += pow(sol[j]-pb->rs->sol[i][j],2);
		dist = sqrt(dist);
		if(min_dist> dist)
			min_dist=dist;
	}
	return min_dist;
}

int SSMax_dist_index(SS *pb,double dist[])
/* Find the index of the solution in P with maximum
   distance to RefSet */
{
	int j,index=1;
	double dmax;

	dmax=dist[1];
	for(j=2;j<=pb->p->PSize;j++)
		if(dist[j]>dmax)
		{
			dmax=dist[j];
			index=j;
		}
	
	return index;
}

void SSUpdate_distances(SS *pb,double min_dist[],int rs_index)
/* For each solution in P, compute the distance to the last
   input sol. in RefSet. If it is lower than the minimum 
   already computed, it is updated. */
{
	double d;
	int i,j;
	
	for(i=1;i<=pb->p->PSize;i++)
	{
		d=0;
		for(j=1;j<=pb->nvar;j++)
			d += pow(pb->p->sol[i][j]-pb->rs->sol[rs_index][j],2);
		d=sqrt(d);
		if(d<min_dist[i])
			min_dist[i]=d;
	}
}

void SSBestSol(SS *pb,double sol[],double *value)
{
	int i;

	for(i=1;i<=pb->nvar;i++)
		sol[i] = pb->rs->sol[pb->rs->order[1]][i];
	*value = pb->rs->ObjVal[pb->rs->order[1]];
}