/***********************************
 *								   *
 *	Scatter Search C code		   *
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *
 *								   *
 ***********************************/

#include "SS2.h"

void SSImprove_solution(SS *pb,int sol[],int *value)
{
	int i,j,feasible,*order,lhs=0;
	double *ratio;

	/* Compute profit-to-weight ratio */
	ratio=SSDouble_array(pb->nvar);
	for(i=1;i<=pb->nvar;i++)
		ratio[i]=(double)pb->ObjCoeff[i]/(double)pb->ConstCoeff[i];
	order=SSOrder_d(ratio,pb->nvar,1);

	/* Feasibility Phase  */
	j=pb->nvar;
	while(!SSIsFeasible(pb,sol))
	{
		if(sol[order[j]]==1)
		{
			sol[order[j]]=0;
			*value -= pb->ObjCoeff[order[j]];
		}
		j--;
	}

	/* Improvement Phase */
	j=feasible=1;
	for(i=1;i<=pb->nvar;i++)
		lhs  += pb->ConstCoeff[i]*sol[i];

	while(feasible && j<=pb->nvar)
	{
		/* Find first null value in sol */
		while(sol[order[j]])
			j++;
		if(lhs+pb->ConstCoeff[order[j]]<=pb->ConstCoeff[pb->nvar+1])
		{
			sol[order[j]]=1;
			lhs += pb->ConstCoeff[order[j]];
			*value += pb->ObjCoeff[order[j]];
		}
		else feasible=0;
	}

	free(ratio+1);free(order+1);
}

