/***********************************
 *								   *
 *	Scatter Search C code		   *
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *
 *								   *
 ***********************************/

#include "SS2.h"

int main(void)
{
	SS *pb;				/* Pointer problem data structure */
	int nvar    =  10;	/* Number of problem variables	  */
	int b       =  10;	/* Size of the Reference Set	  */
	int PSize   =  30;	/* Size of P					  */
	int Iter    =   1;	/* Number of Current Iteration	  */
	int MaxIter =  50;  /* Maximum number of iterations   */
	int *sol,value,i;

	pb = SSProblem_Definition(nvar,b,PSize);

	SSCreate_P(pb);
	SSCreate_RefSet(pb);

	for(Iter=1; Iter<MaxIter; Iter++)
	{
		if(pb->rs->NewSolutions)
			SSUpdate_RefSet(pb);
		else
			SSRebuild_RefSet(pb);
	}

	/* Print Best Solution Found */
	sol	= SSInt_array(pb->nvar);
	SSBestSol(pb,sol,&value);
	printf("\n\nBest Solution Found:\nValue = %d\n",value);
	for(i=1;i<=nvar;i++) printf("x[%d]  = %d\n",i,sol[i]);
	free(sol+1);

	SSFree_DataStructures(pb);
	return 0;
}

int sol_value(SS *pb,int sol[])
{
	int i,value=0;

	for(i=1;i<=pb->nvar;i++)
		value  += pb->ObjCoeff[i]*sol[i];

	return value;
}