/***********************************
 *								   *
 *	Scatter Search C code		   *	
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *	
 *								   *	
 ***********************************/

#include "SS2.h"

SS *SSProblem_Definition(int nvar,int b,int PSize)
{
	SS *pb;

	pb = (SS*) calloc(1,sizeof(SS));
    if(!pb) SSAbort("Memory allocation problem: SS");

	/* Problem Parameters */
	pb->CurrentIter = 0;
	pb->nvar		= nvar;

	/* Profit and Constraint Coefficients */
	pb->ObjCoeff	= SSInt_array(nvar);
	pb->ConstCoeff	= SSInt_array(nvar+1);
	SSSet_Coefficients(pb);

	/* Diverse Set */
	pb->p = (P*) calloc(1,sizeof(P));
    if(!pb->p) SSAbort("Memory allocation problem: P");

	pb->p->PSize  = PSize;
	pb->p->sol    = SSInt_matrix(PSize,nvar);
	pb->p->ObjVal = SSInt_array(PSize);

	/* Reference Set */
	pb->rs = (REFSET*) calloc(1,sizeof(REFSET));
    if(!pb->rs) SSAbort("Memory allocation problem: REFSET");

	pb->rs->b	   = b;
	pb->rs->sol    = SSInt_matrix(b,nvar);
	pb->rs->ObjVal = SSInt_array(b);
	pb->rs->order  = SSInt_array(b);
	pb->rs->iter   = SSInt_array(b);

	/* Solutions' Pool */
	pb->NDivSol = 1000;
	pb->DivSol  = SSInt_matrix(pb->NDivSol,nvar);
	pb->pool	= SSInt_matrix(4*b*b,nvar);

	return pb;
}

void SSSet_Coefficients(SS *pb)
{
	pb->ObjCoeff[1] = 11;
	pb->ObjCoeff[2] = 10;
	pb->ObjCoeff[3] = 9;
	pb->ObjCoeff[4] = 12;
	pb->ObjCoeff[5] = 10;
	pb->ObjCoeff[6] = 6;
	pb->ObjCoeff[7] = 7;
	pb->ObjCoeff[8] = 5;
	pb->ObjCoeff[9] = 3;
	pb->ObjCoeff[10] = 8;

	pb->ConstCoeff[1] = 33;
	pb->ConstCoeff[2] = 27;
	pb->ConstCoeff[3] = 16;
	pb->ConstCoeff[4] = 14;
	pb->ConstCoeff[5] = 29;
	pb->ConstCoeff[6] = 30;
	pb->ConstCoeff[7] = 31;
	pb->ConstCoeff[8] = 33;
	pb->ConstCoeff[9] = 14;
	pb->ConstCoeff[10] = 18;
	pb->ConstCoeff[11] = 100;
}


void SSFree_DataStructures(SS *pb)
{
	/* Solution's Pool */
	SSFree_int_matrix(pb->DivSol,pb->NDivSol);
	SSFree_int_matrix(pb->pool,4*pb->rs->b*pb->rs->b);

	/* Reference Set */
	SSFree_int_matrix(pb->rs->sol,pb->rs->b);
	free(pb->rs->ObjVal+1);
	free(pb->rs->order+1);
	free(pb->rs->iter+1);
	free(pb->rs);

	/* Diverse Set */
	SSFree_int_matrix(pb->p->sol,pb->p->PSize);
	free(pb->p->ObjVal+1);
	free(pb->p);

	/* Profit and Constraint Coefficients */
	free(pb->ObjCoeff+1);
	free(pb->ConstCoeff+1);

	free(pb);
}

int **SSInt_matrix(int nrows,int ncolumns)
/* Allocate an int matrix with "nrows" rows and "ncolumns" columns */
{
	int i,**aux;

	aux = (int**)calloc(nrows,sizeof(int*));
	if(!aux) SSAbort("Memory allocation problem: SSint_matrix");

	aux--;
	for(i=1;i<=nrows;i++)
		aux[i] = SSInt_array(ncolumns);

	return aux;
}

double **SSDouble_matrix(int nrows,int ncolumns)
/* Allocate a double matrix with "nrows" rows and "ncolumns" columns */
{
	double **aux;
	int i;

	aux = (double**)calloc(nrows,sizeof(double*));
	if(!aux) SSAbort("Memory allocation problem: SSdouble_matrix");

	aux--;
	for(i=1;i<=nrows;i++)
		aux[i] = SSDouble_array(ncolumns);
		
	return aux;
}

double *SSDouble_array(int size)
/* Allocate a double array from 1 to size */
{
	double *aux;

	aux = (double*)calloc(size,sizeof(double));
	if(!aux) SSAbort("Memory allocation problem: SSdouble_array");
	return aux-1;
}

int *SSInt_array(int size)
/* Allocate an int array from 1 to size */
{
	int *aux;

	aux = (int*)calloc(size,sizeof(int));
	if(!aux) SSAbort("Memory allocation problem: SSint_array");
	return aux-1;
}

void SSFree_double_matrix(double **matrix,int nrows)
/* Free a double matrix allocated with SSdouble_matrix */
{
	int i;

	for(i=1;i<=nrows;i++)
		free(matrix[i]+1);
	free(matrix+1);
}

void SSFree_int_matrix(int **matrix,int nrows)
/* Free an int matrix allocated with SSint_matrix */
{
	int i;

	for(i=1;i<=nrows;i++)
		free(matrix[i]+1);
	free(matrix+1);
}




