/***********************************
 *								   *
 *	Scatter Search C code		   *	
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *	
 *								   *	
 ***********************************/

#include "SS2.h"

void SSCreate_P(SS *pb)
/* Creates a set P of PSize different solutions */
{
	int obj_val,*sol,currentPSize,j,equal,DivSolCount;

	sol	= SSInt_array(pb->nvar);

	SSGenerate_Sols(pb);	
	if(pb->CDivSol < pb->p->PSize)
		SSAbort("Reduce the PSize value");

	DivSolCount=currentPSize=1;
	while(currentPSize<=pb->p->PSize &&
		  DivSolCount<=pb->CDivSol)
	{
		obj_val = sol_value(pb,pb->DivSol[DivSolCount]);
		SSImprove_solution(pb,pb->DivSol[DivSolCount],&obj_val);

		/* Check if sol is a new one */
		j=1;equal=0;
		while(j<currentPSize && !equal)
			equal=SSEqualSol(pb->DivSol[DivSolCount],pb->p->sol[j++],pb->nvar);

		/* Add solution to set P */
		if(!equal)
		{
			for(j=1;j<=pb->nvar;j++)
				pb->p->sol[currentPSize][j] = pb->DivSol[DivSolCount][j];
			pb->p->ObjVal[currentPSize++] = obj_val;
		}
		DivSolCount++;
	}
	if(currentPSize<pb->p->PSize)
		SSAbort("Reduce the PSize value");

	free(sol+1);
}

void SSGenerate_Sols(SS *pb)
{
	int MaxSol,max_h,max_q,max_k;
	int h,q,k,iter=0,*sol,*seed;

	sol  = SSInt_array(pb->nvar);
	seed = SSInt_array(pb->nvar);

	MaxSol		= pb->NDivSol;
	max_h		= pb->nvar-1;
	pb->CDivSol = 0;

	for(k=1;k<=pb->nvar;k++) sol[k]=0;
	SSTryAddSolDivSet(pb,sol);

	while(iter++<2  &&  pb->CDivSol<=MaxSol)
	{
		/* Seed with the last solution */
		for(k=1;k<=pb->nvar;k++)
			seed[k]=sol[k];
	
		h=2;
		while(h<=max_h && pb->CDivSol<=MaxSol)
		{
			q=1;max_q=h;
			while(q<=max_q && pb->CDivSol<MaxSol-1)
			{
				for(k=1;k<=pb->nvar;k++)
					sol[k]=seed[k];

				max_k=(int)(pb->nvar-q)/h;
				for(k=0;k<=max_k;k++)
					sol[q+k*h]=1-seed[q+k*h];

				/* Add solution and its complement */
				SSTryAddSolDivSet(pb,sol);
				q++;
			}
			h++;
		}
	}
	free(sol+1);free(seed+1);
}


void SSTryAddSolDivSet(SS *pb,int sol[])
/* Try to add sol to the Div Set and its
   complementary solution if they are not
   already present. */
{
	int k;

	if(!SSIsInDivSet(pb,sol))
	{
		pb->CDivSol++;
		for(k=1;k<=pb->nvar;k++)
			pb->DivSol[pb->CDivSol][k]=sol[k];
	}
	
	for(k=1;k<=pb->nvar;k++) sol[k]=1-sol[k];
	if(!SSIsInDivSet(pb,sol))
	{
		pb->CDivSol++;
		for(k=1;k<=pb->nvar;k++)
			pb->DivSol[pb->CDivSol][k]=sol[k];
	}	
}

void SSPrint_P(SS *pb)
{
	FILE *pf;
	int i,j;

	pf=fopen("setP2.txt","w");
	if(!pf) SSAbort("File opening failure");

	for(i=1;i<=pb->p->PSize;i++)
	{
		fprintf(pf,"\n%2d:",i);
		fprintf(pf,"  %d",pb->p->ObjVal[i]);
		for(j=1;j<=pb->nvar;j++)
			fprintf(pf," %d",pb->p->sol[i][j]);
	}
	fclose(pf);
}




