/***********************************
 *								   *
 *	Scatter Search C code		   *
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *
 *								   *
 ***********************************/

#include "SS3.h"

int main(void)
{
	SS *pb;				/* Pointer problem				*/
	int b       =  10;	/* Size of Reference Set		*/
	int PSize   = 100;	/* Size of P					*/
	int Iter    =   1;	/* Number of Current Iteration	*/
	int MaxIter =  50;  /* Maximum number of iterations */
	int *sol,value,i;

	pb = SSProblem_Definition("example_lop",b,PSize);

	SSCreate_P(pb);
	SSCreate_RefSet(pb);

	for(Iter=1; Iter<MaxIter; Iter++)
	{
		if(pb->rs->NewSolutions)
			SSUpdate_RefSet(pb);
		else
			SSRebuild_RefSet(pb);
	}

	/* Print Best Solution Found */
	sol	= SSInt_array(pb->nvar);
	SSBestSol(pb,sol,&value);
	printf("\n\nBest Solution Found:\nValue = %d\n",value);
	for(i=1;i<=pb->nvar;i++) printf("x[%2d] = %d\n",i,sol[i]);
	free(sol+1);

	SSFree_DataStructures(pb);
	return 0;
}

int sol_value(SS *pb,int sol[])
{
	int i,j,value=0;                                      
	
	for(i=1;i<pb->nvar;i++)
	for(j=i+1;j<=pb->nvar;j++)
		value += pb->data[sol[i]][sol[j]];
	
	return value;
}