/***********************************
 *								   *
 *	Scatter Search C code		   *
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *
 *								   *
 ***********************************/

#include "SS3g.h"

void SSImprove_solution(SS *pb,int sol[],int *value)
{
	int i,j,a,inc,current_pos,new_pos;
	int MaxInt=100,Iter,NonImproveIter=0;
	int *best_sol,*sol_inv,best_value,Sum=0;
	int *tabu,tenure=10;

	best_sol=SSInt_array(pb->nvar);
	tabu=SSInt_array(pb->nvar);
	sol_inv=SSInt_array(pb->nvar);
	for(i=1;i<=pb->nvar;i++)
		sol_inv[sol[i]]=i;

	/* Initialize Best Solution */
	best_value=*value;
	for(i=1;i<=pb->nvar;i++)
		best_sol[i]=sol[i];

	for(i=1;i<=pb->nvar;i++)
		Sum+=pb->row_sum[i];

	Iter=tenure+1;
	while(NonImproveIter <= MaxInt)
	{
		Iter++;

		/* Select a sector j according to row_sum */
		a=SSGetrandom(0,Sum);
		j=1;
		while(a>pb->row_sum[j])
			a-=pb->row_sum[j++];

		/* Check tabu status */
		if(Iter-tabu[j]>tenure)
		{
			/* Perform a move */
			current_pos=sol_inv[j];
			inc = SSFirst_Insert(pb,sol,current_pos,&new_pos);
			SSPerform_Move(sol,sol_inv,current_pos,new_pos);	
			*value += inc;
			tabu[j]=Iter;

			if(*value>best_value)
			{
				NonImproveIter=0;
				best_value=*value;
				for(i=1;i<=pb->nvar;i++)
					best_sol[i]=sol[i];
			}
			else
				NonImproveIter++;
		}
	}

	/* Copy best solution found */
	*value=best_value;
	for(i=1;i<=pb->nvar;i++)
		sol[i]=best_sol[i];

	SSLocalSearch(pb,sol,value);

	free(best_sol+1);free(tabu+1);
} 

void SSLocalSearch(SS *pb,int sol[],int *value)
{
	int i,j,inc,old_value,current_pos,new_pos;
	int *order,*sol_inv; /* sol[i]=j <--> sol_inv[j]=i */

	sol_inv=SSInt_array(pb->nvar);
	for(i=1;i<=pb->nvar;i++)
		sol_inv[sol[i]]=i;

	/* Order sectors according to row_sum */
	order = SSOrder_i(pb->row_sum,pb->nvar,1);

   	do{  
    	old_value = *value;
		for(i=1;i<=pb->nvar;i++)
		{
			j=order[i];
			current_pos=sol_inv[j];
			inc = SSFirst_Insert(pb,sol,current_pos,&new_pos);
			if(inc > 0) {
				SSPerform_Move(sol,sol_inv,current_pos,new_pos);
				*value += inc; 
			}

		}
	} while(*value > old_value);

	free(order+1);free(sol_inv+1);
} 

int SSFirst_Insert(SS *pb,int sol[],int i,int *position)
{
/*  Search for the best position to insert i */

	int k,best_inc,inc;
	
	/* Initialize best_inc */
	if(i>2) {
		best_inc  = pb->data_dif[sol[i]][sol[i-1]]; 
		*position = i-1;         
	}
	else {
	 	best_inc  = pb->data_dif[sol[i+1]][sol[i]]; 
		*position = i+1;   
	}

	if(best_inc>0) return best_inc;

	/* Insert i in a previous position */
	inc=0;
	for(k=i-1;k>=1;k--)
	{
		inc += pb->data_dif[sol[i]][sol[k]];                  
		if(inc > best_inc)
		{
			best_inc = inc;
	        *position = k;
			if(best_inc>0) return best_inc;

	    }
	}
	
	/* Insert i in a posterior position */
	inc=0; 	                  
	for(k=i+1;k<=pb->nvar;k++)
	{
		inc += pb->data_dif[sol[k]][sol[i]];   	
	    if(inc > best_inc)
	    {
	    	best_inc  = inc;
	        *position = k;
			if(best_inc>0) return best_inc;
	    }
	}  
	
	return best_inc;
} 

void SSPerform_Move(int sol[],int invsol[],int i,int position)
{
/* Insert element i in position */

	int k,a;
		
	if(position>i) 
	{   
	    a=sol[i];       
		for(k=i; k<position ; k++) 
		{
			sol[k]=sol[k+1];
			invsol[sol[k]]=k;
		}
		sol[position]=a;
		invsol[a]=position;
	}		
	else
	{	
		a=sol[i];  
	    for(k=i;k>position;k--) 
		{
	    	sol[k]=sol[k-1];            
			invsol[sol[k]]=k;
		}
	    sol[position]=a;
		invsol[a]=position;
	}
}
