/***********************************
 *								   *
 *	Scatter Search C code		   *	
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *	
 *								   *	
 ***********************************/

#include "SS3g.h"

void SSCreate_P(SS *pb)
/* Creates a set P of PSize different solutions */
{
	int j,currentPSize,equal,fails;
	int *sol,obj_val,hash_val;

	sol	= SSInt_array(pb->nvar);

	currentPSize=1;fails=0;
	while(currentPSize<=pb->p->PSize && fails<500)
	{
		SSGenerate_Sol(pb,sol);
		obj_val = sol_value(pb,sol);

		SSImprove_solution(pb,sol,&obj_val);
		hash_val=SSHashValue(sol,pb->nvar);

		/* Check if sol is a new one */
		j=1;equal=0;
		while(j<currentPSize && !equal)
			equal=SSEqualSol(sol,obj_val,hash_val,pb->p->sol[j],pb->p->ObjVal[j],pb->p->HashVal[j++],pb->nvar);

		/* Add solution to set P */
		if(!equal)
		{
			for(j=1;j<=pb->nvar;j++)
				pb->p->sol[currentPSize][j] = sol[j];
			pb->p->ObjVal[currentPSize] = obj_val;
			pb->p->HashVal[currentPSize++] = hash_val;

		}
		else fails++;
	}

	if(currentPSize<pb->p->PSize)
		SSAbort("Reduce the PSize value");

	free(sol+1);
}

void SSGenerate_Sol(SS *pb,int sol[])
{
	int i,j,a=1,*assigned,*row_s,*col_s;
	double *weight,max_weight,beta=0.3;	
	
	assigned = SSInt_array(pb->nvar);
	row_s	 = SSInt_array(pb->nvar);
	col_s	 = SSInt_array(pb->nvar);
	weight   = SSDouble_array(pb->nvar);

	/* Initialize rows and cols sums */
	for(i=1;i<=pb->nvar;i++)
	{
		row_s[i] = pb->row_sum[i];
		col_s[i] = pb->col_sum[i];
	}

	for(j=1;j<=pb->nvar;j++)
	{   
		/* Compute (adapt) weights */
		max_weight=-MAXPOSITIVE;
		for(i=1;i<=pb->nvar;i++)
		{
			if(col_s[i]==0) weight[i]=row_s[i];
			else weight[i]=(double)row_s[i]/(double)col_s[i];
			if(!assigned[i] && weight[i]>max_weight)
				max_weight=weight[i];	
		}
		for(i=1;i<=pb->nvar;i++)
			weight[i] -=  beta * (max_weight/(double)pb->Maxfreq)*pb->freq[i][j];

		/* Maximum weight of non-assigned sectors */
		max_weight=-MAXPOSITIVE;
		for(i=1;i<=pb->nvar;i++)  
			if(!assigned[i] && weight[i]>max_weight)
			{
				a=i;
				max_weight=weight[i];	
			}
    
	    /* Assign the element */          
	    assigned[a]=1;
	    sol[j]=a;  

		/* Adapt weights */
		for(i=1;i<=pb->nvar;i++) 
     	{
     	 	row_s[i] -= pb->data[i][a];
     	 	col_s[i] -= pb->data[a][i];
        }
	}      

	/* Update frequencies and their maximum */
	for(i=1;i<=pb->nvar;i++)
		if(++pb->freq[sol[i]][i] > pb->Maxfreq )
			pb->Maxfreq = pb->freq[sol[i]][i];

	free(row_s+1);free(col_s+1);free(weight+1);free(assigned+1);
}

void SSPrint_P(SS *pb)
{
	FILE *pf;
	int i,j;

	pf=fopen("setP3.txt","w");
	if(!pf) SSAbort("File opening failure");

	for(i=1;i<=pb->p->PSize;i++)
	{
		fprintf(pf,"\n%2d ",i);
		fprintf(pf,"  %d",pb->p->ObjVal[i]);
		for(j=1;j<=pb->nvar;j++)
			fprintf(pf," %d",pb->p->sol[i][j]);
	}
	fclose(pf);
}





