/***********************************
 *								   *
 *	Scatter Search C code		   *
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *
 *								   *
 ***********************************/

#include "SS3g.h"

void SSCreate_RefSet(SS *pb)
{
	int b1,i,j,a,num,th_dist=10;
	int *p_order,*rs_order,*min_dist;

	/* Order solutions in P */
	p_order = SSOrder_i(pb->p->ObjVal,pb->p->PSize,1);

	/* Add the b1 best solutions in P to RefSet */
	b1 = pb->rs->b / 2;
	i=num=0;
	while(num<b1)
	{
		i++;
		if(i>pb->p->PSize)
			SSAbort("Reduce the Diversity Test Value");

		/* Minimum diversity test */
		if(	num==0 || SSDist_RefSet(pb,num,pb->p->sol[p_order[i]])>=th_dist)
		{
			num++;
			for(j=1;j<=pb->nvar;j++)
				pb->rs->sol[num][j]=pb->p->sol[p_order[i]][j];
			pb->rs->ObjVal[num]=pb->p->ObjVal[p_order[i]];
			pb->rs->HashVal[num]=pb->p->HashVal[p_order[i]];
			pb->rs->iter[num]=1;
		}
	}

	/* Compute minimum distances from P to RefSet */
	min_dist = SSInt_array(pb->p->PSize);	
	for(i=1;i<=pb->p->PSize;i++)
		min_dist[i]= SSDist_RefSet(pb,b1,pb->p->sol[i]);

	/* Add the diverse b-b1 solutions to RefSet */
	for(i=b1+1;i<=pb->rs->b;i++)
	{
		a=SSMax_dist_index(pb,min_dist);

		for(j=1;j<=pb->nvar;j++)
			pb->rs->sol[i][j] = pb->p->sol[a][j];
		pb->rs->ObjVal[i] = pb->p->ObjVal[a];
		pb->rs->HashVal[i] = pb->p->HashVal[a];
		pb->rs->iter[i]   = 1;

		SSUpdate_distances(pb,min_dist,i);
	}

	/* Compute the order in RefSet */
	rs_order = SSOrder_i(pb->rs->ObjVal,pb->rs->b,1);
	for(i=1;i<=pb->rs->b;i++)	
		pb->rs->order[i] = rs_order[i];

	pb->rs->NewSolutions = 1;
	pb->CurrentIter      = 1;

	free(rs_order+1);free(p_order+1);free(min_dist+1);
}

void SSRebuild_RefSet(SS *pb)
{	
	int *min_dist;
	int b1,i,j,a,index,*rs_order;

	b1 = pb->rs->b / 2;

	/* Create a new set P */
	SSCreate_P(pb);

	/* Compute minimum distances from P to RefSet */
	min_dist = SSInt_array(pb->p->PSize);	
	for(i=1;i<=pb->p->PSize;i++)
		min_dist[i]= SSDist_RefSet(pb,b1,pb->p->sol[i]);
	
	/* Add the diverse b-b1 solutions to RefSet
	   (remove the worst b1 sols. in Refset) */
	for(i=b1+1;i<=pb->rs->b;i++)
	{
		a=SSMax_dist_index(pb,min_dist);
		index = pb->rs->order[i];

		for(j=1;j<=pb->nvar;j++)
			pb->rs->sol[index][j] = pb->p->sol[a][j];
		pb->rs->ObjVal[index] = pb->p->ObjVal[a];
		pb->rs->HashVal[index] = pb->p->HashVal[a];
		pb->rs->iter[index] = pb->CurrentIter;

		SSUpdate_distances(pb,min_dist,index);
	}

	/* Compute the order in RefSet */
	rs_order = SSOrder_i(pb->rs->ObjVal,pb->rs->b,1);
	for(i=1;i<=pb->rs->b;i++)	
		pb->rs->order[i] = rs_order[i];

	pb->rs->NewSolutions = 1;

	free(min_dist+1);free(rs_order+1);
}

void SSUpdate_RefSet(SS *pb)
{
	int a,value,hash;

	pb->rs->NewSolutions=0;
	SSCombine_RefSet(pb);
	pb->CurrentIter++;

	for(a=1;a<=pb->pool_size;a++)
	{
		value=sol_value(pb,pb->pool[a]);
		SSImprove_solution(pb,pb->pool[a],&value);
		hash=SSHashValue(pb->pool[a],pb->nvar);
		SSTryAdd_RefSet(pb,pb->pool[a],value,hash);
	}

	pb->pool_size=0;
}

void SSCombine_RefSet(SS *pb)
{
	int i,j,s;
	int *newsol;

	newsol = SSInt_array(pb->nvar);

	/* Combine elements in RefSet */
	for(i=1;i<pb->rs->b;i++)
	for(j=i+1;j<=pb->rs->b;j++)
	{
		/* Combine solutions not previously combined */
		if(pb->rs->iter[i] == pb->CurrentIter ||
		   pb->rs->iter[j] == pb->CurrentIter)
		{
			SSCombine(pb,pb->rs->sol[i],pb->rs->sol[j],pb->rs->ObjVal[i],pb->rs->ObjVal[j],newsol);
			pb->pool_size++;
			for(s=1;s<=pb->nvar;s++)
				pb->pool[pb->pool_size][s]=newsol[s];
		}
	}

	free(newsol+1);
}

void SSTryAdd_RefSet(SS *pb,int sol[],int value,int hash)
/* If solution sol qualifies, it is added to RefSet 
   (the worst one is replaced) */
{
	int i,j,worst_index;

	worst_index=pb->rs->order[pb->rs->b];
	if(!SSIsInRefSet(pb,sol,value,hash) && value>pb->rs->ObjVal[worst_index])
	{
		/* Find position i for sol. insertion */
		i=pb->rs->b;
		while(i>=1 && value>pb->rs->ObjVal[pb->rs->order[i]])
			i--;
		i++;

		/* Replace solution */
		for(j=1;j<=pb->nvar;j++)
			pb->rs->sol[worst_index][j]=sol[j];
		pb->rs->ObjVal[worst_index]=value;
		pb->rs->HashVal[worst_index]=hash;
		pb->rs->iter[worst_index]=pb->CurrentIter;

		/* Update ReSet order */
		for(j=pb->rs->b;j>i;j--)
			pb->rs->order[j]=pb->rs->order[j-1];
		pb->rs->order[i]=worst_index;

		pb->rs->NewSolutions=1;
	}
}

void SSCombine(SS *pb,int sol1[],int sol2[],int value1,int value2,int newsol[])
{
	int i,a;
	int i1=1;		/* Index in sol1 of its incipient element */
	int i2=1;		/* Index in sol2 of its incipient element */
	int v1,v2;		/* Votes of sol1[i1] and sol2[i2] respect.*/
	int *assign;	/* Assigned elements					  */

	assign = SSInt_array(pb->nvar);
	for(i=1;i<=pb->nvar;i++)
	{
		if(i1>pb->nvar) a=sol2[i2];
		else if (i2>pb->nvar) a=sol1[i1];
		else
		{
			v1 = 1 + i - i1;
			v2 = 1 + i - i2;

			if(v1>v2)				a=sol1[i1];
			else if(v2>v1)			a=sol2[i2];
			else if(value1>value2)	a=sol1[i1];
			else					a=sol2[i2];
		}
		assign[a]=1;
		newsol[i]=a;

		while(i1<=pb->nvar && assign[sol1[i1]]) i1++;
		while(i2<=pb->nvar && assign[sol2[i2]]) i2++;
	}
	free(assign+1);
}

void SSPrint_RefSet(SS *pb)
{
	FILE *pf;
	int i,j;

	pf=fopen("RefSet3.txt","w");
	if(!pf) SSAbort("File opening failure");

	for(i=1;i<=pb->rs->b;i++)
	{
		fprintf(pf,"\n%2d ",i);
		fprintf(pf,"  %d    ",pb->rs->ObjVal[pb->rs->order[i]]);
		for(j=1;j<=pb->nvar;j++)
			fprintf(pf," %d",pb->rs->sol[pb->rs->order[i]][j]);
	}
	fclose(pf);
}



