/***********************************
 *								   *
 *	Scatter Search C code		   *	
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *	
 *								   *	
 ***********************************/

#ifndef SS_H
#define SS_H

#include "stdio.h"
#include "stdlib.h"
#include "malloc.h"
#include "math.h"
#include "string.h"

typedef struct REFSET
{
	int		b;				/* Size									*/
	int		**sol;			/* Solutions							*/ 
	int     *ObjVal;		/* Objective value of solutions			*/
	int		*order;			/* Order of solutions 					*/
	int		*iter;			/* Input iteration number of solutions	*/
	int		NewSolutions;	/* =1 if a new elements has been added	*/

} REFSET;

typedef struct P
{
	int		PSize;		/* Size of the Set P				  */
	int		**sol;		/* Solutions in the Set				  */ 
	int     *ObjVal;	/* Objective value of sols. 		  */

} P;

typedef struct SS
{
	int		nvar;		 /* Number of variables of the problem	 */
	int		CurrentIter; /* Number of Current Iteration			 */
	int		**pool;		 /* Combined solutions					 */
	int     pool_size;   /* Number of elements in pool			 */

	int		**data;		 /* Data Matrix							 */
	int		*row_sum;	 /* Sum of the elements in each data row */
	int     **data_dif;
	REFSET  *rs;
	P		*p;

} SS;

/* Definitions */
#define SSGetrandom(min,max)	(int)( (SSRandNum()*(max+1-min)) + (min))
#define MAXPOSITIVE				10000000

/* User defined function */
int		sol_value(SS *pb,int sol[]);

/* Functions in file SSMemory3.c */
double	*SSDouble_array(int size);
double	**SSDouble_matrix(int nrows,int ncolumns);
void	SSFree_DataStructures(SS *pb);
void	SSFree_double_matrix(double **matrix,int nrows);
void	SSFree_int_matrix(int **matrix,int nrows);
int		*SSInt_array(int size);
int		**SSInt_matrix(int nrows,int ncolumns);
SS		*SSProblem_Definition(char *filename,int b,int PSize);
int		**SSReadData(char *file,SS *pb);

/* Functions in file SSRefSet3.c */
void	SSCombine_RefSet(SS *pb);
int		SSCompute_Insert(SS *pb,int sol[],int i,int new_p);
void	SSCreate_RefSet(SS *pb);
void	SSPath_Relinking(SS *pb,int sol1[],int sol2[],int value1,int newsol[]);
void	SSPrint_RefSet(SS *pb);
void	SSRebuild_RefSet(SS *pb);
void	SSTryAdd_RefSet(SS *pb,int sol[],int value);
void	SSUpdate_RefSet(SS *pb);

/* Functions in file SSP3.c */
void	SSCreate_P(SS *pb);
void	SSGenerate_Sol(SS *pb,int sol[]);
void	SSPrint_P(SS *pb);

/* Functions in file SSImprove3.c */
int		SSFirst_Insert(SS *pb,int sol[],int i,int *position);
void	SSImprove_solution(SS *pb,int sol[],int *value);
void	SSPerform_Move(int sol[],int invsol[],int i,int position);

/* Functions in file SSTools3.c */
void	SSAbort(char texto[]);
void    SSBestSol(SS *pb,int sol[],int *value);
int		SSDist_RefSet(SS *pb,int num,int sol[]);
int		SSEqualSol(int sol1[],int sol2[],int dim);
int		SSIsInRefSet(SS *pb,int sol[]);
int		SSMax_dist_index(SS *pb,int dist[]);
int		*SSOrder_d(double weights[],int num,int type);
int		*SSOrder_i(int weights[],int num,int type);
float	SSRandNum(void);
void    SSUpdate_distances(SS *pb,int min_dist[],int rs_index);

#endif  /* SS_H */