/***********************************
 *								   *
 *	Scatter Search C code		   *	
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *	
 *								   *	
 ***********************************/

#include "PR.h"

SS *SSProblem_Definition(char *filename,int b,int PSize)
{
	int i,j;
	SS *pb;

	pb = (SS*) calloc(1,sizeof(SS));
    if(!pb) SSAbort("Memory allocation problem: SS");
	pb->CurrentIter = 0;

	/* Read Data and Compute difs. ad row_sum */
	pb->data = SSReadData(filename,pb);

	pb->data_dif=SSInt_matrix(pb->nvar,pb->nvar);
	for(i=1;i<=pb->nvar;i++)
	for(j=1;j<=pb->nvar;j++)
		pb->data_dif[i][j] = pb->data[i][j]-pb->data[j][i];
	
	pb->row_sum = SSInt_array(pb->nvar);
	for(i=1;i<=pb->nvar;i++)
	for(j=1;j<=pb->nvar;j++)
		pb->row_sum[i] += pb->data[i][j];

	/* Diverse Set */
	pb->p = (P*) calloc(1,sizeof(P));
    if(!pb->p) SSAbort("Memory allocation problem: P");

	pb->p->PSize  = PSize;
	pb->p->sol    = SSInt_matrix(PSize,pb->nvar);
	pb->p->ObjVal = SSInt_array(PSize);

	/* Reference Set */
	pb->rs = (REFSET*) calloc(1,sizeof(REFSET));
    if(!pb->rs) SSAbort("Memory allocation problem: REFSET");

	pb->rs->b	   = b;
	pb->rs->sol    = SSInt_matrix(b,pb->nvar);
	pb->rs->ObjVal = SSInt_array(b);
	pb->rs->order  = SSInt_array(b);
	pb->rs->iter   = SSInt_array(b);

	/* Solutions' Pool */
	pb->pool	= SSInt_matrix(4*b*b,pb->nvar);

	return pb;
}

int **SSReadData(char *file,SS *pb)
{
	FILE *pf;
	int mod,i,j,**data;
	
	if((pf=fopen(file,"r"))==NULL)
	    SSAbort("\nFile not found");

	/* Read the comment at the beginning of file */ 
	while(fgetc(pf)!='\n');      

	fscanf(pf,"%d\n",&(pb->nvar));
	data=SSInt_matrix(pb->nvar,pb->nvar);
		
	/* Two different data formats:
	   10 columns for 50x50 and 60x60 matrices,
	    6 columns for 44x44 and 56x56 matrices */
		
	if(pb->nvar%10==0)	mod=10;
	else 				mod=6;

	for(i=1 ; i<=pb->nvar ; i++)
	for(j=1 ; j<=pb->nvar ; j++)
	{
		if(i*j%mod== 1)	fscanf(pf,"\n");      
	    fscanf(pf,"%d",&data[i][j]);
	}	
	fclose(pf);
	    
	return data;
}  

void SSFree_DataStructures(SS *pb)
{
	/* Solution's Pool */
	SSFree_int_matrix(pb->pool,4*pb->rs->b*pb->rs->b);

	/* Reference Set */
	SSFree_int_matrix(pb->rs->sol,pb->rs->b);
	free(pb->rs->ObjVal+1);
	free(pb->rs->order+1);
	free(pb->rs->iter+1);
	free(pb->rs);

	/* Diverse Set */
	SSFree_int_matrix(pb->p->sol,pb->p->PSize);
	free(pb->p->ObjVal+1);
	free(pb->p);

	/* Data */
	SSFree_int_matrix(pb->data,pb->nvar);
	SSFree_int_matrix(pb->data_dif,pb->nvar);
	free(pb->row_sum+1);

	free(pb);
}

int **SSInt_matrix(int nrows,int ncolumns)
/* Allocate an int matrix with "nrows" rows and "ncolumns" columns */
{
	int i,**aux;

	aux = (int**)calloc(nrows,sizeof(int*));
	if(!aux) SSAbort("Memory allocation problem: SSint_matrix");

	aux--;
	for(i=1;i<=nrows;i++)
		aux[i] = SSInt_array(ncolumns);

	return aux;
}

double **SSDouble_matrix(int nrows,int ncolumns)
/* Allocate a double matrix with "nrows" rows and "ncolumns" columns */
{
	double **aux;
	int i;

	aux = (double**)calloc(nrows,sizeof(double*));
	if(!aux) SSAbort("Memory allocation problem: SSdouble_matrix");

	aux--;
	for(i=1;i<=nrows;i++)
		aux[i] = SSDouble_array(ncolumns);
		
	return aux;
}

double *SSDouble_array(int size)
/* Allocate a double array from 1 to size */
{
	double *aux;

	aux = (double*)calloc(size,sizeof(double));
	if(!aux) SSAbort("Memory allocation problem: SSdouble_array");
	return aux-1;
}

int *SSInt_array(int size)
/* Allocate an int array from 1 to size */
{
	int *aux;

	aux = (int*)calloc(size,sizeof(int));
	if(!aux) SSAbort("Memory allocation problem: SSint_array");
	return aux-1;
}

void SSFree_double_matrix(double **matrix,int nrows)
/* Free a double matrix allocated with SSdouble_matrix */
{
	int i;

	for(i=1;i<=nrows;i++)
		free(matrix[i]+1);
	free(matrix+1);
}

void SSFree_int_matrix(int **matrix,int nrows)
/* Free an int matrix allocated with SSint_matrix */
{
	int i;

	for(i=1;i<=nrows;i++)
		free(matrix[i]+1);
	free(matrix+1);
}




