/***********************************
 *								   *
 *	Scatter Search C code		   *
 *	Version: 2.0				   *
 *	Authors: M. Laguna & R. Marti  *
 *	Copyright  2002			   *
 *								   *
 ***********************************/

#include "PR.h"

void SSCreate_RefSet(SS *pb)
{
	int b1,i,j,a,*p_order,*rs_order,*min_dist;

	/* Order solutions in P */
	p_order = SSOrder_i(pb->p->ObjVal,pb->p->PSize,1);

	/* Add the b1 best solutions in P to RefSet */
	b1 = pb->rs->b / 2;
	for(i=1;i<=b1;i++)
	{
		for(j=1;j<=pb->nvar;j++)
			pb->rs->sol[i][j] = pb->p->sol[p_order[i]][j];
		pb->rs->ObjVal[i] = pb->p->ObjVal[p_order[i]];
		pb->rs->iter[i]   = 1;
	}

	/* Compute minimum distances from P to RefSet */
	min_dist = SSInt_array(pb->p->PSize);	
	for(i=1;i<=pb->p->PSize;i++)
		min_dist[i]= SSDist_RefSet(pb,b1,pb->p->sol[i]);

	/* Add the diverse b-b1 solutions to RefSet */
	for(i=b1+1;i<=pb->rs->b;i++)
	{
		a=SSMax_dist_index(pb,min_dist);

		for(j=1;j<=pb->nvar;j++)
			pb->rs->sol[i][j] = pb->p->sol[a][j];
		pb->rs->ObjVal[i] = pb->p->ObjVal[a];
		pb->rs->iter[i]   = 1;

		SSUpdate_distances(pb,min_dist,i);
	}

	/* Compute the order in RefSet */
	rs_order = SSOrder_i(pb->rs->ObjVal,pb->rs->b,1);
	for(i=1;i<=pb->rs->b;i++)	
		pb->rs->order[i] = rs_order[i];

	pb->rs->NewSolutions = 1;
	pb->CurrentIter      = 1;

	free(rs_order+1);free(p_order+1);free(min_dist+1);
}

void SSRebuild_RefSet(SS *pb)
{	
	int *min_dist;
	int b1,i,j,a,index,*rs_order;

	b1 = pb->rs->b / 2;

	/* Create a new set P */
	SSCreate_P(pb);

	/* Compute minimum distances from P to RefSet */
	min_dist = SSInt_array(pb->p->PSize);	
	for(i=1;i<=pb->p->PSize;i++)
		min_dist[i]= SSDist_RefSet(pb,b1,pb->p->sol[i]);
	
	/* Add the diverse b-b1 solutions to RefSet
	   (remove the worst b1 sols. in Refset) */
	for(i=b1+1;i<=pb->rs->b;i++)
	{
		a=SSMax_dist_index(pb,min_dist);
		index = pb->rs->order[i];

		for(j=1;j<=pb->nvar;j++)
			pb->rs->sol[index][j] = pb->p->sol[a][j];
		pb->rs->ObjVal[index] = pb->p->ObjVal[a];
		pb->rs->iter[index] = pb->CurrentIter;

		SSUpdate_distances(pb,min_dist,index);
	}

	/* Compute the order in RefSet */
	rs_order = SSOrder_i(pb->rs->ObjVal,pb->rs->b,1);
	for(i=1;i<=pb->rs->b;i++)	
		pb->rs->order[i] = rs_order[i];

	pb->rs->NewSolutions = 1;

	free(min_dist+1);free(rs_order+1);
}

void SSUpdate_RefSet(SS *pb)
{
	int a,value;

	pb->rs->NewSolutions=0;
	SSCombine_RefSet(pb);
	pb->CurrentIter++;

	for(a=1;a<=pb->pool_size;a++)
	{
		value=sol_value(pb,pb->pool[a]);
		SSImprove_solution(pb,pb->pool[a],&value);
		SSTryAdd_RefSet(pb,pb->pool[a],value);
	}

	pb->pool_size=0;
}

void SSCombine_RefSet(SS *pb)
{
	int i,j,s;
	int *newsol;

	newsol = SSInt_array(pb->nvar);

	/* Combine elements in RefSet */
	for(i=1;i<pb->rs->b;i++)
	for(j=i+1;j<=pb->rs->b;j++)
	{
		/* Combine solutions not previously combined */
		if(pb->rs->iter[i] == pb->CurrentIter ||
		   pb->rs->iter[j] == pb->CurrentIter)
		{
			SSPath_Relinking(pb,pb->rs->sol[i],pb->rs->sol[j],pb->rs->ObjVal[i],newsol);
			pb->pool_size++;
			for(s=1;s<=pb->nvar;s++)
				pb->pool[pb->pool_size][s]=newsol[s];
		
			SSPath_Relinking(pb,pb->rs->sol[j],pb->rs->sol[i],pb->rs->ObjVal[j],newsol);
			pb->pool_size++;
			for(s=1;s<=pb->nvar;s++)
				pb->pool[pb->pool_size][s]=newsol[s];
		}
	}
	free(newsol+1);
}

void SSTryAdd_RefSet(SS *pb,int sol[],int value)
/* If solution sol qualifies, it is added to RefSet 
   (the worst one is replaced) */
{
	int i,j,worst_index;

	worst_index=pb->rs->order[pb->rs->b];
	if(!SSIsInRefSet(pb,sol) && value>pb->rs->ObjVal[worst_index])
	{
		/* Find position i for sol. insertion */
		i=pb->rs->b;
		while(i>=1 && value>pb->rs->ObjVal[pb->rs->order[i]])
			i--;
		i++;

		/* Replace solution */
		for(j=1;j<=pb->nvar;j++)
			pb->rs->sol[worst_index][j]=sol[j];
		pb->rs->ObjVal[worst_index]=value;
		pb->rs->iter[worst_index]=pb->CurrentIter;

		/* Update ReSet order */
		for(j=pb->rs->b;j>i;j--)
			pb->rs->order[j]=pb->rs->order[j-1];
		pb->rs->order[i]=worst_index;

		pb->rs->NewSolutions=1;
	}
}

void SSPath_Relinking(SS *pb,int sol1[],int sol2[],int value1,int newsol[])
{
	int i,j,a,pos,*order,new_pos,NumImp=5;
	int best_value,*temp_sol,temp_value;
	int *csol,cvalue;		 /* Current (intermediate) solution */
	int *csol_inv,*sol2_inv; /* sol[i]=j <--> sol_inv[j]=i */
	
	temp_sol = SSInt_array(pb->nvar);

	/* Initialize current and best sol */
	csol = SSInt_array(pb->nvar);
	for(j=1;j<=pb->nvar;j++)
		csol[j]=newsol[j]=sol1[j];
	cvalue=best_value=value1;

	/* Compute the inv. order  */
	sol2_inv  = SSInt_array(pb->nvar);
	for(j=1;j<=pb->nvar;j++)
		sol2_inv[sol2[j]]=j;
	csol_inv  = SSInt_array(pb->nvar);
	for(j=1;j<=pb->nvar;j++)
		csol_inv[csol[j]]=j;
	
	/* Order sectors according to row_sum */
	order = SSOrder_i(pb->row_sum,pb->nvar,1);

	/* Construct a path from sol1 to sol2 */
	while(!SSEqualSol(csol,sol2,pb->nvar))
	{
		for(i=1;i<=pb->nvar;i++)
		{
			a=order[i];
			pos=csol_inv[a];
			new_pos=sol2_inv[a];
			cvalue += SSCompute_Insert(pb,csol,pos,new_pos);
			SSPerform_Move(csol,csol_inv,pos,new_pos);

			/* Update best solution found */
			if(cvalue > best_value)
			{
				best_value=cvalue;
				for(j=1;j<=pb->nvar;j++)
					newsol[j]=csol[j];
			}

			/* Apply a local search improvement */
			if(i % NumImp ==0)
			{
				temp_value=cvalue;
				for(j=1;j<=pb->nvar;j++)
					temp_sol[j]=csol[j];
				SSImprove_solution(pb,temp_sol,&temp_value);

				/* Update best solution found */
				if(temp_value > best_value)
				{
					best_value=temp_value;
					for(j=1;j<=pb->nvar;j++)
						newsol[j]=temp_sol[j];
				}
			}
		}
	}
	free(order+1);free(csol+1);free(temp_sol+1);free(sol2_inv+1);
}

int SSCompute_Insert(SS *pb,int sol[],int i,int new_p)
{
	int k,inc;
	
	if(i==new_p)
		return 0;
	else if(new_p<i)
	{
		/* Insert i in a previous position */
		inc=0;
		for(k=i-1;k>=new_p;k--)
			inc += pb->data_dif[sol[i]][sol[k]];                  
		return inc;
	}
	else
	{
		/* Insert i in a posterior position */
		inc=0; 	                  
		for(k=i+1;k<=new_p;k++)
			inc += pb->data_dif[sol[k]][sol[i]];   	
		return inc;
	}  
} 

void SSPrint_RefSet(SS *pb)
{
	FILE *pf;
	int i,j;

	pf=fopen("RefSet3.txt","w");
	if(!pf) SSAbort("File opening failure");

	for(i=1;i<=pb->rs->b;i++)
	{
		fprintf(pf,"\n%2d ",i);
		fprintf(pf,"  %d    ",pb->rs->ObjVal[pb->rs->order[i]]);
		for(j=1;j<=pb->nvar;j++)
			fprintf(pf," %d",pb->rs->sol[pb->rs->order[i]][j]);
	}
	fclose(pf);
}



