(* Content-type: application/vnd.wolfram.cdf.text *)

(*** Wolfram CDF File ***)
(* http://www.wolfram.com/cdf *)

(* CreatedBy='Mathematica 8.0' *)

(*************************************************************************)
(*                                                                       *)
(*  The Mathematica License under which this file was created prohibits  *)
(*  restricting third parties in receipt of this file from republishing  *)
(*  or redistributing it by any means, including but not limited to      *)
(*  rights management or terms of use, without the express consent of    *)
(*  Wolfram Research, Inc.                                               *)
(*                                                                       *)
(*************************************************************************)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       835,         17]
NotebookDataLength[   3768176,      86967]
NotebookOptionsPosition[   3707591,      85542]
NotebookOutlinePosition[   3708887,      85588]
CellTagsIndexPosition[   3708844,      85585]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[StyleBox["POLIEDROS",
 FontColor->RGBColor[0, 0, 1]]], "Title",
 CellChangeTimes->{{3.538339228281109*^9, 3.538339232833145*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell["Carlos Ivorra", "Text",
 CellChangeTimes->{{3.538339285969895*^9, 3.538339287688696*^9}, {
  3.5383393966979322`*^9, 3.538339399233817*^9}, {3.5383395110348682`*^9, 
  3.538339511037468*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 StyleBox["\[LineSeparator]",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["INTRODUCCI\[CapitalOAcute]N",
  FontSize->24,
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["\[LineSeparator]",
  FontColor->RGBColor[0, 0, 1]]
}], "Section",
 CellChangeTimes->{{3.538496262748913*^9, 3.538496301701696*^9}, {
  3.538507560256893*^9, 3.538507562188425*^9}, {3.556445412565827*^9, 
  3.556445422661458*^9}},
 Hyphenation->False],

Cell["\<\
Este documento interactivo (todav\[IAcute]a en construcci\[OAcute]n) contiene \
algunos resultados sobre poliedros, entre los que se incluyen algunos \
teoremas cl\[AAcute]sicos, como el teorema de Euler, el teorema de Descartes \
o el teorema de rigidez de Cauchy, as\[IAcute] como algunas clasificaciones \
de familias de poliedros, a saber, los poliedros regulares (no necesariamente \
convexos), los deltaedros (poliedros convexos cuyas caras son \
tri\[AAcute]ngulos equil\[AAcute]teros) y los poliedros uniformes, \
as\[IAcute] como una descripci\[OAcute]n detallada de todos \[EAcute]stos y \
tambi\[EAcute]n de la familia de los duales de los poliedros uniformes.\
\>", "Text",
 CellChangeTimes->{{3.5564454084884167`*^9, 3.556445424753159*^9}, {
  3.556445648671979*^9, 3.556445693144721*^9}, {3.556445778377873*^9, 
  3.5564459229231863`*^9}}],

Cell[TextData[{
 "Como se ver\[AAcute], en las descripciones de los poliedros intervienen n\
\[UAcute]meros algebraicos y para simplificar las expresiones que aparecen en \
los c\[AAcute]lculos (sin pasar a aproximaciones decimales) he utilizado el \
procedimiento consistente en usar ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " para calcular el polinomio m\[IAcute]nimo de la expresi\[OAcute]n, luego \
hallar sus ra\[IAcute]ces algebraicamente y elegir entre ellas la que da \
lugar a una expresi\[OAcute]n decimal m\[AAcute]s parecida a la expresi\
\[OAcute]n de partida (lo que nos da la el resultado exacto). He aqu\[IAcute] \
un ejemplo:"
}], "Text",
 CellChangeTimes->{{3.55644596406763*^9, 3.556446072085309*^9}, {
  3.556446135753436*^9, 3.556446239279265*^9}, {3.556448153232078*^9, 
  3.556448157045487*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Dato", "=", 
   FractionBox["1", 
    RowBox[{"3", "+", 
     SqrtBox["5"]}]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Raices", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"MinimalPolynomial", "[", 
     RowBox[{"Dato", ",", "x"}], "]"}], "\[Equal]", "0"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solucion", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"N", "[", 
        RowBox[{"Raices", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "1", ",", "2"}], "]"}], "]"}], "]"}], "\[Equal]", 
       "Dato"}], ",", 
      RowBox[{"Solucion", "=", 
       RowBox[{"Raices", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1", ",", "2"}], "]"}], "]"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "1", ",", 
      RowBox[{"Length", "[", "Raices", "]"}]}], "}"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", "Solucion"}], "Input",
 CellMargins->{{66, 10}, {0, 10}},
 CellChangeTimes->{{3.549534828907042*^9, 3.549534998555221*^9}, {
   3.549535030863316*^9, 3.549535072581699*^9}, 3.549535123114642*^9, {
   3.5495352374457493`*^9, 3.5495352484029913`*^9}, {3.5495353427239523`*^9, 
   3.5495353827003593`*^9}, {3.549535488912732*^9, 3.549535501925968*^9}, {
   3.549535662058063*^9, 3.5495356785124826`*^9}, {3.549535726051353*^9, 
   3.54953573926963*^9}, {3.549535918038389*^9, 3.549535989403892*^9}, {
   3.54953707385401*^9, 3.54953707396742*^9}, {3.549537204387838*^9, 
   3.5495372337545843`*^9}, {3.55350422364043*^9, 3.553504224206511*^9}, {
   3.556447562688571*^9, 3.556447697181005*^9}},
 Background->GrayLevel[0.9]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "-", 
        SqrtBox["5"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        SqrtBox["5"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellMargins->{{66, 10}, {0, 0}},
 CellChangeTimes->{{3.55644766486616*^9, 3.556447690017407*^9}},
 Background->GrayLevel[0.9]],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{"3", "-", 
    SqrtBox["5"]}], ")"}]}]], "Output",
 CellMargins->{{66, 10}, {10, 0}},
 CellChangeTimes->{{3.55644766486616*^9, 3.556447690024064*^9}},
 Background->GrayLevel[0.9]],

Cell["\<\
Y aqu\[IAcute] un bot\[OAcute]n que despliega una ventana que aplica este \
procedimiento:\
\>", "Text",
 CellChangeTimes->{{3.556446092072016*^9, 3.5564460920752296`*^9}, {
  3.556448163143602*^9, 3.556448196352159*^9}}]
}, Open  ]],

Cell[BoxData[
 ButtonBox["\<\"Simplificadora\"\>",
  Appearance->Automatic,
  ButtonFunction:>CreateWindow[
    DialogNotebook[
     DynamicModule[{$CellContext`SimpA = 0, $CellContext`Res = 0}, 
      Deploy[
       Style[
        Panel[
         Grid[
          Transpose[{{"Expresi\[OAcute]n:", 
             Button[
             "Simplificaci\[OAcute]n", 
              If[$CellContext`SimpA == Null, $CellContext`SimpA = 
                0]; $CellContext`SimpB = 
               Solve[MinimalPolynomial[$CellContext`SimpA, $CellContext`x] == 
                 0]; $CellContext`Res = 0; Do[
                If[N[
                   
                   Part[$CellContext`SimpB, $CellContext`i, 1, 
                    2]] == $CellContext`SimpA, $CellContext`Res = 
                 Part[$CellContext`SimpB, $CellContext`i, 1, 
                   2]], {$CellContext`i, 1, 
                 Length[$CellContext`SimpB]}]]}, {
             InputField[
              Dynamic[$CellContext`SimpA]], 
             InputField[
              Dynamic[
               Style[$CellContext`Res, FontFamily -> "Times"]]]}}], Alignment -> 
          Left], ImageMargins -> 10], 
        DefaultOptions -> {
         InputField -> {
           ContinuousAction -> True, 
            FieldSize -> {{30, Infinity}, {1, Infinity}}}}]]]], WindowTitle -> 
    "Simplificadora", WindowFloating -> "True", WindowFrame -> "Palette", 
    Selectable -> False, WindowFrameElements -> {"ResizeArea", "CloseBox"}],
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 CellChangeTimes->{{3.549534847245029*^9, 3.5495348924301662`*^9}, 
   3.549534925346842*^9, {3.549534955544314*^9, 3.549534968608358*^9}, 
   3.5495349992370377`*^9, {3.5495350340628757`*^9, 3.549535072872282*^9}, 
   3.54953512417266*^9, 3.549535249016839*^9, {3.5495353521867456`*^9, 
   3.549535386681452*^9}, 3.549535502916009*^9, 3.549535679126883*^9, {
   3.549535731119235*^9, 3.549535739865003*^9}, {3.549535951616809*^9, 
   3.5495359735621367`*^9}, 3.549536310180574*^9, 3.549536767175634*^9, 
   3.549537074811109*^9, 3.549537234718483*^9, 3.553504226538498*^9, 
   3.553504311156227*^9},
 TextAlignment->Center],

Cell["", "Text"],

Cell[TextData[{
 StyleBox["\[LineSeparator]",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["1. Pol\[IAcute]gonos",
  FontSize->24,
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["\[LineSeparator]",
  FontColor->RGBColor[0, 0, 1]]
}], "Section",
 CellChangeTimes->{{3.538496262748913*^9, 3.538496301701696*^9}, {
  3.538507560256893*^9, 3.538507562188425*^9}},
 Hyphenation->False],

Cell["\<\
Aunque supondremos al lector familiarizado con la geometr\[IAcute]a plana, \
dedicaremos la primera secci\[OAcute]n a revisar los hechos b\[AAcute]sicos \
sobre pol\[IAcute]gonos. Para destacar en la medida de lo posible el \
paralelismo entre los conceptos de pol\[IAcute]gono y poliedro (de modo que, \
en cierta medida, podamos considerar a \[EAcute]ste como el an\[AAcute]logo a \
aqu\[EAcute]l en tres dimensiones), vamos a dar de momento una definici\
\[OAcute]n de pol\[IAcute]gono que se aparta ligeramente de la \
com\[UAcute]nmente aceptada:\
\>", "Text",
 CellMargins->{{12, 10}, {16, 5}},
 CellChangeTimes->{{3.538496310245102*^9, 3.5384963747824183`*^9}, {
  3.5384964141291122`*^9, 3.538496548978312*^9}, {3.538507917394248*^9, 
  3.538507918424756*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Un ",
 StyleBox["pol\[IAcute]gono",
  FontSlant->"Italic"],
 " viene determinado por un conjunto finito de puntos situados en un mismo \
plano, llamados ",
 StyleBox["v\[EAcute]rtices",
  FontSlant->"Italic"],
 " del pol\[IAcute]gono, y un conjunto de segmentos cuyos extremos son v\
\[EAcute]rtices, llamados ",
 StyleBox["lados",
  FontSlant->"Italic"],
 " del pol\[IAcute]gono, de tal modo que cada v\[EAcute]rtice sea el extremo \
de exactamente dos lados, que no han de ser colineales, y se puede pasar \
desde cualquier v\[EAcute]rtice hasta cualquier otro a trav\[EAcute]s de una \
sucesi\[OAcute]n de v\[EAcute]rtices adyacentes. Por v\[EAcute]rtices ",
 StyleBox["adyacentes",
  FontSlant->"Italic"],
 " entendemos dos v\[EAcute]rtices que sean los extremos de un mismo lado, \
mientras que dos lados que tengan un v\[EAcute]rtice en com\[UAcute]n se \
llaman ",
 StyleBox["consecutivos.",
  FontSlant->"Italic"],
 " Un pol\[IAcute]gono es ",
 StyleBox["simple",
  FontSlant->"Italic"],
 " si adem\[AAcute]s cumple que cuando dos de sus lados tienen un punto en \
com\[UAcute]n dicho punto es uno de sus extremos (y, en particular, un v\
\[EAcute]rtice del pol\[IAcute]gono). En caso contrario se dice que es un pol\
\[IAcute]gono ",
 StyleBox["complejo.",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellMargins->{{30, 30}, {3, 5}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
  3.538342563212167*^9, 3.538342641589696*^9}, {3.538477791518964*^9, 
  3.538477806679139*^9}, {3.53849656143301*^9, 3.5384966496577177`*^9}, {
  3.538496697507208*^9, 3.5384967694009666`*^9}, {3.538497015029212*^9, 
  3.538497197509335*^9}},
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell[TextData[{
 "Los pol\[IAcute]gonos de tres lados se llaman ",
 StyleBox["tri\[AAcute]ngulos,",
  FontSlant->"Italic"],
 " los de cuatro ",
 StyleBox["cuadril\[AAcute]teros,",
  FontSlant->"Italic"],
 " y a partir de cinco lados se llaman ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["-\[AAcute]gonos,",
  FontSlant->"Italic"],
 " donde el valor de ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " se indica con el prefijo griego correspondiente: ",
 StyleBox["pent\[AAcute]gonos, hex\[AAcute]gonos, hept\[AAcute]gonos, ",
  FontSlant->"Italic"],
 "etc. Los segmentos que unen dos v\[EAcute]rtices no adyacentes de un pol\
\[IAcute]gono de llaman ",
 StyleBox["diagonales",
  FontSlant->"Italic"],
 " del pol\[IAcute]gono."
}], "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{{3.538497208431759*^9, 3.538497217437051*^9}, {
  3.53849737424261*^9, 3.5384974303090553`*^9}, {3.53849840452321*^9, 
  3.5384984983377132`*^9}, {3.538499235777747*^9, 3.538499255825212*^9}, {
  3.53851562136307*^9, 3.538515656297636*^9}},
 Hyphenation->False],

Cell["\<\
Por ejemplo, de las tres figuras siguientes, la primera es un \
pent\[AAcute]gono simple, la segunda un pent\[AAcute]gono complejo y la \
tercera no es un pol\[IAcute]gono porque no es posible pasar de un \
v\[EAcute]rtice a otro a trav\[EAcute]s de una cadena de v\[EAcute]rtices \
adyacentes. Se trata de la uni\[OAcute]n de dos tri\[AAcute]ngulos.\
\>", "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{{3.538497208431759*^9, 3.538497217437051*^9}, {
   3.53849737424261*^9, 3.5384974303090553`*^9}, 3.53849840452321*^9, {
   3.5384985453255043`*^9, 3.5384985731307*^9}, {3.53850696812182*^9, 
   3.538506969224698*^9}},
 Hyphenation->False],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[1], EdgeForm[GrayLevel[0]], 
    PolygonBox[{{0, 0}, {1, 0}, {2, 1}, {1, 1}, {0, 0.5}}], 
    PolygonBox[{{3, 0}, {3, 1}, {2.5, 0.5}, {4, 0}, {3.75, 0.5}}], 
    PolygonBox[{{5, 0}, {7, 0}, {6, 1}}], 
    PolygonBox[{{5, 0.5}, {7, 0.5}, {5.5, 1}}]}, 
   LineBox[{{5, 0}, {6, 1}, {7, 0}}]},
  ImageSize->{560.4999999999977, Automatic}]], "Figure",
 CellChangeTimes->{
  3.538506594898896*^9, {3.538506690723591*^9, 3.5385067367654963`*^9}, 
   3.5385067694800043`*^9},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "No es dif\[IAcute]cil demostrar que los lados de un pol\[IAcute]gono \
dividen al plano en un n\[UAcute]mero finito de componentes conexas, de las \
cuales s\[OAcute]lo una es no acotada (la que contiene el exterior de una \
circunferencia que contenga a todos los v\[EAcute]rtices del pol\[IAcute]gono \
en su interior). Los puntos de dicha componente conexa se llaman ",
 StyleBox["puntos exteriores",
  FontSlant->"Italic"],
 " del pol\[IAcute]gono, mientras que los puntos de las componentes acotadas \
se llaman ",
 StyleBox["puntos interiores",
  FontSlant->"Italic"],
 " del pol\[IAcute]gono. As\[IAcute], por ejemplo, los puntos interiores de \
los dos pol\[IAcute]gonos de la figura anterior son los que aparecen \
sombreados en la figura siguiente:"
}], "Text",
 CellChangeTimes->{{3.5384986719154177`*^9, 3.5384987037235527`*^9}, {
  3.538498744588129*^9, 3.538498794516595*^9}, {3.538498831613151*^9, 
  3.538498905405856*^9}, {3.538498995950869*^9, 3.5384992134007587`*^9}, {
  3.53849938202722*^9, 3.538499382030345*^9}, {3.538505585334551*^9, 
  3.53850558563054*^9}, {3.53850679091574*^9, 3.538506855487343*^9}, {
  3.538506889817083*^9, 3.5385069063199587`*^9}, {3.538506954042324*^9, 
  3.538506963639271*^9}, {3.5385070004815474`*^9, 3.538507017850374*^9}},
 Hyphenation->False],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0.7], EdgeForm[GrayLevel[0]], 
   PolygonBox[{{0, 0}, {1, 0}, {2, 1}, {1, 1}, {0, 0.5}}], 
   PolygonBox[{{3, 0}, {3, 1}, {2.5, 0.5}, {4, 0}, {3.75, 0.5}}]},
  ImageSize->{470., Automatic}]], "Output",
 CellChangeTimes->{3.53850707525535*^9},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "Nos van a interesar especialmente los pol\[IAcute]gonos simples. Es claro \
que un pol\[IAcute]gono simple es homeomorfo a una circunferencia, y el ",
 StyleBox["teorema de la curva cerrada de Jordan",
  FontSlant->"Italic"],
 " prueba que todo subconjunto del plano homeomorfo a una circunferencia \
divide al plano en exactamente dos componentes conexas, de las cuales es la \
frontera. En particular, el interior de un pol\[IAcute]gono simple ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un subconjunto abierto conexo del plano del cual ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es la frontera. M\[AAcute]s a\[UAcute]n, puede probarse que ",
 StyleBox["P",
  FontSlant->"Italic"],
 " es homeomorfo a un c\[IAcute]rculo (aunque esto no es cierto para curvas \
de Jordan arbitrarias)."
}], "Text",
 CellMargins->{{12, 10}, {16, 4}},
 CellChangeTimes->{{3.538499386602199*^9, 3.538499572036805*^9}, {
  3.538504112147732*^9, 3.538504112153373*^9}},
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Nota:",
  FontWeight->"Bold"],
 " El lector que no est\[EAcute] familiarizado con los resultados topol\
\[OAcute]gicos a los que aludimos no deber\[IAcute]a tener inconveniente en \
aceptarlos como \[OpenCurlyDoubleQuote]intuitivamente evidentes\
\[CloseCurlyDoubleQuote]. Por ejemplo, lo \[UAcute]nico que hemos dicho hasta \
ahora es que, dado un pol\[IAcute]gono y un punto del plano que no est\
\[EAcute] sobre sus lados, o bien est\[AAcute] \
\[OpenCurlyDoubleQuote]encerrado\[CloseCurlyDoubleQuote] por sus lados (y \
entonces es interior), o bien no est\[AAcute] encerrado y podemos movernos \
desde \[EAcute]l hasta cualquier punto arbitrariamente lejano sin cruzar \
ninguno de los lados (en cuyo caso es exterior); cuando afirmamos que todo \
pol\[IAcute]gono simple es homeomorfo a una circunferencia no decimos sino \
que puede ser deformado de forma continua, sin romperlo ni superponer ning\
\[UAcute]n par de puntos, hasta convertirlo en una circunferencia, y entonces \
sus puntos interiores se convierten en los puntos de un c\[IAcute]rculo. La \
figura siguiente ilustra la situaci\[OAcute]n. Es claro que, por muy \
complicado que sea el pol\[IAcute]gono, siempre puede \
\[OpenCurlyDoubleQuote]desenredarse\[CloseCurlyDoubleQuote] hasta que sus \
lados queden listos para ser arqueados y formar una circunferencia. Si no \
fuera simple tendr\[IAcute]amos que separar sus autointersecciones, y eso se \
considera una \[OpenCurlyDoubleQuote]ruptura\[CloseCurlyDoubleQuote]."
}], "Text",
 CellChangeTimes->{{3.5385041122347507`*^9, 3.53850414813131*^9}, {
   3.538504360774118*^9, 3.5385044407821712`*^9}, 3.538505558751603*^9, {
   3.538505608174513*^9, 3.538505654918782*^9}, {3.5385056949997787`*^9, 
   3.538505759481529*^9}, {3.538505806961711*^9, 3.53850585273661*^9}, {
   3.538505885809799*^9, 3.538505964617516*^9}, {3.538506085902528*^9, 
   3.53850618243613*^9}, {3.5385073724798183`*^9, 3.538507372547635*^9}, {
   3.538507468397253*^9, 3.5385074750919523`*^9}, 3.538507741842011*^9},
 TextJustification->1.,
 Hyphenation->False],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`t$$], 0, ""}, 0, 2}}, Typeset`size$$ = {
    360., {177., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`t$10383$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$10383$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> If[$CellContext`t$$ < 1, 
        Graphics[{{
           GrayLevel[1], 
           Circle[{0, 0}]}, {
           GrayLevel[1], 
           EdgeForm[Black], 
           Polygon[{(1 - $CellContext`t$$) {0, 0.5} + $CellContext`t$$ {
                Cos[4 (Pi/6)], 
                Sin[4 (Pi/6)]}, (1 - $CellContext`t$$) {
               0.5, 1} + $CellContext`t$$ {
                Cos[2 (Pi/6)], 
                Sin[2 (Pi/6)]}, {1, 
             0}, (1 - $CellContext`t$$) {-0.3, 0.3} + $CellContext`t$$ {
                Cos[10 (Pi/6)], 
                Sin[10 (Pi/6)]}, (
               1 - $CellContext`t$$) {-0.7, -0.5} + $CellContext`t$$ {
                Cos[8 (Pi/6)], 
                Sin[8 (Pi/6)]}, (1 - $CellContext`t$$) {-1, 
               1} + $CellContext`t$$ {-1, 0}}]}, 
          PlotRange -> {{-1, 1}, {-1, 1}}}], 
        Show[
         Table[
          
          ParametricPlot[($CellContext`t$$ - 
            1 + (2 - $CellContext`t$$) (Sin[2 (Pi/6)]/Sin[
              2 (Pi/3) - $CellContext`u])) {
             Cos[$CellContext`u + (2 Pi) ($CellContext`i/6)], 
             Sin[$CellContext`u + (2 Pi) ($CellContext`i/
                6)]}, {$CellContext`u, 0, 2 (Pi/6)}, PlotStyle -> 
           RGBColor[0, 0, 0]], {$CellContext`i, 0, 5}], 
         PlotRange -> {{-1, 1}, {-1, 1}}, Axes -> None]], 
      "Specifications" :> {{{$CellContext`t$$, 0, ""}, 0, 2, 
         AppearanceElements -> {}}}, "Options" :> {AppearanceElements -> {}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{405., {214., 220.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.539171936043087*^9, 3.5403289574465017`*^9},
 TextAlignment->Center],

Cell["\<\
Hay una clase de pol\[IAcute]gonos especialmente notable:\
\>", "Text",
 CellChangeTimes->{{3.538507776896681*^9, 3.5385077932640123`*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Un pol\[IAcute]gono es ",
 StyleBox["convexo",
  FontSlant->"Italic"],
 " si la recta que prolonga a cada uno de sus lados deja a todo el pol\
\[IAcute]gono en uno de los dos semiplanos que determina."
}], "Text",
 CellMargins->{{30, 30}, {3, 5}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
  3.538342563212167*^9, 3.538342641589696*^9}, {3.538477791518964*^9, 
  3.538477806679139*^9}, {3.53849656143301*^9, 3.5384966496577177`*^9}, {
  3.538496697507208*^9, 3.5384967694009666`*^9}, {3.538497015029212*^9, 
  3.538497197509335*^9}, {3.538507820776568*^9, 3.538507896303946*^9}},
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell[TextData[{
 StyleBox["Teorema 1.1:",
  FontWeight->"Bold",
  FontSlant->"Plain"],
 " ",
 StyleBox["Un pol\[IAcute]gono es convexo si y s\[OAcute]lo si es simple y su \
interior es un abierto convexo en el sentido usual, es decir, tal que si \
contiene a dos puntos contiene tambi\[EAcute]n al segmento que los une.",
  FontSlant->"Italic"]
}], "Text",
 CellMargins->{{12, 24}, {4, 16}},
 CellChangeTimes->{{3.5385078092302513`*^9, 3.538507809231862*^9}, {
  3.538508027243175*^9, 3.5385080761537857`*^9}, {3.538508117538129*^9, 
  3.5385081309236717`*^9}, {3.5385095833801126`*^9, 3.538509593882712*^9}, {
  3.538600954905909*^9, 3.5386009552795153`*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": Sea ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " un pol\[IAcute]gono convexo, para cada uno de sus lados ",
 StyleBox["l,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " sea ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["S", "l"],
    FontFamily->"Times",
    FontSize->18,
    FontSlant->"Italic"], TraditionalForm]]],
 " el semiplano abierto que determina la recta que lo contiene y que contiene \
a ",
 StyleBox["P,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y sea ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " la intersecci\[OAcute]n de dichos semiplanos. Puesto que los semiplanos \
son convexos (en el sentido usual) y la intersecci\[OAcute]n de convexos es \
convexa, tenemos que ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un abierto convexo. Veamos que ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es la frontera de ",
 StyleBox["I.",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " Para ello observamos en primer lugar que la intersecci\[OAcute]n de las \
clausuras de los semiplanos ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["S", "l"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 " (es decir, los correspondientes semiplanos cerrados) es un cerrado que \
contiene a ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " luego la clausura de ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " y en particular su frontera, est\[AAcute]n contenidos en dicha intersecci\
\[OAcute]n."
}], "Text",
 CellChangeTimes->{{3.538508131065311*^9, 3.538508131066758*^9}, {
   3.538508219779613*^9, 3.53850822189851*^9}, 3.538508256716732*^9, {
   3.538508332112483*^9, 3.538508348003789*^9}, {3.538508476613061*^9, 
   3.538508610806892*^9}, {3.53850875853757*^9, 3.5385087664086313`*^9}, {
   3.53850905094971*^9, 3.538509050955024*^9}, {3.5385090901004057`*^9, 
   3.538509101339892*^9}, {3.538509133655287*^9, 3.538509179588949*^9}, {
   3.538553535570861*^9, 3.5385535392137957`*^9}, 3.5389370021080847`*^9},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "As\[IAcute] pues, si un punto ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] en la frontera de ",
 StyleBox["I,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] en las clausuras de todos los semiplanos ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["S", "l"],
    FontFamily->"Times",
    FontSize->18,
    FontSlant->"Italic"], TraditionalForm]]],
 ", y tiene que estar en la frontera de alguno de ellos, pues si estuviera en \
el interior de todos estar\[IAcute]a en ",
 StyleBox["I,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " lo cual es imposible porque ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es abierto. Esto significa que ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] en la recta que prolonga a un lado ",
 StyleBox["l.",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " Ahora bien, si los extremos de ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " son los puntos ",
 StyleBox["p",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["q,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " sabemos que ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] en el semiplano determinado por el lado contiguo a ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " en ",
 StyleBox["q",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " que contiene a ",
 StyleBox["p",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y viceversa, lo cual equivale a que ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] en el segmento de extremos ",
 StyleBox["p",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["q",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " es decir, en ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " luego en ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellChangeTimes->{{3.538509064237102*^9, 3.5385090710433817`*^9}, {
  3.538509181092852*^9, 3.538509237077456*^9}, {3.538509312864653*^9, 
  3.538509326166192*^9}, {3.538509386377708*^9, 3.53850953043182*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "Por otro lado, si ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un lado de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un punto distinto de sus extremos, tenemos que ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] en todos los semiplanos abiertos determinados por los lados \
restantes (pues es f\[AAcute]cil ver que no puede haber dos lados situados \
sobre la misma recta, ya que entonces el lado contiguo a uno de ellos dejar\
\[IAcute]a a cada uno en un semiplano distinto). Por lo tanto, todos los \
puntos de un entorno ",
 StyleBox["U",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute]n en la intersecci\[OAcute]n de los restantes semiplanos \
abiertos y, dado cualquier entorno ",
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " tenemos que ",
 StyleBox["U ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["\[Intersection]",
  FontFamily->"Times"],
 StyleBox[" V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " corta a ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["S", "l"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 ", luego a ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " Esto prueba que ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18],
 " est\[AAcute] en la frontera de ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellChangeTimes->{{3.538509537880188*^9, 3.5385095394880543`*^9}, {
  3.538509575912518*^9, 3.538509661401485*^9}, {3.5385097705794077`*^9, 
  3.538509794826971*^9}, {3.5385098597077503`*^9, 3.538510107678356*^9}, {
  3.538510202137384*^9, 3.538510202143968*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "Con esto hemos probado que ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es la frontera de ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " Notemos ahora que la clausura de ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18],
 " es la intersecci\[OAcute]n de las clausuras de los semiplanos ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["S", "l"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 ", pues una inclusi\[OAcute]n es obvia y, si ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] en la intersecci\[OAcute]n de los semiplanos cerrados, o bien \
est\[AAcute] en la intersecci\[OAcute]n de los semiplanos abiertos, es decir, \
en ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " o bien est\[AAcute] al menos en la frontera de uno de ellos, y bajo esas \
hip\[OAcute]tesis hemos probado m\[AAcute]s arriba que ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] en ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18],
 ", luego en ambos casos est\[AAcute] en la clausura de ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellChangeTimes->{{3.538510370208921*^9, 3.5385106585719843`*^9}, {
  3.53851119933279*^9, 3.5385112118405313`*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "Veamos que ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un conjunto acotado. En efecto, sea ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " una circunferencia que contenga a ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " Como el exterior de ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " no contiene puntos de la frontera de ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " o bien todos sus puntos est\[AAcute]n en ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " o bien ninguno lo est\[AAcute], pero si todos lo estuvieran, por \
convexidad todo el interior de ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " estar\[IAcute]a en ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " lo cual es imposible (pues ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " no est\[AAcute] en ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "), luego ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] contenido en el interior de ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y es, pues, acotado. Por consiguiente, la clausura de ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un convexo compacto, y todo convexo compacto en el plano es homeomorfo \
a un c\[IAcute]rculo, de forma que la frontera (en nuestro caso ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ") es homeomorfa a la circunferencia correspondiente. Esto implica que ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un pol\[IAcute]gono simple."
}], "Text",
 CellChangeTimes->{3.538513600917726*^9},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "El complementario de ",
 StyleBox["I ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["\[Union]",
  FontFamily->"Times"],
 StyleBox[" P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es la uni\[OAcute]n de los semiplanos abiertos complementarios de los ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["S", "l"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 ", luego es un conjunto no acotado. Si probamos que es conexo podremos \
concluir que ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y dicho complementario son las dos \[UAcute]nicas componentes conexas del \
complementario de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " y que ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es la componente acotada, luego es el interior de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellChangeTimes->{{3.538510370208921*^9, 3.5385106585719843`*^9}, {
   3.53851119933279*^9, 3.538511211921948*^9}, 3.5385135977917356`*^9},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "Para probar que el complementario de ",
 StyleBox["I ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["\[Union]",
  FontFamily->"Times"],
 StyleBox[" P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es conexo consideramos una circunferencia que contenga a todos los v\
\[EAcute]rtices de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " en su interior. Hemos visto que est\[AAcute] en dicho complementario. Como \
todo semiplano cuya frontera pase por el interior de la circunferencia \
contiene puntos de la misma, resulta que los semiplanos cuya uni\[OAcute]n es \
el complementario de ",
 StyleBox["I ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["\[Union]",
  FontFamily->"Times"],
 StyleBox[" P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " cortan todos a la circunferencia, luego tenemos una uni\[OAcute]n de \
conjuntos conexos que cortan todos a un mismo conexo. La uni\[OAcute]n es \
conexa."
}], "Text",
 CellChangeTimes->{{3.538510659331917*^9, 3.538510760366003*^9}, {
  3.538513620805171*^9, 3.538513648428302*^9}, {3.5385138165768223`*^9, 
  3.5385138171602716`*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "Esto termina la prueba de una implicaci\[OAcute]n. El rec\[IAcute]proco es \
consecuencia de que los compactos convexos tienen hiperplanos de soporte en \
todos los puntos de su frontera. Concretamente, si ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un lado de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " tomamos un punto ",
 StyleBox["p",
  FontSlant->"Italic"],
 " que no sea un extremo, con lo que existe una recta que pasa por ",
 StyleBox["p",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y que deja a todo el convexo (en este caso la uni\[OAcute]n de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y su interior) en uno de los semiplanos que determina. Es obvio que dicha \
recta tiene que ser necesariamente la prolongaci\[OAcute]n del lado. \
\[FilledSquare]"
}], "Text",
 CellChangeTimes->{{3.538510659331917*^9, 3.538510760366003*^9}, {
  3.538513620805171*^9, 3.538513648428302*^9}, {3.5385138165768223`*^9, 
  3.538513871342477*^9}, {3.538514558447597*^9, 3.538514684232662*^9}, {
  3.5389387775179043`*^9, 3.53893878037227*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Nota:",
  FontWeight->"Bold"],
 " Hamos advertido antes de dar la definici\[OAcute]n de pol\[IAcute]gono que \
con ella nos estamos apartando de la definici\[OAcute]n com\[UAcute]nmente \
aceptada. Esto se debe a que lo usual llamar \[OpenCurlyDoubleQuote]pol\
\[IAcute]gono\[CloseCurlyDoubleQuote] a lo que seg\[UAcute]n nuestra definici\
\[OAcute]n es la uni\[OAcute]n de un pol\[IAcute]gono y su interior, mientras \
que lo que hemos llamado \[OpenCurlyDoubleQuote]pol\[IAcute]gono\
\[CloseCurlyDoubleQuote] es (un caso particular de) lo que usualmente se \
llama \[OpenCurlyDoubleQuote]l\[IAcute]nea poligonal cerrada\
\[CloseCurlyDoubleQuote]. Entre las razones para dar la definici\[OAcute]n \
que hemos dado estaba mostrar que un pol\[IAcute]gono est\[AAcute] \
completamente determinado por sus v\[EAcute]rtices y sus aristas (sin \
necesidad de especificar su interior), pero a partir de este momento no hay \
inconveniente en adoptar el convenio usual y entender que un pol\[IAcute]gono \
es la figura formada por una poligonal cerrada (un pol\[IAcute]gono seg\
\[UAcute]n nuestra definici\[OAcute]n) y su interior."
}], "Text",
 CellChangeTimes->{
  3.5385154266982737`*^9, {3.538515730455316*^9, 3.538515745907192*^9}, {
   3.538553123431901*^9, 3.5385531533779078`*^9}, 3.5385685871993933`*^9},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "A partir de aqu\[IAcute] supondremos que el lector conoce los \
t\[EAcute]rminos y de la geometr\[IAcute]a cl\[AAcute]sica concernientes a \
pol\[IAcute]gonos, es decir, lo que es un cuadrado, un rect\[AAcute]ngulo, un \
paralelogramo, un rombo, un tri\[AAcute]ngulo is\[OAcute]sceles, etc., as\
\[IAcute] como los hechos fundamentales. En particular, es claro que los \
lados que concurren en un v\[EAcute]rtice de un pol\[IAcute]gono determinan \
dos \[AAcute]ngulos cuya suma es de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["360",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ". Si el pol\[IAcute]gono es simple podemos distinguir entre el ",
 StyleBox["\[AAcute]ngulo interior",
  FontSlant->"Italic"],
 " y el ",
 StyleBox["\[AAcute]ngulo exterior,",
  FontSlant->"Italic"],
 " en el sentido obvio. Cuando hablamos de los \[AAcute]ngulos de un pol\
\[IAcute]gono se entiende que son los \[AAcute]ngulos interiores."
}], "Text",
 CellChangeTimes->{{3.5385154291425753`*^9, 3.538515429145899*^9}, {
  3.538515675193637*^9, 3.538515713649764*^9}, {3.538516404379743*^9, 
  3.538516586003553*^9}, {3.538516625420134*^9, 3.5385166687881317`*^9}, {
  3.538516708798472*^9, 3.538516733365896*^9}, {3.538516776153352*^9, 
  3.538516782414579*^9}, {3.538516841386875*^9, 3.5385169883682003`*^9}, {
  3.5385533677007723`*^9, 3.538553368768228*^9}, {3.538553420480824*^9, 
  3.538553450242997*^9}, {3.538940767224751*^9, 3.538940782527685*^9}},
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Teorema 1.2:",
  FontWeight->"Bold",
  FontSlant->"Plain"],
 " ",
 StyleBox["Todo pol\[IAcute]gono simple tiene al menos un \[AAcute]ngulo de \
menos de ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["180",
     FontFamily->"Times",
     FontSlant->"Plain"], "\[SmallCircle]"], TraditionalForm]],
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"]
}], "Text",
 CellMargins->{{12, 24}, {4, 16}},
 CellChangeTimes->{{3.538563354312893*^9, 3.53856335431572*^9}, {
  3.5385679638813763`*^9, 3.538568002767579*^9}, {3.5385682651939783`*^9, 
  3.5385682660977488`*^9}, {3.5385731615134172`*^9, 3.538573166108942*^9}, {
  3.5386010242902203`*^9, 3.538601028806912*^9}, {3.5389408183763742`*^9, 
  3.5389408378704243`*^9}},
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": Fijado un sistema de referencia en el plano, como el interior de un pol\
\[IAcute]gono ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un conjunto acotado, su proyecci\[OAcute]n sobre el eje ",
 StyleBox["X",
  FontFamily->"Times",
  FontSize->18],
 " ser\[AAcute] un conjunto acotado y tendr\[AAcute] un supremo ",
 StyleBox["s",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " que ser\[AAcute] la coordenada ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de un punto ",
 StyleBox["p",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de la frontera de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " As\[IAcute], la recta vertical de ecuaci\[OAcute]n ",
 StyleBox["x = s",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " toca la frontera de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y deja a todo ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " en uno de sus semiplanos. Si ",
 StyleBox["p",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " no es un v\[EAcute]rtice de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " estar\[AAcute] en uno de sus lados, que ser\[AAcute] necesariamente \
vertical, pues si no, cruzar\[IAcute]a la recta, luego los extremos de dicho \
lado estar\[AAcute]n sobre la recta y, en cualquier caso, la recta contendr\
\[AAcute] un v\[EAcute]rtice ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " El \[AAcute]ngulo interior correspondiente a ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] contenido en un semiplano, luego es menor o igual de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["180",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ". La definici\[OAcute]n de pol\[IAcute]gono exige que sea menor de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["180",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ".  \[FilledSmallSquare]"
}], "Text",
 CellChangeTimes->{{3.538563354454145*^9, 3.538563354455887*^9}, {
  3.538568008110956*^9, 3.538568028176949*^9}, {3.538568058354439*^9, 
  3.5385683132285137`*^9}, {3.538940846028882*^9, 3.538940874870002*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Teorema 1.3:",
  FontWeight->"Bold",
  FontSlant->"Plain"],
 " ",
 StyleBox["Todo pol\[IAcute]gono simple de m\[AAcute]s de tres lados contiene \
al menos una de sus diagonales.",
  FontSlant->"Italic"]
}], "Text",
 CellMargins->{{12, 24}, {4, 16}},
 CellChangeTimes->{{3.538563354598115*^9, 3.5385633545998*^9}, {
  3.538568338493198*^9, 3.538568358754874*^9}, {3.538568423390402*^9, 
  3.5385684246995573`*^9}},
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": Sea ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " un pol\[IAcute]gono simple de m\[AAcute]s de tres lados y sea ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " un v\[EAcute]rtice cuyo \[AAcute]ngulo sea menor de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["180",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ". Sean ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "1"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 "y ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "2"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 " sus v\[EAcute]rtices adyacentes. Como ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " no es un tri\[AAcute]ngulo, estos dos v\[EAcute]rtices no son adyacentes \
entre s\[IAcute], y el segmento que los une es una diagonal. Podemos suponer \
que no est\[AAcute] contenida en ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", pues en caso contrario no hay nada que probar. Vamos a distinguir varios \
casos:"
}], "Text",
 CellChangeTimes->{{3.538563354734147*^9, 3.538563354735876*^9}, {
   3.5385683792427483`*^9, 3.5385684136353617`*^9}, {3.538568453590377*^9, 
   3.5385685743169603`*^9}, {3.538568810434307*^9, 3.5385688193334703`*^9}, {
   3.5385732147305107`*^9, 3.5385732151521463`*^9}, 3.538689323503336*^9, {
   3.538940881158166*^9, 3.538940888665923*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "a) ",
 StyleBox["El lado contiguo a",
  FontSlant->"Italic"],
 " ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FontSize->18],
 " ",
 StyleBox["est\[AAcute] contenido en",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["v", "1"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["v", "2"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 " ",
 StyleBox["o bien entra en el tri\[AAcute]ngulo",
  FontSlant->"Italic"],
 " ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "2"], TraditionalForm]],
  FontSize->18],
 "."
}], "Text",
 CellMargins->{{12, 24}, {4, 16}},
 CellChangeTimes->{{3.53856883236747*^9, 3.538568917973873*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "Sea ",
 StyleBox["w",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " su otro extremo y consideremos todos los segmentos que unen ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " con todos los v\[EAcute]rtices contenidos en el tri\[AAcute]ngulo ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FontSize->18],
 StyleBox["w",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " sin contar ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "1"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 ". De entre ellos, nos quedamos con el que forma un \[AAcute]ngulo menor con \
el lado ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FontSize->18],
 ". Si hay varios v\[EAcute]rtices cuyo segmento forma el mismo \
\[AAcute]ngulo, nos quedamos con el m\[AAcute]s cercano a ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " y lo llamamos ",
 StyleBox["w\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellChangeTimes->{{3.538568919026122*^9, 3.5385689202241573`*^9}, {
  3.538568964440813*^9, 3.5385690821773*^9}, {3.538569185520855*^9, 
  3.538569237867668*^9}, {3.5385694991856956`*^9, 3.538569508863426*^9}, {
  3.538569942398024*^9, 3.538569966596527*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[BoxData[
 GraphicsBox[{LineBox[{{0, 0}, {5, 0}, {-1, 3}, {0, 0}, {2, 1}, {-1, 3}}], 
   {PointSize[0.02], PointBox[{{0, 0}, {5, 0}, {-1, 3}, {2, 1}, {0.7, 1}}]}, 
   InsetBox[
    StyleBox["\<\"v\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {-0.2, 0}], InsetBox[
    StyleBox["\<\"w\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {1.7, 1}], InsetBox[
    StyleBox["\<\"w'\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {0.4, 1}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(v\\), \\(1\\)]\\)\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {-1.2, 3}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(v\\), \\(2\\)]\\)\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {5, -0.2}]}]], "Output",
 CellChangeTimes->{3.539024547076509*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Observamos que el lado ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["v", "1"],
    FontFamily->"Times",
    FontSize->18,
    FontSlant->"Italic"], TraditionalForm]]],
 StyleBox["w",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " no puede cortar al lado ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", 
    StyleBox["2",
     FontSize->14,
     FontSlant->"Plain"]], TraditionalForm]],
  FontFamily->"Times",
  FontSlant->"Italic"],
 ", luego el \[AAcute]ngulo que ",
 StyleBox["vw",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " forma con ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FontSize->18],
 " es menor que el que forma ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "2"], TraditionalForm]],
  FontSize->18],
 ", por lo que ",
 StyleBox["w\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " no puede ser ninguno de los dos v\[EAcute]rtices adyacentes a ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " luego el segmento que lo une con ",
 StyleBox["v",
  FontSlant->"Italic"],
 " es una diagonal. Si no fuera interior, como no puede contener \
ning\[UAcute]n otro v\[EAcute]rtice de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " tendr\[IAcute]a que estar atravesada por un lado de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " pero el extremo ",
 StyleBox["w\[CloseCurlyQuote]\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " situado en el mismo semiplano que ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["v", "1"],
    FontFamily->"Times",
    FontSize->18,
    FontSlant->"Italic"], TraditionalForm]]],
 " no puede haber salido del tri\[AAcute]ngulo ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FontSize->18],
 StyleBox["w",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " ni cruzando ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FontSize->18],
 " ni cruzando ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "1"], TraditionalForm]],
  FontSlant->"Italic"],
 StyleBox["w",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " pues ambos son lados de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y los lados no pueden cortarse. Entonces ",
 StyleBox["w\[CloseCurlyQuote]\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " ser\[IAcute]a un v\[EAcute]rtice contenido en el tri\[AAcute]ngulo ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "1"], TraditionalForm]],
  FontFamily->"Times",
  FontSlant->"Italic"],
 StyleBox["w",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " que formar\[IAcute]a un \[AAcute]ngulo con ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FontSize->18],
 " menor que ",
 StyleBox["w\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " contradicci\[OAcute]n. Por lo tanto, la diagonal ",
 StyleBox["vw\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es interior."
}], "Text",
 CellChangeTimes->{{3.538563355014113*^9, 3.538563355015774*^9}, {
   3.538569807121707*^9, 3.5385699092116756`*^9}, {3.5385699962208652`*^9, 
   3.5385702580976067`*^9}, 3.538777773108101*^9},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "b) ",
 StyleBox["El lado contiguo a",
  FontSlant->"Italic"],
 " ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FontSize->18],
 " ",
 StyleBox["est\[AAcute] fuera del tri\[AAcute]ngulo ",
  FontSlant->"Italic"],
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["v", "1"],
    FontFamily->"Times"], TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "2"], TraditionalForm]],
  FontSize->18],
 ".",
 StyleBox[" ",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.538570260494377*^9, 3.538570358144339*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Entonces podemos tomar el punto ",
 StyleBox["p",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de la diagonal ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["v", "1"],
    FontFamily->"Times",
    FontSize->18,
    FontSlant->"Italic"], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["v", "2"],
    FontFamily->"Times",
    FontSize->18,
    FontSlant->"Italic"], TraditionalForm]]],
 " m\[AAcute]s cercano a ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "1"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", y pueden darse dos casos: que sea un v\[EAcute]rtice de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " o que est\[EAcute] en el interior de un lado ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " que cruza la diagonal. En el segundo caso llamamos ",
 StyleBox["w",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " al v\[EAcute]rtice de",
 StyleBox[" l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " que queda dentro del tri\[AAcute]ngulo ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times New Roman Italic",
     FontSlant->"Plain"], "2"], TraditionalForm]],
  FontSize->18],
 ", y en el primero tomamos como ",
 StyleBox["w",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " el propio ",
 StyleBox["p",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " Ahora podemos repetir el argumento anterior con el cuadril\[AAcute]tero ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FontSize->18],
 StyleBox["pw",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " (que ser\[AAcute] un tri\[AAcute]ngulo si ",
 StyleBox["p = w",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "):"
}], "Text",
 CellChangeTimes->{
  3.538570322726963*^9, {3.538570371799569*^9, 3.53857045835261*^9}, {
   3.538570669214755*^9, 3.538570801407838*^9}, {3.538570852527526*^9, 
   3.538570852535633*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[BoxData[
 GraphicsBox[{LineBox[{{0, 0}, {5, 0}, {-1, 3}, {0, 0}, {2, 1}, {1, 2}}], 
   {PointSize[0.02], 
    PointBox[{{0, 0}, {5, 0}, {-1, 3}, {2, 1}, {0.7, 1}, {1, 2}}]}, InsetBox[
    StyleBox["\<\"v\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {-0.2, 0}], InsetBox[
    StyleBox["\<\"w\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {1.7, 1}], InsetBox[
    StyleBox["\<\"p\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {1.2, 2.2}], InsetBox[
    StyleBox["\<\"w'\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {0.4, 1}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(v\\), \\(1\\)]\\)\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {-1.2, 3}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(v\\), \\(2\\)]\\)\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {5, -0.2}]}]], "Output",
 CellChangeTimes->{3.5390245702165937`*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Como antes, consideramos, de entre los v\[EAcute]rtices contenidos en el \
cuadri\[AAcute]tero sin contar ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " ni ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "1"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", el que hace que el segmento que lo une con ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " forme el menor \[AAcute]ngulo posible con ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FontSize->18],
 " y en dicho segmento tomamos el v\[EAcute]rtice ",
 StyleBox["w\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " m\[AAcute]s cercano a ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " Nuevamente, el segmento ",
 StyleBox["vw\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es una diagonal y no puede contener otros v\[EAcute]rtices de ",
 StyleBox["P,",
  FontSlant->"Italic"],
 " ni tampoco puede ser cruzada por un lado, ya que el extremo de dicho lado \
situado en el semiplano de ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["v", "1"],
    FontFamily->"Times",
    FontSize->18,
    FontSlant->"Italic"], TraditionalForm]]],
 "no puede sarlir del cuadril\[AAcute]tero ni por ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FontSize->18],
 ", porque es un lado, ni por ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FontSize->18],
 StyleBox["p",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " por la minimalidad de ",
 StyleBox["p",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " ni por ",
 StyleBox["pw",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " porque es un fragmento de un lado. Por lo tanto, tiene que estar en el \
cuadril\[AAcute]tero y contradice la elecci\[OAcute]n de ",
 StyleBox["w\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 "  \[FilledSmallSquare]"
}], "Text",
 CellChangeTimes->{{3.538570853500617*^9, 3.538570853796467*^9}, {
  3.538571158552802*^9, 3.5385712892254*^9}, {3.5385713440119658`*^9, 
  3.538571431074874*^9}, {3.5385715070408363`*^9, 3.538571510077523*^9}},
 Hyphenation->False],

Cell[TextData[{
 "A partir de este resultado es f\[AAcute]cil probar, por ejemplo, que todo \
pol\[IAcute]gono simple se puede ",
 StyleBox["triangular,",
  FontSlant->"Italic"],
 " es decir, se puede descomponer en uni\[OAcute]n de tri\[AAcute]ngulos \
disjuntos (es decir, que la intersecci\[OAcute]n entre dos de ellos se \
reduzca a un v\[EAcute]rtice o una arista com\[UAcute]n) cuyos \
v\[EAcute]rtices son v\[EAcute]rtices del pol\[IAcute]gono. Otra consecuencia \
sencilla es la siguiente:"
}], "Text",
 CellChangeTimes->{{3.538563355158094*^9, 3.538563355159965*^9}, {
  3.538571632222561*^9, 3.538571718898446*^9}},
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Teorema 1.4:",
  FontWeight->"Bold",
  FontSlant->"Plain"],
 " ",
 StyleBox["La suma de los \[AAcute]ngulos de un pol\[IAcute]gono simple de ",
  FontSlant->"Italic"],
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" lados es igual a ",
  FontSlant->"Italic"],
 StyleBox["(n-",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["2",
  FontFamily->"Times",
  FontSlant->"Italic"],
 StyleBox[")",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["180",
     FontFamily->"Times",
     FontSlant->"Plain"], "\[SmallCircle]"], TraditionalForm]],
  FontSlant->"Italic"],
 StyleBox[". ",
  FontSlant->"Italic"]
}], "Text",
 CellMargins->{{12, 24}, {4, 16}},
 CellChangeTimes->{{3.538563355310115*^9, 3.538563355311988*^9}, {
   3.538571727421789*^9, 3.538571749942418*^9}, {3.538573173806424*^9, 
   3.5385731739172287`*^9}, 3.5389407058062153`*^9},
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": Lo probamos por inducci\[OAcute]n sobre ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " Lo suponemos conocido para el caso de los tri\[AAcute]ngulos. Si es cierto \
para pol\[IAcute]gonos de menos de ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " lados y ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " tiene ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " lados, consideramos una diagonal ",
 StyleBox["d",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " que sea interior. Digamos que une los v\[EAcute]rtices ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["v\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " Es claro que ",
 StyleBox["d",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " divide a ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " en dos pol\[IAcute]gonos de menos de ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " lados. Si tienen ",
 StyleBox["m",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["m\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " lados, respectivamente, entonces los lados de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " son ",
 StyleBox["n = m-",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["1",
  FontFamily->"Times"],
 StyleBox["+m\[CloseCurlyQuote]-",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["1",
  FontFamily->"Times"],
 StyleBox[" = m+m\[CloseCurlyQuote]-",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["2",
  FontFamily->"Times"],
 StyleBox[".",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " Tambi\[EAcute]n es claro que la suma de los \[AAcute]ngulos internos de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es la suma de los \[AAcute]ngulos internos de los dos \
subpol\[IAcute]gonos, luego \[EAcute]sta es ",
 StyleBox["(m-",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["2",
  FontFamily->"Times",
  FontSlant->"Italic"],
 StyleBox[")",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["180",
  FontFamily->"Times"],
 StyleBox["+(m\[CloseCurlyQuote]-",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["2",
  FontFamily->"Times",
  FontSlant->"Italic"],
 StyleBox[")",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["180",
  FontFamily->"Times"],
 StyleBox[" = (n-",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["2",
  FontFamily->"Times",
  FontSlant->"Italic"],
 StyleBox[")",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["180",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 StyleBox[".  ",
  FontFamily->"Verdana Italic"],
 "\[FilledSmallSquare]"
}], "Text",
 CellChangeTimes->{{3.538563355462129*^9, 3.538563355463889*^9}, {
   3.538571795216366*^9, 3.538571949153852*^9}, {3.5385719930247803`*^9, 
   3.538572138694343*^9}, {3.5385721848129807`*^9, 3.5385721861561537`*^9}, 
   3.538774608006268*^9, {3.5389406561751747`*^9, 3.5389406862716103`*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[StyleBox["POL\[CapitalIAcute]GONOS REGULARES",
 FontSize->18,
 FontColor->RGBColor[0, 0, 1]]], "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellMargins->{{100, 100}, {16, 18}},
 CellChangeTimes->{{3.538515429422391*^9, 3.538515429424019*^9}, {
  3.538517083097238*^9, 3.538517086760803*^9}, {3.538772137916774*^9, 
  3.5387721418334713`*^9}, {3.5389433492789*^9, 3.538943354615024*^9}, {
  3.538944109694562*^9, 3.538944112294664*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell["\<\
Estudiamos ahora los pol\[IAcute]gonos regulares, en el sentido siguiente:\
\>", "Text",
 CellChangeTimes->{{3.538515429558395*^9, 3.538515429559925*^9}, {
  3.5385171548994417`*^9, 3.538517184569318*^9}, {3.538601066656513*^9, 
  3.538601102303549*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Un ",
 StyleBox["pol\[IAcute]gono regular",
  FontSlant->"Italic"],
 " es un pol\[IAcute]gono simple con lados iguales y \[AAcute]ngulos \
iguales."
}], "Text",
 CellMargins->{{30, 30}, {3, 5}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
  3.538342563212167*^9, 3.538342641589696*^9}, {3.538477791518964*^9, 
  3.538477806679139*^9}, {3.53849656143301*^9, 3.5384966496577177`*^9}, {
  3.538496697507208*^9, 3.5384967694009666`*^9}, {3.538497015029212*^9, 
  3.538497197509335*^9}, {3.538507820776568*^9, 3.538507896303946*^9}, {
  3.538517197451973*^9, 3.538517209882393*^9}, {3.538600835169466*^9, 
  3.538600858197411*^9}},
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell["\<\
Es conocido que un tri\[AAcute]ngulo tiene sus lados iguales si y \
s\[OAcute]lo si tiene sus lados iguales. Sin embargo, para el resto de pol\
\[IAcute]gonos las dos condiciones son independientes: un rect\[AAcute]ngulo \
tiene sus cuatro \[AAcute]ngulos iguales, pero no necesariamente sus lados \
iguales, mientras que un rombo tiene sus cuatro lados iguales, pero no \
necesariamente sus cuatro \[AAcute]ngulos iguales. Del teorema 1.4 se deduce \
inmediatamente el hecho siguiente:\
\>", "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{{3.538517213411327*^9, 3.5385172594591923`*^9}, {
  3.538572273192424*^9, 3.538572273195867*^9}, {3.538572813178382*^9, 
  3.538572822889119*^9}, {3.538601150764514*^9, 3.538601174969079*^9}},
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Teorema 1.5:",
  FontWeight->"Bold",
  FontSlant->"Plain"],
 " ",
 StyleBox["Cada \[AAcute]ngulo de un ",
  FontSlant->"Italic"],
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["-\[AAcute]gono regular mide ",
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     SuperscriptBox[
      StyleBox["180",
       FontSize->14,
       FontSlant->"Plain"], "\[SmallCircle]"],
     FontSize->14,
     FontSlant->"Plain"], "-", 
    StyleBox[
     FractionBox[
      StyleBox[
       SuperscriptBox[
        StyleBox["360",
         FontFamily->"Times",
         FontSize->12.779998779296875`,
         FontSlant->"Plain"], "\[SmallCircle]"],
       FontFamily->"Times",
       FontSize->12.779998779296875`,
       FontSlant->"Plain"], "n"],
     FontSize->18]}], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "."
}], "Text",
 CellMargins->{{12, 24}, {16, 4}},
 CellChangeTimes->{{3.5385722733151703`*^9, 3.5385722733167343`*^9}, {
  3.538572826297388*^9, 3.5385728681625147`*^9}, {3.5385729008907223`*^9, 
  3.538572921602912*^9}, {3.538573033895903*^9, 3.538573037477852*^9}, {
  3.5385731788947573`*^9, 3.538573179045516*^9}, {3.538600863504538*^9, 
  3.538600863613658*^9}, {3.538940909468273*^9, 3.538940927011466*^9}},
 Hyphenation->False],

Cell[TextData[{
 "En particular, todos los \[AAcute]ngulos de un pol\[IAcute]gono regular \
miden menos de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["180",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 StyleBox[".",
  FontFamily->"Times"],
 " "
}], "Text",
 CellMargins->{{12, 10}, {16, 5}},
 CellChangeTimes->{{3.538572273443122*^9, 3.5385722734450083`*^9}, {
  3.538572906915535*^9, 3.53857296094671*^9}, {3.5385732285977087`*^9, 
  3.5385732289174957`*^9}, {3.538602462807102*^9, 3.538602467136052*^9}, {
  3.538940933818947*^9, 3.538940942152858*^9}},
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Teorema 1.6:",
  FontWeight->"Bold",
  FontSlant->"Plain"],
 " ",
 StyleBox["Los v\[EAcute]rtices de un pol\[IAcute]gono regular est\[AAcute]n \
situados sobre una \[UAcute]nica circunferencia.",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.5385722735871143`*^9, 3.53857227358884*^9}, {
  3.538602310622319*^9, 3.538602366247793*^9}},
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": Consideremos un lado del pol\[IAcute]gono, de extremos ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["v", "1"],
    FontFamily->"Times",
    FontSize->18,
    FontSlant->"Italic"], TraditionalForm]]],
 " y ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["v", "2"],
    FontFamily->"Times",
    FontSize->18,
    FontSlant->"Italic"], TraditionalForm]]],
 ", y construyamos sobre \[EAcute]l un tri\[AAcute]ngulo is\[OAcute]sceles \
cuyos \[AAcute]ngulos sean los indicados en la figura. Realizamos la misma \
construcci\[OAcute]n sobre el lado contiguo, y observamos que los \
tri\[AAcute]ngulos obtenidos son iguales y tienen un lado en com\[UAcute]n, \
",
 StyleBox["O",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "2"], TraditionalForm]],
  FontSize->18],
 ". En efecto, sabemos que el \[AAcute]ngulo que forman los dos lados \
contiguos mide ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     RowBox[{"1", 
      StyleBox["80",
       FontFamily->"Times"]}]], 
    StyleBox["-",
     FontFamily->"Times"], 
    StyleBox[
     FractionBox["360", "n"],
     FontFamily->"Times"]}], TraditionalForm]]],
 ", luego el segmento",
 StyleBox[" O",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["v",
     FontFamily->"Times"], "2"], TraditionalForm]],
  FontSize->18],
 " est\[AAcute] precisamente sobre su bisectriz."
}], "Text",
 CellChangeTimes->{{3.538572273723117*^9, 3.538572273724992*^9}, {
   3.5386023865928907`*^9, 3.538602388567047*^9}, 3.5386024718952427`*^9, {
   3.5386040175378017`*^9, 3.5386040780404863`*^9}, {3.538604152266721*^9, 
   3.538604208138286*^9}, {3.538604243484684*^9, 3.5386043308431997`*^9}, {
   3.538604385182*^9, 3.538604443358511*^9}, {3.5386044787597027`*^9, 
   3.5386044803504753`*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[BoxData[
 GraphicsBox[{
   LineBox[NCache[{{0, 0}, {1, 0}, {
      Sin[Rational[3, 14] Pi], Cos[Rational[3, 14] Pi]}, {-
       Sin[Rational[1, 14] Pi], Cos[Rational[1, 14] Pi]}, {0, 0}, {
      Sin[Rational[3, 14] Pi], Cos[Rational[3, 14] Pi]}}, {{0, 0}, {1, 0}, {
      0.6234898018587335, 0.7818314824680298}, {-0.2225209339563144, 
      0.9749279121818236}, {0, 0}, {0.6234898018587335, 
      0.7818314824680298}}]], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(v\\), \\(1\\)]\\)\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {1.05, 0}], InsetBox[
    StyleBox["\<\"O\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {-0.03, -0.03}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(v\\), \\(2\\)]\\)\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {0.6546642919516702, 0.8209230565914313}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(v\\), \\(3\\)]\\)\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {-0.23364698065413012`, 1.023674307790915}], InsetBox[
    StyleBox["\<\"\\!\\(\\*FractionBox[\\(360\\), \\(n\\)]\\)\"\>",
     StripOnInput->False,
     FontSize->12,
     FontSlant->Italic], {0.15, 0.07}], InsetBox[
    StyleBox["\<\"90-\\!\\(\\*FractionBox[\\(180\\), \\(n\\)]\\)\"\>",
     StripOnInput->False,
     FontSize->12,
     FontSlant->Italic], {0.85, 0.07}], InsetBox[
    StyleBox["\<\"90-\\!\\(\\*FractionBox[\\(180\\), \\(n\\)]\\)\"\>",
     StripOnInput->False,
     FontSize->12,
     FontSlant->Italic], {0.6, 0.6}]},
  ImageSize->{318., Automatic}]], "Output",
 CellChangeTimes->{3.539024581491899*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Concluimos que el punto ",
 StyleBox["O",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] a la misma distancia de los tres v\[EAcute]rtices ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["v", "1"],
    FontFamily->"Times",
    FontSize->18,
    FontSlant->"Italic"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "2"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["v", "3"],
    FontFamily->"Times",
    FontSize->18,
    FontSlant->"Italic"], TraditionalForm]]],
 ", y la construcci\[OAcute]n puede repetirse con los v\[EAcute]rtices \
siguientes, hasta llegar a que todos equidistan del punto ",
 StyleBox["O",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 "  \[FilledSmallSquare]"
}], "ProofContinuation",
 CellChangeTimes->{{3.538604482693095*^9, 3.538604511550201*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "La circunferencia en la que se encuentran los v\[EAcute]rtices de un pol\
\[IAcute]gono regular ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " se llama ",
 StyleBox["circunferencia circunscrita",
  FontSlant->"Italic"],
 " del pol\[IAcute]gono (y tambi\[EAcute]n se dice que el pol\[IAcute]gono \
est\[AAcute] ",
 StyleBox["inscrito",
  FontSlant->"Italic"],
 " en la circunferencia), su centro se llama ",
 StyleBox["centro",
  FontSlant->"Italic"],
 " del pol\[IAcute]gono y su radio ",
 StyleBox["circunradio",
  FontSlant->"Italic"],
 " o, simplemente, ",
 StyleBox["radio",
  FontSlant->"Italic"],
 " del pol\[IAcute]gono."
}], "Text",
 CellMargins->{{30, 30}, {3, 5}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
  3.538342563212167*^9, 3.538342641589696*^9}, {3.538477791518964*^9, 
  3.538477806679139*^9}, {3.53849656143301*^9, 3.5384966496577177`*^9}, {
  3.538496697507208*^9, 3.5384967694009666`*^9}, {3.538497015029212*^9, 
  3.538497197509335*^9}, {3.538507820776568*^9, 3.538507896303946*^9}, {
  3.538517197451973*^9, 3.538517209882393*^9}, {3.538600835169466*^9, 
  3.538600858197411*^9}, {3.538604570997416*^9, 3.538604651286901*^9}, {
  3.538604749808346*^9, 3.53860475979252*^9}},
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell[TextData[{
 "Del la prueba del teorema anterior se deduce que los v\[EAcute]rtices de un \
",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "-\[AAcute]gono regular dividen a su circunferencia circunscrita en ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " partes iguales, as\[IAcute] como que la relaci\[OAcute]n entre la longitud \
",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " del lado y el radio ",
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es la dada por ",
 StyleBox["l = 2r ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["sen",
     FontSize->14], "(", 
    StyleBox[
     FractionBox[
      StyleBox[
       SuperscriptBox[
        StyleBox["180",
         FontFamily->"Times",
         FontSize->12.779998779296875`], "\[SmallCircle]"],
       FontFamily->"Times",
       FontSize->12.779998779296875`], "n"],
     FontSlant->"Plain"], 
    StyleBox[")",
     FontSlant->"Plain"]}], TraditionalForm]],
  FontSize->18],
 ". Tambi\[EAcute]n es obvio que la distancia del centro ",
 StyleBox["O",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " al centro de cada lado es ",
 StyleBox["a = r ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["cos",
     FontSize->14], "(", 
    FractionBox[
     StyleBox[
      SuperscriptBox[
       StyleBox["180",
        FontFamily->"Times",
        FontSize->12.779998779296875`], "\[SmallCircle]"],
      FontFamily->"Times",
      FontSize->12.779998779296875`], "n"], ")"}], TraditionalForm]],
  FontSize->18],
 ". Esta distancia se llama ",
 StyleBox["apotema",
  FontSlant->"Italic"],
 " o ",
 StyleBox["inradio",
  FontSlant->"Italic"],
 " del pol\[IAcute]gono, y la circunferencia de centro ",
 StyleBox["O",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y radio ",
 StyleBox["a",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " se llama ",
 StyleBox["circunferencia inscrita",
  FontSlant->"Italic"],
 " en el pol\[IAcute]gono, pues claramente es tangente a sus lados (y se dice \
tambi\[EAcute]n que el pol\[IAcute]gono est\[AAcute] ",
 StyleBox["circunscrito",
  FontSlant->"Italic"],
 " a ella)."
}], "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{{3.538604529012699*^9, 3.538604529014345*^9}, {
  3.5386047148301163`*^9, 3.538604789736208*^9}, {3.5386048268083353`*^9, 
  3.538604864872984*^9}, {3.53860489556949*^9, 3.538604939178958*^9}, {
  3.538604969978599*^9, 3.538604990931931*^9}, {3.538605045370612*^9, 
  3.538605166883953*^9}, {3.538606486273304*^9, 3.538606496818178*^9}, {
  3.538940967868622*^9, 3.5389410121044617`*^9}},
 Hyphenation->False],

Cell["\<\
La figura siguiente muestra varios pol\[IAcute]gonos regulares con su \
circunferencia inscrita y su circunferencia circunscrita:\
\>", "Text",
 CellMargins->{{12, 10}, {4, 16}},
 CellChangeTimes->{{3.538604529284669*^9, 3.5386045292865257`*^9}, {
  3.538606330807435*^9, 3.538606356992786*^9}},
 Hyphenation->False],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 3, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], {3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}}},
     Typeset`size$$ = {360., {177., 182.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`n$5107$$ =
     0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 3}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$5107$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{{
          GrayLevel[0.9], 
          EdgeForm[Black], 
          Polygon[
           Table[{
             
             Cos[(2 Pi) ($CellContext`i/
               If[$CellContext`n$$ < 3, 3, $CellContext`n$$])], 
             
             Sin[(2 Pi) ($CellContext`i/
               If[$CellContext`n$$ < 3, 
                3, $CellContext`n$$])]}, {$CellContext`i, 0, 
             If[$CellContext`n$$ < 3, 3, $CellContext`n$$]}]]}, 
         Table[
          Line[{{0, 0}, {
             
             Cos[(2 Pi) ($CellContext`i/
               If[$CellContext`n$$ < 3, 3, $CellContext`n$$])], 
             
             Sin[(2 Pi) ($CellContext`i/
               If[$CellContext`n$$ < 3, 
                3, $CellContext`n$$])]}}], {$CellContext`i, 0, 
           If[$CellContext`n$$ < 3, 3, $CellContext`n$$]}], 
         Circle[{0, 0}, 1], 
         Circle[{0, 0}, 
          Cos[Pi/If[$CellContext`n$$ < 3, 3, $CellContext`n$$]]]}], 
      "Specifications" :> {{$CellContext`n$$, {3, 4, 5, 6, 7, 8, 9, 10, 11, 
         12, 13, 14, 15}, ControlType -> SetterBar}}, 
      "Options" :> {AppearanceElements -> {}}, "DefaultOptions" :> {}],
     ImageSizeCache->{405., {212., 218.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.539171967632595*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Ahora es evidente que dos ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "-\[AAcute]gonos regulares son iguales si y s\[OAcute]lo si tienen el mismo \
lado (o el mismo radio), y que dos ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "-\[AAcute]gonos regulares cualesquiera son homot\[EAcute]ticos. Veamos una \
propiedad elemental de los pol\[IAcute]gonos que usaremos a menudo:"
}], "Text",
 CellMargins->{{12, 10}, {16, 5}},
 CellChangeTimes->{{3.5386045295806437`*^9, 3.538604529582305*^9}, {
  3.5386068324522552`*^9, 3.538606941592001*^9}, {3.5386900134193783`*^9, 
  3.538690013538918*^9}, {3.538690118789*^9, 3.538690120300753*^9}},
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Teorema 1.7:",
  FontWeight->"Bold",
  FontSlant->"Plain"],
 " ",
 StyleBox["El lugar geom\[EAcute]trico de los puntos que equidistan de tres \
de los v\[EAcute]rtices de un pol\[IAcute]gono regular es la recta que pasa \
por su centro y es perpendicular a su plano, y sus puntos equidistan de hecho \
de todos los v\[EAcute]rtices del pol\[IAcute]gono.",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.538606942662209*^9, 3.538606983182856*^9}, {
  3.538607545637763*^9, 3.538607549069707*^9}, {3.539183215328033*^9, 
  3.5391832367971773`*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": Es f\[AAcute]cil ver que el lugar geom\[EAcute]trico de los puntos que \
equidistan de dos puntos dados es el plano que pasa por el punto medio del \
segmento que los une y es perpendicular a \[EAcute]l. Por lo tanto, el lugar \
geom\[EAcute]trico de los puntos que equidistan de tres puntos no colineales \
es la intersecci\[OAcute]n de dos planos y, por consiguiente, una recta \
perpendicular al plano que los contiene. Si aplicamos esto a tres \
v\[EAcute]rtices de un pol\[IAcute]gono regular, vemos que los puntos que \
equidistan de ellos forman una recta perpendicular al pol\[IAcute]gono, pero \
como el centro cumple dicha propiedad, es concretamente la recta \
perpendicular al pol\[IAcute]gono que pasa por su centro. Aplicando esto a \
cada grupo de tres v\[EAcute]rtices concluimos que los puntos de dicha recta \
equidistan de todos los v\[EAcute]rtices del pol\[IAcute]gono.  \
\[FilledSmallSquare]"
}], "Text",
 CellChangeTimes->{{3.5386045295806437`*^9, 3.538604529582305*^9}, {
  3.5386068324522552`*^9, 3.538606917502075*^9}, {3.5386070070413446`*^9, 
  3.538607133684931*^9}, {3.5391832959962473`*^9, 3.539183318110413*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "Podemos plantearnos qu\[EAcute] sucede si tratamos de generalizar la \
definici\[OAcute]n de pol\[IAcute]gono regular suprimiendo el requisito de \
que el pol\[IAcute]gono deba ser simple. En principio, nos encontramos con \
una dificultad, ya que no podemos exigir que los \[AAcute]ngulos (internos) \
sean iguales, pues en un pol\[IAcute]gono con autointersecciones no hay una \
forma clara de distinguir entre \[AAcute]ngulos internos y externos. En \
cualquier caso, en cada v\[EAcute]rtice tenemos dos \[AAcute]ngulos, uno \
mayor de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["180",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 " y otro menor, y podemos exigir simplemente que los pares de \
\[AAcute]ngulos en cada v\[EAcute]rtice tengan las mismas medidas. Con esta \
definici\[OAcute]n relajada, existe una amplia gama de \
\[OpenCurlyDoubleQuote]pol\[IAcute]gonos regulares\[CloseCurlyDoubleQuote]. \
La figura siguiente contiene algunas muestras. Por ejemplo, el primero es un \
\[OpenCurlyDoubleQuote]hexadec\[AAcute]gono regular\[CloseCurlyDoubleQuote] \
cuyos v\[EAcute]rtices determinan \[AAcute]ngulos de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["45",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 " y ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["315",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 " y. Vemos que ocho de sus lados pasan por encima de otros tantos \
v\[EAcute]rtices, cosa que no ocurre en el segundo ejemplo, un \
\[OpenCurlyDoubleQuote]icos\[AAcute]gono regular\[CloseCurlyDoubleQuote] con \
\[AAcute]ngulos de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["72",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 " y ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["288",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ", cuyas aristas se cortan \[UAcute]nicamente en puntos interiores."
}], "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{{3.53860452971661*^9, 3.538604529718397*^9}, {
  3.538607136697884*^9, 3.538607136702338*^9}, {3.5386898171820374`*^9, 
  3.5386898394972563`*^9}, {3.53868987590764*^9, 3.538689999899304*^9}, {
  3.5386901396374063`*^9, 3.538690155949151*^9}, {3.538691108849854*^9, 
  3.5386911901685534`*^9}, {3.5386912580278473`*^9, 3.5386913042097*^9}, {
  3.538691345423717*^9, 3.538691399138474*^9}, {3.538691912745234*^9, 
  3.538691932344234*^9}, {3.538722064579691*^9, 3.5387221061492434`*^9}, {
  3.53872217109861*^9, 3.538722171505322*^9}, {3.538941021226802*^9, 
  3.538941118152364*^9}},
 Hyphenation->False],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[
       LineBox[NCache[{{0, 0}, {0, 1}, {
          2^Rational[-1, 2], 1 - 2^Rational[-1, 2]}, {
          2^Rational[-1, 2], 2 - 2^Rational[-1, 2]}, {
          0, 2 - 2^Rational[1, 2]}, {1, 2 - 2^Rational[1, 2]}, {
          1 - 2^Rational[-1, 2], 2 - 3 2^Rational[-1, 2]}, {
          2 - 2^Rational[-1, 2], 2 - 3 2^Rational[-1, 2]}, {
          2 - 2^Rational[1, 2], 2 - 2^Rational[1, 2]}, {
          2 - 2^Rational[1, 2], 1 - 2^Rational[1, 2]}, {
          2 - 2^Rational[-1, 2] - 2^Rational[1, 2], 1 - 3 2^Rational[-1, 2] + 
           2^Rational[1, 2]}, {
          2 - 2^Rational[-1, 2] - 2^Rational[1, 2], (-3) 2^Rational[-1, 2] + 
           2^Rational[1, 2]}, {2 - 2^Rational[1, 2], 0}, {
          1 - 2^Rational[1, 2], 0}, {
          1 - 2^Rational[-1, 2], (-3) 2^Rational[-1, 2] + 
           2 2^Rational[1, 2]}, {-2^Rational[-1, 2], (-3) 2^Rational[-1, 2] + 
           2 2^Rational[1, 2]}, {0, 0}}, {{0, 0}, {0, 1}, {0.7071067811865475,
           0.29289321881345254`}, {0.7071067811865475, 1.2928932188134525`}, {
          0, 0.5857864376269049}, {1, 0.5857864376269049}, {
          0.29289321881345254`, -0.12132034355964239`}, {
          1.2928932188134525`, -0.12132034355964239`}, {0.5857864376269049, 
          0.5857864376269049}, {
          0.5857864376269049, -0.41421356237309515`}, {-0.12132034355964261`, 
          0.29289321881345276`}, {-0.12132034355964261`, \
-0.7071067811865472}, {0.5857864376269049, 0}, {-0.41421356237309515`, 0}, {
          0.29289321881345254`, 0.7071067811865479}, {-0.7071067811865475, 
          0.7071067811865479}, {0, 0}}]]], {194.4, -189.96465402450826`}, 
      ImageScaled[{0.5, 0.5}], {360.00000000000006`, 356.18372629595297`}], 
     InsetBox[
      GraphicsBox[
       LineBox[NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
           Rational[1, 2], 
           Rational[1, 4] (-1 + 
            5^Rational[1, 2])}, {-(Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + (
             Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
            Rational[1, 4] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 4] (1 + 
             5^Rational[1, 2])}, {-(Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 4] (1 + 
             5^Rational[1, 2])}, {(-2) (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2], Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 
             5^Rational[1, 2])}, {(-3) (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 
             5^Rational[1, 2])}, {(-3) (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 4] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 
             5^Rational[1, 2])}, {(-4) (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 4] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 
             5^Rational[1, 2])}, {(-4) (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2], Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 
             5^Rational[1, 2])}, {(-4) (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2], 1 + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 
             5^Rational[1, 2])}, {(-4) (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2], 1 + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[3, 4] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 
             5^Rational[1, 2])}, {(-4) (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2], 2 + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[3, 4] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 
             5^Rational[1, 2])}, {(-4) (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2], 3 - 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 
             5^Rational[1, 2])}, {(-3) (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2], 3 - 5^Rational[1, 2] + 
           Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 
             5^Rational[1, 2])}, {(-2) (Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2], 3 - 5^Rational[1, 2] + 
           Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[3, 4] (1 + 
             5^Rational[1, 2])}, {-(Rational[5, 8] + 
              Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2], 2 - 2 5^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[3, 4] (1 + 5^Rational[1, 2])}, {
          2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
            3 - 5^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2])}, {(Rational[5, 8] + 
            Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 3 - 5^
           Rational[1, 2] + 
           Rational[3, 4] (-1 + 5^Rational[1, 2])}, {(Rational[5, 8] + 
            Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 2 - 5^
           Rational[1, 2] + Rational[3, 4] (-1 + 5^Rational[1, 2])}, {0, 1}, {
          0, 0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
           Rational[1, 2], 1 - 5^Rational[1, 2] + 
           Rational[5, 4] (-1 + 5^Rational[1, 2])}}, {{0.9510565162951535, 
          0.30901699437494745`}, {0.3632712640026804, 1.118033988749895}, {
          1.314327780297834, 1.4270509831248424`}, {0.7265425280053608, 
          2.23606797749979}, {0.13875727571288765`, 1.4270509831248424`}, {
          1.089813792008041, 1.118033988749895}, {0.5020285397155679, 
          0.30901699437494745`}, {1.4530850560107216`, 0.}, {
          1.4530850560107216`, 1.}, {0.5020285397155679, 
          0.6909830056250525}, {0.5020285397155679, 
          1.6909830056250525`}, {-0.4490279765795855, 1.381966011250105}, {
          0.13875727571288765`, 0.5729490168751576}, {0.7265425280053608, 
          1.381966011250105}, {1.314327780297834, 0.5729490168751576}, {
          1.902113032590307, 1.381966011250105}, {0.9510565162951535, 
          1.6909830056250525`}, {0.9510565162951535, 0.6909830056250525}, {0, 
          1}, {0, 0}, {0.9510565162951535, 0.30901699437494745`}}]]], {583.2, -189.96465402450826`},
       ImageScaled[{0.5, 0.5}], {360.00000000000006`, 356.18372629595297`}], 
     InsetBox[
      GraphicsBox[
       LineBox[NCache[{{Cos[Rational[1, 8] Pi], -Sin[Rational[1, 8] Pi]}, {
          2^Rational[-1, 2] + Cos[Rational[1, 8] Pi], 2^Rational[-1, 2] - Sin[
           Rational[1, 8] Pi]}, {
          2^Rational[-1, 2] + 2 Cos[Rational[1, 8] Pi], 2^Rational[-1, 2] - 2 
           Sin[Rational[1, 8] Pi]}, {
          2^Rational[1, 2] + 2 Cos[Rational[1, 8] Pi], 2^Rational[1, 2] - 2 
           Sin[Rational[1, 8] Pi]}, {
          2^Rational[1, 2] + 2 Cos[Rational[1, 8] Pi] - Sin[
           Rational[1, 8] Pi], 2^Rational[1, 2] + Cos[Rational[1, 8] Pi] - 2 
           Sin[Rational[1, 8] Pi]}, {-1 + 2^Rational[1, 2] + 
           2 Cos[Rational[1, 8] Pi] - Sin[Rational[1, 8] Pi], 
           2^Rational[1, 2] + Cos[Rational[1, 8] Pi] - 2 
           Sin[Rational[1, 8] Pi]}, {-1 + 2^Rational[1, 2] + 
           2 Cos[Rational[1, 8] Pi] - 2 Sin[Rational[1, 8] Pi], 
           2^Rational[1, 2] + 2 Cos[Rational[1, 8] Pi] - 2 
           Sin[Rational[1, 8] Pi]}, {-2 + 2^Rational[1, 2] + 
           2 Cos[Rational[1, 8] Pi] - 2 Sin[Rational[1, 8] Pi], 
           2^Rational[1, 2] + 2 Cos[Rational[1, 8] Pi] - 2 
           Sin[Rational[1, 8] Pi]}, {-2 + 2^Rational[1, 2] + 
           2 Cos[Rational[1, 8] Pi] - 3 Sin[Rational[1, 8] Pi], 
           2^Rational[1, 2] + Cos[Rational[1, 8] Pi] - 2 
           Sin[Rational[1, 8] Pi]}, {-2 + 2^Rational[-1, 2] + 
           2^Rational[1, 2] + 2 Cos[Rational[1, 8] Pi] - 3 
           Sin[Rational[1, 8] Pi], -2^Rational[-1, 2] + 2^Rational[1, 2] + 
           Cos[Rational[1, 8] Pi] - 2 Sin[Rational[1, 8] Pi]}, {-2 + 
           2^Rational[-1, 2] + 2^Rational[1, 2] + 2 Cos[Rational[1, 8] Pi] - 
           4 Sin[Rational[1, 8] Pi], -2^Rational[-1, 2] + 2^Rational[1, 2] - 
           2 Sin[Rational[1, 8] Pi]}, {-2 + 2 2^Rational[1, 2] + 
           2 Cos[Rational[1, 8] Pi] - 4 Sin[Rational[1, 8] Pi], (-2) 
           Sin[Rational[1, 8] Pi]}, {-2 + 2 2^Rational[1, 2] + 
           3 Cos[Rational[1, 8] Pi] - 4 Sin[Rational[1, 8] Pi], -
           Sin[Rational[1, 8] Pi]}, {-2 + 2 2^Rational[1, 2] + 
           3 Cos[Rational[1, 8] Pi] - 4 Sin[Rational[1, 8] Pi], 1 - Sin[
           Rational[1, 8] Pi]}, {-2 + 2 2^Rational[1, 2] + 
           4 Cos[Rational[1, 8] Pi] - 4 Sin[Rational[1, 8] Pi], 1}, {-2 + 
           2 2^Rational[1, 2] + 4 Cos[Rational[1, 8] Pi] - 4 
           Sin[Rational[1, 8] Pi], 2}, {-2 + 2 2^Rational[1, 2] + 
           3 Cos[Rational[1, 8] Pi] - 4 Sin[Rational[1, 8] Pi], 2 + 
           Sin[Rational[1, 8] Pi]}, {-2 - 2^Rational[-1, 2] + 
           2 2^Rational[1, 2] + 3 Cos[Rational[1, 8] Pi] - 4 
           Sin[Rational[1, 8] Pi], 2 - 2^Rational[-1, 2] + 
           Sin[Rational[1, 8] Pi]}, {-2 - 2^Rational[-1, 2] + 
           2 2^Rational[1, 2] + 2 Cos[Rational[1, 8] Pi] - 4 
           Sin[Rational[1, 8] Pi], 2 - 2^Rational[-1, 2] + 
           2 Sin[Rational[1, 8] Pi]}, {-2 + 2^Rational[1, 2] + 
           2 Cos[Rational[1, 8] Pi] - 4 Sin[Rational[1, 8] Pi], 2 - 2^
           Rational[1, 2] + 2 Sin[Rational[1, 8] Pi]}, {-2 + 2^Rational[1, 2] + 
           2 Cos[Rational[1, 8] Pi] - 3 Sin[Rational[1, 8] Pi], 2 - 2^
           Rational[1, 2] - Cos[Rational[1, 8] Pi] + 
           2 Sin[Rational[1, 8] Pi]}, {-1 + 2^Rational[1, 2] + 
           2 Cos[Rational[1, 8] Pi] - 3 Sin[Rational[1, 8] Pi], 2 - 2^
           Rational[1, 2] - Cos[Rational[1, 8] Pi] + 
           2 Sin[Rational[1, 8] Pi]}, {-1 + 2^Rational[1, 2] + 
           2 Cos[Rational[1, 8] Pi] - 2 Sin[Rational[1, 8] Pi], 2 - 2^
           Rational[1, 2] - 2 Cos[Rational[1, 8] Pi] + 
           2 Sin[Rational[1, 8] Pi]}, {
          2^Rational[1, 2] + 2 Cos[Rational[1, 8] Pi] - 2 
           Sin[Rational[1, 8] Pi], 2 - 2^Rational[1, 2] - 2 
           Cos[Rational[1, 8] Pi] + 2 Sin[Rational[1, 8] Pi]}, {
          2^Rational[1, 2] + 2 Cos[Rational[1, 8] Pi] - Sin[
           Rational[1, 8] Pi], 2 - 2^Rational[1, 2] - Cos[Rational[1, 8] Pi] + 
           2 Sin[Rational[1, 8] Pi]}, {-2^Rational[-1, 2] + 2^Rational[1, 2] + 
           2 Cos[Rational[1, 8] Pi] - Sin[Rational[1, 8] Pi], 2 + 
           2^Rational[-1, 2] - 2^Rational[1, 2] - Cos[Rational[1, 8] Pi] + 
           2 Sin[Rational[1, 8] Pi]}, {-2^Rational[-1, 2] + 2^Rational[1, 2] + 
           2 Cos[Rational[1, 8] Pi], 2 + 2^Rational[-1, 2] - 2^Rational[1, 2] + 
           2 Sin[Rational[1, 8] Pi]}, {
          2 Cos[Rational[1, 8] Pi], 2 + 2 Sin[Rational[1, 8] Pi]}, {
          Cos[Rational[1, 8] Pi], 2 + Sin[Rational[1, 8] Pi]}, {
          Cos[Rational[1, 8] Pi], 1 + Sin[Rational[1, 8] Pi]}, {0, 1}, {0, 
          0}, {Cos[Rational[1, 8] Pi], -Sin[Rational[1, 8] Pi]}, {
          2^Rational[-1, 2] + Cos[Rational[1, 8] Pi], 2^Rational[-1, 2] - Sin[
           Rational[1, 8] Pi]}, {
          2^Rational[-1, 2] + 2 Cos[Rational[1, 8] Pi], 2^Rational[-1, 2] - 2 
           Sin[Rational[1, 8] Pi]}, {
          2^Rational[1, 2] + 2 Cos[Rational[1, 8] Pi], 2^Rational[1, 2] - 2 
           Sin[Rational[1, 8] Pi]}, {
          2^Rational[1, 2] + 2 Cos[Rational[1, 8] Pi] - Sin[
           Rational[1, 8] Pi], 2^Rational[1, 2] + Cos[Rational[1, 8] Pi] - 2 
           Sin[Rational[1, 8] Pi]}, {-1 + 2^Rational[1, 2] + 
           2 Cos[Rational[1, 8] Pi] - Sin[Rational[1, 8] Pi], 
           2^Rational[1, 2] + Cos[Rational[1, 8] Pi] - 2 
           Sin[Rational[1, 8] Pi]}, {-1 + 2^Rational[1, 2] + 
           2 Cos[Rational[1, 8] Pi] - 2 Sin[Rational[1, 8] Pi], 
           2^Rational[1, 2] + 2 Cos[Rational[1, 8] Pi] - 2 
           Sin[Rational[1, 8] Pi]}, {-2 + 2^Rational[1, 2] + 
           2 Cos[Rational[1, 8] Pi] - 2 Sin[Rational[1, 8] Pi], 
           2^Rational[1, 2] + 2 Cos[Rational[1, 8] Pi] - 2 
           Sin[Rational[1, 8] Pi]}, {-2 + 2^Rational[1, 2] + 
           2 Cos[Rational[1, 8] Pi] - 3 Sin[Rational[1, 8] Pi], 
           2^Rational[1, 2] + Cos[Rational[1, 8] Pi] - 2 
           Sin[Rational[1, 8] Pi]}, {-2 + 2^Rational[-1, 2] + 
           2^Rational[1, 2] + 2 Cos[Rational[1, 8] Pi] - 3 
           Sin[Rational[1, 8] Pi], -2^Rational[-1, 2] + 2^Rational[1, 2] + 
           Cos[Rational[1, 8] Pi] - 2 Sin[Rational[1, 8] Pi]}, {-2 + 
           2^Rational[-1, 2] + 2^Rational[1, 2] + 2 Cos[Rational[1, 8] Pi] - 
           4 Sin[Rational[1, 8] Pi], -2^Rational[-1, 2] + 2^Rational[1, 2] - 
           2 Sin[Rational[1, 8] Pi]}, {-2 + 2 2^Rational[1, 2] + 
           2 Cos[Rational[1, 8] Pi] - 4 Sin[Rational[1, 8] Pi], (-2) 
           Sin[Rational[1, 8] Pi]}}, {{
          0.9238795325112867, -0.3826834323650898}, {1.6309863136978342`, 
          0.3244233488214577}, {2.554865846209121, -0.0582600835436321}, {
          3.261972627395669, 0.6488466976429156}, {2.8792891950305792`, 
          1.5727262301542022`}, {1.8792891950305788`, 1.5727262301542022`}, {
          1.496605762665489, 2.496605762665489}, {0.49660576266548895`, 
          2.496605762665489}, {0.11392233030039933`, 1.5727262301542022`}, {
          0.8210291114869468, 0.8656194489676549}, {
          0.43834567912185696`, -0.05826008354363188}, {
          1.1454524603084046`, -0.7653668647301796}, {
          2.0693319928196914`, -0.3826834323650898}, {2.0693319928196914`, 
          0.6173165676349102}, {2.993211525330978, 1}, {
          2.993211525330978, 2}, {2.0693319928196914`, 2.3826834323650896`}, {
          1.3622252116331437`, 1.6755766511785424`}, {0.4383456791218572, 
          2.058260083543632}, {-0.2687611020646905, 1.3511533023570843`}, {
          0.11392233030039933`, 0.4272737698457977}, {1.1139223303003993`, 
          0.4272737698457977}, {1.496605762665489, -0.49660576266548895`}, {
          2.496605762665489, -0.49660576266548895`}, {2.8792891950305792`, 
          0.4272737698457977}, {2.1721824138440313`, 1.1343805510323453`}, {
          2.554865846209121, 2.0582600835436318`}, {1.8477590650225735`, 
          2.7653668647301797`}, {0.9238795325112867, 2.3826834323650896`}, {
          0.9238795325112867, 1.3826834323650898`}, {0, 1}, {0, 0}, {
          0.9238795325112867, -0.3826834323650898}, {1.6309863136978342`, 
          0.3244233488214577}, {2.554865846209121, -0.0582600835436321}, {
          3.261972627395669, 0.6488466976429156}, {2.8792891950305792`, 
          1.5727262301542022`}, {1.8792891950305788`, 1.5727262301542022`}, {
          1.496605762665489, 2.496605762665489}, {0.49660576266548895`, 
          2.496605762665489}, {0.11392233030039933`, 1.5727262301542022`}, {
          0.8210291114869468, 0.8656194489676549}, {
          0.43834567912185696`, -0.05826008354363188}, {
          1.1454524603084046`, -0.7653668647301796}}]]], {972., -189.96465402450826`},
       ImageScaled[{0.5, 0.5}], {360., 356.18372629595297`}], InsetBox[
      GraphicsBox[
       LineBox[NCache[{{Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2] + Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2] + 
           Rational[1, 2] 3^Rational[1, 2]}, {
          1 + Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2] + 
           3^Rational[1, 2]}, {1 - 3^Rational[1, 2], -1 + 3^Rational[1, 2]}, {
          2 - 3^Rational[1, 2], -1 + 3^Rational[1, 2]}, {
          2 + Rational[-3, 2] 3^Rational[1, 2], Rational[-1, 2] + 
           3^Rational[1, 2]}, {
          3 + Rational[-3, 2] 3^Rational[1, 2], Rational[-1, 2] + 
           3^Rational[1, 2]}, {3 - 2 3^Rational[1, 2], 3^Rational[1, 2]}, {
          Rational[7, 2] - 2 3^Rational[1, 2], Rational[1, 2] 
           3^Rational[1, 2]}, {
          Rational[7, 2] - 2 3^Rational[1, 2], 1 + 
           Rational[1, 2] 3^Rational[1, 2]}, {4 - 2 3^Rational[1, 2], 1}, {
          4 - 2 3^Rational[1, 2], 2}, {
          Rational[7, 2] - 2 3^Rational[1, 2], 2 + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[7, 2] + Rational[-3, 2] 3^Rational[1, 2], Rational[5, 2] + 
           Rational[-1, 2] 3^Rational[1, 2]}, {
          3 + Rational[-3, 2] 3^Rational[1, 2], Rational[5, 2] - 3^
           Rational[1, 2]}, {3 - 3^Rational[1, 2], 3 - 3^Rational[1, 2]}, {
          2 - 3^Rational[1, 2], 3 - 3^Rational[1, 2]}, {
          2 + Rational[-1, 2] 3^Rational[1, 2], Rational[5, 2] - 3^
           Rational[1, 2]}, {
          1 + Rational[-1, 2] 3^Rational[1, 2], Rational[5, 2] - 3^
           Rational[1, 2]}, {1, 2 - 3^Rational[1, 2]}, {
          Rational[1, 2], 2 + Rational[-1, 2] 3^Rational[1, 2]}, {
          Rational[1, 2], 1 + Rational[-1, 2] 3^Rational[1, 2]}, {0, 1}, {0, 
          0}, {Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}}, {{0.5, 
          0.8660254037844386}, {-0.3660254037844386, 0.3660254037844386}, {
          0.1339745962155614, 1.2320508075688772`}, {-0.7320508075688772, 
          0.7320508075688772}, {0.2679491924311228, 
          0.7320508075688772}, {-0.598076211353316, 1.2320508075688772`}, {
          0.401923788646684, 1.2320508075688772`}, {-0.4641016151377544, 
          1.7320508075688772`}, {0.035898384862245614`, 0.8660254037844386}, {
          0.035898384862245614`, 1.8660254037844386`}, {
          0.5358983848622456, 1}, {0.5358983848622456, 2}, {
          0.035898384862245614`, 1.1339745962155614`}, {0.901923788646684, 
          1.6339745962155614`}, {0.401923788646684, 0.7679491924311228}, {
          1.2679491924311228`, 1.2679491924311228`}, {0.2679491924311228, 
          1.2679491924311228`}, {1.1339745962155614`, 0.7679491924311228}, {
          0.1339745962155614, 0.7679491924311228}, {1, 0.2679491924311228}, {
          0.5, 1.1339745962155614`}, {0.5, 0.1339745962155614}, {0, 1}, {0, 
          0}, {0.5, 0.8660254037844386}}]]], {1360.8000000000002`, -189.96465402450826`},
       ImageScaled[{0.5, 0.5}], {359.9999999999998, 356.18372629595297`}]}, {
     InsetBox[
      GraphicsBox[
       LineBox[NCache[{{
          Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
            Rational[-1, 8] 5^Rational[1, 2])^
           Rational[
            1, 2]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + 
           Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
             Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           Rational[1, 4] (-1 + 
             5^Rational[1, 2])}, {-(Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           Rational[1, 2] (1 + 5^Rational[1, 2]), 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + 
           Rational[1, 4] (-1 + 
             5^Rational[1, 2])}, {(-2) (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           Rational[1, 2] (1 + 5^Rational[1, 2]), 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + 
           Rational[1, 2] (-1 + 
             5^Rational[1, 2])}, {(-2) (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           Rational[1, 4] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]), 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - (Rational[5, 8] + 
            Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2])}, {(Rational[5, 8] + 
             Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 4] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]), 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - (Rational[5, 8] + 
            Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 4] (1 + 5^Rational[1, 2])}, {(Rational[5, 8] + 
             Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]), 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 4] (1 + 5^Rational[1, 2])}, {
          2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]), 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-1 + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]), 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-1 + 
           3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]), 
           Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-2 + 
           3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]), 
           Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-2 + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]), 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-2 + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[3, 4] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]), 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - (Rational[5, 8] + 
            Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-2 + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[3, 4] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]), 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 4] (1 - 5^Rational[1, 2]) + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - (Rational[5, 8] + 
            Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-3 + 5^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]), 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 4] (1 - 5^Rational[1, 2]) + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-3 + 5^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 2] (1 + 5^Rational[1, 2]), 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-3 + 5^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[3, 4] (1 + 5^Rational[1, 2]), 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
             Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-3 + 5^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[3, 4] (1 + 5^Rational[1, 2]), 1 + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
             Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-2 + 2 5^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2], 1 + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-2 + 2 5^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2], 2 + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-2 + 2 5^Rational[1, 2] + 
           Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2], 2 + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) - (Rational[5, 8] + 
            Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-2 + 2 5^Rational[1, 2] + 
           Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2], 2 + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[3, 4] (1 - 5^Rational[1, 2]) - (Rational[5, 8] + 
            Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-2 + 2 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2], 2 + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[3, 4] (1 - 5^Rational[1, 2]) - 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-2 + 2 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2], 3 - 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) - 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-2 + 2 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 4] (1 - 5^Rational[1, 2]) + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2], 3 - 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) - 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + (Rational[5, 8] + 
             Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-2 + 2 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 4] (1 - 5^Rational[1, 2]) + 
           3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2], 3 - 5^Rational[1, 2] + 
           Rational[3, 4] (-1 - 5^Rational[1, 2]) - 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + (Rational[5, 8] + 
             Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-2 + 2 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2], 3 - 5^Rational[1, 2] + 
           Rational[3, 4] (-1 - 5^Rational[1, 2]) - 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-2 + 2 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2], 2 - 2 5^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-1 + 2 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2], 2 - 2 5^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {-1 + 2 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
             Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2], 2 - 2 5^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[3, 4] (1 + 5^Rational[1, 2])}, {
          2 5^Rational[1, 2] + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + (Rational[5, 8] + 
             Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2], 2 - 2 5^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[3, 4] (1 + 5^Rational[1, 2])}, {
          2 5^Rational[1, 2] + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2], 3 - 5^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2])}, {
          2 5^Rational[1, 2] + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[3, 4] (1 - 5^Rational[1, 2]) - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2], 3 - 5^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + (Rational[5, 8] + 
             Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2])}, {
          2 5^Rational[1, 2] + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[3, 4] (1 - 5^Rational[1, 2]) - (Rational[5, 8] + 
            Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 3 - 5^
           Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + (Rational[5, 8] + 
             Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           Rational[3, 4] (-1 + 5^Rational[1, 2])}, {
          1 + 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) - (Rational[5, 8] + 
            Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 3 - 5^
           Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + Rational[3, 4] (-1 + 5^Rational[1, 2])}, {
          1 + 5^Rational[1, 2] + Rational[1, 2] (-1 - 5^Rational[1, 2]), 2 - 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
            Rational[1, 2]}, {
          1 + 5^Rational[1, 2] + Rational[3, 4] (-1 - 5^Rational[1, 2]), 
           2 - (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
           Rational[1, 2]}, {
          1 + 5^Rational[1, 2] + Rational[3, 4] (-1 - 5^Rational[1, 2]), 
           1 - (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
           Rational[1, 2]}, {0, 1}, {0, 
          0}, {-1 - 5^Rational[1, 2] + 
           Rational[5, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
            Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{
          0.8090169943749475, 0.5877852522924731}, {-0.14203952192020608`, 
          0.8968022466674206}, {0.6669774724547414, 
          1.4845874989598937`}, {-0.28407904384041216`, 
          1.7936044933348412`}, {0.02493795053453529, 0.8425479770396876}, {
          0.6127232028270084, 1.651564971414635}, {0.9217401972019559, 
          0.7005084551194816}, {1.509525449494429, 1.509525449494429}, {
          0.509525449494429, 1.509525449494429}, {1.0973107017869022`, 
          0.7005084551194816}, {0.09731070178690215, 0.7005084551194816}, {
          0.6850959540793753, -0.10850853925546566`}, {0.9941129484543227, 
          0.8425479770396875}, {0.04305643215916932, 0.5335309826647401}, {
          0.3520734265341168, 1.4845874989598937`}, {-0.5989830897610369, 
          1.1755705045849463`}, {0.21003390461391058`, 0.5877852522924731}, {
          0.21003390461391058`, 1.5877852522924734`}, {1.019050898988858, 
          1.}, {1.019050898988858, 2.}, {0.21003390461391058`, 
          1.4122147477075269`}, {1.1610904209090642`, 1.1031977533325794`}, {
          0.3520734265341168, 0.5154125010401063}, {1.3031299428292702`, 
          0.20639550666515882`}, {0.9941129484543227, 1.1574520229603125`}, {
          0.4063276961618496, 0.348435028585365}, {0.09731070178690215, 
          1.2994915448805187`}, {-0.490474550505571, 0.4904745505055712}, {
          0.509525449494429, 0.4904745505055712}, {-0.07825980279804412, 
          1.2994915448805187`}, {0.9217401972019559, 1.2994915448805187`}, {
          0.3339549449094825, 2.108508539255466}, {0.02493795053453507, 
          1.1574520229603125`}, {0.9759944668296887, 1.46646901733526}, {
          0.6669774724547413, 0.5154125010401063}, {1.618033988749895, 
          0.8244294954150537}, {0.8090169943749475, 1.4122147477075269`}, {
          0.8090169943749475, 0.41221474770752686`}, {0, 1}, {0, 0}, {
          0.8090169943749475, 0.5877852522924731}}]]], {194.4, -569.8939620735248},
       ImageScaled[{0.5, 0.5}], {360.00000000000006`, 356.18372629595297`}], 
     InsetBox[
      GraphicsBox[
       LineBox[NCache[{{
          Sin[Rational[2, 9] Pi], Cos[
           Rational[2, 9] Pi]}, {-Cos[Rational[1, 18] Pi] + 
           Sin[Rational[2, 9] Pi], Cos[Rational[2, 9] Pi] - Sin[
           Rational[1, 18] Pi]}, {-Cos[Rational[1, 18] Pi] + 
           2 Sin[Rational[2, 9] Pi], 2 Cos[Rational[2, 9] Pi] - Sin[
           Rational[1, 18] Pi]}, {(-2) Cos[Rational[1, 18] Pi] + 
           2 Sin[Rational[2, 9] Pi], 2 Cos[Rational[2, 9] Pi] - 2 
           Sin[Rational[1, 18] Pi]}, {
          Rational[1, 2] 3^Rational[1, 2] - 2 Cos[Rational[1, 18] Pi] + 
           2 Sin[Rational[2, 9] Pi], Rational[-1, 2] + 
           2 Cos[Rational[2, 9] Pi] - 2 Sin[Rational[1, 18] Pi]}, {
          Rational[1, 2] 3^Rational[1, 2] - 2 Cos[Rational[1, 18] Pi] - Sin[
           Rational[1, 9] Pi] + 2 Sin[Rational[2, 9] Pi], Rational[-1, 2] + 
           Cos[Rational[1, 9] Pi] + 2 Cos[Rational[2, 9] Pi] - 2 
           Sin[Rational[1, 18] Pi]}, {
          3^Rational[1, 2] - 2 Cos[Rational[1, 18] Pi] - Sin[
           Rational[1, 9] Pi] + 2 Sin[Rational[2, 9] Pi], -1 + 
           Cos[Rational[1, 9] Pi] + 2 Cos[Rational[2, 9] Pi] - 2 
           Sin[Rational[1, 18] Pi]}, {
          3^Rational[1, 2] - 2 Cos[Rational[1, 18] Pi] - 2 
           Sin[Rational[1, 9] Pi] + 2 Sin[Rational[2, 9] Pi], -1 + 
           2 Cos[Rational[1, 9] Pi] + 2 Cos[Rational[2, 9] Pi] - 2 
           Sin[Rational[1, 18] Pi]}, {
          3^Rational[1, 2] - 2 Cos[Rational[1, 18] Pi] - 3 
           Sin[Rational[1, 9] Pi] + 2 Sin[Rational[2, 9] Pi], -1 + 
           Cos[Rational[1, 9] Pi] + 2 Cos[Rational[2, 9] Pi] - 2 
           Sin[Rational[1, 18] Pi]}, {
          Rational[3, 2] 3^Rational[1, 2] - 2 Cos[Rational[1, 18] Pi] - 3 
           Sin[Rational[1, 9] Pi] + 2 Sin[Rational[2, 9] Pi], Rational[-1, 2] + 
           Cos[Rational[1, 9] Pi] + 2 Cos[Rational[2, 9] Pi] - 2 
           Sin[Rational[1, 18] Pi]}, {
          Rational[3, 2] 3^Rational[1, 2] - 2 Cos[Rational[1, 18] Pi] - 4 
           Sin[Rational[1, 9] Pi] + 2 Sin[Rational[2, 9] Pi], Rational[-1, 2] + 
           2 Cos[Rational[2, 9] Pi] - 2 Sin[Rational[1, 18] Pi]}, {
          2 3^Rational[1, 2] - 2 Cos[Rational[1, 18] Pi] - 4 
           Sin[Rational[1, 9] Pi] + 2 Sin[Rational[2, 9] Pi], 
           2 Cos[Rational[2, 9] Pi] - 2 Sin[Rational[1, 18] Pi]}, {
          2 3^Rational[1, 2] - 3 Cos[Rational[1, 18] Pi] - 4 
           Sin[Rational[1, 9] Pi] + 2 Sin[Rational[2, 9] Pi], 
           2 Cos[Rational[2, 9] Pi] - Sin[Rational[1, 18] Pi]}, {
          2 3^Rational[1, 2] - 3 Cos[Rational[1, 18] Pi] - 4 
           Sin[Rational[1, 9] Pi] + 3 Sin[Rational[2, 9] Pi], 
           Cos[Rational[2, 9] Pi] - Sin[Rational[1, 18] Pi]}, {
          2 3^Rational[1, 2] - 4 Cos[Rational[1, 18] Pi] - 4 
           Sin[Rational[1, 9] Pi] + 3 Sin[Rational[2, 9] Pi], Cos[
           Rational[2, 9] Pi]}, {
          2 3^Rational[1, 2] - 4 Cos[Rational[1, 18] Pi] - 4 
           Sin[Rational[1, 9] Pi] + 4 Sin[Rational[2, 9] Pi], 0}, {
          2 3^Rational[1, 2] - 4 Cos[Rational[1, 18] Pi] - 4 
           Sin[Rational[1, 9] Pi] + 4 Sin[Rational[2, 9] Pi], 1}, {
          2 3^Rational[1, 2] - 4 Cos[Rational[1, 18] Pi] - 4 
           Sin[Rational[1, 9] Pi] + 3 Sin[Rational[2, 9] Pi], 1 - Cos[
           Rational[2, 9] Pi]}, {
          2 3^Rational[1, 2] - 4 Cos[Rational[1, 18] Pi] - 4 
           Sin[Rational[1, 9] Pi] + 3 Sin[Rational[2, 9] Pi], 2 - Cos[
           Rational[2, 9] Pi]}, {
          2 3^Rational[1, 2] - 4 Cos[Rational[1, 18] Pi] - 4 
           Sin[Rational[1, 9] Pi] + 2 Sin[Rational[2, 9] Pi], 2 - 2 
           Cos[Rational[2, 9] Pi]}, {
          2 3^Rational[1, 2] - 3 Cos[Rational[1, 18] Pi] - 4 
           Sin[Rational[1, 9] Pi] + 2 Sin[Rational[2, 9] Pi], 2 - 2 
           Cos[Rational[2, 9] Pi] + Sin[Rational[1, 18] Pi]}, {
          Rational[3, 2] 3^Rational[1, 2] - 3 Cos[Rational[1, 18] Pi] - 4 
           Sin[Rational[1, 9] Pi] + 2 Sin[Rational[2, 9] Pi], Rational[5, 2] - 
           2 Cos[Rational[2, 9] Pi] + Sin[Rational[1, 18] Pi]}, {
          Rational[3, 2] 3^Rational[1, 2] - 2 Cos[Rational[1, 18] Pi] - 4 
           Sin[Rational[1, 9] Pi] + 2 Sin[Rational[2, 9] Pi], Rational[5, 2] - 
           2 Cos[Rational[2, 9] Pi] + 2 Sin[Rational[1, 18] Pi]}, {
          3^Rational[1, 2] - 2 Cos[Rational[1, 18] Pi] - 4 
           Sin[Rational[1, 9] Pi] + 2 Sin[Rational[2, 9] Pi], 3 - 2 
           Cos[Rational[2, 9] Pi] + 2 Sin[Rational[1, 18] Pi]}, {
          3^Rational[1, 2] - 2 Cos[Rational[1, 18] Pi] - 3 
           Sin[Rational[1, 9] Pi] + 2 Sin[Rational[2, 9] Pi], 3 - Cos[
           Rational[1, 9] Pi] - 2 Cos[Rational[2, 9] Pi] + 
           2 Sin[Rational[1, 18] Pi]}, {
          3^Rational[1, 2] - 2 Cos[Rational[1, 18] Pi] - 2 
           Sin[Rational[1, 9] Pi] + 2 Sin[Rational[2, 9] Pi], 3 - 2 
           Cos[Rational[2, 9] Pi] + 2 Sin[Rational[1, 18] Pi]}, {
          3^Rational[1, 2] - 2 Cos[Rational[1, 18] Pi] - Sin[
           Rational[1, 9] Pi] + 2 Sin[Rational[2, 9] Pi], 3 - Cos[
           Rational[1, 9] Pi] - 2 Cos[Rational[2, 9] Pi] + 
           2 Sin[Rational[1, 18] Pi]}, {
          3^Rational[1, 2] - 2 Cos[Rational[1, 18] Pi] + 
           2 Sin[Rational[2, 9] Pi], 3 - 2 Cos[Rational[2, 9] Pi] + 
           2 Sin[Rational[1, 18] Pi]}, {
          Rational[1, 2] 3^Rational[1, 2] - 2 Cos[Rational[1, 18] Pi] + 
           2 Sin[Rational[2, 9] Pi], Rational[5, 2] - 2 
           Cos[Rational[2, 9] Pi] + 2 Sin[Rational[1, 18] Pi]}, {
          Rational[1, 2] 3^Rational[1, 2] - Cos[Rational[1, 18] Pi] + 
           2 Sin[Rational[2, 9] Pi], Rational[5, 2] - 2 
           Cos[Rational[2, 9] Pi] + 
           Sin[Rational[1, 18] Pi]}, {-Cos[Rational[1, 18] Pi] + 
           2 Sin[Rational[2, 9] Pi], 2 - 2 Cos[Rational[2, 9] Pi] + 
           Sin[Rational[1, 18] Pi]}, {
          2 Sin[Rational[2, 9] Pi], 2 - 2 Cos[Rational[2, 9] Pi]}, {
          Sin[Rational[2, 9] Pi], 2 - Cos[Rational[2, 9] Pi]}, {
          Sin[Rational[2, 9] Pi], 1 - Cos[Rational[2, 9] Pi]}, {0, 1}, {0, 
          0}, {Sin[Rational[2, 9] Pi], Cos[Rational[2, 9] Pi]}}, {{
          0.6427876096865393, 0.7660444431189781}, {-0.34202014332566877`, 
          0.5923962654520478}, {0.3007674663608705, 
          1.358440708571026}, {-0.6840402866513375, 1.1847925309040956`}, {
          0.18198511713310106`, 0.6847925309040956}, {-0.1600350261925676, 
          1.624485151690004}, {0.705990377591871, 1.124485151690004}, {
          0.36397023426620223`, 2.0641777724759125`}, {0.021950090940533462`, 
          1.124485151690004}, {0.8879754947249723, 1.624485151690004}, {
          0.5459553513993036, 0.6847925309040956}, {1.411980755183742, 
          1.1847925309040956`}, {0.4271730021715341, 1.358440708571026}, {
          1.0699606118580733`, 0.5923962654520478}, {0.08515285884586521, 
          0.7660444431189781}, {0.7279404685324045, 0}, {
          0.7279404685324045, 1}, {0.08515285884586521, 
          0.23395555688102188`}, {0.08515285884586521, 
          1.2339555568810219`}, {-0.557634750840674, 0.46791111376204375`}, {
          0.4271730021715341, 0.641559291428974}, {-0.4388524016129043, 
          1.141559291428974}, {0.5459553513993036, 
          1.3152074690959044`}, {-0.3200700523851352, 1.8152074690959044`}, {
          0.021950090940533462`, 0.8755148483099959}, {0.36397023426620223`, 
          1.8152074690959044`}, {0.705990377591871, 0.8755148483099959}, {
          1.0480105209175397`, 1.8152074690959044`}, {0.18198511713310106`, 
          1.3152074690959044`}, {1.1667928701453092`, 1.141559291428974}, {
          0.3007674663608705, 0.641559291428974}, {1.2855752193730785`, 
          0.46791111376204375`}, {0.6427876096865393, 1.2339555568810219`}, {
          0.6427876096865393, 0.23395555688102188`}, {0, 1}, {0, 0}, {
          0.6427876096865393, 0.7660444431189781}}]]], {583.2, -569.8939620735248},
       ImageScaled[{0.5, 0.5}], {360.00000000000006`, 356.18372629595297`}], 
     InsetBox[
      GraphicsBox[
       LineBox[NCache[{{Cos[Rational[1, 18] Pi], Sin[Rational[1, 18] Pi]}, {
          Cos[Rational[1, 18] Pi] - Sin[Rational[1, 9] Pi], 
           Cos[Rational[1, 9] Pi] + Sin[Rational[1, 18] Pi]}, {
          2 Cos[Rational[1, 18] Pi] - Sin[Rational[1, 9] Pi], 
           Cos[Rational[1, 9] Pi] + 2 Sin[Rational[1, 18] Pi]}, {
          2 Cos[Rational[1, 18] Pi] - 2 Sin[Rational[1, 9] Pi], 
           2 Cos[Rational[1, 9] Pi] + 2 Sin[Rational[1, 18] Pi]}, {
          Rational[-1, 2] 3^Rational[1, 2] + 2 Cos[Rational[1, 18] Pi] - 2 
           Sin[Rational[1, 9] Pi], Rational[-1, 2] + 2 Cos[Rational[1, 9] Pi] + 
           2 Sin[Rational[1, 18] Pi]}, {
          Rational[-1, 2] 3^Rational[1, 2] + 2 Cos[Rational[1, 18] Pi] - 2 
           Sin[Rational[1, 9] Pi] + Sin[Rational[2, 9] Pi], Rational[-1, 2] + 
           2 Cos[Rational[1, 9] Pi] - Cos[Rational[2, 9] Pi] + 
           2 Sin[Rational[1, 18] Pi]}, {-3^Rational[1, 2] + 
           2 Cos[Rational[1, 18] Pi] - 2 Sin[Rational[1, 9] Pi] + 
           Sin[Rational[2, 9] Pi], -1 + 2 Cos[Rational[1, 9] Pi] - Cos[
           Rational[2, 9] Pi] + 
           2 Sin[Rational[1, 18] Pi]}, {-3^Rational[1, 2] + 
           2 Cos[Rational[1, 18] Pi] - 2 Sin[Rational[1, 9] Pi] + 
           2 Sin[Rational[2, 9] Pi], -1 + 2 Cos[Rational[1, 9] Pi] - 2 
           Cos[Rational[2, 9] Pi] + 
           2 Sin[Rational[1, 18] Pi]}, {-3^Rational[1, 2] + 
           2 Cos[Rational[1, 18] Pi] - 2 Sin[Rational[1, 9] Pi] + 
           3 Sin[Rational[2, 9] Pi], -1 + 2 Cos[Rational[1, 9] Pi] - Cos[
           Rational[2, 9] Pi] + 2 Sin[Rational[1, 18] Pi]}, {
          Rational[-3, 2] 3^Rational[1, 2] + 2 Cos[Rational[1, 18] Pi] - 2 
           Sin[Rational[1, 9] Pi] + 3 Sin[Rational[2, 9] Pi], Rational[-1, 2] + 
           2 Cos[Rational[1, 9] Pi] - Cos[Rational[2, 9] Pi] + 
           2 Sin[Rational[1, 18] Pi]}, {
          Rational[-3, 2] 3^Rational[1, 2] + 2 Cos[Rational[1, 18] Pi] - 2 
           Sin[Rational[1, 9] Pi] + 4 Sin[Rational[2, 9] Pi], Rational[-1, 2] + 
           2 Cos[Rational[1, 9] Pi] + 
           2 Sin[Rational[1, 18] Pi]}, {(-2) 3^Rational[1, 2] + 
           2 Cos[Rational[1, 18] Pi] - 2 Sin[Rational[1, 9] Pi] + 
           4 Sin[Rational[2, 9] Pi], 2 Cos[Rational[1, 9] Pi] + 
           2 Sin[Rational[1, 18] Pi]}, {(-2) 3^Rational[1, 2] + 
           2 Cos[Rational[1, 18] Pi] - 3 Sin[Rational[1, 9] Pi] + 
           4 Sin[Rational[2, 9] Pi], Cos[Rational[1, 9] Pi] + 
           2 Sin[Rational[1, 18] Pi]}, {(-2) 3^Rational[1, 2] + 
           3 Cos[Rational[1, 18] Pi] - 3 Sin[Rational[1, 9] Pi] + 
           4 Sin[Rational[2, 9] Pi], Cos[Rational[1, 9] Pi] + 
           Sin[Rational[1, 18] Pi]}, {(-2) 3^Rational[1, 2] + 
           3 Cos[Rational[1, 18] Pi] - 4 Sin[Rational[1, 9] Pi] + 
           4 Sin[Rational[2, 9] Pi], Sin[
           Rational[1, 18] Pi]}, {(-2) 3^Rational[1, 2] + 
           4 Cos[Rational[1, 18] Pi] - 4 Sin[Rational[1, 9] Pi] + 
           4 Sin[Rational[2, 9] Pi], 0}, {(-2) 3^Rational[1, 2] + 
           4 Cos[Rational[1, 18] Pi] - 4 Sin[Rational[1, 9] Pi] + 
           4 Sin[Rational[2, 9] Pi], 1}, {(-2) 3^Rational[1, 2] + 
           3 Cos[Rational[1, 18] Pi] - 4 Sin[Rational[1, 9] Pi] + 
           4 Sin[Rational[2, 9] Pi], 1 - Sin[
           Rational[1, 18] Pi]}, {(-2) 3^Rational[1, 2] + 
           3 Cos[Rational[1, 18] Pi] - 4 Sin[Rational[1, 9] Pi] + 
           4 Sin[Rational[2, 9] Pi], 2 - Sin[
           Rational[1, 18] Pi]}, {(-2) 3^Rational[1, 2] + 
           2 Cos[Rational[1, 18] Pi] - 4 Sin[Rational[1, 9] Pi] + 
           4 Sin[Rational[2, 9] Pi], 2 - 2 
           Sin[Rational[1, 18] Pi]}, {(-2) 3^Rational[1, 2] + 
           2 Cos[Rational[1, 18] Pi] - 3 Sin[Rational[1, 9] Pi] + 
           4 Sin[Rational[2, 9] Pi], 2 - Cos[Rational[1, 9] Pi] - 2 
           Sin[Rational[1, 18] Pi]}, {
          Rational[-3, 2] 3^Rational[1, 2] + 2 Cos[Rational[1, 18] Pi] - 3 
           Sin[Rational[1, 9] Pi] + 4 Sin[Rational[2, 9] Pi], Rational[5, 2] - 
           Cos[Rational[1, 9] Pi] - 2 Sin[Rational[1, 18] Pi]}, {
          Rational[-3, 2] 3^Rational[1, 2] + 2 Cos[Rational[1, 18] Pi] - 2 
           Sin[Rational[1, 9] Pi] + 4 Sin[Rational[2, 9] Pi], Rational[5, 2] - 
           2 Cos[Rational[1, 9] Pi] - 2 
           Sin[Rational[1, 18] Pi]}, {-3^Rational[1, 2] + 
           2 Cos[Rational[1, 18] Pi] - 2 Sin[Rational[1, 9] Pi] + 
           4 Sin[Rational[2, 9] Pi], 3 - 2 Cos[Rational[1, 9] Pi] - 2 
           Sin[Rational[1, 18] Pi]}, {-3^Rational[1, 2] + 
           2 Cos[Rational[1, 18] Pi] - 2 Sin[Rational[1, 9] Pi] + 
           3 Sin[Rational[2, 9] Pi], 3 - 2 Cos[Rational[1, 9] Pi] + 
           Cos[Rational[2, 9] Pi] - 2 
           Sin[Rational[1, 18] Pi]}, {-3^Rational[1, 2] + 
           2 Cos[Rational[1, 18] Pi] - 2 Sin[Rational[1, 9] Pi] + 
           2 Sin[Rational[2, 9] Pi], 3 - 2 Cos[Rational[1, 9] Pi] - 2 
           Sin[Rational[1, 18] Pi]}, {-3^Rational[1, 2] + 
           2 Cos[Rational[1, 18] Pi] - 2 Sin[Rational[1, 9] Pi] + 
           Sin[Rational[2, 9] Pi], 3 - 2 Cos[Rational[1, 9] Pi] + 
           Cos[Rational[2, 9] Pi] - 2 
           Sin[Rational[1, 18] Pi]}, {-3^Rational[1, 2] + 
           2 Cos[Rational[1, 18] Pi] - 2 Sin[Rational[1, 9] Pi], 3 - 2 
           Cos[Rational[1, 9] Pi] - 2 Sin[Rational[1, 18] Pi]}, {
          Rational[-1, 2] 3^Rational[1, 2] + 2 Cos[Rational[1, 18] Pi] - 2 
           Sin[Rational[1, 9] Pi], Rational[5, 2] - 2 Cos[Rational[1, 9] Pi] - 
           2 Sin[Rational[1, 18] Pi]}, {
          Rational[-1, 2] 3^Rational[1, 2] + 2 Cos[Rational[1, 18] Pi] - Sin[
           Rational[1, 9] Pi], Rational[5, 2] - Cos[Rational[1, 9] Pi] - 2 
           Sin[Rational[1, 18] Pi]}, {
          2 Cos[Rational[1, 18] Pi] - Sin[Rational[1, 9] Pi], 2 - Cos[
           Rational[1, 9] Pi] - 2 Sin[Rational[1, 18] Pi]}, {
          2 Cos[Rational[1, 18] Pi], 2 - 2 Sin[Rational[1, 18] Pi]}, {
          Cos[Rational[1, 18] Pi], 2 - Sin[Rational[1, 18] Pi]}, {
          Cos[Rational[1, 18] Pi], 1 - Sin[Rational[1, 18] Pi]}, {0, 1}, {0, 
          0}, {Cos[Rational[1, 18] Pi], Sin[Rational[1, 18] Pi]}}, {{
          0.984807753012208, 0.17364817766693033`}, {0.6427876096865393, 
          1.1133407984528387`}, {1.6275953626987474`, 1.286988976119769}, {
          1.2855752193730785`, 2.2266815969056775`}, {0.41954981558864, 
          1.7266815969056775`}, {1.0623374252751794`, 0.9606371537866993}, {
          0.19631202149074067`, 0.4606371537866994}, {
          0.8390996311772799, -0.3054072893322788}, {1.4818872408638193`, 
          0.4606371537866994}, {0.6158618370793805, 0.9606371537866993}, {
          1.2586494467659197`, 1.7266815969056775`}, {0.39262404298148135`, 
          2.2266815969056775`}, {0.05060389965581247, 1.286988976119769}, {
          1.0354116526680204`, 1.1133407984528387`}, {0.6933915093423517, 
          0.17364817766693033`}, {1.6781992623545599`, 0}, {
          1.6781992623545599`, 1}, {0.6933915093423517, 0.8263518223330697}, {
          0.6933915093423517, 1.8263518223330697`}, {-0.2914162436698562, 
          1.6527036446661394`}, {0.05060389965581247, 0.713011023880231}, {
          0.9166293034402508, 1.213011023880231}, {1.2586494467659197`, 
          0.2733184030943225}, {2.1246748505503588`, 0.7733184030943225}, {
          1.4818872408638193`, 1.5393628462133007`}, {0.8390996311772799, 
          0.7733184030943225}, {0.19631202149074067`, 
          1.5393628462133007`}, {-0.4464755881957986, 0.7733184030943225}, {
          0.41954981558864, 0.2733184030943225}, {0.7615699589143088, 
          1.213011023880231}, {1.6275953626987474`, 0.713011023880231}, {
          1.969615506024416, 1.6527036446661394`}, {0.984807753012208, 
          1.8263518223330697`}, {0.984807753012208, 0.8263518223330697}, {0, 
          1}, {0, 0}, {0.984807753012208, 0.17364817766693033`}}]]], {972., -569.8939620735248},
       ImageScaled[{0.5, 0.5}], {360., 356.18372629595297`}], InsetBox[
      GraphicsBox[
       LineBox[NCache[{{0, 0}, {
          Cos[Rational[1, 30] Pi], -Sin[Rational[1, 30] Pi]}, {
          Cos[Rational[1, 30] Pi] + Sin[Rational[1, 15] Pi], 
           Cos[Rational[1, 15] Pi] - Sin[Rational[1, 30] Pi]}, {
          2 Cos[Rational[1, 30] Pi] + Sin[Rational[1, 15] Pi], 
           Cos[Rational[1, 15] Pi] - 2 Sin[Rational[1, 30] Pi]}, {
          2 Cos[Rational[1, 30] Pi] + 2 Sin[Rational[1, 15] Pi], 
           2 Cos[Rational[1, 15] Pi] - 2 
           Sin[Rational[1, 30] 
             Pi]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] + 
           2 Sin[Rational[1, 15] Pi], Rational[1, 4] (-1 + 5^Rational[1, 2]) + 
           2 Cos[Rational[1, 15] Pi] - 2 
           Sin[Rational[1, 30] 
             Pi]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] + 
           2 Sin[Rational[1, 15] Pi] - Sin[Rational[2, 15] Pi], 
           Rational[1, 4] (-1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           Cos[Rational[2, 15] Pi] - 2 
           Sin[Rational[1, 30] 
             Pi]}, {(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] + 
           2 Sin[Rational[1, 15] Pi] - Sin[Rational[2, 15] Pi], 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           Cos[Rational[2, 15] Pi] - 2 
           Sin[Rational[1, 30] 
             Pi]}, {(-2) (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
             Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] + 
           2 Sin[Rational[1, 15] Pi] - 2 Sin[Rational[2, 15] Pi], 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           2 Cos[Rational[2, 15] Pi] - 2 Sin[Rational[1, 30] Pi]}, {
          Rational[1, 2] 3^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] + 
           2 Sin[Rational[1, 15] Pi] - 2 Sin[Rational[2, 15] Pi], 
           Rational[-1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           2 Cos[Rational[1, 15] Pi] - 2 Cos[Rational[2, 15] Pi] - 2 
           Sin[Rational[1, 30] Pi]}, {
          Rational[1, 2] 
            3^Rational[1, 2] + (Rational[5, 8] + 
             Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] + 
           2 Sin[Rational[1, 15] Pi] - 2 Sin[Rational[2, 15] Pi], 
           Rational[-1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           2 Cos[Rational[2, 15] Pi] - 2 Sin[Rational[1, 30] Pi]}, {
          3^Rational[1, 2] + (Rational[5, 8] + 
             Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] + 
           2 Sin[Rational[1, 15] Pi] - 2 Sin[Rational[2, 15] Pi], -1 + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 4] (1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           2 Cos[Rational[2, 15] Pi] - 2 Sin[Rational[1, 30] Pi]}, {
          3^Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] + 
           2 Sin[Rational[1, 15] Pi] - 2 Sin[Rational[2, 15] Pi], -1 + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           2 Cos[Rational[2, 15] Pi] - 2 Sin[Rational[1, 30] Pi]}, {
          3^Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - Cos[
           Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 2 
           Sin[Rational[2, 15] Pi], -1 + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           2 Cos[Rational[2, 15] Pi] - 2 Sin[Rational[1, 30] Pi] + 
           Sin[Rational[7, 30] Pi]}, {
          3^Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 2 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 2 
           Sin[Rational[2, 15] Pi], -1 + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           2 Cos[Rational[2, 15] Pi] - 2 Sin[Rational[1, 30] Pi]}, {
          3^Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 3 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 2 
           Sin[Rational[2, 15] Pi], -1 + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           2 Cos[Rational[2, 15] Pi] - 2 Sin[Rational[1, 30] Pi] + 
           Sin[Rational[7, 30] Pi]}, {
          3^Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 2 
           Sin[Rational[2, 15] Pi], -1 + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           2 Cos[Rational[2, 15] Pi] - 2 Sin[Rational[1, 30] Pi]}, {
          3^Rational[1, 2] + 
           3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 2 
           Sin[Rational[2, 15] Pi], -1 + 
           Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           2 Cos[Rational[2, 15] Pi] - 2 Sin[Rational[1, 30] Pi]}, {
          Rational[3, 2] 3^Rational[1, 2] + 
           3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 2 
           Sin[Rational[2, 15] Pi], Rational[-1, 2] + 
           Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           2 Cos[Rational[2, 15] Pi] - 2 Sin[Rational[1, 30] Pi]}, {
          Rational[3, 2] 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 2 
           Sin[Rational[2, 15] Pi], Rational[-1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           2 Cos[Rational[2, 15] Pi] - 2 Sin[Rational[1, 30] Pi]}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 2 
           Sin[Rational[2, 15] Pi], Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           2 Cos[Rational[2, 15] Pi] - 2 Sin[Rational[1, 30] Pi]}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 3 
           Sin[Rational[2, 15] Pi], Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           Cos[Rational[2, 15] Pi] - 2 Sin[Rational[1, 30] Pi]}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 3 
           Sin[Rational[2, 15] Pi], Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 4] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           Cos[Rational[2, 15] Pi] - 2 Sin[Rational[1, 30] Pi]}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 4 
           Sin[Rational[2, 15] Pi], Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 4] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           2 Sin[Rational[1, 30] Pi]}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 4 
           Sin[Rational[2, 15] Pi], Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + 2 Cos[Rational[1, 15] Pi] - 
           2 Sin[Rational[1, 30] Pi]}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 3 Sin[Rational[1, 15] Pi] - 4 
           Sin[Rational[2, 15] Pi], Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Rational[1, 15] Pi] - 
           2 Sin[Rational[1, 30] Pi]}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 3 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 3 Sin[Rational[1, 15] Pi] - 4 
           Sin[Rational[2, 15] Pi], Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + Cos[Rational[1, 15] Pi] - 
           Sin[Rational[1, 30] Pi]}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 3 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 4 Sin[Rational[1, 15] Pi] - 4 
           Sin[Rational[2, 15] Pi], Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) - Sin[Rational[1, 30] Pi]}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 4 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 4 Sin[Rational[1, 15] Pi] - 4 
           Sin[Rational[2, 15] Pi], Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 4 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 4 Sin[Rational[1, 15] Pi] - 4 
           Sin[Rational[2, 15] Pi], 1 + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2])}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 3 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 4 Sin[Rational[1, 15] Pi] - 4 
           Sin[Rational[2, 15] Pi], 1 + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + Sin[Rational[1, 30] Pi]}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 3 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 4 Sin[Rational[1, 15] Pi] - 4 
           Sin[Rational[2, 15] Pi], 2 + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + Sin[Rational[1, 30] Pi]}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 4 Sin[Rational[1, 15] Pi] - 4 
           Sin[Rational[2, 15] Pi], 2 + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) + 
           2 Sin[Rational[1, 30] Pi]}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 3 Sin[Rational[1, 15] Pi] - 4 
           Sin[Rational[2, 15] Pi], 2 + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[Rational[1, 15] Pi] + 
           2 Sin[Rational[1, 30] Pi]}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 3 Sin[Rational[1, 15] Pi] - 4 
           Sin[Rational[2, 15] Pi], 2 + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[3, 4] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) - Cos[Rational[1, 15] Pi] + 
           2 Sin[Rational[1, 30] Pi]}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 4 
           Sin[Rational[2, 15] Pi], 2 + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[3, 4] (1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 Cos[Rational[1, 15] Pi] + 
           2 Sin[Rational[1, 30] Pi]}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 4 
           Sin[Rational[2, 15] Pi], 3 - 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 Cos[Rational[1, 15] Pi] + 
           2 Sin[Rational[1, 30] Pi]}, {
          2 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 3 
           Sin[Rational[2, 15] Pi], 3 - 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 Cos[Rational[1, 15] Pi] + 
           Cos[Rational[2, 15] Pi] + 2 Sin[Rational[1, 30] Pi]}, {
          Rational[3, 2] 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 3 
           Sin[Rational[2, 15] Pi], Rational[7, 2] - 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 Cos[Rational[1, 15] Pi] + 
           Cos[Rational[2, 15] Pi] + 2 Sin[Rational[1, 30] Pi]}, {
          Rational[3, 2] 3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 2 
           Sin[Rational[2, 15] Pi], Rational[7, 2] - 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 Cos[Rational[1, 15] Pi] + 
           2 Cos[Rational[2, 15] Pi] + 2 Sin[Rational[1, 30] Pi]}, {
          3^Rational[1, 2] + 
           4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 2 
           Sin[Rational[2, 15] Pi], 4 - 5^Rational[1, 2] + 
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 Cos[Rational[1, 15] Pi] + 
           2 Cos[Rational[2, 15] Pi] + 2 Sin[Rational[1, 30] Pi]}, {
          3^Rational[1, 2] + 
           3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 4 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 2 
           Sin[Rational[2, 15] Pi], 4 - 5^Rational[1, 2] + 
           Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 Cos[Rational[1, 15] Pi] + 
           2 Cos[Rational[2, 15] Pi] + 2 Sin[Rational[1, 30] Pi]}, {
          3^Rational[1, 2] + 
           3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 3 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 2 
           Sin[Rational[2, 15] Pi], 4 - 5^Rational[1, 2] + 
           Rational[3, 4] (-1 - 5^Rational[1, 2]) + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 Cos[Rational[1, 15] Pi] + 
           2 Cos[Rational[2, 15] Pi] + 2 Sin[Rational[1, 30] Pi] - Sin[
           Rational[7, 30] Pi]}, {
          3^Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 3 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 2 
           Sin[Rational[2, 15] Pi], 3 - 2 5^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 Cos[Rational[1, 15] Pi] + 
           2 Cos[Rational[2, 15] Pi] + 2 Sin[Rational[1, 30] Pi] - Sin[
           Rational[7, 30] Pi]}, {
          3^Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - 2 
           Cos[Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 2 
           Sin[Rational[2, 15] Pi], 3 - 2 5^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 Cos[Rational[1, 15] Pi] + 
           2 Cos[Rational[2, 15] Pi] + 2 Sin[Rational[1, 30] Pi] - 2 
           Sin[Rational[7, 30] Pi]}, {
          3^Rational[1, 2] + 
           2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
             Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - Cos[
           Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 2 
           Sin[Rational[2, 15] Pi], 3 - 2 5^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[1, 2] (1 + 5^Rational[1, 2]) - 2 Cos[Rational[1, 15] Pi] + 
           2 Cos[Rational[2, 15] Pi] + 2 Sin[Rational[1, 30] Pi] - Sin[
           Rational[7, 30] Pi]}, {
          3^Rational[1, 2] + (Rational[5, 8] + 
             Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] - Cos[
           Rational[7, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - 2 
           Sin[Rational[2, 15] Pi], 3 - 2 5^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[3, 4] (1 + 5^Rational[1, 2]) - 2 Cos[Rational[1, 15] Pi] + 
           2 Cos[Rational[2, 15] Pi] + 2 Sin[Rational[1, 30] Pi] - Sin[
           Rational[7, 30] Pi]}, {
          3^Rational[1, 2] + (Rational[5, 8] + 
             Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] + 
           2 Sin[Rational[1, 15] Pi] - 2 Sin[Rational[2, 15] Pi], 3 - 2 
           5^Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
           Rational[3, 4] (1 + 5^Rational[1, 2]) - 2 Cos[Rational[1, 15] Pi] + 
           2 Cos[Rational[2, 15] Pi] + 2 Sin[Rational[1, 30] Pi]}, {
          3^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] + 
           2 Sin[Rational[1, 15] Pi] - 2 Sin[Rational[2, 15] Pi], 4 - 5^
           Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) - 2 
           Cos[Rational[1, 15] Pi] + 2 Cos[Rational[2, 15] Pi] + 
           2 Sin[Rational[1, 30] Pi]}, {
          Rational[1, 2] 3^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] + 
           2 Sin[Rational[1, 15] Pi] - 2 Sin[Rational[2, 15] Pi], 
           Rational[7, 2] - 5^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) - 2 Cos[Rational[1, 15] Pi] + 
           2 Cos[Rational[2, 15] Pi] + 2 Sin[Rational[1, 30] Pi]}, {
          Rational[1, 2] 3^Rational[1, 2] - 
           2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + 2 Cos[Rational[1, 30] Pi] + 
           2 Sin[Rational[1, 15] Pi] - Sin[Rational[2, 15] Pi], 
           Rational[7, 2] - 5^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) - 2 Cos[Rational[1, 15] Pi] + 
           Cos[Rational[2, 15] Pi] + 
           2 Sin[Rational[1, 30] Pi]}, {(-2) (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           2 Cos[Rational[1, 30] Pi] + 2 Sin[Rational[1, 15] Pi] - Sin[
           Rational[2, 15] Pi], 3 - 5^Rational[1, 2] + 
           Rational[1, 2] (-1 + 5^Rational[1, 2]) - 2 Cos[Rational[1, 15] Pi] + 
           Cos[Rational[2, 15] Pi] + 
           2 Sin[Rational[1, 30] Pi]}, {(-2) (Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           2 Cos[Rational[1, 30] Pi] + 2 Sin[Rational[1, 15] Pi], 3 - 5^
           Rational[1, 2] + Rational[1, 2] (-1 + 5^Rational[1, 2]) - 2 
           Cos[Rational[1, 15] Pi] + 
           2 Sin[Rational[1, 30] Pi]}, {-(Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           2 Cos[Rational[1, 30] Pi] + 2 Sin[Rational[1, 15] Pi], 3 - 5^
           Rational[1, 2] + Rational[3, 4] (-1 + 5^Rational[1, 2]) - 2 
           Cos[Rational[1, 15] Pi] + 
           2 Sin[Rational[1, 30] Pi]}, {-(Rational[5, 8] + 
              Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
           2 Cos[Rational[1, 30] Pi] + Sin[Rational[1, 15] Pi], 3 - 5^
           Rational[1, 2] + Rational[3, 4] (-1 + 5^Rational[1, 2]) - Cos[
           Rational[1, 15] Pi] + 2 Sin[Rational[1, 30] Pi]}, {
          2 Cos[Rational[1, 30] Pi] + Sin[Rational[1, 15] Pi], 2 - Cos[
           Rational[1, 15] Pi] + 2 Sin[Rational[1, 30] Pi]}, {
          2 Cos[Rational[1, 30] Pi], 2 + 2 Sin[Rational[1, 30] Pi]}, {
          Cos[Rational[1, 30] Pi], 2 + Sin[Rational[1, 30] Pi]}, {
          Cos[Rational[1, 30] Pi], 1 + Sin[Rational[1, 30] Pi]}, {0, 1}, {0, 
          0}}, {{0, 0}, {0.9945218953682733, -0.10452846326765346`}, {
          1.2024335861860327`, 0.8736191374661523}, {2.1969554815543058`, 
          0.7690906741984987}, {2.4048671723720654`, 1.7472382749323045`}, {
          1.4538106560769115`, 2.0562552693072518`}, {1.0470740130011114`, 
          1.142709811664651}, {0.096017496705958, 
          1.4517268060395985`}, {-0.31071914636984216`, 0.5381813483969977}, {
          0.5553062574145964, 0.038181348396997716`}, {1.1430915097070697`, 
          0.8471983427719451}, {2.009116913491508, 0.34719834277194506`}, {
          2.5969021657839813`, 1.1562153371468926`}, {1.8537573403065872`, 
          1.8253459435057509`}, {1.110612514829193, 1.1562153371468926`}, {
          0.3674676893517983, 1.8253459435057509`}, {-0.3756771361255953, 
          1.1562153371468926`}, {0.21210811616687808`, 
          0.34719834277194506`}, {1.0781335199513165`, 0.8471983427719451}, {
          1.6659187722437898`, 0.03818134839699763}, {2.531944176028228, 
          0.5381813483969976}, {2.125207532952428, 1.4517268060395985`}, {
          1.1741510166572744`, 1.142709811664651}, {0.7674143735814738, 
          2.0562552693072518`}, {-0.18364214271367985`, 
          1.7472382749323043`}, {0.024269548104079774`, 0.7690906741984986}, {
          1.0187914434723524`, 0.8736191374661524}, {
          1.2267031342901116`, -0.10452846326765353`}, {2.221225029658386, 
          0.}, {2.221225029658386, 1.}, {1.2267031342901116`, 
          1.1045284632676533`}, {1.2267031342901116`, 2.1045284632676533`}, {
          0.23218123892183895`, 2.209056926535307}, {0.024269548104079774`, 
          1.2309093258015014`}, {0.9753260643992334, 0.9218923314265538}, {
          0.7674143735814738, -0.056255269307251915`}, {
          1.7184708898766274`, -0.36527226368219934`}, {2.125207532952428, 
          0.5482731939604015}, {1.2591821291679897`, 1.0482731939604015`}, {
          1.6659187722437898`, 1.9618186516030023`}, {0.7998933684593514, 
          2.4618186516030023`}, {0.21210811616687808`, 1.6528016572280548`}, {
          0.9552529416442717, 0.9836710508691967}, {0.3674676893517983, 
          0.17465405649424925`}, {1.110612514829193, -0.4944765498646091}, {
          1.8537573403065872`, 0.17465405649424925`}, {1.2659720880141139`, 
          0.9836710508691967}, {2.009116913491508, 1.6528016572280548`}, {
          1.421331661199035, 2.4618186516030023`}, {0.5553062574145964, 
          1.9618186516030023`}, {0.9620429004903965, 1.0482731939604015`}, {
          0.096017496705958, 0.5482731939604014}, {
          0.5027541397817581, -0.36527226368219945`}, {
          1.4538106560769115`, -0.056255269307252}, {1.2458989652591523`, 
          0.9218923314265538}, {2.1969554815543058`, 1.2309093258015011`}, {
          1.9890437907365466`, 2.209056926535307}, {0.9945218953682733, 
          2.1045284632676533`}, {0.9945218953682733, 1.1045284632676535`}, {0,
           1}, {0, 0}}]]], {1360.8000000000002`, -569.8939620735248}, 
      ImageScaled[{0.5, 0.5}], {359.9999999999998, 356.18372629595297`}]}}, \
{}},
  ContentSelectable->True,
  ImageSize->{805., Automatic},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.539024599246854*^9},
 TextAlignment->Center],

Cell["\<\
Ahora bien, al renunciar a la distinci\[OAcute]n entre \[AAcute]ngulos \
internos y externos resulta que hay pol\[IAcute]gonos simples que cumplen \
esta \[OpenCurlyDoubleQuote]definici\[OAcute]n \
general\[CloseCurlyDoubleQuote] de pol\[IAcute]gono regular sin cumplir la \
que hab\[IAcute]amos dado para pol\[IAcute]gonos simples, como es el caso de \
los dos representados en la figura siguiente:\
\>", "Text",
 CellChangeTimes->{{3.538604529868626*^9, 3.538604529870459*^9}, {
  3.538691947529008*^9, 3.538691951231957*^9}, {3.538722191567943*^9, 
  3.53872224760596*^9}},
 Hyphenation->False],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[
      LineBox[NCache[{{0, 
         0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
          Rational[1, 2], 
          Rational[1, 4] (-1 - 5^
           Rational[1, 2])}, {(Rational[5, 8] + 
            Rational[-1, 8] 5^Rational[1, 2])^
           Rational[1, 2] + (Rational[5, 8] + 
            Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
          Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
          Rational[1, 4] (1 - 5^Rational[1, 2])}, {
         2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + (Rational[5, 8] + 
            Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
          Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
          Rational[1, 4] (1 - 5^Rational[1, 2])}, {
         2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
          2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
          Rational[1, 2] (1 - 5^Rational[1, 2])}, {
         2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
          3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
          Rational[1, 2] (1 - 5^Rational[1, 2]) + 
          Rational[1, 4] (-1 + 5^Rational[1, 2])}, {
         3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
          3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
          Rational[1, 2] (1 - 5^Rational[1, 2]) + 
          Rational[1, 4] (-1 + 5^Rational[1, 2]) + 
          Rational[1, 4] (1 + 5^Rational[1, 2])}, {
         3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
          4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
          Rational[1, 2] (1 - 5^Rational[1, 2]) + 
          Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
          Rational[1, 4] (1 + 5^Rational[1, 2])}, {
         4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
          4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
           Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
          Rational[1, 2] (1 - 5^Rational[1, 2]) + 
          Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
          Rational[1, 2] (1 + 5^Rational[1, 2])}, {
         4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
          4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
           1 + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
          Rational[1, 2] (1 - 5^Rational[1, 2]) + 
          Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
          Rational[1, 2] (1 + 5^Rational[1, 2])}, {
         3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
          4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
           1 + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
          Rational[1, 2] (1 - 5^Rational[1, 2]) + 
          Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
          Rational[3, 4] (1 + 5^Rational[1, 2])}, {
         3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
          4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
           2 + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
          Rational[1, 2] (1 - 5^Rational[1, 2]) + 
          Rational[1, 2] (-1 + 5^Rational[1, 2]) + 
          Rational[3, 4] (1 + 5^Rational[1, 2])}, {
         2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
          4 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
           3 + 5^Rational[1, 2] + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
          Rational[1, 2] (1 - 5^Rational[1, 2]) + 
          Rational[1, 2] (-1 + 5^Rational[1, 2])}, {
         2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
          3 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
           3 + 5^Rational[1, 2] + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
          Rational[1, 2] (1 - 5^Rational[1, 2]) + 
          Rational[3, 4] (-1 + 5^Rational[1, 2])}, {
         2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2] + 
          2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
           3 + 5^Rational[1, 2] + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
          Rational[3, 4] (1 - 5^Rational[1, 2]) + 
          Rational[3, 4] (-1 + 5^Rational[1, 2])}, {
         2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
            Rational[1, 2] + (Rational[5, 8] + 
            Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 2 + 
          2 5^Rational[1, 2] + Rational[1, 2] (-1 - 5^Rational[1, 2]) + 
          Rational[3, 4] (1 - 5^Rational[1, 2])}, {
         2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2],
           3 + 5^Rational[1, 2] + 
          Rational[1, 2] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 3 + 
          5^Rational[1, 2] + 
          Rational[3, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 2 + 
          5^Rational[1, 2] + Rational[3, 4] (-1 - 5^Rational[1, 2])}, {0, 
         1}, {0, 0}}, {{0, 0}, {0.5877852522924731, -0.8090169943749475}, {
         1.5388417685876266`, -1.118033988749895}, {
         2.1266270208801, -1.9270509831248424`}, {
         3.077683537175253, -2.23606797749979}, {
         4.028740053470407, -1.9270509831248424`}, {
         4.61652530576288, -1.118033988749895}, {
         5.567581822058034, -0.8090169943749475}, {6.155367074350506, 0.}, {
         6.155367074350506, 1.}, {5.567581822058034, 1.8090169943749475`}, {
         5.567581822058034, 2.8090169943749475`}, {4.97979656976556, 
         3.618033988749895}, {4.028740053470407, 3.9270509831248424`}, {
         3.077683537175253, 3.618033988749895}, {2.1266270208801, 
         3.9270509831248424`}, {1.1755705045849463`, 3.618033988749895}, {
         0.5877852522924731, 2.8090169943749475`}, {0.5877852522924731, 
         1.8090169943749475`}, {0, 1}, {0, 0}}]]], {192., -157.61901049020412`},
      ImageScaled[{0.5, 0.5}], {360., 300.2266866480079}], InsetBox[
     GraphicsBox[
      LineBox[{{0, 0}, {0, 1}, {-1, 1}, {-1, 2}, {0, 2}, {0, 3}, {1, 3}, {1, 
       2}, {2, 2}, {2, 3}, {3, 3}, {3, 4}, {4, 4}, {4, 3}, {5, 3}, {5, 2}, {4,
        2}, {4, 1}, {3, 1}, {3, 0}, {2, 0}, {2, 1}, {1, 1}, {1, 0}, {0, 
       0}}]], {576., -157.61901049020412`}, 
     ImageScaled[{0.5, 0.5}], {360., 300.2266866480079}]}, {}},
  ContentSelectable->True,
  ImageSize->{631., Automatic},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.53902461779784*^9},
 TextAlignment->Center],

Cell["\<\
Resulta as\[IAcute] evidente, especialmente a la vista del pol\[IAcute]gono \
de la derecha, que nuestro proyecto de generalizaci\[OAcute]n del concepto de \
pol\[IAcute]gono regular es demasiado generoso, en tanto que admite objetos \
totalmente asim\[EAcute]tricos, en contraste con la gran simetr\[IAcute]a de \
los pol\[IAcute]gonos regulares simples. Equivalentemente, sucede que la mera \
exigencia de que un pol\[IAcute]gono tenga lados iguales y \[AAcute]ngulos \
iguales implica autom\[AAcute]ticamente unas condiciones de simetr\[IAcute]a \
en el caso de pol\[IAcute]gonos simples que no tienen por qu\[EAcute] darse \
en el caso de pol\[IAcute]gonos complejos (o simplemente si prescindimos de \
la distinci\[OAcute]n entre \[AAcute]ngulos internos y externos), por lo que \
razonable es generalizar la noci\[OAcute]n de pol\[IAcute]gono regular \
exigiendo dichas condiciones de simetr\[IAcute]a:\
\>", "Text",
 CellChangeTimes->{{3.538722990765049*^9, 3.5387230586928263`*^9}, {
  3.538723104885149*^9, 3.538723162013942*^9}, {3.5387231984559927`*^9, 
  3.5387232940561953`*^9}, {3.539063780683138*^9, 3.539063780686576*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Una ",
 StyleBox["simetr\[IAcute]a",
  FontSlant->"Italic"],
 " de un pol\[IAcute]gono es una isometr\[IAcute]a del plano que transforma v\
\[EAcute]rtices en v\[EAcute]rtices y lados en lados."
}], "Text",
 CellMargins->{{30, 30}, {0, 5}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
   3.538342563212167*^9, 3.538342641589696*^9}, {3.538477791518964*^9, 
   3.538477806679139*^9}, {3.538861786756031*^9, 3.5388617916487722`*^9}, {
   3.538862502914343*^9, 3.538862553744755*^9}, {3.538935743587105*^9, 
   3.538935754223081*^9}, {3.538939411691236*^9, 3.5389394121130657`*^9}, {
   3.539029482155212*^9, 3.539029516926116*^9}, 3.539029578192609*^9, {
   3.539029613890944*^9, 3.539029626505129*^9}, {3.539034396328663*^9, 
   3.539034404072836*^9}, {3.539063791467227*^9, 3.5390638169945383`*^9}, {
   3.5390638672434587`*^9, 3.539063867594911*^9}, {3.5390639235000772`*^9, 
   3.539063931523467*^9}},
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell[TextData[{
 "Un ",
 StyleBox["pol\[IAcute]gono regular",
  FontSlant->"Italic"],
 " es un pol\[IAcute]gono tal que para cada par de v\[EAcute]rtices existe \
una simetr\[IAcute]a que transforma uno en otro y para cada par de lados \
existe una simetr\[IAcute]a que transforma uno en otro."
}], "Text",
 CellMargins->{{30, 30}, {3, 0}},
 CellFrameMargins->{{8, 8}, {8, 4}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
  3.538342563212167*^9, 3.538342641589696*^9}, {3.538477791518964*^9, 
  3.538477806679139*^9}, {3.538861786756031*^9, 3.5388617916487722`*^9}, {
  3.538862502914343*^9, 3.538862553744755*^9}, {3.538935743587105*^9, 
  3.538935754223081*^9}, {3.538939411691236*^9, 3.5389394121130657`*^9}, {
  3.539029482155212*^9, 3.539029488159446*^9}, {3.539029844685408*^9, 
  3.539029845147251*^9}, {3.539029908157879*^9, 3.539030035516439*^9}, {
  3.5390303019446707`*^9, 3.53903033945509*^9}, {3.5390303716752253`*^9, 
  3.539030377423381*^9}, {3.539030475442078*^9, 3.53903051228376*^9}, {
  3.539033242688464*^9, 3.539033249631542*^9}, {3.539063831164359*^9, 
  3.539063875010964*^9}},
 TextJustification->1.,
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell["\<\
Observemos que, puesto que los conjuntos de v\[EAcute]rtices y de lados de un \
pol\[IAcute]gono son finitos y las simetr\[IAcute]as son biyectivas, en \
realidad una simetr\[IAcute]a biyecta ambos conjuntos con ellos mismos, es \
decir, induce una permutaci\[OAcute]n en el conjunto de los v\[EAcute]rtices \
y otra permutaci\[OAcute]n en el conjunto de los lados, de modo que los pares \
de v\[EAcute]rtices adyacentes se transforman en pares de v\[EAcute]rtices \
adyacentes y los pares de lados contiguos se transforman en pares de lados \
contiguos. Como las simetr\[IAcute]as son tambi\[EAcute]n homeomorfismos, es \
inmediato que transforman puntos interiores en puntos interiores y, como la \
inversa de una simetr\[IAcute]a es tambi\[EAcute]n una simetr\[IAcute]a, \
concluimos que las simetr\[IAcute]as biyectan los puntos interiores con los \
puntos interiores, es decir, que inducen una permutaci\[OAcute]n del pol\
\[IAcute]gono completo (considerando su interior como parte de \[EAcute]l).\
\>", "Text",
 CellChangeTimes->{{3.539063950933598*^9, 3.53906396894768*^9}, {
  3.539064031692078*^9, 3.539064400239176*^9}, {3.539081458008689*^9, 
  3.5390814641809883`*^9}, {3.5390818446122427`*^9, 3.539081850824697*^9}}],

Cell[TextData[{
 "En particular, ahora es obvio que un pol\[IAcute]gono simple es regular en \
este sentido si y s\[OAcute]lo si lo es seg\[UAcute]n la definici\[OAcute]n \
que hab\[IAcute]amos dado previamente. En efecto, puesto que todo lado puede \
transformarse en cualquier otro mediante una simetr\[IAcute]a, todos los \
lados son iguales y, como todo v\[EAcute]rtice puede transformarse en \
cualquier otro mediante una simetr\[IAcute]a (y \[EAcute]sta transforma \
claramente el \[AAcute]ngulo interior de un v\[EAcute]rtice en el \
\[AAcute]ngulo interior del otro), los \[AAcute]ngulos interiores son tambi\
\[EAcute]n todos iguales. Rec\[IAcute]procamente, en un ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "-\[AAcute]gono regular seg\[UAcute]n la primera definici\[OAcute]n, los \
giros de \[AAcute]ngulo ",
 StyleBox["360",
  FontFamily->"Times"],
 StyleBox["k",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "/",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " respecto de su centro son simetr\[IAcute]as que permiten transformar \
cualquier v\[EAcute]rtice en cualquier v\[EAcute]rtice y cualquier lado en \
cualquier lado."
}], "Text",
 CellChangeTimes->{{3.539063962811228*^9, 3.539063962812294*^9}, {
  3.539064404071966*^9, 3.539064465639887*^9}, {3.539081477855002*^9, 
  3.539081637433949*^9}, {3.539081716047118*^9, 3.5390817529415913`*^9}, {
  3.539081857939843*^9, 3.539081902416946*^9}, {3.539081985453302*^9, 
  3.539082044347494*^9}, {3.5390822278435507`*^9, 3.539082229499621*^9}, {
  3.539082357331872*^9, 3.5390823691086693`*^9}}],

Cell["\<\
Pasamos a estudiar la definici\[OAcute]n extendida de regularidad. Para ello \
resulta \[UAcute]til el concepto de centroide, que definimos en espacios de \
dimensi\[OAcute]n arbitraria para que los resultados nos aprovechen tambi\
\[EAcute]n para poliedros:\
\>", "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{{3.5390639629633503`*^9, 3.539063962964411*^9}, {
  3.539082293322103*^9, 3.539082348551901*^9}, {3.539082380499217*^9, 
  3.53908242709721*^9}}],

Cell[TextData[{
 "Dados ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " puntos distintos en un espacio af\[IAcute]n ",
 StyleBox["m",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "-dimensional y fijado un sistema de referencia, llamamos ",
 StyleBox["centroide",
  FontSlant->"Italic"],
 " del sistema de puntos al punto de coordenadas ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{
      SubscriptBox["p", "1"], "+", " ", "\[CenterEllipsis]", "+", " ", 
      SubscriptBox["p", "n"]}], "n"],
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", donde ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["p", "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \[Ellipsis] , ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["p", "n"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " son las coordenadas de los puntos."
}], "Text",
 CellMargins->{{30, 30}, {3, 5}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
  3.538342563212167*^9, 3.538342641589696*^9}, {3.538477791518964*^9, 
  3.538477806679139*^9}, {3.53849656143301*^9, 3.5384966496577177`*^9}, {
  3.538496697507208*^9, 3.5384967694009666`*^9}, {3.538497015029212*^9, 
  3.538497197509335*^9}, {3.538507820776568*^9, 3.538507896303946*^9}, {
  3.538517197451973*^9, 3.538517209882393*^9}, {3.538600835169466*^9, 
  3.538600858197411*^9}, {3.538604570997416*^9, 3.538604651286901*^9}, {
  3.538604749808346*^9, 3.53860475979252*^9}, {3.538723311975977*^9, 
  3.5387233609194517`*^9}, {3.5387658656472197`*^9, 3.538765983823042*^9}, {
  3.538766030666065*^9, 3.5387661250242977`*^9}, {3.538766187313757*^9, 
  3.53876623983368*^9}, {3.538941235957218*^9, 3.538941242437408*^9}, {
  3.5390824413227882`*^9, 3.539082471498008*^9}, {3.539082501674656*^9, 
  3.539082641493207*^9}},
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell[TextData[{
 StyleBox["Teorema 1.8:",
  FontWeight->"Bold"],
 " ",
 StyleBox["Si una biyecci\[OAcute]n af\[IAcute]n permuta un conjunto finito \
de puntos, entonces deja invariante a su centroide.",
  FontSlant->"Italic"]
}], "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{{3.539063963259335*^9, 3.539063963260482*^9}, {
  3.53908270886376*^9, 3.539082741189663*^9}}],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": La expresi\[OAcute]n en coordenadas de una biyecci\[OAcute]n af\[IAcute]n \
es de la forma ",
 StyleBox["x \[RightArrow] v + xA,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " donde ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un vector y ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " una matriz. Por lo tanto, con la notaci\[OAcute]n de la definici\[OAcute]n \
precedente, las coordenadas de la imagen del centroide vienen dadas por"
}], "Text",
 CellChangeTimes->{{3.539082971541195*^9, 3.539083045173594*^9}, {
  3.5390830830211163`*^9, 3.539083116725411*^9}, {3.5390831721824923`*^9, 
  3.539083185693462*^9}, {3.539083957038397*^9, 3.5390839653983583`*^9}},
 TextJustification->1.],

Cell[TextData[{
 StyleBox["v + ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{
      SubscriptBox[
       StyleBox["p",
        FontFamily->"Times",
        FontSize->18], "1"], "+", " ", "\[CenterEllipsis]", "+", 
      StyleBox[" ",
       FontFamily->"Times",
       FontSize->18], 
      SubscriptBox[
       StyleBox["p",
        FontFamily->"Times",
        FontSize->18], "n"]}], 
     StyleBox["n",
      FontFamily->"Times"]],
    FontSize->18], TraditionalForm]]],
 StyleBox["A ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["=",
  FontFamily->"Times",
  FontSize->18],
 StyleBox[" ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{
      StyleBox["v",
       FontFamily->"Times",
       FontSize->18], "+", " ", 
      RowBox[{
       SubscriptBox[
        StyleBox["p",
         FontFamily->"Times",
         FontSize->18], "1"], 
       StyleBox["A",
        FontFamily->"Times",
        FontSize->18]}], 
      StyleBox[" ",
       FontFamily->"Times",
       FontSize->18], "+", " ", "\[CenterEllipsis]", "+", " ", 
      StyleBox["v",
       FontFamily->"Times",
       FontSize->18], " ", "+", "  ", 
      RowBox[{
       SubscriptBox[
        StyleBox["p",
         FontFamily->"Times",
         FontSize->18], "n"], 
       StyleBox["A",
        FontFamily->"Times",
        FontSize->18]}]}], 
     StyleBox["n",
      FontFamily->"Times"]],
    FontSize->18], TraditionalForm]],
  TextAlignment->Center],
 StyleBox[" ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["=",
  FontFamily->"Times",
  FontSize->18],
 StyleBox[" ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{
      SubscriptBox[
       StyleBox["p",
        FontFamily->"Times",
        FontSize->18], "1"], "+", " ", "\[CenterEllipsis]", "+", 
      StyleBox[" ",
       FontFamily->"Times",
       FontSize->18], 
      SubscriptBox[
       StyleBox["p",
        FontFamily->"Times",
        FontSize->18], "n"]}], 
     StyleBox["n",
      FontFamily->"Times"]],
    FontSize->18], TraditionalForm]]],
 StyleBox[",",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.5390832183117943`*^9, 3.539083262137701*^9}, {
  3.539083329177875*^9, 3.539083380641492*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "donde hemos usado que los sumandos del numerador de la fracci\[OAcute]n \
central son los vectores de coordenadas ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["p",
     FontFamily->"Times",
     FontSize->18], "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \[Ellipsis] , ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["p",
     FontFamily->"Times",
     FontSize->18], "n"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " permutados.  ",
 "\[FilledSmallSquare]"
}], "Text",
 CellChangeTimes->{{3.53908338239832*^9, 3.5390834385115*^9}}],

Cell["\<\
De aqu\[IAcute] se deduce en particular que el centroide de un conjunto \
finito de puntos no depende del sistema de referencia respecto al que se \
calcula.\
\>", "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{3.539083994632492*^9}],

Cell[TextData[{
 "El ",
 StyleBox["centroide",
  FontSlant->"Italic"],
 " de un pol\[IAcute]gono es el centroide del conjunto de sus \
v\[EAcute]rtices. Si el pol\[IAcute]gono es regular recibe el nombre de ",
 StyleBox["centro.",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellMargins->{{30, 30}, {3, 5}},
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQAWIQ7fDwl8etmFeO15rV/EG00Km0EBB96p5RHIiOmv0h
Wib2lWPT7quxINritm6bKpBm4zGdCKJ5rA2mg+gdV3QWgGi/9w/2gehKnw1X
QfTSmzNYtYH0252c/CB6Qtm6mfog2sZmNoh2yUktiADShoFuxSD66qt45ygg
7a2X6Quif9zdGQmig2N+RoFoE+v/tlOAtFqOrAuIZttmwroSSMeE/RIG0RkB
VyVBNM/xBaog2ocrSxdEN639ZQyiOxbWLfsHpO3/+y4H0R4hWjOd4145rnv/
fg6IPjFt6wIQHXVCfxOI3qKzxc8FSKco2vuD6AfbhWJAtMYvhzgQDQBXSZqu

  "],
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell["\<\
El teorema anterior nos da que todas las simetr\[IAcute]as de un \
pol\[IAcute]gono dejan fijo a su centroide. M\[AAcute]s precisamente:\
\>", "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{{3.539083453674128*^9, 3.539083599961741*^9}, {
  3.539083634682721*^9, 3.5390836394589376`*^9}, {3.5390840985139437`*^9, 
  3.539084145520151*^9}}],

Cell[TextData[{
 StyleBox["Teorema 1.9:",
  FontWeight->"Bold"],
 " ",
 StyleBox["Toda simetr\[IAcute]a de un pol\[IAcute]gono es un giro respecto a \
su centroide o bien una simetr\[IAcute]a respecto de una recta que pasa por \
su centroide.",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.539083639577407*^9, 3.539083669010206*^9}}],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": En general, las isometr\[IAcute]as del plano son traslaciones, giros o \
simetr\[IAcute]as axiales, pero las traslaciones no tienen puntos fijos, \
luego quedan descartadas.  \[FilledSmallSquare]"
}], "Text",
 CellChangeTimes->{{3.539083453674128*^9, 3.539083599961741*^9}, {
  3.539083634682721*^9, 3.539083634809472*^9}, {3.539083709805066*^9, 
  3.539083725131135*^9}, {3.5390841700681973`*^9, 3.539084189440872*^9}}],

Cell["Ahora ya es inmediato:", "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{{3.5390834657989817`*^9, 3.53908346580049*^9}, {
  3.5390842534987497`*^9, 3.5390842747535686`*^9}}],

Cell[TextData[{
 StyleBox["Teorema 1.10:",
  FontWeight->"Bold"],
 " ",
 StyleBox["Los v\[EAcute]rtices de un pol\[IAcute]gono regular est\[AAcute]n \
inscritos en una circunferencia con el mismo centro que el pol\[IAcute]gono \
(circunferencia circunscrita) y sus lados son tangentes a otra circunferencia \
con el mismo centro (circunferencia inscrita). ",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.5390834657989817`*^9, 3.53908346580049*^9}, {
  3.5390842534987497`*^9, 3.539084399691698*^9}, {3.5390857493142033`*^9, 
  3.539085761507353*^9}}],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": Dados dos v\[EAcute]rtices, existe una simetr\[IAcute]a que transforma \
uno en otro, la cual fija al centro del pol\[IAcute]gono, luego ambos est\
\[AAcute]n a la misma distancia de dicho centro. Similarmente, todos los \
lados est\[AAcute]n a la misma distancia del centro, luego son tangentes a la \
circunferencia cuyo radio es dicha distancia.  ",
 "\[FilledSmallSquare]"
}], "Text",
 CellChangeTimes->{{3.539084409139027*^9, 3.539084432363361*^9}, {
  3.539084524999208*^9, 3.539084533100938*^9}, {3.5390845802375727`*^9, 
  3.539084646087275*^9}}],

Cell[TextData[{
 "As\[IAcute] pues, podemos hablar del ",
 StyleBox["inradio",
  FontSlant->"Italic"],
 " y del ",
 StyleBox["circunradio",
  FontSlant->"Italic"],
 " (o simplemente ",
 StyleBox["radio,",
  FontSlant->"Italic"],
 " en el segundo caso) de un pol\[IAcute]gono regular en el sentido general."
}], "Text",
 CellChangeTimes->{{3.538722990891955*^9, 3.538722990893075*^9}, {
   3.5387236640910788`*^9, 3.5387236855937977`*^9}, {3.538723722227333*^9, 
   3.5387237833869343`*^9}, {3.538723999318262*^9, 3.5387240355968533`*^9}, {
   3.538724131560172*^9, 3.53872436877562*^9}, {3.538725919835154*^9, 
   3.5387259509809*^9}, {3.538726136288905*^9, 3.538726139416814*^9}, {
   3.538763176761561*^9, 3.538763235662624*^9}, {3.5387637787093897`*^9, 
   3.538763792034829*^9}, {3.5387638974545593`*^9, 3.538764305168548*^9}, {
   3.538941145812458*^9, 3.538941148483387*^9}, 3.539084549584236*^9, {
   3.539084743241403*^9, 3.539084797407352*^9}, {3.539084933355893*^9, 
   3.539084963633238*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Consideremos ahora un ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "-\[AAcute]gono regular y sean ",
 StyleBox["v, v', v''",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " tres v\[EAcute]rtices consecutivos. Los lados que llegan a ",
 StyleBox["v'",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " son cuerdas de la circunferencia circunscrita, y como tienen la misma \
longitud ",
 StyleBox["l,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " ambas abarcan el mismo \[AAcute]ngulo ",
 StyleBox["\[Alpha]",
  FontSize->18],
 " < ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["180",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ", que depende \[UAcute]nicamente de ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " luego, en general, los v\[EAcute]rtices contiguos a un v\[EAcute]rtice \
dado ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " son los dos puntos de la circunferencia circunscrita separados de ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " por un arco de amplitud ",
 StyleBox["\[Alpha]",
  FontSize->18],
 "."
}], "Text",
 CellChangeTimes->{{3.538722990891955*^9, 3.538722990893075*^9}, {
   3.5387236640910788`*^9, 3.5387236855937977`*^9}, {3.538723722227333*^9, 
   3.5387237833869343`*^9}, {3.538723999318262*^9, 3.5387240355968533`*^9}, {
   3.538724131560172*^9, 3.53872436877562*^9}, {3.538725919835154*^9, 
   3.5387259509809*^9}, {3.538726136288905*^9, 3.538726139416814*^9}, {
   3.538763176761561*^9, 3.538763235662624*^9}, {3.5387637787093897`*^9, 
   3.538763792034829*^9}, {3.5387638974545593`*^9, 3.538764305168548*^9}, {
   3.538941145812458*^9, 3.538941148483387*^9}, 3.539084549584236*^9, 
   3.539084743241403*^9},
 Hyphenation->False],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}], 
   LineBox[NCache[{{
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {1, 0}, {
      Rational[1, 4] (-1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2]}}, {{-0.8090169943749475, 0.5877852522924731}, {1, 
      0}, {-0.8090169943749475, -0.5877852522924731}}]], InsetBox[
    StyleBox["\<\"v\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {-0.8494678440936949, 0.6171745149070968}], 
   InsetBox[
    StyleBox["\<\"v''\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {-0.8656481839811938, -0.6289302199529463}], InsetBox[
    StyleBox["\<\"v'\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {1.07, 0}], InsetBox[
    StyleBox["\<\"\[Alpha]\"\>",
     StripOnInput->False,
     FontSize->16,
     FontSlant->Italic], {0.3306481839811938, 1.0176304724358143`}]},
  ImageSize->{302., Automatic}]], "Output",
 CellChangeTimes->{3.5390246518869867`*^9},
 TextAlignment->Center],

Cell[TextData[{
 "De este modo, si medimos los arcos a partir de uno de los v\[EAcute]rtices, \
los v\[EAcute]rtices sucesivos del pol\[IAcute]gono son los que est\[AAcute]n \
separados del v\[EAcute]rtice de partida por un \[AAcute]ngulo ",
 StyleBox["0",
  FontFamily->"Times"],
 StyleBox[", \[Alpha], ",
  FontFamily->"Times",
  FontSize->18],
 StyleBox["2",
  FontFamily->"Times"],
 StyleBox["\[Alpha], ",
  FontFamily->"Times",
  FontSize->18],
 StyleBox["3",
  FontFamily->"Times"],
 StyleBox["\[Alpha], ... , n\[Alpha]",
  FontFamily->"Times",
  FontSize->18],
 " y, como el \[UAcute]ltimo debe coincidir con el primero, resulta que ",
 StyleBox["n\[Alpha] = k ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["360",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ", es decir, que ",
 StyleBox["\[Alpha] = (k/n)",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["360",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ", con ",
 StyleBox["k/n<",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["1/2",
  FontFamily->"Times"],
 ". Adem\[AAcute]s, ",
 StyleBox["k",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " son primos entre s\[IAcute], pues si ",
 StyleBox["k = xk\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["n = xn\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", tendr\[IAcute]amos que ",
 StyleBox["n\[CloseCurlyQuote]\[Alpha] = k\[CloseCurlyQuote] ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["360",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ", lo cual significa que el ",
 StyleBox["n\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "-\[EAcute]simo v\[EAcute]rtice del pol\[IAcute]gono coincide con el primero \
y el pol\[IAcute]gono tendr\[IAcute]a ",
 StyleBox["n\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " v\[EAcute]rtices en lugar de ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". Rec\[IAcute]procamente, si ",
 StyleBox["1",
  FontFamily->"Times"],
 StyleBox[" \[LessEqual] k \[LessEqual] n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " son dos n\[UAcute]meros naturales primos entre s\[IAcute] con ",
 StyleBox["n \[GreaterEqual] ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["3",
  FontFamily->"Times"],
 ", al partir de un punto de la circunferencia y avanzar en arcos de ",
 StyleBox["(k/n)",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["360",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 " y",
 ", llegamos al punto de partida al cabo de ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " pasos, pero no antes, ya que si lleg\[AAcute]ramos al punto de partida en ",
 StyleBox["0",
  FontFamily->"Times"],
 StyleBox[" < i < n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " pasos, ser\[IAcute]a ",
 StyleBox["(ik/n)",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["360",
  FontFamily->"Times"],
 StyleBox[" = m ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["360",
  FontFamily->"Times"],
 ", luego ",
 StyleBox["ik = nm",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego ",
 StyleBox["n ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["\[RightBracketingBar]",
  FontFamily->"Times",
  FontSize->18],
 StyleBox[" i",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", ya que ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es primo con ",
 StyleBox["k",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", contradicci\[OAcute]n. En resumen:"
}], "Text",
 CellMargins->{{12, 10}, {16, 5}},
 CellChangeTimes->{{3.5387260050924883`*^9, 3.538726005093492*^9}, 
   3.538764307088982*^9, {3.538764362738243*^9, 3.538764495159135*^9}, 
   3.5387646088935633`*^9, {3.538764989095809*^9, 3.538765072234002*^9}, {
   3.538765157310956*^9, 3.538765230391695*^9}, {3.538765424955669*^9, 
   3.538765560674995*^9}, 3.5387657926305532`*^9, {3.5387658521927023`*^9, 
   3.538765853853878*^9}, {3.538941152939896*^9, 3.538941230252502*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Si ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["k",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " son n\[UAcute]meros primos entre s\[IAcute] tales que ",
 StyleBox["n \[GreaterEqual] ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["3",
  FontFamily->"Times"],
 ", y ",
 StyleBox["1",
  FontFamily->"Times"],
 StyleBox[" \[LessEqual] k \[LessEqual] n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", llamaremos {",
 StyleBox["n/k",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "} al ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "-\[AAcute]gono regular que resulta de partir de un punto de una \
circunferencia y avanzar sucesivamente arcos de ",
 StyleBox["(k/n) ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["360",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ". Los pol\[IAcute]gonos {",
 StyleBox["n/k",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "} con ",
 StyleBox["k \[NotEqual] ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["1",
  FontFamily->"Times"],
 " se llaman ",
 StyleBox["pol\[IAcute]gonos estrellados.",
  FontSlant->"Italic"],
 " Cuando ",
 StyleBox["k",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = ",
  FontFamily->"Times",
  FontSize->18],
 StyleBox["1",
  FontFamily->"Times"],
 " escribiremos ",
 StyleBox["{n} = {n/",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["1",
  FontFamily->"Times"],
 StyleBox["}",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". Claramente ",
 StyleBox["{",
  FontFamily->"Times",
  FontSize->18],
 StyleBox["n/k",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["} = {",
  FontFamily->"Times",
  FontSize->18],
 StyleBox["n/(n-k)",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["}. ",
  FontFamily->"Times",
  FontSize->18]
}], "Text",
 CellMargins->{{30, 30}, {3, 5}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
  3.538342563212167*^9, 3.538342641589696*^9}, {3.538477791518964*^9, 
  3.538477806679139*^9}, {3.53849656143301*^9, 3.5384966496577177`*^9}, {
  3.538496697507208*^9, 3.5384967694009666`*^9}, {3.538497015029212*^9, 
  3.538497197509335*^9}, {3.538507820776568*^9, 3.538507896303946*^9}, {
  3.538517197451973*^9, 3.538517209882393*^9}, {3.538600835169466*^9, 
  3.538600858197411*^9}, {3.538604570997416*^9, 3.538604651286901*^9}, {
  3.538604749808346*^9, 3.53860475979252*^9}, {3.538723311975977*^9, 
  3.5387233609194517`*^9}, {3.5387658656472197`*^9, 3.538765983823042*^9}, {
  3.538766030666065*^9, 3.5387661250242977`*^9}, {3.538766187313757*^9, 
  3.53876623983368*^9}, {3.538941235957218*^9, 3.538941242437408*^9}},
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell["\<\
En estos t\[EAcute]rminos acabamos de probar que todo pol\[IAcute]gono \
regular es un pol\[IAcute]gono estrellado. M\[AAcute]s a\[UAcute]n, el \
argumento que nos ha llevado a esta conclusi\[OAcute]n (tras el teorema 1.10) \
no ha partido realmente de la definici\[OAcute]n de pol\[IAcute]gono regular, \
sino que solamente se ha apoyado en que el pol\[IAcute]gono considerado \
estaba inscrito en una circunferencia y ten\[IAcute]a sus lados iguales. Por \
consiguiente hemos probado:\
\>", "Text",
 CellChangeTimes->{{3.538764495576001*^9, 3.53876449557775*^9}, {
  3.538766161553714*^9, 3.5387661744886723`*^9}, {3.538766251267192*^9, 
  3.538766258385091*^9}, {3.539084705265325*^9, 3.5390847169028254`*^9}, {
  3.540885049571986*^9, 3.540885139278706*^9}},
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Teorema 1.11:",
  FontWeight->"Bold"],
 " ",
 StyleBox["Si un pol\[IAcute]gono tiene sus v\[EAcute]rtices inscritos en una \
circunferencia y sus lados iguales, entonces es regular.",
  FontSlant->"Italic"]
}], "Text",
 CellMargins->{{12, 10}, {16, 16}},
 CellChangeTimes->{{3.538764495576001*^9, 3.53876449557775*^9}, {
   3.538766161553714*^9, 3.5387661744886723`*^9}, {3.538766251267192*^9, 
   3.538766258385091*^9}, {3.539084705265325*^9, 3.5390847169028254`*^9}, {
   3.540885049571986*^9, 3.540885061509218*^9}, 3.540885173813635*^9},
 Hyphenation->False],

Cell["\<\
La figura siguiente muestra algunos pol\[IAcute]gonos regulares con sus \
circunferencias inscrita y circunscrita:\
\>", "Text",
 CellChangeTimes->{{3.538764495576001*^9, 3.53876449557775*^9}, {
  3.538766161553714*^9, 3.5387661744886723`*^9}, {3.538766251267192*^9, 
  3.538766258385091*^9}, {3.539084705265325*^9, 3.5390847169028254`*^9}, {
  3.540885049571986*^9, 3.54088506150674*^9}},
 Hyphenation->False],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`circ$$ = True, $CellContext`insc$$ = 
    False, $CellContext`k$$ = 2, $CellContext`n$$ = 5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n$$], 5}, {3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
      15}}, {{
       Hold[$CellContext`k$$], 2}, 
      Dynamic[
       Union[
        Table[
         If[
          CoprimeQ[$CellContext`i, $CellContext`n$$], $CellContext`i, 
          1], {$CellContext`i, 1, 
          Floor[$CellContext`n$$/2]}]]]}, {
      Hold[
       Style["Circunferencias", 12]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`circ$$], True, "Circunscrita"}, {True, False}}, {{
       Hold[$CellContext`insc$$], False, "Inscrita"}, {True, False}}}, 
    Typeset`size$$ = {360., {177., 182.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`n$3734$$ =
     0, $CellContext`circ$3735$$ = False, $CellContext`insc$3736$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`circ$$ = True, $CellContext`insc$$ = 
        False, $CellContext`k$$ = 2, $CellContext`n$$ = 5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$3734$$, 0], 
        Hold[$CellContext`circ$$, $CellContext`circ$3735$$, False], 
        Hold[$CellContext`insc$$, $CellContext`insc$3736$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{{
          GrayLevel[
           If[$CellContext`circ$$, 0, 1]], 
          Circle[]}, {
          GrayLevel[
           If[$CellContext`insc$$, 0, 1]], 
          Circle[{0, 0}, 
           Cos[If[
              CoprimeQ[$CellContext`k$$, $CellContext`n$$], $CellContext`k$$, 
              1] (Pi/$CellContext`n$$)]]}, 
         Line[
          Table[{
            Cos[((2 $CellContext`i) If[
                
                CoprimeQ[$CellContext`k$$, $CellContext`n$$], \
$CellContext`k$$, 1]) (Pi/$CellContext`n$$)], 
            Sin[((2 $CellContext`i) If[
                
                CoprimeQ[$CellContext`k$$, $CellContext`n$$], \
$CellContext`k$$, 1]) (Pi/$CellContext`n$$)]}, {$CellContext`i, 
            0, $CellContext`n$$}]]}], 
      "Specifications" :> {{{$CellContext`n$$, 5}, {3, 4, 5, 6, 7, 8, 9, 10, 
         11, 12, 13, 14, 15}, ControlType -> 
         SetterBar}, {{$CellContext`k$$, 2}, 
         Dynamic[
          Union[
           Table[
            If[
             CoprimeQ[$CellContext`i, $CellContext`n$$], $CellContext`i, 
             1], {$CellContext`i, 1, 
             Floor[$CellContext`n$$/2]}]]], ControlType -> SetterBar}, 
        Delimiter, 
        Style[
        "Circunferencias", 
         12], {{$CellContext`circ$$, True, "Circunscrita"}, {
         True, False}}, {{$CellContext`insc$$, False, "Inscrita"}, {
         True, False}}}, "Options" :> {AppearanceElements -> {}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{405., {262., 268.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.5396061700604553`*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Es f\[AAcute]cil justificar que las relaciones entre el lado ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " el radio ",
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y el inradio ",
 StyleBox["a",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " son las dadas por:"
}], "Text",
 CellChangeTimes->{{3.53876449596804*^9, 3.538764495969816*^9}, {
   3.538771398419416*^9, 3.538771437922277*^9}, {3.538771482116602*^9, 
   3.538771523291103*^9}, {3.53877191640416*^9, 3.5387719581382017`*^9}, {
   3.538771990569759*^9, 3.5387721072905283`*^9}, {3.538773002325342*^9, 
   3.538773028008086*^9}, {3.539084692018816*^9, 3.5390846924311333`*^9}, 
   3.539084722551909*^9},
 Hyphenation->False],

Cell[BoxData[
 FrameBox[
  StyleBox["\<\"    l = 2r\\!\\(TraditionalForm\\`\\(\\(\\\\ \
\\)\\(sen(\\*FractionBox[\\(180  k\\), \\(n\\)])\\)\\)\\) ,     \
\\!\\(\\*\\nStyleBox[\\\"a\\\",\\nFontSlant->\\\"Italic\\\"]\\) = r \
cos\\!\\(TraditionalForm\\`\\((\\*FractionBox[\\(180  k\\), \\(n\\)])\\)\\) . \
   \"\>",
   StripOnInput->False,
   FontFamily->"Times New Roman",
   FontSize->18,
   FontSlant->Italic],
  FrameMargins->10,
  StripOnInput->False]], "Output",
 CellChangeTimes->{3.5411581880062227`*^9},
 TextAlignment->Center],

Cell["\<\
Ahora es claro que los \[OpenCurlyDoubleQuote]presuntos\
\[CloseCurlyDoubleQuote] pol\[IAcute]gonos regulares que hab\[IAcute]amos \
mostrado m\[AAcute]s arriba son pol\[IAcute]gonos con un cierto grado de \
simetr\[IAcute]a (excepto el \[UAcute]ltimo, que era totalmente \
asim\[EAcute]trico), pero no con la simetr\[IAcute]a total propia de los pol\
\[IAcute]gonos regulares: en efecto, tienen grupos de v\[EAcute]rtices que \
pueden hacerse corresponder mediante giros adecuados que dejan invariante al \
pol\[IAcute]gono, pero los v\[EAcute]rtices m\[AAcute]s alejados del centro \
no pueden llevarse a los m\[AAcute]s cercanos. Tampoco es posible transformar \
cualquier arista en cualquier otra.\
\>", "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{{3.538772224114917*^9, 3.538772298131588*^9}, {
  3.538772343756187*^9, 3.5387724351890993`*^9}, {3.5388188650168877`*^9, 
  3.538818865018825*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Cuando ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["k",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " no son primos entre s\[IAcute], la notaci\[OAcute]n ",
 StyleBox["{n/k}",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " se emplea para representar la figura que tiene por v\[EAcute]rtices los v\
\[EAcute]rtices del pol\[IAcute]gno ",
 StyleBox["{n}",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y unir cada uno de ellos con los dos a los que se llega avanzando ",
 StyleBox["k",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " v\[EAcute]rtices en ambos sentidos. Por ejemplo, ",
 StyleBox["{6/2} = {6/4}",
  FontFamily->"Times",
  FontSlant->"Italic"],
 " es la estrella de David:"
}], "Text",
 CellChangeTimes->{{3.538818866717041*^9, 3.538819010735427*^9}, {
   3.538819112471116*^9, 3.538819145224744*^9}, 3.538821031889803*^9},
 Hyphenation->False],

Cell[BoxData[
 GraphicsBox[{
   LineBox[NCache[{{0, -1}, {
      Rational[1, 2] 3^Rational[1, 2], Rational[1, 2]}, {
      Rational[-1, 2] 3^Rational[1, 2], Rational[1, 2]}, {0, -1}}, {{0, -1}, {
      0.8660254037844386, 0.5}, {-0.8660254037844386, 0.5}, {0, -1}}]], 
   LineBox[NCache[{{0, 1}, {
      Rational[1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {
      Rational[-1, 2] 3^Rational[1, 2], Rational[-1, 2]}, {0, 1}}, {{0, 1}, {
      0.8660254037844386, -0.5}, {-0.8660254037844386, -0.5}, {0, 1}}]]},
  ImageSize->{244., Automatic}]], "Output",
 CellChangeTimes->{3.539024671651463*^9},
 TextAlignment->Center],

Cell[TextData[{
 "De acuerdo con la definici\[OAcute]n que hemos dado, no es un \
pol\[IAcute]gono, sino lo que se denomina un ",
 StyleBox["compuesto,",
  FontSlant->"Italic"],
 " es decir, una uni\[OAcute]n de varios pol\[IAcute]gonos (dos \
tri\[AAcute]ngulos, en teste caso)."
}], "Text",
 CellChangeTimes->{{3.5388191459556103`*^9, 3.538819145957251*^9}, {
  3.5388210471900587`*^9, 3.538821083539765*^9}},
 Hyphenation->False],

Cell[TextData[StyleBox["EL PENT\[CapitalAAcute]GONO Y EL PENTAGRAMA",
 FontSize->18,
 FontColor->RGBColor[0, 0, 1]]], "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellMargins->{{100, 100}, {16, 18}},
 CellChangeTimes->{{3.538515429422391*^9, 3.538515429424019*^9}, {
  3.538517083097238*^9, 3.538517086760803*^9}, {3.538772137916774*^9, 
  3.5387721418334713`*^9}, {3.5389433492789*^9, 3.538943354615024*^9}, {
  3.5389440948224087`*^9, 3.538944099862537*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "Vamos a estudiar ahora la geometr\[IAcute]a de los dos pent\[AAcute]gonos \
regulares: el pent\[AAcute]gono convexo {5} y el \[UAcute]nico \
pent\[AAcute]gono estrellado {5/2}, conocido tambi\[EAcute]n como ",
 StyleBox["pentagrama, pentalfa, pent\[AAcute]culo, pent\[AAcute]ngulo",
  FontSlant->"Italic"],
 " o ",
 StyleBox["estrella pitag\[OAcute]rica.",
  FontSlant->"Italic"],
 " Como veremos, en las relaciones entre sus partes aparecer\[AAcute] el ",
 StyleBox["n\[UAcute]mero \[AAcute]ureo",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellChangeTimes->{
  3.538772146209426*^9, {3.538772465342004*^9, 3.53877269630338*^9}, {
   3.5387739691470203`*^9, 3.5387739737974977`*^9}, {3.538774039230612*^9, 
   3.538774059984898*^9}},
 Hyphenation->False],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox["\[CapitalPhi]",
    FontFamily->"Times",
    FontSize->18], 
   StyleBox[" ",
    FontFamily->"Times",
    FontSize->18,
    FontSlant->"Italic"], 
   StyleBox["=",
    FontFamily->"Times",
    FontSize->18], 
   StyleBox[" ",
    FontFamily->"Times",
    FontSize->18,
    FontSlant->"Italic"], 
   RowBox[{
    StyleBox[
     FormBox[
      FractionBox[
       RowBox[{
        StyleBox["1",
         FontSize->14,
         FontSlant->"Plain"], "+", 
        SqrtBox[
         StyleBox["5",
          FontSize->14]]}], 
       StyleBox["2",
        FontSize->14,
        FontSlant->"Plain"]],
      TraditionalForm],
     FontFamily->"Times",
     FontSize->18,
     FontSlant->"Italic"], 
    StyleBox[" ",
     FontFamily->"Times",
     FontSize->18,
     FontSlant->"Italic"], 
    StyleBox["=",
     FontFamily->"Times",
     FontSize->18], 
    StyleBox[" ",
     FontFamily->"Times",
     FontSize->18,
     FontSlant->"Italic"], 
    StyleBox[
     RowBox[{
      StyleBox["1.618033988749895`",
       FontSize->14], 
      StyleBox["...",
       FontSize->18,
       FontSlant->"Italic"]}],
     FontFamily->"Times New Roman"]}]}], TraditionalForm]], "Equation",
 CellChangeTimes->{{3.5387740690287437`*^9, 3.5387741013767757`*^9}, {
  3.538774998062544*^9, 3.538774998600816*^9}, {3.5387750398674803`*^9, 
  3.5387750433693438`*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "Es la ra\[IAcute]z positiva del polinomio ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["x",
     FontFamily->"Times",
     FontSize->18], "2"], TraditionalForm]],
  FontSlant->"Italic"],
 StyleBox["-x-",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["1",
  FontFamily->"Times"],
 ", luego es el \[UAcute]nico n\[UAcute]mero positivo que cumple:  ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[CapitalPhi]", "2"], TraditionalForm]],
  FontSize->18],
 StyleBox[" = \[CapitalPhi] + 1",
  FontFamily->"Times",
  FontSize->18],
 ". Consideremos el pent\[AAcute]gono de lado ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " que muestra la figura:"
}], "Text",
 CellChangeTimes->{{3.538774972108597*^9, 3.5387749942633133`*^9}, {
  3.5387750492736197`*^9, 3.538775068058228*^9}, {3.538775098398735*^9, 
  3.538775227324058*^9}, {3.5387755636480837`*^9, 3.538775587933611*^9}},
 Hyphenation->False],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}], 
   {GrayLevel[0.85], EdgeForm[GrayLevel[0]], 
    PolygonBox[
     NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 
       1}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 
        Rational[1, 4] (-1 + 
         5^Rational[1, 2])}, {-(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 - 5^Rational[1, 2])}, {(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 + 5^Rational[1, 2])}}, {{0.9510565162951535, 
       0.30901699437494745`}, {0, 1}, {-0.9510565162951535, 
       0.30901699437494745`}, {-0.5877852522924731, -0.8090169943749475}, {
       0.5877852522924731, -0.8090169943749475}, {0.9510565162951535, 
       0.30901699437494745`}}]]}, 
   LineBox[NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], 
       Rational[1, 4] (-1 + 
        5^Rational[1, 2])}, {-(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 + 5^Rational[1, 2])}, {(Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 - 5^Rational[1, 2])}, {0, 1}}, {{0.9510565162951535,
       0.30901699437494745`}, {-0.9510565162951535, 0.30901699437494745`}, {
      0.5877852522924731, -0.8090169943749475}, {0, 1}}]], 
   InsetBox["\<\"A\"\>", {-1, 0.3}], InsetBox["\<\"B\"\>", {0, 1.05}], 
   InsetBox["\<\"C\"\>", {1, 0.3}], InsetBox["\<\"D\"\>", {0.65, -0.85}], 
   InsetBox["\<\"E\"\>", {-0.65, -0.85}], InsetBox["\<\"F\"\>", {0.15, 0.35}],
    InsetBox["\<\"d-l\"\>", {0.55, 0.35}], 
   InsetBox["\<\"d\"\>", {-0.2, -0.35}], InsetBox["\<\"l\"\>", {-0.2, 0.35}], 
   InsetBox["\<\"l\"\>", {0.85, -0.2}]},
  ImageSize->{309., Automatic}]], "Output",
 CellChangeTimes->{3.539024693575946*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Teniendo en cuenta que un \[AAcute]ngulo inscrito en una circunferencia \
mide la mitad del arco que abarca, es f\[AAcute]cil ver que el \
tri\[AAcute]ngulo ",
 StyleBox["ABF",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es is\[OAcute]sceles, pues su \[AAcute]ngulo ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " mide ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["36",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ", mientras que ",
 StyleBox["B",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " mide ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["72",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ", luego ",
 StyleBox["F",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " tambi\[EAcute]n mide ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["72",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ", y esto hace que ",
 StyleBox["AF = l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontFamily->"Times New Roman Italic"],
 " Igualmente, los tri\[AAcute]ngulos ",
 StyleBox["ACD",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["DCF",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " son semejantes, lo que nos da la proporci\[OAcute]n"
}], "Text",
 CellChangeTimes->{{3.538772171577249*^9, 3.538772171578985*^9}, 
   3.538775264621613*^9, 3.538775597575986*^9, {3.5389412630857677`*^9, 
   3.538941294673676*^9}},
 Hyphenation->False],

Cell[BoxData[
 FormBox[
  StyleBox[
   RowBox[{
    RowBox[{
     StyleBox[
      FractionBox[
       StyleBox["d",
        FontFamily->"Times"], 
       StyleBox["l",
        FontFamily->"Times"]],
      FontFamily->"Times New Roman",
      FontSlant->"Plain"], 
     StyleBox["=",
      FontFamily->"Verdana Italic"], 
     RowBox[{
      StyleBox[
       FractionBox[
        StyleBox["AD",
         FontFamily->"Times",
         FontSlant->"Italic"], 
        StyleBox["CD",
         FontFamily->"Times",
         FontSlant->"Italic"]],
       FontFamily->"Verdana Italic"], 
      StyleBox["=",
       FontFamily->"Verdana Italic"], 
      StyleBox[" ",
       FontFamily->"Verdana Italic"], 
      RowBox[{
       StyleBox[
        FractionBox[
         StyleBox["CD",
          FontFamily->"Times",
          FontSlant->"Italic"], 
         StyleBox["CF",
          FontFamily->"Times",
          FontSlant->"Italic"]],
        FontFamily->"Verdana Italic"], 
       StyleBox["=",
        FontFamily->"Verdana Italic"], 
       RowBox[{
        StyleBox[
         FractionBox[
          StyleBox["l",
           FontFamily->"Times"], 
          RowBox[{"d", 
           StyleBox["-",
            FontFamily->"Times",
            FontSlant->"Italic"], 
           StyleBox["l",
            FontFamily->"Times"]}]],
         FontFamily->"Times New Roman Italic"], 
        StyleBox[" ",
         FontFamily->"Verdana Italic"], 
        StyleBox["=",
         FontFamily->"Verdana Italic"], 
        StyleBox[" ",
         FontFamily->"Verdana Italic"], 
        StyleBox[
         FractionBox[
          StyleBox["1",
           FontFamily->"Times",
           FontSize->14,
           FontSlant->"Plain"], 
          RowBox[{
           StyleBox[
            FractionBox["d", "l"],
            FontFamily->"Times",
            FontSlant->"Italic"], "-", 
           StyleBox["1",
            FontFamily->"Times",
            FontSize->14,
            FontSlant->"Plain"]}]],
         FontFamily->"Times New Roman"]}]}]}]}], ","}],
   FontSize->18], TraditionalForm]], "Equation",
 CellChangeTimes->{{3.5387721718412848`*^9, 3.538772171843071*^9}, {
   3.5387753404312553`*^9, 3.53877534705722*^9}, 3.538775394591146*^9, {
   3.538775602839654*^9, 3.5387756172402267`*^9}, {3.538775891081831*^9, 
   3.538775892692597*^9}, {3.53877592417415*^9, 3.5387759376439867`*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "de la que se sigue que ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       StyleBox["d",
        FontFamily->"Times",
        FontSize->18], 
       StyleBox["l",
        FontFamily->"Times",
        FontSize->18]], ")"}], "2"], "=", " ", 
    RowBox[{
     FractionBox[
      StyleBox["d",
       FontFamily->"Times",
       FontSize->18], 
      StyleBox["l",
       FontFamily->"Times",
       FontSize->18]], 
     StyleBox["+",
      FontFamily->"Times"], 
     StyleBox["1",
      FontFamily->"Times"]}]}], TraditionalForm]]],
 ", luego ",
 StyleBox["d = l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["\[CapitalPhi]",
  FontFamily->"Times",
  FontSize->18],
 ". Teniendo en cuenta las proporciones y semejanzas anteriores, ahora es \
inmediato que, de las cuatro longitudes determinadas por el pentagrama, las \
que en la figura siguiente aparecen destacadas con las letras ",
 StyleBox["A > B > C > D,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " se cumple que cada una de ellas es igual a la siguiente multiplicada por \
",
 StyleBox["\[CapitalPhi]",
  FontFamily->"Times",
  FontSize->18],
 ". Adem\[AAcute]s B coincide con el lado del pent\[AAcute]gono. En \
particular, el lado del pent\[AAcute]gono interior es igual al lado del pent\
\[AAcute]gono exterior dividido entre ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["\[CapitalPhi]",
     FontSize->18,
     FontSlant->"Plain"], "2"], TraditionalForm]]],
 ". "
}], "Text",
 CellChangeTimes->{{3.538772171985262*^9, 3.538772171987031*^9}, {
   3.538775397518162*^9, 3.538775397521282*^9}, {3.538775633272975*^9, 
   3.538775635494005*^9}, {3.538775947326662*^9, 3.538776080611376*^9}, 
   3.538778216355486*^9, {3.5388211172237167`*^9, 3.5388212863474617`*^9}, {
   3.538854567683701*^9, 3.538854589584812*^9}, {3.538854941718205*^9, 
   3.538854977323681*^9}, {3.538855095311755*^9, 3.538855174933366*^9}},
 Hyphenation->False],

Cell[BoxData[
 GraphicsBox[{
   LineBox[NCache[{{0, 
      1}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2],
        Rational[1, 4] (-1 - 5^
        Rational[1, 2])}, {-(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 + 5^Rational[1, 2])}, {(Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 + 
        5^Rational[1, 2])}, {-(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 - 5^Rational[1, 2])}, {0, 
      1}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 + 5^Rational[1, 2])}, {(Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 - 5^
        Rational[1, 2])}, {-(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 - 5^
        Rational[1, 2])}, {-(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 1}}, {{0, 1}, {
      0.5877852522924731, -0.8090169943749475}, {-0.9510565162951535, 
      0.30901699437494745`}, {0.9510565162951535, 
      0.30901699437494745`}, {-0.5877852522924731, -0.8090169943749475}, {0, 
      1}, {0.9510565162951535, 0.30901699437494745`}, {
      0.5877852522924731, -0.8090169943749475}, {-0.5877852522924731, \
-0.8090169943749475}, {-0.9510565162951535, 0.30901699437494745`}, {0, 
      1}}]], 
   {Thickness[0.007], 
    LineBox[NCache[{{-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 
        Rational[1, 4] (-1 + 5^Rational[1, 2])}, {(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 + 5^Rational[1, 2])}, {
       0, (-1) GoldenRatio^(-2)}, {(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{-0.9510565162951535, 
       0.30901699437494745`}, {0.9510565162951535, 0.30901699437494745`}, {
       0, -0.38196601125010515`}, {
       0.5877852522924731, -0.8090169943749475}}]]}, 
   {Thickness[0.007], 
    LineBox[NCache[{{-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2] GoldenRatio^(-2), 
        Rational[1, 4] (1 + 5^Rational[1, 2]) 
        GoldenRatio^(-2)}, {-(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2] GoldenRatio^(-2), 
        Rational[1, 4] (1 - 5^Rational[1, 2]) 
        GoldenRatio^(-2)}}, {{-0.2245139882897927, 
      0.30901699437494745`}, {-0.36327126400268045`, \
-0.11803398874989486`}}]]}, InsetBox[
    StyleBox["\<\"A\"\>",
     StripOnInput->False,
     FontSize->18], {0, 0.37}], InsetBox[
    StyleBox["\<\"B\"\>",
     StripOnInput->False,
     FontSize->18], {0.55, -0.1}], InsetBox[
    StyleBox["\<\"C\"\>",
     StripOnInput->False,
     FontSize->18], {0.22, -0.65}], InsetBox[
    StyleBox["\<\"D\"\>",
     StripOnInput->False,
     FontSize->18], {-0.23, 0.05}]},
  ImageSize->{297., Automatic}]], "Output",
 CellChangeTimes->{3.5390247076401253`*^9},
 TextAlignment->Center],

Cell[TextData[{
 "En t\[EAcute]rminos trigonom\[EAcute]tricos, hemos demostrado que ",
 StyleBox["sen ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["18",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 " = 1/",
 StyleBox["2\[CapitalPhi]",
  FontFamily->"Times"],
 ". Usando las f\[OAcute]rmulas para el seno y el coseno del \[AAcute]ngulo \
doble obtenemos f\[AAcute]cilmente las razones trigonom\[EAcute]tricas del \
\[AAcute]ngulo de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["36",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ", de modo que tambi\[EAcute]n conocemos las de sus \[AAcute]ngulos \
complementarios: ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["72",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 " y ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["54",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ": "
}], "Text",
 CellChangeTimes->{{3.538775398035116*^9, 3.53877539803685*^9}, {
  3.538855525610598*^9, 3.538855630766728*^9}, {3.538857738566401*^9, 
  3.538857801118487*^9}, {3.538941301535119*^9, 3.538941349154038*^9}},
 Hyphenation->False],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"\[CapitalAAcute]ngulo\"\>", "\<\"sen\"\>", "\<\"cos\"\>"},
    {"18", 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(\[CapitalPhi] - 1\\), \\(2\\)]\\) \
=\\!\\(\\*FractionBox[\\(\\(-1\\)\\(+\\)\\*SqrtBox[\\(5\\)]\\(\\\\ \\)\\), \
\\(4\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[SqrtBox[\\(\[CapitalPhi] + 2\\)], \
\\(2\\)]\\) \
=\\!\\(\\*SqrtBox[FractionBox[\\(\\(5\\)\\(+\\)\\*SqrtBox[\\(5\\)]\\(\\\\ \\)\
\\), \\(8\\)]]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18]},
    {"36", 
     StyleBox["\<\"\\!\\(\\*FractionBox[SqrtBox[\\(3 - \[CapitalPhi]\\)], \
\\(2\\)]\\) \
=\\!\\(\\*SqrtBox[FractionBox[\\(\\(5\\)\\(-\\)\\*SqrtBox[\\(5\\)]\\(\\\\ \\)\
\\), \\(8\\)]]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(\[CapitalPhi]\\), \\(2\\)]\\) =\\!\
\\(\\*FractionBox[\\(\\(1\\)\\(+\\)\\*SqrtBox[\\(5\\)]\\(\\\\ \\)\\), \
\\(4\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18]}
   },
   AutoDelete->False,
   GridBoxDividers->{
    "Columns" -> {False, True, True, True}, "Rows" -> {False, True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.538857690400725*^9, 3.5420504287205563`*^9},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[StyleBox["ALGUNOS DATOS SOBRE LOS PRIMEROS \
POL\[CapitalIAcute]GONOS",
 FontSize->18,
 FontColor->RGBColor[0, 0, 1]]], "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellMargins->{{100, 100}, {16, 18}},
 CellChangeTimes->{{3.538515429422391*^9, 3.538515429424019*^9}, {
  3.538517083097238*^9, 3.538517086760803*^9}, {3.538772137916774*^9, 
  3.5387721418334713`*^9}, {3.5389433492789*^9, 3.538943354615024*^9}, {
  3.538944083654379*^9, 3.538944088838513*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell["\<\
Los \[UAcute]nicos datos de la tabla siguiente que no son inmediatos son los \
correpondientes al pent\[AAcute]gono, que se deducen de los c\[AAcute]lculos \
precedentes:\
\>", "Text",
 CellChangeTimes->{{3.538857994585333*^9, 3.538858009032097*^9}, {
  3.5388580466355124`*^9, 3.538858064854611*^9}},
 Hyphenation->False],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Pol\[IAcute]gono\"\>", "\<\"radio\"\>", "\<\"apotema\"\>", "\<\"\
\[AAcute]rea\"\>"},
    {"\<\"{3}\"\>", 
     StyleBox["\<\"\\!\\(\\*FractionBox[SqrtBox[\\(3\\)], \\(3\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[SqrtBox[\\(3\\)], \\(6\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[SqrtBox[\\(3\\)], \\(4\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18]},
    {"\<\"{4}\"\>", 
     StyleBox["\<\"\\!\\(\\*FractionBox[SqrtBox[\\(2\\)], \\(2\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(1\\), \\(2\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14]},
    {"\<\"{5}\"\>", 
     StyleBox["\<\"\\!\\(\\*SqrtBox[FractionBox[\\(5 + \
\\*SqrtBox[\\(5\\)]\\), \\(10\\)]]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(1\\), \
\\(2\\)]\\)\\!\\(\\*SqrtBox[FractionBox[\\(5 + 2 \\*SqrtBox[\\(5\\)]\\), \\(5\
\\)]]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(5\\), \
\\(4\\)]\\)\\!\\(\\*SqrtBox[FractionBox[\\(5 + 2 \\*SqrtBox[\\(5\\)]\\), \\(5\
\\)]]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18]},
    {"\<\"{6}\"\>", 
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], 
     StyleBox["\<\"\\!\\(\\*FractionBox[SqrtBox[\\(3\\)], \\(2\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(3 \\*SqrtBox[\\(3\\)]\\), \\(2\\)]\
\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18]},
    {"\<\"{8}\"\>", 
     StyleBox["\<\"\\!\\(\\*SqrtBox[FractionBox[\\(2 + \
\\*SqrtBox[\\(2\\)]\\), \\(2\\)]]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(1 + \\*SqrtBox[\\(2\\)]\\), \
\\(2\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"2+2\\!\\(\\*SqrtBox[\\(2\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14]},
    {"\<\"{10}\"\>", 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(1 + \\*SqrtBox[\\(5\\)]\\), \
\\(2\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[SqrtBox[\\(5 + 2 \
\\*SqrtBox[\\(5\\)]\\)], \\(2\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(5\\), \\(2\\)]\\) \
\\!\\(\\*SqrtBox[\\(5 + 2 \\*SqrtBox[\\(5\\)]\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14]}
   },
   AutoDelete->False,
   GridBoxDividers->{
    "Columns" -> {False, True, True, True, True}, "Rows" -> {False, True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.539024724481698*^9, 3.5392010861606617`*^9, 3.539201330099803*^9, 
   3.539201427762287*^9, 3.5392016994998693`*^9, {3.539201748498741*^9, 
   3.539201762362111*^9}, {3.542621751756363*^9, 3.542621781677105*^9}, {
   3.542621835813004*^9, 3.542621919429224*^9}, 3.542622627550503*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Los datos corresponden a pol\[IAcute]gonos de lado ",
 StyleBox["l ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["= ",
  FontFamily->"Times",
  FontSize->18],
 StyleBox["1",
  FontFamily->"Times"],
 ". En general hay que multiplicar el radio y la apotema por ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y el \[AAcute]rea por  ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["l",
     FontFamily->"Times",
     FontSize->18], "2"], TraditionalForm]]],
 ". El \[AAcute]rea se calcula sumando el \[AAcute]rea de los ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " tri\[AAcute]ngulos de v\[EAcute]rtices en el centro del pol\[IAcute]gono y \
en cada par de lados consecutivos: ",
 StyleBox["A = nla/",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["2",
  FontFamily->"Times"],
 StyleBox[".",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " "
}], "Text",
 CellChangeTimes->{{3.5388602736904984`*^9, 3.538860335788918*^9}, {
  3.538860366316382*^9, 3.538860454044983*^9}},
 Hyphenation->False],

Cell[TextData[{
 StyleBox["\[LineSeparator]",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["2. Definici\[OAcute]n de poliedro",
  FontSize->24,
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["\[LineSeparator]",
  FontColor->RGBColor[0, 0, 1]]
}], "Section",
 CellChangeTimes->{{3.538496262748913*^9, 3.538496301701696*^9}, {
  3.538507560256893*^9, 3.538507562188425*^9}, {3.538860491527355*^9, 
  3.5388605196265087`*^9}},
 Hyphenation->False],

Cell["\<\
Los poliedros son el an\[AAcute]logo tridimensional de los pol\[IAcute]gonos. \
Sin embargo, al pasar a tres dimensiones las posibilidades se multiplican, y \
esto vale tanto para los casos de inter\[EAcute]s como para los casos patol\
\[OAcute]gicos que nos gustar\[IAcute]a excluir mediante una \
definici\[OAcute]n adecuada. La idea b\[AAcute]sica es la que recoge lo que \
podr\[IAcute]amos considerar como \"definici\[OAcute]n\" cl\[AAcute]sica de \
poliedro:\
\>", "Text",
 CellChangeTimes->{{3.5387260058049517`*^9, 3.538726005806142*^9}, {
   3.538861168125854*^9, 3.538861220346085*^9}, {3.538861260533436*^9, 
   3.5388613400833282`*^9}, 3.538861545113636*^9, {3.539029303582122*^9, 
   3.539029326472453*^9}, 3.539030572154814*^9},
 Hyphenation->False],

Cell[TextData[StyleBox["Un poliedro es una regi\[OAcute]n acotada del espacio \
limitada por un n\[UAcute]mero finito de caras poligonales,",
 FontSlant->"Italic"]], "Text",
 CellFrame->False,
 CellDingbat->"\[FilledSquare]",
 ShowSelection->True,
 ShowClosedCellArea->False,
 ShowShortBoxForm->False,
 CellMargins->{{60, 48}, {16, 16}},
 CellChangeTimes->{{3.5383398990470667`*^9, 3.538339928080864*^9}, {
  3.5383402756465397`*^9, 3.5383402996288843`*^9}, {3.538861388462598*^9, 
  3.538861392091695*^9}},
 Hyphenation->False],

Cell["\<\
o, lo que viene a ser lo mismo, un poliedro es una figura \
\[OpenCurlyDoubleQuote]de este estilo\[CloseCurlyDoubleQuote]:\
\>", "Text",
 CellChangeTimes->{{3.5383402781232967`*^9, 3.538340313707753*^9}},
 Hyphenation->False],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.6], Opacity[0.9], 
   GraphicsComplex3DBox[
    NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
      Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
      Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
      Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
      Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
      Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
      Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
      Rational[1, 2], Rational[1, 2], Rational[1, 2]}, {0.09999999999999998, 
      0.5, 0.5}, {-0.09999999999999998, 0.5, 0.5}, {-0.5, 0.09999999999999998,
       0.5}, {-0.5, -0.09999999999999998, 0.5}, {-0.09999999999999998, -0.5, 
      0.5}, {0.09999999999999998, -0.5, 0.5}, {0.5, -0.09999999999999998, 
      0.5}, {0.5, 0.09999999999999998, 0.5}, {0.5, -0.5, 
      0.09999999999999998}, {0.5, -0.5, -0.09999999999999998}, {
      0.5, -0.09999999999999998, -0.5}, {0.5, 0.09999999999999998, -0.5}, {
      0.5, 0.5, -0.09999999999999998}, {0.5, 0.5, 0.09999999999999998}, {
      0.09999999999999998, 0.5, -0.5}, {-0.09999999999999998, 
      0.5, -0.5}, {-0.5, 0.5, -0.09999999999999998}, {-0.5, 0.5, 
      0.09999999999999998}, {-0.5, 
      0.09999999999999998, -0.5}, {-0.5, -0.09999999999999998, -0.5}, {-0.5, \
-0.5, -0.09999999999999998}, {-0.5, -0.5, 0.09999999999999998}, {
      0.09999999999999998, -0.5, -0.5}, {-0.09999999999999998, -0.5, -0.5}}, \
CompressedData["
1:eJxTTMoPSmViYGBQAGJmBhh4sJ9I2p4AH10cnSbWPFz6MORnzASBnbjEcenb
j0PffnR9aHx0cZzuw2U/LvcOFncRaz+a+SS7C4c70e3BoHHJ43A/QX0AqtnX
vw==
     "]], {
     Polygon3DBox[{{9, 10, 11, 12, 13, 14, 15, 16}, {16, 15, 17, 18, 19, 20, 
      21, 22}, {22, 21, 23, 24, 25, 26, 10, 9}, {26, 25, 27, 28, 29, 30, 12, 
      11}, {28, 27, 24, 23, 20, 19, 31, 32}, {30, 29, 32, 31, 18, 17, 14, 
      13}}], Polygon3DBox[{{32, 29, 28}, {30, 13, 12}, {27, 25, 24}, {26, 11, 
      10}, {31, 19, 18}, {17, 15, 14}, {23, 21, 20}, {22, 9, 16}}]}]},
  Boxed->False,
  ImageSize->{249., Automatic},
  Lighting->"Neutral",
  ViewPoint->{1.0843946552088064`, -2.4347263645218318`, 2.084753165642609},
  ViewVertical->{-0.05875701505872377, 0.007139344866749724, 
   0.9982467845859873}]], "Output",
 CellChangeTimes->{3.539024737427733*^9},
 TextAlignment->Center],

Cell["\<\
Desgraciadamente, existen distintas posibilidades a la hora de interpretar el \
grado de parecido que ha de tener una figura con la que muestra la figura \
para que merezca ser considerada como un \[OpenCurlyDoubleQuote]poliedro\
\[CloseCurlyDoubleQuote], y la \[OpenCurlyDoubleQuote]definici\[OAcute]n\
\[CloseCurlyDoubleQuote] anterior es lo suficientemente ambig\[UDoubleDot]a \
como para no ser de mucha ayuda a la hora de elegir una en particular. Por \
otra parte, una definici\[OAcute]n que fuera completamente fiel a esta idea \
incluir\[IAcute]a necesariamente muchos casos patol\[OAcute]gicos que \
conviene excluir, no porque no sea justo considerarlos \
\[OpenCurlyDoubleQuote]regiones acotadas del espacio limitadas por un n\
\[UAcute]mero finito de caras poligonales\[CloseCurlyDoubleQuote], sino \
porque dar\[IAcute]an lugar a una mara\[NTilde]a de contraejemplos a muchos \
teoremas v\[AAcute]lidos para poliedros m\[AAcute]s \
\[OpenCurlyDoubleQuote]razonables\[CloseCurlyDoubleQuote]. Por ello, pensando \
en incluir \[UAcute]nicamente las figuras geom\[EAcute]tricas susceptibles de \
dar lugar a una teor\[IAcute]a interesante m\[AAcute]s que en ser fieles a la \
vaga noci\[OAcute]n cl\[AAcute]sica de poliedro, adoptaremos la definici\
\[OAcute]n siguiente:\
\>", "Text",
 CellChangeTimes->{
  3.5383417303229856`*^9, {3.538341922805172*^9, 3.5383419301491203`*^9}, {
   3.5383420226114893`*^9, 3.538342034198495*^9}, {3.538342109154579*^9, 
   3.538342265640889*^9}, {3.538342397572157*^9, 3.538342397574464*^9}, {
   3.538459498357407*^9, 3.538459500411277*^9}, {3.538473725901857*^9, 
   3.538473729165607*^9}, 3.538861413568597*^9, {3.5388616678254137`*^9, 
   3.538861760943488*^9}, {3.538903456864155*^9, 3.538903457693158*^9}, {
   3.539029181008608*^9, 3.539029181133046*^9}, {3.539029446696454*^9, 
   3.539029460378541*^9}, 3.53903042689968*^9, 3.53903065085581*^9, {
   3.5390310206841307`*^9, 3.539031021964514*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Un ",
 StyleBox["poliedro",
  FontSlant->"Italic"],
 " est\[AAcute] determinado por un conjunto finito (no vac\[IAcute]o) de \
puntos del espacio llamados ",
 StyleBox["v\[EAcute]rtices",
  FontSlant->"Italic"],
 " del poliedro, un conjunto de segmentos cuyos extremos sean \
v\[EAcute]rtices, llamados ",
 StyleBox["aristas",
  FontSlant->"Italic"],
 " del poliedro, y un conjunto de pol\[IAcute]gonos cuyos lados sean aristas, \
llamados ",
 StyleBox["caras",
  FontSlant->"Italic"],
 " del poliedro. Exigimos adem\[AAcute]s las condiciones siguientes:"
}], "Text",
 CellMargins->{{30, 30}, {0, 5}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
   3.538342563212167*^9, 3.538342641589696*^9}, {3.538477791518964*^9, 
   3.538477806679139*^9}, {3.538861786756031*^9, 3.5388617916487722`*^9}, {
   3.538862502914343*^9, 3.538862553744755*^9}, {3.538935743587105*^9, 
   3.538935754223081*^9}, {3.538939411691236*^9, 3.5389394121130657`*^9}, {
   3.539029482155212*^9, 3.539029516926116*^9}, 3.539029578192609*^9, {
   3.539029613890944*^9, 3.539029626505129*^9}, {3.539034396328663*^9, 
   3.539034404072836*^9}},
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell[TextData[{
 "1) Todo v\[EAcute]rtice es el extremo de al menos una arista y toda arista \
es el lado de exactamente dos caras, las cuales no est\[AAcute]n sobre el \
mismo plano. (Cuando dos caras comparten una arista diremos que son ",
 StyleBox["contiguas.",
  FontSlant->"Italic"],
 ")"
}], "Text",
 CellMargins->{{30, 30}, {0, 0}},
 CellFrameMargins->{{8, 8}, {0, 0}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
  3.538342563212167*^9, 3.538342641589696*^9}, {3.538477791518964*^9, 
  3.538477806679139*^9}, {3.538861786756031*^9, 3.5388617916487722`*^9}, {
  3.538862502914343*^9, 3.538862553744755*^9}, {3.538935743587105*^9, 
  3.538935754223081*^9}, {3.538939411691236*^9, 3.5389394121130657`*^9}, {
  3.539029482155212*^9, 3.539029488159446*^9}, {3.539029844685408*^9, 
  3.539029845147251*^9}, {3.539029908157879*^9, 3.539030035516439*^9}, {
  3.5390303019446707`*^9, 3.53903033945509*^9}, {3.5390303716752253`*^9, 
  3.539030377423381*^9}, {3.539030475442078*^9, 3.53903051228376*^9}, {
  3.539033242688464*^9, 3.5390332426907587`*^9}},
 TextJustification->1.,
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell["\<\
2) Todo par de caras puede conectarse por una sucesi\[OAcute]n de caras \
contiguas.\
\>", "Text",
 CellMargins->{{30, 30}, {0, 0}},
 CellFrameMargins->{{8, 8}, {0, 4}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
  3.538342563212167*^9, 3.538342641589696*^9}, {3.538477791518964*^9, 
  3.538477806679139*^9}, {3.538861786756031*^9, 3.5388617916487722`*^9}, {
  3.538862502914343*^9, 3.538862553744755*^9}, {3.538935743587105*^9, 
  3.538935754223081*^9}, {3.538939411691236*^9, 3.5389394121130657`*^9}, {
  3.539029482155212*^9, 3.539029488159446*^9}, {3.539029844685408*^9, 
  3.539029845147251*^9}, {3.539029908157879*^9, 3.539030035516439*^9}, {
  3.5390303019446707`*^9, 3.53903033945509*^9}, {3.5390303716752253`*^9, 
  3.539030377423381*^9}, {3.539030475442078*^9, 3.53903051228376*^9}, {
  3.539033242688464*^9, 3.539033247953103*^9}},
 TextJustification->1.,
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell[TextData[{
 "3) Las aristas que llegan a un mismo v\[EAcute]rtice pueden disponerse c\
\[IAcute]clicamente de forma que cada una y la siguiente sean lados de una \
misma cara. (Se dice entonces que las aristas son ",
 StyleBox["consecutivas",
  FontSlant->"Italic"],
 " respecto a dicho v\[EAcute]rtice.)"
}], "Text",
 CellMargins->{{30, 30}, {3, 0}},
 CellFrameMargins->{{8, 8}, {8, 4}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
  3.538342563212167*^9, 3.538342641589696*^9}, {3.538477791518964*^9, 
  3.538477806679139*^9}, {3.538861786756031*^9, 3.5388617916487722`*^9}, {
  3.538862502914343*^9, 3.538862553744755*^9}, {3.538935743587105*^9, 
  3.538935754223081*^9}, {3.538939411691236*^9, 3.5389394121130657`*^9}, {
  3.539029482155212*^9, 3.539029488159446*^9}, {3.539029844685408*^9, 
  3.539029845147251*^9}, {3.539029908157879*^9, 3.539030035516439*^9}, {
  3.5390303019446707`*^9, 3.53903033945509*^9}, {3.5390303716752253`*^9, 
  3.539030377423381*^9}, {3.539030475442078*^9, 3.53903051228376*^9}, {
  3.539033242688464*^9, 3.539033249631542*^9}},
 TextJustification->1.,
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell["\<\
La tercera condici\[OAcute]n sirve para excluir figuras como la siguiente:\
\>", "Text",
 CellChangeTimes->{{3.539030529204297*^9, 3.5390305292057467`*^9}, {
  3.5390310325105124`*^9, 3.5390310842848997`*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.7], Opacity[0.95], 
   GraphicsComplex3DBox[
    NCache[{{1, 1, 1}, {1, 1, -1}, {1, -1, -1}, {1, -1, 1}, {
      Rational[1, 2], Rational[1, 2], Rational[1, 2]}, {
      Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
      Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
      Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {-1, 1, 1}, {-1, 
      1, -1}, {-1, -1, -1}, {-1, -1, 1}, {
      Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
      Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
      Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
      Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
      Rational[-3, 4], 0, 0}}, {{1, 1, 1}, {1, 1, -1}, {1, -1, -1}, {1, -1, 
      1}, {0.5, 0.5, 0.5}, {0.5, 0.5, -0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 
      0.5}, {-1, 1, 1}, {-1, 1, -1}, {-1, -1, -1}, {-1, -1, 1}, {-0.5, 0.5, 
      0.5}, {-0.5, 0.5, -0.5}, {-0.5, -0.5, -0.5}, {-0.5, -0.5, 
      0.5}, {-0.75, 0, 0}}], 
    Polygon3DBox[{{1, 2, 3, 4}, {5, 6, 7, 8}, {1, 2, 6, 5}, {1, 5, 8, 4}, {8, 
      4, 3, 7}, {3, 7, 6, 2}, {2, 10, 11, 3}, {6, 14, 15, 7}, {3, 11, 17, 15, 
      7}, {2, 10, 17, 14, 6}, {8, 16, 13, 5}, {1, 9, 17, 13, 5}, {4, 12, 17, 
      16, 8}, {1, 9, 12, 4}, {9, 12, 17}, {14, 15, 17}, {10, 11, 17}, {13, 16,
       17}}]]},
  Boxed->False,
  ImageSize->{314.3969361026088, 283.},
  Lighting->"Neutral",
  ViewPoint->{-1.7510769885278914`, -2.792145010208325, 0.7665869958568601},
  ViewVertical->{-0.1847316022917105, -0.348109346466484, 
   0.9190724226182694}]], "Output",
 CellChangeTimes->{3.539024792706819*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Esta figura, con ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 16",
  FontFamily->"Times"],
 " caras (",
 StyleBox["4",
  FontFamily->"Times"],
 " tri\[AAcute]ngulos, ",
 StyleBox["8",
  FontFamily->"Times"],
 " cuadril\[AAcute]teros y ",
 StyleBox["4",
  FontFamily->"Times"],
 " pent\[AAcute]gonos) ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 32",
  FontFamily->"Times"],
 " aristas y ",
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 17",
  FontFamily->"Times"],
 " v\[EAcute]rtices, cumple todos los requisitos de la definici\[OAcute]n de \
poliedro excepto el \[UAcute]ltimo, pues las ocho aristas que confluyen en el \
v\[EAcute]rtice \[OpenCurlyDoubleQuote]peculiar\[CloseCurlyDoubleQuote] se \
dividen en dos grupos de cuatro, de forma que cada uno de esos grupos s\
\[IAcute] que puede disponerse c\[IAcute]clicamente como exige la propiedad \
3), pero no as\[IAcute] la totalidad de ellos. Pese a ello, se ajusta \
perfectamente a la \"definici\[OAcute]n\" de poliedro como \"regi\[OAcute]n \
del espacio limitada por caras poligonales\"."
}], "Text",
 CellChangeTimes->{{3.5383928048480587`*^9, 3.538392891886054*^9}, {
   3.5383933810549498`*^9, 3.538393532957014*^9}, {3.538394414654971*^9, 
   3.538394414661029*^9}, {3.538394632193182*^9, 3.538394632196151*^9}, 
   3.53842456175112*^9, {3.5388626405392847`*^9, 3.5388626405415897`*^9}, {
   3.538911464406926*^9, 3.538911578254334*^9}, {3.539031181368388*^9, 
   3.5390312257776127`*^9}, {3.539032370354246*^9, 3.539032424464116*^9}, {
   3.53903248852205*^9, 3.5390325023130693`*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Por el contrario, el objeto representado en la primera figura de esta secci\
\[OAcute]n cumple la definici\[OAcute]n de poliedro y tiene ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 14",
  FontFamily->"Times"],
 " caras (seis oct\[AAcute]gonos y ocho tri\[AAcute]ngulos), ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 36",
  FontFamily->"Times"],
 " aristas y ",
 StyleBox["V ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["= 24",
  FontFamily->"Times"],
 " v\[EAcute]rtices."
}], "Text",
 CellChangeTimes->{
  3.53890378591247*^9, {3.539031246605798*^9, 3.539031270519459*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Si comparamos esta definici\[OAcute]n con la definici\[OAcute]n de pol\
\[IAcute]gono dada en la secci\[OAcute]n anterior podemos notar ciertos \
paralelismos, pero tambi\[EAcute]n ciertas diferencias significativas. Por lo \
pronto, en la definici\[OAcute]n de pol\[IAcute]gono exig\[IAcute]amos que \
los lados establezcan un ciclo de v\[EAcute]rtices, de modo que podemos \
partir de un v\[EAcute]rtice cualquiera y recorrerlos todos \
movi\[EAcute]ndonos a trav\[EAcute]s de los lados hasta volver al \
v\[EAcute]rtice de partida. En cambio, en el caso de los poliedros no hay \
ning\[UAcute]n recorrido natural que nos lleve por todas sus caras, y lo m\
\[AAcute]ximo que podemos pedir es que exista una cadena de caras que nos \
lleve de una cualquiera a otra cualquiera. Esta exigencia nos asegura que no \
consideraremos como un \[UAcute]nico poliedro lo que resulta m\[AAcute]s \
natural considerar como dos poliedros independientes sin relaci\[OAcute]n \
alguna, pero tambi\[EAcute]n excluye casos como el de la figura siguiente, \
que en principio encajar\[IAcute]a con la \[OpenCurlyDoubleQuote]definici\
\[OAcute]n\[CloseCurlyDoubleQuote] cl\[AAcute]sica que hemos dado en primer \
lugar: el espacio comprendido entre los dos poliedros representados es una \
regi\[OAcute]n acotada del espacio limitada por caras poligonales (",
 StyleBox["12",
  FontFamily->"Times"],
 " cuadrados)."
}], "Text",
 CellMargins->{{12, 10}, {3, 10}},
 CellChangeTimes->{{3.5383424736666517`*^9, 3.538342473668219*^9}, {
   3.538343604089587*^9, 3.538343786961452*^9}, 3.538861514521701*^9, {
   3.538861801611517*^9, 3.538861810248761*^9}, {3.5388618414599133`*^9, 
   3.5388618416589193`*^9}, 3.538861925970969*^9, {3.538861964724223*^9, 
   3.5388620255221663`*^9}, {3.5389033984403467`*^9, 3.538903398442107*^9}, {
   3.538903514887516*^9, 3.538903751359016*^9}, {3.538903810282975*^9, 
   3.538903882930663*^9}},
 Hyphenation->False],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.7], 
    GraphicsComplex3DBox[
     NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
       Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
       Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
       Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
       Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
       Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
       Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
       Rational[1, 2], Rational[1, 2], Rational[
        1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
      0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {0.5,
       0.5, -0.5}, {0.5, 0.5, 0.5}}], 
     Polygon3DBox[{{8, 4, 2, 6}, {8, 6, 5, 7}, {8, 7, 3, 4}, {4, 3, 1, 2}, {1,
       3, 7, 5}, {2, 1, 5, 6}}]]}, 
   {GrayLevel[0.3], 
    GeometricTransformation3DBox[
     GraphicsComplex3DBox[
      NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
        Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
        Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
        Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
        Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
        Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
        Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
        Rational[1, 2], Rational[1, 2], Rational[
         1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
       0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {
       0.5, 0.5, -0.5}, {0.5, 0.5, 0.5}}], 
      Polygon3DBox[{{8, 4, 2, 6}, {8, 6, 5, 7}, {8, 7, 3, 4}, {4, 3, 1, 2}, {
       1, 3, 7, 5}, {2, 1, 5, 6}}]], {{{0.5, 0., 0.}, {0., 0.5, 0.}, {0., 0., 
      0.5}}, Center}]}},
  Boxed->False,
  ImageSize->{303., Automatic},
  Lighting->"Neutral",
  ViewPoint->{1.6466247065978095`, -2.836450767107627, 0.8325707906215742},
  ViewVertical->{0.1921944677719952, -0.32136248814658197`, 
   0.9272472365933897}]], "Output",
 CellChangeTimes->{3.539024754554676*^9},
 TextAlignment->Center],

Cell["\<\
Por otro lado, la definici\[OAcute]n precedente admite deliberadamente \
poliedros con autointersecciones como el que muestra la figura siguiente, que \
ser\[IAcute]a razonable considerar contrarios al \[OpenCurlyDoubleQuote]esp\
\[IAcute]ritu\[CloseCurlyDoubleQuote] de la \[OpenCurlyDoubleQuote]definici\
\[OAcute]n\[CloseCurlyDoubleQuote] cl\[AAcute]sica:\
\>", "Text",
 CellChangeTimes->{{3.538903917751033*^9, 3.538903944656398*^9}, {
  3.539031368226218*^9, 3.5390314481522207`*^9}},
 Hyphenation->False],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.6], Opacity[0.8], 
   GraphicsComplex3DBox[
    NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
      Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
      Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
      Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
      Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
      Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
      Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
      Rational[1, 2], Rational[1, 2], Rational[1, 2]}, {0, 0, 
      1}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 0.5, -0.5}, {-0.5, 
      0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {0.5, 0.5, -0.5}, {0.5, 
      0.5, 0.5}, {0, 0, 1}}], 
    Polygon3DBox[{{8, 4, 2, 6}, {8, 6, 5, 7}, {8, 7, 3, 4}, {4, 3, 1, 2}, {2, 
      1, 5, 6}, {1, 3, 9}, {3, 7, 9}, {7, 5, 9}, {5, 1, 9}}]]},
  Boxed->False,
  ImageSize->{234.5640247727681, Automatic},
  Lighting->"Neutral",
  ViewPoint->{1.711252317964398, -2.7192078140905176`, 1.0618495034846258`},
  ViewVertical->{0.2855709453409677, -0.3666171764173035, 
   0.9507987475177254}]], "Output",
 CellChangeTimes->{3.539024771337989*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Aqu\[IAcute] vemos un poliedro con ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 9",
  FontFamily->"Times"],
 " caras, ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 16",
  FontFamily->"Times"],
 " aristas y ",
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 9",
  FontFamily->"Times"],
 " v\[EAcute]rtices en el que las cuatro caras triangulares cortan a una de \
las caras cuadradas. Para excluir las autointersecciones introducimos las \
condiciones siguientes:"
}], "Text",
 CellChangeTimes->{{3.5383442173980017`*^9, 3.538344230454054*^9}, {
  3.539031453915634*^9, 3.539031454464315*^9}, {3.5390328036296387`*^9, 
  3.5390328224998493`*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Diremos que un poliedro es ",
 StyleBox["simple",
  FontSlant->"Italic"],
 " si cuando dos de sus aristas tienen un punto en com\[UAcute]n \[EAcute]ste \
es uno de sus extremos, y cuando dos de sus caras tienen un punto en com\
\[UAcute]n entonces su intersecci\[OAcute]n es, o bien uno de sus \
v\[EAcute]rtices, o bien uno de sus lados."
}], "Text",
 CellMargins->{{30, 30}, {3, 5}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
  3.538342563212167*^9, 3.538342641589696*^9}, {3.5383442356780663`*^9, 
  3.538344341344078*^9}, {3.538459597238266*^9, 3.53845959926803*^9}, {
  3.539031332002205*^9, 3.539031333224443*^9}},
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell["\<\
En particular, las caras de un poliedro simple son pol\[IAcute]gonos simples.\
\
\>", "Text",
 CellChangeTimes->{{3.538343974909299*^9, 3.53834405750063*^9}, {
   3.5383441194374857`*^9, 3.538344145221197*^9}, {3.538344215255472*^9, 
   3.538344215258232*^9}, {3.5383444960268784`*^9, 3.5383448034123497`*^9}, {
   3.538388962037671*^9, 3.538388962041355*^9}, {3.538390404394182*^9, 
   3.5383904116332073`*^9}, 3.538862146406411*^9, {3.538862231860979*^9, 
   3.5388622718771467`*^9}, {3.538903994878405*^9, 3.538903998889532*^9}, {
   3.538910718557229*^9, 3.538910737903081*^9}, {3.5390314953294497`*^9, 
   3.539031497344427*^9}},
 Hyphenation->False],

Cell["\<\
Si alguien podr\[IAcute]a considerar nuestra definici\[OAcute]n \
\[OpenCurlyDoubleQuote]excesivamente generosa\[CloseCurlyDoubleQuote] por \
admitir autointersecciones, tambi\[EAcute]n podr\[IAcute]a tacharla de \
\[OpenCurlyDoubleQuote]excesivamente restrictiva\[CloseCurlyDoubleQuote] por \
exigir que cada arista sea compartida exactamente por dos caras. Ciertamente, \
admitir poliedros con aristas que formen parte de una \[UAcute]nica cara s\
\[OAcute]lo supondr\[IAcute]a aceptar como tales a objetos \
patol\[OAcute]gicos (como por ejemplo, dos pol\[IAcute]gonos cualesquiera \
situados en planos distintos y unidos por un lado), pero es cuestionable que \
no se pueda admitir la existencia de aristas compartidas por m\[AAcute]s de \
dos caras. Consideremos por ejemplo la figura siguiente:\
\>", "Text",
 CellChangeTimes->{{3.538343974909299*^9, 3.53834405750063*^9}, {
   3.5383441194374857`*^9, 3.538344145221197*^9}, {3.538344215255472*^9, 
   3.538344215258232*^9}, {3.5383444960268784`*^9, 3.5383448034123497`*^9}, {
   3.538388962037671*^9, 3.538388962041355*^9}, {3.538390404394182*^9, 
   3.5383904116332073`*^9}, 3.538862146406411*^9, {3.538862231860979*^9, 
   3.5388622718771467`*^9}, {3.538903994878405*^9, 3.538903998889532*^9}, 
   3.538910718557229*^9, {3.5390315139467983`*^9, 3.53903154302487*^9}, {
   3.539031583465514*^9, 3.539031686434369*^9}, {3.53903171862222*^9, 
   3.5390318452517853`*^9}},
 Hyphenation->False],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = False, $CellContext`v$$ = 1., 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`v$$], 1, "Opacidad"}, 0, 1}, {{
       Hold[$CellContext`u$$], False, "Ocultar Tri\[AAcute]ngulos"}, {
      True, False}}}, Typeset`size$$ = {360., {193., 198.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`v$10666$$ = 0, $CellContext`u$10667$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`u$$ = False, $CellContext`v$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`v$$, $CellContext`v$10666$$, 0], 
        Hold[$CellContext`u$$, $CellContext`u$10667$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{
         GrayLevel[0.5], 
         Opacity[$CellContext`v$$], 
         GraphicsComplex[{{-2^Rational[1, 2], 0, 0}, {
           0, 0, 2^Rational[1, 2]}, {0, 0, -2^Rational[1, 2]}, {
           0, 2^Rational[1, 2], 0}, {0, -2^Rational[1, 2], 0}, {
           2^Rational[1, 2], 0, 0}, {0, 0, 0}}, 
          Polygon[
           
           If[$CellContext`u$$, {{4, 1, 7}, {2, 1, 7}, {3, 1, 7}, {3, 4, 7}, {
            4, 2, 7}, {4, 6, 7}, {2, 6, 7}, {3, 6, 7}, {1, 7, 5}, {7, 6, 5}, {
            3, 7, 5}, {2, 7, 5}}, {{4, 1, 2}, {2, 5, 6}, {3, 4, 6}, {1, 3, 
            5}, {4, 1, 7}, {2, 1, 7}, {3, 1, 7}, {3, 4, 7}, {4, 2, 7}, {4, 6, 
            7}, {2, 6, 7}, {3, 6, 7}, {1, 7, 5}, {7, 6, 5}, {3, 7, 5}, {2, 7, 
            5}}]]]}, Lighting -> "Neutral", Boxed -> False], 
      "Specifications" :> {{{$CellContext`v$$, 1, "Opacidad"}, 0, 1, 
         AppearanceElements -> {}}, {{$CellContext`u$$, False, 
          "Ocultar Tri\[AAcute]ngulos"}, {True, False}}}, 
      "Options" :> {AppearanceElements -> {}}, "DefaultOptions" :> {}],
     ImageSizeCache->{405., {241., 247.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.5390288176548643`*^9, 3.539028858759151*^9}, {
   3.539028905304647*^9, 3.539028920259926*^9}, 3.5391718791955976`*^9, 
   3.539172038738534*^9, 3.540329004867385*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Esta figura podr\[IAcute]a interpretarse como un poliedro simple con ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 16",
  FontFamily->"Times"],
 " caras triangulares, ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 18",
  FontFamily->"Times"],
 " aristas y ",
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 7",
  FontFamily->"Times"],
 " v\[EAcute]rtices salvo por el hecho de que ",
 StyleBox["6",
  FontFamily->"Times"],
 " de las aristas son compartidas por ",
 StyleBox["4",
  FontFamily->"Times"],
 " caras cada una. No obstante, la figura es tambi\[EAcute]n un poliedro seg\
\[UAcute]n la definici\[OAcute]n que hemos dado, pero consider\[AAcute]ndolo \
como formado por ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 7",
  FontFamily->"Times"],
 " caras (tres cuadrados y cuatro tri\[AAcute]ngulos), ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 12",
  FontFamily->"Times"],
 " aristas y ",
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 6",
  FontFamily->"Times"],
 " v\[EAcute]rtices, de tal forma que las caras cuadradas se cortan por sus \
diagonales (el lector deber\[IAcute]a pararse a comprobar que as\[IAcute] se \
cumple tambi\[EAcute]n la condici\[OAcute]n 3 de nuestra definici\[OAcute]n \
de poliedro). Pensando en casos como \[EAcute]ste resulta razonable \
considerar una definici\[OAcute]n de poliedro un poco m\[AAcute]s generosa \
que la que hemos dado de forma que se admitan aristas que forman parte de ",
 StyleBox["un n\[UAcute]mero par",
  FontSlant->"Italic"],
 " de caras (y en tal caso en la definici\[OAcute]n de poliedro simple se \
incluye la condici\[OAcute]n de que . No obstante, nosotros nos \
ce\[NTilde]iremos a la definici\[OAcute]n que hemos dado."
}], "Text",
 CellChangeTimes->{{3.5383891612699747`*^9, 3.538389180188634*^9}, {
   3.538389553113289*^9, 3.53838955362397*^9}, {3.5383895839265633`*^9, 
   3.538389646022297*^9}, {3.53838969807136*^9, 3.538389858240666*^9}, {
   3.5383899012016277`*^9, 3.5383899842330923`*^9}, {3.53839055599207*^9, 
   3.538390555995521*^9}, {3.538862336536537*^9, 3.538862350455886*^9}, 
   3.539029097833846*^9, {3.539031869107094*^9, 3.539031869171102*^9}, {
   3.5390320528616333`*^9, 3.539032182919454*^9}, {3.5390322798408413`*^9, 
   3.539032316087719*^9}},
 Hyphenation->False],

Cell["\<\
El concepto de poliedro simple es el equivalente tridimensional al de pol\
\[IAcute]gono simple, aunque esto debe ser matizado. En realidad se trata de \
una propiedad puramente topol\[OAcute]gica: un poliedro es simple si y s\
\[OAcute]lo si cada uno de sus puntos tiene un entorno homeomorfo a un \
subconjunto abierto del plano. La ausencia de autointersecciones garantiza \
que esto es as\[IAcute] para los puntos interiores de sus caras, el hecho de \
que cada arista sea compartida exactamente por dos caras lo garantiza para \
los puntos interiores de sus aristas y la propiedad 3) de la \
definici\[OAcute]n de poliedro lo garantiza para sus v\[EAcute]rtices. M\
\[AAcute]s concretamente, los poliedros simples son superficies compactas, \
necesariamente orientables, pues las superficies compactas no orientables no \
pueden sumergirse en el espacio tridimensional.\
\>", "Text",
 CellChangeTimes->{{3.538862663216549*^9, 3.538862663218359*^9}, {
  3.538911695271253*^9, 3.538911791168148*^9}, {3.538912561993635*^9, 
  3.538912616022859*^9}, {3.538912658161076*^9, 3.53891265816448*^9}, {
  3.539032697629139*^9, 3.539032741019761*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Este hecho tiene su an\[AAcute]logo en pol\[IAcute]gonos: un \
pol\[IAcute]gono es simple si y s\[OAcute]lo si es homeomorfo a una \
circunferencia, es decir, si y s\[OAcute]lo si es una variedad \
topol\[OAcute]gica compacta de dimensi\[OAcute]n ",
 StyleBox["1",
  FontFamily->"Times"],
 ", porque sucede que todas las variedades topol\[OAcute]gicas compactas de \
dimensi\[OAcute]n ",
 StyleBox["1",
  FontFamily->"Times"],
 " son homeomorfas a circunferencias. Sin embargo, existen infinitas \
superficies topol\[OAcute]gicas compactas no homeomorfas entre s\[IAcute], \
determinadas por un \[UAcute]nico invariante llamado ",
 StyleBox["g\[EAcute]nero:",
  FontSlant->"Italic"],
 " las superficies de g\[EAcute]nero ",
 StyleBox["0",
  FontFamily->"Times"],
 " son las homeomorfas a esferas, las de g\[EAcute]nero ",
 StyleBox["1",
  FontFamily->"Times"],
 " son las homemorfas a toros, es decir, las que tienen un \
\[OpenCurlyDoubleQuote]agujero\[CloseCurlyDoubleQuote], las de g\[EAcute]nero \
",
 StyleBox["2",
  FontFamily->"Times"],
 " tienen dos agujeros, etc."
}], "Text",
 CellChangeTimes->{{3.5383946332880707`*^9, 3.5383946826331997`*^9}, {
  3.538911888483275*^9, 3.538911889096966*^9}, {3.538913047434484*^9, 
  3.53891306876294*^9}, {3.539032844055066*^9, 3.539032844382841*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Por ejemplo, la figura siguiente muestra un poliedro simple de \
g\[EAcute]nero ",
 StyleBox["1",
  FontFamily->"Times"],
 ", con ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 16",
  FontFamily->"Times"],
 " caras (cuadril\[AAcute]teros), ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 32",
  FontFamily->"Times"],
 " aristas y ",
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 16",
  FontFamily->"Times"],
 " v\[EAcute]rtices:"
}], "Text",
 CellChangeTimes->{{3.5383946332880707`*^9, 3.5383946826331997`*^9}, {
  3.538911888483275*^9, 3.538911889096966*^9}, {3.538913047434484*^9, 
  3.53891306876294*^9}, {3.539032844055066*^9, 3.5390328443793793`*^9}},
 Hyphenation->False],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.6], Opacity[0.95], 
   Polygon3DBox[
    NCache[{{Rational[1, 2], Rational[1, 2], Rational[1, 2]}, {
      Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
      Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
      Rational[1, 2], Rational[-1, 2], Rational[1, 2]}}, {{0.5, 0.5, 0.5}, {
     0.5, 0.5, -0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}}]], 
   Polygon3DBox[
    NCache[{{Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
      Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
      Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
      Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}}, {{-0.5, 0.5, 
     0.5}, {-0.5, 0.5, -0.5}, {-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2], Rational[1, 2], Rational[1, 2]}, {
      Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
      Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
      Rational[1, 2], Rational[-1, 2], Rational[1, 2]}}, {{0.5, 0.5, 
     0.5}, {-0.5, 0.5, 0.5}, {-0.5, -0.5, 0.5}, {0.5, -0.5, 0.5}}]], 
   Polygon3DBox[
    NCache[{{Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
      Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
      Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
      Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}}, {{0.5, 
     0.5, -0.5}, {-0.5, 0.5, -0.5}, {-0.5, -0.5, -0.5}, {0.5, -0.5, -0.5}}]], 
   Polygon3DBox[{{1, 1, 1}, {1, 1, -1}, {1, -1, -1}, {1, -1, 1}}], 
   Polygon3DBox[{{-1, 1, 1}, {-1, 1, -1}, {-1, -1, -1}, {-1, -1, 1}}], 
   Polygon3DBox[{{1, 1, 1}, {-1, 1, 1}, {-1, -1, 1}, {1, -1, 1}}], 
   Polygon3DBox[{{1, 1, -1}, {-1, 1, -1}, {-1, -1, -1}, {1, -1, -1}}], 
   Polygon3DBox[
    NCache[{{1, 1, 1}, {Rational[1, 2], Rational[1, 2], Rational[1, 2]}, {
      Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {1, 1, -1}}, {{1, 1, 
      1}, {0.5, 0.5, 0.5}, {0.5, 0.5, -0.5}, {1, 1, -1}}]], 
   Polygon3DBox[
    NCache[{{1, 1, 1}, {Rational[1, 2], Rational[1, 2], Rational[1, 2]}, {
      Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {-1, 1, 1}}, {{1, 1, 
      1}, {0.5, 0.5, 0.5}, {-0.5, 0.5, 0.5}, {-1, 1, 1}}]], 
   Polygon3DBox[
    NCache[{{-1, 1, 1}, {Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
      Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {-1, 1, -1}}, {{-1, 
      1, 1}, {-0.5, 0.5, 0.5}, {-0.5, 0.5, -0.5}, {-1, 1, -1}}]], 
   Polygon3DBox[
    NCache[{{-1, 1, -1}, {Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
      Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {1, 1, -1}}, {{-1, 
      1, -1}, {-0.5, 0.5, -0.5}, {0.5, 0.5, -0.5}, {1, 1, -1}}]], 
   Polygon3DBox[
    NCache[{{1, -1, 1}, {Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
      Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {1, -1, -1}}, {{
      1, -1, 1}, {0.5, -0.5, 0.5}, {0.5, -0.5, -0.5}, {1, -1, -1}}]], 
   Polygon3DBox[
    NCache[{{1, -1, 1}, {Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
      Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {-1, -1, 1}}, {{
      1, -1, 1}, {0.5, -0.5, 0.5}, {-0.5, -0.5, 0.5}, {-1, -1, 1}}]], 
   Polygon3DBox[
    NCache[{{-1, -1, 1}, {Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
      Rational[-1, 2], Rational[-1, 2], 
       Rational[-1, 2]}, {-1, -1, -1}}, {{-1, -1, 1}, {-0.5, -0.5, 
      0.5}, {-0.5, -0.5, -0.5}, {-1, -1, -1}}]], 
   Polygon3DBox[
    NCache[{{-1, -1, -1}, {
      Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
      Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
      1, -1, -1}}, {{-1, -1, -1}, {-0.5, -0.5, -0.5}, {0.5, -0.5, -0.5}, {
      1, -1, -1}}]]},
  Boxed->False,
  ImageSize->{337.0639110548616, 333.},
  Lighting->"Neutral",
  ViewPoint->{-1.1904349171670219`, -3.037383518308855, 0.8984242153321917},
  ViewVertical->{-0.11022733001056534`, -0.33889112757970774`, 
   0.9343461560719862}]], "Output",
 CellChangeTimes->{3.539024833310192*^9},
 TextAlignment->Center],

Cell[TextData[{
 "En general, podemos distinguir puntos interiores y puntos exteriores en \
cualquier poliedro con el mismo criterio empleado para los pol\[IAcute]gonos: \
el complementario de un poliedro tiene una \[UAcute]nica componente conexa no \
acotada, a saber, la que contiene al exterior de una esfera que contenga al \
poliedro, por lo que podemos llamar puntos ",
 StyleBox["interiores",
  FontSlant->"Italic"],
 " a los de las restantes componentes conexas y ",
 StyleBox["puntos exteriores",
  FontSlant->"Italic"],
 " a los de dicha \[UAcute]nica componente no acotada. Teniendo en cuenta que \
las componentes conexas de los abiertos son arcoconexas, esto equivale a que \
un punto es exterior si puede unirse con un punto lejano mediante un arco que \
no pasa por el poliedro."
}], "Text",
 CellChangeTimes->{{3.538936051470461*^9, 3.538936146105069*^9}, {
   3.5389362085006447`*^9, 3.538936253938459*^9}, 3.5389363278447437`*^9, {
   3.5390328627764*^9, 3.539032863844697*^9}},
 Hyphenation->False],

Cell["\<\
El concepto de pol\[IAcute]gono convexo admite una generalizaci\[OAcute]n \
obvia:\
\>", "Text",
 CellChangeTimes->{{3.538425329914785*^9, 3.5384253736780157`*^9}, {
  3.538913471534492*^9, 3.538913485254065*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Un poliedro es ",
 StyleBox["convexo",
  FontSlant->"Italic"],
 " si, para cada una de sus caras, el plano que la contiene deja todo el \
poliedro en uno de los semiespacios que determina."
}], "Text",
 CellMargins->{{30, 30}, {3, 5}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
  3.538342563212167*^9, 3.538342641589696*^9}, {3.5383442356780663`*^9, 
  3.538344341344078*^9}, {3.5383916368989153`*^9, 3.538391701841703*^9}, {
  3.538391805282505*^9, 3.5383918567709513`*^9}, {3.538391941949873*^9, 
  3.538391963140169*^9}, {3.538425381242011*^9, 3.538425424800625*^9}, {
  3.538425576780856*^9, 3.538425578658119*^9}, {3.5384256855156183`*^9, 
  3.5384256859475107`*^9}, {3.538425795101571*^9, 3.538425800156361*^9}, {
  3.538913547649026*^9, 3.53891355201474*^9}},
 TextJustification->1.,
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell["\<\
La prueba del teorema siguiente se obtiene modificando levemente la prueba \
del teorema 1.1:\
\>", "Text",
 CellMargins->{{12, 10}, {16, 16}},
 CellOpen->True,
 CellChangeTimes->{{3.538938911515943*^9, 3.538938935827588*^9}},
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Teorema 2.1:",
  FontWeight->"Bold"],
 " ",
 StyleBox["Un poliedro es convexo si y s\[OAcute]lo si es simple y su \
interior es un abierto convexo (en el sentido usual) del cual es la frontera.",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.5389137703547583`*^9, 3.5389137703558292`*^9}, {
  3.538936348575355*^9, 3.538936353082754*^9}, {3.5389363859230824`*^9, 
  3.5389364193157597`*^9}},
 Hyphenation->False],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": Sea ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " un poliedro convexo, para cada una de sus caras ",
 StyleBox["C,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " sea ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["S", "C"],
    FontFamily->"Times",
    FontSize->18,
    FontSlant->"Italic"], TraditionalForm]]],
 " el semiespacio abierto que determina el plano que la contiene y que \
contiene a ",
 StyleBox["P,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y sea ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " la intersecci\[OAcute]n de dichos semiespacios. Puesto que los \
semiespacios son convexos (en el sentido usual) y la intersecci\[OAcute]n de \
convexos es convexa, tenemos que ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un abierto convexo. Veamos que ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es la frontera de ",
 StyleBox["I.",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " Para ello observamos en primer lugar que la intersecci\[OAcute]n de las \
clausuras de los semiespacios ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["S", "C"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 " (es decir, los correspondientes semiespacios cerrados) es un cerrado que \
contiene a ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " luego la clausura de ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " y en particular su frontera, est\[AAcute]n contenidos en dicha intersecci\
\[OAcute]n."
}], "Text",
 CellChangeTimes->{{3.538508131065311*^9, 3.538508131066758*^9}, {
   3.538508219779613*^9, 3.53850822189851*^9}, 3.538508256716732*^9, {
   3.538508332112483*^9, 3.538508348003789*^9}, {3.538508476613061*^9, 
   3.538508610806892*^9}, {3.53850875853757*^9, 3.5385087664086313`*^9}, {
   3.53850905094971*^9, 3.538509050955024*^9}, {3.5385090901004057`*^9, 
   3.538509101339892*^9}, {3.538509133655287*^9, 3.538509179588949*^9}, {
   3.538553535570861*^9, 3.5385535392137957`*^9}, {3.538936947879589*^9, 
   3.538937046842136*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "As\[IAcute] pues, si un punto ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] en la frontera de ",
 StyleBox["I,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] en las clausuras de todos los semiespacios ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["S", "C"],
    FontFamily->"Times",
    FontSize->18,
    FontSlant->"Italic"], TraditionalForm]]],
 ", y tiene que estar en la frontera de alguno de ellos, pues si estuviera en \
el interior de todos estar\[IAcute]a en ",
 StyleBox["I,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " lo cual es imposible porque ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es abierto. Esto significa que ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] en el plano que prolonga a una cara ",
 StyleBox["C.",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " Observemos que la definici\[OAcute]n de poliedro convexo implica que las \
caras de un poliedro convexo cumplen la definici\[OAcute]n de \
pol\[IAcute]gono convexo, y el hecho de que ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18],
 " est\[EAcute] en todos los semiespacios cerrados definidos por los planos \
de las caras de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " que contienen a ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " implica que ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] en todos los semiplanos definidos por los lados de ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " que contienen a ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", es decir, que est\[AAcute] en ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " luego en ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellChangeTimes->{{3.538509064237102*^9, 3.5385090710433817`*^9}, {
  3.538509181092852*^9, 3.538509237077456*^9}, {3.538509312864653*^9, 
  3.538509326166192*^9}, {3.538509386377708*^9, 3.53850953043182*^9}, {
  3.538937056977779*^9, 3.5389370913588743`*^9}, {3.538937324846045*^9, 
  3.538937324963153*^9}, {3.5389376016874*^9, 3.538937603942813*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "Por otro lado, si ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es una cara de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un punto de su interior, tenemos que ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] en todos los semiespacios abiertos determinados por las caras \
restantes (pues es f\[AAcute]cil ver que no puede haber dos caras situadas \
sobre el mismo plano, ya que entonces, como ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es la intersecci\[OAcute]n de los semiplanos determinados por las \
prolongaciones de sus lados y otra cara distinta ",
 StyleBox["C\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " no puede estar contenida en ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", si ",
 StyleBox["C\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " estuviera en el mismo plano no estar\[IAcute]a contenida en uno de dichos \
semiplanos, luego la cara contigua a ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " por el lado correspondiente determinar\[IAcute]a un plano que tendr\
\[IAcute]a puntos de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " en ambos semiespacios, en contradicci\[OAcute]n con la convexidad de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "). Por lo tanto, todos los puntos de un entorno ",
 StyleBox["U",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute]n en la intersecci\[OAcute]n de los restantes semiespacios \
abiertos y, dado cualquier entorno ",
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " tenemos que ",
 StyleBox["U ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["\[Intersection]",
  FontFamily->"Times"],
 StyleBox[" V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " corta a ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["S", "C"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 ", luego a ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " Esto prueba que ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18],
 " est\[AAcute] en la frontera de ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellChangeTimes->{{3.538509537880188*^9, 3.5385095394880543`*^9}, {
  3.538509575912518*^9, 3.538509661401485*^9}, {3.5385097705794077`*^9, 
  3.538509794826971*^9}, {3.5385098597077503`*^9, 3.538510107678356*^9}, {
  3.538510202137384*^9, 3.538510202143968*^9}, {3.53893761121459*^9, 
  3.538937658207592*^9}, {3.538937728365047*^9, 3.538937764375184*^9}, {
  3.5389381725199013`*^9, 3.5389382026815233`*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "Con esto hemos probado que ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es la frontera de ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " Notemos ahora que la clausura de ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18],
 " es la intersecci\[OAcute]n de las clausuras de los semiespacios ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["S", "C"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 ", pues una inclusi\[OAcute]n es obvia y, si ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] en la intersecci\[OAcute]n de los semiespacios cerrados, o \
bien est\[AAcute] en la intersecci\[OAcute]n de los semiespacios abiertos, es \
decir, en ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " o bien est\[AAcute] al menos en la frontera de uno de ellos, y bajo esas \
hip\[OAcute]tesis hemos probado m\[AAcute]s arriba que ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] en ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18],
 ", luego en ambos casos est\[AAcute] en la clausura de ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellChangeTimes->{{3.538510370208921*^9, 3.5385106585719843`*^9}, {
  3.53851119933279*^9, 3.5385112118405313`*^9}, {3.5389382573234262`*^9, 
  3.538938283934168*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "Veamos que ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un conjunto acotado. En efecto, sea ",
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " una esfera que contenga a ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " Como el exterior de ",
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " no contiene puntos de la frontera de ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " o bien todos sus puntos est\[AAcute]n en ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " o bien ninguno lo est\[AAcute], pero si todos lo estuvieran, por \
convexidad todo el interior de ",
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " estar\[IAcute]a en ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " lo cual es imposible (pues ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " no est\[AAcute] en ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "), luego ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] contenido en el interior de ",
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y es, pues, acotado. Por consiguiente, la clausura de ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un convexo compacto, y todo convexo compacto en el espacio es \
homeomorfo a una bola, de forma que la frontera (en nuestro caso ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ") es homeomorfa a la esfera correspondiente. Como la esfera es una \
superficie topol\[OAcute]gica, esto implica que ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un poliedro simple."
}], "Text",
 CellChangeTimes->{
  3.538513600917726*^9, {3.538938346165689*^9, 3.538938354271183*^9}, {
   3.538938419958103*^9, 3.53893842416527*^9}, {3.538938613071721*^9, 
   3.538938632296727*^9}, {3.538939103894834*^9, 3.538939113877736*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "El complementario de ",
 StyleBox["I ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["\[Union]",
  FontFamily->"Times"],
 StyleBox[" P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es la uni\[OAcute]n de los semiespacios abiertos complementarios de los ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox["S", "C"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 ", luego es un conjunto no acotado. Si probamos que es conexo podremos \
concluir que ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y dicho complementario son las dos \[UAcute]nicas componentes conexas del \
complementario de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " y que ",
 StyleBox["I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es la componente acotada, luego es el interior de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellChangeTimes->{{3.538510370208921*^9, 3.5385106585719843`*^9}, {
   3.53851119933279*^9, 3.538511211921948*^9}, 3.5385135977917356`*^9, {
   3.538938648839526*^9, 3.538938664060932*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "Para probar que el complementario de ",
 StyleBox["I ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["\[Union]",
  FontFamily->"Times"],
 StyleBox[" P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es conexo consideramos una esfera que contenga a todos los \
v\[EAcute]rtices de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " en su interior. Hemos visto que est\[AAcute] en dicho complementario. Como \
todo semiespacio cuya frontera pase por el interior de la esfera contiene \
puntos de la misma, resulta que los semiespacios cuya uni\[OAcute]n es el \
complementario de ",
 StyleBox["I ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["\[Union]",
  FontFamily->"Times"],
 StyleBox[" P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " cortan todos a la esfera luego tenemos una uni\[OAcute]n de conjuntos \
conexos que cortan todos a un mismo conexo. La uni\[OAcute]n es conexa."
}], "Text",
 CellChangeTimes->{{3.538510659331917*^9, 3.538510760366003*^9}, {
  3.538513620805171*^9, 3.538513648428302*^9}, {3.5385138165768223`*^9, 
  3.5385138171602716`*^9}, {3.538938701303541*^9, 3.538938726346459*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "Esto termina la prueba de una implicaci\[OAcute]n. El rec\[IAcute]proco es \
consecuencia de que los compactos convexos tienen hiperplanos de soporte en \
todos los puntos de su frontera. Concretamente, si ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es una cara de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[",",
  FontSlant->"Italic"],
 " tomamos un punto interior ",
 StyleBox["p",
  FontSlant->"Italic"],
 ", con lo que existe un plano que pasa por ",
 StyleBox["p",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y que deja a todo el convexo (en este caso la uni\[OAcute]n de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y su interior) en uno de los semiespacios que determina. Es obvio que \
dicho plano tiene que ser necesariamente la prolongaci\[OAcute]n de la cara. \
\[FilledSquare]"
}], "Text",
 CellChangeTimes->{{3.538510659331917*^9, 3.538510760366003*^9}, {
  3.538513620805171*^9, 3.538513648428302*^9}, {3.5385138165768223`*^9, 
  3.538513871342477*^9}, {3.538514558447597*^9, 3.538514684232662*^9}, {
  3.5389387389425163`*^9, 3.5389387564508963`*^9}, {3.538938812942061*^9, 
  3.538938852339839*^9}},
 TextJustification->1.,
 Hyphenation->False],

Cell[TextData[{
 "En particular hemos visto que los poliedros convexos son homeomorfos a \
esferas, y que sus interiores son homeomorfos a bolas abiertas. En la pr\
\[AAcute]ctica, la clase de los poliedros simples nos resultar\[AAcute] \
demasiado amplia, y consideraremos \[UAcute]nicamente poliedros simples de g\
\[EAcute]nero ",
 StyleBox["0",
  FontFamily->"Times"],
 ". Ya hemos explicado lo que es esto, pero destacamos la \
definici\[OAcute]n:"
}], "Text",
 CellChangeTimes->{{3.5389137730477457`*^9, 3.538913773048831*^9}, {
  3.538939561537571*^9, 3.538939600074397*^9}, {3.538939702839961*^9, 
  3.538939782676231*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Un poliedro es ",
 StyleBox["esferoide",
  FontSlant->"Italic"],
 " o ",
 StyleBox["de g\[EAcute]nero 0",
  FontSlant->"Italic"],
 " si es homeomorfo a una esfera o, equivalentemente, si es homeomorfo a un \
poliedro convexo."
}], "Text",
 CellMargins->{{30, 30}, {3, 5}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
  3.538342563212167*^9, 3.538342641589696*^9}, {3.5383442356780663`*^9, 
  3.538344341344078*^9}, {3.5383916368989153`*^9, 3.538391701841703*^9}, {
  3.538391805282505*^9, 3.5383918567709513`*^9}, {3.538391941949873*^9, 
  3.538391963140169*^9}, {3.538425381242011*^9, 3.538425424800625*^9}, {
  3.538425576780856*^9, 3.538425578658119*^9}, {3.5384256855156183`*^9, 
  3.5384256859475107`*^9}, {3.538425795101571*^9, 3.538425800156361*^9}, {
  3.538430686763076*^9, 3.538430723056788*^9}},
 TextJustification->1.,
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell["\<\
Esto significa que el poliedro puede deformarse hasta convertirse en una \
esfera (o en un poliedro convexo) sin que en la deformaci\[OAcute]n se \
produzca ninguna ruptura y sin que dos puntos distintos acaben \
peg\[AAcute]ndose. La figura siguiente muestra un poliedro esferoide no \
convexo y c\[OAcute]mo puede deformarse hasta convertirse en un poliedro \
convexo.\
\>", "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{
  3.538425909644863*^9, {3.5384284427721567`*^9, 3.53842857786215*^9}, {
   3.5384286147744303`*^9, 3.538428719455452*^9}, {3.538428759276598*^9, 
   3.538428797778804*^9}, 3.5384289010352993`*^9, 3.5384289614931192`*^9, 
   3.538429468841304*^9, {3.5384295430123053`*^9, 3.538429582982705*^9}, {
   3.538429985294374*^9, 3.538430100619576*^9}, {3.5384301309873047`*^9, 
   3.538430130991877*^9}, {3.538430620312955*^9, 3.538430621482008*^9}, {
   3.538430728552721*^9, 3.538430749873065*^9}, {3.538430783217186*^9, 
   3.538430868770301*^9}, {3.53843117981518*^9, 3.5384312117975073`*^9}},
 Hyphenation->False],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`t$$], 0, ""}, 0, 1}}, Typeset`size$$ = {
    360., {170., 174.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`t$10770$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$10770$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{
         GrayLevel[0.6], 
         GraphicsComplex[{{((-2) (2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) - $CellContext`t$$, 0, 
            0}, {(-(2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) - $CellContext`t$$/
            2, (-(2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) - $CellContext`t$$/
            2, -(2 ((1 - $CellContext`t$$)/3^
               Rational[1, 2])) - $CellContext`t$$/2^
            Rational[
             1, 2]}, {(-(2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) - $CellContext`t$$/2^
            Rational[
             1, 2], (-(2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) - $CellContext`t$$/2^Rational[1, 2], 
            0}, {(-(2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) - $CellContext`t$$/
            2, (-(2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) - $CellContext`t$$/2, 
            2 ((1 - $CellContext`t$$)/3^Rational[1, 2]) + $CellContext`t$$/2^
             Rational[1, 2]}, {(-(2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) - (2/3)^Rational[1, 2] $CellContext`t$$, 
            0, -((1 - $CellContext`t$$)/3^Rational[1, 2]) - $CellContext`t$$/
            3^Rational[
             1, 2]}, {(-(2/3)^Rational[1, 2]) (1 - $CellContext`t$$) - (2/3)^
             Rational[1, 2] $CellContext`t$$, 
            0, (1 - $CellContext`t$$)/3^Rational[1, 2] + $CellContext`t$$/3^
             Rational[1, 2]}, {(-(2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) - $CellContext`t$$/
            2, (2/3)^Rational[1, 2] (1 - $CellContext`t$$) + $CellContext`t$$/
             2, -(2 ((1 - $CellContext`t$$)/3^
               Rational[1, 2])) - $CellContext`t$$/2^
            Rational[
             1, 2]}, {(-(2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) - $CellContext`t$$/2^
            Rational[
             1, 2], (2/3)^Rational[1, 2] (
              1 - $CellContext`t$$) + $CellContext`t$$/2^Rational[1, 2], 
            0}, {(-(2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) - $CellContext`t$$/
            2, (2/3)^Rational[1, 2] (1 - $CellContext`t$$) + $CellContext`t$$/
             2, 2 ((1 - $CellContext`t$$)/3^
              Rational[1, 2]) + $CellContext`t$$/2^Rational[1, 2]}, {
           0, ((-2) (2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) - $CellContext`t$$, 0}, {
           0, (-(2/3)^Rational[1, 2]) (1 - $CellContext`t$$) - (2/3)^
             Rational[1, 2] $CellContext`t$$, -((1 - $CellContext`t$$)/3^
              Rational[1, 2]) - $CellContext`t$$/3^Rational[1, 2]}, {
           0, (-(2/3)^Rational[1, 2]) (1 - $CellContext`t$$) - (2/3)^
             Rational[1, 2] $CellContext`t$$, (1 - $CellContext`t$$)/3^
             Rational[1, 2] + $CellContext`t$$/3^Rational[1, 2]}, {
           0, 0, -(2 ((1 - $CellContext`t$$)/3^
               Rational[1, 2])) - $CellContext`t$$}, {
           0, 0, 2 ((1 - $CellContext`t$$)/3^
              Rational[1, 2]) + $CellContext`t$$}, {
           0, (2/3)^Rational[1, 2] (1 - $CellContext`t$$) + (2/3)^
              Rational[1, 2] $CellContext`t$$, -((1 - $CellContext`t$$)/3^
              Rational[1, 2]) - $CellContext`t$$/3^Rational[1, 2]}, {
           0, (2/3)^Rational[1, 2] (1 - $CellContext`t$$) + (2/3)^
              Rational[1, 2] $CellContext`t$$, (1 - $CellContext`t$$)/3^
             Rational[1, 2] + $CellContext`t$$/3^Rational[1, 2]}, {
           0, (2 (2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) + $CellContext`t$$, 
            0}, {(2/3)^Rational[1, 2] (
              1 - $CellContext`t$$) + $CellContext`t$$/
             2, (-(2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) - $CellContext`t$$/
            2, -(2 ((1 - $CellContext`t$$)/3^
               Rational[1, 2])) - $CellContext`t$$/2^
            Rational[
             1, 2]}, {(2/3)^Rational[1, 2] (
              1 - $CellContext`t$$) + $CellContext`t$$/2^
             Rational[1, 2], (-(2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) - $CellContext`t$$/2^Rational[1, 2], 
            0}, {(2/3)^Rational[1, 2] (
              1 - $CellContext`t$$) + $CellContext`t$$/
             2, (-(2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) - $CellContext`t$$/2, 
            2 ((1 - $CellContext`t$$)/3^Rational[1, 2]) + $CellContext`t$$/2^
             Rational[1, 2]}, {(2/3)^Rational[1, 2] (
              1 - $CellContext`t$$) + (2/3)^Rational[1, 2] $CellContext`t$$, 
            0, -((1 - $CellContext`t$$)/3^Rational[1, 2]) - $CellContext`t$$/
            3^Rational[
             1, 2]}, {(2/3)^Rational[1, 2] (1 - $CellContext`t$$) + (2/3)^
              Rational[1, 2] $CellContext`t$$, 
            0, (1 - $CellContext`t$$)/3^Rational[1, 2] + $CellContext`t$$/3^
             Rational[1, 2]}, {(2/3)^Rational[1, 2] (
              1 - $CellContext`t$$) + $CellContext`t$$/
             2, (2/3)^Rational[1, 2] (
              1 - $CellContext`t$$) + $CellContext`t$$/
             2, -(2 ((1 - $CellContext`t$$)/3^
               Rational[1, 2])) - $CellContext`t$$/2^
            Rational[
             1, 2]}, {(2/3)^Rational[1, 2] (
              1 - $CellContext`t$$) + $CellContext`t$$/2^
             Rational[1, 2], (2/3)^Rational[1, 2] (
              1 - $CellContext`t$$) + $CellContext`t$$/2^Rational[1, 2], 
            0}, {(2/3)^Rational[1, 2] (
              1 - $CellContext`t$$) + $CellContext`t$$/
             2, (2/3)^Rational[1, 2] (
              1 - $CellContext`t$$) + $CellContext`t$$/2, 
            2 ((1 - $CellContext`t$$)/3^Rational[1, 2]) + $CellContext`t$$/2^
             Rational[1, 2]}, {(2 (2/3)^Rational[1, 2]) (
              1 - $CellContext`t$$) + $CellContext`t$$, 0, 0}}, 
          
          Polygon[{{1, 5, 3}, {1, 3, 6}, {1, 6, 8}, {1, 8, 5}, {2, 3, 5}, {2, 
           5, 13}, {2, 13, 11}, {2, 11, 3}, {4, 12, 14}, {4, 14, 6}, {4, 6, 
           3}, {4, 3, 12}, {7, 5, 8}, {7, 8, 15}, {7, 15, 13}, {7, 13, 5}, {9,
            14, 16}, {9, 16, 8}, {9, 8, 6}, {9, 6, 14}, {10, 19, 12}, {10, 12,
            3}, {10, 3, 11}, {10, 11, 19}, {17, 15, 8}, {17, 8, 16}, {17, 16, 
           24}, {17, 24, 15}, {18, 11, 13}, {18, 13, 21}, {18, 21, 19}, {18, 
           19, 11}, {20, 19, 22}, {20, 22, 14}, {20, 14, 12}, {20, 12, 19}, {
           23, 13, 15}, {23, 15, 24}, {23, 24, 21}, {23, 21, 13}, {25, 22, 
           24}, {25, 24, 16}, {25, 16, 14}, {25, 14, 22}, {26, 24, 22}, {26, 
           22, 19}, {26, 19, 21}, {26, 21, 24}}]]}, Lighting -> "Neutral", 
        Boxed -> False], 
      "Specifications" :> {{{$CellContext`t$$, 0, ""}, 0, 1, 
         AppearanceElements -> {}}}, "Options" :> {AppearanceElements -> {}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{405., {206., 212.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.538431026629055*^9, 3.5384310375516043`*^9}, 
   3.539172051201187*^9, 3.540329054559202*^9},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "Seg\[UAcute]n hemos explicado, informalmente, un poliedro esferoide es un \
poliedro simple \[OpenCurlyDoubleQuote]sin agujeros\[CloseCurlyDoubleQuote]. \
El teorema de la curva de Jordan se generaliza al teorema de Jordan-Brouwer, \
seg\[UAcute]n el cual todo espacio ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " homeomorfo a una esfera (en particular todo poliedro esferoide) divide al \
espacio (m\[AAcute]s precisamente, a su complementario en el espacio) en dos \
componentes conexas, una acotada y otra no acotada, de las cuales ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es la frontera. En particular, su interior es siempre un conjunto conexo. \
As\[IAcute] pues, un poliedro esferoide ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " determina \[OpenCurlyDoubleQuote]una regi\[OAcute]n acotada del espacio \
limitada por un n\[UAcute]mero finito de caras poligonales\
\[CloseCurlyDoubleQuote] (las caras de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "), es decir, un poliedro en el sentido de la definici\[OAcute]n informal \
que hemos tomado como punto de partida. No obstante, conviene mantener el \
convenio que hemos adoptado en virtud del cual el poliedro es la superficie \
que limita a la regi\[OAcute]n, y no la regi\[OAcute]n misma."
}], "Text",
 CellChangeTimes->{
  3.538425909644863*^9, {3.5384284427721567`*^9, 3.53842857786215*^9}, {
   3.5384286147744303`*^9, 3.538428719455452*^9}, {3.538428759276598*^9, 
   3.538428797778804*^9}, 3.5384289010352993`*^9, 3.5384289614931192`*^9, 
   3.538429468841304*^9, {3.5384295430123053`*^9, 3.538429582982705*^9}, {
   3.538429985294374*^9, 3.538430100619576*^9}, {3.5384301309873047`*^9, 
   3.538430130991877*^9}, {3.538430620312955*^9, 3.5384306216076803`*^9}, {
   3.5384313175170813`*^9, 3.53843133828826*^9}, {3.538431608560822*^9, 
   3.5384316122567577`*^9}, {3.538431643401223*^9, 3.538431788795405*^9}, {
   3.538431836890616*^9, 3.5384318368929462`*^9}, {3.538940057434308*^9, 
   3.538940058065777*^9}, {3.5389425334159737`*^9, 3.5389425571840267`*^9}, {
   3.538942853270508*^9, 3.538942854819158*^9}},
 Hyphenation->False],

Cell[TextData[StyleBox["EJEMPLOS: PRISMAS Y PIR\[CapitalAAcute]MIDES",
 FontSize->18,
 FontColor->RGBColor[0, 0, 1]]], "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellMargins->{{100, 100}, {16, 18}},
 CellChangeTimes->{{3.538515429422391*^9, 3.538515429424019*^9}, {
  3.538517083097238*^9, 3.538517086760803*^9}, {3.538772137916774*^9, 
  3.5387721418334713`*^9}, {3.5389433492789*^9, 3.538943354615024*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell["\<\
Terminamos esta secci\[OAcute]n analizando dos ejemplos especialmente simples \
de poliedros convexos que probablemente conocer\[AAcute] ya el lector, pero \
que nos servir\[AAcute]n como introducci\[OAcute]n al estudio de los \
poliedros regulares en la secci\[OAcute]n siguiente.\
\>", "Text",
 CellChangeTimes->{{3.5389433430464163`*^9, 3.538943343048231*^9}, {
   3.5389436333882637`*^9, 3.538943695354804*^9}, 3.5389439347828407`*^9},
 Hyphenation->False],

Cell[TextData[{
 "Un ",
 StyleBox["prisma",
  FontSlant->"Italic"],
 " es un poliedro que consta de dos caras paralelas, llamadas ",
 StyleBox["bases,",
  FontSlant->"Italic"],
 " de tal forma que una se obtiene de la otra mediante una traslaci\[OAcute]n \
y, si las bases tienen ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " lados, de otras ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " caras, llamadas ",
 StyleBox["caras laterales,",
  FontSlant->"Italic"],
 " que son paralelogramos entre cuyos lados figura un lado de una base y su \
trasladado en la otra base. Cuando la traslaci\[OAcute]n que relaciona las \
bases se realiza en direcci\[OAcute]n perpendicular a sus planos (o, \
equivalentemente, cuando las caras laterales son rect\[AAcute]ngulos) el \
prisma se dice ",
 StyleBox["recto,",
  FontSlant->"Italic"],
 " y en caso contrario ",
 StyleBox["oblicuo.",
  FontSlant->"Italic"],
 " La distancia entre las dos bases se llama ",
 StyleBox["altura",
  FontSlant->"Italic"],
 " del prisma."
}], "Text",
 CellMargins->{{30, 30}, {3, 5}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
  3.538342563212167*^9, 3.538342641589696*^9}, {3.5383442356780663`*^9, 
  3.538344341344078*^9}, {3.5383916368989153`*^9, 3.538391701841703*^9}, {
  3.538391805282505*^9, 3.5383918567709513`*^9}, {3.538391941949873*^9, 
  3.538391963140169*^9}, {3.538425381242011*^9, 3.538425424800625*^9}, {
  3.538425576780856*^9, 3.538425578658119*^9}, {3.5384256855156183`*^9, 
  3.5384256859475107`*^9}, {3.538425795101571*^9, 3.538425800156361*^9}, {
  3.538913547649026*^9, 3.53891355201474*^9}, {3.538944148369854*^9, 
  3.5389442792646*^9}, {3.538944487060791*^9, 3.5389447002612753`*^9}, {
  3.5389448971850777`*^9, 3.538944904959159*^9}},
 TextJustification->1.,
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell[TextData[{
 "La figura muestra un prisma recto y otro oblicuo con la misma base y la \
misma altura. Un prisma es ",
 StyleBox["triangular, cuadrangular, pentagonal, hexagonal,",
  FontSlant->"Italic"],
 " etc. seg\[UAcute]n el n\[UAcute]mero de lados de sus bases. Por lo tanto, \
los prismas de la figura son pentagonales."
}], "Text",
 CellChangeTimes->{{3.53894394107654*^9, 3.5389439410780373`*^9}, {
  3.538946870741623*^9, 3.5389469463894167`*^9}, {3.538946985957424*^9, 
  3.538946994917644*^9}},
 Hyphenation->False],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.7], Opacity[0.95], 
   GraphicsComplex3DBox[
    NCache[{{Rational[3, 2], 0, 0}, {0, 1, 
      0}, {-1, Rational[1, 2], 0}, {-1, Rational[-1, 2], 0}, {0, -1, 0}, {
      Rational[3, 2], 0, 3}, {0, 1, 
      3}, {-1, Rational[1, 2], 3}, {-1, Rational[-1, 2], 3}, {0, -1, 3}}, {{
      1.5, 0, 0}, {0, 1, 0}, {-1, 0.5, 0}, {-1, -0.5, 0}, {0, -1, 0}, {
      1.5, 0, 3}, {0, 1, 3}, {-1, 0.5, 3}, {-1, -0.5, 3}, {0, -1, 3}}], 
    Polygon3DBox[{{1, 2, 3, 4, 5}, {6, 7, 8, 9, 10}, {1, 2, 7, 6}, {2, 3, 8, 
      7}, {3, 4, 9, 8}, {4, 5, 10, 9}, {5, 1, 6, 10}}]], 
   GeometricTransformation3DBox[
    GraphicsComplex3DBox[
     NCache[{{Rational[5, 2], 1, 0}, {1, 2, 0}, {0, Rational[3, 2], 0}, {
       0, Rational[1, 2], 0}, {1, 0, 0}, {Rational[3, 2], 0, 3}, {0, 1, 
       3}, {-1, Rational[1, 2], 3}, {-1, Rational[-1, 2], 3}, {0, -1, 3}}, {{
       2.5, 1, 0}, {1, 2, 0}, {0, 1.5, 0}, {0, 0.5, 0}, {1, 0, 0}, {
       1.5, 0, 3}, {0, 1, 3}, {-1, 0.5, 3}, {-1, -0.5, 3}, {0, -1, 3}}], 
     Polygon3DBox[{{1, 2, 3, 4, 5}, {6, 7, 8, 9, 10}, {1, 2, 7, 6}, {2, 3, 8, 
       7}, {3, 4, 9, 8}, {4, 5, 10, 9}, {5, 1, 6, 10}}]], {5, 0, 0}]},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{360.16549625319806`, 168.96445007918143`},
  Lighting->"Neutral",
  ViewPoint->{0.5347942016243012, -3.160413173934607, 1.084335617753843},
  ViewVertical->{0.05328260937335195, -0.8405641525183946, 
   2.7015622386800215`}]], "Figure",
 CellChangeTimes->{{3.538947457012662*^9, 3.538947486127054*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "Claramente, un prisma es un poliedro convexo si y s\[OAcute]lo si sus bases \
son pol\[IAcute]gonos convexos. Puesto que todas las secciones de un prisma \
(recto u oblicuo) respecto a planos paralelos a sus bases tienen la misma \
\[AAcute]rea (las secciones son tambi\[EAcute]n traslaciones de las bases), \
el teorema de Fubini nos da que el volumen de un prisma es ",
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = ",
  FontFamily->"Times",
  FontSize->18],
 StyleBox["Sh",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", donde ",
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es la superficie de la base y ",
 StyleBox["h",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " la altura."
}], "Text",
 CellChangeTimes->{{3.538943941404546*^9, 3.538943941406048*^9}, {
  3.538947528709176*^9, 3.538947621172242*^9}, {3.538948479247016*^9, 
  3.538948479250512*^9}, {3.5389489886859827`*^9, 3.53894901238811*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Una ",
 StyleBox["pir\[AAcute]mide",
  FontSlant->"Italic"],
 " es un poliedro que consta de una cara llamada base y, si la base tiene ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " lados, de otras ",
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " caras, llamadas ",
 StyleBox["caras laterales,",
  FontSlant->"Italic"],
 " que resultan de unir un lado de la base con un punto fijo situado fuera de \
su plano llamado ",
 StyleBox["v\[EAcute]rtice",
  FontSlant->"Italic"],
 " de la pir\[AAcute]mide. La distancia entre la base y el v\[EAcute]rtice se \
llama ",
 StyleBox["altura",
  FontSlant->"Italic"],
 " de la pir\[AAcute]mide."
}], "Text",
 CellMargins->{{30, 30}, {3, 5}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
  3.538342563212167*^9, 3.538342641589696*^9}, {3.5383442356780663`*^9, 
  3.538344341344078*^9}, {3.5383916368989153`*^9, 3.538391701841703*^9}, {
  3.538391805282505*^9, 3.5383918567709513`*^9}, {3.538391941949873*^9, 
  3.538391963140169*^9}, {3.538425381242011*^9, 3.538425424800625*^9}, {
  3.538425576780856*^9, 3.538425578658119*^9}, {3.5384256855156183`*^9, 
  3.5384256859475107`*^9}, {3.538425795101571*^9, 3.538425800156361*^9}, {
  3.538913547649026*^9, 3.53891355201474*^9}, {3.538944148369854*^9, 
  3.5389442792646*^9}, {3.538944487060791*^9, 3.5389447002612753`*^9}, {
  3.5389448971850777`*^9, 3.538944904959159*^9}, {3.5389486062205687`*^9, 
  3.5389487284326057`*^9}, {3.5389501365860567`*^9, 3.538950136648181*^9}},
 TextJustification->1.,
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell["\<\
La figura muestra una pir\[AAcute]mide pentagonal (con la misma base que los \
prismas anteriores). Como en el caso de los prismas, una pir\[AAcute]mide es \
convexa si y s\[OAcute]lo si lo es su base.\
\>", "Text",
 CellChangeTimes->{{3.53894907078965*^9, 3.538949104284459*^9}, {
  3.538949146377673*^9, 3.538949172269163*^9}},
 Hyphenation->False],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.7], Opacity[0.9], 
   GraphicsComplex3DBox[
    NCache[{{Rational[3, 2], 0, 0}, {0, 1, 
      0}, {-1, Rational[1, 2], 0}, {-1, Rational[-1, 2], 0}, {0, -1, 0}, {0, 
      0, 3}}, {{1.5, 0, 0}, {0, 1, 0}, {-1, 0.5, 0}, {-1, -0.5, 0}, {0, -1, 
      0}, {0, 0, 3}}], 
    Polygon3DBox[{{1, 2, 3, 4, 5}, {1, 2, 6}, {2, 3, 6}, {3, 4, 6}, {4, 5, 
      6}, {5, 1, 6}}]]},
  Boxed->False,
  ImageSize->{165.6429492211057, Automatic},
  Lighting->"Neutral",
  ViewPoint->{1.320208180161333, -3.013607044531989, 0.7907104034868089},
  ViewVertical->{0.1843391970871123, -0.5315055838727373, 
   0.9224138854631119}]], "Figure",
 CellChangeTimes->{3.5389490313991127`*^9, 3.53894906433468*^9},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "Para calcular el volumen de una pir\[AAcute]mide, llamamos ",
 StyleBox["h",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " a su altura y ",
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " a la superficie de su base. Es claro que la secci\[OAcute]n de la pir\
\[AAcute]mide por un plano paralelo a la base y a una distancia ",
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " del v\[EAcute]rtice tiene \[AAcute]rea ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["S",
     FontFamily->"Times",
     FontSize->18], 
    StyleBox["x",
     FontFamily->"Times",
     FontSize->12]], TraditionalForm]]],
 "tal que"
}], "Text",
 CellChangeTimes->{{3.5389493373051147`*^9, 3.5389493511030607`*^9}, {
  3.5389493824987793`*^9, 3.538949465813528*^9}},
 Hyphenation->False],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["S",
     FontFamily->"Times",
     FontSize->18], 
    StyleBox["x",
     FontFamily->"Times",
     FontSize->12]], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"=", 
    SuperscriptBox[
     StyleBox[
      RowBox[{"(", 
       FractionBox["x", "h"], ")"}],
      FontFamily->"Times",
      FontSize->18], "2"]}], TraditionalForm]]],
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSize->18]
}], "Text",
 CellChangeTimes->{{3.538949475441861*^9, 3.5389496217027473`*^9}, 
   3.5389501037058983`*^9},
 TextAlignment->Center,
 Hyphenation->False],

Cell["Por lo tanto, el teorema de Fubini nos da que el volumen es", "Text",
 CellChangeTimes->{{3.5389493373051147`*^9, 3.5389493511030607`*^9}, {
  3.5389493824987793`*^9, 3.538949465813528*^9}, {3.5389496784122133`*^9, 
  3.538949690397503*^9}},
 Hyphenation->False],

Cell[TextData[{
 StyleBox["V = ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     StyleBox["0",
      FontFamily->"Times",
      FontSize->12.779998779296875`,
      FontSlant->"Plain"], 
     StyleBox["h",
      FontFamily->"Times",
      FontSize->12.779998779296875`]], 
    RowBox[{
     SubscriptBox[
      StyleBox["S",
       FontFamily->"Times"], "x"], 
     RowBox[{
      StyleBox["\[DifferentialD]",
       FontSize->14], 
      StyleBox["x",
       FontFamily->"Times"]}]}]}], TraditionalForm]],
  FontSize->18],
 StyleBox[" = ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     StyleBox["0",
      FontFamily->"Times",
      FontSize->12,
      FontSlant->"Plain"], 
     StyleBox["h",
      FontFamily->"Times",
      FontSize->12.779998779296875`]], 
    RowBox[{
     SuperscriptBox[
      StyleBox[
       RowBox[{"(", 
        FractionBox["x", "h"], ")"}],
       FontFamily->"Times",
       FontSize->18], "2"], 
     StyleBox["S",
      FontFamily->"Times",
      FontSize->18,
      FontSlant->"Italic"], 
     RowBox[{
      StyleBox["\[DifferentialD]",
       FontSize->14], 
      StyleBox["x",
       FontFamily->"Times"]}]}]}], TraditionalForm]],
  FontSize->18],
 StyleBox[" = ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   FractionBox[
    StyleBox["S",
     FontFamily->"Times"], 
    SuperscriptBox[
     StyleBox["h",
      FontFamily->"Times",
      FontSize->12.779998779296875`], "2"]], TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SubsuperscriptBox[
    RowBox[{"[", 
     FractionBox[
      SuperscriptBox[
       StyleBox["x",
        FontFamily->"Times",
        FontSize->12.779998779296875`], "3"], 
      StyleBox["3",
       FontFamily->"Times",
       FontSize->12.779998779296875`,
       FontSlant->"Plain"]], "]"}], 
    StyleBox["0",
     FontFamily->"Times",
     FontSize->12,
     FontSlant->"Plain"], 
    StyleBox["h",
     FontFamily->"Times",
     FontSize->14]], TraditionalForm]],
  FontSize->18],
 StyleBox[" = ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   FractionBox[
    StyleBox["1",
     FontSize->12.779998779296875`,
     FontSlant->"Plain"], 
    StyleBox["3",
     FontSize->12.779998779296875`,
     FontSlant->"Plain"]], TraditionalForm]],
  FontSize->18],
 StyleBox["Sh.",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.5389496914342537`*^9, 3.538949889522462*^9}, 
   3.538949951440875*^9, {3.539085486858234*^9, 3.5390854906720753`*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "Un ",
 StyleBox["paralelep\[IAcute]pedo",
  FontSlant->"Italic"],
 " es un prisma cuyas caras son paralelogramos, por lo que son paralelas dos \
a dos."
}], "Text",
 CellChangeTimes->{3.54184612282885*^9, 3.541846705074473*^9}],

Cell[BoxData[
 Graphics3DBox[{Text3DBox[
    FormBox[
     StyleBox["\<\"O\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], StandardForm], {-0.1, -0.1, -0.1}], Text3DBox[
    FormBox[
     StyleBox["\<\"B\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], StandardForm], {1.1, 2.2, 0.}], Text3DBox[
    FormBox[
     StyleBox["\<\"A\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], StandardForm], {2.2, 0., 0.}], Text3DBox[
    FormBox[
     StyleBox["\<\"C\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], StandardForm], {1.1, 1.1, 1.1}], 
   {GrayLevel[0.6], Opacity[0.8], 
    GraphicsComplex3DBox[{{0, 0, 0}, {1, 2, 0}, {3, 2, 0}, {2, 0, 0}, {1, 1, 
     1}, {2, 3, 1}, {4, 3, 1}, {3, 1, 1}}, 
     Polygon3DBox[{{1, 2, 3, 4}, {5, 6, 7, 8}, {1, 2, 6, 5}, {2, 3, 7, 6}, {3,
        4, 8, 7}, {4, 1, 5, 8}, {2, 4, 5}}]]}},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{354.9201217250069, 175.01779730356012`},
  Lighting->"Neutral",
  ViewPoint->{1.2300380322245918`, -2.9672919184902207`, 1.064041874055566},
  ViewVertical->{0.14621135220260859`, -0.3602458512648032, 
   3.249303577911898}]], "Output",
 CellChangeTimes->{3.541846560678598*^9},
 TextAlignment->Center],

Cell[TextData[{
 " Claramente, un paralelogramo queda completamente determinado por uno de \
sus v\[EAcute]rtices ",
 StyleBox["O",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y tres vectores linealmente independientes ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["OA",
     FontFamily->"Times",
     FontSize->18,
     FontSlant->"Italic"], "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["OB",
     FontFamily->"Times",
     FontSize->18,
     FontSlant->"Italic"], "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["OC",
     FontFamily->"Times",
     FontSize->18,
     FontSlant->"Italic"], "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", y es conocido que su volumen viene dado por"
}], "Text",
 CellChangeTimes->{{3.541845957583892*^9, 3.541845957586836*^9}, {
  3.541846710180913*^9, 3.5418467165658007`*^9}}],

Cell[TextData[{
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = |det[",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["OA",
     FontFamily->"Times",
     FontSize->18,
     FontSlant->"Italic"], "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["OB",
     FontFamily->"Times",
     FontSize->18,
     FontSlant->"Italic"], "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["OC",
     FontFamily->"Times",
     FontSize->18,
     FontSlant->"Italic"], "\[RightVector]"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "]|."
}], "Text",
 CellChangeTimes->{{3.541846716702676*^9, 3.541846734609847*^9}, 
   3.5418467744196577`*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Por otro lado, los mismos datos determinan tambi\[EAcute]n una \
pir\[AAcute]mide (un tetraedro) ",
 StyleBox["OABC.",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " Si comparamos el volumen del paralelep\[IAcute]pedo, (que tambi\[EAcute]n \
puede calcularse como la superficie de su base por su altura) con el de la \
pir\[AAcute]mide, que es un tercio de la superficie de su base (que a su vez \
es la mitad de la superficie de la base del paralelep\[IAcute]pedo) por la \
misma altura, concluimos que el volumen del tetraedro es"
}], "Text",
 CellChangeTimes->{{3.5418467808187428`*^9, 3.541846891990559*^9}}],

Cell[TextData[{
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "6"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "|det[",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["OA",
     FontFamily->"Times",
     FontSize->18,
     FontSlant->"Italic"], "\[RightVector]"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["OB",
     FontFamily->"Times",
     FontSize->18,
     FontSlant->"Italic"], "\[RightVector]"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   OverscriptBox[
    StyleBox["OC",
     FontFamily->"Times",
     FontSize->18,
     FontSlant->"Italic"], "\[RightVector]"], TraditionalForm]]],
 "]|."
}], "Text",
 CellChangeTimes->{{3.541847011678296*^9, 3.541847031861623*^9}},
 TextAlignment->Center],

Cell[TextData[{
 StyleBox["\[LineSeparator]",
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["3. LOS POLIEDROS REGULARES",
  FontSize->24,
  FontColor->RGBColor[0, 0, 1]],
 StyleBox["\[LineSeparator]",
  FontColor->RGBColor[0, 0, 1]]
}], "Section",
 CellChangeTimes->{{3.538496262748913*^9, 3.538496301701696*^9}, {
  3.538507560256893*^9, 3.538507562188425*^9}, {3.538860491527355*^9, 
  3.5388605196265087`*^9}, {3.538950168733983*^9, 3.538950180103657*^9}},
 Hyphenation->False],

Cell[TextData[{
 "La definici\[OAcute]n de pol\[IAcute]gono regular se generaliza de forma \
natural a la de poliedro regular. Como en el caso de los pol\[IAcute]gono, \
por ",
 StyleBox["simetr\[IAcute]a",
  FontSlant->"Italic"],
 " de un poliedro entendemos una isometr\[IAcute]a del espacio que transforma \
cada v\[EAcute]rtice en un v\[EAcute]rtice, cada arista en una arista y cada \
cara en una cara. Si llamamos ",
 StyleBox["centroide",
  FontSlant->"Italic"],
 " de un poliedro al centroide de sus v\[EAcute]rtices, el teorema 1.8 \
implica que todas las simetr\[IAcute]as de un poliedro dejan invariante a su \
centroide, luego en particular son giros respecto a un eje que pasa por el \
centroide o bien simetr\[IAcute]as respecto de un plano que pasa por el \
centroide (pues \[EAcute]stas son las \[UAcute]nicas isometr\[IAcute]as del \
espacio con un punto fijo)."
}], "Text",
 CellChangeTimes->{{3.538950184160647*^9, 3.538950184163602*^9}, {
  3.539025313864728*^9, 3.539025338223709*^9}, {3.539033392011644*^9, 
  3.539033392752153*^9}, {3.541006679672443*^9, 3.541006709085807*^9}, {
  3.541006943177969*^9, 3.5410069623680573`*^9}, {3.541007718160397*^9, 
  3.541007718417604*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Un poliedro es ",
 StyleBox["transitivo para v\[EAcute]rtices",
  FontSlant->"Italic"],
 " (resp. ",
 StyleBox["aristas, caras",
  FontSlant->"Italic"],
 ") si para cada par de v\[EAcute]rtices (resp. aristas, caras) tiene una \
simetr\[IAcute]a que transforma uno en otro. Un poliedro es ",
 StyleBox["regular",
  FontSlant->"Italic"],
 " si es transitivo para v\[EAcute]rtices, aristas y caras."
}], "Text",
 CellMargins->{{30, 30}, {3, 5}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
   3.538342563212167*^9, 3.538342641589696*^9}, {3.5383442356780663`*^9, 
   3.538344341344078*^9}, {3.5383916368989153`*^9, 3.538391701841703*^9}, {
   3.538391805282505*^9, 3.5383918567709513`*^9}, {3.538391941949873*^9, 
   3.538391963140169*^9}, {3.538425381242011*^9, 3.538425424800625*^9}, {
   3.538425576780856*^9, 3.538425578658119*^9}, {3.5384256855156183`*^9, 
   3.5384256859475107`*^9}, {3.538425795101571*^9, 3.538425800156361*^9}, {
   3.538913547649026*^9, 3.53891355201474*^9}, {3.538944148369854*^9, 
   3.5389442792646*^9}, {3.538944487060791*^9, 3.5389447002612753`*^9}, {
   3.5389448971850777`*^9, 3.538944904959159*^9}, {3.5389486062205687`*^9, 
   3.5389487284326057`*^9}, {3.5389501365860567`*^9, 3.538950136648181*^9}, 
   3.539025454650983*^9, {3.539025659164495*^9, 3.539025696079756*^9}, {
   3.539034217136392*^9, 3.53903429708702*^9}, {3.54100675875181*^9, 
   3.541006893423398*^9}},
 TextJustification->1.,
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell["\<\
Veamos algunas consecuencias de estas definiciones:\
\>", "Text",
 CellChangeTimes->{{3.541007687397629*^9, 3.541007690341606*^9}, {
  3.541007781192008*^9, 3.5410077851186132`*^9}, {3.541007908599904*^9, 
  3.5410079521042767`*^9}}],

Cell[TextData[{
 StyleBox["Teorema 3.1:",
  FontWeight->"Bold"],
 " ",
 StyleBox["Los v\[EAcute]rtices de un poliedro transitivo para \
v\[EAcute]rtices est\[AAcute]n inscritos en una (\[UAcute]nica) esfera cuyo \
centro es el centroide del poliedro (y que se suele llamar tambi\[EAcute]n \
circuncentro, o simplemente centro, del poliedro) y cuyo radio se llama \
circunradio, o simplemente radio, del poliedro. La esfera recibe el nombre de \
esfera circunscrita al poliedro.",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.541006648259691*^9, 3.541006648261779*^9}, {
  3.541007934936019*^9, 3.54100802406564*^9}, {3.541008206926311*^9, 
  3.541008237187262*^9}}],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": Es inmediato, pues dados dos v\[EAcute]rtices cualesquiera, existe una \
simetr\[IAcute]a del poliedro que transforma uno en otro y, como \[EAcute]sta \
deja fijo al centroide, ambos v\[EAcute]rtices est\[AAcute]n a la misma \
distancia de \[EAcute]l.  ",
 "\[FilledSmallSquare]"
}], "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{{3.5410066484115677`*^9, 3.541006648413917*^9}, {
  3.5410080581959953`*^9, 3.541008080401716*^9}, {3.5410081109243393`*^9, 
  3.54100814702818*^9}}],

Cell[TextData[{
 StyleBox["Teorema 3.2:",
  FontWeight->"Bold"],
 " ",
 StyleBox["Las caras (resp. aristas) de un poliedro transitivo para caras \
(resp. aristas) son tangentes a una (\[UAcute]nica) esfera cuyo centro es el \
centroide del poliedro y cuyo radio (para el caso de las caras) se llama \
inradio del poliedro. La esfera (para el caso de las caras) recibe el nombre \
de esfera inscrita en el poliedro.",
  FontSlant->"Italic"]
}], "Text",
 CellMargins->{{12, 10}, {16, 16}},
 CellChangeTimes->{{3.541006648555563*^9, 3.541006648557754*^9}, {
  3.541008157147603*^9, 3.541008285723971*^9}, {3.5410083652071238`*^9, 
  3.5410083988692207`*^9}, {3.54102106741888*^9, 3.5410211120118732`*^9}}],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": Por el mismo argumento empleado en el teorema anterior, todas las caras \
(resp. aristas) del poliedro est\[AAcute]n a la misma distancia ",
 StyleBox["r",
  FontSlant->"Italic"],
 " del centroide del poliedro, luego la esfera con dicho centro y radio ",
 StyleBox["r",
  FontSlant->"Italic"],
 " es tangente a todas ellas, supuesto que ",
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" > 0.",
  FontFamily->"Times"],
 " Ahora bien, no puede ser que todas las caras pasen por el centroide del \
poliedro, pues, si una lo hace, tendr\[AAcute] al menos una arista que no lo \
contenga, y la cara contigua por dicha arista no pasar\[AAcute] por el \
centroide. Como todas las caras tienen que estar a la misma distancia del \
centroide, ninguna pasa por \[EAcute]l. Con las aristas se razona \
an\[AAcute]logamente.  \[FilledSmallSquare]"
}], "Text",
 CellChangeTimes->{{3.5410066484115677`*^9, 3.541006648413917*^9}, {
  3.5410080581959953`*^9, 3.541008080401716*^9}, {3.5410081109243393`*^9, 
  3.54100814702818*^9}, {3.5410083092779827`*^9, 3.5410083414844418`*^9}, {
  3.5410084062939243`*^9, 3.5410084103740053`*^9}, {3.541020741160924*^9, 
  3.541020769255556*^9}, {3.541020864089755*^9, 3.541020900880198*^9}, {
  3.541020996377427*^9, 3.5410210281378193`*^9}, {3.541021160941936*^9, 
  3.541021253235579*^9}, {3.541021328351507*^9, 3.5410213314774027`*^9}}],

Cell[TextData[{
 StyleBox["Teorema 3.3:",
  FontWeight->"Bold"],
 " ",
 StyleBox["Las caras de un poliedro transitivo para v\[EAcute]rtices y \
aristas son pol\[IAcute]gonos regulares, que ser\[AAcute]n simples si el \
poliedro lo es.",
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.54100664869956*^9, 3.5410066487016*^9}, {
  3.541008466264309*^9, 3.54100853103828*^9}, {3.541175891961993*^9, 
  3.54117589756733*^9}}],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": Los v\[EAcute]rtices de una cara est\[AAcute]n contenidos en un plano, y \
tambi\[EAcute]n en la esfera circunscrita, luego est\[AAcute]n en una \
circunferencia. Por la transitividad para aristas, dos cualesquiera de sus \
lados tienen la misma longitud, y el teorema 1.11 nos da entonces que las \
caras son pol\[IAcute]gonos regulares.  ",
 "\[FilledSmallSquare]"
}], "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{{3.5410066484115677`*^9, 3.541006648413917*^9}, {
  3.5410080581959953`*^9, 3.541008080401716*^9}, {3.5410081109243393`*^9, 
  3.54100814702818*^9}, {3.541008552344096*^9, 3.541008712701928*^9}}],

Cell["\<\
Observemos adem\[AAcute]s que, como el centro de un poliedro regular \
equidista de los v\[EAcute]rtices de una cara, se encuentra sobre la recta \
perpendicular a su plano y que pasa por su centro, luego el centro de la cara \
es el punto m\[AAcute]s cercano al centro del poliedro, luego es el punto de \
tangencia de la esfera inscrita.\
\>", "Text",
 CellChangeTimes->{{3.5410066488435793`*^9, 3.541006648845804*^9}, {
  3.5410088485674257`*^9, 3.541008898473639*^9}, {3.5411760967462273`*^9, 
  3.541176096748844*^9}}],

Cell[TextData[{
 StyleBox["Teorema 3.4:",
  FontWeight->"Bold"],
 " ",
 StyleBox["Todas las simetr\[IAcute]as de una cara de un poliedro regular que \
dejen fijo a su centro son simetr\[IAcute]as del poliedro.",
  FontSlant->"Italic"]
}], "Text",
 CellMargins->{{12, 10}, {16, 16}},
 CellChangeTimes->{{3.541176129648855*^9, 3.54117615908361*^9}, {
  3.541176346107585*^9, 3.5411763585558653`*^9}, {3.5411770169791737`*^9, 
  3.541177019947055*^9}}],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": La prueba se basa en que podemos reconstruir el poliedro a partir de una \
de sus caras y de su esfera inscrita mediante el procedimiento siguiente: \
partimos de una cara ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", y le situamos encima la esfera inscrita ",
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", de modo que el punto de tangencia sea el centro de ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". (En lo sucesivo, cuando digamos que un pol\[IAcute]gono reguar es \
tangente a ",
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " sobrentenderemos que el punto de tangencia es el centro del \
pol\[IAcute]gino.) La cara del poliedro contigua a ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " por uno de sus lados est\[AAcute] un\[IAcute]vocamente determinada por que \
es el \[UAcute]nico pol\[IAcute]gono igual que ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " que comparte el lado con ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y que es tangente a ",
 StyleBox["S.",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " (Aqu\[IAcute] usamos que por una recta exterior a una esfera pasan \
\[UAcute]nicamente dos planos tangentes a ella, que en este caso son el plano \
de ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y el plano de la cara contigua.) Por lo tanto, ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " determinan completamente las caras contiguas de ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". Si al construir estas caras quedan aristas libres, es decir, sin cara \
contigua, resulta que sus caras contiguas por dichas aristas est\[AAcute]n un\
\[IAcute]vocamente determinadas del mismo modo, y as\[IAcute] podemos ir a\
\[NTilde]adiendo caras sin ning\[UAcute]n margen de libertad hasta que no \
queden aristas libres."
}], "Text",
 CellChangeTimes->{{3.541176160474292*^9, 3.5411761666975203`*^9}, {
  3.541176198162759*^9, 3.5411763215237103`*^9}, {3.54117636428475*^9, 
  3.541176519438252*^9}, {3.541176552725576*^9, 3.541176973631466*^9}, {
  3.541177063188237*^9, 3.541177069172098*^9}}],

Cell[TextData[{
 "Es claro que si aplicamos a ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y a ",
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " una misma isometr\[IAcute]a, el poliedro que se obtiene mediante el \
procedimiento que acabamos de describir a partir de las im\[AAcute]genes de \
",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es la imagen por la isometr\[IAcute]a del que se obtiene a partir de ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["S.",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " En particular, si consideramos una isometr\[IAcute]a que fije a ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y al centro del poliedro, tambi\[EAcute]n dejar\[AAcute] fija a ",
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego la imagen del poliedro por la isometr\[IAcute]a ser\[AAcute] el \
poliedro construido a partir de ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego ser\[AAcute] el propio poliedro de partida. Esto significa que la \
isometr\[IAcute]a es una simetr\[IAcute]a del poliedro.  \
\[FilledSmallSquare]"
}], "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{{3.541176129792878*^9, 3.541176129795404*^9}, {
  3.541177354776106*^9, 3.5411773615049143`*^9}}],

Cell[TextData[{
 "Si las caras de un poliedro regular son pol\[IAcute]gonos de tipo {",
 StyleBox["n/k",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "}, los giros de \[AAcute]ngulo ",
 StyleBox["360/",
  FontFamily->"Times"],
 StyleBox["n",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " grados respecto de ejes que pasen por el centro del poliedro y el centro \
de una cara son simetr\[IAcute]as del poliedro, al igual que lo son las \
simetr\[IAcute]as respecto de planos que pasen por el centro del poliedro y \
por un eje de simetr\[IAcute]a de una cara. Esto nos da una caracterizaci\
\[OAcute]n de la regularidad:"
}], "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{{3.541177372467271*^9, 3.5411776040511017`*^9}}],

Cell[TextData[{
 StyleBox["Teorema 3.5:",
  FontWeight->"Bold"],
 " ",
 StyleBox["Un poliedro es regular si para todo par de caras ",
  FontSlant->"Italic"],
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" y ",
  FontSlant->"Italic"],
 StyleBox["C\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[", todo par de aristas ",
  FontSlant->"Italic"],
 StyleBox["a",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" y ",
  FontSlant->"Italic"],
 StyleBox["a\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" tales que ",
  FontSlant->"Italic"],
 StyleBox["a",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" es un lado de ",
  FontSlant->"Italic"],
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" y ",
  FontSlant->"Italic"],
 StyleBox["a\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" es un lado de ",
  FontSlant->"Italic"],
 StyleBox["C\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" y todo par de v\[EAcute]rtices ",
  FontSlant->"Italic"],
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" y ",
  FontSlant->"Italic"],
 StyleBox["v\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" tales que ",
  FontSlant->"Italic"],
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" es un extremo de ",
  FontSlant->"Italic"],
 StyleBox["a",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" y ",
  FontSlant->"Italic"],
 StyleBox["v\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" es un extremo de ",
  FontSlant->"Italic"],
 StyleBox["v\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" existe una simetr\[IAcute]a del poliedro que transforma ",
  FontSlant->"Italic"],
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" en ",
  FontSlant->"Italic"],
 StyleBox["C\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[", ",
  FontSlant->"Italic"],
 StyleBox["a",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" en ",
  FontSlant->"Italic"],
 StyleBox["a\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" y ",
  FontSlant->"Italic"],
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" en ",
  FontSlant->"Italic"],
 StyleBox["v\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSlant->"Italic"]
}], "Text",
 CellMargins->{{12, 10}, {16, 16}},
 CellChangeTimes->{{3.541177605087949*^9, 3.541177683179727*^9}}],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": Una implicaci\[OAcute]n es inmediata. Si el poliedro es regular, por la \
transitividad para caras existe una simetr\[IAcute]a que transforma ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " en ",
 StyleBox["C\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". Componi\[EAcute]ndola con un giro adecuado de ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " podemos hacer que ",
 StyleBox["a",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " se corresponda con ",
 StyleBox["a\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y, en caso de que ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " no se corresponda con ",
 StyleBox["v\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", podemos tomar una simetr\[IAcute]a de ",
 StyleBox["C\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " que deje fija la arista ",
 StyleBox["a\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " intercambiado sus extremos, y al componer con esta simetr\[IAcute]a (que \
tambi\[EAcute]n lo es del poliedro) obtenemos una simetr\[IAcute]a que cumple \
lo pedido.  ",
 "\[FilledSmallSquare]"
}], "Text",
 CellChangeTimes->{{3.541177683288354*^9, 3.54117768329107*^9}, {
  3.541177788377787*^9, 3.54117799177923*^9}}],

Cell[TextData[StyleBox["EL HEXAEDRO",
 FontSize->18,
 FontColor->RGBColor[0, 0, 1]]], "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellMargins->{{100, 100}, {16, 18}},
 CellChangeTimes->{{3.538515429422391*^9, 3.538515429424019*^9}, {
  3.538517083097238*^9, 3.538517086760803*^9}, {3.538772137916774*^9, 
  3.5387721418334713`*^9}, {3.5389433492789*^9, 3.538943354615024*^9}, {
  3.538944083654379*^9, 3.538944088838513*^9}, {3.5391065561537533`*^9, 
  3.5391065641036177`*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "El poliedro regular m\[AAcute]s f\[AAcute]cil de estudiar es el ",
 StyleBox["hexaedro",
  FontSlant->"Italic"],
 " o ",
 StyleBox["cubo,",
  FontSlant->"Italic"],
 " que no es sino un prisma de bases cuadradas cuyas caras laterales son \
tambi\[EAcute]n cuadradas. En particular es un poliedro convexo."
}], "Text",
 CellChangeTimes->{{3.5389501847514477`*^9, 3.5389501847530003`*^9}, {
  3.539106576267742*^9, 3.5391066044482327`*^9}, {3.539110498918405*^9, 
  3.5391105046944933`*^9}},
 Hyphenation->False],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"GrayLevel", "[", "0.7", "]"}], ",", " ", 
     RowBox[{"Opacity", "[", "0.7", "]"}], ",", " ", 
     RowBox[{"PolyhedronData", "[", 
      RowBox[{"\"\<Hexahedron\>\"", ",", " ", "\"\<Faces\>\""}], "]"}]}], 
    "}"}], ",", " ", "\n", "  ", 
   RowBox[{"Boxed", " ", "->", " ", "False"}], ",", " ", 
   RowBox[{"Lighting", " ", "->", " ", "\"\<Neutral\>\""}]}], "]"}]], "Text",
 Evaluatable->True,
 CellOpen->False,
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.536774570399049*^9, 3.536774594704513*^9}, 
   3.536852161073413*^9, {3.539109586904642*^9, 3.539109625223774*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.7], Opacity[0.7], 
   GraphicsComplex3DBox[
    NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
      Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
      Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
      Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
      Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
      Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
      Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
      Rational[1, 2], Rational[1, 2], Rational[
       1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
     0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {0.5, 
     0.5, -0.5}, {0.5, 0.5, 0.5}}], 
    Polygon3DBox[{{8, 4, 2, 6}, {8, 6, 5, 7}, {8, 7, 3, 4}, {4, 3, 1, 2}, {1, 
     3, 7, 5}, {2, 1, 5, 6}}]]},
  Boxed->False,
  ImageSize->{246., Automatic},
  Lighting->"Neutral",
  ViewPoint->{-1.8772997447683986`, -2.528525845869314, 1.2378621551139612`},
  ViewVertical->{-0.13800968919882517`, -0.2152217200623578, 
   0.9667641578485643}]], "Output",
 CellChangeTimes->{
  3.539106620255274*^9, {3.5391095993828573`*^9, 3.539109625697342*^9}},
 TextAlignment->Center]
}, Open  ]],

Cell[TextData[{
 "El cubo tiene ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18],
 StyleBox[" = 6",
  FontFamily->"Times"],
 " caras cuadradas, ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18],
 StyleBox[" = 12",
  FontFamily->"Times"],
 " aristas y ",
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 8",
  FontFamily->"Times"],
 " v\[EAcute]rtices, a cada uno de los cuales llegan ",
 StyleBox["3",
  FontFamily->"Times"],
 " aristas. Observemos que el cubo es regular, pues los giros de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["90",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 "respecto a ejes que pasan por el centro de dos caras opuestas son simetr\
\[IAcute]as del cubo y con ellas podemos transformar cualquier cara en \
cualquier cara, cualquier arista en cualquier arista y cualquier \
v\[EAcute]rtice en cualquier v\[EAcute]rtice."
}], "Text",
 CellChangeTimes->{{3.538950184911347*^9, 3.538950184912891*^9}, {
  3.5391066494740963`*^9, 3.539106649477117*^9}, {3.5391069511668577`*^9, 
  3.539106954507072*^9}, {3.539107030099905*^9, 3.539107054468343*^9}, {
  3.539107100008258*^9, 3.539107301751099*^9}, {3.541009176723468*^9, 
  3.5410093665910597`*^9}, {3.541178034327951*^9, 3.541178081805191*^9}},
 Hyphenation->False],

Cell[TextData[{
 "Es claro que el inradio de un cubo es ",
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = ",
  FontFamily->"Times"],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["/2",
  FontFamily->"Times"],
 ", mientras que de la figura siguiente se deduce que ",
 StyleBox["CV",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "/",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox["2",
     FontFamily->"Times",
     FontSlant->"Plain"]], TraditionalForm]]],
 ", y a su vez, teniendo en cuenta que ",
 StyleBox["OC",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = ",
  FontFamily->"Times"],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["/2,",
  FontFamily->"Times"],
 " que el circunradio es ",
 StyleBox["R",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = ",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox[
     StyleBox["3",
      FontSize->12,
      FontSlant->"Plain"]], 
    StyleBox["2",
     FontSlant->"Plain"]], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox["l.",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.539107351728663*^9, 3.539107474552595*^9}, {
   3.539107532987507*^9, 3.539107532992285*^9}, {3.5391075828848877`*^9, 
   3.539107618786503*^9}, {3.539107666206142*^9, 3.539107733342331*^9}, 
   3.539107807828476*^9},
 Hyphenation->False],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.2], Glow[
     GrayLevel[0.85]], 
    GeometricTransformation3DBox[
     GraphicsComplex3DBox[
      NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
        Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
        Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
        Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
        Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
        Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
        Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
        Rational[1, 2], Rational[1, 2], Rational[
         1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
       0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {
       0.5, 0.5, -0.5}, {0.5, 0.5, 0.5}}], 
      Polygon3DBox[{{8, 4, 2, 6}, {8, 6, 5, 7}, {8, 7, 3, 4}, {4, 3, 1, 2}, {
       1, 3, 7, 5}, {2, 1, 5, 6}}]], 
     NCache[{{{2 3^Rational[-1, 2], 0, 0}, {0, 2 3^Rational[-1, 2], 0}, {
        0, 0, 2 3^Rational[-1, 2]}}, {0, 0, 
       0}}, {{{1.1547005383792517`, 0, 0}, {0, 1.1547005383792517`, 0}, {
        0, 0, 1.1547005383792517`}}, {0, 0, 0}}]]}, 
   Line3DBox[
    NCache[{{0, 0, 0}, {0, 0, -3^Rational[-1, 2]}, {
      3^Rational[-1, 2], 3^Rational[-1, 2], -3^Rational[-1, 2]}, {0, 0, 
      0}}, {{0, 0, 0}, {0, 0, -0.5773502691896258}, {0.5773502691896258, 
      0.5773502691896258, -0.5773502691896258}, {0, 0, 0}}]], 
   Text3DBox["O", {-0.05, 0, 0}], 
   Text3DBox["V", 
    NCache[{0.6273502691896259, 0.6273502691896259, -3^Rational[-1, 2]}, {
     0.6273502691896259, 0.6273502691896259, -0.5773502691896258}]], 
   Text3DBox["C", 
    NCache[{-0.05, -0.05, -3^
       Rational[-1, 2]}, {-0.05, -0.05, -0.5773502691896258}]]},
  Boxed->False,
  ImageSize->{222.29525806765423`, 219.},
  Lighting->None,
  ViewPoint->{-0.7275820819438514, 3.230771812777791, 0.6947933561820764},
  ViewVertical->{-0.08889136034517113, 0.40315557841596705`, 
   0.9502429581988753}]], "Output",
 CellChangeTimes->{3.539107542093788*^9},
 TextAlignment->Center],

Cell[TextData[{
 "La tabla siguiente resume los resultados que hemos obtenido y otros \
inmediatos. Todos se refieren a un cubo de arista 1. En general, el ",
 StyleBox["\[AAcute]ngulo di\[EAcute]drico",
  FontSlant->"Italic"],
 " de un poliedro en una arista es el \[AAcute]ngulo que forman las dos caras \
que la comparten como lado. Es claro que en un poliedro regular todos los \
\[AAcute]ngulos di\[EAcute]dricos son iguales, as\[IAcute] como que en el \
caso del cubo son de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["90",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ", como indica la tabla."
}], "Text",
 CellChangeTimes->{{3.53910753365639*^9, 3.539107533657992*^9}, {
  3.539110137605318*^9, 3.5391101468219843`*^9}, {3.539110215635919*^9, 
  3.5391102606711206`*^9}, {3.539110451959655*^9, 3.539110480694214*^9}, {
  3.539110515577301*^9, 3.539110583151009*^9}, {3.5391122285074177`*^9, 
  3.539112229343505*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\"\<Radio\>\"", ",", "\"\<Inradio\>\"", ",", " ", "\"\<Volumen\>\"", 
       ",", " ", "\"\<\[CapitalAAcute]rea\>\"", ",", " ", 
       "\"\<\[CapitalAAcute]ngulo di\[EAcute]drico\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*FractionBox[SqrtBox[\(3\)], \(2\)]\)\>\"", ",", "18", ",", 
         
         RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<\!\(\*FractionBox[\(1\), \(2\)]\)\>\"", ",", "18", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<1\>\"", ",", "14", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<6\>\"", ",", "14", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{
        "\"\<\!\(\*SuperscriptBox[\(90\), \(\[SmallCircle]\)]\)\>\"", ",", 
         "14", ",", 
         RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"Dividers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"False", ",", "True", ",", "True", ",", "True", ",", "True"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"False", ",", "True"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellOpen->False,
 CellChangeTimes->{{3.538858064968013*^9, 3.53885806496976*^9}, {
  3.538860248352882*^9, 3.5388602503096848`*^9}, {3.5391101899423113`*^9, 
  3.5391102457887287`*^9}, {3.539110310356593*^9, 3.539110414621147*^9}},
 Hyphenation->False],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Radio\"\>", "\<\"Inradio\"\>", "\<\"Volumen\"\>", "\<\"\
\[CapitalAAcute]rea\"\>", "\<\"\[CapitalAAcute]ngulo di\[EAcute]drico\"\>"},
    {
     StyleBox["\<\"\\!\\(\\*FractionBox[SqrtBox[\\(3\\)], \\(2\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(1\\), \\(2\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], 
     StyleBox["\<\"6\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], 
     StyleBox["\<\"\\!\\(\\*SuperscriptBox[\\(90\\), \\(\[SmallCircle]\\)]\\)\
\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14]}
   },
   AutoDelete->False,
   GridBoxDividers->{
    "Columns" -> {False, True, True, True, True}, "Rows" -> {False, True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.539110312398365*^9, {3.539110394848291*^9, 3.539110415124639*^9}},
 TextAlignment->Center]
}, Open  ]],

Cell[TextData[StyleBox["EL TETRAEDRO",
 FontSize->18,
 FontColor->RGBColor[0, 0, 1]]], "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellMargins->{{100, 100}, {16, 18}},
 CellChangeTimes->{{3.538515429422391*^9, 3.538515429424019*^9}, {
  3.538517083097238*^9, 3.538517086760803*^9}, {3.538772137916774*^9, 
  3.5387721418334713`*^9}, {3.5389433492789*^9, 3.538943354615024*^9}, {
  3.538944083654379*^9, 3.538944088838513*^9}, {3.5391065561537533`*^9, 
  3.5391065641036177`*^9}, {3.539110603199396*^9, 3.5391106061050386`*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "El poliedro regular m\[AAcute]s sencillo es el ",
 StyleBox["tetraedro,",
  FontSlant->"Italic"],
 " que no es sino una pir\[AAcute]mide cuya base y cuyas caras laterales son \
todas tri\[AAcute]ngulos equil\[AAcute]teros."
}], "Text",
 CellChangeTimes->{{3.5391101470262833`*^9, 3.539110147028084*^9}, {
  3.539110653628385*^9, 3.53911071725006*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.6], Opacity[0.7], 
   GraphicsComplex3DBox[
    NCache[{{0, 0, Rational[2, 3]^Rational[1, 2] + 
       Rational[-1, 2] 6^Rational[-1, 2]}, {
      Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], Rational[-1, 2] 
       6^Rational[-1, 2]}, {
      Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], Rational[-1, 2] 
       6^Rational[-1, 2]}, {
      3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}}, {{
      0, 0, 0.6123724356957945}, {-0.2886751345948129, -0.5, \
-0.20412414523193154`}, {-0.2886751345948129, 0.5, -0.20412414523193154`}, {
      0.5773502691896258, 0, -0.20412414523193154`}}], 
    Polygon3DBox[{{2, 3, 4}, {3, 2, 1}, {4, 1, 2}, {1, 4, 3}}]]},
  Boxed->False,
  ImageSize->{300.6486076346068, 344.},
  Lighting->"Neutral",
  ViewCenter->{{0.5, 0.5, 0.5}, {0.4977529580333415, 0.3539422721671961}},
  ViewPoint->{-0.2011447828607444, 2.40218936729827, 2.3746635593209926`},
  ViewVertical->{-0.4872162929430236, 
   0.9005766930402324, -0.1280244090253634}]], "Output",
 CellChangeTimes->{
  3.539110776449513*^9, 3.5391108187650557`*^9, {3.539110874321259*^9, 
   3.5391108906218557`*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Consta de ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 4",
  FontFamily->"Times"],
 " caras triangulares, ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 6",
  FontFamily->"Times"],
 " aristas y ",
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 4",
  FontFamily->"Times"],
 " v\[EAcute]rtices, a cada uno de los cuales llegan ",
 StyleBox["3",
  FontFamily->"Times"],
 " aristas. Es f\[AAcute]cil ver que existen realmente tetraedros (es decir, \
que cuatro puntos pueden disponerse de forma que la distancia entre dos \
cualesquiera de ellos sea la misma), pero una forma de verlo que nos ser\
\[AAcute] particularmente \[UAcute]til es observar que podemos construir un \
tetraedro uniendo cuatro de los ocho v\[EAcute]rtices de un cubo:"
}], "Text",
 CellChangeTimes->{{3.5391101471943607`*^9, 3.539110147196191*^9}, {
  3.539110921334527*^9, 3.5391109884127073`*^9}, {3.5391113170808277`*^9, 
  3.5391113341269712`*^9}, {3.5391117427811747`*^9, 3.539111831075856*^9}, {
  3.5391118887743883`*^9, 3.5391119837967157`*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.2], Glow[
     GrayLevel[0.85]], 
    GeometricTransformation3DBox[
     GraphicsComplex3DBox[
      NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
        Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
        Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
        Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
        Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
        Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
        Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
        Rational[1, 2], Rational[1, 2], Rational[
         1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
       0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {
       0.5, 0.5, -0.5}, {0.5, 0.5, 0.5}}], 
      Polygon3DBox[{{8, 4, 2, 6}, {8, 6, 5, 7}, {8, 7, 3, 4}, {4, 3, 1, 2}, {
       1, 3, 7, 5}, {2, 1, 5, 6}}]], {{{2, 0, 0}, {0, 2, 0}, {0, 0, 2}}, {0, 
      0, 0}}]}, 
   {Opacity[0.7], Glow[
     GrayLevel[0.5]], Polygon3DBox[{{1, 1, 1}, {1, -1, -1}, {-1, 1, -1}}]}, 
   {Opacity[0.7], Glow[
     GrayLevel[0.5]], Polygon3DBox[{{1, 1, 1}, {1, -1, -1}, {-1, -1, 1}}]}, 
   {Opacity[0.7], Glow[
     GrayLevel[0.5]], 
    Polygon3DBox[{{-1, 1, -1}, {1, -1, -1}, {-1, -1, 1}}]}, 
   {Opacity[0.7], Glow[
     GrayLevel[0.5]], Polygon3DBox[{{1, 1, 1}, {-1, -1, 1}, {-1, 1, -1}}]}},
  Boxed->False,
  ImageSize->{243., Automatic},
  Lighting->None,
  ViewPoint->{-1.61942634334891, -2.8183587688411476`, 0.9403787367671639},
  ViewVertical->{-0.15184358128511952`, -0.3091361005235135, 
   0.9388175531889172}]], "Output",
 CellChangeTimes->{3.5391114565737143`*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Como un v\[EAcute]rtice equidista de los otros tres, est\[AAcute] en la \
recta perpendicular a su cara opuesta que pasa por su centro, y los giros de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["120",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 " respecto tales rectas son claramente simetr\[IAcute]as del tetraedro que \
bastan para justificar su regularidad."
}], "Text",
 CellChangeTimes->{{3.5391101471943607`*^9, 3.539110147196191*^9}, {
  3.539110921334527*^9, 3.5391109884127073`*^9}, {3.5391113170808277`*^9, 
  3.5391113341269712`*^9}, {3.5391117427811747`*^9, 3.539111831075856*^9}, {
  3.5391118887743883`*^9, 3.53911188889939*^9}, {3.539112060279001*^9, 
  3.539112075901836*^9}, {3.539112129094372*^9, 3.539112191558497*^9}, {
  3.53911222196206*^9, 3.539112275712103*^9}, {3.539112356171566*^9, 
  3.539112386688595*^9}, {3.539112441804907*^9, 3.539112441999695*^9}, {
  3.541009602546833*^9, 3.541009694737914*^9}, {3.54117813897252*^9, 
  3.541178144381665*^9}}],

Cell[TextData[{
 "Continuando con la figura, vemos que la esfera circunscrita al tetraedro es \
la misma que la del cubo, si la arista del tetraedro mide ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", la del cubo mide ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox["2"], "2"], TraditionalForm]]],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego, seg\[UAcute]n los c\[AAcute]lculos de la subsecci\[OAcute]n \
precedente el circunradio es"
}], "Text",
 CellChangeTimes->{{3.5391101471943607`*^9, 3.539110147196191*^9}, {
   3.539110921334527*^9, 3.5391109884127073`*^9}, {3.5391113170808277`*^9, 
   3.5391113341269712`*^9}, {3.5391117427811747`*^9, 3.539111831075856*^9}, {
   3.5391118887743883`*^9, 3.53911188889939*^9}, {3.539112060279001*^9, 
   3.539112075901836*^9}, {3.539112129094372*^9, 3.539112191558497*^9}, {
   3.53911222196206*^9, 3.539112275712103*^9}, {3.539112356171566*^9, 
   3.539112386688595*^9}, {3.539112441804907*^9, 3.539112441999695*^9}, {
   3.541009602546833*^9, 3.541009602760704*^9}, 3.54100970245575*^9}],

Cell[TextData[{
 StyleBox["R",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     SqrtBox["3"], "2"],
    FontSlant->"Plain"], TraditionalForm]],
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" ",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     SqrtBox["2"], "2"],
    FontSlant->"Plain"], TraditionalForm]],
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = ",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     SqrtBox["3"], 
     RowBox[{"2", 
      SqrtBox["2"]}]],
    FontSlant->"Plain"], TraditionalForm]],
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSize->18,
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.5391101471943607`*^9, 3.539110147196191*^9}, {
  3.539110921334527*^9, 3.5391109884127073`*^9}, {3.5391113170808277`*^9, 
  3.5391113341269712`*^9}, {3.5391117427811747`*^9, 3.539111831075856*^9}, {
  3.5391118887743883`*^9, 3.53911188889939*^9}, {3.539112060279001*^9, 
  3.539112075901836*^9}, {3.539112129094372*^9, 3.539112191558497*^9}, {
  3.53911222196206*^9, 3.539112275712103*^9}, {3.539112356171566*^9, 
  3.539112386688595*^9}, {3.539112441804907*^9, 3.539112441992474*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Para calcular el incentro observamos la figura siguiente, en la que el tri\
\[AAcute]ngulo ",
 StyleBox["VOC",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es rect\[AAcute]ngulo, ya que, como el centro equidista de los tres v\
\[EAcute]rtices de una cara, est\[AAcute] sobre la recta perpendicular a su \
plano que pasa por su centro, y el segmento ",
 StyleBox["OC",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] sobre dicha recta. Por la geometr\[IAcute]a del \
tri\[AAcute]ngulo equil\[AAcute]tero sabemos que ",
 StyleBox["VC",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox["3"], "3"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", y el teorema de Pit\[AAcute]goras nos da que el inradio es ",
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = ",
  FontFamily->"Times New Roman",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", 
     RowBox[{"2", 
      SqrtBox["6"]}]],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 " ",
 StyleBox["l.",
  FontFamily->"Times New Roman Italic",
  FontSize->18],
 " "
}], "Text",
 CellChangeTimes->{{3.5391101471943607`*^9, 3.539110147196191*^9}, {
  3.539110921334527*^9, 3.5391109884127073`*^9}, {3.5391113170808277`*^9, 
  3.5391113341269712`*^9}, {3.5391117427811747`*^9, 3.539111831075856*^9}, {
  3.5391118887743883`*^9, 3.53911188889939*^9}, {3.539112060279001*^9, 
  3.5391120642950974`*^9}, {3.539112458283039*^9, 3.53911246751445*^9}, {
  3.5391125741409492`*^9, 3.539112677626844*^9}, {3.539112739486425*^9, 
  3.5391127948917723`*^9}, {3.539112900559958*^9, 3.539112950617675*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.2], Glow[
     GrayLevel[0.85]], 
    GeometricTransformation3DBox[
     GraphicsComplex3DBox[
      NCache[{{0, 0, Rational[2, 3]^Rational[1, 2] + 
         Rational[-1, 2] 6^Rational[-1, 2]}, {
        Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], Rational[-1, 2] 
         6^Rational[-1, 2]}, {
        Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], Rational[-1, 2] 
         6^Rational[-1, 2]}, {
        3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}}, {{
        0, 0, 0.6123724356957945}, {-0.2886751345948129, -0.5, \
-0.20412414523193154`}, {-0.2886751345948129, 0.5, -0.20412414523193154`}, {
        0.5773502691896258, 0, -0.20412414523193154`}}], 
      Polygon3DBox[{{2, 3, 4}, {3, 2, 1}, {4, 1, 2}, {1, 4, 3}}]], {{{1, 0, 
      0}, {0, 1, 0}, {0, 0, 1}}, {0, 0, 0}}]}, 
   Line3DBox[
    NCache[{{0, 0, 0}, {
      Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], Rational[-1, 2] 
       6^Rational[-1, 2]}, {0, 0, Rational[-1, 2] 6^Rational[-1, 2]}, {0, 0, 
      0}}, {{0, 0, 0}, {-0.2886751345948129, -0.5, -0.20412414523193154`}, {
      0, 0, -0.20412414523193154`}, {0, 0, 0}}]], 
   Text3DBox["O", {0.05, 0, 0.03}], 
   Text3DBox["V", 
    NCache[{-0.3386751345948129, -0.55, Rational[-1, 2] 
      6^Rational[-1, 
         2]}, {-0.3386751345948129, -0.55, -0.20412414523193154`}]], 
   Text3DBox["C", 
    NCache[{0.05, 0.05, Rational[-1, 2] 6^Rational[-1, 2]}, {0.05, 
     0.05, -0.20412414523193154`}]]},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{363.59950438665123`, 286.3658926377896},
  Lighting->None,
  ViewPoint->{2.2554123721267376`, -2.4254009705557413`, 0.6932136493786833},
  ViewVertical->{0.327379117315504, -0.29875678075130735`, 
   1.1710015713063984`}]], "Output",
 CellChangeTimes->{3.539112521486368*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Ahora es inmediato que la altura de un tetraedro (visto como \
pir\[AAcute]mide) es ",
 StyleBox["h",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = ",
  FontFamily->"Times"],
 StyleBox["R",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" + ",
  FontFamily->"Times"],
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" =",
  FontFamily->"Times"],
 " ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox["2"], 
    SqrtBox["3"]], TraditionalForm]],
  FontSize->14],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". El \[AAcute]rea de una cara es ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     SqrtBox["3"], "4"],
    FontSize->18], TraditionalForm]],
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["l",
     FontFamily->"Times",
     FontSize->18], "2"], TraditionalForm]]],
 ",  luego el \[AAcute]rea del tetraedro es ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     SqrtBox["3"], 
     SuperscriptBox[
      StyleBox["l",
       FontSize->18], "2"]}],
    FontFamily->"Times"], TraditionalForm]],
  TextAlignment->Center,
  FontSize->14],
 ". El volumen es 1/3 del \[AAcute]rea de una cara por la altura, es decir, \
",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     FractionBox["1", 
      RowBox[{"6", 
       SqrtBox["2"]}]], 
     SuperscriptBox["l", "3"]}],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]],
  FontSize->14],
 ". Por \[UAcute]ltimo, el \[AAcute]ngulo di\[EAcute]drico tiene por seno el \
cociente entre la altura del tetraedro y la altura de una cara, que es ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     RowBox[{
      FractionBox[
       SqrtBox["3"], "2"], "l"}], ","}],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]],
  FontSize->14],
 " luego dicho seno es ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"2", 
     SqrtBox["2"]}], "3"], TraditionalForm]],
  FontSize->14],
 " y el coseno es 1/3. La tabla siguiente recoge los datos de un poliedro de \
arista ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 1",
  FontFamily->"Times"],
 ":"
}], "Text",
 CellChangeTimes->{{3.539112199913288*^9, 3.5391122043132877`*^9}, {
  3.539112988160611*^9, 3.539112999829838*^9}, {3.539113059633469*^9, 
  3.539113121080456*^9}, {3.539113204699937*^9, 3.5391132394648438`*^9}, {
  3.5391133591799927`*^9, 3.539113359272987*^9}, {3.539113647535344*^9, 
  3.539113655676331*^9}, {3.539113888556184*^9, 3.5391138963592587`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Radio\"\>", "\<\"Inradio\"\>", "\<\"Volumen\"\>", "\<\"\
\[CapitalAAcute]rea\"\>", "\<\"\[CapitalAAcute]ngulo di\[EAcute]drico\"\>"},
    {
     StyleBox["\<\"\\!\\(\\*FractionBox[SqrtBox[\\(3\\)], \\(2 \
\\*SqrtBox[\\(2\\)]\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(1\\), \\(2 \\*SqrtBox[\\(6\\)]\\)]\
\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(1\\), \\(6 \\*SqrtBox[\\(2\\)]\\)]\
\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], 
     StyleBox["\<\"\\!\\(\\*SqrtBox[\\(3\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], 
     StyleBox["\<\"arccos[1/3]\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14]}
   },
   AutoDelete->False,
   GridBoxDividers->{
    "Columns" -> {False, True, True, True, True}, "Rows" -> {False, True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.539113815923286*^9, 3.5391188114634047`*^9},
 TextAlignment->Center],

Cell[TextData[StyleBox["EL OCTAEDRO",
 FontSize->18,
 FontColor->RGBColor[0, 0, 1]]], "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellMargins->{{100, 100}, {16, 18}},
 CellChangeTimes->{{3.538515429422391*^9, 3.538515429424019*^9}, {
  3.538517083097238*^9, 3.538517086760803*^9}, {3.538772137916774*^9, 
  3.5387721418334713`*^9}, {3.5389433492789*^9, 3.538943354615024*^9}, {
  3.538944083654379*^9, 3.538944088838513*^9}, {3.5391065561537533`*^9, 
  3.5391065641036177`*^9}, {3.539110603199396*^9, 3.5391106061050386`*^9}, {
  3.539114155036748*^9, 3.5391141567297077`*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell["\<\
Para presentar el siguiente poliedro regular observamos primero un hecho \
general:\
\>", "Text",
 CellChangeTimes->{{3.539112204454023*^9, 3.539112204455845*^9}, {
  3.5391145705929337`*^9, 3.539114583070483*^9}, {3.539114617036038*^9, 
  3.539114744378821*^9}}],

Cell[TextData[{
 "Dado un poliedro regular, podemos formar otro poliedro tomando como v\
\[EAcute]rtices los centros de las caras del poliedro dado, como aristas los \
segmentos que unen los centros de cada par de caras contiguas, y como caras \
los pol\[IAcute]gonos determinados por las aristas asociadas a caras del \
poliedro dado unidas por aristas que llegan a un mismo v\[EAcute]rtice. Dicho \
poliedro se llama ",
 StyleBox["poliedro dual",
  FontSlant->"Italic"],
 " del poliedro dado. "
}], "Text",
 CellMargins->{{30, 30}, {3, 5}},
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBmIQ7fDwl8etmFeO15rV/EG00Km0EBB96p5RHIjesalU
9TaQ3sC02ghEvzo8x+sTkLZ+vysIRHtwrYwH0YtWS6SB6JjUfQUg2qUmpRhE
9+1bfoQpFmjOPMlTIPrYH4m7IDqAPxRMf6rf8ApEMwXtA9NCDsk/QPRLBtaf
IPrSkRLFj0D6QAWDEoi+cbVbiCHuleOs8hdKIJrh00MbEB0X0xEOojXeqBaA
6LyNcoUg+hnfcXsmIP3iOq8/iP51QOg/iH62VwRM//AzTAwG0tsfLAbTB7z/
ZIFoDUHFbBB9J+ue/isg7ZTgZwqiAbOwmFI=
  "],
 TextJustification->1.,
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell["\<\
Observemos que la condici\[OAcute]n 3) de la definici\[OAcute]n de poliedro \
asegura que las caras del poliedro dual cumplen la definici\[OAcute]n de pol\
\[IAcute]gono.\
\>", "Text",
 CellChangeTimes->{{3.539112204454023*^9, 3.539112204455845*^9}, {
  3.5391145705929337`*^9, 3.539114583070483*^9}, {3.539114617036038*^9, 
  3.539114744882367*^9}, {3.539114885252201*^9, 3.539115028361856*^9}, {
  3.539423672955406*^9, 3.5394237287774477`*^9}}],

Cell["\<\
El poliedro dual tiene tantas caras como v\[EAcute]rtices tiene el poliedro \
dado, y viceversa, as\[IAcute] como el mismo n\[UAcute]mero de aristas (pues \
cada arista del poliedro dado une dos caras contiguas, las cuales determinan \
una arista del poliedro dual).\
\>", "Text",
 CellChangeTimes->{{3.539112204454023*^9, 3.539112204455845*^9}, {
   3.5391145705929337`*^9, 3.539114583070483*^9}, {3.539114617036038*^9, 
   3.539114744882367*^9}, {3.539114885252201*^9, 3.539115028361856*^9}, 
   3.539423672955406*^9, {3.541009869133892*^9, 3.541009869614513*^9}}],

Cell[TextData[{
 "La figura muestra el poliedro dual del tetraedro, que no es sino otro \
tetraedro, mientras que el poliedro dual del hexaedro es un nuevo poliedro \
regular, llamado ",
 StyleBox["octaedro,",
  FontSlant->"Italic"],
 " pues tiene ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 8",
  FontFamily->"Times"],
 " caras triangulares, ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 12",
  FontFamily->"Times"],
 " aristas y ",
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 6",
  FontFamily->"Times"],
 " v\[EAcute]rtices, a cada uno de los cuales llegan ",
 StyleBox["4",
  FontFamily->"Times"],
 " aristas. La figura muestra tambi\[EAcute]n que el dual del octaedro es el \
hexaedro:"
}], "Text",
 CellChangeTimes->{{3.53911502931501*^9, 3.539115068179885*^9}, {
  3.539115105244532*^9, 3.539115200765462*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     Graphics3DBox[{
       {GrayLevel[0.7], Opacity[0.2], 
        GeometricTransformation3DBox[
         GraphicsComplex3DBox[
          NCache[{{
            0, 0, Rational[2, 3]^Rational[1, 2] + 
             Rational[-1, 2] 6^Rational[-1, 2]}, {
            Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
             Rational[-1, 2] 6^Rational[-1, 2]}, {
            Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
             Rational[-1, 2] 6^Rational[-1, 2]}, {
            3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}}, {{
            0, 0, 0.6123724356957945}, {-0.2886751345948129, -0.5, \
-0.20412414523193154`}, {-0.2886751345948129, 0.5, -0.20412414523193154`}, {
            0.5773502691896258, 0, -0.20412414523193154`}}], 
          Polygon3DBox[{{2, 3, 4}, {3, 2, 1}, {4, 1, 2}, {1, 4, 3}}]], {{{-1, 
          0, 0}, {0, -1, 0}, {0, 0, -1}}, {0, 0, 0}}]}, 
       {GrayLevel[0.6], Opacity[1], 
        GeometricTransformation3DBox[
         GraphicsComplex3DBox[
          NCache[{{
            0, 0, Rational[2, 3]^Rational[1, 2] + 
             Rational[-1, 2] 6^Rational[-1, 2]}, {
            Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], 
             Rational[-1, 2] 6^Rational[-1, 2]}, {
            Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], 
             Rational[-1, 2] 6^Rational[-1, 2]}, {
            3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}}, {{
            0, 0, 0.6123724356957945}, {-0.2886751345948129, -0.5, \
-0.20412414523193154`}, {-0.2886751345948129, 0.5, -0.20412414523193154`}, {
            0.5773502691896258, 0, -0.20412414523193154`}}], 
          Polygon3DBox[{{2, 3, 4}, {3, 2, 1}, {4, 1, 2}, {1, 4, 3}}]], 
         NCache[{{{Rational[1, 3], 0, 0}, {0, Rational[1, 3], 0}, {
            0, 0, Rational[1, 3]}}, {0, 0, 
           0}}, {{{0.3333333333333333, 0, 0}, {0, 0.3333333333333333, 0}, {
            0, 0, 0.3333333333333333}}, {0, 0, 0}}]]}},
      AutomaticImageSize->True,
      Boxed->False,
      ImageSize->{249.77369885474587`, 261.1426291389867},
      Lighting->"Neutral",
      ViewPoint->{-1.079739857986434, -3.181692984669342, -0.4012375734914949},
      ViewVertical->{-1.0298047244408115`, -0.3604155091159458, 
       0.33479993935535174`}], {193.5, -189.}, ImageScaled[{0.5, 0.5}], {360., 360.},
     
     ContentSelectable->True], InsetBox[
     Graphics3DBox[{
       {GrayLevel[0.7], Opacity[0.2], 
        GraphicsComplex3DBox[
         NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
           Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
           Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
           Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
           Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
           Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
           Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
           Rational[1, 2], Rational[1, 2], Rational[
            1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
          0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {
          0.5, 0.5, -0.5}, {0.5, 0.5, 0.5}}], 
         Polygon3DBox[{{8, 4, 2, 6}, {8, 6, 5, 7}, {8, 7, 3, 4}, {4, 3, 1, 
          2}, {1, 3, 7, 5}, {2, 1, 5, 6}}]]}, 
       {GrayLevel[0.6], Opacity[1], 
        GeometricTransformation3DBox[
         GraphicsComplex3DBox[
          NCache[{{-2^Rational[-1, 2], 0, 0}, {0, 2^Rational[-1, 2], 0}, {
            0, 0, -2^Rational[-1, 2]}, {0, 0, 2^Rational[-1, 2]}, {
            0, -2^Rational[-1, 2], 0}, {
            2^Rational[-1, 2], 0, 0}}, {{-0.7071067811865475, 0, 0}, {
            0, 0.7071067811865475, 0}, {0, 0, -0.7071067811865475}, {
            0, 0, 0.7071067811865475}, {0, -0.7071067811865475, 0}, {
            0.7071067811865475, 0, 0}}], 
          Polygon3DBox[{{4, 5, 6}, {4, 6, 2}, {4, 2, 1}, {4, 1, 5}, {5, 1, 
           3}, {5, 3, 6}, {3, 1, 2}, {6, 3, 2}}]], 
         NCache[{{{2^Rational[-1, 2], 0, 0}, {0, 2^Rational[-1, 2], 0}, {
            0, 0, 2^Rational[-1, 2]}}, {0, 0, 
           0}}, {{{0.7071067811865475, 0, 0}, {0, 0.7071067811865475, 0}, {
            0, 0, 0.7071067811865475}}, {0, 0, 0}}]]}},
      AutomaticImageSize->True,
      Boxed->False,
      ImageSize->{240.2207778612468, 215.80400005285247`},
      Lighting->"Neutral",
      ViewPoint->{1.9461134856431066`, -2.5332373183920605`, 
       1.1159529513845294`},
      ViewVertical->{0.19947630152508844`, -0.21511887645376798`, 
       0.9559984697284513}], {580.5, -189.}, ImageScaled[{0.5, 0.5}], {360., 360.},
     
     ContentSelectable->True], InsetBox[
     Graphics3DBox[{
       {GrayLevel[0.7], Opacity[0.2], 
        GraphicsComplex3DBox[
         NCache[{{-2^Rational[-1, 2], 0, 0}, {0, 2^Rational[-1, 2], 0}, {
           0, 0, -2^Rational[-1, 2]}, {0, 0, 2^Rational[-1, 2]}, {
           0, -2^Rational[-1, 2], 0}, {
           2^Rational[-1, 2], 0, 0}}, {{-0.7071067811865475, 0, 0}, {
           0, 0.7071067811865475, 0}, {0, 0, -0.7071067811865475}, {
           0, 0, 0.7071067811865475}, {0, -0.7071067811865475, 0}, {
           0.7071067811865475, 0, 0}}], 
         Polygon3DBox[{{4, 5, 6}, {4, 6, 2}, {4, 2, 1}, {4, 1, 5}, {5, 1, 
          3}, {5, 3, 6}, {3, 1, 2}, {6, 3, 2}}]]}, 
       {GrayLevel[0.6], Opacity[1], 
        GeometricTransformation3DBox[
         GraphicsComplex3DBox[
          NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
            Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
            Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
            Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
            Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
            Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
            Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
            Rational[1, 2], Rational[1, 2], Rational[
             1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
           0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 
           0.5}, {0.5, 0.5, -0.5}, {0.5, 0.5, 0.5}}], 
          Polygon3DBox[{{8, 4, 2, 6}, {8, 6, 5, 7}, {8, 7, 3, 4}, {4, 3, 1, 
           2}, {1, 3, 7, 5}, {2, 1, 5, 6}}]], 
         NCache[{{{Rational[1, 3] 2^Rational[1, 2], 0, 0}, {
            0, Rational[1, 3] 2^Rational[1, 2], 0}, {
            0, 0, Rational[1, 3] 2^Rational[1, 2]}}, {0, 0, 
           0}}, {{{0.4714045207910317, 0, 0}, {0, 0.4714045207910317, 0}, {
            0, 0, 0.4714045207910317}}, {0, 0, 0}}]]}},
      AutomaticImageSize->True,
      Boxed->False,
      ImageSize->{232.84329756839384`, 208.2727996482405},
      Lighting->"Neutral",
      ViewPoint->{1.6278480947682072`, -2.813309598403986, 0.9409567917218727},
      ViewVertical->{0.15988265178887584`, -0.3043110217434434, 
       0.9390592844450336}], {967.5, -189.}, ImageScaled[{0.5, 0.5}], {360., 360.},
     
     ContentSelectable->True]}, {}},
  ContentSelectable->True,
  ImageSize->{777., Automatic},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.5391152227594013`*^9, 3.539115238448387*^9}, {
  3.53911527677124*^9, 3.539115301670147*^9}, {3.539115366528325*^9, 
  3.539115401392487*^9}, {3.539115467124969*^9, 3.539115481968677*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "En general, el poliedro dual de un poliedro regular ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es tambi\[EAcute]n un poliedro regular, pues todas las simetr\[IAcute]as \
de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " son tambi\[EAcute]n simetr\[IAcute]as de su dual, y la transitividad para \
v\[EAcute]rtices (resp. aristas, caras) de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " implica la transitividad para caras (resp. aristas v\[EAcute]rtices) de su \
dual. ",
 "Si el octaedro tiene arista ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", es claro que los cuatro v\[EAcute]rtices distintos de dos \
v\[EAcute]rtices opuestos forman un cuadrado de lado ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", y su radio ser\[AAcute] el radio del octaedro (pues el centro del \
cuadrado equidista de cuatro de sus v\[EAcute]rtices, luego de todos). Por \
consiguiente, el radio es R = ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox["2"], "2"], TraditionalForm]]],
 StyleBox["l.",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " Para calcular el inradio usamos de nuevo que, tal y como muestra la \
figura, el radio de una cara ",
 StyleBox["VC",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", el radio del octaedro ",
 StyleBox["OV",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y el inradio ",
 StyleBox["OC",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " forman un tri\[AAcute]ngulo rect\[AAcute]ngulo y, por la geometr\[IAcute]a \
del tri\[AAcute]ngulo equil\[AAcute]tero, el radio de la cara es ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox["3"], "3"], TraditionalForm]]],
 StyleBox["l,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de donde concluimos que ",
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", 
    SqrtBox["6"]], TraditionalForm]]],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.539118265102189*^9, 3.539118278078903*^9}, {
  3.539118323026528*^9, 3.539118327271736*^9}, {3.5391184134346*^9, 
  3.53911857312197*^9}, {3.539118655606523*^9, 3.539118659915708*^9}, {
  3.541010595548712*^9, 3.54101059694807*^9}, {3.541178279022928*^9, 
  3.5411782813681498`*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.2], Glow[
     GrayLevel[0.85]], 
    GeometricTransformation3DBox[
     GraphicsComplex3DBox[
      NCache[{{-2^Rational[-1, 2], 0, 0}, {0, 2^Rational[-1, 2], 0}, {
        0, 0, -2^Rational[-1, 2]}, {0, 0, 2^Rational[-1, 2]}, {
        0, -2^Rational[-1, 2], 0}, {
        2^Rational[-1, 2], 0, 0}}, {{-0.7071067811865475, 0, 0}, {
        0, 0.7071067811865475, 0}, {0, 0, -0.7071067811865475}, {
        0, 0, 0.7071067811865475}, {0, -0.7071067811865475, 0}, {
        0.7071067811865475, 0, 0}}], 
      Polygon3DBox[{{4, 5, 6}, {4, 6, 2}, {4, 2, 1}, {4, 1, 5}, {5, 1, 3}, {5,
        3, 6}, {3, 1, 2}, {6, 3, 2}}]], {{{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}, {
      0, 0, 0}}]}, 
   Line3DBox[
    NCache[{{0, 0, 0}, {0, 0, 2^Rational[-1, 2]}, {
      Rational[1, 3] 2^Rational[-1, 2], Rational[1, 3] 2^Rational[-1, 2], 
       Rational[1, 3] 2^Rational[-1, 2]}, {0, 0, 0}}, {{0, 0, 0}, {
      0, 0, 0.7071067811865475}, {0.2357022603955158, 0.2357022603955158, 
      0.2357022603955158}, {0, 0, 0}}]], Text3DBox["O", {-0.05, -0.05, 0}], 
   Text3DBox["V", {0, 0, 0.7571067811865475}], 
   Text3DBox["C", 
    NCache[{0.28570226039551583`, Rational[1, 3] 2^Rational[-1, 2], 
      Rational[1, 3] 2^Rational[-1, 2]}, {0.28570226039551583`, 
     0.2357022603955158, 0.2357022603955158}]]},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{339.28564319758675`, 315.4264645485157},
  Lighting->None,
  ViewPoint->{1.4609077931301535`, -3.028620845257393, 0.3784233021947533},
  ViewVertical->{0.18088191716417545`, -0.48438276897993193`, 
   0.8663728528230827}]], "Output",
 CellChangeTimes->{3.5391183945673857`*^9},
 TextAlignment->Center],

Cell[TextData[{
 "La tabla siguiente contiene los datos del octaedro para ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 1",
  FontFamily->"Times"],
 ". "
}], "Text",
 CellChangeTimes->{{3.539112204454023*^9, 3.539112204455845*^9}, {
  3.5391145705929337`*^9, 3.539114583070483*^9}, {3.539114617036038*^9, 
  3.5391147592834167`*^9}, {3.539118663163849*^9, 3.5391187027867737`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Radio\"\>", "\<\"Inradio\"\>", "\<\"Volumen\"\>", "\<\"\
\[CapitalAAcute]rea\"\>", "\<\"\[CapitalAAcute]ngulo di\[EAcute]drico\"\>"},
    {
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(1\\), SqrtBox[\\(2\\)]]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(1\\), SqrtBox[\\(6\\)]]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[SqrtBox[\\(2\\)], \\(3\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], 
     StyleBox["\<\"2\\!\\(\\*SqrtBox[\\(3\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], 
     StyleBox["\<\"arccos[-1/3]\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14]}
   },
   AutoDelete->False,
   GridBoxDividers->{
    "Columns" -> {False, True, True, True, True}, "Rows" -> {False, True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.539113815923286*^9, {3.53911878755645*^9, 3.539118798314666*^9}, 
   3.5418819084927683`*^9},
 TextAlignment->Center],

Cell[TextData[{
 "El \[AAcute]rea y el volumen se obtienen f\[AAcute]cilmente (el segundo \
como suma de los vol\[UAcute]menes de las dos pir\[AAcute]mides de base \
cuadrada en que puede descomponerse el octaedro). Para obtener el \
\[AAcute]ngulo di\[EAcute]drico basta tener en cuenta que el seno del \
\[AAcute]ngulo medio es ",
 StyleBox["R",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " dividido entre la altura de una cara, que es ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox["3"], "2"], TraditionalForm]]],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellChangeTimes->{{3.539118663281815*^9, 3.539118663283436*^9}, {
  3.539118843775289*^9, 3.539118970097036*^9}}],

Cell[TextData[StyleBox["EL ICOSAEDRO",
 FontSize->18,
 FontColor->RGBColor[0, 0, 1]]], "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellMargins->{{100, 100}, {16, 18}},
 CellChangeTimes->{{3.538515429422391*^9, 3.538515429424019*^9}, {
  3.538517083097238*^9, 3.538517086760803*^9}, {3.538772137916774*^9, 
  3.5387721418334713`*^9}, {3.5389433492789*^9, 3.538943354615024*^9}, {
  3.538944083654379*^9, 3.538944088838513*^9}, {3.5391065561537533`*^9, 
  3.5391065641036177`*^9}, {3.539110603199396*^9, 3.5391106061050386`*^9}, {
  3.539114155036748*^9, 3.5391141567297077`*^9}, {3.5391190486065063`*^9, 
  3.5391190499503193`*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "A continuaci\[OAcute]n estudiamos un nuevo poliedro regular, el ",
 StyleBox["icosaedro,",
  FontSlant->"Italic"],
 " que tiene ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 20",
  FontFamily->"Times"],
 " caras triangulares, ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 30",
  FontFamily->"Times"],
 " aristas y ",
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 12",
  FontFamily->"Times"],
 " v\[EAcute]rtices, a cada uno de los cuales llegan ",
 StyleBox["5",
  FontFamily->"Times"],
 " aristas. La figura siguiente muestra su aspecto, pero no justifica su \
existencia. Observemos que la existencia del hexaedro y del tetraedro era \
inmediata, y que el octaedro lo hemos obtenido como dual del hexaedro, \
mientras que no es evidente que los ",
 StyleBox["20",
  FontFamily->"Times"],
 " tri\[AAcute]ngulos que muestra la figura puedan disponerse de forma que \
sean todos equil\[AAcute]teros y formen \[AAcute]ngulos poli\[EAcute]dricos \
iguales."
}], "Text",
 CellChangeTimes->{{3.539119052657029*^9, 3.539119052660286*^9}, {
  3.539172895712483*^9, 3.53917289571522*^9}, {3.53917297428303*^9, 
  3.5391732244273157`*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.7], Opacity[0.8], 
   GraphicsComplex3DBox[
    NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
      0, 0, 5 (50 - 10 5^Rational[1, 2])^
        Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
       0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
        Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {(
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
        5^Rational[1, 2]), Rational[
       1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
        Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
        5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {(
        Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
        5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {(
        Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
        Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
        5^Rational[1, 2]), 
       Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {(
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
        5^Rational[1, 2]), 
       Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
      0, 0, -0.9510565162951536}, {
      0, 0, 0.9510565162951536}, {-0.85065080835204, 
       0, -0.42532540417601994`}, {
      0.85065080835204, 0, 0.42532540417601994`}, {
      0.6881909602355868, -0.5, -0.42532540417601994`}, {0.6881909602355868, 
      0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
      0.42532540417601994`}, {-0.6881909602355868, 0.5, 
      0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
      0.8090169943749475, -0.42532540417601994`}, {
      0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
      0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
    Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 12}, {
     5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 10, 8}, {8, 
     3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 9}, {6, 4, 5}, {10, 
     12, 6}, {3, 8, 10}, {9, 7, 3}}]]},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{354.2186654481945, 348.0282409421545},
  Lighting->"Neutral",
  ViewPoint->{1.5441144705455874`, -2.9778283525957336`, 0.44525139452751383`},
  ViewVertical->{0.2562103152057587, -0.49564428724142817`, 
   0.8773376858383319}]], "Output",
 CellChangeTimes->{{3.5391729025257587`*^9, 3.539172923324917*^9}},
 TextAlignment->Center],

Cell["\<\
Realizaremos la construcci\[OAcute]n en varios pasos:\
\>", "Text",
 CellChangeTimes->{{3.539172895855097*^9, 3.5391728958569517`*^9}, {
  3.5391732482685843`*^9, 3.539173327244114*^9}, {3.5391733749505377`*^9, 
  3.5391734051733713`*^9}, {3.541359633216075*^9, 3.541359639427031*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`p$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`p$$], 1, "Paso"}, {1, 2, 3, 4, 5, 6, 7}}, {
      Hold[
       Button["Mostrar en ventana", 
        CreateWindow[
         DialogNotebook[
          Pane[
           Manipulate[
            Graphics3D[{{
               Opacity[
                If[$CellContext`p$$ < 3, 0, 0.3]], 
               Sphere[{0, 0, 0}, 1]}, 
              If[$CellContext`p$$ > 1, 
               Text[
                Style["O", 12, Italic], {0, 0, -1.1}]], 
              If[$CellContext`p$$ == 7, 
               Text[
                Style["K", 12, Italic], {0, 0, 1.1}]], 
              Text[
               Style["A", 12, Italic], 
               1.1 {(1 + 5^Rational[1, 2])/(
                 2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), -(1/2), -(
                  1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}], 
              Text[
               Style["B", 12, Italic], 
               1.1 {(1 + 5^Rational[1, 2])/(
                 2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), 1/
                 2, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}], 
              Text[
               Style["C", 12, Italic], 
               1.1 {-((-1 + 5^Rational[1, 2])/(
                  2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (1/
                  2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                  Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
                  Rational[1, 2])}], 
              Text[
               Style["D", 12, Italic], 
               1.1 {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
                 0, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}], 
              Text[
               Style["E", 12, Italic], 
               1.1 {-((-1 + 5^Rational[1, 2])/(
                  2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (-(1/
                   2)) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                  Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
                  Rational[1, 2])}], 
              If[$CellContext`p$$ > 2, 
               Text[
                Style["G", 12, Italic], 
                1.1 {(-1 + 5^Rational[1, 2])/(
                  2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), (1/
                   2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                   Rational[1, 2], 1/(10 - 2 5^Rational[1, 2])^
                  Rational[1, 2]}]], 
              If[$CellContext`p$$ > 3, 
               Text[
                Style["H", 12, Italic], 
                1.1 {-((1 + 5^Rational[1, 2])/(
                   2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), 1/2, 
                  1/(10 - 2 5^Rational[1, 2])^Rational[1, 2]}]], 
              If[$CellContext`p$$ > 4, 
               Text[
                Style["I", 12, Italic], 
                1.1 {-((1 + 5^Rational[1, 2])/(
                   2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), -(1/2), 
                  1/(10 - 2 5^Rational[1, 2])^Rational[1, 2]}]], 
              If[$CellContext`p$$ > 4, 
               Text[
                Style["J", 12, Italic], 
                1.1 {(-1 + 5^Rational[1, 2])/(
                  2 (10 - 2 5^Rational[1, 2])^
                   Rational[1, 2]), (-(1/2)) ((5 + 5^Rational[1, 2])/(5 - 5^
                    Rational[1, 2]))^Rational[1, 2], 
                  1/(10 - 2 5^Rational[1, 2])^Rational[1, 2]}]], 
              If[$CellContext`p$$ > 2, 
               Text[
                Style["F", 12, Italic], 
                1.1 {(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 0, 
                  1/(10 - 2 5^Rational[1, 2])^Rational[1, 2]}]], {
               GrayLevel[0.7], 
               Opacity[0.95], 
               GraphicsComplex[{
                 
                 If[$CellContext`p$$ == 1, {
                  0, 0, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {
                  0, 0, -(5/(50 - 10 5^Rational[1, 2])^Rational[1, 2])}], {
                 0, 0, 5/(50 - 10 5^Rational[1, 2])^
                  Rational[1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^
                   Rational[1, 2], 
                  0, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {(2/(5 - 
                   5^Rational[1, 2]))^Rational[1, 2], 0, 
                  1/(10 - 2 5^Rational[1, 2])^
                  Rational[1, 2]}, {(1 + 5^Rational[1, 2])/(
                  2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), -(1/2), -(
                   1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {(1 + 
                   5^Rational[1, 2])/(
                  2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), 1/
                  2, -(1/(10 - 2 5^Rational[1, 2])^
                   Rational[1, 2])}, {-((1 + 5^Rational[1, 2])/(
                   2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), -(1/2), 
                  1/(10 - 2 5^Rational[1, 2])^
                  Rational[1, 2]}, {-((1 + 5^Rational[1, 2])/(
                   2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), 1/2, 
                  1/(10 - 2 5^Rational[1, 2])^
                  Rational[1, 2]}, {-((-1 + 5^Rational[1, 2])/(
                   2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (-(1/
                    2)) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                   Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
                   Rational[1, 2])}, {-((-1 + 5^Rational[1, 2])/(
                   2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (1/
                   2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                   Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
                   Rational[1, 2])}, {(-1 + 5^Rational[1, 2])/(
                  2 (10 - 2 5^Rational[1, 2])^
                   Rational[1, 2]), (-(1/2)) ((5 + 5^Rational[1, 2])/(5 - 5^
                    Rational[1, 2]))^Rational[1, 2], 
                  1/(10 - 2 5^Rational[1, 2])^
                  Rational[1, 2]}, {(-1 + 5^Rational[1, 2])/(
                  2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), (1/
                   2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                   Rational[1, 2], 1/(10 - 2 5^Rational[1, 2])^
                  Rational[1, 2]}}, 
                If[$CellContext`p$$ < 3, 
                 
                 Polygon[{{5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3,
                   1}}], 
                 If[$CellContext`p$$ == 3, 
                  
                  Polygon[{{5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 
                   3, 1}, {4, 6, 12}, {6, 4, 5}, {10, 12, 6}}], 
                  If[$CellContext`p$$ == 4, 
                   
                   Polygon[{{5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 
                    3, 1}, {12, 10, 8}, {4, 6, 12}, {6, 4, 5}, {10, 12, 6}, {
                    3, 8, 10}}], 
                   If[$CellContext`p$$ == 5, 
                    
                    Polygon[{{5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9,
                     3, 1}, {12, 10, 8}, {8, 3, 7}, {3, 8, 10}, {11, 5, 4}, {
                    4, 6, 12}, {5, 11, 9}, {6, 4, 5}, {10, 12, 6}, {9, 7, 
                    3}}], 
                    If[$CellContext`p$$ == 6, 
                    
                    Polygon[{{5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9,
                     3, 1}, {12, 10, 8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {
                    4, 6, 12}, {5, 11, 9}, {6, 4, 5}, {10, 12, 6}, {3, 8, 
                    10}, {9, 7, 3}}], 
                    
                    Polygon[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {
                    2, 4, 12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {
                    9, 3, 1}, {12, 10, 8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 
                    4}, {4, 6, 12}, {5, 11, 9}, {6, 4, 5}, {10, 12, 6}, {3, 8,
                     10}, {9, 7, 3}}]]]]]]]}}, Lighting -> "Neutral", Boxed -> 
             False, ImageSize -> 500], {{$CellContext`p$$, 1, "Paso"}, 
             Range[7], ControlType -> SetterBar}, Paneled -> False, 
            AppearanceElements -> {}], {500, 500}], WindowTitle -> 
          "Construcci\[OAcute]n del icosaedro", WindowFloating -> "True", 
          WindowFrame -> "Palette", Selectable -> False]]]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    360., {193., 198.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`p$7570$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`p$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`p$$, $CellContext`p$7570$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{{
          Opacity[
           If[$CellContext`p$$ < 3, 0, 0.3]], 
          Sphere[{0, 0, 0}, 1]}, 
         If[$CellContext`p$$ > 1, 
          Text[
           Style["O", 12, Italic], {0, 0, -1.1}]], 
         If[$CellContext`p$$ == 7, 
          Text[
           Style["K", 12, Italic], {0, 0, 1.1}]], 
         Text[
          Style["A", 12, Italic], 
          1.1 {(1 + 5^Rational[1, 2])/(
            2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), -(1/2), -(
             1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}], 
         Text[
          Style["B", 12, Italic], 
          1.1 {(1 + 5^Rational[1, 2])/(
            2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), 1/
            2, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}], 
         Text[
          Style["C", 12, Italic], 
          1.1 {-((-1 + 5^Rational[1, 2])/(
             2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (1/
             2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
             Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}], 
         
         Text[
          Style["D", 12, Italic], 
          1.1 {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
            0, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}], 
         Text[
          Style["E", 12, Italic], 
          1.1 {-((-1 + 5^Rational[1, 2])/(
             2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (-(1/
              2)) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
             Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}], 
         
         If[$CellContext`p$$ > 2, 
          Text[
           Style["G", 12, Italic], 
           1.1 {(-1 + 5^Rational[1, 2])/(
             2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), (1/
              2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
              Rational[1, 2], 1/(10 - 2 5^Rational[1, 2])^Rational[1, 2]}]], 
         If[$CellContext`p$$ > 3, 
          Text[
           Style["H", 12, Italic], 
           1.1 {-((1 + 5^Rational[1, 2])/(
              2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), 1/2, 
             1/(10 - 2 5^Rational[1, 2])^Rational[1, 2]}]], 
         If[$CellContext`p$$ > 4, 
          Text[
           Style["I", 12, Italic], 
           1.1 {-((1 + 5^Rational[1, 2])/(
              2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), -(1/2), 
             1/(10 - 2 5^Rational[1, 2])^Rational[1, 2]}]], 
         If[$CellContext`p$$ > 4, 
          Text[
           Style["J", 12, Italic], 
           1.1 {(-1 + 5^Rational[1, 2])/(
             2 (10 - 2 5^Rational[1, 2])^
              Rational[1, 2]), (-(1/2)) ((5 + 5^Rational[1, 2])/(5 - 5^
               Rational[1, 2]))^Rational[1, 2], 1/(10 - 2 5^Rational[1, 2])^
             Rational[1, 2]}]], 
         If[$CellContext`p$$ > 2, 
          Text[
           Style["F", 12, Italic], 
           1.1 {(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 0, 
             1/(10 - 2 5^Rational[1, 2])^Rational[1, 2]}]], {
          GrayLevel[0.7], 
          Opacity[0.95], 
          GraphicsComplex[{
            
            If[$CellContext`p$$ == 1, {
             0, 0, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {
             0, 0, -(5/(50 - 10 5^Rational[1, 2])^Rational[1, 2])}], {
            0, 0, 5/(50 - 10 5^Rational[1, 2])^
             Rational[1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
             0, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {(2/(5 - 5^
              Rational[1, 2]))^Rational[1, 2], 0, 1/(10 - 2 5^Rational[1, 2])^
             Rational[1, 2]}, {(1 + 5^Rational[1, 2])/(
             2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), -(1/2), -(
              1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {(1 + 
              5^Rational[1, 2])/(2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), 
             1/2, -(1/(10 - 2 5^Rational[1, 2])^
              Rational[1, 2])}, {-((1 + 5^Rational[1, 2])/(
              2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), -(1/2), 
             1/(10 - 2 5^Rational[1, 2])^
             Rational[1, 2]}, {-((1 + 5^Rational[1, 2])/(
              2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), 1/2, 
             1/(10 - 2 5^Rational[1, 2])^
             Rational[1, 2]}, {-((-1 + 5^Rational[1, 2])/(
              2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (-(1/
               2)) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
              Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
              Rational[1, 2])}, {-((-1 + 5^Rational[1, 2])/(
              2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (1/
              2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
              Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
              Rational[1, 2])}, {(-1 + 5^Rational[1, 2])/(
             2 (10 - 2 5^Rational[1, 2])^
              Rational[1, 2]), (-(1/2)) ((5 + 5^Rational[1, 2])/(5 - 5^
               Rational[1, 2]))^Rational[1, 2], 1/(10 - 2 5^Rational[1, 2])^
             Rational[1, 2]}, {(-1 + 5^Rational[1, 2])/(
             2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), (1/
              2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
              Rational[1, 2], 1/(10 - 2 5^Rational[1, 2])^Rational[1, 2]}}, 
           If[$CellContext`p$$ < 3, 
            
            Polygon[{{5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 
             1}}], 
            If[$CellContext`p$$ == 3, 
             
             Polygon[{{5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 
              1}, {4, 6, 12}, {6, 4, 5}, {10, 12, 6}}], 
             If[$CellContext`p$$ == 4, 
              
              Polygon[{{5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 
               1}, {12, 10, 8}, {4, 6, 12}, {6, 4, 5}, {10, 12, 6}, {3, 8, 
               10}}], 
              If[$CellContext`p$$ == 5, 
               
               Polygon[{{5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 
                1}, {12, 10, 8}, {8, 3, 7}, {3, 8, 10}, {11, 5, 4}, {4, 6, 
                12}, {5, 11, 9}, {6, 4, 5}, {10, 12, 6}, {9, 7, 3}}], 
               If[$CellContext`p$$ == 6, 
                
                Polygon[{{5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 
                 1}, {12, 10, 8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 
                 12}, {5, 11, 9}, {6, 4, 5}, {10, 12, 6}, {3, 8, 10}, {9, 7, 
                 3}}], 
                
                Polygon[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4,
                  12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 
                 1}, {12, 10, 8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 
                 12}, {5, 11, 9}, {6, 4, 5}, {10, 12, 6}, {3, 8, 10}, {9, 7, 
                 3}}]]]]]]]}}, Lighting -> "Neutral", Boxed -> False], 
      "Specifications" :> {{{$CellContext`p$$, 1, "Paso"}, {1, 2, 3, 4, 5, 6, 
         7}, ControlType -> SetterBar}, 
        Button["Mostrar en ventana", 
         CreateWindow[
          DialogNotebook[
           Pane[
            Manipulate[
             Graphics3D[{{
                Opacity[
                 If[$CellContext`p$$ < 3, 0, 0.3]], 
                Sphere[{0, 0, 0}, 1]}, 
               If[$CellContext`p$$ > 1, 
                Text[
                 Style["O", 12, Italic], {0, 0, -1.1}]], 
               If[$CellContext`p$$ == 7, 
                Text[
                 Style["K", 12, Italic], {0, 0, 1.1}]], 
               Text[
                Style["A", 12, Italic], 
                1.1 {(1 + 5^Rational[1, 2])/(
                  2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), -(1/2), -(
                   1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}], 
               Text[
                Style["B", 12, Italic], 
                1.1 {(1 + 5^Rational[1, 2])/(
                  2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), 1/
                  2, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}], 
               Text[
                Style["C", 12, Italic], 
                1.1 {-((-1 + 5^Rational[1, 2])/(
                   2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (1/
                   2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                   Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
                   Rational[1, 2])}], 
               Text[
                Style["D", 12, Italic], 
                1.1 {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
                  0, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}], 
               Text[
                Style["E", 12, Italic], 
                1.1 {-((-1 + 5^Rational[1, 2])/(
                   2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (-(1/
                    2)) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                   Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
                   Rational[1, 2])}], 
               If[$CellContext`p$$ > 2, 
                Text[
                 Style["G", 12, Italic], 
                 1.1 {(-1 + 5^Rational[1, 2])/(
                   2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), (1/
                    2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                    Rational[1, 2], 1/(10 - 2 5^Rational[1, 2])^
                   Rational[1, 2]}]], 
               If[$CellContext`p$$ > 3, 
                Text[
                 Style["H", 12, Italic], 
                 1.1 {-((1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), 1/2, 
                   1/(10 - 2 5^Rational[1, 2])^Rational[1, 2]}]], 
               If[$CellContext`p$$ > 4, 
                Text[
                 Style["I", 12, Italic], 
                 1.1 {-((1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), -(1/2), 
                   1/(10 - 2 5^Rational[1, 2])^Rational[1, 2]}]], 
               If[$CellContext`p$$ > 4, 
                Text[
                 Style["J", 12, Italic], 
                 1.1 {(-1 + 5^Rational[1, 2])/(
                   2 (10 - 2 5^Rational[1, 2])^
                    Rational[1, 2]), (-(1/2)) ((5 + 5^Rational[1, 2])/(5 - 5^
                    Rational[1, 2]))^Rational[1, 2], 
                   1/(10 - 2 5^Rational[1, 2])^Rational[1, 2]}]], 
               If[$CellContext`p$$ > 2, 
                Text[
                 Style["F", 12, Italic], 
                 1.1 {(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 0, 
                   1/(10 - 2 5^Rational[1, 2])^Rational[1, 2]}]], {
                GrayLevel[0.7], 
                Opacity[0.95], 
                GraphicsComplex[{
                  
                  If[$CellContext`p$$ == 1, {
                   0, 0, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {
                   0, 0, -(5/(50 - 10 5^Rational[1, 2])^Rational[1, 2])}], {
                  0, 0, 5/(50 - 10 5^Rational[1, 2])^
                   Rational[1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^
                    Rational[1, 2], 
                   0, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {(2/(5 - 
                    5^Rational[1, 2]))^Rational[1, 2], 0, 
                   1/(10 - 2 5^Rational[1, 2])^
                   Rational[1, 2]}, {(1 + 5^Rational[1, 2])/(
                   2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), -(1/2), -(
                    1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {(1 + 
                    5^Rational[1, 2])/(
                   2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), 1/
                   2, -(1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2])}, {-((1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), -(1/2), 
                   1/(10 - 2 5^Rational[1, 2])^
                   Rational[1, 2]}, {-((1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), 1/2, 
                   1/(10 - 2 5^Rational[1, 2])^
                   Rational[1, 2]}, {-((-1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (-(1/
                    2)) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                    Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2])}, {-((-1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (1/
                    2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                    Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2])}, {(-1 + 5^Rational[1, 2])/(
                   2 (10 - 2 5^Rational[1, 2])^
                    Rational[1, 2]), (-(1/2)) ((5 + 5^Rational[1, 2])/(5 - 5^
                    Rational[1, 2]))^Rational[1, 2], 
                   1/(10 - 2 5^Rational[1, 2])^
                   Rational[1, 2]}, {(-1 + 5^Rational[1, 2])/(
                   2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), (1/
                    2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                    Rational[1, 2], 1/(10 - 2 5^Rational[1, 2])^
                   Rational[1, 2]}}, 
                 If[$CellContext`p$$ < 3, 
                  
                  Polygon[{{5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 
                   3, 1}}], 
                  If[$CellContext`p$$ == 3, 
                   
                   Polygon[{{5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 
                    3, 1}, {4, 6, 12}, {6, 4, 5}, {10, 12, 6}}], 
                   If[$CellContext`p$$ == 4, 
                    
                    Polygon[{{5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9,
                     3, 1}, {12, 10, 8}, {4, 6, 12}, {6, 4, 5}, {10, 12, 6}, {
                    3, 8, 10}}], 
                    If[$CellContext`p$$ == 5, 
                    
                    Polygon[{{5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9,
                     3, 1}, {12, 10, 8}, {8, 3, 7}, {3, 8, 10}, {11, 5, 4}, {
                    4, 6, 12}, {5, 11, 9}, {6, 4, 5}, {10, 12, 6}, {9, 7, 
                    3}}], 
                    If[$CellContext`p$$ == 6, 
                    
                    Polygon[{{5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9,
                     3, 1}, {12, 10, 8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {
                    4, 6, 12}, {5, 11, 9}, {6, 4, 5}, {10, 12, 6}, {3, 8, 
                    10}, {9, 7, 3}}], 
                    
                    Polygon[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {
                    2, 4, 12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {
                    9, 3, 1}, {12, 10, 8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 
                    4}, {4, 6, 12}, {5, 11, 9}, {6, 4, 5}, {10, 12, 6}, {3, 8,
                     10}, {9, 7, 3}}]]]]]]]}}, Lighting -> "Neutral", Boxed -> 
              False, ImageSize -> 500], {{$CellContext`p$$, 1, "Paso"}, 
              Range[7], ControlType -> SetterBar}, Paneled -> False, 
             AppearanceElements -> {}], {500, 500}], WindowTitle -> 
           "Construcci\[OAcute]n del icosaedro", WindowFloating -> "True", 
           WindowFrame -> "Palette", Selectable -> False]]]}, 
      "Options" :> {AppearanceElements -> {}}, "DefaultOptions" :> {}],
     ImageSizeCache->{405., {244., 250.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.54135894812289*^9, {3.541359181474469*^9, 3.541359193500476*^9}, {
   3.541359285407542*^9, 3.541359324607772*^9}, {3.541359363480999*^9, 
   3.541359370726899*^9}, 3.541359506009673*^9, 3.541359543721327*^9, 
   3.5413595900985622`*^9, 3.5419386366462097`*^9},
 TextAlignment->Center],

Cell[TextData[{
 StyleBox["Paso 1:",
  FontWeight->"Bold"],
 " Partimos de un pent\[AAcute]gono regular de lado ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". La geometr\[IAcute]a del pent\[AAcute]gono nos da que su radio es menor \
que su lado, por lo que podemos tomar un punto ",
 StyleBox["O",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " situado sobre la perpendicular al pent\[AAcute]gono que pasa por su centro \
cuya distancia a cada uno de los v\[EAcute]rtices sea igual a ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellChangeTimes->{{3.5391190530860786`*^9, 3.5391190530880127`*^9}, {
  3.539173728482847*^9, 3.539173748410795*^9}}],

Cell[TextData[{
 StyleBox["Paso 2:",
  FontWeight->"Bold"],
 " Tenemos as\[IAcute] la superficie lateral de una pir\[AAcute]mide \
pentagonal cuyas aristas miden todas ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". Ahora observamos que el tri\[AAcute]ngulo ",
 StyleBox["AOC",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es igual a ",
 StyleBox["ABC,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " por lo que el \[AAcute]ngulo ",
 StyleBox["AOC",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["108",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ", es decir, el \[AAcute]ngulo interior del pent\[AAcute]gono regular. Por \
lo tanto, podemos construir un pent\[AAcute]gono regular que contenga a ",
 StyleBox["AO",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["OC",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " como lados, y unir todos sus v\[EAcute]rtices con el punto ",
 StyleBox["B",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellChangeTimes->{{3.5391190530860786`*^9, 3.5391190530880127`*^9}, {
  3.539173728482847*^9, 3.539173796729504*^9}, {3.5391738578264227`*^9, 
  3.539173970291353*^9}, {3.5391740126777277`*^9, 3.539174130533127*^9}}],

Cell[TextData[{
 StyleBox["Paso 3:",
  FontWeight->"Bold"],
 " Como ",
 StyleBox["B",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] a distancia ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de los v\[EAcute]rtices ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", ",
 StyleBox["O",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", est\[AAcute] sobre la recta perpendicular a su plano y que pasa por el \
centro de la circunferencia que los contiene, que es el centro del nuevo pent\
\[AAcute]gono ",
 StyleBox["OAFGC,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " luego ",
 StyleBox["B",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] a distancia ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de los cinco v\[EAcute]rtices del pent\[AAcute]gono, y as\[IAcute], los \
ocho tri\[AAcute]ngulos representados en la figura son equil\[AAcute]teros (y \
los dos pent\[AAcute]gonos que se ven son regulares, y en particular \
planos)."
}], "Text",
 CellChangeTimes->{{3.539119053230014*^9, 3.539119053231813*^9}, {
  3.539174151964877*^9, 3.53917416303691*^9}, {3.539174198701893*^9, 
  3.5391743157425547`*^9}, {3.5391743465057497`*^9, 3.539174405847501*^9}, {
  3.539174619237352*^9, 3.539174699371766*^9}, {3.539175975173114*^9, 
  3.5391759759182663`*^9}}],

Cell[TextData[{
 "Observamos ahora que todos los v\[EAcute]rtices que hemos construido hasta \
aqu\[IAcute] se encuentran sobre una esfera. En efecto, el lugar \
geom\[EAcute]trico de los puntos que equidistan de los v\[EAcute]rtices del \
pent\[AAcute]gono ",
 StyleBox["ABCDE",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es la recta perpendicular a su plano que pasa por su centro, la cual \
contiene al v\[EAcute]rtice ",
 StyleBox["O",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", y s\[OAcute]lo uno de sus puntos est\[AAcute] a la misma distancia del v\
\[EAcute]rtice ",
 StyleBox["O",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". Llamemos ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " a dicho punto equidistante de los seis v\[EAcute]rtices, que es el centro \
de la \[UAcute]nica esfera que los contiene. Falta probar que los \
v\[EAcute]rtices ",
 StyleBox["F",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["G",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute]n en la misma esfera, pero esto se debe a que P equidista de \
los puntos ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", ",
 StyleBox["O",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego est\[AAcute] sobre la recta perpendicular al plano que los contiene \
y que pasa por el centro de la circunferencia que los contiene, pero \
\[EAcute]ste es el centro del pent\[AAcute]gono ",
 StyleBox["OAFGC,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " luego ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " equidista de todos los v\[EAcute]rtices de este pent\[AAcute]gono."
}], "Text",
 CellChangeTimes->{{3.539119053230014*^9, 3.539119053231813*^9}, {
  3.539174151964877*^9, 3.53917416303691*^9}, {3.539174198701893*^9, 
  3.5391743157425547`*^9}, {3.5391743465057497`*^9, 3.539174405847501*^9}, {
  3.539174619237352*^9, 3.539174699371766*^9}, {3.539175975173114*^9, 
  3.539176100505309*^9}, {3.539176167906292*^9, 3.539176305539846*^9}, {
  3.539181568191908*^9, 3.539181568195404*^9}}],

Cell[TextData[{
 "Por otra parte, observamos que los cuatro v\[EAcute]rtices ",
 StyleBox["D, O, B, G",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute]n en el mismo plano. Esto se debe a que est\[AAcute]n a la \
misma distancia tanto de ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " como de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego est\[AAcute]n en la intersecci\[OAcute]n de dos esferas, que es una \
circunferencia. Como los \[AAcute]ngulos ",
 StyleBox["DOB",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["OBG",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " son ambos de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["108",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ", concluimos que los cuatro v\[EAcute]rtices forman parte de un pent\
\[AAcute]gono regular. Llamamos ",
 StyleBox["H",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " al quinto v\[EAcute]rtice."
}], "Text",
 CellChangeTimes->{{3.539119053230014*^9, 3.539119053231813*^9}, {
  3.539174151964877*^9, 3.53917416303691*^9}, {3.539174198701893*^9, 
  3.5391743157425547`*^9}, {3.5391743465057497`*^9, 3.539174405847501*^9}, {
  3.539174619237352*^9, 3.539174699371766*^9}, {3.539175975173114*^9, 
  3.539175976631728*^9}, {3.539181866198234*^9, 3.539181866819243*^9}}],

Cell[TextData[{
 StyleBox["Paso 4:",
  FontWeight->"Bold"],
 " Como en el paso anterior se razona que ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] a distancia ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de los cinco v\[EAcute]rtices del nuevo pent\[AAcute]gono, con lo que \
todos los tri\[AAcute]ngulos son equil\[AAcute]teros e igualmente concluimos \
que todos los v\[EAcute]rtices est\[AAcute]n sobre la esfera de centro ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". Igualmente razonamos que tanto los v\[EAcute]rtices ",
 StyleBox["E, O, C, H",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " como los v\[EAcute]rtices ",
 StyleBox["E, O, B, F",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " forman parte de sendos pent\[AAcute]gonos regulares, que podemos \
a\[NTilde]adir a la construcci\[OAcute]n."
}], "Text",
 CellChangeTimes->{{3.539176961362172*^9, 3.539177038451165*^9}, {
  3.5391819876980658`*^9, 3.539181998079791*^9}}],

Cell[TextData[{
 StyleBox["Paso 5:",
  FontWeight->"Bold"],
 " La repetici\[OAcute]n de los razonamientos precedentes justifica que todos \
los v\[EAcute]rtices representados en la figura est\[AAcute]n sobre la misma \
esfera, que todas las caras que determinan son tri\[AAcute]ngulos equil\
\[AAcute]teros, y que los cinco pent\[AAcute]gonos son regulares. Adem\
\[AAcute]s, los cinco v\[EAcute]rtices ",
 StyleBox["A, O, D, I, J",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute]n sobre una misma circunferencia, porque equidistan de ",
 StyleBox["E",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", y como forman \[AAcute]ngulos de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["108",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ", podemos concluir que determinan un nuevo pent\[AAcute]gono regular."
}], "Text",
 CellChangeTimes->{{3.539119053366008*^9, 3.5391190533679123`*^9}, {
  3.5391770678703547`*^9, 3.539177187749185*^9}, {3.539177538244507*^9, 
  3.5391777632995043`*^9}, {3.539177806550239*^9, 3.5391778329206123`*^9}, {
  3.5391820293006*^9, 3.539182146945704*^9}}],

Cell[TextData[{
 StyleBox["Paso 6:",
  FontWeight->"Bold"],
 " En este punto tenemos que todos los pent\[AAcute]gonos que muestra la \
figura son regulares por construcci\[OAcute]n salvo quiz\[AAcute] el pent\
\[AAcute]gono ",
 StyleBox["FGHIJ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". Ahora bien, todos sus puntos est\[AAcute]n a la misma distancia de ",
 StyleBox["O",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", a saber a distancia \[CapitalPhi]",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", la diagonal de un pent\[AAcute]gono regular de lado ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego los cinco puntos est\[AAcute]n en la intersecci\[OAcute]n de dos \
esferas: una de centro ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y otra de centro ",
 StyleBox["O,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " luego est\[AAcute]n sobre una misma circunferencia y a su vez esto nos \
permite concluir como siempre que forman un pent\[AAcute]gono regular. As\
\[IAcute] podemos repetir el paso 2 y construir una pir\[AAcute]mide \
pentagonal sobre \[EAcute]l cuyas aristas tengan todas longitud ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellChangeTimes->{{3.539177833699512*^9, 3.539177835427424*^9}, {
  3.539177951153056*^9, 3.539177980861223*^9}, {3.539178048215802*^9, 
  3.5391782115524483`*^9}, {3.539178530151021*^9, 3.5391785532117367`*^9}, {
  3.5391821803257*^9, 3.539182219709408*^9}, {3.539182287710597*^9, 
  3.5391822926036177`*^9}}],

Cell[TextData[{
 StyleBox["Paso 7:",
  FontWeight->"Bold"],
 " Supongamos que no hubi\[EAcute]ramos construido el v\[EAcute]rtice ",
 StyleBox["K",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " (ni por tanto la \[UAcute]ltima pir\[AAcute]mide), y en su lugar \
observamos que los v\[EAcute]rtices ",
 StyleBox["G, B, A, J",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute]n sobre una misma circunferencia (por el argumento usual, \
porque equidistan de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " por una parte y de ",
 StyleBox["F",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " por otra), lo que nos permite concluir como siempre que pueden completarse \
hasta un pent\[AAcute]gono regular con un v\[EAcute]rtice ",
 StyleBox["K\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". Como ",
 StyleBox["F",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] a distancia ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de ",
 StyleBox["G, B, A, J",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", est\[AAcute] a la misma distancia de ",
 StyleBox["K\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego ",
 StyleBox["K\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] a la misma distancia ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de ",
 StyleBox["C, F",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["G",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". Esto implica que est\[AAcute] a la misma distancia de los cinco \
v\[EAcute]rtices del pent\[AAcute]gono regular ",
 StyleBox["FGHIJ,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " luego ",
 StyleBox["K\[CloseCurlyQuote]",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es el mismo punto ",
 StyleBox["K",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". Con esto hemos probado que la base de la pir\[AAcute]mide que rodea a ",
 StyleBox["F",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un pent\[AAcute]gono regular, y el mismo argumento se aplica a las pir\
\[AAcute]mides de ",
 StyleBox["C, G, H, I",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", con lo que concluimos que las doce pir\[AAcute]mides pentagonales del \
icosaedro tienen base regular."
}], "Text",
 CellChangeTimes->{{3.5391785621892014`*^9, 3.539178564035323*^9}, {
  3.5391787433050327`*^9, 3.5391787629578753`*^9}, {3.5391788790152073`*^9, 
  3.539178916975217*^9}, {3.5391789552794867`*^9, 3.5391789565672207`*^9}, {
  3.539178993458481*^9, 3.539178994175742*^9}, {3.5391827234583683`*^9, 
  3.539183134268176*^9}, {3.5391836548837233`*^9, 3.539183655002564*^9}}],

Cell[TextData[{
 "En la construcci\[OAcute]n anterior hemos visto que el v\[EAcute]rtice ",
 StyleBox["O",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " equidista de los cinco v\[EAcute]rtices del pent\[AAcute]gono ",
 StyleBox["FGHIJ,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " los cuales por otra parte equidistan de ",
 StyleBox["K",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y de P. Esto prueba que los puntos ",
 StyleBox["O",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["K",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute]n alineados y el argumento vale claramente para todo par de v\
\[EAcute]rtices opuestos. Equivalentemente: la diagonal que une dos \
v\[EAcute]rtices opuestos de un icosaedro pasa por su centro y es \
perpendicular a los dos pent\[AAcute]gonos regulares que atraviesa. Esto \
implica que un giro de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["72",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 " respecto de dicha diagonal permuta los v\[EAcute]rtices de ambos pent\
\[AAcute]gonos y fija a los dos v\[EAcute]rtices que une. Es claro entonces \
que tal giro es una simetr\[IAcute]a del icosaedro, as\[IAcute] como que \
componiendo adecuadamente varios de estos giros (respecto de diagonales \
distintas) podemos transformar cualquier v\[EAcute]rtice en cualquier v\
\[EAcute]rtice, cualquier arista en cualquier arista y cualquier cara en \
cualquier cara. Esto prueba que el icosaedro es un poliedro regular."
}], "Text",
 CellChangeTimes->{{3.539112204598035*^9, 3.539112204599663*^9}, {
   3.539183827166095*^9, 3.53918406849393*^9}, {3.5391841199051867`*^9, 
   3.539184137598414*^9}, {3.5391841682015753`*^9, 3.539184282266226*^9}, {
   3.541010813466514*^9, 3.541010813573029*^9}, {3.541010865767248*^9, 
   3.541010882670721*^9}, 3.541010912849518*^9, {3.541010978875573*^9, 
   3.541010978883287*^9}}],

Cell["\<\
Observemos ahora que las diagonales que unen dos pares de v\[EAcute]rtices \
opuestos se cortan en el centro del poliedro, luego dos pares de \
v\[EAcute]rtices opuestos est\[AAcute]n contenidos en la misma circunferencia \
y forman un cuadrilatero inscrito cuyas diagonales son di\[AAcute]metros, \
luego sus \[AAcute]ngulos son rectos (porque abarcan semicircunferencias). En \
resumen: dos pares de v\[EAcute]rtices opuestos en un icosaedro forman un \
rect\[AAcute]ngulo. Podemos elegir tres de estos rect\[AAcute]ngulos de modo \
que tengan conjuntos disjuntos de v\[EAcute]rtices, tal y como muestra la \
figura siguiente:\
\>", "Text",
 CellChangeTimes->{{3.539184287184269*^9, 3.539184433433185*^9}, {
  3.5391844668036013`*^9, 3.5391845116021833`*^9}, {3.5410109922097893`*^9, 
  3.541010993728046*^9}, {3.541178339219152*^9, 3.5411783436882963`*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.5], Glow[
     GrayLevel[0.85]], 
    GraphicsComplex3DBox[
     NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
       0, 0, 5 (50 - 10 5^Rational[1, 2])^
         Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
        0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
         Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
        Rational[-1, 2]}, {
       Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
         5^Rational[1, 2]), 
        Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
       Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
         5^Rational[1, 2]), Rational[
        1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
       Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
         5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
        Rational[-1, 2]}, {
       Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
         5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
        Rational[-1, 2]}, {
       Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
         5^Rational[1, 2]), 
        Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
       Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
         5^Rational[1, 2]), 
        Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
       Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
         5^Rational[1, 2]), 
        Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
       Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
         5^Rational[1, 2]), 
        Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
       0, 0, -0.9510565162951536}, {
       0, 0, 0.9510565162951536}, {-0.85065080835204, 
        0, -0.42532540417601994`}, {
       0.85065080835204, 0, 0.42532540417601994`}, {
       0.6881909602355868, -0.5, -0.42532540417601994`}, {0.6881909602355868, 
       0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
       0.42532540417601994`}, {-0.6881909602355868, 0.5, 
       0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
       0.8090169943749475, -0.42532540417601994`}, {
       0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
       0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
     Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 
      12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 10, 
      8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 9}, {6, 4, 
      5}, {10, 12, 6}, {3, 8, 10}, {9, 7, 3}}]]}, 
   {Glow[
     GrayLevel[0.5]], 
    GraphicsComplex3DBox[
     NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
       0, 0, 5 (50 - 10 5^Rational[1, 2])^
         Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
        0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
         Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
        Rational[-1, 2]}, {
       Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
         5^Rational[1, 2]), 
        Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
       Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
         5^Rational[1, 2]), Rational[
        1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
       Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
         5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
        Rational[-1, 2]}, {
       Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
         5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
        Rational[-1, 2]}, {
       Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
         5^Rational[1, 2]), 
        Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
       Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
         5^Rational[1, 2]), 
        Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
       Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
         5^Rational[1, 2]), 
        Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
       Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
         5^Rational[1, 2]), 
        Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
       Rational[1, 2] (
         Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
           5^Rational[1, 2]) + 
         Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
           5^Rational[1, 2])), 
        Rational[1, 2] (Rational[-1, 2] + 
         Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
           Rational[1, 2]), -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
       Rational[1, 2] (
         Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
           5^Rational[1, 2]) + 
         Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
           5^Rational[1, 2])), 
        Rational[1, 2] (Rational[1, 2] + 
         Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
           Rational[1, 2]), (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
       Rational[1, 2] ((2/(5 - 5^Rational[1, 2]))^Rational[1, 2] + 
         Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
           5^Rational[1, 2])), 
        Rational[-1, 4] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], 0}, {
       Rational[1, 2] (-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2] + 
         Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
           5^Rational[1, 2])), 
        Rational[1, 4] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], 0}, {
       Rational[-1, 4] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
         5^Rational[1, 2]), Rational[-1, 4], 
        Rational[
         1, 2] ((-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2] + (10 - 2 
           5^Rational[1, 2])^Rational[-1, 2])}, {
       Rational[1, 4] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
         5^Rational[1, 2]), Rational[1, 4], 
        Rational[1, 2] (
         5 (50 - 10 5^Rational[1, 2])^Rational[-1, 2] - (10 - 2 
          5^Rational[1, 2])^Rational[-1, 2])}}, {{
       0, 0, -0.9510565162951536}, {
       0, 0, 0.9510565162951536}, {-0.85065080835204, 
        0, -0.42532540417601994`}, {
       0.85065080835204, 0, 0.42532540417601994`}, {
       0.6881909602355868, -0.5, -0.42532540417601994`}, {0.6881909602355868, 
       0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
       0.42532540417601994`}, {-0.6881909602355868, 0.5, 
       0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
       0.8090169943749475, -0.42532540417601994`}, {
       0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
       0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}, {
       0.21266270208801, 
       0.15450849718747373`, -0.42532540417601994`}, {-0.21266270208801, \
-0.15450849718747373`, 0.42532540417601994`}, {
       0.29389262614623657`, -0.4045084971874737, 0}, {-0.29389262614623657`, 
        0.4045084971874737, 
        0}, {-0.3440954801177934, -0.25, -0.26286555605956685`}, {
       0.3440954801177934, 0.25, 0.26286555605956685`}}], 
     Polygon3DBox[{{5, 13, 14, 11}, {10, 13, 14, 8}, {4, 15, 16, 12}, {9, 15, 
      16, 3}, {1, 17, 18, 6}, {7, 17, 18, 2}}]]}},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{380.56851990496676`, 383.8097024597824},
  Lighting->None,
  ViewPoint->{-1.0402002579880028`, -3.13312081036725, -0.742655647608876},
  ViewVertical->{-0.5269025741440713, -0.7388918538468677, 
   0.618738819496706}]], "Output",
 CellChangeTimes->{3.539184529984524*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Los lados menores son lados del icosaedro, de longitud ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", mientras que los lados mayores son diagonales de pent\[AAcute]gonos de \
lado ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego tienen longitud ",
 StyleBox["\[CapitalPhi]",
  FontSize->18],
 StyleBox["l.",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " As\[IAcute] pues, los rect\[AAcute]ngulos tienen proporci\[OAcute]n \
\[AAcute]urea. Es claro que los v\[EAcute]rtices de uno de los \
rect\[AAcute]ngulos equidistan de dos v\[EAcute]rtices adyacentes de otro, \
luego un rect\[AAcute]ngulo est\[AAcute] contenido en el plano perpendicular \
a un cierto lado de cualquiera de los otros rect\[AAcute]ngulos, luego los \
tres rect\[AAcute]ngulos est\[AAcute]n sobre planos perpendiculares dos a \
dos. A partir de aqu\[IAcute] es f\[AAcute]cil deducir un sencillo conjunto \
de coordenadas cartesianas para los v\[EAcute]rtices de un icosaedro respecto \
de un sistema de referencia adecuado. Lo dejamos a cargo del lector."
}], "Text",
 CellChangeTimes->{{3.539112204734005*^9, 3.539112204735856*^9}, {
  3.539184557941259*^9, 3.5391845579446*^9}, {3.539184595101983*^9, 
  3.539184654852062*^9}, {3.539184843217119*^9, 3.539184942551023*^9}, {
  3.539184982951618*^9, 3.539184996271764*^9}, {3.539190679799118*^9, 
  3.539190731311976*^9}, {3.541011020171482*^9, 3.541011020174624*^9}}],

Cell[TextData[{
 "Ahora es inmediato que el radio del icosaedro (que es la mitad de la \
diagonal de cualquiera de los rect\[AAcute]ngulos de lados ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["\[CapitalPhi]",
  FontSize->18],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "), es "
}], "Text",
 CellChangeTimes->{{3.5391907813179407`*^9, 3.53919082958959*^9}, {
   3.539201849232995*^9, 3.5392018529102993`*^9}, 3.5411783623247147`*^9}],

Cell[BoxData[
 FormBox[
  RowBox[{
   StyleBox["R",
    FontFamily->"Times",
    FontSize->18], 
   StyleBox[" ",
    FontFamily->"Times"], 
   StyleBox["=",
    FontFamily->"Times New Roman",
    FontSize->18], 
   StyleBox[" ",
    FontFamily->"Times"], 
   RowBox[{
    StyleBox[
     RowBox[{
      FormBox[
       FractionBox[
        SqrtBox[
         RowBox[{"\[CapitalPhi]", "+", "2"}]], "2"],
       TraditionalForm], 
      StyleBox["l",
       FontSize->18,
       FontSlant->"Italic"]}],
     FontFamily->"Times"], 
    StyleBox[" ",
     FontFamily->"Times New Roman",
     FontSize->18], 
    StyleBox["=",
     FontFamily->"Times New Roman",
     FontSize->18], 
    StyleBox[" ",
     FontFamily->"Times New Roman",
     FontSize->18], 
    RowBox[{
     StyleBox[
      FormBox[
       RowBox[{
        FractionBox["1", "2"], 
        SqrtBox[
         FractionBox[
          RowBox[{"5", "+", 
           SqrtBox["5"]}], "2"]]}],
       TraditionalForm],
      FontFamily->"Times"], 
     StyleBox["l",
      FontFamily->"Times",
      FontSize->18,
      FontSlant->"Italic"], 
     StyleBox[" ",
      FontFamily->"Times New Roman",
      FontSize->18]}]}]}], TraditionalForm]], "Equation",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.53684881230794*^9, 3.5368488421084557`*^9}, {
   3.536848914413434*^9, 3.536848966373749*^9}, {3.536849024033951*^9, 
   3.536849030726388*^9}, {3.536849261476451*^9, 3.536849267385294*^9}, {
   3.536849350730043*^9, 3.536849399339061*^9}, {3.536849615568947*^9, 
   3.5368496684572372`*^9}, {3.536849748665278*^9, 3.5368497486731567`*^9}, {
   3.536849780152142*^9, 3.536849792454063*^9}, 3.5368506738925877`*^9, {
   3.536851382476898*^9, 3.536851385232678*^9}, 3.536852161095171*^9, {
   3.539202038300458*^9, 3.539202091805221*^9}, 3.539293300299508*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Para calcular el inradio usamos, como de costumbre, que el inradio ",
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", el radio y el radio de una cara forman un tri\[AAcute]ngulo \
rect\[AAcute]ngulo, con lo que"
}], "Text",
 CellChangeTimes->{{3.539184558058133*^9, 3.539184558060066*^9}, {
  3.539190890286951*^9, 3.5391909407093563`*^9}}],

Cell[BoxData[
 FormBox[
  StyleBox[
   RowBox[{
    StyleBox[
     SuperscriptBox["r", "2"],
     FontSize->18], 
    StyleBox["=",
     FontSize->18], 
    StyleBox[" ",
     FontSize->18], 
    RowBox[{
     RowBox[{
      RowBox[{
       StyleBox["(",
        FontSize->18], 
       StyleBox[
        RowBox[{
         FractionBox[
          RowBox[{"5", "+", 
           SqrtBox["5"]}], "8"], "-", 
         FractionBox["1", "3"]}],
        FontSize->14], 
       StyleBox[")",
        FontSize->18]}], 
      StyleBox[
       SuperscriptBox["l", "2"],
       FontSize->18]}], 
     StyleBox["=",
      FontSize->18], 
     RowBox[{
      RowBox[{
       StyleBox[
        FractionBox[
         RowBox[{"7", "+", 
          RowBox[{"3", 
           SqrtBox["5"]}]}], "24"],
        FontSize->14], 
       StyleBox[
        RowBox[{
         SuperscriptBox["l", "2"], " ", "\[DoubleLongRightArrow]", " ", "r"}],
        
        FontSize->18]}], 
      StyleBox["=",
       FontSize->18], 
      RowBox[{
       StyleBox[
        RowBox[{
         SqrtBox[
          FractionBox[
           RowBox[{
            StyleBox["7",
             FontSize->14,
             FontSlant->"Plain"], 
            StyleBox["+",
             FontSize->14], 
            RowBox[{
             StyleBox["3",
              FontSize->14,
              FontSlant->"Plain"], 
             SqrtBox[
              StyleBox["5",
               FontSize->14,
               FontSlant->"Plain"]]}]}], 
           StyleBox["24",
            FontSize->14]]], "l"}],
        FontSize->18], 
       StyleBox[" ",
        FontSize->18], 
       StyleBox["=",
        FontSize->18], 
       StyleBox[" ",
        FontSize->18], 
       RowBox[{
        FractionBox[
         SuperscriptBox["\[CapitalPhi]", "2"], 
         RowBox[{"2", 
          SqrtBox["3"]}]], 
        StyleBox[
         RowBox[{
          SuperscriptBox[
           StyleBox["l",
            FontFamily->"Times",
            FontSize->18], "2"], "."}],
         FontSize->18]}]}]}]}]}],
   FontFamily->"Times"], TraditionalForm]], "Equation",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.5368500144644127`*^9, 3.5368501012771187`*^9}, {
   3.536850687993307*^9, 3.536850842993433*^9}, {3.5368513882027807`*^9, 
   3.5368513901780577`*^9}, 3.536852161095366*^9, {3.539202111150898*^9, 
   3.539202166141337*^9}, {3.539375457198701*^9, 3.539375497678164*^9}, {
   3.539375558071203*^9, 3.539375560348523*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Ahora es f\[AAcute]cil calcular el volumen del icosaedro como suma de los \
vol\[UAcute]menes de las ",
 StyleBox["20",
  FontFamily->"Times"],
 " pir\[AAcute]mides pentagonales que lo componen, cuya altura es el inradio. \
El \[AAcute]ngulo di\[EAcute]drico se obtiene observando que los \
v\[EAcute]rtices de dos caras contiguas opuestos al lado com\[UAcute]n est\
\[AAcute]n a una distancia ",
 StyleBox["\[CapitalPhi]",
  FontSize->18],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego el \[AAcute]ngulo di\[EAcute]drico aparece en un tri\[AAcute]ngulo \
is\[OAcute]sceles cuyo lado opuesto tiene longitud ",
 StyleBox["\[CapitalPhi]",
  FontSize->18],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y en el que los lados contiguos miden ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox["3"], "2"], TraditionalForm]]],
 StyleBox["\[CapitalPhi]",
  FontSize->18],
 StyleBox["l.",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " Los resultados para un icosaedro de lado unitario son:"
}], "Text",
 CellChangeTimes->{{3.539184558330134*^9, 3.539184558332119*^9}, {
  3.539191097993598*^9, 3.539191156911377*^9}, {3.539191205834765*^9, 
  3.5391913351701593`*^9}, {3.539192561239456*^9, 3.53919257607966*^9}, {
  3.539375643405869*^9, 3.539375644657909*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Radio\"\>", "\<\"Inradio\"\>", "\<\"Volumen\"\>", "\<\"\
\[CapitalAAcute]rea\"\>", "\<\"\[CapitalAAcute]ngulo di\[EAcute]drico\"\>"},
    {
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(1\\), \
\\(2\\)]\\)\\!\\(\\*SqrtBox[FractionBox[\\(5 + \\*SqrtBox[\\(5\\)]\\), \
\\(2\\)]]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[SuperscriptBox[\\(\[CapitalPhi]\\), \
\\(2\\)], \\(2 \\*SqrtBox[\\(3\\)]\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(5 \\*SuperscriptBox[\\(\
\[CapitalPhi]\\), \\(2\\)]\\), \\(6\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], 
     StyleBox["\<\"5\\!\\(\\*SqrtBox[\\(3\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], 
     StyleBox["\<\"arccos[-\\!\\(\\*FractionBox[SqrtBox[\\(5\\)], \
\\(3\\)]\\)]\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14]}
   },
   AutoDelete->False,
   GridBoxDividers->{
    "Columns" -> {False, True, True, True, True}, "Rows" -> {False, True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.5391913496287518`*^9, 3.539191513971236*^9, {3.539202257260804*^9, 
   3.539202278282761*^9}, 3.539202343764638*^9, 3.539375775563814*^9},
 TextAlignment->Center],

Cell[TextData[StyleBox["EL DODECAEDRO",
 FontSize->18,
 FontColor->RGBColor[0, 0, 1]]], "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellMargins->{{100, 100}, {16, 18}},
 CellChangeTimes->{{3.538515429422391*^9, 3.538515429424019*^9}, {
  3.538517083097238*^9, 3.538517086760803*^9}, {3.538772137916774*^9, 
  3.5387721418334713`*^9}, {3.5389433492789*^9, 3.538943354615024*^9}, {
  3.538944083654379*^9, 3.538944088838513*^9}, {3.5391065561537533`*^9, 
  3.5391065641036177`*^9}, {3.539110603199396*^9, 3.5391106061050386`*^9}, {
  3.539114155036748*^9, 3.5391141567297077`*^9}, {3.5391190486065063`*^9, 
  3.5391190499503193`*^9}, {3.539191580022891*^9, 3.539191581987825*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "A partir del icosaedro podemos formar su poliedro dual, el ",
 StyleBox["dodecaedro,",
  FontSlant->"Italic"],
 " que tendr\[AAcute] ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 12",
  FontFamily->"Times"],
 " caras pentagonales, ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 30",
  FontFamily->"Times"],
 " aristas y ",
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 20",
  FontFamily->"Times"],
 " v\[EAcute]rtices, a cada uno de los cuales llegar\[AAcute]n ",
 StyleBox["3",
  FontFamily->"Times"],
 " aristas (y por ser el dual de un poliedro regular es tambi\[EAcute]n \
regular)."
}], "Text",
 CellChangeTimes->{{3.539191723111977*^9, 3.53919177199851*^9}, {
  3.5410112985561733`*^9, 3.541011321267098*^9}, {3.541178377914958*^9, 
  3.541178383520294*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     Graphics3DBox[{
       {GrayLevel[0.7], Opacity[0.2], 
        GeometricTransformation3DBox[
         GraphicsComplex3DBox[
          NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
            0, 0, 5 (50 - 10 5^Rational[1, 2])^
              Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
             0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
              Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
             Rational[-1, 2]}, {(
              Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
              5^Rational[1, 2]), 
             Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
              Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
              5^Rational[1, 2]), Rational[
             1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
              Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
              5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
             Rational[-1, 2]}, {(
              Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
              5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
             Rational[-1, 2]}, {(
              Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
              5^Rational[1, 2]), 
             Rational[-1, 
               2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
              Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
              Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
              5^Rational[1, 2]), 
             Rational[
              1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
              Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
              Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
              5^Rational[1, 2]), 
             Rational[-1, 
               2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
              Rational[1, 2], (10 - 2 5^Rational[1, 2])^
             Rational[-1, 2]}, {(
              Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
              5^Rational[1, 2]), 
             Rational[
              1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
              Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
            0, 0, -0.9510565162951536}, {
            0, 0, 0.9510565162951536}, {-0.85065080835204, 
             0, -0.42532540417601994`}, {
            0.85065080835204, 0, 0.42532540417601994`}, {
            0.6881909602355868, -0.5, -0.42532540417601994`}, {
            0.6881909602355868, 
            0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
            0.42532540417601994`}, {-0.6881909602355868, 0.5, 
            0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
            0.8090169943749475, -0.42532540417601994`}, {
            0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
            0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
          Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 
           12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 
           10, 8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 
           9}, {6, 4, 5}, {10, 12, 6}, {3, 8, 10}, {9, 7, 3}}]], 
         NCache[{{{4 (3^Rational[1, 2]/(3 + 5^Rational[1, 2])), 0, 0}, {
            0, 4 (3^Rational[1, 2]/(3 + 5^Rational[1, 2])), 0}, {
            0, 0, 4 (3^Rational[1, 2]/(3 + 5^Rational[1, 2]))}}, {0, 0, 
           0}}, {{{1.323169076499215, 0, 0}, {0, 1.323169076499215, 0}, {
            0, 0, 1.323169076499215}}, {0, 0, 0}}]]}, 
       {GrayLevel[0.7], Opacity[0.9], 
        GeometricTransformation3DBox[
         GraphicsComplex3DBox[
          NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
             1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
             Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
            Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
             Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 3, 0]}, {
            Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
             Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
              Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
              Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 3, 0]}, {
            Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
             Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
              Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
            Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
             Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
              Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
            Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
            Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[1, 2], Root[
             1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
              Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[-1, 2], (Rational[5, 8] + 
              Rational[11, 8] 5^Rational[-1, 2])^
             Rational[1, 2]}, {(Rational[1, 4] + 
              Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
             1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
             Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
             Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
            Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
             Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 2, 0]}, {
            Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
             Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 2, 0]}, {
            Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
             0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
             Rational[1, 2]}, {
            Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
             Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
             1 - 100 #^2 + 80 #^4& , 1, 0]}, {
            Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
             Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
             1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
              Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
              Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
             0.2628655560595668}, {
            1.3763819204711736`, 
             0, -0.2628655560595668}, {-0.42532540417601994`, \
-1.3090169943749475`, 0.2628655560595668}, {-0.42532540417601994`, 
            1.3090169943749475`, 0.2628655560595668}, {
            1.1135163644116066`, -0.8090169943749475, 0.2628655560595668}, {
            1.1135163644116066`, 0.8090169943749475, 
            0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
            1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
            1.1135163644116066`}, {-0.6881909602355868, -0.5, \
-1.1135163644116068`}, {-0.6881909602355868, 0.5, -1.1135163644116068`}, {
            0.6881909602355868, -0.5, 1.1135163644116066`}, {
            0.6881909602355868, 0.5, 1.1135163644116066`}, {
            0.85065080835204, 
             0, -1.1135163644116068`}, {-1.1135163644116068`, \
-0.8090169943749475, -0.2628655560595668}, {-1.1135163644116068`, 
            0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
             1.1135163644116066`}, {
            0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
            0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
            0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, \
{0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], 
          Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 
           19}, {11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2,
            5, 19, 17, 13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19,
            3, 14, 9}, {3, 7, 16, 1, 14}, {16, 8, 4, 15, 1}}]], 
         NCache[{{{4 (3^Rational[-1, 2]/(1 + 5^Rational[1, 2])), 0, 0}, {
            0, 4 (3^Rational[-1, 2]/(1 + 5^Rational[1, 2])), 0}, {
            0, 0, 4 (3^Rational[-1, 2]/(1 + 5^Rational[1, 2]))}}, {0, 0, 
           0}}, {{{0.7136441795461799, 0, 0}, {0, 0.7136441795461799, 0}, {
            0, 0, 0.7136441795461799}}, {0, 0, 0}}]]}},
      AutomaticImageSize->True,
      Boxed->False,
      ImageSize->{226.0118687231965, 213.14867826617356`},
      Lighting->"Neutral",
      ViewPoint->{2.2213747992793604`, -2.5148054931257042`, 
       0.43731834271085057`},
      ViewVertical->{0.40594269568574853`, -0.3791898740759834, 
       0.8741422351939434}], {193.5, -189.}, ImageScaled[{0.5, 0.5}], {360., 360.},
     
     ContentSelectable->True], InsetBox[
     Graphics3DBox[
      {GrayLevel[0.7], Opacity[0.9], 
       GeometricTransformation3DBox[
        GraphicsComplex3DBox[
         NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
            1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
            Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
           Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
            Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
            1 - 20 #^2 + 80 #^4& , 3, 0]}, {
           Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
            Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
            1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
             Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
            Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
            1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
             Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
            Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
            1 - 20 #^2 + 80 #^4& , 3, 0]}, {
           Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
            Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
             Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
           Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
            Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
             Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
           Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
            Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
           Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
            1, 2], Root[
            1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
             Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
            Rational[-1, 2], (Rational[5, 8] + 
             Rational[11, 8] 5^Rational[-1, 2])^
            Rational[1, 2]}, {(Rational[1, 4] + 
             Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
            1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
            Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
            Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
           Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
            Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
            1 - 20 #^2 + 80 #^4& , 2, 0]}, {
           Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
            Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
            1 - 20 #^2 + 80 #^4& , 2, 0]}, {
           Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
            0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
            Rational[1, 2]}, {
           Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
            Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
            1 - 100 #^2 + 80 #^4& , 1, 0]}, {
           Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
            Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
            1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
             Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
            Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
            1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
             Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
            Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
            1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
            0.2628655560595668}, {
           1.3763819204711736`, 
            0, -0.2628655560595668}, {-0.42532540417601994`, \
-1.3090169943749475`, 0.2628655560595668}, {-0.42532540417601994`, 
           1.3090169943749475`, 0.2628655560595668}, {
           1.1135163644116066`, -0.8090169943749475, 0.2628655560595668}, {
           1.1135163644116066`, 0.8090169943749475, 
           0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
           1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
           1.1135163644116066`}, {-0.6881909602355868, -0.5, \
-1.1135163644116068`}, {-0.6881909602355868, 0.5, -1.1135163644116068`}, {
           0.6881909602355868, -0.5, 1.1135163644116066`}, {
           0.6881909602355868, 0.5, 1.1135163644116066`}, {
           0.85065080835204, 
            0, -1.1135163644116068`}, {-1.1135163644116068`, \
-0.8090169943749475, -0.2628655560595668}, {-1.1135163644116068`, 
           0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
            1.1135163644116066`}, {
           0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
           0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
           0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
           0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], 
         Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 
          19}, {11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 
          5, 19, 17, 13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 
          3, 14, 9}, {3, 7, 16, 1, 14}, {16, 8, 4, 15, 1}}]], 
        NCache[{{{2 (10/(25 + 11 5^Rational[1, 2]))^Rational[1, 2], 0, 0}, {
           0, 2 (10/(25 + 11 5^Rational[1, 2]))^Rational[1, 2], 0}, {
           0, 0, 2 (10/(25 + 11 5^Rational[1, 2]))^Rational[1, 2]}}, {0, 0, 
          0}}, {{{0.8980559531591706, 0, 0}, {0, 0.8980559531591706, 0}, {
           0, 0, 0.8980559531591706}}, {0, 0, 0}}]]},
      AutomaticImageSize->True,
      Boxed->False,
      ImageSize->{210.30012727082394`, 190.61569006949256`},
      Lighting->"Neutral",
      ViewPoint->{1.4086743235590053`, -2.7804442025673626`, 
       1.3171054196817813`},
      ViewVertical->{0.1292583965189829, -0.20302066529241714`, 
       1.2022378581526343`}], {580.5, -189.}, ImageScaled[{0.5, 0.5}], {360., 360.},
     
     ContentSelectable->True], InsetBox[
     Graphics3DBox[{
       {GrayLevel[0.7], Opacity[0.2], 
        GeometricTransformation3DBox[
         GraphicsComplex3DBox[
          NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
             1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
             Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
            Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
             Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 3, 0]}, {
            Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
             Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
              Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
              Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 3, 0]}, {
            Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
             Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
              Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
            Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
             Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
              Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
            Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
            Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[1, 2], Root[
             1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
              Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[-1, 2], (Rational[5, 8] + 
              Rational[11, 8] 5^Rational[-1, 2])^
             Rational[1, 2]}, {(Rational[1, 4] + 
              Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
             1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
             Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
             Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
            Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
             Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 2, 0]}, {
            Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
             Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 2, 0]}, {
            Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
             0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
             Rational[1, 2]}, {
            Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
             Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
             1 - 100 #^2 + 80 #^4& , 1, 0]}, {
            Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
             Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
             1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
              Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
              Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
             Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
             1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
             0.2628655560595668}, {
            1.3763819204711736`, 
             0, -0.2628655560595668}, {-0.42532540417601994`, \
-1.3090169943749475`, 0.2628655560595668}, {-0.42532540417601994`, 
            1.3090169943749475`, 0.2628655560595668}, {
            1.1135163644116066`, -0.8090169943749475, 0.2628655560595668}, {
            1.1135163644116066`, 0.8090169943749475, 
            0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
            1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
            1.1135163644116066`}, {-0.6881909602355868, -0.5, \
-1.1135163644116068`}, {-0.6881909602355868, 0.5, -1.1135163644116068`}, {
            0.6881909602355868, -0.5, 1.1135163644116066`}, {
            0.6881909602355868, 0.5, 1.1135163644116066`}, {
            0.85065080835204, 
             0, -1.1135163644116068`}, {-1.1135163644116068`, \
-0.8090169943749475, -0.2628655560595668}, {-1.1135163644116068`, 
            0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
             1.1135163644116066`}, {
            0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
            0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
            0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, \
{0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], 
          Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 
           19}, {11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2,
            5, 19, 17, 13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19,
            3, 14, 9}, {3, 7, 16, 1, 14}, {16, 8, 4, 15, 1}}]], 
         NCache[{{{2 (10/(25 + 11 5^Rational[1, 2]))^Rational[1, 2], 0, 0}, {
            0, 2 (10/(25 + 11 5^Rational[1, 2]))^Rational[1, 2], 0}, {
            0, 0, 2 (10/(25 + 11 5^Rational[1, 2]))^Rational[1, 2]}}, {0, 0, 
           0}}, {{{0.8980559531591706, 0, 0}, {0, 0.8980559531591706, 0}, {
            0, 0, 0.8980559531591706}}, {0, 0, 0}}]]}, 
       {GrayLevel[0.7], Opacity[0.9], 
        GeometricTransformation3DBox[
         GraphicsComplex3DBox[
          NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
            0, 0, 
             5 (50 - 10 5^Rational[1, 2])^
              Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
             0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
              Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
             Rational[-1, 2]}, {(
              Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
              5^Rational[1, 2]), 
             Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
              Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
              5^Rational[1, 2]), Rational[
             1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
              Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
              5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
             Rational[-1, 2]}, {(
              Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
              5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
             Rational[-1, 2]}, {(
              Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
              5^Rational[1, 2]), 
             Rational[-1, 
               2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
              Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
              Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
              5^Rational[1, 2]), 
             Rational[
              1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
              Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
              Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
              5^Rational[1, 2]), 
             Rational[-1, 
               2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
              Rational[1, 2], (10 - 2 5^Rational[1, 2])^
             Rational[-1, 2]}, {(
              Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
              5^Rational[1, 2]), 
             Rational[
              1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
              Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
            0, 0, -0.9510565162951536}, {
            0, 0, 0.9510565162951536}, {-0.85065080835204, 
             0, -0.42532540417601994`}, {
            0.85065080835204, 0, 0.42532540417601994`}, {
            0.6881909602355868, -0.5, -0.42532540417601994`}, {
            0.6881909602355868, 
            0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
            0.42532540417601994`}, {-0.6881909602355868, 0.5, 
            0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
            0.8090169943749475, -0.42532540417601994`}, {
            0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
            0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
          Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 
           12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 
           10, 8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 
           9}, {6, 4, 5}, {10, 12, 6}, {3, 8, 10}, {9, 7, 3}}]], 
         NCache[{{{2 (2/(5 + 5^Rational[1, 2]))^Rational[1, 2], 0, 0}, {
            0, 2 (2/(5 + 5^Rational[1, 2]))^Rational[1, 2], 0}, {
            0, 0, 2 (2/(5 + 5^Rational[1, 2]))^Rational[1, 2]}}, {0, 0, 
           0}}, {{{1.0514622242382672`, 0, 0}, {0, 1.0514622242382672`, 0}, {
            0, 0, 1.0514622242382672`}}, {0, 0, 0}}]]}},
      AutomaticImageSize->True,
      Boxed->False,
      ImageSize->{220.397263110234, 214.76090855533656`},
      Lighting->"Neutral",
      ViewPoint->{1.3982629794104264`, -2.7121073682072097`, 
       1.462646322159407},
      ViewVertical->{0.08141246224565062, -0.1739135778645207, 
       1.214882104617065}], {967.5, -189.}, ImageScaled[{0.5, 0.5}], {360., 360.},
     
     ContentSelectable->True]}, {}},
  ContentSelectable->True,
  ImageSize->{717., Automatic},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.539191831128035*^9, {3.539191929659772*^9, 3.539191943557159*^9}, {
   3.539191976857437*^9, 3.539192016073489*^9}, {3.5391920482513723`*^9, 
   3.539192062452368*^9}},
 TextAlignment->Center],

Cell["\<\
Para calcular el radio del dodecaedro observamos que contiene un cubo del \
mismo radio:\
\>", "Text",
 CellChangeTimes->{{3.539191723229094*^9, 3.539191723230791*^9}, {
  3.539192074220779*^9, 3.539192095289888*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.2], Glow[
     GrayLevel[0.5]], 
    GraphicsComplex3DBox[
     NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
        Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
       Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
       Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
        1, 2], Root[
        1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
         Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[-1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[
        1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 2, 0]}, {
       Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 2, 0]}, {
       Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
        0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]}, {
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 100 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
         Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
         Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
        0.2628655560595668}, {
       1.3763819204711736`, 
        0, -0.2628655560595668}, {-0.42532540417601994`, -1.3090169943749475`,
        0.2628655560595668}, {-0.42532540417601994`, 1.3090169943749475`, 
       0.2628655560595668}, {1.1135163644116066`, -0.8090169943749475, 
       0.2628655560595668}, {1.1135163644116066`, 0.8090169943749475, 
       0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
       1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
       1.1135163644116066`}, {-0.6881909602355868, -0.5, \
-1.1135163644116068`}, {-0.6881909602355868, 0.5, -1.1135163644116068`}, {
       0.6881909602355868, -0.5, 1.1135163644116066`}, {0.6881909602355868, 
       0.5, 1.1135163644116066`}, {
       0.85065080835204, 
        0, -1.1135163644116068`}, {-1.1135163644116068`, -0.8090169943749475, \
-0.2628655560595668}, {-1.1135163644116068`, 
       0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
        1.1135163644116066`}, {
       0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
       0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
       0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
       0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], 
     Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 19}, {
      11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 5, 19, 17,
       13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 3, 14, 9}, {3, 
      7, 16, 1, 14}, {16, 8, 4, 15, 1}}]]}, 
   {Opacity[0.7], Glow[
     GrayLevel[0.5]], 
    GraphicsComplex3DBox[
     NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
        Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
       Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
       Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
        1, 2], Root[
        1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
         Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[-1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[
        1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 2, 0]}, {
       Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 2, 0]}, {
       Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
        0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]}, {
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 100 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
         Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
         Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
        0.2628655560595668}, {
       1.3763819204711736`, 
        0, -0.2628655560595668}, {-0.42532540417601994`, -1.3090169943749475`,
        0.2628655560595668}, {-0.42532540417601994`, 1.3090169943749475`, 
       0.2628655560595668}, {1.1135163644116066`, -0.8090169943749475, 
       0.2628655560595668}, {1.1135163644116066`, 0.8090169943749475, 
       0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
       1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
       1.1135163644116066`}, {-0.6881909602355868, -0.5, \
-1.1135163644116068`}, {-0.6881909602355868, 0.5, -1.1135163644116068`}, {
       0.6881909602355868, -0.5, 1.1135163644116066`}, {0.6881909602355868, 
       0.5, 1.1135163644116066`}, {
       0.85065080835204, 
        0, -1.1135163644116068`}, {-1.1135163644116068`, -0.8090169943749475, \
-0.2628655560595668}, {-1.1135163644116068`, 
       0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
        1.1135163644116066`}, {
       0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
       0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
       0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
       0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], 
     Polygon3DBox[{{3, 17, 10, 1}, {1, 3, 11, 8}, {3, 11, 2, 17}, {2, 17, 10, 
      20}, {11, 2, 20, 8}, {1, 8, 20, 10}}]]}},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{358.1093731422096, 348.56722222927544`},
  Lighting->None,
  ViewPoint->{1.38322538127236, -2.524582415316009, 1.7785306218564583`},
  ViewVertical->{0.05048159544403092, -0.06554416732815052, 
   1.2320850096350144`}]], "Output",
 CellChangeTimes->{3.5391921757766447`*^9},
 TextAlignment->Center],

Cell[TextData[{
 "El lado del cubo es ",
 StyleBox["\[CapitalPhi]",
  FontSize->18],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego, seg\[UAcute]n los datos que hemos obtenido para el cubo, su radio \
es ",
 StyleBox["R",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = ",
  FontFamily->"Times New Roman",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox["3"], "2"], TraditionalForm]],
  FontSize->18],
 StyleBox["\[CapitalPhi]",
  FontSize->18],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontSize->18,
  FontSlant->"Italic"],
 " Usando una vez m\[AAcute]s que el inradio, el circunradio y el radio de \
una cara forman un tri\[AAcute]ngulo rect\[AAcute]ngulo, obtenemos que"
}], "Text",
 CellChangeTimes->{{3.5391921972928867`*^9, 3.5391922327054873`*^9}, {
  3.53919239271242*^9, 3.539192412085352*^9}}],

Cell[TextData[Cell[BoxData[
 FormBox[
  StyleBox[
   RowBox[{
    StyleBox[
     SuperscriptBox["r", "2"],
     FontFamily->"Times"], " ", "=", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       FractionBox["3", "4"], 
       SuperscriptBox["\[CapitalPhi]", "2"], 
       StyleBox[
        SuperscriptBox["l", "2"],
        FontFamily->"Times"]}], "-", 
      RowBox[{
       FormBox[
        FractionBox[
         RowBox[{"5", "+", 
          SqrtBox["5"]}], "10"],
        TraditionalForm], 
       StyleBox[
        SuperscriptBox["l", "2"],
        FontFamily->"Times"]}]}], " ", "=", " ", 
     RowBox[{
      RowBox[{
       FractionBox[
        RowBox[{"25", "+", 
         RowBox[{"11", 
          SqrtBox["5"]}]}], "40"], 
       RowBox[{
        StyleBox[
         SuperscriptBox["l", "2"],
         FontFamily->"Times"], "  ", "\[DoubleLongRightArrow]", " ", 
        StyleBox["r",
         FontFamily->"Times"]}]}], "=", " ", 
      RowBox[{
       SqrtBox[
        RowBox[{" ", 
         FractionBox[
          RowBox[{"25", "+", 
           RowBox[{"11", 
            SqrtBox["5"]}]}], "40"]}]], 
       RowBox[{
        StyleBox["l",
         FontFamily->"Times"], "."}]}]}]}]}],
   FontSize->18], TraditionalForm]],
 CellChangeTimes->{{3.5368691009174232`*^9, 3.536869283625966*^9}, {
   3.536869359297336*^9, 3.5368695360240593`*^9}, 3.5368696814114103`*^9},
 FontFamily->"Times",
 FontSize->18]], "Text",
 CellChangeTimes->{{3.539112204878004*^9, 3.539112204879677*^9}, {
   3.539192173043604*^9, 3.539192173046959*^9}, 3.539192417844618*^9, {
   3.5392034697040777`*^9, 3.539203534111835*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Ahora ya es f\[AAcute]cil calcular la superficie y el volumen del \
dodecaedro (como suma de los vol\[UAcute]menes de las doce pir\[AAcute]mides \
pentagonales que lo forman). Para ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" =1",
  FontFamily->"Times"],
 " los valores son:"
}], "Text",
 CellChangeTimes->{{3.5391921731780863`*^9, 3.539192173179811*^9}, {
  3.539192522480894*^9, 3.539192550862501*^9}, {3.5391925874658117`*^9, 
  3.539192591975116*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Radio\"\>", "\<\"Inradio\"\>", "\<\"Volumen\"\>", "\<\"\
\[CapitalAAcute]rea\"\>", "\<\"\[CapitalAAcute]ngulo di\[EAcute]drico\"\>"},
    {
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(\\*SqrtBox[\\(3\\)] \
\[CapitalPhi]\\), \\(2\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*SqrtBox[FractionBox[\\(25 + 11 \
\\*SqrtBox[\\(5\\)]\\), \\(40\\)]]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(15 + 7 \\*SqrtBox[\\(5\\)]\\), \
\\(4\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"3\\!\\(\\*SqrtBox[\\(25 + 10 \
\\*SqrtBox[\\(5\\)]\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], 
     StyleBox["\<\"arccos[-\\!\\(\\*FractionBox[SqrtBox[\\(5\\)], \
\\(5\\)]\\)]\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18]}
   },
   AutoDelete->False,
   GridBoxDividers->{
    "Columns" -> {False, True, True, True, True}, "Rows" -> {False, True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.539204363178063*^9, 3.539206010600774*^9, {3.5393743807523947`*^9, 
   3.5393744068970003`*^9}},
 TextAlignment->Center],

Cell["\<\
Para calcular el \[AAcute]ngulo di\[EAcute]drico razonamos sobre la figura \
siguiente:\
\>", "Text",
 CellChangeTimes->{{3.5391921733221273`*^9, 3.539192173323855*^9}, {
  3.539192810996161*^9, 3.5391928193936577`*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.3], Glow[
     GrayLevel[0.5]], 
    GraphicsComplex3DBox[
     NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
        Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
       Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
       Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
        1, 2], Root[
        1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
         Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[-1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[
        1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 2, 0]}, {
       Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 2, 0]}, {
       Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
        0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]}, {
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 100 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
         Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
         Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
        0.2628655560595668}, {
       1.3763819204711736`, 
        0, -0.2628655560595668}, {-0.42532540417601994`, -1.3090169943749475`,
        0.2628655560595668}, {-0.42532540417601994`, 1.3090169943749475`, 
       0.2628655560595668}, {1.1135163644116066`, -0.8090169943749475, 
       0.2628655560595668}, {1.1135163644116066`, 0.8090169943749475, 
       0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
       1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
       1.1135163644116066`}, {-0.6881909602355868, -0.5, \
-1.1135163644116068`}, {-0.6881909602355868, 0.5, -1.1135163644116068`}, {
       0.6881909602355868, -0.5, 1.1135163644116066`}, {0.6881909602355868, 
       0.5, 1.1135163644116066`}, {
       0.85065080835204, 
        0, -1.1135163644116068`}, {-1.1135163644116068`, -0.8090169943749475, \
-0.2628655560595668}, {-1.1135163644116068`, 
       0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
        1.1135163644116066`}, {
       0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
       0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
       0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
       0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], 
     Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 19}, {
      11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 5, 19, 17,
       13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 3, 14, 9}, {3, 
      7, 16, 1, 14}, {16, 8, 4, 15, 1}}]]}, 
   {Opacity[0.7], Glow[
     GrayLevel[0.5]], 
    GraphicsComplex3DBox[
     NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
        Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
       Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
       Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
        1, 2], Root[
        1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
         Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[-1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
        Rational[1, 2], Rational[
        1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
        Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 2, 0]}, {
       Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 2, 0]}, {
       Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
        0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
        Rational[1, 2]}, {
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 100 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
         Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
         Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
        Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
        0.2628655560595668}, {
       1.3763819204711736`, 
        0, -0.2628655560595668}, {-0.42532540417601994`, -1.3090169943749475`,
        0.2628655560595668}, {-0.42532540417601994`, 1.3090169943749475`, 
       0.2628655560595668}, {1.1135163644116066`, -0.8090169943749475, 
       0.2628655560595668}, {1.1135163644116066`, 0.8090169943749475, 
       0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
       1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
       1.1135163644116066`}, {-0.6881909602355868, -0.5, \
-1.1135163644116068`}, {-0.6881909602355868, 0.5, -1.1135163644116068`}, {
       0.6881909602355868, -0.5, 1.1135163644116066`}, {0.6881909602355868, 
       0.5, 1.1135163644116066`}, {
       0.85065080835204, 
        0, -1.1135163644116068`}, {-1.1135163644116068`, -0.8090169943749475, \
-0.2628655560595668}, {-1.1135163644116068`, 
       0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
        1.1135163644116066`}, {
       0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
       0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
       0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
       0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], 
     Polygon3DBox[{{20, 13, 19, 7, 8}, {7, 20, 18, 3}}]], 
    Line3DBox[
     NCache[{{Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 100 #^2 + 80 #^4& , 1, 0]}, {
       Rational[1, 2] (
         Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
         Root[1 - 20 #^2 + 80 #^4& , 3, 0]), 
        Rational[1, 2] (Rational[-1, 2] + 
         Rational[1, 4] (-1 - 5^Rational[1, 2])), Root[
        1 - 100 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
        Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 3, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 100 #^2 + 80 #^4& , 1, 0]}}, {{0.2628655560595668, 
      0.8090169943749475, -1.1135163644116068`}, {-0.21266270208801, \
-0.6545084971874737, -1.1135163644116068`}, {-0.42532540417601994`, \
-1.3090169943749475`, 0.2628655560595668}, {0.2628655560595668, 
      0.8090169943749475, -1.1135163644116068`}}]]}, Text3DBox[
    FormBox["\<\"A\"\>", StandardForm], 
    NCache[{(Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
      Rational[1, 2], 1.3744678440936948`, -0.27600883386254516`}, {
     0.42532540417601994`, 1.3744678440936948`, -0.27600883386254516`}]], 
   Text3DBox[
    FormBox["\<\"B\"\>", StandardForm], {
    0.893183348769642, 0, -1.1691921826321872`}], Text3DBox[
    FormBox["\<\"C\"\>", StandardForm], 
    NCache[{0.5103904850112239, 
      Rational[1, 4] (-3 - 5^Rational[1, 2]), -0.3154386672714801}, {
     0.5103904850112239, -1.3090169943749475`, -0.3154386672714801}]], 
   Text3DBox[
    FormBox["\<\"D\"\>", StandardForm], 
    NCache[{-0.3154386672714801, -0.9708203932499369, (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {-0.3154386672714801, -0.9708203932499369, 
     1.1135163644116066`}]], Text3DBox[
    FormBox["\<\"E\"\>", StandardForm], 
    NCache[{-0.3154386672714801, 
      0.9708203932499369, (Rational[5, 8] + 
       Rational[11, 8] 5^Rational[-1, 2])^
      Rational[1, 2]}, {-0.3154386672714801, 0.9708203932499369, 
     1.1135163644116066`}]], Text3DBox[
    FormBox["\<\"F\"\>", StandardForm], 
    NCache[{-0.46785794459362195`, -1.4399186938124424`, Root[
      1 - 20 #^2 + 80 #^4& , 3, 
       0]}, {-0.46785794459362195`, -1.4399186938124424`, 
     0.2628655560595668}]], Text3DBox[
    FormBox["\<\"G\"\>", StandardForm], 
    NCache[{0.2891521116655235, 0.8899186938124423, Root[
      1 - 100 #^2 + 80 #^4& , 1, 0]}, {0.2891521116655235, 
     0.8899186938124423, -1.1135163644116068`}]], Text3DBox[
    FormBox["\<\"H\"\>", StandardForm], 
    NCache[{-0.255195242505612, -0.7854101966249685, Root[
      1 - 100 #^2 + 80 #^4& , 1, 
       0]}, {-0.255195242505612, -0.7854101966249685, -1.1135163644116068`}]]},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{388.3795623537447, 348.9365463127889},
  Lighting->None,
  ViewPoint->{0.14331941672203471`, 2.747486694464291, -1.9699686313574},
  ViewVertical->{-0.7315407789538687, 
   0.3200145164896805, -0.7656168285839533}]], "Output",
 CellChangeTimes->{3.5391943108525867`*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Si el dodecaedro tiene lado ",
 StyleBox["1",
  FontFamily->"Times"],
 ", el pent\[AAcute]gono sombreado tiene lado ",
 StyleBox["\[CapitalPhi]",
  FontSize->18],
 ", luego el rect\[AAcute]ngulo sombreado tiene lado ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["\[CapitalPhi]",
     FontSize->18,
     FontSlant->"Plain"], "2"], TraditionalForm]]],
 ", luego el tri\[AAcute]ngulo ",
 StyleBox["EHG",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " tiene un lado de longitud ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["\[CapitalPhi]",
     FontSize->18,
     FontSlant->"Plain"], "2"], TraditionalForm]]],
 " y los otros dos de longitud ",
 StyleBox["h",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 StyleBox["\[CapitalPhi]",
  FontSize->18],
 "cos ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["18",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"\[CapitalPhi]", 
      SqrtBox[
       RowBox[{"2", "+", "\[CapitalPhi]"}]]}], 
     StyleBox["2",
      FontFamily->"Times",
      FontSize->12.779998779296875`,
      FontSlant->"Plain"]],
    FontSize->18], TraditionalForm]]],
 ", de donde su altura es de donde la mitad del \[AAcute]ngulo \
di\[EAcute]drico tiene seno igual a ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    StyleBox["\[CapitalPhi]",
     FontSlant->"Plain"], 
    SqrtBox[
     RowBox[{"2", "+", "\[CapitalPhi]"}]]], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 "= ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    FractionBox[
     RowBox[{"5", "+", 
      SqrtBox["5"]}], "10"]], TraditionalForm]]],
 ". De aqu\[IAcute] se obtiene el coseno que aparece en la tabla anterior. (N\
\[OAcute]tese que una expresi\[OAcute]n alternativa es ",
 StyleBox["arctan[-",
  FontFamily->"Times",
  FontSize->18],
 StyleBox["2",
  FontFamily->"Times"],
 StyleBox["]).",
  FontFamily->"Times",
  FontSize->18]
}], "Text",
 CellChangeTimes->{{3.53919217345813*^9, 3.539192173459857*^9}, {
   3.539194351456852*^9, 3.53919463311829*^9}, {3.5391946631741343`*^9, 
   3.53919468159439*^9}, 3.539204387813491*^9, {3.53920584561644*^9, 
   3.53920587150639*^9}, {3.539205910029809*^9, 3.539205914090891*^9}, {
   3.5392061287320232`*^9, 3.5392061341346073`*^9}, {3.5392062588248796`*^9, 
   3.539206305986457*^9}, {3.539466380648046*^9, 3.539466425747068*^9}}],

Cell[TextData[StyleBox["LOS S\[CapitalOAcute]LIDOS PLAT\[CapitalOAcute]NICOS",
 
 FontSize->18,
 FontColor->RGBColor[0, 0, 1]]], "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellMargins->{{100, 100}, {16, 18}},
 CellChangeTimes->{{3.538515429422391*^9, 3.538515429424019*^9}, {
  3.538517083097238*^9, 3.538517086760803*^9}, {3.538772137916774*^9, 
  3.5387721418334713`*^9}, {3.5389433492789*^9, 3.538943354615024*^9}, {
  3.538944083654379*^9, 3.538944088838513*^9}, {3.5391065561537533`*^9, 
  3.5391065641036177`*^9}, {3.539110603199396*^9, 3.5391106061050386`*^9}, {
  3.539114155036748*^9, 3.5391141567297077`*^9}, {3.5391190486065063`*^9, 
  3.5391190499503193`*^9}, {3.539191580022891*^9, 3.539191581987825*^9}, {
  3.539194702212619*^9, 3.539194706217629*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "Mientras que existen infinitos pol\[IAcute]gonos regulares convexos, sucede \
que los \[UAcute]nicos poliedros regulares convexos son los cinco que hemos \
presentado hasta aqu\[IAcute], conocidos tambi\[EAcute]n como ",
 StyleBox["s\[OAcute]lidos plat\[OAcute]nicos.",
  FontSlant->"Italic"],
 " La figura siguiente muestra los cinco junto con sus esferas inscritas y \
circunscritas."
}], "Text",
 CellChangeTimes->{{3.539192173602111*^9, 3.539192173603932*^9}, {
  3.539194714121715*^9, 3.539194780490591*^9}, {3.54088365855684*^9, 
  3.5408836588319283`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0.296, $CellContext`b$$ = 
    0.534, $CellContext`n$$ = "Tetrahedron", Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n$$], "Tetrahedron", "Poliedro"}, {
      "Tetrahedron" -> "Tetraedro", "Hexahedron" -> "Hexaedro", "Octahedron" -> 
       "Octaedro", "Dodecahedron" -> "Dodecaedro", "Icosahedron" -> 
       "Icosaedro"}}, {{
       Hold[$CellContext`a$$], 0.4, "Opacidad esfera"}, 0, 1}, {{
       Hold[$CellContext`b$$], 0.8, "Opacidad poliedro"}, 0, 1}}, 
    Typeset`size$$ = {360., {193., 198.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$10833$$ = False, $CellContext`a$10834$$ = 
    0, $CellContext`b$10835$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 0.4, $CellContext`b$$ = 
        0.8, $CellContext`n$$ = "Tetrahedron"}, "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$10833$$, False], 
        Hold[$CellContext`a$$, $CellContext`a$10834$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$10835$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{{
          Opacity[$CellContext`a$$], 
          GrayLevel[0.6], 
          Sphere[{0, 0, 0}, 1.01]}, {
          Opacity[1], 
          GrayLevel[0.8], 
          
          Sphere[{0, 0, 0}, PolyhedronData[$CellContext`n$$, "Inradius"]/
           PolyhedronData[$CellContext`n$$, "Circumradius"]]}, {
          GrayLevel[0.5], 
          Opacity[$CellContext`b$$], 
          Scale[
           PolyhedronData[$CellContext`n$$, "Faces"], 1/
           PolyhedronData[$CellContext`n$$, "Circumradius"], {0, 0, 0}]}}, 
        Lighting -> "Neutral", Boxed -> False], 
      "Specifications" :> {{{$CellContext`n$$, "Tetrahedron", "Poliedro"}, {
         "Tetrahedron" -> "Tetraedro", "Hexahedron" -> "Hexaedro", 
          "Octahedron" -> "Octaedro", "Dodecahedron" -> "Dodecaedro", 
          "Icosahedron" -> "Icosaedro"}}, {{$CellContext`a$$, 0.4, 
          "Opacidad esfera"}, 0, 1, 
         AppearanceElements -> {}}, {{$CellContext`b$$, 0.8, 
          "Opacidad poliedro"}, 0, 1, AppearanceElements -> {}}}, 
      "Options" :> {AppearanceElements -> {}}, "DefaultOptions" :> {}],
     ImageSizeCache->{405., {256., 262.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.5391167395734043`*^9, 3.5391994607220697`*^9, 
  3.5403291106633997`*^9},
 TextAlignment->Center],

Cell[TextData[{
 "La tabla siguiente recopila la informaci\[OAcute]n que hemos obtenido sobre \
ellos, pero, para no repetir exactamente lo mismo, presentamos los datos para \
poliedros de radio ",
 StyleBox["R",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 1",
  FontFamily->"Times"],
 " en lugar de arista ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 1",
  FontFamily->"Times"],
 ". Incluimos adem\[AAcute]s el n\[UAcute]mero de lados de cada cara ",
 StyleBox["c",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y el n\[UAcute]mero de aristas que llegan a cada v\[EAcute]rtice ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellChangeTimes->{{3.539116768112653*^9, 3.539116768113727*^9}, {
  3.539194878085246*^9, 3.5391949916290607`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"\"\>", "\<\"C\"\>", "\<\"A\"\>", "\<\"V\"\>", "\<\"c\"\>", "\<\"v\"\
\>", "\<\"l\"\>", "\<\"r\"\>", "\<\"Vol\"\>", "\<\"\[CapitalAAcute]rea\"\>", \
"\<\"D\"\>"},
    {"\<\"Tetraedro\"\>", "4", "6", "4", "3", "3", "1.63299`", "0.33333`", 
     "0.5132`", 
     "4.6188`", "\<\"\\!\\(\\*SuperscriptBox[\\(70.52\\), \
\\(\[SmallCircle]\\)]\\)\"\>"},
    {"\<\"Hexaedro\"\>", "6", "12", "8", "4", "3", "1.1547`", "0.57735`", 
     "1.5396`", 
     "8", "\<\"\\!\\(\\*SuperscriptBox[\\(90\\), \
\\(\[SmallCircle]\\)]\\)\"\>"},
    {"\<\"Octaedro\"\>", "8", "12", "6", "3", "4", "1.41421`", "0.57735`", 
     "1.33333`", 
     "6.9282`", "\<\"\\!\\(\\*SuperscriptBox[\\(109.47\\), \
\\(\[SmallCircle]\\)]\\)\"\>"},
    {"\<\"Dodecaedro\"\>", "12", "30", "20", "5", "3", "0.71364`", "0.79465`",
      "2.78516`", 
     "10.514`", "\<\"\\!\\(\\*SuperscriptBox[\\(116.56\\), \
\\(\[SmallCircle]\\)]\\)\"\>"},
    {"\<\"Icosaedro\"\>", "20", "30", "12", "3", "5", "1.0546`", "0.79465`", 
     "2.53615`", 
     "9.5745`", "\<\"\\!\\(\\*SuperscriptBox[\\(138.19\\), \
\\(\[SmallCircle]\\)]\\)\"\>"}
   },
   AutoDelete->False,
   GridBoxDividers->{
    "Columns" -> {
      False, True, False, False, True, False, True, True, True, False, True, 
       True}, "Rows" -> {False, True, True, False, True, False, True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{{3.5391953484743357`*^9, 3.539195441436879*^9}, 
   3.539195515443283*^9, 3.5391956054391747`*^9, {3.5391956661461983`*^9, 
   3.5391956843024273`*^9}, 3.5406756080812597`*^9, 3.540675728394474*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Observemos que si consideramos un v\[EAcute]rtice ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de un poliedro regular cualquiera en el que concurran ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " caras (luego tambi\[EAcute]n ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " aristas), los ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " v\[EAcute]rtices adyacentes a ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " tienen que estar sobre la esfera de centro ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y radio igual a la arista ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " del poliedro, y tambi\[EAcute]n sobre la esfera de centro el centro del \
poliedro y radio igual al radio del poliedro, luego est\[AAcute]n en la \
intersecci\[OAcute]n de dos esferas, que es una circunferencia de radio ",
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y, en particular est\[AAcute]n en el mismo plano. M\[AAcute]s a\[UAcute]n, \
por definici\[OAcute]n de poliedro podemos disponer c\[IAcute]clicamente \
dichos v\[EAcute]rtices de modo que las aristas que unen ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " con dos v\[EAcute]rtices consecutivos sean dos lados contiguos de la misma \
cara. Esto implica que si unimos con un segmento cada par de v\[EAcute]rtices \
consecutivos obtenemos un pol\[IAcute]gono de ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " lados. Adem\[AAcute]s, dichos lados ser\[AAcute]n todos iguales, pues si \
las caras del poliedro tienen ",
 StyleBox["c",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " lados, la longitud de cada lado del pol\[IAcute]gono que hemos formado \
debe ser la de la diagonal de un ",
 StyleBox["c",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "-\[AAcute]gono regular de radio ",
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " que une dos v\[EAcute]rtices adyacentes a un tercero (que en este caso es ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "). (Notemos que si ",
 StyleBox["c",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 3",
  FontFamily->"Times"],
 " en lugar de una inexistente \[OpenCurlyDoubleQuote]diagonal\
\[CloseCurlyDoubleQuote] de un tri\[AAcute]ngulo equil\[AAcute]tero lo que \
tenemos es uno de sus lados, pero el argumento vale igualmente). Por el \
teorema 1.11 sabemos que el pol\[IAcute]gono que hemos formado es regular, y \
ser\[AAcute] simple si el poliedro lo es, ya que si dos de sus lados se \
cortan, como dichos lados son diagonales de caras del poliedro, \[EAcute]stas \
se cortar\[IAcute]an tambi\[EAcute]n en puntos distintos de sus aristas."
}], "Text",
 CellChangeTimes->{{3.5408846722391567`*^9, 3.540884681127532*^9}, {
  3.540884808200767*^9, 3.5408848177690887`*^9}, {3.5408852135081882`*^9, 
  3.540885277181583*^9}, {3.5408854425432873`*^9, 3.540885443871112*^9}}],

Cell[TextData[{
 "Se llama ",
 StyleBox["figura",
  FontSlant->"Italic"],
 " asociada a un v\[EAcute]rtice ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de un poliedro regular al pol\[IAcute]gono regular cuyos v\[EAcute]rtices \
son los v\[EAcute]rtices adyacentes al v\[EAcute]rtice dado, de modo que dos \
v\[EAcute]rtices son adyacentes si las aristas que los unen con ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " forman parte de la misma cara."
}], "Text",
 CellMargins->{{30, 30}, {3, 5}},
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQAWIQ7fDwl8etmFeO15rV/EG00Km0EBB96p5RHIjesalU
9TaQ3sC02ghEvzo8x+sTkLZ+vysIRHtwrYwH0YtWS6SB6JjUfQUg2qUmpRhE
9+1bfoQpFmjOPMlTIPrYH4m7IDqAPxRMf6rf8ApEMwXtA9NCDsk/QPRLBtaf
IPrSkRLFj0D6QAWDEoi+cbVbiCHuleOs8hdKIJrh00MbEB0X0xEOojXeqBaA
6LyNcoUg+hnfcXsmIP3iOq8/iP51QOg/iH62VwRM//AzTAwG0tsfLAbTB7z/
ZIFoDUHFbBB9J+ue/isg7ZTgZwqi1fe+er05Eaiv4wHzFiANAI+3oe4=
  "],
 TextJustification->1.,
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell[TextData[{
 "Es claro que una simetr\[IAcute]a del poliedro que transforma un \
v\[EAcute]rtice en otro transforma la figura de uno en la figura del otro, \
por lo que todas las figuras de los distintos v\[EAcute]rtices de un poliedro \
regular son iguales. Puesto que el v\[EAcute]rtice ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " equidista de los v\[EAcute]rtices de su figura, el segmento que lo une con \
el centro de su figura es perpendicular al plano de \[EAcute]sta y la recta \
que lo contiene pasa por el centro del poliedro. Podemos formar una pir\
\[AAcute]mide con base la figura y v\[EAcute]rtice ",
 StyleBox["P,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de modo que para visualizar la figura de un v\[EAcute]rtice ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de un poliedro no es necesario considerar sus v\[EAcute]rtices adyacentes, \
sino que basta cortar el poliedro por un plano perpendicular a la recta que \
une ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " con el centro, y la secci\[OAcute]n obtenida es homot\[EAcute]tica a la \
figura. La figura siguiente muestra las figuras de los s\[OAcute]lidos plat\
\[OAcute]nicos:"
}], "Text",
 CellChangeTimes->{{3.540886061780673*^9, 3.540886080942237*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`u$$], 0, "Figura"}, 0, 0.2}}, Typeset`size$$ = {
    360., {116., 121.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False, $CellContext`u$941$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$941$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> GraphicsGrid[{{
          Graphics3D[{
            GrayLevel[0.7], 
            PolyhedronOperations`Truncate[
             PolyhedronData["Tetrahedron", "Faces"], $CellContext`u$$]}, 
           Boxed -> False, Lighting -> "Neutral"], 
          Graphics3D[{
            GrayLevel[0.7], 
            PolyhedronOperations`Truncate[
             PolyhedronData["Hexahedron", "Faces"], $CellContext`u$$]}, Boxed -> 
           False, Lighting -> "Neutral"], 
          Graphics3D[{
            GrayLevel[0.7], 
            PolyhedronOperations`Truncate[
             PolyhedronData["Octahedron", "Faces"], $CellContext`u$$]}, Boxed -> 
           False, Lighting -> "Neutral"]}, {
          Graphics3D[{
            GrayLevel[0.7], 
            PolyhedronOperations`Truncate[
             PolyhedronData["Dodecahedron", "Faces"], $CellContext`u$$]}, 
           Boxed -> False, Lighting -> "Neutral"], 
          Graphics3D[{
            GrayLevel[0.7], 
            PolyhedronOperations`Truncate[
             PolyhedronData["Icosahedron", "Faces"], $CellContext`u$$]}, 
           Boxed -> False, Lighting -> "Neutral"]}}], 
      "Specifications" :> {{{$CellContext`u$$, 0, "Figura"}, 0, 0.2, 
         AppearanceElements -> {}}}, "Options" :> {AppearanceElements -> {}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{405., {153., 159.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({PolyhedronOperations`Truncate[
         Pattern[PolyhedronOperations`Private`poly, 
          Blank[]], 
         PatternTest[
          Pattern[PolyhedronOperations`Private`ratio, 
           Blank[]], # == 0& ]] := PolyhedronOperations`Private`poly, 
       PolyhedronOperations`Truncate[
         Pattern[PolyhedronOperations`Private`ipoly, 
          Blank[]], 
         Optional[
          Pattern[PolyhedronOperations`Private`ratio, 
           Blank[]], 3/10]] := Condition[
         Block[{
          PolyhedronOperations`Private`pol, PolyhedronOperations`Private`res, 
           PolyhedronOperations`Private`reslist = {}, 
           PolyhedronOperations`Private`nratio = 
           N[PolyhedronOperations`Private`ratio], 
           PolyhedronOperations`Private`search, 
           PolyhedronOperations`Private`begin, 
           PolyhedronOperations`Private`val, 
           PolyhedronOperations`Private`$TruncList, 
           PolyhedronOperations`Private`$TruncHalfList, 
           PolyhedronOperations`Private`polygon}, 
          PolyhedronOperations`Private`poly = 
           ReplaceAll[
            PolyhedronOperations`Private`ipoly, {
             Pattern[PolyhedronOperations`Private`g, 
                Blank[GraphicsComplex]] :> ReplaceAll[
                PolyhedronOperations`Private`TruncateFace[
                PolyhedronOperations`Private`g, 
                 PolyhedronOperations`Private`ratio, False], Polygon -> 
                PolyhedronOperations`Private`polygon]}]; 
          PolyhedronOperations`Private`$TruncList = {}; 
          PolyhedronOperations`Private`$TruncHalfList = {}; 
          PolyhedronOperations`Private`pol = Flatten[
             ReplaceAll[PolyhedronOperations`Private`poly, Polygon[
                Pattern[PolyhedronOperations`Private`x, 
                 Blank[]]] :> 
              PolyhedronOperations`Private`TruncateFace[
               PolyhedronOperations`Private`x, 
                PolyhedronOperations`Private`nratio]]]; ReplaceAll[
            If[
            Length[PolyhedronOperations`Private`res] > 0, 
             PolyhedronOperations`Private`res = 
              Round[PolyhedronOperations`Private`$TruncList 100000000]/1.*^8; 
             PolyhedronOperations`Private`res = Sort[
                Flatten[
                 MapIndexed[{#, #2}& , PolyhedronOperations`Private`res, {3}],
                  2], OrderedQ[{
                  Part[#, 1], 
                  Part[#2, 1]}]& ]; PolyhedronOperations`Private`res = Join[{
                 Part[PolyhedronOperations`Private`res, {2, 1, 2}]}, 
                Partition[PolyhedronOperations`Private`res, 3, 1], {
                 Part[
                 PolyhedronOperations`Private`res, 
                  Length[PolyhedronOperations`Private`res] - {1, 0, 1}]}]; 
             PolyhedronOperations`Private`res = 
              Select[PolyhedronOperations`Private`res, Or[
                Part[#, 2, 1] == Part[#, 1, 1], Part[#, 2, 1] == 
                 Part[#, 3, 1]]& ]; 
             PolyhedronOperations`Private`res = Partition[
                Part[
                 Transpose[
                  Part[
                   Transpose[PolyhedronOperations`Private`res], 2]], 2], 2]; 
             While[PolyhedronOperations`Private`res =!= {}, 
               PolyhedronOperations`Private`search = ReplaceAll[{
                   Part[
                    First[PolyhedronOperations`Private`res], 2]}, {
                    Pattern[PolyhedronOperations`Private`a, 
                    Blank[]], 
                    Pattern[PolyhedronOperations`Private`b, 
                    Blank[]], 
                    Pattern[PolyhedronOperations`Private`c, 
                    Blank[]]} -> {
                   PolyhedronOperations`Private`a, 
                    PolyhedronOperations`Private`b, 
                    If[PolyhedronOperations`Private`c == 2, 1, 2]}]; 
               PolyhedronOperations`Private`begin = 
                PolyhedronOperations`Private`search; 
               PolyhedronOperations`Private`res = 
                Rest[PolyhedronOperations`Private`res]; 
               While[(PolyhedronOperations`Private`val = 
                  Select[PolyhedronOperations`Private`res, MemberQ[#, 
                    Part[PolyhedronOperations`Private`search, 1]]& , 
                    1]) =!= {}, 
                 PolyhedronOperations`Private`search = ReplaceAll[
                    Complement[
                    Part[PolyhedronOperations`Private`val, 1], 
                    PolyhedronOperations`Private`search], {
                    Pattern[PolyhedronOperations`Private`a, 
                    Blank[]], 
                    Pattern[PolyhedronOperations`Private`b, 
                    Blank[]], 
                    Pattern[PolyhedronOperations`Private`c, 
                    Blank[]]} -> {
                    PolyhedronOperations`Private`a, 
                    PolyhedronOperations`Private`b, 
                    If[PolyhedronOperations`Private`c == 2, 1, 2]}]; 
                 PolyhedronOperations`Private`begin = 
                  Join[PolyhedronOperations`Private`begin, 
                    PolyhedronOperations`Private`search]; 
                 PolyhedronOperations`Private`res = 
                  DeleteCases[PolyhedronOperations`Private`res, 
                    Part[PolyhedronOperations`Private`val, 1]]; Null]; 
               AppendTo[
                PolyhedronOperations`Private`reslist, 
                 PolyhedronOperations`Private`begin]; Null]; 
             If[PolyhedronOperations`Private`nratio === 0.5, 
               PolyhedronOperations`Private`reslist = 
                Apply[Part[PolyhedronOperations`Private`$TruncHalfList, 
                   SlotSequence[1]]& , PolyhedronOperations`Private`reslist, {
                  2}]; PolyhedronOperations`Private`pol = 
                ReplaceAll[PolyhedronOperations`Private`pol, Polygon[
                    Pattern[PolyhedronOperations`Private`x, 
                    Blank[]]] :> 
                  PolyhedronOperations`Private`combineSame[
                   PolyhedronOperations`Private`x]], 
               PolyhedronOperations`Private`reslist = 
               Apply[Part[PolyhedronOperations`Private`$TruncList, 
                  SlotSequence[1]]& , PolyhedronOperations`Private`reslist, {
                 2}]]; If[
              Head[PolyhedronOperations`Private`pol] === Graphics3D, 
               Join[
                Graphics3D[
                 Join[
                  First[PolyhedronOperations`Private`pol], 
                  Map[Polygon, PolyhedronOperations`Private`reslist]]], 
                Rest[PolyhedronOperations`Private`pol]], 
               Join[PolyhedronOperations`Private`pol, 
                Map[Polygon, PolyhedronOperations`Private`reslist]]], 
             PolyhedronOperations`Private`pol], {
            PolyhedronOperations`Private`polygon -> Polygon}]], 
         NumberQ[
          N[PolyhedronOperations`Private`ratio]]], 
       TagSet[PolyhedronOperations`Truncate, 
        MessageName[PolyhedronOperations`Truncate, "usage"], 
        "\!\(\*RowBox[{\" Truncate \", \"[\", StyleBox[\" expr \", \" TI \"], \
\"]\"}]\) truncates each edge of each polygon in graphics expression \
\!\(\*StyleBox[\" expr \", \" TI \"]\).\n\!\(\*RowBox[{\" Truncate \", \"[\", \
RowBox[{StyleBox[\" expr \", \" TI \"], \",\", StyleBox[\" ratio \", \" TI \
\"]}], \"]\"}]\) truncates to the specified \!\(\*StyleBox[\" ratio \", \" TI \
\"]\) of the edge length."], PolyhedronOperations`Private`$TruncList = {}, 
       PolyhedronOperations`Private`$TruncHalfList = {}, 
       PolyhedronOperations`Private`TruncateFace[
         Pattern[PolyhedronOperations`Private`face, 
          Blank[List]], 0.5] := 
       Block[{PolyhedronOperations`Private`array, 
          PolyhedronOperations`Private`array2}, 
         PolyhedronOperations`Private`array = 
          PolyhedronOperations`Private`truncList[
           PolyhedronOperations`Private`face, 0.49]; 
         AppendTo[PolyhedronOperations`Private`$TruncList, 
           Partition[
            RotateLeft[PolyhedronOperations`Private`array], 2]]; 
         PolyhedronOperations`Private`array2 = Flatten[
            Map[0.5 {
               Apply[Plus, #], 
               Apply[Plus, #]}& , 
             Partition[PolyhedronOperations`Private`array, 2]], 1]; 
         AppendTo[PolyhedronOperations`Private`$TruncHalfList, 
           Partition[
            RotateLeft[PolyhedronOperations`Private`array2], 2]]; 
         Polygon[PolyhedronOperations`Private`array]], 
       PolyhedronOperations`Private`TruncateFace[
         Pattern[PolyhedronOperations`Private`face, 
          Blank[List]], 
         Pattern[PolyhedronOperations`Private`ratio, 
          Blank[]]] := 
       Block[{PolyhedronOperations`Private`array}, 
         PolyhedronOperations`Private`array = 
          PolyhedronOperations`Private`truncList[
           PolyhedronOperations`Private`face, 
            PolyhedronOperations`Private`ratio]; 
         AppendTo[PolyhedronOperations`Private`$TruncList, 
           Partition[
            RotateLeft[PolyhedronOperations`Private`array], 2]]; 
         Polygon[PolyhedronOperations`Private`array]], 
       PolyhedronOperations`Private`TruncateFace[
         GraphicsComplex[
          Pattern[PolyhedronOperations`Private`ipts, 
           Blank[]], 
          Pattern[PolyhedronOperations`Private`iprims, 
           Blank[]], 
          Pattern[PolyhedronOperations`Private`opts, 
           BlankNullSequence[]]], 
         Pattern[PolyhedronOperations`Private`ratio, 
          Blank[]], 
         Pattern[PolyhedronOperations`Private`open, 
          Blank[]]] := 
       Block[{PolyhedronOperations`Private`index, 
          PolyhedronOperations`Private`newpts, 
          PolyhedronOperations`Private`count = 0, 
          PolyhedronOperations`Private`pts = 
          PolyhedronOperations`Private`ipts, 
          PolyhedronOperations`Private`prims = 
          PolyhedronOperations`Private`iprims, 
          PolyhedronOperations`Private`faces}, 
         PolyhedronOperations`Private`index[
            Pattern[PolyhedronOperations`Private`pt, 
             Blank[]]] := (
           PolyhedronOperations`Private`index[
            PolyhedronOperations`Private`pt] = (
            PolyhedronOperations`Private`newpts[
               PreIncrement[PolyhedronOperations`Private`count]] = 
             PolyhedronOperations`Private`pt; 
            PolyhedronOperations`Private`count)); 
         Map[PolyhedronOperations`Private`index, 
           PolyhedronOperations`Private`pts]; 
         PolyhedronOperations`Private`prims = 
          ReplaceAll[PolyhedronOperations`Private`prims, {Polygon[
               Pattern[PolyhedronOperations`Private`a, {
                 Repeated[{
                   BlankSequence[Integer]}]}]] :> Polygon[
               Map[PolyhedronOperations`Private`truncatePolygon[
                 Part[PolyhedronOperations`Private`pts, #], #, 
                 PolyhedronOperations`Private`ratio]& , 
                PolyhedronOperations`Private`a]], Polygon[
               Pattern[PolyhedronOperations`Private`a, {
                 BlankSequence[Integer]}]] :> Polygon[
               PolyhedronOperations`Private`truncatePolygon[
                Part[
                PolyhedronOperations`Private`pts, 
                 PolyhedronOperations`Private`a], 
                PolyhedronOperations`Private`a, 
                PolyhedronOperations`Private`ratio]]}]; If[
           Not[PolyhedronOperations`Private`open], 
           PolyhedronOperations`Private`faces = Join[
              Flatten[
               Cases[{PolyhedronOperations`Private`iprims}, Polygon[
                  Pattern[PolyhedronOperations`Private`a, {
                    Repeated[{
                    BlankSequence[Integer]}]}]] :> 
                PolyhedronOperations`Private`a, Infinity], 1], 
              Cases[{PolyhedronOperations`Private`iprims}, Polygon[
                 Pattern[PolyhedronOperations`Private`a, {
                   BlankSequence[Integer]}]] :> 
               PolyhedronOperations`Private`a, Infinity]]; 
           PolyhedronOperations`Private`prims = 
            Append[{PolyhedronOperations`Private`prims}, 
              Polygon[
               PolyhedronOperations`Private`newfaces[
               PolyhedronOperations`Private`ipts, 
                PolyhedronOperations`Private`faces, 
                PolyhedronOperations`Private`ratio]]]]; GraphicsComplex[
           Map[PolyhedronOperations`Private`newpts, 
            Range[PolyhedronOperations`Private`count]], 
           PolyhedronOperations`Private`prims]], 
       PolyhedronOperations`Private`truncList[
         Pattern[PolyhedronOperations`Private`face, 
          Blank[]], 0.5] := Map[0.5 Apply[Plus, #]& , 
         Join[
          Partition[PolyhedronOperations`Private`face, 2, 1], {{
            Last[PolyhedronOperations`Private`face], 
            First[PolyhedronOperations`Private`face]}}]], 
       PolyhedronOperations`Private`truncList[
         Pattern[PolyhedronOperations`Private`face, 
          Blank[]], 
         Pattern[PolyhedronOperations`Private`ratio, 
          Blank[]]] := Flatten[
         Map[{
          PolyhedronOperations`Private`ratio (Part[#, 2] - Part[#, 1]) + 
           Part[#, 1], (1 - PolyhedronOperations`Private`ratio) (Part[#, 2] - 
             Part[#, 1]) + Part[#, 1]}& , 
          Join[
           Partition[PolyhedronOperations`Private`face, 2, 1], {{
             Last[PolyhedronOperations`Private`face], 
             First[PolyhedronOperations`Private`face]}}]], 1], 
       PolyhedronOperations`Private`truncatePolygon[
         Pattern[PolyhedronOperations`Private`ptc, 
          Blank[]], 
         Pattern[PolyhedronOperations`Private`pti, 
          Blank[]], 
         Pattern[PolyhedronOperations`Private`ratio, 
          Blank[]]] := 
       Block[{PolyhedronOperations`Private`new}, 
         PolyhedronOperations`Private`new = 
          Partition[PolyhedronOperations`Private`ptc, 2, 1, 1]; 
         If[PolyhedronOperations`Private`ratio == 0.5, 
           PolyhedronOperations`Private`new = 
           Map[Mean, PolyhedronOperations`Private`new], 
           PolyhedronOperations`Private`new = Flatten[
             
             Apply[{PolyhedronOperations`Private`ratio #2 + (1 - 
                 PolyhedronOperations`Private`ratio) #, 
               PolyhedronOperations`Private`ratio # + (1 - 
                 PolyhedronOperations`Private`ratio) #2}& , 
              PolyhedronOperations`Private`new, {1}], 1]]; 
         Map[PolyhedronOperations`Private`index, 
           PolyhedronOperations`Private`new]], 
       PolyhedronOperations`Private`newfaces[
         Pattern[PolyhedronOperations`Private`points, 
          Blank[]], 
         Pattern[PolyhedronOperations`Private`faces, 
          Blank[]], 
         Pattern[PolyhedronOperations`Private`ratio, 
          Blank[]]] := 
       Block[{PolyhedronOperations`Private`edges, 
          PolyhedronOperations`Private`polys, 
          PolyhedronOperations`Private`corners}, 
         PolyhedronOperations`Private`corners = Flatten[
            Map[Partition[#, 3, 1, 1]& , PolyhedronOperations`Private`faces], 
            1]; PolyhedronOperations`Private`polys = Map[{#, 
             Cases[PolyhedronOperations`Private`corners, {
                Pattern[PolyhedronOperations`Private`a, 
                 Blank[]], #, 
                Pattern[PolyhedronOperations`Private`b, 
                 Blank[]]} :> (PolyhedronOperations`Private`a -> 
               PolyhedronOperations`Private`b), Infinity]}& , 
            Range[
             Length[PolyhedronOperations`Private`points]]]; 
         PolyhedronOperations`Private`polys = 
          DeleteCases[PolyhedronOperations`Private`polys, {
             Blank[], {}}]; 
         PolyhedronOperations`Private`polys = 
          Map[PolyhedronOperations`Private`organize, 
            PolyhedronOperations`Private`polys]; Apply[
           
           Function[{
            PolyhedronOperations`Private`center, 
             PolyhedronOperations`Private`face}, 
            Map[
            PolyhedronOperations`Private`index[(1 - 
                PolyhedronOperations`Private`ratio) 
               Part[PolyhedronOperations`Private`points, 
                 PolyhedronOperations`Private`center] + 
              PolyhedronOperations`Private`ratio 
               Part[PolyhedronOperations`Private`points, #]]& , 
             PolyhedronOperations`Private`face]], 
           PolyhedronOperations`Private`polys, 1]], 
       PolyhedronOperations`Private`organize[{
          Pattern[PolyhedronOperations`Private`i, 
           Blank[]], 
          Pattern[PolyhedronOperations`Private`pairs, 
           Blank[]]}] := {PolyhedronOperations`Private`i, 
         Reverse[
          NestList[ReplaceAll[#, PolyhedronOperations`Private`pairs]& , 
           First[
            First[PolyhedronOperations`Private`pairs]], 
           Length[PolyhedronOperations`Private`pairs] - 1]]}, 
       PolyhedronOperations`Private`combineSame[
         Pattern[PolyhedronOperations`Private`x, 
          Blank[List]]] := 
       Block[{PolyhedronOperations`Private`set}, 
         PolyhedronOperations`Private`set = 
          If[Norm[Part[PolyhedronOperations`Private`x, 2] - Part[
              PolyhedronOperations`Private`x, 1]] > 
            Norm[Part[PolyhedronOperations`Private`x, 3] - Part[
              PolyhedronOperations`Private`x, 2]], 
            RotateLeft[PolyhedronOperations`Private`x], 
            PolyhedronOperations`Private`x]; Polygon[
           Map[0.5 Apply[Plus, #]& , 
            Partition[PolyhedronOperations`Private`set, 2]]]]}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.5394230634402514`*^9, 3.539426416527657*^9, {3.540666901286798*^9, 
   3.540666926887282*^9}, {3.540666958548732*^9, 3.540667010216488*^9}, 
   3.5406670658596287`*^9, 3.540723024212319*^9, 3.5407230590361853`*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Observamos que un s\[OAcute]lido plat\[OAcute]nico est\[AAcute] \
completamente determinado por el tipo de cara y el de la figura de sus v\
\[EAcute]rtices, y es habitual representar mediante {",
 StyleBox["c,v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "} al s\[OAcute]lido plat\[OAcute]nico cuyas caras son de tipo {",
 StyleBox["c",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "} y las figuras de sus v\[EAcute]rtices son de tipo {",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "}. As\[IAcute], ",
 StyleBox["{3, 3}",
  FontFamily->"Times"],
 " es el tetraedro, ",
 StyleBox["{4, 3}",
  FontFamily->"Times"],
 " es el hexaedro, ",
 StyleBox["{3, 4}",
  FontFamily->"Times"],
 " es el octaedro, ",
 StyleBox["{5, 3}",
  FontFamily->"Times"],
 " es el dodecaedro y ",
 StyleBox["{3, 5}",
  FontFamily->"Times"],
 " es el icosaedro. Veamos que, tal y como hemos indicado, no hay m\[AAcute]s \
posibilidades:"
}], "Text",
 CellChangeTimes->{{3.539423339960268*^9, 3.539423497063632*^9}, {
   3.5394237416998568`*^9, 3.539423741703916*^9}, {3.53942378226652*^9, 
   3.539423787579872*^9}, 3.53942390281973*^9, {3.5405886096361217`*^9, 
   3.540588620777169*^9}, {3.540669542824801*^9, 3.540669554176499*^9}, {
   3.540883716866235*^9, 3.5408837437927856`*^9}, {3.541013591296867*^9, 
   3.541013591301409*^9}}],

Cell[TextData[{
 StyleBox["Teorema 3.6:",
  FontWeight->"Bold"],
 " Los \[UAcute]nicos poliedros simples (en particular, convexos), \
transitivos para v\[EAcute]rtices, cuyas caras son pol\[IAcute]gonos \
regulares iguales (en particular, los \[UAcute]nicos poliedros regulares \
simples) son los s\[OAcute]lidos plat\[OAcute]nicos."
}], "Text",
 CellMargins->{{30, 30}, {3, 5}},
 CellChangeTimes->{{3.5383424718399963`*^9, 3.5383425212035933`*^9}, {
   3.538342563212167*^9, 3.538342641589696*^9}, {3.5383442356780663`*^9, 
   3.538344341344078*^9}, {3.5383916368989153`*^9, 3.538391701841703*^9}, {
   3.538391805282505*^9, 3.5383918567709513`*^9}, {3.538391941949873*^9, 
   3.538391963140169*^9}, {3.538425381242011*^9, 3.538425424800625*^9}, {
   3.538425576780856*^9, 3.538425578658119*^9}, {3.5384256855156183`*^9, 
   3.5384256859475107`*^9}, {3.538425795101571*^9, 3.538425800156361*^9}, {
   3.538913547649026*^9, 3.53891355201474*^9}, {3.538944148369854*^9, 
   3.5389442792646*^9}, {3.538944487060791*^9, 3.5389447002612753`*^9}, {
   3.5389448971850777`*^9, 3.538944904959159*^9}, {3.5389486062205687`*^9, 
   3.5389487284326057`*^9}, {3.5389501365860567`*^9, 3.538950136648181*^9}, {
   3.5391147615408897`*^9, 3.539114765121181*^9}, {3.539114839884247*^9, 
   3.5391148410333443`*^9}, {3.5394236149505444`*^9, 3.53942365844925*^9}, {
   3.540883788065652*^9, 3.540883828016777*^9}, 3.541011937435651*^9, {
   3.541013600660755*^9, 3.541013678028378*^9}, {3.541014902300558*^9, 
   3.5410149035051947`*^9}, 3.5411787385108757`*^9},
 TextJustification->1.,
 Hyphenation->False,
 Background->RGBColor[0.8, 0.7, 0.6]],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": Pongamos que las caras del poliedro (que necesariamente son \
pol\[IAcute]gonos regulares simples) tienen ",
 StyleBox["c",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " lados. Las hip\[OAcute]tesis bastan para justificar que los \
v\[EAcute]rtices adyacentes a uno dado ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " deben formar un pol\[IAcute]gono regular simple. En efecto, la \
transitividad para v\[EAcute]rtices asegura que existe la esfera circunscrita \
que contiene a todos los v\[EAcute]rtices y, por otra parte, como todas las \
caras son pol\[IAcute]gonos regulares iguales (necesariamente simples), todas \
las aristas tienen la misma longitud ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego todos los v\[EAcute]rtices adyacentes a ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute]n tambi\[EAcute]n en la esfera de centro ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y radio ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego al estar en la intersecci\[OAcute]n de dos esferas est\[AAcute]n \
sobre una circunferencia y por definici\[OAcute]n de poliedro forman un pol\
\[IAcute]gono, que ser\[AAcute] simple al serlo el poliedro (y lo llamaremos ",
 StyleBox["figura",
  FontSlant->"Italic"],
 " ",
 StyleBox["F",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " del v\[EAcute]rtice ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "). M\[AAcute]s a\[UAcute]n, todos los lados de la figura son iguales, pues \
miden ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " si las caras son tri\[AAcute]ngulos, y en otro caso su longitud es la de \
la diagonal ",
 StyleBox["d",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de dos v\[EAcute]rtices del pol\[IAcute]gono {",
 StyleBox["c",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "} (de lado ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ") con un v\[EAcute]rtice adyacente com\[UAcute]n. El teorema 1.11 justifica \
que ",
 StyleBox["F",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un pol\[IAcute]gono regular, digamos {",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "}. La transitividad para v\[EAcute]rtices justifica que el valor de ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es el mismo para todos los v\[EAcute]rtices del poliedro. Un simple c\
\[AAcute]lculo muestra que el lado de la figura ",
 StyleBox["F",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " mide ",
 StyleBox["d",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 StyleBox["2",
  FontFamily->"Times"],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " cos(",
 StyleBox["\[Pi]/",
  FontFamily->"Times"],
 StyleBox["c",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "), con lo que su radio es"
}], "Text",
 CellChangeTimes->{{3.541013591428528*^9, 3.5410135914304237`*^9}, {
  3.5410136548766117`*^9, 3.5410136583869667`*^9}, {3.5410137148552837`*^9, 
  3.541014086200473*^9}, {3.5410141389928417`*^9, 3.5410141680644293`*^9}, {
  3.541014204130684*^9, 3.5410143256903152`*^9}, {3.541014397918644*^9, 
  3.541014460348423*^9}}],

Cell[TextData[{
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     StyleBox[
      RowBox[{"l", " ", 
       RowBox[{"cos", "(", 
        RowBox[{"\[Pi]", "/", "c"}], ")"}]}],
      FontFamily->"Times",
      FontSize->17.039993286132812`], 
     RowBox[{"sen", "(", 
      RowBox[{"\[Pi]", "/", "v"}], ")"}]],
    FontFamily->"Times",
    FontSize->24], TraditionalForm]],
  FontSize->18],
 "."
}], "Text",
 CellChangeTimes->{{3.540887346953813*^9, 3.540887398815114*^9}, 
   3.540887472079463*^9, {3.5408880705766773`*^9, 3.540888097640148*^9}, {
   3.5408883373071947`*^9, 3.540888343481289*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Consideremos la pir\[AAcute]mide de base ",
 StyleBox["F",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y altura ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". Como ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " equidista de los v\[EAcute]rtices de ",
 StyleBox["F",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", su altura ",
 StyleBox["h",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y el radio ",
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " deben formar un tri\[AAcute]ngulo rect\[AAcute]ngulo cuya hipotenusa es ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", lo cual requiere en particular que se cumpla ",
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " < ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". Para un valor fijo de c, la expresi\[OAcute]n anterior para ",
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " crece a medida que ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " crece. Por ejemplo, si ",
 StyleBox["c",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 3",
  FontFamily->"Times"],
 ", tenemos que, para ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 6",
  FontFamily->"Times"],
 " ya sale ",
 StyleBox["r ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["=",
  FontFamily->"Times"],
 StyleBox[" l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", por lo que podemos concluir que si el poliedro est\[AAcute] formado por \
caras triangulares, su figura puede ser un tri\[AAcute]ngulo, un cuadrado o \
un pent\[AAcute]gono, pero un n\[UAcute]mero de lados mayor es imposible. \
Similarmente, si ",
 StyleBox["c",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 4",
  FontFamily->"Times"],
 ", para ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 4",
  FontFamily->"Times"],
 " ya obtenemos ",
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = ",
  FontFamily->"Times"],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego si las caras son cuadrados la figura es necesariamente un tri\
\[AAcute]ngulo, y lo mismo vale si las caras son pent\[AAcute]gonos, pues \
para ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 4",
  FontFamily->"Times"],
 " sale ",
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 1.14 ",
  FontFamily->"Times"],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", que ya es imposible. Por \[UAcute]ltimo, si ",
 StyleBox["c",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" \[GreaterEqual] 6",
  FontFamily->"Times"],
 " y ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 3",
  FontFamily->"Times"],
 " obtenemos que r \[GreaterSlantEqual] ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", por lo que las caras no pueden tener m\[AAcute]s de cinco lados."
}], "Text",
 CellChangeTimes->{{3.541013591602037*^9, 3.5410135916043158`*^9}, {
  3.54101447131754*^9, 3.541014541775425*^9}, {3.541014585864252*^9, 
  3.541014662376205*^9}}],

Cell[TextData[{
 "Con esto hemos probado que los valores {",
 StyleBox["c, v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "} para el poliedro dado deben coincidir con los correspondientes a un s\
\[OAcute]lido plat\[OAcute]nico.  Falta probar que es necesariamente el s\
\[OAcute]lido plat\[OAcute]nico correspondiente. Para ello observamos que el \
razonamiento anterior muestra que la figura de cualquier v\[EAcute]rtice ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] completamente determinada por los valores de ",
 StyleBox["c",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["v",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", al igual que la altura ",
 StyleBox["h",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " de la pir\[AAcute]mide de v\[EAcute]rtice ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " que la tiene por base, pues puede calcularse a partir de ",
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " por el teorema de Pit\[AAcute]goras. A partir de aqu\[IAcute] ya es f\
\[AAcute]cil probar que el poliedro tiene que ser el s\[OAcute]lido plat\
\[OAcute]nico correspondiente. Vamos a razonarlo para el caso del icosaedro, \
y dejamos los otros cuatro casos al lector, que son m\[AAcute]s sencillos."
}], "Text",
 CellChangeTimes->{{3.541014662589727*^9, 3.5410147151214857`*^9}}],

Cell[TextData[{
 "Se trata de probar que si el poliedro tiene tipo ",
 StyleBox["{3, 5}",
  FontFamily->"Times"],
 " es necesariamente un icosaedro regular. El razonamiento lo ilustra la \
misma figura que hemos empleado en la construcci\[OAcute]n del icosaedro. En \
realidad podemos empezar por el paso 2:"
}], "Text",
 CellChangeTimes->{{3.540889315525949*^9, 3.540889345030582*^9}, {
  3.540889619718604*^9, 3.5408896670459547`*^9}, {3.540889765116013*^9, 
  3.540889767692078*^9}, {3.540890457727233*^9, 3.54089045912272*^9}, {
  3.541014751012089*^9, 3.541014764938444*^9}}],

Cell[TextData[{
 StyleBox["Paso 2:",
  FontWeight->"Bold"],
 " Dado un poliedro en las hip\[OAcute]tesis del teorema y de tipo ",
 StyleBox["{3, 5},",
  FontFamily->"Times"],
 " sabemos que los v\[EAcute]rtices contiguos a uno de sus v\[EAcute]rtices \
",
 StyleBox["O",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " deben formar la base de una pir\[AAcute]mide pentagonal id\[EAcute]ntica a \
la del icosaedro del mismo lado. Si nos fijamos, por ejemplo, en el \
v\[EAcute]rtice ",
 StyleBox["B",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", sabemos que su figura debe contener a los v\[EAcute]rtices ",
 StyleBox["A, O, C,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " pero s\[OAcute]lo existe un pent\[AAcute]gono regular que contenga dichos \
v\[EAcute]rtices, luego la figura del v\[EAcute]rtice ",
 StyleBox["B",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " debe ser la misma que la del icosaedro."
}], "Text",
 CellChangeTimes->{{3.540889709542467*^9, 3.5408898745721292`*^9}, {
  3.5408899614486732`*^9, 3.540890006253499*^9}, {3.541014779532291*^9, 
  3.541014783704174*^9}}],

Cell[TextData[{
 StyleBox["Paso 3:",
  FontWeight->"Bold"],
 " Por lo tanto, las cinco caras que concurren en el v\[EAcute]rtice ",
 StyleBox["B",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " son exactamente las mismas que las del icosaedro. Similarmente, la figura \
del v\[EAcute]rtice ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " debe tener entre sus v\[EAcute]rtices a los v\[EAcute]rtices ",
 StyleBox["D, O, B, G,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " pero s\[OAcute]lo hay un pent\[AAcute]gono con dichos v\[EAcute]rtices, \
que es el que forma la figura correspondiente del icosaedro. "
}], "Text",
 CellChangeTimes->{{3.5408898382036963`*^9, 3.540889840139624*^9}, {
  3.540890018278067*^9, 3.540890127159273*^9}}],

Cell[TextData[{
 StyleBox["Paso 4:",
  FontWeight->"Bold"],
 " Concluimos que las caras que concurren en el v\[EAcute]rtice ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " tienen que ser las mismas que las del icosaedro. Igualmente se razona con \
los v\[EAcute]rtices ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y ",
 StyleBox["D",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellChangeTimes->{{3.540890128744069*^9, 3.5408901873097258`*^9}, {
  3.540890237674836*^9, 3.540890249815921*^9}}],

Cell[TextData[{
 StyleBox["Paso 5:",
  FontWeight->"Bold"],
 " Ahora es inmediato que la quinta cara que llega al v\[EAcute]rtice ",
 StyleBox["E",
  FontFamily->"Times",
  FontSize->18],
 " tiene que ser la del icosaedro."
}], "Text",
 CellChangeTimes->{{3.540890188047245*^9, 3.540890196487363*^9}, {
  3.540890227207943*^9, 3.540890236368587*^9}, {3.540890272834324*^9, 
  3.540890316022346*^9}}],

Cell[TextData[{
 StyleBox["Paso 6:",
  FontWeight->"Bold"],
 " Por \[UAcute]ltimo, las figuras de los v\[EAcute]rtices ",
 StyleBox["F, G, H, I, J",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " tienen que ser las mismas que las del icosaedro."
}], "Text",
 CellChangeTimes->{{3.54089031685676*^9, 3.540890408340296*^9}}],

Cell[TextData[{
 StyleBox["Paso 7:",
  FontWeight->"Bold"],
 " Por lo tanto, como le sucede al icosaedro, todas estas figuras comparten \
un mismo v\[EAcute]rtice com\[UAcute]n ",
 StyleBox["K",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " que cierra el poliedro y lo hace igual al icosaedro.  \
\[FilledSmallSquare]"
}], "Text",
 CellMargins->{{12, 10}, {16, 5}},
 CellChangeTimes->{{3.540883717447172*^9, 3.540883717449377*^9}, {
  3.540890598791484*^9, 3.5408906068377323`*^9}, {3.541011657927052*^9, 
  3.541011660944316*^9}}],

Cell["\<\
As\[IAcute] pues, hemos probado que si estamos dispuestos a restringirnos a \
poliedros simples, podr\[IAcute]amos haber definido un poliedro regular como \
un poliedro (simple) transitivo para v\[EAcute]rtices cuyas caras son pol\
\[IAcute]gonos regulares iguales. Esto basta para justificar que son s\
\[OAcute]lidos plat\[OAcute]nicos y, en particular regulares en el sentido \
fuerte. Veremos m\[AAcute]s adelante que la condici\[OAcute]n de \
transitividad para v\[EAcute]rtices se puede debilitar hasta el punto de no \
hacer referencia a simetr\[IAcute]as (teorema 4.10).\
\>", "Text",
 CellChangeTimes->{{3.541011614333733*^9, 3.541011614335202*^9}, {
   3.5410149256422567`*^9, 3.541015054950149*^9}, 3.541178504012538*^9, {
   3.541613489652829*^9, 3.541613494225947*^9}}],

Cell[TextData[StyleBox["EL GRAN DODECAEDRO",
 FontSize->18,
 FontColor->RGBColor[0, 0, 1]]], "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellMargins->{{100, 100}, {16, 18}},
 CellChangeTimes->{{3.538515429422391*^9, 3.538515429424019*^9}, {
  3.538517083097238*^9, 3.538517086760803*^9}, {3.538772137916774*^9, 
  3.5387721418334713`*^9}, {3.5389433492789*^9, 3.538943354615024*^9}, {
  3.538944083654379*^9, 3.538944088838513*^9}, {3.5391065561537533`*^9, 
  3.5391065641036177`*^9}, {3.539110603199396*^9, 3.5391106061050386`*^9}, {
  3.539114155036748*^9, 3.5391141567297077`*^9}, {3.5391190486065063`*^9, 
  3.5391190499503193`*^9}, {3.539191580022891*^9, 3.539191581987825*^9}, {
  3.539194702212619*^9, 3.539194706217629*^9}, {3.539198553615024*^9, 
  3.5391985588123913`*^9}, {3.539255753070822*^9, 3.539255755378742*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell["\<\
En la construcci\[OAcute]n del icosaedro hemos visto que cada v\[EAcute]rtice \
es el v\[EAcute]rtice de una pir\[AAcute]mide cuya base es un \
pent\[AAcute]gono regular, de modo que en el interior de cada icosaedro hay \
doce de estos pent\[AAcute]gonos. La figura siguiente permite destacarlos uno \
a uno para ver su disposici\[OAcute]n.\
\>", "Text",
 CellChangeTimes->{{3.539116768549533*^9, 3.5391167685512342`*^9}, {
  3.53919879899473*^9, 3.539198806030954*^9}, {3.5392557695740013`*^9, 
  3.539255854011682*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`c1$$ = False, $CellContext`c10$$ = 
    False, $CellContext`c11$$ = False, $CellContext`c12$$ = 
    True, $CellContext`c2$$ = False, $CellContext`c3$$ = 
    False, $CellContext`c4$$ = False, $CellContext`c5$$ = 
    False, $CellContext`c6$$ = False, $CellContext`c7$$ = 
    False, $CellContext`c8$$ = False, $CellContext`c9$$ = 
    False, $CellContext`ei$$ = False, $CellContext`t$$ = 
    0.05, $CellContext`ttt$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`t$$], 0.05, "Icosaedro"}, 0, 1}, {{
       Hold[$CellContext`ttt$$], 0, "Dodecaedro"}, 0, 1}, {{
       Hold[$CellContext`ei$$], False, "Esfera Inscrita"}, {True, False}}, {{
       Hold[$CellContext`c1$$], False}, {True, False}}, {{
       Hold[$CellContext`c2$$], False}, {True, False}}, {{
       Hold[$CellContext`c3$$], False}, {True, False}}, {{
       Hold[$CellContext`c4$$], False}, {True, False}}, {{
       Hold[$CellContext`c5$$], False}, {True, False}}, {{
       Hold[$CellContext`c6$$], False}, {True, False}}, {{
       Hold[$CellContext`c7$$], False}, {True, False}}, {{
       Hold[$CellContext`c8$$], False}, {True, False}}, {{
       Hold[$CellContext`c9$$], False}, {True, False}}, {{
       Hold[$CellContext`c10$$], False}, {True, False}}, {{
       Hold[$CellContext`c11$$], False}, {True, False}}, {
      Hold[$CellContext`c12$$], {True, False}}, {
      Hold[
       Grid[{{
          Button[
          "Ocultar todas las caras", {$CellContext`c1$$ = 
            False, $CellContext`c2$$ = False, $CellContext`c3$$ = 
            False, $CellContext`c4$$ = False, $CellContext`c5$$ = 
            False, $CellContext`c6$$ = False, $CellContext`c7$$ = 
            False, $CellContext`c8$$ = False, $CellContext`c9$$ = 
            False, $CellContext`c10$$ = False, $CellContext`c11$$ = 
            False, $CellContext`c12$$ = False}], 
          Button[
          "Mostrar todas las caras", {$CellContext`c1$$ = 
            True, $CellContext`c2$$ = True, $CellContext`c3$$ = 
            True, $CellContext`c4$$ = True, $CellContext`c5$$ = 
            True, $CellContext`c6$$ = True, $CellContext`c7$$ = 
            True, $CellContext`c8$$ = True, $CellContext`c9$$ = 
            True, $CellContext`c10$$ = True, $CellContext`c11$$ = 
            True, $CellContext`c12$$ = True}], 
          Button["Mostrar en ventana", 
           CreateWindow[
            DialogNotebook[
             Pane[
              Manipulate[
               Graphics3D[{{
                  Opacity[0], 
                  Sphere[]}, 
                 If[$CellContext`t$$ > 0, {
                   GrayLevel[0.6], 
                   Opacity[$CellContext`t$$], 
                   PolyhedronData["Icosahedron", "Faces"]}], 
                 If[$CellContext`ei$$, {
                   GrayLevel[0.6], 
                   
                   Sphere[{0, 0, 0}, 
                    PolyhedronData["Dodecahedron", "Inradius"]/
                    GoldenRatio^2]}], 
                 If[$CellContext`ttt$$ > 0, {
                   GrayLevel[0.6], 
                   Opacity[$CellContext`ttt$$], 
                   Scale[
                    PolyhedronData["Dodecahedron", "Faces"], 1/
                    GoldenRatio^2]}], {
                  GrayLevel[0.6], 
                  
                  GraphicsComplex[{{
                    0, 0, -(5/(50 - 10 5^Rational[1, 2])^Rational[1, 2])}, {
                    0, 0, 5/(50 - 10 5^Rational[1, 2])^
                    Rational[1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^
                    Rational[1, 2], 
                    0, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {(2/(5 - 
                    5^Rational[1, 2]))^Rational[1, 2], 0, 
                    1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2]}, {-((-1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (-(1/
                    2)) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                    Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2])}, {-((-1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (1/
                    2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                    Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2])}, {(-1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^
                    Rational[1, 2]), (-(1/2)) ((5 + 5^Rational[1, 2])/(5 - 5^
                    Rational[1, 2]))^Rational[1, 2], 
                    1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2]}, {(-1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), (1/
                    2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                    Rational[1, 2], 1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2]}, {-((1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), -(1/2), 
                    1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2]}, {-((1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), 1/2, 
                    1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2]}, {(1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), -(1/2), -(
                    1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {(1 + 
                    5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), 1/
                    2, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}}, 
                   Polygon[{
                    If[$CellContext`d1, {7, 9, 3, 1, 11}, {}], 
                    If[$CellContext`d2, {1, 3, 10, 8, 12}, {}], 
                    If[$CellContext`d3, {11, 1, 6, 8, 4}, {}], 
                    If[$CellContext`d4, {7, 5, 1, 12, 4}, {}], 
                    If[$CellContext`d5, {1, 5, 9, 10, 6}, {}], 
                    If[$CellContext`d6, {8, 6, 3, 9, 2}, {}], 
                    If[$CellContext`d7, {7, 2, 10, 3, 5}, {}], 
                    If[$CellContext`d8, {4, 2, 9, 5, 11}, {}], 
                    If[$CellContext`d9, {4, 12, 6, 10, 2}, {}], 
                    If[$CellContext`d10, {8, 2, 7, 11, 12}, {}], 
                    If[$CellContext`d11, {5, 3, 6, 12, 11}, {}], 
                    If[$CellContext`d12, {4, 8, 10, 9, 7}, {}]}]]}}, Lighting -> 
                "Neutral", Boxed -> False, ImageSize -> 
                400], {{$CellContext`t$$, 0.05, "Icosaedro"}, 0, 1, 
                AppearanceElements -> {}, ControlPlacement -> 
                Top}, {{$CellContext`ttt$$, 0, "Dodecaedro"}, 0, 1, 
                AppearanceElements -> {}, ControlPlacement -> 
                Top}, {{$CellContext`ei$$, False, "Esfera Inscrita"}, {
                True, False}, ControlPlacement -> 
                Top}, {{$CellContext`d1, False, "c1"}, {True, False}, 
                ControlPlacement -> Left}, {{$CellContext`d2, False, "c2"}, {
                True, False}, ControlPlacement -> 
                Left}, {{$CellContext`d3, False, "c3"}, {True, False}, 
                ControlPlacement -> Left}, {{$CellContext`d4, False, "c4"}, {
                True, False}, ControlPlacement -> 
                Left}, {{$CellContext`d5, False, "c5"}, {True, False}, 
                ControlPlacement -> Left}, {{$CellContext`d6, False, "c6"}, {
                True, False}, ControlPlacement -> 
                Left}, {{$CellContext`d7, False, "c7"}, {True, False}, 
                ControlPlacement -> Left}, {{$CellContext`d8, False, "c8"}, {
                True, False}, ControlPlacement -> 
                Left}, {{$CellContext`d9, False, "c9"}, {True, False}, 
                ControlPlacement -> 
                Left}, {{$CellContext`d10, False, "c10"}, {True, False}, 
                ControlPlacement -> 
                Left}, {{$CellContext`d11, False, "c11"}, {True, False}, 
                ControlPlacement -> Left}, {{$CellContext`d12, True, "c12"}, {
                True, False}, ControlPlacement -> Left}, 
               Button[
               "Ocultar todas las caras", {$CellContext`d1 = 
                 False, $CellContext`d2 = False, $CellContext`d3 = 
                 False, $CellContext`d4 = False, $CellContext`d5 = 
                 False, $CellContext`d6 = False, $CellContext`d7 = 
                 False, $CellContext`d8 = False, $CellContext`d9 = 
                 False, $CellContext`d10 = False, $CellContext`d11 = 
                 False, $CellContext`d12 = False}], 
               Button[
               "Mostrar todas las caras", {$CellContext`d1 = 
                 True, $CellContext`d2 = True, $CellContext`d3 = 
                 True, $CellContext`d4 = True, $CellContext`d5 = 
                 True, $CellContext`d6 = True, $CellContext`d7 = 
                 True, $CellContext`d8 = True, $CellContext`d9 = 
                 True, $CellContext`d10 = True, $CellContext`d11 = 
                 True, $CellContext`d12 = True}], AppearanceElements -> {}, 
               Paneled -> False], {500, 600}], WindowTitle -> 
             "El gran dodecaedro", WindowFloating -> "True", WindowFrame -> 
             "Palette", Selectable -> False]]]}}]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    360., {193., 198.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`t$3744$$ = 
    0, $CellContext`ttt$3745$$ = 0, $CellContext`ei$3746$$ = 
    False, $CellContext`c1$3747$$ = False, $CellContext`c2$3748$$ = 
    False, $CellContext`c3$3749$$ = False, $CellContext`c4$3750$$ = 
    False, $CellContext`c5$3751$$ = False, $CellContext`c6$3752$$ = 
    False, $CellContext`c7$3753$$ = False, $CellContext`c8$3754$$ = 
    False, $CellContext`c9$3755$$ = False, $CellContext`c10$3756$$ = 
    False, $CellContext`c11$3757$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`c1$$ = False, $CellContext`c10$$ = 
        False, $CellContext`c11$$ = False, $CellContext`c12$$ = 
        True, $CellContext`c2$$ = False, $CellContext`c3$$ = 
        False, $CellContext`c4$$ = False, $CellContext`c5$$ = 
        False, $CellContext`c6$$ = False, $CellContext`c7$$ = 
        False, $CellContext`c8$$ = False, $CellContext`c9$$ = 
        False, $CellContext`ei$$ = False, $CellContext`t$$ = 
        0.05, $CellContext`ttt$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$3744$$, 0], 
        Hold[$CellContext`ttt$$, $CellContext`ttt$3745$$, 0], 
        Hold[$CellContext`ei$$, $CellContext`ei$3746$$, False], 
        Hold[$CellContext`c1$$, $CellContext`c1$3747$$, False], 
        Hold[$CellContext`c2$$, $CellContext`c2$3748$$, False], 
        Hold[$CellContext`c3$$, $CellContext`c3$3749$$, False], 
        Hold[$CellContext`c4$$, $CellContext`c4$3750$$, False], 
        Hold[$CellContext`c5$$, $CellContext`c5$3751$$, False], 
        Hold[$CellContext`c6$$, $CellContext`c6$3752$$, False], 
        Hold[$CellContext`c7$$, $CellContext`c7$3753$$, False], 
        Hold[$CellContext`c8$$, $CellContext`c8$3754$$, False], 
        Hold[$CellContext`c9$$, $CellContext`c9$3755$$, False], 
        Hold[$CellContext`c10$$, $CellContext`c10$3756$$, False], 
        Hold[$CellContext`c11$$, $CellContext`c11$3757$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{{
          Opacity[0], 
          Sphere[]}, 
         If[$CellContext`t$$ > 0, {
           GrayLevel[0.6], 
           Opacity[$CellContext`t$$], 
           PolyhedronData["Icosahedron", "Faces"]}], 
         If[$CellContext`ei$$, {
           GrayLevel[0.6], 
           
           Sphere[{0, 0, 0}, PolyhedronData["Dodecahedron", "Inradius"]/
            GoldenRatio^2]}], 
         If[$CellContext`ttt$$ > 0, {
           GrayLevel[0.6], 
           Opacity[$CellContext`ttt$$], 
           Scale[
            PolyhedronData["Dodecahedron", "Faces"], 1/GoldenRatio^2]}], {
          GrayLevel[0.6], 
          
          GraphicsComplex[{{
            0, 0, -(5/(50 - 10 5^Rational[1, 2])^Rational[1, 2])}, {
            0, 0, 5/(50 - 10 5^Rational[1, 2])^
             Rational[1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
             0, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {(2/(5 - 5^
              Rational[1, 2]))^Rational[1, 2], 0, 1/(10 - 2 5^Rational[1, 2])^
             Rational[1, 2]}, {-((-1 + 5^Rational[1, 2])/(
              2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (-(1/
               2)) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
              Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
              Rational[1, 2])}, {-((-1 + 5^Rational[1, 2])/(
              2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (1/
              2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
              Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
              Rational[1, 2])}, {(-1 + 5^Rational[1, 2])/(
             2 (10 - 2 5^Rational[1, 2])^
              Rational[1, 2]), (-(1/2)) ((5 + 5^Rational[1, 2])/(5 - 5^
               Rational[1, 2]))^Rational[1, 2], 1/(10 - 2 5^Rational[1, 2])^
             Rational[1, 2]}, {(-1 + 5^Rational[1, 2])/(
             2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), (1/
              2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
              Rational[1, 2], 1/(10 - 2 5^Rational[1, 2])^
             Rational[1, 2]}, {-((1 + 5^Rational[1, 2])/(
              2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), -(1/2), 
             1/(10 - 2 5^Rational[1, 2])^
             Rational[1, 2]}, {-((1 + 5^Rational[1, 2])/(
              2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), 1/2, 
             1/(10 - 2 5^Rational[1, 2])^
             Rational[1, 2]}, {(1 + 5^Rational[1, 2])/(
             2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), -(1/2), -(
              1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {(1 + 
              5^Rational[1, 2])/(2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), 
             1/2, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}}, 
           Polygon[{
             If[$CellContext`c1$$, {7, 9, 3, 1, 11}, {}], 
             If[$CellContext`c2$$, {1, 3, 10, 8, 12}, {}], 
             If[$CellContext`c3$$, {11, 1, 6, 8, 4}, {}], 
             If[$CellContext`c4$$, {7, 5, 1, 12, 4}, {}], 
             If[$CellContext`c5$$, {1, 5, 9, 10, 6}, {}], 
             If[$CellContext`c6$$, {8, 6, 3, 9, 2}, {}], 
             If[$CellContext`c7$$, {7, 2, 10, 3, 5}, {}], 
             If[$CellContext`c8$$, {4, 2, 9, 5, 11}, {}], 
             If[$CellContext`c9$$, {4, 12, 6, 10, 2}, {}], 
             If[$CellContext`c10$$, {8, 2, 7, 11, 12}, {}], 
             If[$CellContext`c11$$, {5, 3, 6, 12, 11}, {}], 
             If[$CellContext`c12$$, {4, 8, 10, 9, 7}, {}]}]]}}, Lighting -> 
        "Neutral", Boxed -> False], 
      "Specifications" :> {{{$CellContext`t$$, 0.05, "Icosaedro"}, 0, 1, 
         AppearanceElements -> {}, ControlPlacement -> 
         Top}, {{$CellContext`ttt$$, 0, "Dodecaedro"}, 0, 1, 
         AppearanceElements -> {}, ControlPlacement -> 
         Top}, {{$CellContext`ei$$, False, "Esfera Inscrita"}, {True, False}, 
         ControlPlacement -> Top}, {{$CellContext`c1$$, False}, {True, False},
          ControlPlacement -> Left}, {{$CellContext`c2$$, False}, {
         True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c3$$, False}, {True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c4$$, False}, {True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c5$$, False}, {True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c6$$, False}, {True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c7$$, False}, {True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c8$$, False}, {True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c9$$, False}, {True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c10$$, False}, {True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c11$$, False}, {True, False}, ControlPlacement -> 
         Left}, {$CellContext`c12$$, {True, False}, ControlPlacement -> Left}, 
        Grid[{{
           Button[
           "Ocultar todas las caras", {$CellContext`c1$$ = 
             False, $CellContext`c2$$ = False, $CellContext`c3$$ = 
             False, $CellContext`c4$$ = False, $CellContext`c5$$ = 
             False, $CellContext`c6$$ = False, $CellContext`c7$$ = 
             False, $CellContext`c8$$ = False, $CellContext`c9$$ = 
             False, $CellContext`c10$$ = False, $CellContext`c11$$ = 
             False, $CellContext`c12$$ = False}], 
           Button[
           "Mostrar todas las caras", {$CellContext`c1$$ = 
             True, $CellContext`c2$$ = True, $CellContext`c3$$ = 
             True, $CellContext`c4$$ = True, $CellContext`c5$$ = 
             True, $CellContext`c6$$ = True, $CellContext`c7$$ = 
             True, $CellContext`c8$$ = True, $CellContext`c9$$ = 
             True, $CellContext`c10$$ = True, $CellContext`c11$$ = 
             True, $CellContext`c12$$ = True}], 
           Button["Mostrar en ventana", 
            CreateWindow[
             DialogNotebook[
              Pane[
               Manipulate[
                Graphics3D[{{
                   Opacity[0], 
                   Sphere[]}, 
                  If[$CellContext`t$$ > 0, {
                    GrayLevel[0.6], 
                    Opacity[$CellContext`t$$], 
                    PolyhedronData["Icosahedron", "Faces"]}], 
                  If[$CellContext`ei$$, {
                    GrayLevel[0.6], 
                    
                    Sphere[{0, 0, 0}, 
                    PolyhedronData["Dodecahedron", "Inradius"]/
                    GoldenRatio^2]}], 
                  If[$CellContext`ttt$$ > 0, {
                    GrayLevel[0.6], 
                    Opacity[$CellContext`ttt$$], 
                    Scale[
                    PolyhedronData["Dodecahedron", "Faces"], 1/
                    GoldenRatio^2]}], {
                   GrayLevel[0.6], 
                   
                   GraphicsComplex[{{
                    0, 0, -(5/(50 - 10 5^Rational[1, 2])^Rational[1, 2])}, {
                    0, 0, 5/(50 - 10 5^Rational[1, 2])^
                    Rational[1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^
                    Rational[1, 2], 
                    0, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {(2/(5 - 
                    5^Rational[1, 2]))^Rational[1, 2], 0, 
                    1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2]}, {-((-1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (-(1/
                    2)) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                    Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2])}, {-((-1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (1/
                    2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                    Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2])}, {(-1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^
                    Rational[1, 2]), (-(1/2)) ((5 + 5^Rational[1, 2])/(5 - 5^
                    Rational[1, 2]))^Rational[1, 2], 
                    1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2]}, {(-1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), (1/
                    2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                    Rational[1, 2], 1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2]}, {-((1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), -(1/2), 
                    1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2]}, {-((1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), 1/2, 
                    1/(10 - 2 5^Rational[1, 2])^
                    Rational[1, 2]}, {(1 + 5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), -(1/2), -(
                    1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {(1 + 
                    5^Rational[1, 2])/(
                    2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), 1/
                    2, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}}, 
                    Polygon[{
                    If[$CellContext`d1, {7, 9, 3, 1, 11}, {}], 
                    If[$CellContext`d2, {1, 3, 10, 8, 12}, {}], 
                    If[$CellContext`d3, {11, 1, 6, 8, 4}, {}], 
                    If[$CellContext`d4, {7, 5, 1, 12, 4}, {}], 
                    If[$CellContext`d5, {1, 5, 9, 10, 6}, {}], 
                    If[$CellContext`d6, {8, 6, 3, 9, 2}, {}], 
                    If[$CellContext`d7, {7, 2, 10, 3, 5}, {}], 
                    If[$CellContext`d8, {4, 2, 9, 5, 11}, {}], 
                    If[$CellContext`d9, {4, 12, 6, 10, 2}, {}], 
                    If[$CellContext`d10, {8, 2, 7, 11, 12}, {}], 
                    If[$CellContext`d11, {5, 3, 6, 12, 11}, {}], 
                    If[$CellContext`d12, {4, 8, 10, 9, 7}, {}]}]]}}, Lighting -> 
                 "Neutral", Boxed -> False, ImageSize -> 
                 400], {{$CellContext`t$$, 0.05, "Icosaedro"}, 0, 1, 
                 AppearanceElements -> {}, ControlPlacement -> 
                 Top}, {{$CellContext`ttt$$, 0, "Dodecaedro"}, 0, 1, 
                 AppearanceElements -> {}, ControlPlacement -> 
                 Top}, {{$CellContext`ei$$, False, "Esfera Inscrita"}, {
                 True, False}, ControlPlacement -> 
                 Top}, {{$CellContext`d1, False, "c1"}, {True, False}, 
                 ControlPlacement -> Left}, {{$CellContext`d2, False, "c2"}, {
                 True, False}, ControlPlacement -> 
                 Left}, {{$CellContext`d3, False, "c3"}, {True, False}, 
                 ControlPlacement -> Left}, {{$CellContext`d4, False, "c4"}, {
                 True, False}, ControlPlacement -> 
                 Left}, {{$CellContext`d5, False, "c5"}, {True, False}, 
                 ControlPlacement -> Left}, {{$CellContext`d6, False, "c6"}, {
                 True, False}, ControlPlacement -> 
                 Left}, {{$CellContext`d7, False, "c7"}, {True, False}, 
                 ControlPlacement -> Left}, {{$CellContext`d8, False, "c8"}, {
                 True, False}, ControlPlacement -> 
                 Left}, {{$CellContext`d9, False, "c9"}, {True, False}, 
                 ControlPlacement -> 
                 Left}, {{$CellContext`d10, False, "c10"}, {True, False}, 
                 ControlPlacement -> 
                 Left}, {{$CellContext`d11, False, "c11"}, {True, False}, 
                 ControlPlacement -> 
                 Left}, {{$CellContext`d12, True, "c12"}, {True, False}, 
                 ControlPlacement -> Left}, 
                Button[
                "Ocultar todas las caras", {$CellContext`d1 = 
                  False, $CellContext`d2 = False, $CellContext`d3 = 
                  False, $CellContext`d4 = False, $CellContext`d5 = 
                  False, $CellContext`d6 = False, $CellContext`d7 = 
                  False, $CellContext`d8 = False, $CellContext`d9 = 
                  False, $CellContext`d10 = False, $CellContext`d11 = 
                  False, $CellContext`d12 = False}], 
                Button[
                "Mostrar todas las caras", {$CellContext`d1 = 
                  True, $CellContext`d2 = True, $CellContext`d3 = 
                  True, $CellContext`d4 = True, $CellContext`d5 = 
                  True, $CellContext`d6 = True, $CellContext`d7 = 
                  True, $CellContext`d8 = True, $CellContext`d9 = 
                  True, $CellContext`d10 = True, $CellContext`d11 = 
                  True, $CellContext`d12 = True}], AppearanceElements -> {}, 
                Paneled -> False], {500, 600}], WindowTitle -> 
              "El gran dodecaedro", WindowFloating -> "True", WindowFrame -> 
              "Palette", Selectable -> False]]]}}]}, 
      "Options" :> {AppearanceElements -> {}}, "DefaultOptions" :> {}],
     ImageSizeCache->{501., {271., 277.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.5413597026568403`*^9, 3.541359743615446*^9, 3.541359779755516*^9, 
   3.541359913319497*^9, 3.541359962073985*^9, 3.5413600748268433`*^9, 
   3.541360140593095*^9, 3.5413602083653517`*^9, 3.541938752390044*^9, {
   3.54193881288807*^9, 3.5419388455300837`*^9}, 3.545595969503456*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Ahora bien, si hacemos visibles todos los pent\[AAcute]gonos y ocultamos el \
icosaedro nos encontraremos con un nuevo poliedro, conocido como ",
 StyleBox["gran dodecaedro,",
  FontSlant->"Italic"],
 " y que consta de ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 12",
  FontFamily->"Times"],
 " caras pentagonales, ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 30",
  FontFamily->"Times"],
 " aristas y ",
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 12",
  FontFamily->"Times"],
 " v\[EAcute]rtices, a cada uno de los cuales concurren ",
 StyleBox["5",
  FontFamily->"Times"],
 " aristas. Observemos que, ciertamente, el gran dodecaedro cumple todos los \
requisitos que exige la definici\[OAcute]n de poliedro que hemos dado: cada \
arista pertenece exactamente a dos caras, se puede pasar de cualquier cara a \
cualquier otra por una cadena de caras contiguas y las diez aristas que \
concurren en un v\[EAcute]rtice pueden disponerse c\[IAcute]clicamente de \
forma que cada par de aristas consecutivas comparten cara. M\[AAcute]s a\
\[UAcute]n, es f\[AAcute]cil ver que las simetr\[IAcute]as del icosaedro son \
tambi\[EAcute]n simetr\[IAcute]as del gran dodecaedro, y son suficientes para \
justificar que es regular. Eso s\[IAcute], no es un poliedro simple, sino que \
sus caras tienen autointersecciones."
}], "Text",
 CellChangeTimes->{{3.5392536522497168`*^9, 3.539253652251524*^9}, {
  3.539255900286564*^9, 3.539255902067721*^9}, {3.539256012253956*^9, 
  3.539256141093886*^9}, {3.539256224558386*^9, 3.539256224806628*^9}, {
  3.539256318338215*^9, 3.5392565018570127`*^9}, {3.541015321906722*^9, 
  3.541015358310136*^9}, {3.5411785635499983`*^9, 3.541178571588675*^9}}],

Cell["\<\
Para comprender la estructura de cada v\[EAcute]rtice conviene seleccionar en \
la figura las cinco primeras caras, todas las cuales tienen un mismo v\
\[EAcute]rtice en com\[UAcute]n. La forma en que se disponen se aprecia mejor \
si mostramos tambi\[EAcute]n la cara n\[UAcute]mero 11. As\[IAcute] se ve c\
\[OAcute]mo las cinco caras concurrentes cortan a la und\[EAcute]cima a trav\
\[EAcute]s de los lados de su pentagrama, de modo que dos caras son contiguas \
si y s\[OAcute]lo si sus cortes con la cara und\[EAcute]cima son lados \
contiguos del pentagrama.\
\>", "Text",
 CellChangeTimes->{{3.539256503056526*^9, 3.5392567011284237`*^9}}],

Cell["\<\
Si miramos el v\[EAcute]rtice por el extremo opuesto veremos que las cinco \
caras que concurren en \[EAcute]l forman la superficie lateral de una pir\
\[AAcute]mide pentagonal (para verla entera hay que ocultar la cara und\
\[EAcute]cima) cuya base es otra de las caras del gran dodecaedro (la duod\
\[EAcute]cima en la figura).\
\>", "Text",
 CellChangeTimes->{{3.539256701370339*^9, 3.539256778412038*^9}, {
  3.53925680872648*^9, 3.539256821933805*^9}}],

Cell["\<\
La cara und\[EAcute]cima trunca la pir\[AAcute]mide y le pone una cara \
superior pentagonal. El pent\[AAcute]gono es precisamente el \
pent\[AAcute]gono central de su pentagrama. Los doce pent\[AAcute]gonos \
centrales de las doce caras forman un dodecaedro que puede hacerse visible en \
la figura con el control correspondiente. Su disposici\[OAcute]n se aprecia \
claramente mostrando todas las caras excepto la octava, la d\[EAcute]cima y \
la duod\[EAcute]cima. La esfera inscrita en el dodecaedro central es tambi\
\[EAcute]n la esfera inscrita al gran dodecaedro, y tambi\[EAcute]n puede \
hacerse visible en la figura.\
\>", "Text",
 CellChangeTimes->{{3.539257014533236*^9, 3.5392570404303417`*^9}, {
  3.539257076625004*^9, 3.539257077086835*^9}}],

Cell["\<\
Puesto que la arista y el radio del gran dodecaedro coinciden con los del \
icosaedro, sabemos que su relaci\[OAcute]n es:\
\>", "Text",
 CellChangeTimes->{{3.539253652393708*^9, 3.539253652395371*^9}, {
  3.539293227539317*^9, 3.539293260445516*^9}, {3.5392933825591593`*^9, 
  3.539293383726692*^9}}],

Cell[BoxData[
 StyleBox["\<\"\\!\\(\\*\\nStyleBox[\\\"R\\\",\\nFontSize->18,\\nFontWeight->\
\\\"Plain\\\",\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\" \\\",\
\\nFontWeight->\\\"Plain\\\",\\nFontSlant->\\\"Italic\\\"]\\)= \
\\!\\(\\*FractionBox[\\(\\(1\\)\\(\\\\ \\)\\), \
\\(2\\)]\\)\\!\\(\\*SqrtBox[FractionBox[\\(5 + \\*SqrtBox[\\(5\\)]\\), \
\\(2\\)]]\\)\\!\\(\\*\\nStyleBox[\\\"l\\\",\\nFontSize->18,\\nFontWeight->\\\"\
Plain\\\",\\nFontSlant->\\\"Italic\\\"]\\).\"\>",
  StripOnInput->False,
  FontFamily->"Times",
  FontSize->14]], "Output",
 CellChangeTimes->{3.53938096735052*^9, 3.539381180524302*^9},
 TextAlignment->Center],

Cell[TextData[{
 "En cuanto al inradio, es el del dodecaedro interior, cuya arista es la del \
pent\[AAcute]gono interno de los pentagramas, cuyo lado mide ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "/",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[CapitalPhi]", "2"], TraditionalForm]]],
 ", luego es"
}], "Text",
 CellChangeTimes->{{3.539293312591041*^9, 3.5392933367182693`*^9}, {
  3.539293375303507*^9, 3.539293417607052*^9}, {3.539293468786478*^9, 
  3.539293468927682*^9}, {3.539460855204125*^9, 3.53946086360968*^9}}],

Cell[BoxData[
 StyleBox["\<\"\\!\\(\\*\\nStyleBox[\\\"r\\\",\\nFontSize->18,\\nFontWeight->\
\\\"Plain\\\",\\nFontSlant->\\\"Italic\\\"]\\) = \
\\!\\(\\*FractionBox[\\(1\\), SuperscriptBox[\\(\[CapitalPhi]\\), \
\\(2\\)]]\\)\\!\\(\\*SqrtBox[FractionBox[\\(25 + 11 \\*SqrtBox[\\(5\\)]\\), \
\\(40\\)]]\\)\\!\\(\\*\\nStyleBox[\\\"l\\\",\\nFontSize->18,\\nFontWeight->\\\
\"Plain\\\",\\nFontSlant->\\\"Italic\\\"]\\) = \
\\!\\(\\*FractionBox[\\(\\(1\\)\\(\\\\ \\)\\), \
\\(4\\)]\\)\\!\\(\\*SqrtBox[FractionBox[\\(10 + 2 \\*SqrtBox[\\(5\\)]\\), \
\\(5\\)]]\\)\\!\\(\\*\\nStyleBox[\\\"l\\\",\\nFontSize->18,\\nFontWeight->\\\"\
Plain\\\",\\nFontSlant->\\\"Italic\\\"]\\).\"\>",
  StripOnInput->False,
  FontFamily->"Times",
  FontSize->14]], "Output",
 CellChangeTimes->{{3.5393810895766697`*^9, 3.539381132715028*^9}},
 TextAlignment->Center],

Cell["\<\
Si interpretamos como \[AAcute]rea del gran dodecaedro la suma de las \
\[AAcute]reas de sus doce caras, entonces \[EAcute]sta es igual a\
\>", "Text",
 CellChangeTimes->{{3.5392933133413553`*^9, 3.539293313343088*^9}, {
  3.539294239714428*^9, 3.539294258603269*^9}}],

Cell[TextData[{
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     StyleBox["=",
      FontSize->18], 
     RowBox[{
      StyleBox["15",
       FontSize->14], 
      StyleBox[
       SqrtBox[
        FractionBox[
         RowBox[{"5", "+", 
          RowBox[{"2", 
           SqrtBox["5"]}]}], "5"]],
       FontSize->18]}]}],
    FontFamily->"Times"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["l",
     FontFamily->"Times",
     FontSize->18], "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " = ",
 StyleBox["3",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{
     StyleBox["25",
      FontFamily->"Times"], 
     StyleBox["+",
      FontFamily->"Times"], 
     RowBox[{
      StyleBox["10",
       FontFamily->"Times"], 
      SqrtBox[
       StyleBox["5",
        FontFamily->"Times",
        FontSlant->"Plain"]]}]}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["l",
     FontFamily->"Times",
     FontSize->18], "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ","
}], "Text",
 CellChangeTimes->{{3.5392942593995667`*^9, 3.539294347578714*^9}, {
  3.539294406595583*^9, 3.539294428930408*^9}, {3.539296322232689*^9, 
  3.5392963746015387`*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "aunque tambi\[EAcute]n podemos calcular el \[AAcute]rea de la superficie \
\[OpenCurlyDoubleQuote]real\[CloseCurlyDoubleQuote] del gran dodecadedro, es \
decir, consider\[AAcute]ndolo como un poliedro esferoide formado por ",
 StyleBox["60",
  FontFamily->"Times"],
 " caras triangulares, ",
 StyleBox["90",
  FontFamily->"Times"],
 " aristas y ",
 StyleBox["32",
  FontFamily->"Times"],
 " v\[EAcute]rtices. En tal caso, cada cara es un tri\[AAcute]ngulo \
\[AAcute]ureo, con un lado de longitud ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y otros dos lados de longitud ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "/\[CapitalPhi]. Por lo tanto, su \[AAcute]rea es"
}], "Text",
 CellChangeTimes->{{3.539294430944564*^9, 3.5392944729861317`*^9}, {
  3.539294552101862*^9, 3.539294666212308*^9}, {3.539295157044759*^9, 
  3.539295165612797*^9}}],

Cell[BoxData[
 StyleBox["\<\"\\!\\(\\*\\nStyleBox[\\\"S\\\",\\nFontFamily->\\\"Times\\\",\\\
nFontSize->18,\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\" \\\",\
\\nFontFamily->\\\"Times\\\",\\nFontSize->18,\\nFontSlant->\\\"Italic\\\"]\\)\
\\!\\(\\*\\nStyleBox[\\\"=\\\",\\nFontFamily->\\\"Times\\\",\\nFontSize->18]\\\
)\\!\\(\\*\\nStyleBox[\\\" \\\",\\nFontFamily->\\\"Times\\\",\\nFontSize->18,\
\\nFontSlant->\\\"Italic\\\"]\\)\\!\\(\\*\\nStyleBox[\\\"60\\\",\\nFontFamily-\
>\\\"Times\\\"]\\)\\!\\(\\*\\nStyleBox[\\\" \
\\\",\\nFontFamily->\\\"Times\\\"]\\)\\!\\(\\*FormBox[FractionBox[\\n  \
StyleBox[\\n   RowBox[{\\n    StyleBox[\\\"sen\\\",\\nFontSize->18], \\n    \
StyleBox[\\\"[\\\",\\nFontSize->18], \\n    \
StyleBox[\\\"36\\\",\\nFontSize->14], \\n    \
StyleBox[\\\"]\\\",\\nFontSize->18]}],\\nFontFamily->\\\"Times\\\"], \\n  \
StyleBox[\\n   RowBox[{\\n    \
StyleBox[\\\"2\\\",\\nFontFamily->\\\"Times\\\"], \\n    StyleBox[\\\"\
\[CapitalPhi]\\\",\\nFontSlant->\\\"Plain\\\"]}],\\nFontSize->14]],\\n \
TraditionalForm]\\)\\!\\(\\*FormBox[\\n StyleBox[SuperscriptBox[\\\"l\\\", \\\
\"2\\\"],\\nFontFamily->\\\"Times\\\",\\nFontSize->18,\\nFontSlant->\\\"\
Italic\\\"],\\n TraditionalForm]\\) = \\!\\(\\*FormBox[\\n RowBox[{\\n  \
StyleBox[\\\"15\\\",\\nFontFamily->\\\"Times\\\"], SqrtBox[\\n   StyleBox[\\n \
   RowBox[{\\n     StyleBox[\\\"5\\\",\\nFontSlant->\\\"Plain\\\"], \\n     \
StyleBox[\\\"-\\\",\\nFontSlant->\\\"Plain\\\"], \\n     RowBox[{\\\"2\\\", \
SqrtBox[\\\"5\\\"]}]}],\\nFontFamily->\\\"Times\\\",\\nFontSize->14]]}],\\n \
TraditionalForm]\\)\\!\\(\\*FormBox[\\n StyleBox[SuperscriptBox[\\\"l\\\", \\\
\"2\\\"],\\nFontFamily->\\\"Times\\\",\\nFontSize->18,\\nFontSlant->\\\"\
Italic\\\"],\\n TraditionalForm]\\).\"\>",
  StripOnInput->False,
  FontFamily->"Times",
  FontSize->14]], "Output",
 CellChangeTimes->{{3.5486102280718937`*^9, 3.548610248775468*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Para calcular el volumen podemos ver al gran dodecaedro como el resultado \
de quitarle al icosaedro ",
 StyleBox["20",
  FontFamily->"Times"],
 " pir\[AAcute]mides con base un tri\[AAcute]ngulo equil\[AAcute]tero de lado \
",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y cuyas caras laterales son tri\[AAcute]ngulos is\[OAcute]sceles con un \
lado igual a ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y los otros dos iguales a ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "/\[CapitalPhi]. Es f\[AAcute]cil ver entonces que la altura de la pir\
\[AAcute]mide es"
}], "Text",
 CellChangeTimes->{{3.539295527391593*^9, 3.539295532941041*^9}, {
  3.5392961958384237`*^9, 3.53929619584155*^9}, {3.539375892356688*^9, 
  3.539375925475872*^9}, {3.539376019013217*^9, 3.5393761554180193`*^9}}],

Cell[BoxData[
 StyleBox["\<\"\\!\\(\\*\\nStyleBox[\\\"h\\\",\\nFontFamily->\\\"Times\\\",\\\
nFontSize->18,\\nFontSlant->\\\"Italic\\\"]\\) = \
\\!\\(TraditionalForm\\`\\*SqrtBox[\\(\\*FractionBox[\\(1\\), SuperscriptBox[\
\\(\[CapitalPhi]\\), \\(2\\)]] - \\*FractionBox[\\(1\\), \
\\(3\\)]\\)]\\)\\!\\(\\*\\nStyleBox[\\\"l\\\",\\nFontFamily->\\\"Times\\\",\\\
nFontSize->18,\\nFontSlant->\\\"Italic\\\"]\\) = \\!\\(\\*FormBox[SqrtBox[\\n \
 StyleBox[FractionBox[\\n    RowBox[{\\\"7\\\", \\\"-\\\", \\n     RowBox[{\\\
\"3\\\", SqrtBox[\\\"5\\\"]}]}], \
\\\"6\\\"],\\nFontFamily->\\\"Times\\\"]],\\n \
TraditionalForm]\\)\\!\\(\\*\\nStyleBox[\\\"l\\\",\\nFontFamily->\\\"Times\\\"\
,\\nFontSize->18,\\nFontSlant->\\\"Italic\\\"]\\) = \
\\!\\(TraditionalForm\\`\\*SqrtBox[FractionBox[\\(1\\), \\(3 \
\\*SuperscriptBox[\\(\[CapitalPhi]\\), \
\\(4\\)]\\)]]\\)\\!\\(\\*\\nStyleBox[\\\"l\\\",\\nFontFamily->\\\"Times\\\",\\\
nFontSize->18,\\nFontSlant->\\\"Italic\\\"]\\) = \
\\!\\(\\*FormBox[FractionBox[\\n  StyleBox[\\\"l\\\",\\nFontFamily->\\\"Times\
\\\",\\nFontSize->18], \\n  RowBox[{\\n   StyleBox[SqrtBox[\\n     \
StyleBox[\\\"3\\\",\\nFontFamily->\\\"Times\\\",\\nFontSlant->\\\"Plain\\\"]],\
\\nFontSize->13], SuperscriptBox[\\n    \
StyleBox[\\\"\[CapitalPhi]\\\",\\nFontSize->13,\\nFontSlant->\\\"Plain\\\"], \
\\n    StyleBox[\\\"2\\\",\\nFontFamily->\\\"Times\\\",\\nFontSize->9,\\\
nFontSlant->\\\"Plain\\\"]]}]],\\n TraditionalForm]\\).\"\>",
  StripOnInput->False,
  FontFamily->"Times",
  FontSize->14]], "Output",
 CellChangeTimes->{3.539380733687789*^9},
 TextAlignment->Center],

Cell["\<\
Por lo tanto, el volumen del gran dodecaedro es:\
\>", "Text",
 CellChangeTimes->{{3.539296196795714*^9, 3.539296217828491*^9}, {
  3.5393763792803183`*^9, 3.53937639199432*^9}}],

Cell[BoxData[
 StyleBox["\<\"V = \\!\\(\\*FractionBox[\\(5 \\*SuperscriptBox[\\(\
\[CapitalPhi]\\), \\(2\\)]\\), \\(6\\)]\\)\\!\\(\\*SuperscriptBox[\\n \
StyleBox[\\\"l\\\",\\nFontSize->18,\\nFontWeight->\\\"Plain\\\",\\nFontSlant->\
\\\"Italic\\\"], \\\"3\\\"]\\) - 20 \\!\\(\\*FractionBox[\\(1\\), \\(3\\)]\\)\
\\!\\(\\*FractionBox[\\(\\*SqrtBox[\\(3\\)]\\(\\\\ \\)\\), \
\\(4\\)]\\)\\!\\(\\*FractionBox[\\n RowBox[{\\\" \\\", SuperscriptBox[\\n   \
StyleBox[\\\"l\\\",\\nFontSize->18,\\nFontWeight->\\\"Plain\\\",\\nFontSlant->\
\\\"Italic\\\"], \\\"3\\\"]}], \\n RowBox[{SqrtBox[\\\"3\\\"], \
SuperscriptBox[\\\"\[CapitalPhi]\\\", \\\"2\\\"]}]]\\) = \
\\!\\(\\*FractionBox[\\(5\\), \\(4\\)]\\)(\\!\\(\\*SqrtBox[\\(5\\)]\\)-1) \\!\
\\(\\*SuperscriptBox[\\n StyleBox[\\\"l\\\",\\nFontSize->18,\\nFontWeight->\\\
\"Plain\\\",\\nFontSlant->\\\"Italic\\\"], \\\"3\\\"]\\)\"\>",
  StripOnInput->False,
  FontFamily->"Times",
  FontSize->14]], "Output",
 CellChangeTimes->{3.548610316888524*^9},
 TextAlignment->Center],

Cell["\<\
Para calcular el \[AAcute]ngulo di\[EAcute]drico observamos la figura \
siguiente:\
\>", "Text",
 CellChangeTimes->{{3.539376392352062*^9, 3.539376392353943*^9}, {
  3.539379982720923*^9, 3.539379994102384*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0.7], Opacity[0], 
    GraphicsComplex3DBox[
     NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
       0, 0, 5 (50 - 10 5^Rational[1, 2])^
         Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
        0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
         Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
        Rational[-1, 2]}, {(
         Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
         5^Rational[1, 2]), 
        Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
         Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
         5^Rational[1, 2]), Rational[
        1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
         Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
         5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
        Rational[-1, 2]}, {(
         Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
         5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
        Rational[-1, 2]}, {(
         Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
         5^Rational[1, 2]), 
        Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
         Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
         5^Rational[1, 2]), 
        Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
         Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
         5^Rational[1, 2]), 
        Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], (10 - 2 5^Rational[1, 2])^
        Rational[-1, 2]}, {(
         Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
         5^Rational[1, 2]), 
        Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
       0, 0, -0.9510565162951536}, {
       0, 0, 0.9510565162951536}, {-0.85065080835204, 
        0, -0.42532540417601994`}, {
       0.85065080835204, 0, 0.42532540417601994`}, {
       0.6881909602355868, -0.5, -0.42532540417601994`}, {0.6881909602355868, 
       0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
       0.42532540417601994`}, {-0.6881909602355868, 0.5, 
       0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
       0.8090169943749475, -0.42532540417601994`}, {
       0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
       0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
     Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 
      12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 10, 
      8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 9}, {6, 4, 
      5}, {10, 12, 6}, {3, 8, 10}, {9, 7, 3}}]]}, 
   GraphicsComplex3DBox[
    NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
      0, 0, 5 (50 - 10 5^Rational[1, 2])^
        Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
       0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
        Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {(
        Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
        Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
        5^Rational[1, 2]), 
       Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {(
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
        5^Rational[1, 2]), 
       Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
        Rational[1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {(
        Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
        5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {(
        Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
        5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
       Rational[-1, 2]}, {(
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
        5^Rational[1, 2]), 
       Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
        5^Rational[1, 2]), Rational[
       1, 2], -(10 - 2 5^Rational[1, 2])^
        Rational[-1, 2]}, {-(2 (5 - 5^Rational[1, 2]))^Rational[-1, 2], 0, 
       Rational[
        1, 2] ((-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2] - (10 - 2 
         5^Rational[1, 2])^Rational[-1, 2])}}, {{0, 0, -0.9510565162951536}, {
      0, 0, 0.9510565162951536}, {-0.85065080835204, 
       0, -0.42532540417601994`}, {
      0.85065080835204, 0, 
       0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
      0.8090169943749475, -0.42532540417601994`}, {
      0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
      0.2628655560595668, 0.8090169943749475, 
      0.42532540417601994`}, {-0.6881909602355868, -0.5, 
      0.42532540417601994`}, {-0.6881909602355868, 0.5, 
      0.42532540417601994`}, {
      0.6881909602355868, -0.5, -0.42532540417601994`}, {0.6881909602355868, 
      0.5, -0.42532540417601994`}, {-0.42532540417601994`, 
       0, -0.6881909602355868}}], 
    {GrayLevel[0.7], Polygon3DBox[{{7, 9, 3, 1, 11}, {1, 3, 10, 8, 12}}], 
     Polygon3DBox[{7, 8, 13, 7}]}]},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{372.42067115305565`, 325.0793768586896},
  Lighting->"Neutral",
  ViewPoint->{2.8667473103229812`, 0.8815937695867602, 1.5667010832260744`},
  ViewVertical->{0.6135462713414226, -0.68432300770473, 
   0.5999876477500121}]], "Output",
 CellChangeTimes->{3.539380023992807*^9},
 TextAlignment->Center],

Cell[TextData[{
 "El tri\[AAcute]ngulo tiene al \[AAcute]ngulo di\[EAcute]drico por uno de \
sus \[AAcute]ngulos. Si suponemos que el icosaedro tiene lado unitario, \
entonces el lado opuesto al \[AAcute]ngulo di\[EAcute]drico mide \
\[CapitalPhi] (porque es la diagonal de uno de los pent\[AAcute]gonos de lado \
",
 StyleBox["1",
  FontFamily->"Times"],
 "), y los otros dos lados miden \[CapitalPhi] cos[",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["18",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 "], de donde es f\[AAcute]cil deducir el seno de la mitad del \[AAcute]ngulo \
di\[EAcute]drico y de ah\[IAcute] su coseno. La tabla siguiente resume lo que \
hemos obtenido:"
}], "Text",
 CellChangeTimes->{{3.5393800616155853`*^9, 3.539380216857937*^9}, {
  3.5394658802240667`*^9, 3.5394658876220827`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Radio\"\>", "\<\"Inradio\"\>", "\<\"Volumen\"\>", "\<\"\
\[CapitalAAcute]rea\"\>", "\<\"\[CapitalAAcute]ngulo di\[EAcute]drico\"\>"},
    {
     StyleBox["\<\"\\!\\(\\*FormBox[\\n RowBox[{FractionBox[\\\"1\\\", \
\\\"2\\\"], SqrtBox[\\n   StyleBox[FractionBox[\\n     RowBox[{\\\"5\\\", \
\\\"+\\\", SqrtBox[\\\"5\\\"]}], \\\"2\\\"],\\nFontSize->18]]}],\\n \
TraditionalForm]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(1\\), \\(4\\)]\\)\\!\\(\\*SqrtBox[\
\\n StyleBox[FractionBox[\\n   RowBox[{\\\"10\\\", \\\"+\\\", \\n    RowBox[{\
\\\"2\\\", SqrtBox[\\\"5\\\"]}]}], \\\"5\\\"],\\nFontSize->18]]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(5\\), \
\\(4\\)]\\)(\\!\\(\\*FormBox[SqrtBox[\\n  \
StyleBox[\\\"5\\\",\\nFontFamily->\\\"Times\\\",\\nFontSlant->\\\"Plain\\\"]],\
\\n TraditionalForm]\\)-\\!\\(\\*\\nStyleBox[\\\"1\\\",\\nFontFamily->\\\"\
Times\\\"]\\))\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FormBox[\\n RowBox[{\\n  \
StyleBox[\\\"15\\\",\\nFontFamily->\\\"Times\\\"], SqrtBox[\\n   StyleBox[\\n \
   RowBox[{\\n     StyleBox[\\\"5\\\",\\nFontSlant->\\\"Plain\\\"], \\n     \
StyleBox[\\\"-\\\",\\nFontSlant->\\\"Plain\\\"], \\n     RowBox[{\\\"2\\\", \
SqrtBox[\\\"5\\\"]}]}],\\nFontFamily->\\\"Times\\\",\\nFontSize->14]]}],\\n \
TraditionalForm]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], 
     StyleBox["\<\"arccos[\\!\\(\\*FractionBox[SqrtBox[\\(5\\)], \\(5\\)]\\)]\
\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18]}
   },
   AutoDelete->False,
   GridBoxDividers->{
    "Columns" -> {False, True, True, True, True}, "Rows" -> {False, True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.539380241164668*^9, 3.5393802714111233`*^9, {3.5393803081606894`*^9, 
   3.5393803248635397`*^9}, {3.539380371143836*^9, 3.53938040344543*^9}},
 TextAlignment->Center],

Cell[TextData[StyleBox["EL PEQUE\[CapitalNTilde]O DODECAEDRO ESTRELLADO",
 FontSize->18,
 FontColor->RGBColor[0, 0, 1]]], "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellMargins->{{100, 100}, {16, 18}},
 CellChangeTimes->{{3.538515429422391*^9, 3.538515429424019*^9}, {
  3.538517083097238*^9, 3.538517086760803*^9}, {3.538772137916774*^9, 
  3.5387721418334713`*^9}, {3.5389433492789*^9, 3.538943354615024*^9}, {
  3.538944083654379*^9, 3.538944088838513*^9}, {3.5391065561537533`*^9, 
  3.5391065641036177`*^9}, {3.539110603199396*^9, 3.5391106061050386`*^9}, {
  3.539114155036748*^9, 3.5391141567297077`*^9}, {3.5391190486065063`*^9, 
  3.5391190499503193`*^9}, {3.539191580022891*^9, 3.539191581987825*^9}, {
  3.539194702212619*^9, 3.539194706217629*^9}, {3.539198553615024*^9, 
  3.5391985588123913`*^9}, {3.539255753070822*^9, 3.539255755378742*^9}, {
  3.539381764243767*^9, 3.539381768720518*^9}, {3.539468599133072*^9, 
  3.539468603074017*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "Vamos a construir el poliedro dual del gran dodecaedro, que ser\[AAcute] \
otro poliedro regular. Tiene ",
 StyleBox["12",
  FontFamily->"Times"],
 " v\[EAcute]rtices, que son los centros de las ",
 StyleBox["12",
  FontFamily->"Times"],
 " caras del gran dodecaedro, y tambi\[EAcute]n los centros de las ",
 StyleBox["12",
  FontFamily->"Times"],
 " caras del peque\[NTilde]o dodecaedro (convexo) contenido en su interior. \
De cada v\[EAcute]rtice salen cinco aristas que llegan a los centros de las \
cinco caras contiguas, pero no contiguas en el peque\[NTilde]o dodecaedro, \
sino en el gran dodecaedro. Para ver cu\[AAcute]les son conviene mostrar en \
la figura interactiva del gran dodecaedro las caras ",
 StyleBox["1, 2, 3, 4, 5",
  FontFamily->"Times"],
 " y ",
 StyleBox["12,",
  FontFamily->"Times"],
 " junto con el peque\[NTilde]o dodecaedro central. Las cinco primeras son \
las caras contiguas a la duod\[EAcute]cima. Si ocultamos \[EAcute]sta \
\[UAcute]ltima y nos fijamos en las caras del peque\[NTilde]o dodecaedro que \
contienen a las otras cinco, vemos que son las cinco caras que est\[AAcute]n \
a \[OpenCurlyDoubleQuote]dos caras de distancia\[CloseCurlyDoubleQuote] de la \
cara duod\[EAcute]cima. As\[IAcute] pues, para construir el poliedro dual del \
gran dodecaedro hemos de unir el centro de cada cara de un dodecaedro convexo \
con los centros de las cinco caras que est\[AAcute]n a dos caras de distancia."
}], "Text",
 CellChangeTimes->{{3.539380217032256*^9, 3.539380217034243*^9}, {
  3.539424536059404*^9, 3.539424557616802*^9}, {3.539424594012189*^9, 
  3.539424706194396*^9}, {3.5394249119351883`*^9, 3.539425118598473*^9}, {
  3.5410153921411057`*^9, 3.541015397134424*^9}, {3.541178592320217*^9, 
  3.541178593066986*^9}}],

Cell[TextData[{
 "Por otra parte, las caras ",
 StyleBox["1, 2, 3, 4, 5",
  FontFamily->"Times"],
 " son tambi\[EAcute]n un grupo de cinco caras con un v\[EAcute]rtice en com\
\[UAcute]n, luego las aristas del poliedro dual que tienen por \
v\[EAcute]rtices sus centros forman una cara de dicho dual. Como cada centro \
no se une a los centros de las caras contiguas (en el dodecaedro peque\
\[NTilde]o), sino con los las dos siguientes, el pol\[IAcute]gono que forman \
no es un pent\[AAcute]gono, sino un pentagrama. Podemos ver la situaci\
\[OAcute]n en la figura siguiente si mostramos \[UAcute]nicamente una de las \
caras. Si las mostramos todas veremos el ",
 StyleBox["peque\[NTilde]o dodecaedro estrellado.",
  FontSlant->"Italic"],
 " "
}], "Text",
 CellChangeTimes->{{3.5393802171761303`*^9, 3.5393802171782913`*^9}, {
  3.5394404748346577`*^9, 3.539440525475336*^9}, {3.5394568552563667`*^9, 
  3.539456965751895*^9}, {3.5394570491001863`*^9, 3.5394570785692587`*^9}, {
  3.539457145996749*^9, 3.539457148793909*^9}, {3.539457189853726*^9, 
  3.539457204794375*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`c1$$ = False, $CellContext`c10$$ = 
    False, $CellContext`c11$$ = False, $CellContext`c12$$ = 
    True, $CellContext`c2$$ = False, $CellContext`c3$$ = 
    False, $CellContext`c4$$ = False, $CellContext`c5$$ = 
    False, $CellContext`c6$$ = False, $CellContext`c7$$ = 
    False, $CellContext`c8$$ = False, $CellContext`c9$$ = 
    False, $CellContext`dod$$ = 0, $CellContext`ext$$ = 
    True, $CellContext`ic$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`ext$$], True, "Dodecaedro Exterior"}, {
      True, False}}, {{
       Hold[$CellContext`ic$$], 0, "Icosaedro"}, 0, 1}, {{
       Hold[$CellContext`dod$$], 0, "Dodecaedro"}, 0, 1}, {{
       Hold[$CellContext`c1$$], False}, {True, False}}, {{
       Hold[$CellContext`c2$$], False}, {True, False}}, {{
       Hold[$CellContext`c3$$], False}, {True, False}}, {{
       Hold[$CellContext`c4$$], False}, {True, False}}, {{
       Hold[$CellContext`c5$$], False}, {True, False}}, {{
       Hold[$CellContext`c6$$], False}, {True, False}}, {{
       Hold[$CellContext`c7$$], False}, {True, False}}, {{
       Hold[$CellContext`c8$$], False}, {True, False}}, {{
       Hold[$CellContext`c9$$], False}, {True, False}}, {{
       Hold[$CellContext`c10$$], False}, {True, False}}, {{
       Hold[$CellContext`c11$$], False}, {True, False}}, {
      Hold[$CellContext`c12$$], {True, False}}, {
      Hold[
       Grid[{{
          Button[
          "Ocultar todas las caras", {$CellContext`c1$$ = 
            False, $CellContext`c2$$ = False, $CellContext`c3$$ = 
            False, $CellContext`c4$$ = False, $CellContext`c5$$ = 
            False, $CellContext`c6$$ = False, $CellContext`c7$$ = 
            False, $CellContext`c8$$ = False, $CellContext`c9$$ = 
            False, $CellContext`c10$$ = False, $CellContext`c11$$ = 
            False, $CellContext`c12$$ = False}], 
          Button[
          "Mostrar todas las caras", {$CellContext`c1$$ = 
            True, $CellContext`c2$$ = True, $CellContext`c3$$ = 
            True, $CellContext`c4$$ = True, $CellContext`c5$$ = 
            True, $CellContext`c6$$ = True, $CellContext`c7$$ = 
            True, $CellContext`c8$$ = True, $CellContext`c9$$ = 
            True, $CellContext`c10$$ = True, $CellContext`c11$$ = 
            True, $CellContext`c12$$ = True}]}}]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    360., {193., 198.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`ext$3658$$ = 
    False, $CellContext`ic$3659$$ = 0, $CellContext`dod$3660$$ = 
    0, $CellContext`c1$3661$$ = False, $CellContext`c2$3662$$ = 
    False, $CellContext`c3$3663$$ = False, $CellContext`c4$3664$$ = 
    False, $CellContext`c5$3665$$ = False, $CellContext`c6$3666$$ = 
    False, $CellContext`c7$3667$$ = False, $CellContext`c8$3668$$ = 
    False, $CellContext`c9$3669$$ = False, $CellContext`c10$3670$$ = 
    False, $CellContext`c11$3671$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`c1$$ = False, $CellContext`c10$$ = 
        False, $CellContext`c11$$ = False, $CellContext`c12$$ = 
        True, $CellContext`c2$$ = False, $CellContext`c3$$ = 
        False, $CellContext`c4$$ = False, $CellContext`c5$$ = 
        False, $CellContext`c6$$ = False, $CellContext`c7$$ = 
        False, $CellContext`c8$$ = False, $CellContext`c9$$ = 
        False, $CellContext`dod$$ = 0, $CellContext`ext$$ = 
        True, $CellContext`ic$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`ext$$, $CellContext`ext$3658$$, False], 
        Hold[$CellContext`ic$$, $CellContext`ic$3659$$, 0], 
        Hold[$CellContext`dod$$, $CellContext`dod$3660$$, 0], 
        Hold[$CellContext`c1$$, $CellContext`c1$3661$$, False], 
        Hold[$CellContext`c2$$, $CellContext`c2$3662$$, False], 
        Hold[$CellContext`c3$$, $CellContext`c3$3663$$, False], 
        Hold[$CellContext`c4$$, $CellContext`c4$3664$$, False], 
        Hold[$CellContext`c5$$, $CellContext`c5$3665$$, False], 
        Hold[$CellContext`c6$$, $CellContext`c6$3666$$, False], 
        Hold[$CellContext`c7$$, $CellContext`c7$3667$$, False], 
        Hold[$CellContext`c8$$, $CellContext`c8$3668$$, False], 
        Hold[$CellContext`c9$$, $CellContext`c9$3669$$, False], 
        Hold[$CellContext`c10$$, $CellContext`c10$3670$$, False], 
        Hold[$CellContext`c11$$, $CellContext`c11$3671$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{{
          GrayLevel[0.6], 
          Opacity[1], 
          
          GraphicsComplex[{{(1/
              5) ((-2) (1 + 2/5^Rational[1, 2])^Rational[1, 2] + 
              2 Root[1 - 100 #^2 + 80 #^4& , 1]), (1/
              5) ((1/4) (-1 - 5^Rational[1, 2]) + (1/4) (1 + 
                5^Rational[1, 2])), (1/5) (2 Root[1 - 100 #^2 + 80 #^4& , 1] + 
              2 Root[1 - 20 #^2 + 80 #^4& , 2] + 
              Root[1 - 20 #^2 + 80 #^4& , 3])}, {(1/5) (
              2 (1/4 + 1/(2 5^Rational[1, 2]))^Rational[1, 2] + 
              2 (5/8 + 11/(8 5^Rational[1, 2]))^Rational[1, 2] + (1 + 
                2/5^Rational[1, 2])^Rational[1, 2]), (1/
              5) ((1/4) (-1 - 5^Rational[1, 2]) + (1/4) (1 + 
                5^Rational[1, 2])), (1/5) (
              2 (5/8 + 11/(8 5^Rational[1, 2]))^Rational[1, 2] + 
              Root[1 - 20 #^2 + 80 #^4& , 2] + 
              2 Root[1 - 20 #^2 + 80 #^4& , 3])}, {(1/
              5) ((1/8 + 1/(8 5^Rational[1, 2]))^
               Rational[1, 2] + (1/4 + 1/(2 5^Rational[1, 2]))^
               Rational[1, 2] + (5/8 + 11/(8 5^Rational[1, 2]))^
               Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 1] + 
              Root[1 - 20 #^2 + 80 #^4& , 2]), (1/
              5) (-(1/2) + (1/2) (-3 - 5^Rational[1, 2]) + (1/2) (-1 - 5^
                Rational[1, 2])), (1/5) (
              2 (5/8 + 11/(8 5^Rational[1, 2]))^Rational[1, 2] + 
              Root[1 - 20 #^2 + 80 #^4& , 2] + 
              2 Root[1 - 20 #^2 + 80 #^4& , 3])}, {(1/5) (
              2 (1/4 + 1/(2 5^Rational[1, 2]))^Rational[1, 2] + 
              Root[1 - 5 #^2 + 5 #^4& , 1] + 
              2 Root[1 - 20 #^2 + 80 #^4& , 2]), (1/
              5) ((1/4) (-1 - 5^Rational[1, 2]) + (1/4) (1 + 
                5^Rational[1, 2])), (5/8 + 11/(8 5^Rational[1, 2]))^
             Rational[1, 2]}, {(1/
              5) ((1/8 + 1/(8 5^Rational[1, 2]))^
               Rational[1, 2] + (1/4 + 1/(2 5^Rational[1, 2]))^
               Rational[1, 2] + (5/8 + 11/(8 5^Rational[1, 2]))^
               Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 1] + 
              Root[1 - 20 #^2 + 80 #^4& , 2]), (1/5) (
              1/2 + (1/2) (1 + 5^Rational[1, 2]) + (1/2) (3 + 
                5^Rational[1, 2])), (1/5) (
              2 (5/8 + 11/(8 5^Rational[1, 2]))^Rational[1, 2] + 
              Root[1 - 20 #^2 + 80 #^4& , 2] + 
              2 Root[1 - 20 #^2 + 80 #^4& , 3])}, {(1/
              5) ((1/8 + 1/(8 5^Rational[1, 2]))^
               Rational[1, 2] + (5/8 + 11/(8 5^Rational[1, 2]))^
               Rational[1, 2] + (1 + 2/5^Rational[1, 2])^
               Rational[1, 2] + ((1/10) (5 + 5^Rational[1, 2]))^
               Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3]), (1/
              5) ((1/2) (1 + 5^Rational[1, 2]) + (1/4) (3 + 
                5^Rational[1, 2])), (1/5) (2 Root[1 - 100 #^2 + 80 #^4& , 1] + 
              2 Root[1 - 20 #^2 + 80 #^4& , 2] + 
              Root[1 - 20 #^2 + 80 #^4& , 3])}, {(1/
              5) ((1/8 + 1/(8 5^Rational[1, 2]))^
               Rational[1, 2] + (5/8 + 11/(8 5^Rational[1, 2]))^
               Rational[1, 2] + (1 + 2/5^Rational[1, 2])^
               Rational[1, 2] + ((1/10) (5 + 5^Rational[1, 2]))^
               Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3]), (1/
              5) ((1/4) (-3 - 5^Rational[1, 2]) + (1/2) (-1 - 5^
                Rational[1, 2])), (1/5) (2 Root[1 - 100 #^2 + 80 #^4& , 1] + 
              2 Root[1 - 20 #^2 + 80 #^4& , 2] + 
              Root[1 - 20 #^2 + 80 #^4& , 3])}, {(1/
              5) ((1/8 + 1/(8 5^Rational[1, 2]))^Rational[1, 2] - (1/
               2) (1 + 2/5^Rational[1, 2])^Rational[1, 2] + 
              Root[1 - 100 #^2 + 80 #^4& , 1] + 
              Root[1 - 20 #^2 + 80 #^4& , 1] + 
              Root[1 - 20 #^2 + 80 #^4& , 3]), (1/5) (
              1/2 + (1/2) (1 + 5^Rational[1, 2]) + (1/2) (3 + 
                5^Rational[1, 2])), (1/5) (2 Root[1 - 100 #^2 + 80 #^4& , 1] + 
              2 Root[1 - 20 #^2 + 80 #^4& , 2] + 
              Root[1 - 20 #^2 + 80 #^4& , 3])}, {(1/
              5) (-(1 + 2/5^Rational[1, 2])^
                Rational[1, 2] + ((1/10) (5 + 5^Rational[1, 2]))^
               Rational[1, 2] + 2 Root[1 - 20 #^2 + 80 #^4& , 3]), (1/
              5) ((1/4) (-1 - 5^Rational[1, 2]) + (1/4) (1 + 
                5^Rational[1, 2])), 
             Root[
             1 - 100 #^2 + 80 #^4& , 1]}, {(1/
              5) ((1/8 + 1/(8 5^Rational[1, 2]))^Rational[1, 2] - (1/
               2) (1 + 2/5^Rational[1, 2])^Rational[1, 2] + 
              Root[1 - 100 #^2 + 80 #^4& , 1] + 
              Root[1 - 20 #^2 + 80 #^4& , 1] + 
              Root[1 - 20 #^2 + 80 #^4& , 3]), (1/
              5) (-(1/2) + (1/2) (-3 - 5^Rational[1, 2]) + (1/2) (-1 - 5^
                Rational[1, 2])), (1/5) (2 Root[1 - 100 #^2 + 80 #^4& , 1] + 
              2 Root[1 - 20 #^2 + 80 #^4& , 2] + 
              Root[1 - 20 #^2 + 80 #^4& , 3])}, {(1/
              5) (-(1 + 2/5^Rational[1, 2])^Rational[1, 2] + 
              Root[1 - 5 #^2 + 5 #^4& , 1] + Root[1 - 100 #^2 + 80 #^4& , 1] + 
              Root[1 - 20 #^2 + 80 #^4& , 1] + 
              Root[1 - 20 #^2 + 80 #^4& , 2]), (1/
              5) ((1/4) (-3 - 5^Rational[1, 2]) + (1/2) (-1 - 5^
                Rational[1, 2])), (1/5) (
              2 (5/8 + 11/(8 5^Rational[1, 2]))^Rational[1, 2] + 
              Root[1 - 20 #^2 + 80 #^4& , 2] + 
              2 Root[1 - 20 #^2 + 80 #^4& , 3])}, {(1/
              5) (-(1 + 2/5^Rational[1, 2])^Rational[1, 2] + 
              Root[1 - 5 #^2 + 5 #^4& , 1] + Root[1 - 100 #^2 + 80 #^4& , 1] + 
              Root[1 - 20 #^2 + 80 #^4& , 1] + 
              Root[1 - 20 #^2 + 80 #^4& , 2]), (1/
              5) ((1/2) (1 + 5^Rational[1, 2]) + (1/4) (3 + 
                5^Rational[1, 2])), (1/5) (
              2 (5/8 + 11/(8 5^Rational[1, 2]))^Rational[1, 2] + 
              Root[1 - 20 #^2 + 80 #^4& , 2] + 
              2 Root[1 - 20 #^2 + 80 #^4& , 3])}}, 
           Polygon[{
             If[$CellContext`c11$$, {3, 5, 7, 4, 6}, {}], 
             If[$CellContext`c12$$, {8, 10, 12, 9, 11}, {}], 
             If[$CellContext`c6$$, {1, 3, 12, 10, 4}, {}], 
             If[$CellContext`c9$$, {1, 7, 11, 9, 3}, {}], 
             If[$CellContext`c1$$, {3, 5, 11, 2, 12}, {}], 
             If[$CellContext`c2$$, {2, 10, 6, 3, 9}, {}], 
             If[$CellContext`c4$$, {2, 11, 7, 4, 10}, {}], 
             If[$CellContext`c7$$, {6, 10, 8, 7, 1}, {}], 
             If[$CellContext`c3$$, {2, 8, 4, 6, 12}, {}], 
             If[$CellContext`c5$$, {2, 9, 5, 7, 8}, {}], 
             If[$CellContext`c10$$, {5, 9, 12, 6, 1}, {}], 
             If[$CellContext`c8$$, {1, 4, 8, 11, 5}, {}]}]]}, 
         If[$CellContext`ext$$, {
           GrayLevel[0.6], 
           Opacity[0.1], 
           PolyhedronData["Dodecahedron", "Faces"]}], {
          Opacity[0], 
          Sphere[{0, 0, 0}, 
           PolyhedronData["Dodecahedron", "Circumradius"]]}, 
         If[$CellContext`dod$$ > 0, {
           GrayLevel[0.6], 
           Opacity[$CellContext`dod$$], 
           Scale[
            PolyhedronData[
            "Dodecahedron", "Faces"], (10 + 2 5^Rational[1, 2])^
             Rational[1, 2]/(50 + 10 5^Rational[1, 2])^Rational[1, 2]]}], 
         If[$CellContext`ic$$ > 0, {
           GrayLevel[0.7], 
           Opacity[$CellContext`ic$$], 
           Scale[
            PolyhedronData["Icosahedron", "Faces"], 
            PolyhedronData["Dodecahedron", "Inradius"]/PolyhedronData[
            "Icosahedron", "Circumradius"]]}]}, Lighting -> "Neutral", Boxed -> 
        False], "Specifications" :> {{{$CellContext`ext$$, True, 
          "Dodecaedro Exterior"}, {
         True, False}}, {{$CellContext`ic$$, 0, "Icosaedro"}, 0, 1, 
         AppearanceElements -> {}}, {{$CellContext`dod$$, 0, "Dodecaedro"}, 0,
          1, AppearanceElements -> {}}, {{$CellContext`c1$$, False}, {
         True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c2$$, False}, {True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c3$$, False}, {True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c4$$, False}, {True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c5$$, False}, {True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c6$$, False}, {True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c7$$, False}, {True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c8$$, False}, {True, False}, ControlPlacement -> L\
eft}, {{$CellContext`c9$$, False}, {True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c10$$, False}, {True, False}, ControlPlacement -> 
         Left}, {{$CellContext`c11$$, False}, {True, False}, ControlPlacement -> 
         Left}, {$CellContext`c12$$, {True, False}, ControlPlacement -> Left}, 
        Grid[{{
           Button[
           "Ocultar todas las caras", {$CellContext`c1$$ = 
             False, $CellContext`c2$$ = False, $CellContext`c3$$ = 
             False, $CellContext`c4$$ = False, $CellContext`c5$$ = 
             False, $CellContext`c6$$ = False, $CellContext`c7$$ = 
             False, $CellContext`c8$$ = False, $CellContext`c9$$ = 
             False, $CellContext`c10$$ = False, $CellContext`c11$$ = 
             False, $CellContext`c12$$ = False}], 
           Button[
           "Mostrar todas las caras", {$CellContext`c1$$ = 
             True, $CellContext`c2$$ = True, $CellContext`c3$$ = 
             True, $CellContext`c4$$ = True, $CellContext`c5$$ = 
             True, $CellContext`c6$$ = True, $CellContext`c7$$ = 
             True, $CellContext`c8$$ = True, $CellContext`c9$$ = 
             True, $CellContext`c10$$ = True, $CellContext`c11$$ = 
             True, $CellContext`c12$$ = True}]}}]}, 
      "Options" :> {AppearanceElements -> {}}, "DefaultOptions" :> {}],
     ImageSizeCache->{448., {271., 277.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.5394567063774853`*^9, 3.539457132542342*^9, 3.539458424565165*^9, {
   3.539606249272694*^9, 3.539606271774385*^9}, {3.5396320258369493`*^9, 
   3.539632038046476*^9}, {3.5403292505744047`*^9, 3.5403292690706043`*^9}, 
   3.545595932253593*^9},
 TextAlignment->Center],

Cell["\<\
Sabemos que uniendo (de otro modo) los centros de las caras de un dodecaedro \
obtenemos un icosaedro (el poliedro dual del dodecaedro), por lo que los v\
\[EAcute]rtices del peque\[NTilde]o dodecaedro estrellado son tambi\[EAcute]n \
los v\[EAcute]rtices de un icosaedro del mismo radio, que tambi\[EAcute]n \
puede mostrarse en la figura. Vemos as\[IAcute] que el peque\[NTilde]o \
dodecaedro estrellado puede obtenerse a partir de un icosaedro de forma an\
\[AAcute]loga a como hemos obtenido el gran dodecaedro: en lugar de tomar \
como caras los pent\[AAcute]gonos situados bajo cada v\[EAcute]rtice, tomamos \
los pentagramas correspondientes. Si a partir de un mismo icosaedro \
construimos su gran dodecaedro y su peque\[NTilde]o dodecaedro estrellado, \
ambos compartir\[AAcute]n el mismo peque\[NTilde]o dodecaedro interior, que \
tambi\[EAcute]n puede verse en la figura (ocultando algunas caras). Por lo \
tanto, el peque\[NTilde]o dodecaedro estrellado puede construirse tambi\
\[EAcute]n situando una pir\[AAcute]mide pentagonal (de la altura adecuada) \
sobre cada cara de un dodecaedro.\
\>", "Text",
 CellChangeTimes->{{3.539456717620639*^9, 3.5394567176223183`*^9}, {
  3.539458580195567*^9, 3.539458638289249*^9}, {3.539458673279739*^9, 
  3.5394586738742027`*^9}, {3.539458768869792*^9, 3.539458813130918*^9}, {
  3.539468621090479*^9, 3.539468623234664*^9}}],

Cell[TextData[{
 "Si el peque\[NTilde]o dodecaedro ",
 "estrellado",
 " tiene arista ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", entonces el icosaedro tiene lado ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "/\[CapitalPhi], luego su radio (que es el mismo para los dos) es"
}], "Text",
 CellChangeTimes->{{3.539456717780637*^9, 3.539456717782198*^9}, {
   3.539459715250245*^9, 3.539459785416346*^9}, 3.539468625291527*^9}],

Cell[TextData[{
 StyleBox["R",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "=",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    FormBox[
     StyleBox[
      RowBox[{
       FractionBox["1", 
        RowBox[{"2", "\[CapitalPhi]"}]], 
       SqrtBox[
        StyleBox[
         FractionBox[
          RowBox[{"5", "+", 
           SqrtBox["5"]}], "2"],
         FontSize->18]]}],
      FontSize->18],
     TraditionalForm], 
    StyleBox["l",
     FontSize->18,
     FontSlant->"Italic"]}],
   FontFamily->"Times"]],
  CellGroupingRules->{GroupTogetherGrouping, 10000.},
  CellChangeTimes->{{3.53684881230794*^9, 3.5368488421084557`*^9}, {
    3.536848914413434*^9, 3.536848966373749*^9}, {3.536849024033951*^9, 
    3.536849030726388*^9}, {3.536849261476451*^9, 3.536849267385294*^9}, {
    3.536849350730043*^9, 3.536849399339061*^9}, {3.536849615568947*^9, 
    3.5368496684572372`*^9}, {3.536849748665278*^9, 3.5368497486731567`*^9}, {
    3.536849780152142*^9, 3.536849792454063*^9}, 3.5368506738925877`*^9, {
    3.536851382476898*^9, 3.536851385232678*^9}, 3.536852161095171*^9, {
    3.539202038300458*^9, 3.539202091805221*^9}, 3.539293300299508*^9},
  TextAlignment->Center],
 " = ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    FormBox[
     StyleBox[
      RowBox[{
       FractionBox["1", "2"], 
       SqrtBox[
        StyleBox[
         FractionBox[
          RowBox[{"5", "-", 
           SqrtBox["5"]}], "2"],
         FontSize->18]]}],
      FontSize->18],
     TraditionalForm], 
    StyleBox["l",
     FontSize->18,
     FontSlant->"Italic"]}],
   FontFamily->"Times"]],
  CellGroupingRules->{GroupTogetherGrouping, 10000.},
  CellChangeTimes->{{3.53684881230794*^9, 3.5368488421084557`*^9}, {
    3.536848914413434*^9, 3.536848966373749*^9}, {3.536849024033951*^9, 
    3.536849030726388*^9}, {3.536849261476451*^9, 3.536849267385294*^9}, {
    3.536849350730043*^9, 3.536849399339061*^9}, {3.536849615568947*^9, 
    3.5368496684572372`*^9}, {3.536849748665278*^9, 3.5368497486731567`*^9}, {
    3.536849780152142*^9, 3.536849792454063*^9}, 3.5368506738925877`*^9, {
    3.536851382476898*^9, 3.536851385232678*^9}, 3.536852161095171*^9, {
    3.539202038300458*^9, 3.539202091805221*^9}, 3.539293300299508*^9},
  TextAlignment->Center],
 "."
}], "Text",
 CellChangeTimes->{{3.539459785532259*^9, 3.539459817453835*^9}, {
  3.539460758948206*^9, 3.539460783348105*^9}},
 TextAlignment->Center],

Cell["\<\
El inradio es el mismo que el del gran dodecaedro asociado al icosaedro, es \
decir,\
\>", "Text",
 CellChangeTimes->{{3.5394612450952587`*^9, 3.5394612658065367`*^9}}],

Cell[BoxData[
 StyleBox["\<\"\\!\\(\\*\\nStyleBox[\\\"r\\\",\\nFontSize->18,\\nFontWeight->\
\\\"Plain\\\",\\nFontSlant->\\\"Italic\\\"]\\)  = \
\\!\\(\\*FractionBox[\\(\\(1\\)\\(\\\\ \\)\\), \\(4  \
\[CapitalPhi]\\)]\\)\\!\\(\\*SqrtBox[FractionBox[\\(10 + 2 \
\\*SqrtBox[\\(5\\)]\\), \
\\(5\\)]]\\)\\!\\(\\*\\nStyleBox[\\\"l\\\",\\nFontSize->18,\\nFontWeight->\\\"\
Plain\\\",\\nFontSlant->\\\"Italic\\\"]\\) = \
\\!\\(\\*FractionBox[\\(\\(1\\)\\(\\\\ \\)\\), \
\\(4\\)]\\)\\!\\(\\*SqrtBox[FractionBox[\\(10 - 2 \\*SqrtBox[\\(5\\)]\\), \
\\(5\\)]]\\)\\!\\(\\*\\nStyleBox[\\\"l\\\",\\nFontSize->18,\\nFontWeight->\\\"\
Plain\\\",\\nFontSlant->\\\"Italic\\\"]\\).\"\>",
  StripOnInput->False,
  FontFamily->"Times",
  FontSize->14]], "Output",
 CellChangeTimes->{3.539461350761516*^9, 3.539461404953381*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Para construir un peque\[NTilde]o dodecaedro ",
 "estrellado",
 " a partir de un dodecaedro de lado ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " hemos de a\[NTilde]adirle pir\[AAcute]mides de base de lado ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " y aristas laterales de longitud \[CapitalPhi]",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego, teniendo en cuenta la f\[OAcute]rmula del radio del \
pent\[AAcute]gono, la altura ser\[AAcute]"
}], "Text",
 CellChangeTimes->{{3.539461265980197*^9, 3.539461283974683*^9}, {
   3.5394626374864597`*^9, 3.539462745367874*^9}, 3.539468627567292*^9}],

Cell[TextData[{
 StyleBox["h",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{
     SuperscriptBox["\[CapitalPhi]", "2"], "-", 
     FractionBox[
      RowBox[{"5", "+", 
       SqrtBox["5"]}], "10"]}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    FractionBox[
     RowBox[{"5", "+", 
      RowBox[{"2", 
       SqrtBox["5"]}]}], "5"]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "."
}], "Text",
 CellChangeTimes->{{3.539462757220233*^9, 3.53946285213455*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Ahora bien, si el peque\[NTilde]o dodecaedro ",
 "estrellado",
 " tiene arista ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", la arista del peque\[NTilde]o dodecaedro sobre el que hay que poner las \
pir\[AAcute]mides es ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "/",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[CapitalPhi]", "3"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " = (",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox["5",
     FontFamily->"Times",
     FontSlant->"Plain"]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "-",
 StyleBox["2",
  FontFamily->"Times"],
 ")",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego el volumen de la pir\[AAcute]mide a\[NTilde]adida es"
}], "Text",
 CellChangeTimes->{{3.5394612661322203`*^9, 3.5394612661339703`*^9}, {
   3.5394628853675537`*^9, 3.539462952902564*^9}, {3.539463068017915*^9, 
   3.53946309352099*^9}, {3.539463154628304*^9, 3.5394631611617002`*^9}, {
   3.539463989179325*^9, 3.539463989186748*^9}, 3.539468628632061*^9}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   FractionBox["3", "3"], TraditionalForm]],
  FontSize->18],
 StyleBox[" ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   FractionBox["5", "4"], TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    FractionBox[
     RowBox[{"5", "+", 
      RowBox[{"2", 
       SqrtBox["5"]}]}], "5"]], TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SqrtBox[
        StyleBox["5",
         FontFamily->"Times",
         FontSlant->"Plain"]], "-", 
       StyleBox["2",
        FontFamily->"Times"]}], ")"}], "2"],
    FontSize->14], TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    FractionBox[
     RowBox[{"5", "+", 
      RowBox[{"2", 
       SqrtBox["5"]}]}], "5"]], TraditionalForm]],
  FontSize->18],
 StyleBox["(",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox["5",
     FontFamily->"Times",
     FontSlant->"Plain"]], TraditionalForm]],
  FontSize->14],
 StyleBox["-2)",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["l",
     FontFamily->"Times",
     FontSize->18], "3"], TraditionalForm]],
  FontSize->18],
 StyleBox[" = ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{
     RowBox[{"-", "20"}], "+", 
     RowBox[{"9", 
      SqrtBox["5"]}]}], "12"], TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["l",
     FontFamily->"Times",
     FontSize->18], "3"], TraditionalForm]],
  FontSize->18],
 StyleBox[".",
  FontFamily->"Times",
  FontSize->18]
}], "Text",
 CellChangeTimes->{{3.539464035876733*^9, 3.5394642617288523`*^9}, {
   3.539464374033773*^9, 3.539464374033842*^9}, 3.5394645251729593`*^9},
 TextAlignment->Center],

Cell["\<\
De aqu\[IAcute] obtenemos el volumen del peque\[NTilde]o dodecaedro \
estrellado, sumando el del peque\[NTilde]o dodecaedro central m\[AAcute]s el \
de las doce pir\[AAcute]mides que lo extienden:\
\>", "Text",
 CellChangeTimes->{{3.539464036009736*^9, 3.5394640360115633`*^9}, {
   3.5394642749276648`*^9, 3.53946430864692*^9}, 3.5394686295584593`*^9}],

Cell[TextData[{
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"15", "+", 
     RowBox[{"7", 
      SqrtBox["5"]}]}], "4"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       StyleBox["5",
        FontFamily->"Times",
        FontSlant->"Plain"]], "-", 
      StyleBox["2",
       FontFamily->"Times"]}], ")"}], "3"], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["l",
     FontFamily->"Times",
     FontSize->18], "3"], TraditionalForm]]],
 "+(-",
 StyleBox["20",
  FontFamily->"Times"],
 "+",
 StyleBox["9",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox["5",
     FontFamily->"Times",
     FontSlant->"Plain"]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ")",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["l",
     FontFamily->"Times",
     FontSize->18], "3"], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   FractionBox["5", "4"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "(",
 StyleBox["5",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox["5",
     FontFamily->"Times",
     FontSlant->"Plain"]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "-",
 StyleBox["11",
  FontFamily->"Times"],
 ")",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["l",
     FontFamily->"Times",
     FontSize->18], "3"], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.539464309661024*^9, 3.539464346623845*^9}, {
  3.539464378610461*^9, 3.5394644541618023`*^9}, {3.539464528542399*^9, 
  3.539464532100629*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "El \[AAcute]rea (de la superficie \[OpenCurlyDoubleQuote]real\
\[CloseCurlyDoubleQuote] del peque\[NTilde]o dodecaedro ",
 "estrellado",
 ", es decir, la suma de las \[AAcute]reas de los ",
 StyleBox["60",
  FontFamily->"Times"],
 " tri\[AAcute]ngulos \[AAcute]ureos visibles desde el exterior, es"
}], "Text",
 CellChangeTimes->{{3.5394645830811863`*^9, 3.539464605040353*^9}, {
   3.5394646377768183`*^9, 3.53946467467645*^9}, 3.539468630616547*^9}],

Cell[TextData[{
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 StyleBox["15",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{
     StyleBox["85",
      FontFamily->"Times"], "-", 
     RowBox[{
      StyleBox["38",
       FontFamily->"Times"], 
      SqrtBox[
       StyleBox["5",
        FontFamily->"Times",
        FontSlant->"Plain"]]}]}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["l",
     FontFamily->"Times",
     FontSize->18], "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "."
}], "Text",
 CellChangeTimes->{{3.539464674800466*^9, 3.539464740746428*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Dejamos el c\[AAcute]lculo a cuenta del lector. El \[AAcute]ngulo di\
\[EAcute]drico es el suplementario del del gran dodecaedro, como de deduce de \
la figura anterior mostrando el icosaedro y las caras ",
 StyleBox["1",
  FontFamily->"Times"],
 ", ",
 StyleBox["11",
  FontFamily->"Times"],
 " y ",
 StyleBox["12",
  FontFamily->"Times"],
 ". Las dos \[UAcute]ltimas son paralelas, y el \[AAcute]ngulo que forma la \
primera con la und\[EAcute]cima coincide con el suplementario del \
\[AAcute]ngulo que forma el pent\[AAcute]gono circunscrito a la primera con \
el de la duod\[EAcute]cima, que es uno de los \[AAcute]ngulos \
di\[EAcute]dricos del gran dodecaedro, pues los pent\[AAcute]gonos las caras ",
 StyleBox["1",
  FontFamily->"Times"],
 " y ",
 StyleBox["12",
  FontFamily->"Times"],
 " son caras contiguas de \[EAcute]ste. En resumen, para un peque\[NTilde]o \
dodecaedro estrellado de arista ",
 StyleBox["1",
  FontFamily->"Times"],
 " tenemos:"
}], "Text",
 CellChangeTimes->{{3.539464754969697*^9, 3.539464759785796*^9}, {
   3.5394648081944036`*^9, 3.539464822570458*^9}, {3.539464969167184*^9, 
   3.539465010206349*^9}, {3.539465152481206*^9, 3.539465158822451*^9}, {
   3.539465383354085*^9, 3.5394654191767483`*^9}, {3.5394655904605427`*^9, 
   3.53946560652223*^9}, {3.539465831365951*^9, 3.539465832469949*^9}, 
   3.539468631717599*^9, {3.540675966302657*^9, 3.540675970929345*^9}, {
   3.540676009685109*^9, 3.5406760120741167`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Radio\"\>", "\<\"Inradio\"\>", "\<\"Volumen\"\>", "\<\"\
\[CapitalAAcute]rea\"\>", "\<\"\[CapitalAAcute]ngulo di\[EAcute]drico\"\>"},
    {
     StyleBox["\<\"\\!\\(\\*FormBox[\\n StyleBox[\\n  \
RowBox[{FractionBox[\\\"1\\\", \\\"2\\\"], SqrtBox[\\n    \
StyleBox[FractionBox[\\n      RowBox[{\\\"5\\\", \\\"-\\\", \
SqrtBox[\\\"5\\\"]}], \\\"2\\\"],\\nFontSize->18]]}],\\nFontSize->18],\\n \
TraditionalForm]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(\\(1\\)\\(\\\\ \\)\\), \\(4\\)]\\)\
\\!\\(\\*SqrtBox[FractionBox[\\(10 - 2 \\*SqrtBox[\\(5\\)]\\), \\(5\\)]]\\)\"\
\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FormBox[\\n RowBox[{FractionBox[\\\"5\\\", \
\\\"4\\\"], \\n  RowBox[{\\\"(\\\", \\n   RowBox[{\\n    RowBox[{\\n     \
StyleBox[\\\"5\\\",\\nFontFamily->\\\"Times\\\"], SqrtBox[\\n      \
StyleBox[\\\"5\\\",\\nFontFamily->\\\"Times\\\",\\nFontSlant->\\\"Plain\\\"]]}\
], \\\"-\\\", \\n    StyleBox[\\\"11\\\",\\nFontFamily->\\\"Times\\\"]}], \
\\\")\\\"}]}],\\n TraditionalForm]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], 
     StyleBox["\<\"\\!\\(\\*FormBox[\\n RowBox[{\\n  \
StyleBox[\\\"15\\\",\\nFontFamily->\\\"Times\\\"], FormBox[SqrtBox[\\n    \
RowBox[{\\n     StyleBox[\\\"85\\\",\\nFontFamily->\\\"Times\\\"], \\\"-\\\", \
\\n     RowBox[{\\n      StyleBox[\\\"38\\\",\\nFontFamily->\\\"Times\\\"], \
SqrtBox[\\n       \
StyleBox[\\\"5\\\",\\nFontFamily->\\\"Times\\\",\\nFontSlant->\\\"Plain\\\"]]}\
]}]],\\n   TraditionalForm]}],\\n TraditionalForm]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], 
     StyleBox["\<\"arccos[-\\!\\(\\*FractionBox[SqrtBox[\\(5\\)], \
\\(5\\)]\\)]\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18]}
   },
   AutoDelete->False,
   GridBoxDividers->{
    "Columns" -> {False, True, True, True, True}, "Rows" -> {False, True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.539465431952258*^9, {3.539465467100943*^9, 3.539465481432536*^9}, {
   3.539465520120311*^9, 3.539465531238798*^9}, 3.539506282920824*^9, 
   3.5406761086238422`*^9},
 TextAlignment->Center],

Cell[TextData[StyleBox["EL GRAN ICOSAEDRO",
 FontSize->18,
 FontColor->RGBColor[0, 0, 1]]], "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellMargins->{{100, 100}, {16, 18}},
 CellChangeTimes->{{3.538515429422391*^9, 3.538515429424019*^9}, {
  3.538517083097238*^9, 3.538517086760803*^9}, {3.538772137916774*^9, 
  3.5387721418334713`*^9}, {3.5389433492789*^9, 3.538943354615024*^9}, {
  3.538944083654379*^9, 3.538944088838513*^9}, {3.5391065561537533`*^9, 
  3.5391065641036177`*^9}, {3.539110603199396*^9, 3.5391106061050386`*^9}, {
  3.539114155036748*^9, 3.5391141567297077`*^9}, {3.5391190486065063`*^9, 
  3.5391190499503193`*^9}, {3.539191580022891*^9, 3.539191581987825*^9}, {
  3.539194702212619*^9, 3.539194706217629*^9}, {3.539198553615024*^9, 
  3.5391985588123913`*^9}, {3.539255753070822*^9, 3.539255755378742*^9}, {
  3.539381764243767*^9, 3.539381768720518*^9}, {3.5394685624739428`*^9, 
  3.539468565705537*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "La figura siguiente muestra el peque\[NTilde]o dodecaedro estrellado. Si \
pulsamos el bot\[OAcute]n titulado \[OpenCurlyDoubleQuote]Aristas\
\[CloseCurlyDoubleQuote] vemos sus aristas, entre las cuales hemos destacado \
las que forman una de las caras pentagr\[AAcute]micas y las que unen los v\
\[EAcute]rtices de dicha cara con el v\[EAcute]rtice opuesto. Dichas aristas \
destacadas forman cinco tri\[AAcute]ngulos equil\[AAcute]teros. En total \
tenemos ",
 StyleBox["5 x 12 / 3 = 20",
  FontFamily->"Times"],
 " tri\[AAcute]ngulos, que podemos tomar como caras de un nuevo poliedro \
regular, conocido como ",
 StyleBox["gran icosaedro.",
  FontSlant->"Italic"],
 " El gran icosaedro tiene ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 20",
  FontFamily->"Times"],
 " caras triangulares, ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 30",
  FontFamily->"Times"],
 " aristas y ",
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 12",
  FontFamily->"Times"],
 " v\[EAcute]rtices, y puede verse pulsando el tercer bot\[OAcute]n de la \
figura. Es f\[AAcute]cil convencerse de que las simetr\[IAcute]as del peque\
\[NTilde]o dodecaedro estrellado son tambi\[EAcute]n simetr\[IAcute]as del \
gran icosaedro, y bastan para probar que es un poliedro regular."
}], "Text",
 CellChangeTimes->{{3.539465010307906*^9, 3.539465010309718*^9}, {
  3.539512497295117*^9, 3.539512576956154*^9}, {3.5395129800435877`*^9, 
  3.539513060401657*^9}, {3.539513099532827*^9, 3.539513110569643*^9}, {
  3.5395135709219513`*^9, 3.539513581663129*^9}, {3.5399821058547773`*^9, 
  3.5399821386359987`*^9}, {3.5399821736777687`*^9, 3.539982178140936*^9}, {
  3.539982213061116*^9, 3.5399822338933897`*^9}, {3.541015428818084*^9, 
  3.541015431229869*^9}, {3.541015517385127*^9, 3.541015520030855*^9}, {
  3.541178612404902*^9, 3.5411786130262747`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`car$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`car$$], 0, ""}, {
      0 -> "Peque\[NTilde]o dodecaedro estrellado", 1 -> "Aristas", 2 -> 
       "Gran Icosaedro"}}}, Typeset`size$$ = {360., {193., 198.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`car$2901$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`car$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`car$$, $CellContext`car$2901$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{{
          Opacity[0], 
          
          Sphere[{0, 0, 
           0}, (1/2) ((1/2) (5 - 5^Rational[1, 2]))^Rational[1, 2]]}, 
         GraphicsComplex[{{
           0, 0, (-(1/2)) ((1/2) (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {
           0, 0, (1/2) ((1/2) (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {(1/8 + 
             1/(8 5^Rational[1, 2]))^
            Rational[1, 2], -(1/(1 + 
             5^Rational[1, 2])), (-(1/2)) ((1/10) (5 - 5^Rational[1, 2]))^
             Rational[1, 2]}, {(1/8 + 1/(8 5^Rational[1, 2]))^Rational[1, 2], 
            1/(1 + 5^
             Rational[1, 2]), (-(1/2)) ((1/10) (5 - 5^Rational[1, 2]))^
             Rational[1, 2]}, {-(1/8 + 1/(8 5^Rational[1, 2]))^
             Rational[1, 2], -(1/(1 + 5^Rational[1, 2])), (1/
             2) ((1/10) (5 - 5^Rational[1, 2]))^
             Rational[1, 2]}, {-(1/8 + 1/(8 5^Rational[1, 2]))^Rational[1, 2],
             1/(1 + 5^Rational[1, 2]), (1/2) ((1/10) (5 - 5^Rational[1, 2]))^
             Rational[1, 2]}, {((1/10) (5 - 5^Rational[1, 2]))^Rational[1, 2],
             0, (1/2) ((1/10) (5 - 5^Rational[1, 2]))^
             Rational[1, 2]}, {-((1/10) (5 - 5^Rational[1, 2]))^
             Rational[1, 2], 
            0, (-(1/2)) ((1/10) (5 - 5^Rational[1, 2]))^
             Rational[1, 2]}, {(-(1/2)) (1 - 2/5^Rational[1, 2])^
             Rational[1, 2], -(1/2), (-(1/2)) ((1/10) (5 - 5^Rational[1, 2]))^
             Rational[1, 2]}, {(-(1/2)) (1 - 2/5^Rational[1, 2])^
             Rational[1, 2], 1/
            2, (-(1/2)) ((1/10) (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {(1/
             2) (1 - 2/5^Rational[1, 2])^Rational[1, 2], -(1/2), (1/
             2) ((1/10) (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {(1/
             2) (1 - 2/5^Rational[1, 2])^Rational[1, 2], 1/
            2, (1/2) ((1/10) (5 - 5^Rational[1, 2]))^Rational[1, 2]}}, {{
            If[$CellContext`car$$ == 1, {{
               Thickness[0.006], 
               
               Line[{{3, 8, 4, 9, 10, 3}, {3, 2}, {8, 2}, {4, 2}, {9, 2}, {10,
                  2}}]}, 
              
              Line[{{1, 5}, {1, 6}, {1, 7}, {1, 11}, {1, 12}, {2, 3}, {2, 
               4}, {2, 8}, {2, 9}, {2, 10}, {3, 5}, {3, 8}, {3, 10}, {3, 
               12}, {4, 6}, {4, 8}, {4, 9}, {4, 11}, {5, 7}, {5, 10}, {5, 
               12}, {6, 7}, {6, 9}, {6, 11}, {7, 9}, {7, 10}, {8, 11}, {8, 
               12}, {9, 10}, {11, 12}}]}], 
            If[$CellContext`car$$ == 2, {
              GrayLevel[0.6], 
              
              Polygon[{{1, 7, 5}, {6, 7, 1}, {1, 5, 12}, {11, 6, 1}, {12, 11, 
               1}, {2, 8, 3}, {4, 8, 2}, {2, 3, 10}, {9, 4, 2}, {10, 9, 2}, {
               12, 3, 8}, {8, 4, 11}, {8, 11, 12}, {10, 5, 7}, {7, 6, 9}, {7, 
               9, 10}, {3, 5, 10}, {12, 5, 3}, {9, 6, 4}, {4, 6, 11}}]}], 
            If[$CellContext`car$$ == 0, {
              GrayLevel[0.6], 
              
              Polygon[{{3, 8, 4, 9, 10}, {3, 5, 7, 9, 2}, {9, 2, 8, 11, 6}, {
               8, 2, 10, 5, 12}, {10, 2, 4, 6, 7}, {3, 2, 4, 11, 12}, {5, 1, 
               6, 9, 10}, {6, 1, 12, 8, 4}, {12, 1, 7, 10, 3}, {7, 1, 11, 4, 
               9}, {11, 1, 5, 3, 8}, {5, 7, 6, 11, 12}}]}]}}]}, Lighting -> 
        "Neutral", Boxed -> False], 
      "Specifications" :> {{{$CellContext`car$$, 0, ""}, {
         0 -> "Peque\[NTilde]o dodecaedro estrellado", 1 -> "Aristas", 2 -> 
          "Gran Icosaedro"}}}, "Options" :> {AppearanceElements -> {}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{405., {228., 234.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.539512335619584*^9, 3.5395124234301157`*^9, 
  3.5396321333010387`*^9},
 TextAlignment->Center],

Cell["\<\
El gran icosaedro es el poliedro m\[AAcute]s complejo que hemos estudiado \
hasta ahora. Empezamos observando que tiene la misma arista y el mismo radio \
que el peque\[NTilde]o dodecaedro estrellado, por lo que la \
proporci\[OAcute]n entre ambos es la misma, es decir,\
\>", "Text",
 CellChangeTimes->{{3.539513587929985*^9, 3.53951358793286*^9}, {
  3.539981823203319*^9, 3.5399818341363087`*^9}, {3.539981884932386*^9, 
  3.539981934114029*^9}}],

Cell[TextData[{
 StyleBox["R",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "= ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    FormBox[
     StyleBox[
      RowBox[{
       FractionBox["1", "2"], 
       SqrtBox[
        StyleBox[
         FractionBox[
          RowBox[{"5", "-", 
           SqrtBox["5"]}], "2"],
         FontSize->18]]}],
      FontSize->18],
     TraditionalForm], 
    StyleBox["l",
     FontSize->18,
     FontSlant->"Italic"]}],
   FontFamily->"Times"]],
  CellGroupingRules->{GroupTogetherGrouping, 10000.},
  CellChangeTimes->{{3.53684881230794*^9, 3.5368488421084557`*^9}, {
    3.536848914413434*^9, 3.536848966373749*^9}, {3.536849024033951*^9, 
    3.536849030726388*^9}, {3.536849261476451*^9, 3.536849267385294*^9}, {
    3.536849350730043*^9, 3.536849399339061*^9}, {3.536849615568947*^9, 
    3.5368496684572372`*^9}, {3.536849748665278*^9, 3.5368497486731567`*^9}, {
    3.536849780152142*^9, 3.536849792454063*^9}, 3.5368506738925877`*^9, {
    3.536851382476898*^9, 3.536851385232678*^9}, 3.536852161095171*^9, {
    3.539202038300458*^9, 3.539202091805221*^9}, 3.539293300299508*^9},
  TextAlignment->Center],
 "."
}], "Text",
 CellChangeTimes->{{3.539459785532259*^9, 3.539459817453835*^9}, {
   3.539460758948206*^9, 3.539460783348105*^9}, 3.5399819463397017`*^9},
 TextAlignment->Center],

Cell["\<\
Para analizarlo m\[AAcute]s a fondo consideramos las figuras siguientes:\
\>", "Text",
 CellChangeTimes->{{3.539513588070344*^9, 3.53951358807193*^9}, {
  3.539981965476734*^9, 3.539981974818231*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      StyleBox[
       DynamicModuleBox[{$CellContext`c1$$ = True, $CellContext`c10$$ = 
        True, $CellContext`c11$$ = True, $CellContext`c12$$ = 
        True, $CellContext`c13$$ = True, $CellContext`c14$$ = 
        True, $CellContext`c15$$ = True, $CellContext`c16$$ = 
        True, $CellContext`c17$$ = True, $CellContext`c18$$ = 
        True, $CellContext`c19$$ = True, $CellContext`c2$$ = 
        True, $CellContext`c20$$ = True, $CellContext`c3$$ = 
        True, $CellContext`c4$$ = True, $CellContext`c5$$ = 
        True, $CellContext`c6$$ = True, $CellContext`c7$$ = 
        True, $CellContext`c8$$ = True, $CellContext`c9$$ = 
        True, $CellContext`ico$$ = False, Typeset`show$$ = True, 
        Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
        Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
        "\"untitled\"", Typeset`specs$$ = {{{
           Hold[$CellContext`ico$$], False, "Icosaedro inscrito"}, {
          True, False}}, {
          Hold[$CellContext`c1$$], {True, False}}, {
          Hold[$CellContext`c2$$], {True, False}}, {
          Hold[$CellContext`c3$$], {True, False}}, {
          Hold[$CellContext`c4$$], {True, False}}, {
          Hold[$CellContext`c5$$], {True, False}}, {
          Hold[$CellContext`c6$$], {True, False}}, {
          Hold[$CellContext`c7$$], {True, False}}, {
          Hold[$CellContext`c8$$], {True, False}}, {
          Hold[$CellContext`c9$$], {True, False}}, {
          Hold[$CellContext`c10$$], {True, False}}, {
          Hold[$CellContext`c11$$], {True, False}}, {
          Hold[$CellContext`c12$$], {True, False}}, {
          Hold[$CellContext`c13$$], {True, False}}, {
          Hold[$CellContext`c14$$], {True, False}}, {
          Hold[$CellContext`c15$$], {True, False}}, {
          Hold[$CellContext`c16$$], {True, False}}, {
          Hold[$CellContext`c17$$], {True, False}}, {
          Hold[$CellContext`c18$$], {True, False}}, {
          Hold[$CellContext`c19$$], {True, False}}, {
          Hold[$CellContext`c20$$], {True, False}}, {
          Hold[
           Grid[{{
              Button[
              "Todas", {$CellContext`c1$$ = True; $CellContext`c2$$ = 
                 True; $CellContext`c3$$ = True; $CellContext`c4$$ = 
                 True; $CellContext`c5$$ = True; $CellContext`c6$$ = 
                 True; $CellContext`c7$$ = True; $CellContext`c8$$ = 
                 True; $CellContext`c9$$ = True; $CellContext`c10$$ = 
                 True; $CellContext`c11$$ = True; $CellContext`c12$$ = 
                 True; $CellContext`c13$$ = True; $CellContext`c14$$ = 
                 True; $CellContext`c15$$ = True; $CellContext`c16$$ = 
                 True; $CellContext`c17$$ = True; $CellContext`c18$$ = 
                 True; $CellContext`c19$$ = True; $CellContext`c20$$ = True}, 
               Appearance -> "Palette"], 
              Button[
              "1", {$CellContext`c1$$ = True; $CellContext`c2$$ = 
                 False; $CellContext`c3$$ = False; $CellContext`c4$$ = 
                 True; $CellContext`c5$$ = True; $CellContext`c6$$ = 
                 True; $CellContext`c7$$ = False; $CellContext`c8$$ = 
                 True; $CellContext`c9$$ = True; $CellContext`c10$$ = 
                 True; $CellContext`c11$$ = False; $CellContext`c12$$ = 
                 False; $CellContext`c13$$ = True; $CellContext`c14$$ = 
                 False; $CellContext`c15$$ = True; $CellContext`c16$$ = 
                 True; $CellContext`c17$$ = True; $CellContext`c18$$ = 
                 True; $CellContext`c19$$ = False; $CellContext`c20$$ = True},
                Appearance -> "Palette"], 
              Button[
              "2", {$CellContext`c1$$ = True; $CellContext`c2$$ = 
                 True; $CellContext`c3$$ = True; $CellContext`c4$$ = 
                 False; $CellContext`c5$$ = False; $CellContext`c6$$ = 
                 True; $CellContext`c7$$ = True; $CellContext`c8$$ = 
                 True; $CellContext`c9$$ = True; $CellContext`c10$$ = 
                 True; $CellContext`c11$$ = True; $CellContext`c12$$ = 
                 False; $CellContext`c13$$ = False; $CellContext`c14$$ = 
                 True; $CellContext`c15$$ = True; $CellContext`c16$$ = 
                 True; $CellContext`c17$$ = True; $CellContext`c18$$ = 
                 True; $CellContext`c19$$ = True; $CellContext`c20$$ = False},
                Appearance -> "Palette"], 
              Button[
              "3", {$CellContext`c1$$ = True; $CellContext`c2$$ = 
                 False; $CellContext`c3$$ = False; $CellContext`c4$$ = 
                 True; $CellContext`c5$$ = True; $CellContext`c6$$ = 
                 True; $CellContext`c7$$ = False; $CellContext`c8$$ = 
                 False; $CellContext`c9$$ = True; $CellContext`c10$$ = 
                 False; $CellContext`c11$$ = False; $CellContext`c12$$ = 
                 True; $CellContext`c13$$ = True; $CellContext`c14$$ = 
                 False; $CellContext`c15$$ = True; $CellContext`c16$$ = 
                 False; $CellContext`c17$$ = False; $CellContext`c18$$ = 
                 True; $CellContext`c19$$ = False; $CellContext`c20$$ = True},
                Appearance -> "Palette"], 
              Button[
              "Ninguna", {$CellContext`c1$$ = False; $CellContext`c2$$ = 
                 False; $CellContext`c3$$ = False; $CellContext`c4$$ = 
                 False; $CellContext`c5$$ = False; $CellContext`c6$$ = 
                 False; $CellContext`c7$$ = False; $CellContext`c8$$ = 
                 False; $CellContext`c9$$ = False; $CellContext`c10$$ = 
                 False; $CellContext`c11$$ = False; $CellContext`c12$$ = 
                 False; $CellContext`c13$$ = False; $CellContext`c14$$ = 
                 False; $CellContext`c15$$ = False; $CellContext`c16$$ = 
                 False; $CellContext`c17$$ = False; $CellContext`c18$$ = 
                 False; $CellContext`c19$$ = False; $CellContext`c20$$ = 
                 False}, Appearance -> "Palette"]}}]], 
          Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
        360., {193., 198.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
        Typeset`skipInitDone$$ = True, $CellContext`ico$6361$$ = 
        False, $CellContext`c1$6362$$ = False, $CellContext`c2$6363$$ = 
        False, $CellContext`c3$6364$$ = False, $CellContext`c4$6365$$ = 
        False, $CellContext`c5$6366$$ = False, $CellContext`c6$6367$$ = 
        False, $CellContext`c7$6368$$ = False, $CellContext`c8$6369$$ = 
        False, $CellContext`c9$6370$$ = False, $CellContext`c10$6371$$ = 
        False, $CellContext`c11$6372$$ = False}, 
        DynamicBox[Manipulate`ManipulateBoxes[
         1, StandardForm, 
          "Variables" :> {$CellContext`c1$$ = True, $CellContext`c10$$ = True,
             $CellContext`c11$$ = True, $CellContext`c12$$ = 
            True, $CellContext`c13$$ = True, $CellContext`c14$$ = 
            True, $CellContext`c15$$ = True, $CellContext`c16$$ = 
            True, $CellContext`c17$$ = True, $CellContext`c18$$ = 
            True, $CellContext`c19$$ = True, $CellContext`c2$$ = 
            True, $CellContext`c20$$ = True, $CellContext`c3$$ = 
            True, $CellContext`c4$$ = True, $CellContext`c5$$ = 
            True, $CellContext`c6$$ = True, $CellContext`c7$$ = 
            True, $CellContext`c8$$ = True, $CellContext`c9$$ = 
            True, $CellContext`ico$$ = False}, "ControllerVariables" :> {
            Hold[$CellContext`ico$$, $CellContext`ico$6361$$, False], 
            Hold[$CellContext`c1$$, $CellContext`c1$6362$$, False], 
            Hold[$CellContext`c2$$, $CellContext`c2$6363$$, False], 
            Hold[$CellContext`c3$$, $CellContext`c3$6364$$, False], 
            Hold[$CellContext`c4$$, $CellContext`c4$6365$$, False], 
            Hold[$CellContext`c5$$, $CellContext`c5$6366$$, False], 
            Hold[$CellContext`c6$$, $CellContext`c6$6367$$, False], 
            Hold[$CellContext`c7$$, $CellContext`c7$6368$$, False], 
            Hold[$CellContext`c8$$, $CellContext`c8$6369$$, False], 
            Hold[$CellContext`c9$$, $CellContext`c9$6370$$, False], 
            Hold[$CellContext`c10$$, $CellContext`c10$6371$$, False], 
            Hold[$CellContext`c11$$, $CellContext`c11$6372$$, False]}, 
          "OtherVariables" :> {
           Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
            Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
            Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
            Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
          Graphics3D[{{
              Opacity[0], 
              
              Sphere[{0, 0, 
               0}, (1/2) ((1/2) (5 - 5^Rational[1, 2]))^Rational[1, 2]]}, 
             If[$CellContext`ico$$, 
              Scale[
               PolyhedronData["Icosahedron", "Faces"], 0.1103/PolyhedronData[
               "Icosahedron", "Inradius"]]], 
             
             GraphicsComplex[{{
               0, 0, (-(1/2)) ((1/2) (5 - 5^Rational[1, 2]))^
                 Rational[1, 2]}, {
               0, 0, (1/2) ((1/2) (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {(
                 1/8 + 1/(8 5^Rational[1, 2]))^
                Rational[1, 2], -(1/(1 + 
                 5^Rational[1, 2])), (-(1/2)) ((1/10) (5 - 5^Rational[1, 2]))^
                 Rational[1, 2]}, {(1/8 + 1/(8 5^Rational[1, 2]))^
                Rational[1, 2], 1/(1 + 
                5^Rational[1, 2]), (-(1/2)) ((1/10) (5 - 5^Rational[1, 2]))^
                 Rational[1, 2]}, {-(1/8 + 1/(8 5^Rational[1, 2]))^
                 Rational[1, 2], -(1/(1 + 5^Rational[1, 2])), (1/
                 2) ((1/10) (5 - 5^Rational[1, 2]))^
                 Rational[1, 2]}, {-(1/8 + 1/(8 5^Rational[1, 2]))^
                 Rational[1, 2], 1/(1 + 
                5^Rational[1, 2]), (1/2) ((1/10) (5 - 5^Rational[1, 2]))^
                 Rational[1, 2]}, {((1/10) (5 - 5^Rational[1, 2]))^
                Rational[1, 2], 
                0, (1/2) ((1/10) (5 - 5^Rational[1, 2]))^
                 Rational[1, 2]}, {-((1/10) (5 - 5^Rational[1, 2]))^
                 Rational[1, 2], 
                0, (-(1/2)) ((1/10) (5 - 5^Rational[1, 2]))^
                 Rational[1, 2]}, {(-(1/2)) (1 - 2/5^Rational[1, 2])^
                 Rational[1, 2], -(1/
                 2), (-(1/2)) ((1/10) (5 - 5^Rational[1, 2]))^
                 Rational[1, 2]}, {(-(1/2)) (1 - 2/5^Rational[1, 2])^
                 Rational[1, 2], 1/
                2, (-(1/2)) ((1/10) (5 - 5^Rational[1, 2]))^
                 Rational[1, 2]}, {(1/2) (1 - 2/5^Rational[1, 2])^
                 Rational[1, 2], -(1/2), (1/
                 2) ((1/10) (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {(1/
                 2) (1 - 2/5^Rational[1, 2])^Rational[1, 2], 1/
                2, (1/2) ((1/10) (5 - 5^Rational[1, 2]))^Rational[1, 2]}}, {{
                If[$CellContext`c1$$, {Black, 
                  Polygon[{1, 7, 5}]}, {}], {
                 GrayLevel[0.6], 
                 Polygon[{
                   If[$CellContext`c2$$, {6, 7, 1}, {}], 
                   If[$CellContext`c3$$, {1, 5, 12}, {}], 
                   If[$CellContext`c4$$, {11, 6, 1}, {}], 
                   If[$CellContext`c5$$, {12, 11, 1}, {}], 
                   If[$CellContext`c6$$, {2, 8, 3}, {}], 
                   If[$CellContext`c7$$, {4, 8, 2}, {}], 
                   If[$CellContext`c8$$, {2, 3, 10}, {}], 
                   If[$CellContext`c9$$, {9, 4, 2}, {}], 
                   If[$CellContext`c10$$, {10, 9, 2}, {}], 
                   If[$CellContext`c11$$, {12, 3, 8}, {}], 
                   If[$CellContext`c12$$, {8, 4, 11}, {}], 
                   If[$CellContext`c13$$, {8, 11, 12}, {}], 
                   If[$CellContext`c14$$, {10, 5, 7}, {}], 
                   If[$CellContext`c15$$, {7, 6, 9}, {}], 
                   If[$CellContext`c16$$, {7, 9, 10}, {}], 
                   If[$CellContext`c17$$, {3, 5, 10}, {}], 
                   If[$CellContext`c18$$, {12, 5, 3}, {}], 
                   If[$CellContext`c19$$, {9, 6, 4}, {}], 
                   If[$CellContext`c20$$, {4, 6, 11}, {}]}]}}}]}, Lighting -> 
            "Neutral", Boxed -> False], 
          "Specifications" :> {{{$CellContext`ico$$, False, 
              "Icosaedro inscrito"}, {True, False}}, {$CellContext`c1$$, {
             True, False}, ControlPlacement -> Left}, {$CellContext`c2$$, {
             True, False}, ControlPlacement -> Left}, {$CellContext`c3$$, {
             True, False}, ControlPlacement -> Left}, {$CellContext`c4$$, {
             True, False}, ControlPlacement -> Left}, {$CellContext`c5$$, {
             True, False}, ControlPlacement -> Left}, {$CellContext`c6$$, {
             True, False}, ControlPlacement -> Left}, {$CellContext`c7$$, {
             True, False}, ControlPlacement -> Left}, {$CellContext`c8$$, {
             True, False}, ControlPlacement -> Left}, {$CellContext`c9$$, {
             True, False}, ControlPlacement -> Left}, {$CellContext`c10$$, {
             True, False}, ControlPlacement -> Left}, {$CellContext`c11$$, {
             True, False}, ControlPlacement -> Right}, {$CellContext`c12$$, {
             True, False}, ControlPlacement -> Right}, {$CellContext`c13$$, {
             True, False}, ControlPlacement -> Right}, {$CellContext`c14$$, {
             True, False}, ControlPlacement -> Right}, {$CellContext`c15$$, {
             True, False}, ControlPlacement -> Right}, {$CellContext`c16$$, {
             True, False}, ControlPlacement -> Right}, {$CellContext`c17$$, {
             True, False}, ControlPlacement -> Right}, {$CellContext`c18$$, {
             True, False}, ControlPlacement -> Right}, {$CellContext`c19$$, {
             True, False}, ControlPlacement -> Right}, {$CellContext`c20$$, {
             True, False}, ControlPlacement -> Right}, 
            Grid[{{
               Button[
               "Todas", {$CellContext`c1$$ = True; $CellContext`c2$$ = 
                  True; $CellContext`c3$$ = True; $CellContext`c4$$ = 
                  True; $CellContext`c5$$ = True; $CellContext`c6$$ = 
                  True; $CellContext`c7$$ = True; $CellContext`c8$$ = 
                  True; $CellContext`c9$$ = True; $CellContext`c10$$ = 
                  True; $CellContext`c11$$ = True; $CellContext`c12$$ = 
                  True; $CellContext`c13$$ = True; $CellContext`c14$$ = 
                  True; $CellContext`c15$$ = True; $CellContext`c16$$ = 
                  True; $CellContext`c17$$ = True; $CellContext`c18$$ = 
                  True; $CellContext`c19$$ = True; $CellContext`c20$$ = True},
                 Appearance -> "Palette"], 
               Button[
               "1", {$CellContext`c1$$ = True; $CellContext`c2$$ = 
                  False; $CellContext`c3$$ = False; $CellContext`c4$$ = 
                  True; $CellContext`c5$$ = True; $CellContext`c6$$ = 
                  True; $CellContext`c7$$ = False; $CellContext`c8$$ = 
                  True; $CellContext`c9$$ = True; $CellContext`c10$$ = 
                  True; $CellContext`c11$$ = False; $CellContext`c12$$ = 
                  False; $CellContext`c13$$ = True; $CellContext`c14$$ = 
                  False; $CellContext`c15$$ = True; $CellContext`c16$$ = 
                  True; $CellContext`c17$$ = True; $CellContext`c18$$ = 
                  True; $CellContext`c19$$ = False; $CellContext`c20$$ = 
                  True}, Appearance -> "Palette"], 
               Button[
               "2", {$CellContext`c1$$ = True; $CellContext`c2$$ = 
                  True; $CellContext`c3$$ = True; $CellContext`c4$$ = 
                  False; $CellContext`c5$$ = False; $CellContext`c6$$ = 
                  True; $CellContext`c7$$ = True; $CellContext`c8$$ = 
                  True; $CellContext`c9$$ = True; $CellContext`c10$$ = 
                  True; $CellContext`c11$$ = True; $CellContext`c12$$ = 
                  False; $CellContext`c13$$ = False; $CellContext`c14$$ = 
                  True; $CellContext`c15$$ = True; $CellContext`c16$$ = 
                  True; $CellContext`c17$$ = True; $CellContext`c18$$ = 
                  True; $CellContext`c19$$ = True; $CellContext`c20$$ = 
                  False}, Appearance -> "Palette"], 
               Button[
               "3", {$CellContext`c1$$ = True; $CellContext`c2$$ = 
                  False; $CellContext`c3$$ = False; $CellContext`c4$$ = 
                  True; $CellContext`c5$$ = True; $CellContext`c6$$ = 
                  True; $CellContext`c7$$ = False; $CellContext`c8$$ = 
                  False; $CellContext`c9$$ = True; $CellContext`c10$$ = 
                  False; $CellContext`c11$$ = False; $CellContext`c12$$ = 
                  True; $CellContext`c13$$ = True; $CellContext`c14$$ = 
                  False; $CellContext`c15$$ = True; $CellContext`c16$$ = 
                  False; $CellContext`c17$$ = False; $CellContext`c18$$ = 
                  True; $CellContext`c19$$ = False; $CellContext`c20$$ = 
                  True}, Appearance -> "Palette"], 
               Button[
               "Ninguna", {$CellContext`c1$$ = False; $CellContext`c2$$ = 
                  False; $CellContext`c3$$ = False; $CellContext`c4$$ = 
                  False; $CellContext`c5$$ = False; $CellContext`c6$$ = 
                  False; $CellContext`c7$$ = False; $CellContext`c8$$ = 
                  False; $CellContext`c9$$ = False; $CellContext`c10$$ = 
                  False; $CellContext`c11$$ = False; $CellContext`c12$$ = 
                  False; $CellContext`c13$$ = False; $CellContext`c14$$ = 
                  False; $CellContext`c15$$ = False; $CellContext`c16$$ = 
                  False; $CellContext`c17$$ = False; $CellContext`c18$$ = 
                  False; $CellContext`c19$$ = False; $CellContext`c20$$ = 
                  False}, Appearance -> "Palette"]}}]}, 
          "Options" :> {AppearanceElements -> {}}, "DefaultOptions" :> {}],
         ImageSizeCache->{490., {241., 247.}},
         SingleEvaluation->True],
        Deinitialization:>None,
        DynamicModuleValues:>{},
        SynchronousInitialization->True,
        UnsavedVariables:>{Typeset`initDone$$},
        UntrackedVariables:>{Typeset`size$$}], "Manipulate",
       Deployed->True,
       StripOnInput->False],
      Manipulate`InterpretManipulate[1]], 
     GraphicsBox[{
       GraphicsComplexBox[
        NCache[{{
          Rational[-1, 2] - 
           GoldenRatio, (Rational[1, 2] 3^Rational[1, 2]) (1 + 
            2 GoldenRatio)}, {
          Rational[1, 2] + 
           GoldenRatio, (Rational[1, 2] 3^Rational[1, 2]) (1 + 
            2 GoldenRatio)}, {0, 0}, {
          Rational[-1, 2], (Rational[1, 2] 3^Rational[1, 2]) (1 + 
            2 GoldenRatio)}, {
          Rational[
           1, 2], (Rational[1, 2] 3^Rational[1, 2]) (1 + 2 GoldenRatio)}, {
          Rational[1, 2] GoldenRatio, (Rational[1, 2] 3^Rational[1, 2]) 
           GoldenRatio}, {
          Rational[-1, 2] GoldenRatio, (Rational[1, 2] 3^Rational[1, 2]) 
           GoldenRatio}, {
          Rational[1, 2] (1 + GoldenRatio), (Rational[1, 2] 
            3^Rational[1, 2]) (1 + GoldenRatio)}, {
          Rational[1, 2] (-1 - GoldenRatio), (Rational[1, 2] 
            3^Rational[1, 2]) (1 + GoldenRatio)}}, {{-2.118033988749895, 
          3.6685424806725857`}, {2.118033988749895, 3.6685424806725857`}, {0, 
          0}, {-0.5, 3.6685424806725857`}, {0.5, 3.6685424806725857`}, {
          0.8090169943749475, 1.4012585384440734`}, {-0.8090169943749475, 
          1.4012585384440734`}, {1.3090169943749475`, 
          2.267283942228512}, {-1.3090169943749475`, 2.267283942228512}}], 
        LineBox[{{1, 2, 3, 1}, {4, 6}, {5, 7}, {8, 9}, {2, 9}, {2, 7}, {1, 
          6}, {1, 8}, {3, 4}, {5, 3}, {4, 8}, {5, 9}, {7, 8}, {5, 6}, {6, 
          9}, {7, 4}}]], InsetBox[
        StyleBox["\<\"1\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {0, 3.8}], InsetBox[
        StyleBox["\<\"\[CapitalPhi]\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {1.3, 3.8}], InsetBox[
        StyleBox["\<\"C\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {2.2, 3.8}], InsetBox[
        StyleBox["\<\"B\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {-2.2, 3.8}], InsetBox[
        StyleBox["\<\"\[CapitalPhi]\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {-1.3, 3.8}], InsetBox[
        StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(A\\), \\(1\\)]\\)\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {-0.5, 3.8}], InsetBox[
        StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(A\\), \\(2\\)]\\)\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {0.5, 3.8}], InsetBox[
        StyleBox["\<\"T\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {0, 2.6}], InsetBox[
        StyleBox["\<\"A\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {0, -0.1}], InsetBox[
        StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(P\\), \\(1\\)]\\)\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {-0.65, 3.2}], InsetBox[
        StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(B\\), \\(1\\)]\\)\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {1.4, 2.25}], InsetBox[
        StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(C\\), \\(1\\)]\\)\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {-1.4, 2.25}], InsetBox[
        StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(B\\), \\(2\\)]\\)\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {0.95, 1.4}], InsetBox[
        StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(C\\), \\(2\\)]\\)\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {-0.95, 1.4}], InsetBox[
        StyleBox["\<\"P\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {0, 3.4}]},
      ImageSize->{504., Automatic},
      ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{3.5399819903584833`*^9, 3.5399864177367907`*^9, 
  3.540063968770482*^9, 3.540070073024028*^9, 3.540072202888625*^9, 
  3.540073484343134*^9},
 TextAlignment->Center],

Cell["\<\
La figura de la izquierda nos permite mostrar y ocultar independientemente \
cada una de las veinte caras. Una de ellas, c1, est\[AAcute] pintada de negro \
para que nos sirva de referencia. La figura de la derecha muestra una cara \
(que podemos identificar con c1) y todas las rectas por donde la cortan las \
caras restantes. Si en la figura de la izquierda pulsamos el bot\[OAcute]n 1 \
ocultaremos las caras que no cortan a c1, con lo que es m\[AAcute]s \
f\[AAcute]cil comprobar la correspondencia con la figura de la derecha.\
\>", "Text",
 CellChangeTimes->{{3.539513588206299*^9, 3.539513588207878*^9}, {
  3.539982020973937*^9, 3.539982073883358*^9}, {3.539982195750813*^9, 
  3.539982205605356*^9}, {3.53998226644075*^9, 3.539982353599216*^9}}],

Cell["\<\
En primer lugar observamos que los cortes dividen cada lado del \
tri\[AAcute]ngulo equil\[AAcute]tero en tres partes, y la figura de la \
izquiera muestra que se trata de la divisi\[OAcute]n que dos lados \
consecutivos de un pentagrama inducen en un tercero. Por lo tanto, si tomamos \
como unidad la longitud del tramo central, los otros dos tramos miden \
\[CapitalPhi].\
\>", "Text",
 CellChangeTimes->{{3.539982350046232*^9, 3.539982470022703*^9}}],

Cell[TextData[{
 "Si pulsamos el bot\[OAcute]n 2 ocultamos las cinco caras que confluyen en \
un v\[EAcute]rtice. Se ve entonces la superficie lateral de una \
pir\[AAcute]mide pentagonal cuyas caras laterales son el tri\[AAcute]ngulo ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "1"], TraditionalForm]],
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "2"], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox["T",
  FontFamily->"Times"],
 " de la figura de la derecha y sus correspondientes en otras cuatro caras. \
Observemos que el tri\[AAcute]ngulo es equil\[AAcute]tero, pues la el lado ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "2"], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox["T",
  FontFamily->"Times"],
 " es paralelo a ",
 StyleBox["AC",
  FontFamily->"Times"],
 ", luego el \[AAcute]ngulo ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "2"], TraditionalForm]],
  FontFamily->"Times"],
 " es de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["60",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 ". De este modo, vemos que cada v\[EAcute]rtice del gran icosaedro tiene en \
su base un pent\[AAcute]gono unitario, por lo que podemos ver al gran \
icosaedro como el resultado de tomar un dodecaedro regular y sustituir cada \
una de sus caras por la superficie lateral de una pir\[AAcute]mide pentagonal \
formada por tri\[AAcute]ngulos equil\[AAcute]teros (con lo que obtenemos el \
poliedro de la figura siguiente) y a continuaci\[OAcute]n insertar en cada \
oquedad una \[OpenCurlyDoubleQuote]punta\[CloseCurlyDoubleQuote] de \
estructura complicada que estudiaremos luego."
}], "Text",
 CellChangeTimes->{{3.53998310220154*^9, 3.539983118398375*^9}, {
  3.539983349971806*^9, 3.539983403585968*^9}, {3.539983534189949*^9, 
  3.539983549155795*^9}, {3.539983602188859*^9, 3.539983832758259*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0.6], 
   GraphicsComplex3DBox[
    NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
       1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
       Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
      Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
       Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
       1 - 20 #^2 + 80 #^4& , 3, 0]}, {
      Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
       Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
       1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
        Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
       Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
       1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
        Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
       Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
       1 - 20 #^2 + 80 #^4& , 3, 0]}, {
      Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
       Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
      Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
       Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
      Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
       Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
      Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
       1, 2], Root[
       1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
        Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
       Rational[-1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
       Rational[1, 2]}, {(Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^
       Rational[1, 2], Rational[
       1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
       Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
       Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
      Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
       Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
       1 - 20 #^2 + 80 #^4& , 2, 0]}, {
      Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
       Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
       1 - 20 #^2 + 80 #^4& , 2, 0]}, {
      Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
       0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
       Rational[1, 2]}, {
      Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
       Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
       1 - 100 #^2 + 80 #^4& , 1, 0]}, {
      Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
       Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
       1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
        Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
       Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
       1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
        Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
       Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
       1 - 20 #^2 + 80 #^4& , 2, 
        0]}, {((Rational[1, 10] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] - 10^
         Rational[1, 2] + (7 + 3 5^Rational[1, 2])^
          Rational[1, 2])) ((-2) (1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
        2 Root[1 - 100 #^2 + 80 #^4& , 1, 0]), 
       0, ((Rational[1, 10] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] - 10^
         Rational[1, 2] + (7 + 3 5^Rational[1, 2])^Rational[1, 2])) (
        2 Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
        2 Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
        Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {((
         Rational[-1, 100] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
         Rational[1, 2])) (
        4 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2] + (250 + 
          110 5^Rational[1, 2])^Rational[1, 2]), 
       0, ((Rational[-1, 100] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
         Rational[1, 2])) ((50 - 10 5^Rational[1, 2])^
         Rational[1, 2] + (250 + 110 5^Rational[1, 2])^Rational[1, 2] + 
        Root[125 - 25 #^2 + #^4& , 2, 0])}, {((
         Rational[1, 200] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
         Rational[1, 2])) ((50 - 10 5^Rational[1, 2])^Rational[1, 2] - 
        2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2] + 
        2 Root[125 - 125 #^2 + #^4& , 1, 0]), ((
         Rational[1, 20] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (5 + 
         2 5^Rational[1, 2])) (
        2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
        Rational[1, 2]), ((
         Rational[-1, 10] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] - 10^
         Rational[1, 2] + (7 + 3 5^Rational[1, 2])^Rational[1, 2])) (
        2 Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
        2 Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
        Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {((
         Rational[-1, 50] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
         Rational[1, 2])) (-(Rational[5, 2] (5 + 5^Rational[1, 2]))^
          Rational[1, 2] + (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2] + 
        Root[125 - 25 #^2 + #^4& , 2, 0]), 
       0, (Rational[1, 4] (Rational[9, 10] + 2 5^Rational[-1, 2])^
         Rational[1, 2]) (2^Rational[1, 2] - 10^
        Rational[1, 2] + (7 + 3 5^Rational[1, 2])^Rational[1, 2])}, {((
         Rational[-1, 200] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
         Rational[1, 2])) (
        2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2] + (250 + 
          110 5^Rational[1, 2])^Rational[1, 2] + 
        2 Root[125 - 25 #^2 + #^4& , 2, 0]), ((
         Rational[-1, 20] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (5 + 
         2 5^Rational[1, 2])) (
        2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
        Rational[1, 2]), ((
         Rational[-1, 100] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
         Rational[1, 2])) ((50 - 10 5^Rational[1, 2])^
         Rational[1, 2] + (250 + 110 5^Rational[1, 2])^Rational[1, 2] + 
        Root[125 - 25 #^2 + #^4& , 2, 0])}, {((
         Rational[-1, 200] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
         Rational[1, 2])) ((50 - 10 5^Rational[1, 2])^Rational[1, 2] + 
        3 (10 (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
        4 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2] + (250 + 
          110 5^Rational[1, 2])^Rational[1, 2]), ((
         Rational[-1, 40] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (5 + 
         3 5^Rational[1, 2])) (
        2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
        Rational[1, 2]), ((
         Rational[1, 10] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] - 10^
         Rational[1, 2] + (7 + 3 5^Rational[1, 2])^Rational[1, 2])) (
        2 Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
        2 Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
        Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {((
         Rational[-1, 200] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
         Rational[1, 2])) ((50 - 10 5^Rational[1, 2])^Rational[1, 2] + 
        3 (10 (5 + 5^Rational[1, 2]))^Rational[1, 2] + 
        4 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2] + (250 + 
          110 5^Rational[1, 2])^Rational[1, 2]), ((
         Rational[1, 40] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (5 + 
         3 5^Rational[1, 2])) (
        2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
        Rational[1, 2]), ((
         Rational[1, 10] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] - 10^
         Rational[1, 2] + (7 + 3 5^Rational[1, 2])^Rational[1, 2])) (
        2 Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
        2 Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
        Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {((
         Rational[-1, 200] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
         Rational[1, 2])) ((50 - 10 5^Rational[1, 2])^Rational[1, 2] - 
        2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2] + 
        2 Root[125 - 125 #^2 + #^4& , 1, 0]), ((
         Rational[-1, 20] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (5 + 
         2 5^Rational[1, 2])) (
        2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
        Rational[1, 2]), ((
         Rational[1, 10] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] - 10^
         Rational[1, 2] + (7 + 3 5^Rational[1, 2])^Rational[1, 2])) (
        2 Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
        2 Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
        Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {((
         Rational[-1, 100] (5 - 5^Rational[1, 2])^
          Rational[-1, 2]) ((50 - 10 5^Rational[1, 2])^
          Rational[1, 2] + (10 (5 + 5^Rational[1, 2]))^Rational[1, 2] - 
         2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2])) (
        2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
        Rational[1, 2]), 
       0, ((Rational[1, 2] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] - 10^
         Rational[1, 2] + (7 + 3 5^Rational[1, 2])^Rational[1, 2])) 
       Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {((
         Rational[-1, 200] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
         Rational[1, 2])) ((50 - 10 5^Rational[1, 2])^Rational[1, 2] - 
        2 (5 (5 + 2 5^Rational[1, 2]))^Rational[1, 2] + 
        2 Root[125 - 125 #^2 + #^4& , 1, 0]), ((
         Rational[1, 20] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (5 + 
         2 5^Rational[1, 2])) (
        2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
        Rational[1, 2]), ((
         Rational[1, 10] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] - 10^
         Rational[1, 2] + (7 + 3 5^Rational[1, 2])^Rational[1, 2])) (
        2 Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
        2 Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
        Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {((
         Rational[1, 10] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] - 10^
         Rational[1, 2] + (7 + 3 5^Rational[1, 2])^
          Rational[1, 2])) (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
        Root[1 - 5 #^2 + 5 #^4& , 1, 0] + Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
        Root[1 - 20 #^2 + 80 #^4& , 1, 0] + 
        Root[1 - 20 #^2 + 80 #^4& , 2, 0]), ((
         Rational[1, 40] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (5 + 
         3 5^Rational[1, 2])) (
        2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
        Rational[1, 2]), ((
         Rational[-1, 100] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
         Rational[1, 2])) ((50 - 10 5^Rational[1, 2])^
         Rational[1, 2] + (250 + 110 5^Rational[1, 2])^Rational[1, 2] + 
        Root[125 - 25 #^2 + #^4& , 2, 0])}, {((
         Rational[1, 10] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] - 10^
         Rational[1, 2] + (7 + 3 5^Rational[1, 2])^
          Rational[1, 2])) (-(1 + 2 5^Rational[-1, 2])^Rational[1, 2] + 
        Root[1 - 5 #^2 + 5 #^4& , 1, 0] + Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
        Root[1 - 20 #^2 + 80 #^4& , 1, 0] + 
        Root[1 - 20 #^2 + 80 #^4& , 2, 0]), ((
         Rational[-1, 40] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (5 + 
         3 5^Rational[1, 2])) (
        2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
        Rational[1, 2]), ((
         Rational[-1, 100] (5 - 5^Rational[1, 2])^Rational[-1, 2]) (
         2^Rational[1, 2] (-1 + 5^Rational[1, 2]) - (7 + 3 5^Rational[1, 2])^
         Rational[1, 2])) ((50 - 10 5^Rational[1, 2])^
         Rational[1, 2] + (250 + 110 5^Rational[1, 2])^Rational[1, 2] + 
        Root[125 - 25 #^2 + #^4& , 2, 0])}}, {{-1.3763819204711736`, 0, 
       0.2628655560595668}, {
      1.3763819204711736`, 
       0, -0.2628655560595668}, {-0.42532540417601994`, -1.3090169943749475`, 
      0.2628655560595668}, {-0.42532540417601994`, 1.3090169943749475`, 
      0.2628655560595668}, {1.1135163644116066`, -0.8090169943749475, 
      0.2628655560595668}, {1.1135163644116066`, 0.8090169943749475, 
      0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
      1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
      1.1135163644116066`}, {-0.6881909602355868, -0.5, \
-1.1135163644116068`}, {-0.6881909602355868, 0.5, -1.1135163644116068`}, {
      0.6881909602355868, -0.5, 1.1135163644116066`}, {0.6881909602355868, 
      0.5, 1.1135163644116066`}, {
      0.85065080835204, 
       0, -1.1135163644116068`}, {-1.1135163644116068`, -0.8090169943749475, \
-0.2628655560595668}, {-1.1135163644116068`, 
      0.8090169943749475, -0.2628655560595668}, {-0.8506508083520399, 0, 
       1.1135163644116066`}, {
      0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
      0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
      0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
      0.42532540417601994`, 
      1.3090169943749475`, -0.2628655560595668}, {-0.5854101966249687, 
       0, -0.2927050983124843}, {0.5854101966249684, 0, 0.2927050983124842}, {
      0.18090169943749473`, -0.5567581822058034, 0.2927050983124843}, {
      0., 0, 0.6545084971874737}, {0.18090169943749473`, 0.5567581822058034, 
      0.2927050983124842}, {0.47360679774997894`, 
      0.3440954801177934, -0.2927050983124843}, {
      0.47360679774997894`, -0.3440954801177934, -0.2927050983124843}, \
{-0.18090169943749473`, 0.5567581822058034, -0.2927050983124843}, {
      0., 0, -0.6545084971874738}, {-0.18090169943749473`, \
-0.5567581822058034, -0.2927050983124843}, {-0.47360679774997916`, \
-0.3440954801177934, 0.2927050983124842}, {-0.47360679774997916`, 
      0.3440954801177934, 0.2927050983124842}}], 
    Polygon3DBox[{{15, 10, 21}, {10, 9, 21}, {9, 14, 21}, {14, 1, 21}, {1, 15,
      21}, {2, 6, 22}, {6, 12, 22}, {12, 11, 22}, {11, 5, 22}, {5, 2, 22}, {5,
      11, 23}, {11, 7, 23}, {7, 3, 23}, {3, 19, 23}, {19, 5, 23}, {11, 12, 
     24}, {12, 8, 24}, {8, 16, 24}, {16, 7, 24}, {7, 11, 24}, {12, 6, 25}, {6,
      20, 25}, {20, 4, 25}, {4, 8, 25}, {8, 12, 25}, {6, 2, 26}, {2, 13, 
     26}, {13, 18, 26}, {18, 20, 26}, {20, 6, 26}, {2, 5, 27}, {5, 19, 27}, {
     19, 17, 27}, {17, 13, 27}, {13, 2, 27}, {4, 20, 28}, {20, 18, 28}, {18, 
     10, 28}, {10, 15, 28}, {15, 4, 28}, {18, 13, 29}, {13, 17, 29}, {17, 9, 
     29}, {9, 10, 29}, {10, 18, 29}, {17, 19, 30}, {19, 3, 30}, {3, 14, 30}, {
     14, 9, 30}, {9, 17, 30}, {3, 7, 31}, {7, 16, 31}, {16, 1, 31}, {1, 14, 
     31}, {14, 3, 31}, {16, 8, 32}, {8, 4, 32}, {4, 15, 32}, {15, 1, 32}, {1, 
     16, 32}}]]},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{332.95352249950184`, 323.8726730379692},
  Lighting->"Neutral",
  ViewPoint->{0.7031263879977306, -3.09396813893497, 1.1759993357806575`},
  ViewVertical->{-0.003990116939142488, -0.2972951044855637, 
   1.1856203068073754`}]], "Output",
 CellChangeTimes->{3.539984668405459*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Pulsando el bot\[OAcute]n 3 se ocultan las caras traseras del gran \
icosaedro, de modo que d\[AAcute]ndole la vuelta podemos ver su interior. \
Concretamente, vemos cinco tri\[AAcute]ngulos equil\[AAcute]teros, \
correspondientes al tri\[AAcute]ngulo central de la figura de la derecha. Hay \
un total de ",
 StyleBox["20",
  FontFamily->"Times"],
 " tri\[AAcute]ngulos que, por simetr\[IAcute]a equidistan del centro del \
gran icosaedro, luego forman las caras de un peque\[NTilde]o icosaedro \
central (que tambi\[EAcute]n puede mostrarse en la figura), cuyo inradio es \
tambi\[EAcute]n el inradio del gran icosaedro. Para calcularlo s\[OAcute]lo \
necesitamos calcular el lado del tri\[AAcute]ngulo central y aplicar la f\
\[OAcute]rmula para el inradio de un icosaedro. ",
 "Ahora bien, por semejanza de tri\[AAcute]ngulos, la raz\[OAcute]n entre el \
lado ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " del tri\[AAcute]ngulo interior y el segmento ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "1"], TraditionalForm]],
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "2"], TraditionalForm]],
  FontFamily->"Times"],
 ", que mide ",
 StyleBox["1",
  FontFamily->"Times"],
 ", es"
}], "Text",
 CellChangeTimes->{{3.5399838606487837`*^9, 3.539983860652101*^9}, {
  3.5399847956738367`*^9, 3.539984823952815*^9}, {3.539984984228897*^9, 
  3.5399851123795767`*^9}, {3.5399853558644114`*^9, 3.539985355868783*^9}, {
  3.540064019835384*^9, 3.5400640315533323`*^9}, {3.54011583832165*^9, 
  3.540115840148287*^9}}],

Cell[TextData[{
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"1", "+", "\[CapitalPhi]"}], 
     RowBox[{"1", "+", 
      RowBox[{"2", "\[CapitalPhi]"}]}]],
    FontSize->24], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times"],
 StyleBox["= ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{
      SqrtBox[
       StyleBox["5",
        FontSize->17.039993286132812`,
        FontSlant->"Plain"]], "-", "1"}], "2"],
    FontSize->24], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times"]
}], "Text",
 CellChangeTimes->{{3.5399854503227367`*^9, 3.539985492146052*^9}},
 TextAlignment->Center],

Cell["\<\
Por consiguiente, el inradio del peque\[NTilde]o icosaedro interior es\
\>", "Text",
 CellChangeTimes->{{3.539985805269721*^9, 3.539985818717066*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     SuperscriptBox["\[CapitalPhi]", "2"], 
     RowBox[{
      StyleBox["2",
       FontFamily->"Times",
       FontSize->17.039993286132812`,
       FontSlant->"Plain"], 
      SqrtBox[
       StyleBox["3",
        FontFamily->"Times",
        FontSize->17.039993286132812`,
        FontSlant->"Plain"]]}]],
    FontSize->24], TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{
      SqrtBox[
       StyleBox["5",
        FontSize->17.039993286132812`,
        FontSlant->"Plain"]], "-", "1"}], "2"],
    FontSize->24], TraditionalForm]],
  FontFamily->"Times"],
 ","
}], "Text",
 CellChangeTimes->{{3.539985834406823*^9, 3.539985883894374*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "para un gran icosaedro cuyo segmento ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "1"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "2"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times"],
 " mida ",
 StyleBox["1",
  FontFamily->"Times"],
 ". Para un icosaedro de arista ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " tenemos que ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "1"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "2"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times"],
 " = ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    StyleBox["l",
     FontFamily->"Times"], 
    RowBox[{
     RowBox[{
      StyleBox["2",
       FontFamily->"Times",
       FontSize->12.779998779296875`,
       FontSlant->"Plain"], "\[CapitalPhi]"}], "+", 
     StyleBox["1",
      FontFamily->"Times",
      FontSize->12.779998779296875`,
      FontSlant->"Plain"]}]], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontSize->18],
 ", luego el inradio es"
}], "Text",
 CellChangeTimes->{{3.5399858867385*^9, 3.539986010936226*^9}, {
  3.5399860514074697`*^9, 3.539986053734535*^9}}],

Cell[TextData[{
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     SuperscriptBox["\[CapitalPhi]", "2"], 
     RowBox[{
      StyleBox["2",
       FontFamily->"Times",
       FontSize->17.039993286132812`,
       FontSlant->"Plain"], 
      SqrtBox[
       StyleBox["3",
        FontFamily->"Times",
        FontSize->17.039993286132812`,
        FontSlant->"Plain"]]}]],
    FontSize->24], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{
      SqrtBox[
       StyleBox["5",
        FontSize->17.039993286132812`,
        FontSlant->"Plain"]], "-", "1"}], "2"],
    FontSize->24], TraditionalForm]],
  FontFamily->"Times"],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["l", 
     RowBox[{
      RowBox[{"2", "\[CapitalPhi]"}], "+", "1"}]],
    FontFamily->"Times",
    FontSize->24], TraditionalForm]]],
 "= ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{
      StyleBox["3",
       FontFamily->"Times",
       FontSize->17.039993286132812`,
       FontSlant->"Plain"], 
      StyleBox["-",
       FontFamily->"Times",
       FontSize->17.039993286132812`,
       FontSlant->"Plain"], 
      SqrtBox[
       StyleBox["5",
        FontFamily->"Times",
        FontSize->17.039993286132812`,
        FontSlant->"Plain"]]}], 
     RowBox[{
      StyleBox["4",
       FontFamily->"Times",
       FontSize->17.039993286132812`,
       FontSlant->"Plain"], 
      SqrtBox[
       StyleBox["3",
        FontFamily->"Times",
        FontSize->17.039993286132812`,
        FontSlant->"Plain"]]}]],
    FontSize->24], TraditionalForm]]],
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " ."
}], "Text",
 CellChangeTimes->{{3.5399862675489807`*^9, 3.539986303689207*^9}, {
   3.5399865222477627`*^9, 3.5399865244037113`*^9}, {3.540064047831884*^9, 
   3.540064072482255*^9}, 3.540064139646888*^9},
 TextAlignment->Center],

Cell[TextData[{
 "El \[AAcute]rea del gran icosaedro entendida como suma de las \[AAcute]reas \
de sus veinte caras triangulares se calcula trivialmente (es la misma que la \
del icosaedro convexo). Vamos a calcular el \[AAcute]rea de su superficie \
exterior. Para ello observamos que cada cara deja en el exterior seis tri\
\[AAcute]ngulos iguales a ",
 StyleBox["B",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["P",
     FontFamily->"Times",
     FontSlant->"Plain"], "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " y tres iguales a ",
 StyleBox["P",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", luego la superficie del gran icosaedro consta de un total de ",
 StyleBox["180",
  FontFamily->"Times"],
 " tri\[AAcute]ngulos. La figura siguiente nos permite calcular la altura del \
tri\[AAcute]ngulo ",
 StyleBox["P",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", sin m\[AAcute]s que observar que tenemos un tri\[AAcute]ngulo rect\
\[AAcute]ngulo de base 1 + \[CapitalPhi]/",
 StyleBox["2",
  FontFamily->"Times"],
 " y altura ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{
     SqrtBox["3"], "\[CapitalPhi]"}], "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", luego una simple proporci\[OAcute]n nos da que la altura de ",
 StyleBox["P",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " es"
}], "Text",
 CellChangeTimes->{{3.539986267855504*^9, 3.5399862678574944`*^9}, {
  3.540071036937352*^9, 3.540071119982319*^9}, {3.540071153449946*^9, 
  3.5400711776711884`*^9}, {3.5400712700579853`*^9, 3.540071357042665*^9}, {
  3.540071398133608*^9, 3.5400714451629457`*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"1", "/", "2"}], 
     RowBox[{"1", "+", 
      RowBox[{"\[CapitalPhi]", "/", "2"}]}]],
    FontFamily->"Times",
    FontSize->24], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{
      SqrtBox["3"], "\[CapitalPhi]"}], "2"],
    FontFamily->"Times",
    FontSize->24], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     SqrtBox[
      StyleBox["15",
       FontSize->17.039993286132812`]], "10"],
    FontFamily->"Times",
    FontSize->24], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "."
}], "Text",
 CellChangeTimes->{{3.5399862680154*^9, 3.5399862680173407`*^9}, {
  3.540071471177636*^9, 3.540071579277017*^9}},
 TextAlignment->Center],

Cell[BoxData[
 GraphicsBox[{
   GraphicsComplexBox[
    NCache[{{Rational[-1, 2] - GoldenRatio, Rational[1, 2] 
       3^Rational[1, 2] (1 + 2 GoldenRatio)}, {
      Rational[1, 2] + GoldenRatio, Rational[1, 2] 
       3^Rational[1, 2] (1 + 2 GoldenRatio)}, {0, 0}, {
      Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2] (1 + 2 GoldenRatio)}, {
      Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] (1 + 2 GoldenRatio)}, {
      Rational[1, 2] (1 + GoldenRatio), Rational[1, 2] 
       3^Rational[1, 2] (1 + GoldenRatio)}, {
      Rational[1, 2] (-1 - GoldenRatio), Rational[1, 2] 
       3^Rational[1, 2] (1 + GoldenRatio)}, {
      Rational[1, 2] (1 + GoldenRatio), Rational[1, 2] 
       3^Rational[1, 2] (1 + 2 GoldenRatio)}, {
      0, Rational[1, 2] 3^Rational[1, 2] (1 + 2 GoldenRatio)}, {
      0, Rational[-1, 2] Rational[3, 5]^Rational[1, 2] + 
       Rational[1, 2] 
        3^Rational[1, 2] (1 + 2 GoldenRatio)}}, {{-2.118033988749895, 
      3.6685424806725857`}, {2.118033988749895, 3.6685424806725857`}, {0, 
      0}, {-0.5, 3.6685424806725857`}, {0.5, 3.6685424806725857`}, {
      1.3090169943749475`, 2.267283942228512}, {-1.3090169943749475`, 
      2.267283942228512}, {1.3090169943749475`, 3.6685424806725857`}, {
      0, 3.6685424806725857`}, {0, 3.281244146051844}}], 
    LineBox[{{1, 2, 3, 1}, {4, 6}, {5, 7}, {6, 8}, {9, 10}}]], InsetBox[
    StyleBox["\<\"1\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {0, 3.8}], InsetBox[
    StyleBox["\<\"\[CapitalPhi]/2\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {0.9, 3.8}], InsetBox[
    StyleBox["\<\"\\!\\(\\*FractionBox[\\(\\*SqrtBox[\\(3\\)] \
\[CapitalPhi]\\), \\(2\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->12], {1.1, 3.2}], InsetBox[
    StyleBox["\<\"C\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {2.2, 3.8}], InsetBox[
    StyleBox["\<\"B\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {-2.2, 3.8}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(A\\), \\(1\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {-0.5, 3.8}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(A\\), \\(2\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {0.5, 3.8}], InsetBox[
    StyleBox["\<\"A\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {0, -0.1}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(B\\), \\(1\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {1.5, 2.25}], InsetBox[
    StyleBox["\<\"Q\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {1.3, 3.75}], InsetBox[
    StyleBox["\<\"P\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {0, 3.1}]}]], "Output",
 CellChangeTimes->{
  3.540070971934885*^9, 3.540071002303596*^9, {3.5400713786740513`*^9, 
   3.540071388847165*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "De aqu\[IAcute] se sigue a su vez que el lado ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "1"], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox["P",
  FontFamily->"Times"],
 " mide ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox["10"], "/", "5"}], TraditionalForm]],
  FontFamily->"Times"],
 ", y su \[AAcute]rea es ",
 Cell[BoxData[
  FormBox[
   SqrtBox["15"], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox["/20",
  FontFamily->"Times"],
 ". Para estudiar el tri\[AAcute]ngulo ",
 StyleBox["B",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "1"], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["P",
     FontFamily->"Times",
     FontSlant->"Plain"], "1"], TraditionalForm]]],
 " consideramos la figura siguiente:"
}], "Text",
 CellChangeTimes->{{3.54007175448048*^9, 3.540071773869877*^9}, {
  3.5400718045068417`*^9, 3.540071859247492*^9}, {3.5400738623017607`*^9, 
  3.540073888851819*^9}}],

Cell[BoxData[
 GraphicsBox[{
   GraphicsComplexBox[
    NCache[{{Rational[-1, 2] - GoldenRatio, Rational[1, 2] 
       3^Rational[1, 2] (1 + 2 GoldenRatio)}, {
      Rational[1, 2] + GoldenRatio, Rational[1, 2] 
       3^Rational[1, 2] (1 + 2 GoldenRatio)}, {0, 0}, {
      Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2] (1 + 2 GoldenRatio)}, {
      Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] (1 + 2 GoldenRatio)}, {
      Rational[1, 2] GoldenRatio, Rational[1, 2] 3^Rational[1, 2] 
       GoldenRatio}, {
      Rational[-1, 2] GoldenRatio, Rational[1, 2] 3^Rational[1, 2] 
       GoldenRatio}, {
      Rational[1, 2] (1 + GoldenRatio), Rational[1, 2] 
       3^Rational[1, 2] (1 + GoldenRatio)}, {
      Rational[1, 2] (-1 - GoldenRatio), Rational[1, 2] 
       3^Rational[1, 2] (1 + GoldenRatio)}}, {{-2.118033988749895, 
      3.6685424806725857`}, {2.118033988749895, 3.6685424806725857`}, {0, 
      0}, {-0.5, 3.6685424806725857`}, {0.5, 3.6685424806725857`}, {
      0.8090169943749475, 1.4012585384440734`}, {-0.8090169943749475, 
      1.4012585384440734`}, {1.3090169943749475`, 
      2.267283942228512}, {-1.3090169943749475`, 2.267283942228512}}], 
    LineBox[{{1, 2, 3, 1}, {4, 6}, {1, 8}, {4, 8}, {7, 6}, {5, 9}, {7, 4}, {7,
       5}}]], InsetBox[
    StyleBox["\<\"1\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {0, 3.8}], InsetBox[
    StyleBox["\<\"\[CapitalPhi]\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {1.3, 3.8}], InsetBox[
    StyleBox["\<\"C\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {2.2, 3.8}], InsetBox[
    StyleBox["\<\"B\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {-2.2, 3.8}], InsetBox[
    StyleBox["\<\"\[CapitalPhi]\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {-1.3, 3.8}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(A\\), \\(1\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {-0.5, 3.8}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(A\\), \\(2\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {0.5, 3.8}], InsetBox[
    StyleBox["\<\"T\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {0, 2.6}], InsetBox[
    StyleBox["\<\"A\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {0, -0.1}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(P\\), \\(1\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {-0.65, 3.2}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(B\\), \\(2\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {0.95, 1.4}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(B\\), \\(1\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {1.4, 2.25}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(C\\), \\(1\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {-1.4, 2.25}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(C\\), \\(2\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {-0.95, 1.4}], InsetBox[
    StyleBox["\<\"P\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {0, 3.4}]}]], "Output",
 CellChangeTimes->{3.540073838236607*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Como los tri\[AAcute]ngulos ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times",
     FontSlant->"Plain"], "1"], TraditionalForm]]],
 StyleBox["C",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["B",
     FontFamily->"Times",
     FontSlant->"Plain"], "2"], TraditionalForm]]],
 " y ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["C",
     FontFamily->"Times"], "2"], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["B",
     FontFamily->"Times"], "2"], TraditionalForm]]],
 StyleBox["A",
  FontFamily->"Times"],
 " son equil\[AAcute]teros, los tri\[AAcute]ngulos ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "1"], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["B",
     FontFamily->"Times"], "1"], TraditionalForm]]],
 StyleBox["C",
  FontFamily->"Times"],
 " y ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "1"], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["C",
     FontFamily->"Times"], "2"], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["B",
     FontFamily->"Times"], "2"], TraditionalForm]]],
 " son iguales, pues tienen un \[AAcute]ngulo de ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["60",
     FontFamily->"Times"], "\[SmallCircle]"], TraditionalForm]]],
 " y dos lados iguales. Esto hace que los tri\[AAcute]ngulos ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "1"], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "2"], TraditionalForm]]],
 StyleBox["P",
  FontFamily->"Times"],
 " y ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "1"], TraditionalForm]]],
 StyleBox["T",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["P",
     FontFamily->"Times"], "1"], TraditionalForm]]],
 " sean iguales, pues tienen un lado igual, un \[AAcute]ngulo igual, y ambos \
son is\[OAcute]sceles, el segundo debido a que el tri\[AAcute]ngulo ",
 StyleBox["B",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "2"], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["C",
     FontFamily->"Times"], "2"], TraditionalForm]]],
 " es equil\[AAcute]tero. As\[IAcute] ya tenemos que ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "1"], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["P",
     FontFamily->"Times"], "1"], TraditionalForm]]],
 " es igual a ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "1"], TraditionalForm]]],
 StyleBox["P",
  FontFamily->"Times"],
 " (cosa que se deduc\[IAcute]a tambi\[EAcute]n de la figura tridimensional, \
ya que esos dos segmentos de dos caras distintas forman una misma arista del \
gran icosaedro). Seguidamente observamos que la altura del tri\[AAcute]ngulo ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "1"], TraditionalForm]],
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox["A", "2"], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox["T",
  FontFamily->"Times"],
 " es ",
 Cell[BoxData[
  FormBox[
   SqrtBox["3"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times"],
 StyleBox["/2",
  FontFamily->"Times"],
 ", luego ",
 StyleBox["BT",
  FontFamily->"Times"],
 " mide"
}], "Text",
 CellChangeTimes->{{3.540073899964858*^9, 3.540074037805306*^9}, {
  3.540074070239393*^9, 3.540074180012734*^9}, {3.5400742181587353`*^9, 
  3.540074309559189*^9}, {3.540074339591907*^9, 3.540074408895814*^9}, {
  3.540101994469017*^9, 3.540102021915391*^9}, {3.5401026051851873`*^9, 
  3.540102605480852*^9}, {3.5401026400677557`*^9, 3.540102733732574*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"\[CapitalPhi]", "+", 
         RowBox[{"1", "/", "2"}]}], ")"}], "2"], " ", "+", " ", 
      RowBox[{"3", "/", "4"}]}],
     FontFamily->"Times"]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "= ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"3", "+", 
     SqrtBox["5"]}]], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times"],
 "= ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox["2",
     FontFamily->"Times",
     FontSlant->"Plain"]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "\[CapitalPhi]."
}], "Text",
 CellChangeTimes->{{3.5401027432147083`*^9, 3.540102743223969*^9}, {
   3.540102994803838*^9, 3.540103041623541*^9}, {3.540104045373567*^9, 
   3.540104051264064*^9}, {3.5401041301300917`*^9, 3.540104138501663*^9}, 
   3.5401047880360823`*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Por consiguiente, ",
 StyleBox["B",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["P",
     FontFamily->"Times",
     FontSlant->"Plain"], "1"], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox["2",
     FontFamily->"Times",
     FontSlant->"Plain"]], TraditionalForm]]],
 "\[CapitalPhi] - ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox["10"], "/", "5"}], TraditionalForm]],
  FontFamily->"Times"],
 " = ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox["2",
     FontFamily->"Times",
     FontSlant->"Plain"]], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"5", "+", 
     RowBox[{"3", 
      SqrtBox["5"]}]}], "10"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 ". Ahora, una proporci\[OAcute]n a partir de la altura del tri\[AAcute]ngulo \
",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "1"], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "2"], TraditionalForm]]],
 StyleBox["T",
  FontFamily->"Times"],
 " nos da la altura del tri\[AAcute]ngulo ",
 StyleBox["B",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "1"], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["P",
     FontFamily->"Times",
     FontSlant->"Plain"], "1"], TraditionalForm]]],
 ", que resulta ser:"
}], "Text",
 CellChangeTimes->{{3.5400739001220407`*^9, 3.540073900123719*^9}, {
  3.540104081120268*^9, 3.540104123255505*^9}, {3.540104154879827*^9, 
  3.540104182524928*^9}, {3.540104367774189*^9, 3.540104432014873*^9}, {
  3.5401061504672422`*^9, 3.540106220645891*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     SubscriptBox["BP", "1"], "BT"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     SqrtBox["3"], "2"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{
      SqrtBox["3"], 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"3", 
         SqrtBox["5"]}]}], ")"}]}], 
     RowBox[{"20", "\[CapitalPhi]"}]],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.54010622854887*^9, 3.540106402908368*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Por lo tanto, el \[AAcute]rea es ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "2"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "\[CapitalPhi]",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{
      SqrtBox["3"], 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"3", 
         SqrtBox["5"]}]}], ")"}]}], 
     RowBox[{"20", "\[CapitalPhi]"}]],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 "= ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{
      SqrtBox["3"], 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"3", 
         SqrtBox["5"]}]}], ")"}]}], "40"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 " y el \[AAcute]rea total del gran icosaedro es"
}], "Text",
 CellChangeTimes->{{3.5400739002660027`*^9, 3.5400739002676907`*^9}, {
  3.540106442284759*^9, 3.5401065179273767`*^9}}],

Cell[TextData[{
 StyleBox["120",
  FontFamily->"Times"],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{
      SqrtBox["3"], 
      RowBox[{"(", 
       RowBox[{"5", "+", 
        RowBox[{"3", 
         SqrtBox["5"]}]}], ")"}]}], "40"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 "+ ",
 StyleBox["60",
  FontFamily->"Times"],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     SqrtBox["15"], "20"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 " = ",
 StyleBox["3",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox["3"], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox["(5+4",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox["5"], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox[").",
  FontFamily->"Times"]
}], "Text",
 CellChangeTimes->{{3.540106870536436*^9, 3.5401069282646646`*^9}, {
  3.5401070114199457`*^9, 3.540107037778285*^9}},
 TextAlignment->Center],

Cell["\<\
Esto es v\[AAcute]lido para un gran icosaedro construido sobre un dodecaedro \
de arista unitaria (luego de arista 2\[CapitalPhi]+1). Por consiguiente, el \
\[AAcute]rea en funci\[OAcute]n del lado es\
\>", "Text",
 CellChangeTimes->{{3.540073900402007*^9, 3.5400739004040833`*^9}, {
  3.540107043904748*^9, 3.540107061384962*^9}, {3.5401071039935083`*^9, 
  3.540107133233637*^9}, {3.540107318220998*^9, 3.5401073182242928`*^9}}],

Cell[TextData[{
 StyleBox["S",
  FontFamily->"Times"],
 " =",
 StyleBox[" ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{
     StyleBox["3",
      FontFamily->"Times"], 
     FormBox[
      SqrtBox["3"],
      TraditionalForm], 
     RowBox[{
      StyleBox["(",
       FontFamily->"Times"], 
      RowBox[{
       StyleBox["5",
        FontFamily->"Times"], 
       StyleBox["+",
        FontFamily->"Times"], 
       RowBox[{
        StyleBox["4",
         FontFamily->"Times"], 
        FormBox[
         SqrtBox["5"],
         TraditionalForm]}]}], 
      StyleBox[")",
       FontFamily->"Times"]}], 
     SuperscriptBox["l", "2"]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "\[CapitalPhi]"}], "+", "1"}], ")"}], "2"]], 
   TraditionalForm]],
  FontFamily->"Times"],
 "=",
 StyleBox["3",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox["3"], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox["(16",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox["5"], TraditionalForm]],
  FontFamily->"Times"],
 "-",
 StyleBox["35) ",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["l",
     FontFamily->"Times",
     FontSize->18], "2"], TraditionalForm]]],
 StyleBox[".",
  FontFamily->"Times"]
}], "Text",
 CellChangeTimes->{{3.5401073183551273`*^9, 3.540107321443409*^9}, {
   3.540107427427662*^9, 3.5401075392396383`*^9}, 3.54010757047232*^9},
 TextAlignment->Center],

Cell[TextData[{
 "El c\[AAcute]lculo del volumen es m\[AAcute]s complicado. Teniendo en \
cuenta la f\[OAcute]rmula para el radio de un pent\[AAcute]gono regular, es f\
\[AAcute]cil ver que la altura de una pir\[AAcute]mide pentagonal formada por \
tri\[AAcute]ngulos equil\[AAcute]teros de lado unitario es ",
 StyleBox["h",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    FractionBox[
     RowBox[{"5", "-", 
      SqrtBox["5"]}], "10"]], TraditionalForm]]],
 ", luego su volumen es "
}], "Text",
 CellChangeTimes->{{3.540107318515049*^9, 3.5401073185163097`*^9}, {
  3.5401076367698097`*^9, 3.5401076432310553`*^9}, {3.540110970771138*^9, 
  3.54011104111609*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "3"],
    FontFamily->"Times"], TraditionalForm]],
  FontSize->18],
 StyleBox[" ",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["5", "4"],
    FontFamily->"Times"], TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox[
     FractionBox[
      RowBox[{"5", "+", 
       RowBox[{"2", 
        SqrtBox["5"]}]}], "5"],
     FontFamily->"Times"]], TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox[
     FractionBox[
      RowBox[{"5", "-", 
       SqrtBox["5"]}], "10"],
     FontFamily->"Times"]], TraditionalForm]],
  FontSize->18],
 StyleBox["= ",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "12"],
    FontFamily->"Times"], TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox[
     FractionBox[
      RowBox[{"15", "+", 
       RowBox[{"5", 
        SqrtBox["5"]}]}], "2"],
     FontFamily->"Times"]], TraditionalForm]],
  FontSize->18],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"5", "+", 
      SqrtBox["5"]}], "24"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.540107657121908*^9, 3.540107657127062*^9}, {
   3.540111175371358*^9, 3.540111254338076*^9}, {3.540111347445524*^9, 
   3.540111348955768*^9}, 3.540117218192761*^9, {3.5403108079903812`*^9, 
   3.54031080843547*^9}, {3.540310861129531*^9, 3.540310866966248*^9}, {
   3.5403108977748747`*^9, 3.540310907974729*^9}},
 TextAlignment->Center],

Cell["\<\
Por consiguiente, el volumen del dodecaedro \[OpenCurlyDoubleQuote]abombado\
\[CloseCurlyDoubleQuote] por pir\[AAcute]mides pentagonales es\
\>", "Text",
 CellChangeTimes->{{3.54010765726257*^9, 3.540107657264575*^9}, {
  3.540111367366496*^9, 3.540111375318801*^9}, {3.540111434385297*^9, 
  3.540111445191442*^9}, {3.540111498672982*^9, 3.540111498675294*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["V",
     FontFamily->"Times"], "0"], TraditionalForm]],
  FontSize->18],
 StyleBox[" = ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"15", "+", 
     RowBox[{"7", 
      SqrtBox["5"]}]}], "4"], TraditionalForm]],
  FontSize->18],
 StyleBox[" - ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"5", "+", 
      SqrtBox["5"]}], "2"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]],
  FontSize->18],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"5", "+", 
      RowBox[{"5", 
       SqrtBox["5"]}]}], "4"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm"]
}], "Text",
 CellChangeTimes->{{3.540111499791646*^9, 3.54011156185933*^9}, {
  3.540310881295817*^9, 3.5403108836546497`*^9}, {3.540310963020734*^9, 
  3.54031098023654*^9}, {3.5403110298929873`*^9, 3.5403110576078997`*^9}},
 TextAlignment->Center],

Cell["\<\
El volumen del gran icosaedro ser\[AAcute] la suma de este volumen \
m\[AAcute]s el volumen de las doce \[OpenCurlyDoubleQuote]puntas\
\[CloseCurlyDoubleQuote] que hay que insertar en los huecos dejados por las \
pir\[AAcute]mides. La figura siguiente nos permite estudiar su estructura:\
\>", "Text",
 CellChangeTimes->{{3.540111592331675*^9, 3.5401116462972937`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      StyleBox[
       DynamicModuleBox[{$CellContext`b$$ = True, $CellContext`c1$$ = 
        True, $CellContext`c2$$ = True, $CellContext`i1$$ = 
        True, $CellContext`i2$$ = True, $CellContext`i3$$ = 
        True, $CellContext`i4$$ = True, $CellContext`i5$$ = 
        True, $CellContext`s1$$ = True, $CellContext`s2$$ = 
        True, $CellContext`s3$$ = True, $CellContext`s4$$ = 
        True, $CellContext`s5$$ = True, Typeset`show$$ = True, 
        Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
        Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
        "\"untitled\"", Typeset`specs$$ = {{{
           Hold[$CellContext`c1$$], True, 
           "Pir\[AAcute]mide central superior"}, {True, False}}, {{
           Hold[$CellContext`c2$$], True, 
           "Pir\[AAcute]mide central inferior"}, {True, False}}, {{
           Hold[$CellContext`b$$], True, "Pir\[AAcute]mide base"}, {
          True, False}}, {{
           Hold[$CellContext`s1$$], True, "Pir\[AAcute]mide superior 1"}, {
          True, False}}, {{
           Hold[$CellContext`s2$$], True, "Pir\[AAcute]mide superior 2"}, {
          True, False}}, {{
           Hold[$CellContext`s3$$], True, "Pir\[AAcute]mide superior 3"}, {
          True, False}}, {{
           Hold[$CellContext`s4$$], True, "Pir\[AAcute]mide superior 4"}, {
          True, False}}, {{
           Hold[$CellContext`s5$$], True, "Pir\[AAcute]mide superior 5"}, {
          True, False}}, {{
           Hold[$CellContext`i1$$], True, "Pir\[AAcute]mide inferior 1"}, {
          True, False}}, {{
           Hold[$CellContext`i2$$], True, "Pir\[AAcute]mide inferior 2"}, {
          True, False}}, {{
           Hold[$CellContext`i3$$], True, "Pir\[AAcute]mide inferior 3"}, {
          True, False}}, {{
           Hold[$CellContext`i4$$], True, "Pir\[AAcute]mide inferior 4"}, {
          True, False}}, {{
           Hold[$CellContext`i5$$], True, "Pir\[AAcute]mide inferior 5"}, {
          True, False}}, {
          Hold[
           Grid[{{
              Button[
              "Ocultar todo", {$CellContext`c1$$ = False, $CellContext`c2$$ = 
                False, $CellContext`b$$ = False, $CellContext`s1$$ = 
                False, $CellContext`s2$$ = False, $CellContext`s3$$ = 
                False, $CellContext`s4$$ = False, $CellContext`s5$$ = 
                False, $CellContext`i1$$ = False, $CellContext`i2$$ = 
                False, $CellContext`i3$$ = False, $CellContext`i4$$ = 
                False, {$CellContext`i5$$ = False}}], 
              Button[
              "Mostrar todo", {$CellContext`c1$$ = True, $CellContext`c2$$ = 
                True, $CellContext`b$$ = True, $CellContext`s1$$ = 
                True, $CellContext`s2$$ = True, $CellContext`s3$$ = 
                True, $CellContext`s4$$ = True, $CellContext`s5$$ = 
                True, $CellContext`i1$$ = True, $CellContext`i2$$ = 
                True, $CellContext`i3$$ = True, $CellContext`i4$$ = 
                True, {$CellContext`i5$$ = True}}]}}]], 
          Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
        360., {193., 198.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
        Typeset`skipInitDone$$ = True, $CellContext`c1$8792$$ = 
        False, $CellContext`c2$8793$$ = False, $CellContext`b$8794$$ = 
        False, $CellContext`s1$8795$$ = False, $CellContext`s2$8796$$ = 
        False, $CellContext`s3$8797$$ = False, $CellContext`s4$8798$$ = 
        False, $CellContext`s5$8799$$ = False, $CellContext`i1$8800$$ = 
        False, $CellContext`i2$8801$$ = False, $CellContext`i3$8802$$ = 
        False, $CellContext`i4$8803$$ = False}, 
        DynamicBox[Manipulate`ManipulateBoxes[
         1, StandardForm, 
          "Variables" :> {$CellContext`b$$ = True, $CellContext`c1$$ = 
            True, $CellContext`c2$$ = True, $CellContext`i1$$ = 
            True, $CellContext`i2$$ = True, $CellContext`i3$$ = 
            True, $CellContext`i4$$ = True, $CellContext`i5$$ = 
            True, $CellContext`s1$$ = True, $CellContext`s2$$ = 
            True, $CellContext`s3$$ = True, $CellContext`s4$$ = 
            True, $CellContext`s5$$ = True}, "ControllerVariables" :> {
            Hold[$CellContext`c1$$, $CellContext`c1$8792$$, False], 
            Hold[$CellContext`c2$$, $CellContext`c2$8793$$, False], 
            Hold[$CellContext`b$$, $CellContext`b$8794$$, False], 
            Hold[$CellContext`s1$$, $CellContext`s1$8795$$, False], 
            Hold[$CellContext`s2$$, $CellContext`s2$8796$$, False], 
            Hold[$CellContext`s3$$, $CellContext`s3$8797$$, False], 
            Hold[$CellContext`s4$$, $CellContext`s4$8798$$, False], 
            Hold[$CellContext`s5$$, $CellContext`s5$8799$$, False], 
            Hold[$CellContext`i1$$, $CellContext`i1$8800$$, False], 
            Hold[$CellContext`i2$$, $CellContext`i2$8801$$, False], 
            Hold[$CellContext`i3$$, $CellContext`i3$8802$$, False], 
            Hold[$CellContext`i4$$, $CellContext`i4$8803$$, False]}, 
          "OtherVariables" :> {
           Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
            Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
            Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
            Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
          Graphics3D[{{
              Opacity[0], 
              
              Sphere[{0, 
                0, -(5/(2 (50 - 10 5^Rational[1, 2])^Rational[1, 2])) - 1/(
                2 (10 - 2 5^Rational[1, 2])^
                 Rational[1, 2]) + (1/2) ((1/5) (5 + 2 5^Rational[1, 2]))^
                  Rational[1, 2]}, 
               5/(2 (50 - 10 5^Rational[1, 2])^Rational[1, 2]) - 1/(
               2 (10 - 2 5^Rational[1, 2])^
                Rational[1, 2]) + (1/2) ((1/5) (5 + 2 5^Rational[1, 2]))^
                 Rational[1, 2]]}, {
              GrayLevel[0.6], 
              
              GraphicsComplex[{{
                0, 0, -(5/(50 - 10 5^Rational[1, 2])^Rational[1, 2])}, {(1 + 
                  5^Rational[1, 2])/(
                 2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), -(1/2), -(
                  1/(10 - 2 5^Rational[1, 2])^
                  Rational[1, 2])}, {-((-1 + 5^Rational[1, 2])/(
                  2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (-(1/
                   2)) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                  Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
                  Rational[1, 2])}, {-(2/(5 - 5^Rational[1, 2]))^
                  Rational[1, 2], 
                 0, -(1/(10 - 2 5^Rational[1, 2])^
                  Rational[1, 2])}, {-((-1 + 5^Rational[1, 2])/(
                  2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (1/
                  2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
                  Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
                  Rational[1, 2])}, {(1 + 5^Rational[1, 2])/(
                 2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), 1/
                 2, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {(1/
                  10) ((1/2) (5 - 5^Rational[1, 2]))^
                  Rational[1, 2], ((1/40) (-5 + 5^Rational[1, 2])) (
                  2 + (2 (3 + 5^Rational[1, 2]))^Rational[1, 2]), (-10 + 
                  5^Rational[1, 2])/(
                 5 (10 - 2 5^Rational[1, 2])^
                  Rational[1, 2])}, {-((5 + 5^Rational[1, 2])/(
                  10 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), ((1/20) (-5 + 
                   5^Rational[1, 2])) ((1/2) (3 + 5^Rational[1, 2]))^
                  Rational[1, 2], (-10 + 5^Rational[1, 2])/(
                 5 (10 - 2 5^Rational[1, 2])^
                  Rational[1, 2])}, {-((5 + 5^Rational[1, 2])/(
                  10 (10 - 2 5^Rational[1, 2])^
                   Rational[1, 2])), ((-(1/20)) (-5 + 
                   5^Rational[1, 2])) ((1/2) (3 + 5^Rational[1, 2]))^
                  Rational[1, 2], (-10 + 5^Rational[1, 2])/(
                 5 (10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {(1/
                  10) ((1/2) (5 - 5^Rational[1, 2]))^
                  Rational[1, 2], ((-(1/40)) (-5 + 5^Rational[1, 2])) (
                  2 + (2 (3 + 5^Rational[1, 2]))^Rational[1, 2]), (-10 + 
                  5^Rational[1, 2])/(
                 5 (10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {
                2/(50 - 10 5^Rational[1, 2])^Rational[1, 2], 
                 0, (-10 + 5^Rational[1, 2])/(
                 5 (10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {
                0, 0, -(1/(10 - 2 5^Rational[1, 2])^
                   Rational[1, 2]) + ((5 + 2 5^Rational[1, 2])/5)^
                  Rational[1, 2]}}, {
                If[$CellContext`b$$, 
                 
                 Polygon[{{1, 2, 3}, {1, 3, 4}, {1, 4, 5}, {1, 5, 6}, {1, 6, 
                  2}}]], 
                If[$CellContext`c1$$, 
                 
                 Polygon[{{7, 8, 9, 10, 11}, {12, 7, 8}, {12, 8, 9}, {12, 9, 
                   10}, {12, 10, 11}, {12, 11, 7}}]], 
                If[$CellContext`c2$$, 
                 
                 Polygon[{{7, 8, 9, 10, 11}, {1, 7, 8}, {1, 8, 9}, {1, 9, 
                   10}, {1, 10, 11}, {1, 11, 7}}]], 
                If[$CellContext`s1$$, 
                 Polygon[{{12, 7, 2}, {12, 2, 11}, {12, 11, 7}, {7, 11, 2}}]], 
                If[$CellContext`s2$$, 
                 Polygon[{{12, 3, 7}, {12, 3, 8}, {12, 7, 8}, {3, 7, 8}}]], 
                If[$CellContext`s3$$, 
                 Polygon[{{12, 4, 8}, {12, 4, 9}, {12, 8, 9}, {4, 8, 9}}]], 
                If[$CellContext`s4$$, 
                 Polygon[{{12, 5, 9}, {12, 5, 10}, {12, 9, 10}, {5, 9, 10}}]], 
                If[$CellContext`s5$$, 
                 
                 Polygon[{{12, 6, 10}, {12, 6, 11}, {10, 11, 6}, {12, 10, 
                  11}}]], 
                If[$CellContext`i1$$, 
                 Polygon[{{1, 7, 2}, {1, 2, 11}, {1, 11, 7}, {7, 11, 2}}]], 
                If[$CellContext`i2$$, 
                 Polygon[{{1, 7, 3}, {7, 8, 1}, {1, 8, 3}, {7, 3, 8}}]], 
                If[$CellContext`i3$$, 
                 Polygon[{{4, 8, 9}, {1, 8, 4}, {1, 4, 9}, {1, 8, 9}}]], 
                If[$CellContext`i4$$, 
                 Polygon[{{9, 10, 1}, {9, 10, 5}, {9, 1, 5}, {10, 1, 5}}]], 
                If[$CellContext`i5$$, 
                 
                 Polygon[{{10, 11, 1}, {1, 10, 6}, {1, 11, 6}, {10, 11, 
                  6}}]]}]}}, Lighting -> "Neutral", Boxed -> False], 
          "Specifications" :> {{{$CellContext`c1$$, True, 
              "Pir\[AAcute]mide central superior"}, {True, False}, 
             ControlPlacement -> 
             Left}, {{$CellContext`c2$$, True, 
              "Pir\[AAcute]mide central inferior"}, {True, False}, 
             ControlPlacement -> 
             Left}, {{$CellContext`b$$, True, "Pir\[AAcute]mide base"}, {
             True, False}, ControlPlacement -> Left}, 
            Delimiter, {{$CellContext`s1$$, True, 
              "Pir\[AAcute]mide superior 1"}, {True, False}, ControlPlacement -> 
             Left}, {{$CellContext`s2$$, True, 
              "Pir\[AAcute]mide superior 2"}, {True, False}, ControlPlacement -> 
             Left}, {{$CellContext`s3$$, True, 
              "Pir\[AAcute]mide superior 3"}, {True, False}, ControlPlacement -> 
             Left}, {{$CellContext`s4$$, True, 
              "Pir\[AAcute]mide superior 4"}, {True, False}, ControlPlacement -> 
             Left}, {{$CellContext`s5$$, True, 
              "Pir\[AAcute]mide superior 5"}, {True, False}, ControlPlacement -> 
             Left}, Delimiter, {{$CellContext`i1$$, True, 
              "Pir\[AAcute]mide inferior 1"}, {True, False}, ControlPlacement -> 
             Left}, {{$CellContext`i2$$, True, 
              "Pir\[AAcute]mide inferior 2"}, {True, False}, ControlPlacement -> 
             Left}, {{$CellContext`i3$$, True, 
              "Pir\[AAcute]mide inferior 3"}, {True, False}, ControlPlacement -> 
             Left}, {{$CellContext`i4$$, True, 
              "Pir\[AAcute]mide inferior 4"}, {True, False}, ControlPlacement -> 
             Left}, {{$CellContext`i5$$, True, 
              "Pir\[AAcute]mide inferior 5"}, {True, False}, ControlPlacement -> 
             Left}, 
            Grid[{{
               Button[
               "Ocultar todo", {$CellContext`c1$$ = False, $CellContext`c2$$ = 
                 False, $CellContext`b$$ = False, $CellContext`s1$$ = 
                 False, $CellContext`s2$$ = False, $CellContext`s3$$ = 
                 False, $CellContext`s4$$ = False, $CellContext`s5$$ = 
                 False, $CellContext`i1$$ = False, $CellContext`i2$$ = 
                 False, $CellContext`i3$$ = False, $CellContext`i4$$ = 
                 False, {$CellContext`i5$$ = False}}], 
               Button[
               "Mostrar todo", {$CellContext`c1$$ = True, $CellContext`c2$$ = 
                 True, $CellContext`b$$ = True, $CellContext`s1$$ = 
                 True, $CellContext`s2$$ = True, $CellContext`s3$$ = 
                 True, $CellContext`s4$$ = True, $CellContext`s5$$ = 
                 True, $CellContext`i1$$ = True, $CellContext`i2$$ = 
                 True, $CellContext`i3$$ = True, $CellContext`i4$$ = 
                 True, {$CellContext`i5$$ = True}}]}}]}, 
          "Options" :> {AppearanceElements -> {}}, "DefaultOptions" :> {}],
         ImageSizeCache->{542., {232., 238.}},
         SingleEvaluation->True],
        Deinitialization:>None,
        DynamicModuleValues:>{},
        SynchronousInitialization->True,
        UnsavedVariables:>{Typeset`initDone$$},
        UntrackedVariables:>{Typeset`size$$}], "Manipulate",
       Deployed->True,
       StripOnInput->False],
      Manipulate`InterpretManipulate[1]], 
     GraphicsBox[{
       GraphicsComplexBox[
        NCache[{{
          Rational[-1, 2] - 
           GoldenRatio, (Rational[1, 2] 3^Rational[1, 2]) (1 + 
            2 GoldenRatio)}, {
          Rational[1, 2] + 
           GoldenRatio, (Rational[1, 2] 3^Rational[1, 2]) (1 + 
            2 GoldenRatio)}, {0, 0}, {
          Rational[-1, 2], (Rational[1, 2] 3^Rational[1, 2]) (1 + 
            2 GoldenRatio)}, {
          Rational[
           1, 2], (Rational[1, 2] 3^Rational[1, 2]) (1 + 2 GoldenRatio)}, {
          Rational[1, 2] GoldenRatio, (Rational[1, 2] 3^Rational[1, 2]) 
           GoldenRatio}, {
          Rational[-1, 2] GoldenRatio, (Rational[1, 2] 3^Rational[1, 2]) 
           GoldenRatio}, {
          Rational[1, 2] (1 + GoldenRatio), (Rational[1, 2] 
            3^Rational[1, 2]) (1 + GoldenRatio)}, {
          Rational[1, 2] (-1 - GoldenRatio), (Rational[1, 2] 
            3^Rational[1, 2]) (1 + GoldenRatio)}}, {{-2.118033988749895, 
          3.6685424806725857`}, {2.118033988749895, 3.6685424806725857`}, {0, 
          0}, {-0.5, 3.6685424806725857`}, {0.5, 3.6685424806725857`}, {
          0.8090169943749475, 1.4012585384440734`}, {-0.8090169943749475, 
          1.4012585384440734`}, {1.3090169943749475`, 
          2.267283942228512}, {-1.3090169943749475`, 2.267283942228512}}], 
        LineBox[{{1, 2, 3, 1}, {4, 6}, {5, 7}, {8, 9}, {2, 9}, {2, 7}, {1, 
          6}, {1, 8}, {3, 4}, {5, 3}, {4, 8}, {5, 9}, {7, 8}, {5, 6}, {6, 
          9}, {7, 4}}]], InsetBox[
        StyleBox["\<\"1\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {0, 3.8}], InsetBox[
        StyleBox["\<\"\[CapitalPhi]\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {1.3, 3.8}], InsetBox[
        StyleBox["\<\"C\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {2.2, 3.8}], InsetBox[
        StyleBox["\<\"B\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {-2.2, 3.8}], InsetBox[
        StyleBox["\<\"\[CapitalPhi]\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {-1.3, 3.8}], InsetBox[
        StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(A\\), \\(1\\)]\\)\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {-0.5, 3.8}], InsetBox[
        StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(A\\), \\(2\\)]\\)\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {0.5, 3.8}], InsetBox[
        StyleBox["\<\"T\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {0, 2.6}], InsetBox[
        StyleBox["\<\"A\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {0, -0.1}], InsetBox[
        StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(P\\), \\(1\\)]\\)\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {-0.65, 3.2}], InsetBox[
        StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(B\\), \\(1\\)]\\)\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {1.4, 2.25}], InsetBox[
        StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(C\\), \\(2\\)]\\)\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {-1.4, 2.25}], InsetBox[
        StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(B\\), \\(2\\)]\\)\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {0.95, 1.4}], InsetBox[
        StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(C\\), \\(1\\)]\\)\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {-0.95, 1.4}], InsetBox[
        StyleBox["\<\"P\"\>",
         StripOnInput->False,
         FontFamily->"Times",
         FontSize->14], {0, 3.4}]},
      ImageSize->{407., Automatic}]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.540107665831408*^9, 3.540111861837282*^9, {3.540111946568521*^9, 
   3.540111975956316*^9}, 3.540112067915956*^9, 3.540116573817893*^9, 
   3.5411058285470448`*^9},
 TextAlignment->Center],

Cell[TextData[{
 "La pir\[AAcute]mide base es simplemente una pir\[AAcute]mide pentagonal \
formada por tri\[AAcute]ngulos equil\[AAcute]teros. Es la base sobre la que \
est\[AAcute] construida la \[OpenCurlyDoubleQuote]punta\
\[CloseCurlyDoubleQuote]. Si la ocultamos, vemos que \[EAcute]sta \
est\[AAcute] formada por una parte exterior, fomada por diez \
tri\[AAcute]ngulos iguales al tri\[AAcute]ngulo ",
 StyleBox["B",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times"], "1"], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["P",
     FontFamily->"Times",
     FontSlant->"Plain"], "1"], TraditionalForm]]],
 ", y una parte oculta bajo la pir\[AAcute]mide base formada por otros diez \
tri\[AAcute]ngulos iguales al tri\[AAcute]ngulo ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times",
     FontSlant->"Plain"], "1"], TraditionalForm]]],
 StyleBox["PT",
  FontFamily->"Times"],
 ". Podemos descomponer esta figura en diez pir\[AAcute]mides triangulares, \
cinco superiores y cinco inferiores, las cuales encierran otras dos pir\
\[AAcute]mides pentagonales centrales, como se puede ver en la figura \
ocultando algunas de las pir\[AAcute]mides. Calcularemos el volumen de la \
\[OpenCurlyDoubleQuote]punta\[CloseCurlyDoubleQuote] como suma de los vol\
\[UAcute]menes de las doce pir\[AAcute]mides."
}], "Text",
 CellChangeTimes->{{3.54010767875286*^9, 3.540107678755934*^9}, {
  3.54011210994471*^9, 3.540112153678441*^9}, {3.5401157652581053`*^9, 
  3.540115802721571*^9}, {3.540115873557081*^9, 3.5401159337145147`*^9}, {
  3.540116043774246*^9, 3.540116055347652*^9}, {3.540116123655787*^9, 
  3.540116175596476*^9}, {3.540116258677911*^9, 3.540116276821665*^9}, {
  3.540116594582891*^9, 3.540116602550259*^9}}],

Cell["\<\
Para calcular las dimensiones de la pir\[AAcute]mide central inferior \
imaginemos primero que tuviera los v\[EAcute]rtices de su base en los puntos \
medios de las aristas de la base de la pir\[AAcute]mide base. Entonces la \
base ser\[IAcute]a un pent\[AAcute]gono de radio igual a la apotema de la \
base de la pir\[AAcute]mide base, y su altura ser\[IAcute]a la misma que la \
de la pir\[AAcute]mide base. En suma, sus datos ser\[IAcute]an:\
\>", "Text",
 CellChangeTimes->{{3.540156536681058*^9, 3.540156536682418*^9}, {
  3.540157342447448*^9, 3.5401573800771227`*^9}, {3.540157560497504*^9, 
  3.540157636548581*^9}}],

Cell[TextData[{
 StyleBox["r = ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  RowBox[{
   FractionBox["1", "2"], 
   SqrtBox[
    FractionBox[
     RowBox[{"5", "+", 
      RowBox[{"2", 
       SqrtBox["5"]}]}], "5"]]}]],
  CellChangeTimes->{
   3.539024724481698*^9, 3.5392010861606617`*^9, 3.539201330099803*^9, 
    3.539201427762287*^9, 3.5392016994998693`*^9, {3.539201748498741*^9, 
    3.539201762362111*^9}},
  TextAlignment->Center,
  FontFamily->"Times"],
 StyleBox[", l = ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   RowBox[{" ", 
    RowBox[{
     FormBox[
      FractionBox["1", "2"],
      TraditionalForm], " ", 
     FormBox[
      SqrtBox[
       FractionBox[
        RowBox[{"3", "+", 
         SqrtBox["5"]}], "2"]],
      TraditionalForm]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 StyleBox[", h = ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    FractionBox[
     RowBox[{"5", "-", 
      SqrtBox["5"]}], "10"]], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.540157638488453*^9, 3.5401576816016397`*^9}, {
  3.540157899893811*^9, 3.540157940351581*^9}, {3.540158837028111*^9, 
  3.540158837028208*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Ahora bien, la pir\[AAcute]mide inferior real resulta de aplicar a \
\[EAcute]sta una homotecia con centro su v\[EAcute]rtice de modo que sus \
aristas laterales pasen de medir ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox[
     StyleBox["3",
      FontFamily->"Times",
      FontSlant->"Plain"]], "/", 
    StyleBox["2",
     FontFamily->"Times",
     FontSlant->"Plain"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " a tener longitud igual al segmento ",
 StyleBox["PT",
  FontFamily->"Times"],
 ", que mide ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox["3"], "2"], TraditionalForm]]],
 "- ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox["15"], "10"], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox["3",
     FontFamily->"Times",
     FontSlant->"Plain"]], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"5", "-", 
     SqrtBox["5"]}], "10"], TraditionalForm]]],
 ". Por lo tanto, los valores anteriores se contraen en la misma proporcion, \
es decir, ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"5", "-", 
     SqrtBox["5"]}], "5"], TraditionalForm]]],
 " y en realidad son"
}], "Text",
 CellChangeTimes->{{3.5401565367379913`*^9, 3.540156536739306*^9}, {
  3.540157942956374*^9, 3.540158053838686*^9}, {3.540158089608831*^9, 
  3.540158101155677*^9}, {3.540159231253254*^9, 3.540159238175201*^9}}],

Cell[TextData[{
 StyleBox["r = ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "10"],
    FontSlant->"Plain"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SqrtBox[
     RowBox[{"10", "+", 
      RowBox[{"2", 
       SqrtBox["5"]}]}]],
    FontSize->14,
    FontSlant->"Plain"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[", l = ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     SqrtBox["5"], "5"],
    FontSlant->"Plain"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[", h = ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{
     StyleBox["2",
      FontSize->12.779998779296875`,
      FontSlant->"Plain"], 
     SqrtBox[
      StyleBox[
       RowBox[{"5", "-", 
        RowBox[{"2", 
         SqrtBox["5"]}]}],
       FontSize->12.779998779296875`,
       FontSlant->"Plain"]]}], 
    StyleBox["5",
     FontSize->12.779998779296875`,
     FontSlant->"Plain"]], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[".",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{
  3.540158116143667*^9, {3.5401581781401997`*^9, 3.540158201285894*^9}, {
   3.540158276566292*^9, 3.540158287111713*^9}, {3.5401583562302647`*^9, 
   3.540158370661195*^9}, {3.540158759817112*^9, 3.5401587822520638`*^9}, {
   3.5401590750389357`*^9, 3.540159080592003*^9}, 3.540159183258337*^9, {
   3.540159698953361*^9, 3.540159700853477*^9}, {3.5401604525378437`*^9, 
   3.540160482126659*^9}},
 TextAlignment->Center],

Cell["\<\
Con estos datos ya podemos calcular el volumen de la pir\[AAcute]mide central \
inferior, que resulta ser:\
\>", "Text",
 CellChangeTimes->{{3.5401565372821608`*^9, 3.540156537284186*^9}, {
  3.540159259737529*^9, 3.54015928013034*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   StyleBox[
    SubscriptBox[
     StyleBox["V",
      FontFamily->"Times"], "1"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "3"],
    FontSize->18], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox[" ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["5", "4"],
    FontSize->18], TraditionalForm]],
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox[
     FractionBox[
      RowBox[{"5", "+", 
       RowBox[{"2", 
        SqrtBox["5"]}]}], "5"],
     FontSize->18]], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox[" ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "5"],
    FontSize->18], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox[" ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"2", 
      SqrtBox[
       RowBox[{"5", "-", 
        RowBox[{"2", 
         SqrtBox["5"]}]}]]}], "5"],
    FontSize->18], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox[" = ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "30"],
    FontSize->18], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox[".",
  FontFamily->"Times",
  FontSize->18]
}], "Text",
 CellChangeTimes->{{3.5401592854917307`*^9, 3.540159506939144*^9}, {
  3.540159622744206*^9, 3.5401596289496593`*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "De la pir\[AAcute]mide central superior conocemos el lado de la base: ",
 Cell[BoxData[
  FormBox[
   SqrtBox["5"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times"],
 StyleBox["/5",
  FontFamily->"Times"],
 ", el radio de la base, ",
 Cell[BoxData[
  RowBox[{
   FormBox[
    StyleBox[
     FractionBox["1", "10"],
     FontSlant->"Plain"],
    TraditionalForm], 
   FormBox[
    StyleBox[
     SqrtBox[
      RowBox[{"10", "+", 
       RowBox[{"2", 
        SqrtBox["5"]}]}]],
     FontSize->14,
     FontSlant->"Plain"],
    TraditionalForm]}]],
  CellChangeTimes->{{3.540160366367929*^9, 3.540160367534849*^9}, 
    3.540160493724663*^9}],
 " y la arista lateral, ",
 StyleBox["B",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["P",
     FontFamily->"Times",
     FontSlant->"Plain"], "1"], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox["2",
     FontFamily->"Times",
     FontSlant->"Plain"]], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"5", "+", 
     RowBox[{"3", 
      SqrtBox["5"]}]}], "10"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 ". Del radio y la arista lateral sacamos la altura:"
}], "Text",
 CellChangeTimes->{{3.5401179601312227`*^9, 3.540117960132666*^9}, {
   3.5401597473675213`*^9, 3.540159782765544*^9}, {3.5401598448001413`*^9, 
   3.5401598469850616`*^9}, 3.5401599034827957`*^9, {3.540160011788784*^9, 
   3.540160035681884*^9}, {3.5401605172903423`*^9, 3.540160519968006*^9}}],

Cell[TextData[{
 StyleBox["h",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        SqrtBox[
         StyleBox["2",
          FontFamily->"Times",
          FontSlant->"Plain"]], " ", 
        FractionBox[
         RowBox[{"5", "+", 
          RowBox[{"3", 
           SqrtBox["5"]}]}], "10"]}], ")"}], "2"], "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FormBox[
         StyleBox[
          FractionBox["1", "10"],
          FontSlant->"Plain"],
         TraditionalForm], 
        FormBox[
         StyleBox[
          SqrtBox[
           StyleBox[
            RowBox[{"10", "+", 
             RowBox[{"2", 
              SqrtBox["5"]}]}],
            FontFamily->"Times"]],
          FontSize->14,
          FontSlant->"Plain"],
         TraditionalForm]}], ")"}], "2"]}]], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "10"],
    FontSize->18], TraditionalForm]],
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"130", "+", 
     RowBox[{"58", 
      SqrtBox["5"]}]}]], TraditionalForm]],
  FontFamily->"Times"],
 "."
}], "Text",
 CellChangeTimes->{{3.540160036600354*^9, 3.540160103754683*^9}, {
  3.540160526486382*^9, 3.540160526486453*^9}, {3.540160828292624*^9, 
  3.540160853325474*^9}},
 TextAlignment->Center],

Cell["\<\
A su vez de aqu\[IAcute] obtenemos el volumen:\
\>", "Text",
 CellChangeTimes->{{3.5401608711244698`*^9, 3.54016087860505*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["V",
     FontFamily->"Times",
     FontSize->18], "2"], TraditionalForm]]],
 " =",
 StyleBox[" ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   FractionBox["1", "3"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 StyleBox[" ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   FractionBox["5", "4"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    FractionBox[
     RowBox[{"5", "+", 
      RowBox[{"2", 
       SqrtBox["5"]}]}], "5"]], TraditionalForm]],
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "5"],
    FontSize->18], TraditionalForm]],
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "10"],
    FontSize->18], TraditionalForm]],
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox[
     RowBox[{"130", "+", 
      RowBox[{"58", 
       SqrtBox["5"]}]}],
     FontSize->14]], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox[" = ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     SqrtBox[
      RowBox[{"246", "+", 
       RowBox[{"110", 
        SqrtBox["5"]}]}]], "120"],
    FontSize->18], TraditionalForm]],
  FontFamily->"Times"],
 " = ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"11", "+", 
     RowBox[{"5", 
      SqrtBox["5"]}]}], "120"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times",
  FontSize->18],
 "."
}], "Text",
 CellChangeTimes->{{3.540160884557221*^9, 3.5401608957141333`*^9}, {
  3.5401609335403347`*^9, 3.540160935509593*^9}, {3.54016096811567*^9, 
  3.540161013141377*^9}, {3.540161170274415*^9, 3.540161205217744*^9}, {
  3.54031852348475*^9, 3.540318536571907*^9}},
 TextAlignment->Center],

Cell["\<\
Analicemos ahora las pir\[AAcute]mides superiores. Conocemos la longitud de \
todas sus aristas:\
\>", "Text",
 CellChangeTimes->{{3.540107679134861*^9, 3.540107679136857*^9}, {
  3.540237046308095*^9, 3.540237067827614*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0.6], 
    GraphicsComplex3DBox[
     NCache[{{0, Rational[1, 2] 5^Rational[-1, 2], 0}, {
       0, Rational[-1, 2] 5^Rational[-1, 2], 0}, {
       Rational[1, 10] (135 + 60 5^Rational[1, 2])^Rational[1, 2], 0, 
        0}, {(Rational[1, 2] (2 + 5^Rational[1, 2])) (
          15 (9 + 4 5^Rational[1, 2]))^Rational[-1, 2], 0, 3^
        Rational[-1, 2]}}, {{0, 0.22360679774997896`, 0}, {
       0, -0.22360679774997896`, 0}, {1.6406220730259222`, 0, 0}, {
       0.12909944487358055`, 0, 0.5773502691896258}}], 
     Polygon3DBox[{{1, 2, 3}, {1, 2, 4}, {1, 3, 4}, {2, 3, 4}}]]}, 
   Line3DBox[{{-0.1, 0, 0}, {1.8, 0, 0}}], 
   Line3DBox[{{0, -0.3, 0}, {0, 0.3, 0}}], 
   Line3DBox[{{0, 0, -0.1}, {0, 0, 0.7}}], Text3DBox[
    FormBox[
     StyleBox["\<\"\[CapitalPhi]\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], StandardForm], {0.5, 0, 0.5}], Text3DBox[
    FormBox[
     StyleBox["\<\"\\!\\(\\*FractionBox[SqrtBox[\\(10\\)], \\(5\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->12], StandardForm], {0.1, -0.1, 0.3}], Text3DBox[
    FormBox[
     StyleBox["\<\"\\!\\(\\*SqrtBox[\\(2\\)]\\)\\!\\(\\*FractionBox[\\(5 + \
\\(\\(3\\) \\*SqrtBox[\\(5\\)]\\(\\\\ \\)\\)\\), \\(10\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->12], StandardForm], {0.6, -0.1, -0.1}], Text3DBox[
    FormBox[
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(\\*SqrtBox[\\(5\\)]\\(\\\\ \\)\\), \
\\(5\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->12], StandardForm], {-0.1, 0, 0}]},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{349.0936799926029, 168.35420253351208`},
  Lighting->"Neutral",
  ViewPoint->{0.4083758266055466, -3.205031405960935, 1.005486385312261},
  ViewVertical->{0.06111087258409115, -1.0120092708239223`, 
   2.2457667538044204`}]], "Output",
 CellChangeTimes->{3.5402370812644453`*^9},
 TextAlignment->Center],

Cell[TextData[{
 "De aqu\[IAcute] es f\[AAcute]cil deducir que la base es un \
tri\[AAcute]ngulo (is\[OAcute]sceles) de altura ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "10"], TraditionalForm]],
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"135", "+", 
     RowBox[{"60", 
      SqrtBox["5"]}]}]], TraditionalForm]],
  FontFamily->"Times"],
 ", con lo que, en el sistema de referencia indicado en la figura, el v\
\[EAcute]rtice ",
 StyleBox["(x, ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["0",
  FontFamily->"Times",
  FontSize->18],
 StyleBox[", z)",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " cumple"
}], "Text",
 CellChangeTimes->{{3.540237068120035*^9, 3.540237068121648*^9}, {
  3.540237140171187*^9, 3.540237146641177*^9}, {3.5402371821700783`*^9, 
  3.540237217978894*^9}, {3.540237276830566*^9, 3.5402373233366947`*^9}}],

Cell[TextData[{
 StyleBox["(",
  FontFamily->"Times",
  FontSize->18],
 StyleBox["x",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["-",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   FractionBox["1", "10"], TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SqrtBox[
     StyleBox[
      RowBox[{"135", "+", 
       RowBox[{"60", 
        SqrtBox["5"]}]}],
      FontFamily->"Times"]],
    FontSize->14], TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[")", "2"], TraditionalForm]],
  FontSize->18],
 StyleBox[" + ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["z",
     FontFamily->"Times"], 
    StyleBox["2",
     FontFamily->"Times",
     FontSize->12.779998779296875`,
     FontSlant->"Plain"]], TraditionalForm]],
  FontSize->18],
 StyleBox["= ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["\[CapitalPhi]",
     FontFamily->"Times",
     FontSlant->"Plain"], 
    StyleBox["2",
     FontFamily->"Times",
     FontSize->12.779998779296875`,
     FontSlant->"Plain"]], TraditionalForm]],
  FontSize->18],
 StyleBox[",        ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SuperscriptBox[
     StyleBox["x",
      FontFamily->"Times"], "2"],
    FontFamily->"Times"], TraditionalForm]],
  FontSize->18],
 StyleBox[" + ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["5", "100"],
    FontFamily->"Times"], TraditionalForm]],
  FontSize->18],
 StyleBox[" + ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["z",
     FontFamily->"Times"], "2"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 StyleBox[" = ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   FractionBox["10", "25"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 StyleBox[",",
  FontFamily->"Times",
  FontSize->18]
}], "Text",
 CellChangeTimes->{{3.540237327291254*^9, 3.5402374238385*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "de donde se concluye que la altura de la pir\[AAcute]mide es ",
 StyleBox["z",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = ",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox["3"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times"],
 StyleBox["/3",
  FontFamily->"Times"],
 ". Por consiguiente, su volumen es:"
}], "Text",
 CellChangeTimes->{{3.540237068248025*^9, 3.540237068249693*^9}, {
  3.540237426348353*^9, 3.540237427172205*^9}, {3.54023746463174*^9, 
  3.540237491525482*^9}, {3.5402376148419333`*^9, 3.540237625012144*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["V",
     FontFamily->"Times",
     FontSize->18], "3"], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "3"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "2"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     SqrtBox["5"], "5"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "10"],
    FontSize->18], TraditionalForm]],
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"135", "+", 
     RowBox[{"60", 
      SqrtBox["5"]}]}]], TraditionalForm]],
  FontFamily->"Times"],
 " ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox[
     StyleBox["3",
      FontFamily->"Times",
      FontSize->14,
      FontSlant->"Plain"]], 
    StyleBox["3",
     FontFamily->"Times",
     FontSlant->"Plain"]], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "60"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox[
     RowBox[{"9", "+", 
      RowBox[{"4", 
       SqrtBox["5"]}]}],
     FontFamily->"Times"]], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"2", "+", 
     SqrtBox["5"]}], "60"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18]
}], "Text",
 CellChangeTimes->{{3.540237768548911*^9, 3.54023781581288*^9}, {
  3.540237859050942*^9, 3.54023786227489*^9}, {3.540238000818667*^9, 
  3.540238019133497*^9}, {3.540317578573138*^9, 3.540317600852516*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "La situaci\[OAcute]n para las pir\[AAcute]mides inferiores es similar. \
Conocemos las medidas de sus aristas, de donde, tomando como base el tri\
\[AAcute]ngulo que comparte con la pir\[AAcute]mide superior, la altura de la \
base resulta ser ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox["35"], "10"], TraditionalForm]]],
 "y el v\[EAcute]rtice opuesto tiene coordenadas ",
 StyleBox["(x, ",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox["0",
  FontFamily->"Times",
  FontSize->18],
 StyleBox[", z)",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "  que cumplen:"
}], "Text",
 CellChangeTimes->{{3.540239940545906*^9, 3.540239957322667*^9}, {
  3.540239993202569*^9, 3.540240001143914*^9}, {3.540240035320335*^9, 
  3.540240055504304*^9}, {3.540240691162541*^9, 3.54024076461689*^9}, {
  3.540316883188765*^9, 3.540316883188854*^9}}],

Cell[TextData[{
 StyleBox["(x-",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     SqrtBox["35"], "10"],
    FontFamily->"Times"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[")", "2"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 StyleBox[" + ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SuperscriptBox[
     StyleBox["z",
      FontFamily->"Times"], "2"],
    FontFamily->"Times"], TraditionalForm]],
  FontSize->18],
 " ",
 StyleBox["= 1,        ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SuperscriptBox[
     StyleBox["x",
      FontFamily->"Times"], "2"],
    FontFamily->"Times"], TraditionalForm]],
  FontSize->18],
 StyleBox[" + ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["5", "100"],
    FontFamily->"Times"], TraditionalForm]],
  FontSize->18],
 StyleBox[" + ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["z",
     FontFamily->"Times"], "2"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 StyleBox[" = ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"3", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"5", "-", 
         SqrtBox["5"]}], ")"}], "2"]}], "100"],
    FontFamily->"Times"], TraditionalForm]],
  FontSize->18],
 "."
}], "Text",
 CellChangeTimes->{{3.540239957478815*^9, 3.5402399574807043`*^9}, {
   3.54024077493719*^9, 3.54024082957028*^9}, {3.5402408823902493`*^9, 
   3.540240897101087*^9}, {3.540240985308112*^9, 3.540240985571816*^9}, 
   3.54031953487116*^9},
 TextAlignment->Center],

Cell[TextData[{
 "Este sistema tiene por soluci\[OAcute]n ",
 StyleBox["z",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    FractionBox[
     RowBox[{"7", "-", 
      RowBox[{"3", 
       SqrtBox["5"]}]}], "14"]], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times",
  FontSize->18],
 "y \[EAcute]sta es, pues, la altura de la pir\[AAcute]mide."
}], "Text",
 CellChangeTimes->{{3.540239957638804*^9, 3.540239957640688*^9}, {
  3.5402409007132797`*^9, 3.5402410044751663`*^9}, {3.540241156872889*^9, 
  3.540241168184078*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0.6], 
    GraphicsComplex3DBox[
     NCache[{{0, Rational[1, 2] 5^Rational[-1, 2], 0}, {
       0, Rational[-1, 2] 5^Rational[-1, 2], 0}, {
       Rational[1, 2] Rational[7, 5]^Rational[1, 2], 0, 0}, {
       Rational[1, 2] ((-3) 7^Rational[-1, 2] + 2 35^Rational[-1, 2]), 
        0, (Rational[1, 14] (7 - 3 5^Rational[1, 2]))^Rational[1, 2]}}, {{
       0, 0.22360679774997896`, 0}, {0, -0.22360679774997896`, 0}, {
       0.5916079783099616, 0, 0}, {-0.39791585856813744`, 0, 
        0.14436958214958248`}}], 
     Polygon3DBox[{{1, 2, 3}, {1, 2, 4}, {1, 3, 4}, {2, 3, 4}}]]}, 
   Line3DBox[{{-0.1, 0, 0}, {0.7, 0, 0}}], 
   Line3DBox[{{0, -0.3, 0}, {0, 0.3, 0}}], 
   Line3DBox[{{0, 0, -0.1}, {0, 0, 0.3}}], Text3DBox[
    FormBox[
     StyleBox["\<\"1\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], StandardForm], {0.05, 0, 0.1}], Text3DBox[
    FormBox[
     StyleBox["\<\"\\!\\(\\*FractionBox[\\(\\*SqrtBox[\\(3\\)]\\\\ \\((5 - \
\\*SqrtBox[\\(5\\)])\\)\\), \\(10\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->10], StandardForm], {-0.2, 0.2, 0.1}], Text3DBox[
    FormBox[
     StyleBox["\<\"\\!\\(\\*FractionBox[SqrtBox[\\(10\\)], \\(5\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->12], StandardForm], {0.3, -0.1, -0.1}], Text3DBox[
    FormBox[
     StyleBox["\<\"\\!\\(\\*FractionBox[SqrtBox[\\(5\\)], \\(5\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->12], StandardForm], {-0.05, -0.05, 0}]},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{354.8275938225685, 197.59208666480734`},
  Lighting->"Neutral",
  ViewPoint->{0.08728162139625302, -3.113210180837688, 1.3229906607739221`},
  ViewVertical->{-0.03637445092898166, -0.421203643660203, 
   2.669217860737719}]], "Output",
 CellChangeTimes->{3.540239970546455*^9},
 TextAlignment->Center],

Cell["Por lo tanto, su volumen es", "Text",
 CellChangeTimes->{{3.54024100978951*^9, 3.5402410181977243`*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["V",
     FontFamily->"Times",
     FontSize->18], "4"], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "3"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "2"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     SqrtBox["5"], "5"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     SqrtBox["35"], "10"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 " ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    FractionBox[
     RowBox[{"7", "-", 
      RowBox[{"3", 
       SqrtBox["5"]}]}], "14"]], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 "= ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "60"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    FractionBox[
     RowBox[{"7", "-", 
      RowBox[{"3", 
       SqrtBox["5"]}]}], "2"]], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"3", "-", 
      SqrtBox["5"]}], "120"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "."
}], "Text",
 CellChangeTimes->{{3.54024102732099*^9, 3.540241137309474*^9}, {
   3.540241174880735*^9, 3.540241174880804*^9}, {3.540241230843912*^9, 
   3.5402412512810707`*^9}, {3.540316919566186*^9, 3.5403169195662537`*^9}, {
   3.5403169883058662`*^9, 3.540316990165599*^9}, {3.540317698325392*^9, 
   3.540317716261549*^9}, {3.540318346373391*^9, 3.540318346373514*^9}, 
   3.5403195692576942`*^9},
 TextAlignment->Center],

Cell["\<\
As\[IAcute] pues, el volumen de la \[OpenCurlyDoubleQuote]punta\
\[CloseCurlyDoubleQuote] (teniendo en cuenta que las pir\[AAcute]mides \
laterales hay que contarlas cinco veces) es\
\>", "Text",
 CellChangeTimes->{{3.540318583965728*^9, 3.540318592019865*^9}, {
  3.540318984585018*^9, 3.540318997598377*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   FractionBox["1", "30"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " + ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"11", "+", 
     RowBox[{"5", 
      SqrtBox["5"]}]}], "120"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times",
  FontSize->18],
 " + ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"2", "+", 
     SqrtBox["5"]}], "12"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times",
  FontSize->18],
 "+",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
     FractionBox[
      RowBox[{"3", "-", 
       SqrtBox["5"]}], "24"], " "}],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "=  ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"5", "+", 
     SqrtBox["5"]}], "12"], TraditionalForm]],
  FontFamily->"Times",
  FontSize->18]
}], "Text",
 CellChangeTimes->{{3.540318592137566*^9, 3.540318592139323*^9}, {
  3.540318914514502*^9, 3.540318980495215*^9}, {3.540319110474036*^9, 
  3.5403191146396923`*^9}, {3.540319208813738*^9, 3.5403192088138037`*^9}},
 TextAlignment->Center],

Cell["\<\
Y el volumen del gran icosaedro resulta ser\
\>", "Text",
 CellChangeTimes->{{3.5403185922815027`*^9, 3.540318592283374*^9}, {
  3.540319244908135*^9, 3.5403192522827253`*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"5", "+", 
      RowBox[{"5", 
       SqrtBox["5"]}]}], "4"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 "+",
 StyleBox["5",
  FontFamily->"Times"],
 "+",
 Cell[BoxData[
  FormBox[
   StyleBox[
    SqrtBox["5"],
    FontFamily->"Times"], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"25", "+", 
      RowBox[{"9", 
       SqrtBox["5"]}]}], "4"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.54031925456103*^9, 3.540319375797916*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Recordemos que \[EAcute]ste es el volumen de un gran icosaedro construido \
sobre un dodecaedro de arista unitaria. El volumen de un gran icosaedro de \
arista ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es"
}], "Text",
 CellChangeTimes->{{3.540319396954674*^9, 3.5403194225018387`*^9}, 
   3.540319617745145*^9}],

Cell[TextData[{
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"25", "+", 
      RowBox[{"9", 
       SqrtBox["5"]}]}], 
     RowBox[{"4", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "\[CapitalPhi]"}], "+", "1"}], ")"}], "3"]}]],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["l",
     FontFamily->"Times",
     FontSize->18], "3"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "= ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{
     RowBox[{"83", 
      SqrtBox["5"]}], "-", "185"}], "4"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["l",
     FontFamily->"Times",
     FontSize->18], "3"], TraditionalForm]],
  FormatType->"TraditionalForm"]
}], "Text",
 CellChangeTimes->{{3.54031942363459*^9, 3.540319424170402*^9}, {
   3.5403199167309523`*^9, 3.540319948144644*^9}, {3.5403199904945498`*^9, 
   3.540320037097856*^9}, 3.540320327725753*^9},
 TextAlignment->Center],

Cell[TextData[{
 "El \[AAcute]ngulo di\[EAcute]drico es f\[AAcute]cil de calcular. Como se \
aprecia en la primera figura de este apartado (en la opci\[OAcute]n que \
muestra las aristas del gran icosaedro), cuando la arista es unitaria, dos \
caras contiguas son tri\[AAcute]ngulos equil\[AAcute]teros de altura ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox["3"], "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " y cuyos v\[EAcute]rtices opuestos al lado com\[UAcute]n forman dos v\
\[EAcute]rtices no adyacentes de un pentagrama de lado unitario, luego su \
distancia es 1/\[CapitalPhi]. De aqu\[IAcute] se sigue que la mitad del \
\[AAcute]ngulo di\[EAcute]drico tiene seno ",
 StyleBox["(1/2\[CapitalPhi])/(",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox["3"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontSize->14],
 StyleBox["/2),",
  FontFamily->"Times"],
 " y de aqu\[IAcute] se obtiene inmediatamente el coseno del \[AAcute]ngulo \
di\[EAcute]drico. La tabla siguiente resume los resultados que hemos obtenido:"
}], "Text",
 CellChangeTimes->{{3.5403201893128242`*^9, 3.540320189314241*^9}, {
  3.540320651858368*^9, 3.540320766968913*^9}, {3.540321334451293*^9, 
  3.5403214252876596`*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Radio\"\>", "\<\"Inradio\"\>", "\<\"Volumen\"\>", "\<\"\
\[CapitalAAcute]rea\"\>", "\<\"\[CapitalAAcute]ngulo di\[EAcute]drico\"\>"},
    {
     StyleBox["\<\"\\!\\(TraditionalForm\\`\\*FractionBox[\\(1\\), \\(2\\)] \
\\*SqrtBox[FractionBox[\\(5 - \\*SqrtBox[\\(5\\)]\\), \\(2\\)]]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(TraditionalForm\\`\\*FractionBox[\\(3 - \
\\*SqrtBox[\\(5\\)]\\), \\(4 \\*SqrtBox[\\(3\\)]\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(TraditionalForm\\`\\(TraditionalForm\\`\\*\
FractionBox[\\(83 \\*SqrtBox[\\(5\\)] - 185\\), \\(4\\)]\\)\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FormBox[\\n RowBox[{\\\" \\\", \\n  RowBox[{\\n   \
StyleBox[\\\"3\\\",\\nFontFamily->\\\"Times\\\"], FormBox[SqrtBox[\\\"3\\\"],\
\\n    TraditionalForm], \\n   RowBox[{\\n    \
StyleBox[\\\"(\\\",\\nFontFamily->\\\"Times\\\"], \\n    RowBox[{\\n     \
RowBox[{\\n      StyleBox[\\\"16\\\",\\nFontFamily->\\\"Times\\\"], \
FormBox[SqrtBox[\\\"5\\\"],\\n       TraditionalForm]}], \\\"-\\\", \\n     \
StyleBox[\\\"35\\\",\\nFontFamily->\\\"Times\\\"]}], \\n    \
StyleBox[\\\")\\\",\\nFontFamily->\\\"Times\\\"]}]}]}],\\n \
TraditionalForm]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], 
     StyleBox["\<\"arccos[\\!\\(\\*FractionBox[SqrtBox[\\(5\\)], \\(3\\)]\\)]\
\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18]}
   },
   AutoDelete->False,
   GridBoxDividers->{
    "Columns" -> {False, True, True, True, True}, "Rows" -> {False, True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.539465431952258*^9, {3.539465467100943*^9, 3.539465481432536*^9}, {
   3.539465520120311*^9, 3.539465531238798*^9}, 3.539506282920824*^9, {
   3.54032026862471*^9, 3.54032030788908*^9}, {3.540320344605932*^9, 
   3.540320350540251*^9}, 3.5403203826265287`*^9, 3.5403204612150917`*^9, 
   3.540320978876295*^9, 3.540674948551793*^9},
 TextAlignment->Center],

Cell[TextData[StyleBox["EL GRAN DODECAEDRO ESTRELLADO",
 FontSize->18,
 FontColor->RGBColor[0, 0, 1]]], "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellMargins->{{100, 100}, {16, 18}},
 CellChangeTimes->{{3.538515429422391*^9, 3.538515429424019*^9}, {
  3.538517083097238*^9, 3.538517086760803*^9}, {3.538772137916774*^9, 
  3.5387721418334713`*^9}, {3.5389433492789*^9, 3.538943354615024*^9}, {
  3.538944083654379*^9, 3.538944088838513*^9}, {3.5391065561537533`*^9, 
  3.5391065641036177`*^9}, {3.539110603199396*^9, 3.5391106061050386`*^9}, {
  3.539114155036748*^9, 3.5391141567297077`*^9}, {3.5391190486065063`*^9, 
  3.5391190499503193`*^9}, {3.539191580022891*^9, 3.539191581987825*^9}, {
  3.539194702212619*^9, 3.539194706217629*^9}, {3.539198553615024*^9, 
  3.5391985588123913`*^9}, {3.539255753070822*^9, 3.539255755378742*^9}, {
  3.539381764243767*^9, 3.539381768720518*^9}, {3.5394685624739428`*^9, 
  3.539468565705537*^9}, {3.5403214883881617`*^9, 3.540321493567947*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "El poliedro dual del gran icosaedro se llama ",
 StyleBox["gran dodecaedro estrellado,",
  FontSlant->"Italic"],
 " y es necesariamente un poliedro regular, que tendr\[AAcute] ",
 StyleBox["C",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 StyleBox["12",
  FontFamily->"Times"],
 " caras, ",
 StyleBox["A",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 StyleBox["30",
  FontFamily->"Times"],
 " aristas y ",
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 StyleBox[" = 20",
  FontFamily->"Times"],
 " v\[EAcute]rtices. Los v\[EAcute]rtices del gran dodecaedro estrellado son \
los centros de las caras del gran icosaedro, que coinciden con los centros de \
las caras del peque\[NTilde]o icosaedro que encierra en su interior, es \
decir, con los v\[EAcute]rtices de su dodecaedro dual. La figura siguiente \
permite ver las caras del peque\[NTilde]o icosaedro correspondientes a un \
grupo de caras del gran icosaedro que confluyen en el mismo v\[EAcute]rtice \
(las pintadas de oscuro), cuyos centros ser\[AAcute]n los v\[EAcute]rtices de \
una cara del gran dodecaedro estrellado:"
}], "Text",
 CellChangeTimes->{{3.5403215291952143`*^9, 3.540321628225215*^9}, {
  3.540329464783395*^9, 3.540329464790217*^9}, {3.540329510943925*^9, 
  3.540329659734723*^9}, {3.540329727247705*^9, 3.540329739256002*^9}, {
  3.540329861556534*^9, 3.54032986964987*^9}, {3.541015807129642*^9, 
  3.541015809522943*^9}, {3.5411786327029877`*^9, 3.541178633443446*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`c1$$ = True, $CellContext`c10$$ = 
    True, $CellContext`c11$$ = True, $CellContext`c12$$ = 
    True, $CellContext`c13$$ = True, $CellContext`c14$$ = 
    True, $CellContext`c15$$ = True, $CellContext`c16$$ = 
    True, $CellContext`c17$$ = True, $CellContext`c18$$ = 
    True, $CellContext`c19$$ = True, $CellContext`c2$$ = 
    True, $CellContext`c20$$ = True, $CellContext`c3$$ = 
    True, $CellContext`c4$$ = True, $CellContext`c5$$ = 
    True, $CellContext`c6$$ = True, $CellContext`c7$$ = 
    True, $CellContext`c8$$ = True, $CellContext`c9$$ = 
    True, $CellContext`u$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`u$$], 1, "Opacidad"}, 0.3, 1}, {
      Hold[$CellContext`c1$$], {True, False}}, {
      Hold[$CellContext`c2$$], {True, False}}, {
      Hold[$CellContext`c3$$], {True, False}}, {
      Hold[$CellContext`c4$$], {True, False}}, {
      Hold[$CellContext`c5$$], {True, False}}, {
      Hold[$CellContext`c6$$], {True, False}}, {
      Hold[$CellContext`c7$$], {True, False}}, {
      Hold[$CellContext`c8$$], {True, False}}, {
      Hold[$CellContext`c9$$], {True, False}}, {
      Hold[$CellContext`c10$$], {True, False}}, {
      Hold[$CellContext`c11$$], {True, False}}, {
      Hold[$CellContext`c12$$], {True, False}}, {
      Hold[$CellContext`c13$$], {True, False}}, {
      Hold[$CellContext`c14$$], {True, False}}, {
      Hold[$CellContext`c15$$], {True, False}}, {
      Hold[$CellContext`c16$$], {True, False}}, {
      Hold[$CellContext`c17$$], {True, False}}, {
      Hold[$CellContext`c18$$], {True, False}}, {
      Hold[$CellContext`c19$$], {True, False}}, {
      Hold[$CellContext`c20$$], {True, False}}, {
      Hold[
       Grid[{{
          Button[
          "Todas", {$CellContext`c1$$ = True; $CellContext`c2$$ = 
             True; $CellContext`c3$$ = True; $CellContext`c4$$ = 
             True; $CellContext`c5$$ = True; $CellContext`c6$$ = 
             True; $CellContext`c7$$ = True; $CellContext`c8$$ = 
             True; $CellContext`c9$$ = True; $CellContext`c10$$ = 
             True; $CellContext`c11$$ = True; $CellContext`c12$$ = 
             True; $CellContext`c13$$ = True; $CellContext`c14$$ = 
             True; $CellContext`c15$$ = True; $CellContext`c16$$ = 
             True; $CellContext`c17$$ = True; $CellContext`c18$$ = 
             True; $CellContext`c19$$ = True; $CellContext`c20$$ = True}, 
           Appearance -> "Palette"], 
          Button[
          "V\[EAcute]rtice", {$CellContext`c1$$ = True; $CellContext`c2$$ = 
             True; $CellContext`c3$$ = True; $CellContext`c4$$ = 
             True; $CellContext`c5$$ = True; $CellContext`c6$$ = 
             False; $CellContext`c7$$ = False; $CellContext`c8$$ = 
             False; $CellContext`c9$$ = False; $CellContext`c10$$ = 
             False; $CellContext`c11$$ = False; $CellContext`c12$$ = 
             False; $CellContext`c13$$ = False; $CellContext`c14$$ = 
             False; $CellContext`c15$$ = False; $CellContext`c16$$ = 
             False; $CellContext`c17$$ = False; $CellContext`c18$$ = 
             False; $CellContext`c19$$ = False; $CellContext`c20$$ = False}, 
           Appearance -> "Palette"], 
          Button[
          "Ninguna", {$CellContext`c1$$ = False; $CellContext`c2$$ = 
             False; $CellContext`c3$$ = False; $CellContext`c4$$ = 
             False; $CellContext`c5$$ = False; $CellContext`c6$$ = 
             False; $CellContext`c7$$ = False; $CellContext`c8$$ = 
             False; $CellContext`c9$$ = False; $CellContext`c10$$ = 
             False; $CellContext`c11$$ = False; $CellContext`c12$$ = 
             False; $CellContext`c13$$ = False; $CellContext`c14$$ = 
             False; $CellContext`c15$$ = False; $CellContext`c16$$ = 
             False; $CellContext`c17$$ = False; $CellContext`c18$$ = 
             False; $CellContext`c19$$ = False; $CellContext`c20$$ = False}, 
           Appearance -> "Palette"]}}]], Manipulate`Dump`ThisIsNotAControl}}, 
    Typeset`size$$ = {360., {193., 198.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`u$7974$$ =
     0, $CellContext`c1$7975$$ = False, $CellContext`c2$7976$$ = 
    False, $CellContext`c3$7977$$ = False, $CellContext`c4$7978$$ = 
    False, $CellContext`c5$7979$$ = False, $CellContext`c6$7980$$ = 
    False, $CellContext`c7$7981$$ = False, $CellContext`c8$7982$$ = 
    False, $CellContext`c9$7983$$ = False, $CellContext`c10$7984$$ = 
    False, $CellContext`c11$7985$$ = False, $CellContext`c12$7986$$ = False}, 
    
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`c1$$ = True, $CellContext`c10$$ = 
        True, $CellContext`c11$$ = True, $CellContext`c12$$ = 
        True, $CellContext`c13$$ = True, $CellContext`c14$$ = 
        True, $CellContext`c15$$ = True, $CellContext`c16$$ = 
        True, $CellContext`c17$$ = True, $CellContext`c18$$ = 
        True, $CellContext`c19$$ = True, $CellContext`c2$$ = 
        True, $CellContext`c20$$ = True, $CellContext`c3$$ = 
        True, $CellContext`c4$$ = True, $CellContext`c5$$ = 
        True, $CellContext`c6$$ = True, $CellContext`c7$$ = 
        True, $CellContext`c8$$ = True, $CellContext`c9$$ = 
        True, $CellContext`u$$ = 1}, "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$7974$$, 0], 
        Hold[$CellContext`c1$$, $CellContext`c1$7975$$, False], 
        Hold[$CellContext`c2$$, $CellContext`c2$7976$$, False], 
        Hold[$CellContext`c3$$, $CellContext`c3$7977$$, False], 
        Hold[$CellContext`c4$$, $CellContext`c4$7978$$, False], 
        Hold[$CellContext`c5$$, $CellContext`c5$7979$$, False], 
        Hold[$CellContext`c6$$, $CellContext`c6$7980$$, False], 
        Hold[$CellContext`c7$$, $CellContext`c7$7981$$, False], 
        Hold[$CellContext`c8$$, $CellContext`c8$7982$$, False], 
        Hold[$CellContext`c9$$, $CellContext`c9$7983$$, False], 
        Hold[$CellContext`c10$$, $CellContext`c10$7984$$, False], 
        Hold[$CellContext`c11$$, $CellContext`c11$7985$$, False], 
        Hold[$CellContext`c12$$, $CellContext`c12$7986$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{{
          Opacity[0], 
          
          Sphere[{0, 0, 
           0}, (1/2) ((1/2) (5 - 5^Rational[1, 2]))^Rational[1, 2]]}, {
          Scale[
           
           GraphicsComplex[{{
             0, 0, -(5/(50 - 10 5^Rational[1, 2])^Rational[1, 2])}, {
             0, 0, 5/(50 - 10 5^Rational[1, 2])^
              Rational[1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
              0, -(1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {(2/(5 - 5^
               Rational[1, 2]))^Rational[1, 2], 0, 
              1/(10 - 2 5^Rational[1, 2])^
              Rational[1, 2]}, {(1 + 5^Rational[1, 2])/(
              2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), -(1/2), -(
               1/(10 - 2 5^Rational[1, 2])^Rational[1, 2])}, {(1 + 
               5^Rational[1, 2])/(2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]),
               1/2, -(1/(10 - 2 5^Rational[1, 2])^
               Rational[1, 2])}, {-((1 + 5^Rational[1, 2])/(
               2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), -(1/2), 
              1/(10 - 2 5^Rational[1, 2])^
              Rational[1, 2]}, {-((1 + 5^Rational[1, 2])/(
               2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), 1/2, 
              1/(10 - 2 5^Rational[1, 2])^
              Rational[1, 2]}, {-((-1 + 5^Rational[1, 2])/(
               2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (-(1/
                2)) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
               Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
               Rational[1, 2])}, {-((-1 + 5^Rational[1, 2])/(
               2 (10 - 2 5^Rational[1, 2])^Rational[1, 2])), (1/
               2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
               Rational[1, 2], -(1/(10 - 2 5^Rational[1, 2])^
               Rational[1, 2])}, {(-1 + 5^Rational[1, 2])/(
              2 (10 - 2 5^Rational[1, 2])^
               Rational[1, 2]), (-(1/2)) ((5 + 5^Rational[1, 2])/(5 - 5^
                Rational[1, 2]))^Rational[1, 2], 1/(10 - 2 5^Rational[1, 2])^
              Rational[1, 2]}, {(-1 + 5^Rational[1, 2])/(
              2 (10 - 2 5^Rational[1, 2])^Rational[1, 2]), (1/
               2) ((5 + 5^Rational[1, 2])/(5 - 5^Rational[1, 2]))^
               Rational[1, 2], 1/(10 - 2 5^Rational[1, 2])^Rational[1, 2]}}, {{
              GrayLevel[0.4], 
              
              Polygon[{{5, 11, 9}, {9, 7, 3}, {3, 8, 10}, {10, 12, 6}, {6, 4, 
               5}}]}, 
             
             Polygon[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 
              12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {
              12, 10, 8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}}]}], 
           0.1103/PolyhedronData["Icosahedron", "Inradius"]]}, {
          Opacity[$CellContext`u$$], 
          
          GraphicsComplex[{{
            0, 0, (-(1/2)) ((1/2) (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {
            0, 0, (1/2) ((1/2) (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {(1/8 + 
              1/(8 5^Rational[1, 2]))^
             Rational[1, 2], -(1/(1 + 
              5^Rational[1, 2])), (-(1/2)) ((1/10) (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {(1/8 + 1/(8 5^Rational[1, 2]))^Rational[1, 2],
              1/(1 + 5^
              Rational[1, 2]), (-(1/2)) ((1/10) (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {-(1/8 + 1/(8 5^Rational[1, 2]))^
              Rational[1, 2], -(1/(1 + 5^Rational[1, 2])), (1/
              2) ((1/10) (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {-(1/8 + 1/(8 5^Rational[1, 2]))^
              Rational[1, 2], 1/(1 + 
             5^Rational[1, 2]), (1/2) ((1/10) (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {((1/10) (5 - 5^Rational[1, 2]))^
             Rational[1, 2], 
             0, (1/2) ((1/10) (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {-((1/10) (5 - 5^Rational[1, 2]))^
              Rational[1, 2], 
             0, (-(1/2)) ((1/10) (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {(-(1/2)) (1 - 2/5^Rational[1, 2])^
              Rational[1, 2], -(1/
              2), (-(1/2)) ((1/10) (5 - 5^Rational[1, 2]))^
              Rational[1, 2]}, {(-(1/2)) (1 - 2/5^Rational[1, 2])^
              Rational[1, 2], 1/
             2, (-(1/2)) ((1/10) (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {(1/
              2) (1 - 2/5^Rational[1, 2])^Rational[1, 2], -(1/2), (1/
              2) ((1/10) (5 - 5^Rational[1, 2]))^Rational[1, 2]}, {(1/
              2) (1 - 2/5^Rational[1, 2])^Rational[1, 2], 1/
             2, (1/2) ((1/10) (5 - 5^Rational[1, 2]))^Rational[1, 2]}}, {{{
              GrayLevel[0.6], 
              Polygon[{
                If[$CellContext`c1$$, {1, 7, 5}, {}], 
                If[$CellContext`c2$$, {6, 7, 1}, {}], 
                If[$CellContext`c3$$, {1, 5, 12}, {}], 
                If[$CellContext`c4$$, {11, 6, 1}, {}], 
                If[$CellContext`c5$$, {12, 11, 1}, {}], 
                If[$CellContext`c6$$, {2, 8, 3}, {}], 
                If[$CellContext`c7$$, {4, 8, 2}, {}], 
                If[$CellContext`c8$$, {2, 3, 10}, {}], 
                If[$CellContext`c9$$, {9, 4, 2}, {}], 
                If[$CellContext`c10$$, {10, 9, 2}, {}], 
                If[$CellContext`c11$$, {12, 3, 8}, {}], 
                If[$CellContext`c12$$, {8, 4, 11}, {}], 
                If[$CellContext`c13$$, {8, 11, 12}, {}], 
                If[$CellContext`c14$$, {10, 5, 7}, {}], 
                If[$CellContext`c15$$, {7, 6, 9}, {}], 
                If[$CellContext`c16$$, {7, 9, 10}, {}], 
                If[$CellContext`c17$$, {3, 5, 10}, {}], 
                If[$CellContext`c18$$, {12, 5, 3}, {}], 
                If[$CellContext`c19$$, {9, 6, 4}, {}], 
                If[$CellContext`c20$$, {4, 6, 11}, {}]}]}}}]}}, Lighting -> 
        "Neutral", Boxed -> False], 
      "Specifications" :> {{{$CellContext`u$$, 1, "Opacidad"}, 0.3, 1, 
         AppearanceElements -> None}, {$CellContext`c1$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c2$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c3$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c4$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c5$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c6$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c7$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c8$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c9$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c10$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c11$$, {True, False}, 
         ControlPlacement -> Right}, {$CellContext`c12$$, {True, False}, 
         ControlPlacement -> Right}, {$CellContext`c13$$, {True, False}, 
         ControlPlacement -> Right}, {$CellContext`c14$$, {True, False}, 
         ControlPlacement -> Right}, {$CellContext`c15$$, {True, False}, 
         ControlPlacement -> Right}, {$CellContext`c16$$, {True, False}, 
         ControlPlacement -> Right}, {$CellContext`c17$$, {True, False}, 
         ControlPlacement -> Right}, {$CellContext`c18$$, {True, False}, 
         ControlPlacement -> Right}, {$CellContext`c19$$, {True, False}, 
         ControlPlacement -> Right}, {$CellContext`c20$$, {True, False}, 
         ControlPlacement -> Right}, 
        Grid[{{
           Button[
           "Todas", {$CellContext`c1$$ = True; $CellContext`c2$$ = 
              True; $CellContext`c3$$ = True; $CellContext`c4$$ = 
              True; $CellContext`c5$$ = True; $CellContext`c6$$ = 
              True; $CellContext`c7$$ = True; $CellContext`c8$$ = 
              True; $CellContext`c9$$ = True; $CellContext`c10$$ = 
              True; $CellContext`c11$$ = True; $CellContext`c12$$ = 
              True; $CellContext`c13$$ = True; $CellContext`c14$$ = 
              True; $CellContext`c15$$ = True; $CellContext`c16$$ = 
              True; $CellContext`c17$$ = True; $CellContext`c18$$ = 
              True; $CellContext`c19$$ = True; $CellContext`c20$$ = True}, 
            Appearance -> "Palette"], 
           Button[
           "V\[EAcute]rtice", {$CellContext`c1$$ = True; $CellContext`c2$$ = 
              True; $CellContext`c3$$ = True; $CellContext`c4$$ = 
              True; $CellContext`c5$$ = True; $CellContext`c6$$ = 
              False; $CellContext`c7$$ = False; $CellContext`c8$$ = 
              False; $CellContext`c9$$ = False; $CellContext`c10$$ = 
              False; $CellContext`c11$$ = False; $CellContext`c12$$ = 
              False; $CellContext`c13$$ = False; $CellContext`c14$$ = 
              False; $CellContext`c15$$ = False; $CellContext`c16$$ = 
              False; $CellContext`c17$$ = False; $CellContext`c18$$ = 
              False; $CellContext`c19$$ = False; $CellContext`c20$$ = False}, 
            Appearance -> "Palette"], 
           Button[
           "Ninguna", {$CellContext`c1$$ = False; $CellContext`c2$$ = 
              False; $CellContext`c3$$ = False; $CellContext`c4$$ = 
              False; $CellContext`c5$$ = False; $CellContext`c6$$ = 
              False; $CellContext`c7$$ = False; $CellContext`c8$$ = 
              False; $CellContext`c9$$ = False; $CellContext`c10$$ = 
              False; $CellContext`c11$$ = False; $CellContext`c12$$ = 
              False; $CellContext`c13$$ = False; $CellContext`c14$$ = 
              False; $CellContext`c15$$ = False; $CellContext`c16$$ = 
              False; $CellContext`c17$$ = False; $CellContext`c18$$ = 
              False; $CellContext`c19$$ = False; $CellContext`c20$$ = False}, 
            Appearance -> "Palette"]}}]}, 
      "Options" :> {AppearanceElements -> {}}, "DefaultOptions" :> {}],
     ImageSizeCache->{490., {244., 250.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.5403294707240753`*^9, 3.540330061513364*^9, 
  3.54033013976652*^9, 3.541104928305621*^9},
 TextAlignment->Center],

Cell["\<\
Vemos que son los cinco tri\[AAcute]ngulos contiguos a las cinco caras que \
confluyen en un mismo v\[EAcute]rtice del peque\[NTilde]o icosaedro. M\
\[AAcute]s a\[UAcute]n, si nos fijamos vemos que dos caras contiguas del gran \
icosaedro se corresponden con dos de las cinco caras separadas por una \
tercera. Por lo tanto, las caras del gran dodecaedro estrellado se forman \
uniendo grupos de cinco v\[EAcute]rtices, pero no formando un \
pent\[AAcute]gono regular, sino un pentagrama. La figura siguiente permite \
explorar el gran dodecaedro estrellado.\
\>", "Text",
 CellChangeTimes->{{3.540332885879263*^9, 3.540332885881034*^9}, 
   3.540333253376405*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`c1$$ = True, $CellContext`c10$$ = 
    False, $CellContext`c11$$ = False, $CellContext`c12$$ = 
    False, $CellContext`c2$$ = False, $CellContext`c3$$ = 
    False, $CellContext`c4$$ = False, $CellContext`c5$$ = 
    False, $CellContext`c6$$ = False, $CellContext`c7$$ = 
    False, $CellContext`c8$$ = False, $CellContext`c9$$ = 
    False, $CellContext`u$$ = 0.186, $CellContext`uu$$ = 
    0., $CellContext`v$$ = 1., $CellContext`w$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`u$$], 0.2, "Icosaedro exterior"}, 0, 1}, {{
       Hold[$CellContext`uu$$], 0, "Dodecaedro exterior"}, 0, 1}, {{
       Hold[$CellContext`v$$], 1, "Gran dodecaedro estrellado"}, 0, 1}, {{
       Hold[$CellContext`w$$], 0, "Icosaedro interior"}, 0, 1}, {
      Hold[$CellContext`c1$$], {True, False}}, {
      Hold[$CellContext`c2$$], {True, False}}, {
      Hold[$CellContext`c3$$], {True, False}}, {
      Hold[$CellContext`c4$$], {True, False}}, {
      Hold[$CellContext`c5$$], {True, False}}, {
      Hold[$CellContext`c6$$], {True, False}}, {
      Hold[$CellContext`c7$$], {True, False}}, {
      Hold[$CellContext`c8$$], {True, False}}, {
      Hold[$CellContext`c9$$], {True, False}}, {
      Hold[$CellContext`c10$$], {True, False}}, {
      Hold[$CellContext`c11$$], {True, False}}, {
      Hold[$CellContext`c12$$], {True, False}}, {
      Hold[
       Grid[{{
          Button[
          "Todas", {$CellContext`c1$$ = True; $CellContext`c2$$ = 
             True; $CellContext`c3$$ = True; $CellContext`c4$$ = 
             True; $CellContext`c5$$ = True; $CellContext`c6$$ = 
             True; $CellContext`c7$$ = True; $CellContext`c8$$ = 
             True; $CellContext`c9$$ = True; $CellContext`c10$$ = 
             True; $CellContext`c11$$ = True; $CellContext`c12$$ = True}, 
           Appearance -> "Palette"], 
          Button[
          "Ninguna", {$CellContext`c1$$ = False; $CellContext`c2$$ = 
             False; $CellContext`c3$$ = False; $CellContext`c4$$ = 
             False; $CellContext`c5$$ = False; $CellContext`c6$$ = 
             False; $CellContext`c7$$ = False; $CellContext`c8$$ = 
             False; $CellContext`c9$$ = False; $CellContext`c10$$ = 
             False; $CellContext`c11$$ = False; $CellContext`c12$$ = False}, 
           Appearance -> "Palette"]}}]], Manipulate`Dump`ThisIsNotAControl}}, 
    Typeset`size$$ = {360., {193., 198.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`u$8440$$ =
     0, $CellContext`uu$8441$$ = 0, $CellContext`v$8442$$ = 
    0, $CellContext`w$8443$$ = 0, $CellContext`c1$8444$$ = 
    False, $CellContext`c2$8445$$ = False, $CellContext`c3$8446$$ = 
    False, $CellContext`c4$8447$$ = False, $CellContext`c5$8448$$ = 
    False, $CellContext`c6$8449$$ = False, $CellContext`c7$8450$$ = 
    False, $CellContext`c8$8451$$ = False, $CellContext`c9$8452$$ = 
    False, $CellContext`c10$8453$$ = False, $CellContext`c11$8454$$ = 
    False, $CellContext`c12$8455$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`c1$$ = True, $CellContext`c10$$ = 
        True, $CellContext`c11$$ = True, $CellContext`c12$$ = 
        True, $CellContext`c2$$ = True, $CellContext`c3$$ = 
        True, $CellContext`c4$$ = True, $CellContext`c5$$ = 
        True, $CellContext`c6$$ = True, $CellContext`c7$$ = 
        True, $CellContext`c8$$ = True, $CellContext`c9$$ = 
        True, $CellContext`u$$ = 0.2, $CellContext`uu$$ = 0, $CellContext`v$$ = 
        1, $CellContext`w$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$8440$$, 0], 
        Hold[$CellContext`uu$$, $CellContext`uu$8441$$, 0], 
        Hold[$CellContext`v$$, $CellContext`v$8442$$, 0], 
        Hold[$CellContext`w$$, $CellContext`w$8443$$, 0], 
        Hold[$CellContext`c1$$, $CellContext`c1$8444$$, False], 
        Hold[$CellContext`c2$$, $CellContext`c2$8445$$, False], 
        Hold[$CellContext`c3$$, $CellContext`c3$8446$$, False], 
        Hold[$CellContext`c4$$, $CellContext`c4$8447$$, False], 
        Hold[$CellContext`c5$$, $CellContext`c5$8448$$, False], 
        Hold[$CellContext`c6$$, $CellContext`c6$8449$$, False], 
        Hold[$CellContext`c7$$, $CellContext`c7$8450$$, False], 
        Hold[$CellContext`c8$$, $CellContext`c8$8451$$, False], 
        Hold[$CellContext`c9$$, $CellContext`c9$8452$$, False], 
        Hold[$CellContext`c10$$, $CellContext`c10$8453$$, False], 
        Hold[$CellContext`c11$$, $CellContext`c11$8454$$, False], 
        Hold[$CellContext`c12$$, $CellContext`c12$8455$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{{
          Opacity[0], 
          Sphere[{0, 0, 0}, 
           PolyhedronData["Icosahedron", "Inradius"]]}, {
          GrayLevel[0.7], 
          Opacity[$CellContext`v$$], 
          GraphicsComplex[{{
             Root[1 - 10 #^2 + 5 #^4& , 2], 0, 
             Root[1 - 20 #^2 + 80 #^4& , 4]}, {
             Root[1 - 10 #^2 + 5 #^4& , 3], 0, 
             Root[1 - 20 #^2 + 80 #^4& , 1]}, {
             Root[1 - 5 #^2 + 5 #^4& , 2], 0, 
             Root[1 - 100 #^2 + 80 #^4& , 3]}, {
             Root[1 - 5 #^2 + 5 #^4& , 3], 0, 
             Root[1 - 100 #^2 + 80 #^4& , 2]}, {
             Root[1 - 100 #^2 + 80 #^4& , 2], (1/4) (1 - 5^Rational[1, 2]), 
             Root[1 - 20 #^2 + 80 #^4& , 4]}, {
             Root[1 - 100 #^2 + 80 #^4& , 2], (1/4) (-1 + 5^Rational[1, 2]), 
             Root[1 - 20 #^2 + 80 #^4& , 4]}, {
             Root[1 - 100 #^2 + 80 #^4& , 3], (1/4) (1 - 5^Rational[1, 2]), 
             Root[1 - 20 #^2 + 80 #^4& , 1]}, {
             Root[1 - 100 #^2 + 80 #^4& , 3], (1/4) (-1 + 5^Rational[1, 2]), 
             Root[1 - 20 #^2 + 80 #^4& , 1]}, {
             Root[1 - 40 #^2 + 80 #^4& , 2], -(1/2), 
             Root[1 - 100 #^2 + 80 #^4& , 3]}, {
             Root[1 - 40 #^2 + 80 #^4& , 2], 1/2, 
             Root[1 - 100 #^2 + 80 #^4& , 3]}, {
             Root[1 - 40 #^2 + 80 #^4& , 3], -(1/2), 
             Root[1 - 100 #^2 + 80 #^4& , 2]}, {
             Root[1 - 40 #^2 + 80 #^4& , 3], 1/2, 
             Root[1 - 100 #^2 + 80 #^4& , 2]}, {
             Root[1 - 20 #^2 + 80 #^4& , 1], (1/4) (1 - 5^Rational[1, 2]), 
             Root[1 - 100 #^2 + 80 #^4& , 2]}, {
             Root[1 - 20 #^2 + 80 #^4& , 1], (1/4) (-1 + 5^Rational[1, 2]), 
             Root[1 - 100 #^2 + 80 #^4& , 2]}, {
             Root[1 - 20 #^2 + 80 #^4& , 2], (1/4) (3 - 5^Rational[1, 2]), 
             Root[1 - 20 #^2 + 80 #^4& , 1]}, {
             Root[1 - 20 #^2 + 80 #^4& , 2], (1/4) (-3 + 5^Rational[1, 2]), 
             Root[1 - 20 #^2 + 80 #^4& , 1]}, {
             Root[1 - 20 #^2 + 80 #^4& , 3], (1/4) (3 - 5^Rational[1, 2]), 
             Root[1 - 20 #^2 + 80 #^4& , 4]}, {
             Root[1 - 20 #^2 + 80 #^4& , 3], (1/4) (-3 + 5^Rational[1, 2]), 
             Root[1 - 20 #^2 + 80 #^4& , 4]}, {
             Root[1 - 20 #^2 + 80 #^4& , 4], (1/4) (1 - 5^Rational[1, 2]), 
             Root[1 - 100 #^2 + 80 #^4& , 3]}, {
             Root[1 - 20 #^2 + 80 #^4& , 4], (1/4) (-1 + 5^Rational[1, 2]), 
             Root[1 - 100 #^2 + 80 #^4& , 3]}}, 
           Polygon[{
             If[$CellContext`c1$$, {13, 4, 1, 7, 17}, {}], 
             If[$CellContext`c2$$, {18, 8, 1, 4, 14}, {}], 
             If[$CellContext`c3$$, {10, 7, 1, 8, 9}, {}], 
             If[$CellContext`c4$$, {19, 3, 2, 5, 15}, {}], 
             If[$CellContext`c5$$, {16, 6, 2, 3, 20}, {}], 
             If[$CellContext`c6$$, {12, 5, 2, 6, 11}, {}], 
             If[$CellContext`c7$$, {9, 20, 3, 19, 10}, {}], 
             If[$CellContext`c8$$, {11, 14, 4, 13, 12}, {}], 
             If[$CellContext`c9$$, {17, 15, 5, 12, 13}, {}], 
             If[$CellContext`c10$$, {14, 11, 6, 16, 18}, {}], 
             If[$CellContext`c11$$, {15, 17, 7, 10, 19}, {}], 
             If[$CellContext`c12$$, {20, 9, 8, 18, 16}, {}]}]]}, 
         If[$CellContext`u$$ > 0, {
           Opacity[$CellContext`u$$], 
           Scale[
            PolyhedronData["Icosahedron", "Faces"], 
            PolyhedronData["Icosahedron", "Inradius"]]}], 
         If[$CellContext`uu$$ > 0, {
           Opacity[$CellContext`uu$$], 
           Scale[
            PolyhedronData[
            "Dodecahedron", 
             "Faces"], ((1/40) (5 + 5^Rational[1, 2]) + 
              Root[1 - 10 #^2 + 5 #^4& , 2]^2)^Rational[1, 2]/PolyhedronData[
            "Dodecahedron", "Circumradius"]]}], 
         If[$CellContext`w$$ > 0, {
           Opacity[$CellContext`w$$], 
           Scale[
            PolyhedronData["Icosahedron", "Faces"], 1/GoldenRatio^3]}]}, 
        Boxed -> False, Lighting -> "Neutral"], 
      "Specifications" :> {{{$CellContext`u$$, 0.2, "Icosaedro exterior"}, 0, 
         1, AppearanceElements -> {}}, {{$CellContext`uu$$, 0, 
          "Dodecaedro exterior"}, 0, 1, 
         AppearanceElements -> {}}, {{$CellContext`v$$, 1, 
          "Gran dodecaedro estrellado"}, 0, 1, 
         AppearanceElements -> {}}, {{$CellContext`w$$, 0, 
          "Icosaedro interior"}, 0, 1, 
         AppearanceElements -> {}}, {$CellContext`c1$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c2$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c3$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c4$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c5$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c6$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c7$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c8$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c9$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c10$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c11$$, {True, False}, 
         ControlPlacement -> Left}, {$CellContext`c12$$, {True, False}, 
         ControlPlacement -> Left}, 
        Grid[{{
           Button[
           "Todas", {$CellContext`c1$$ = True; $CellContext`c2$$ = 
              True; $CellContext`c3$$ = True; $CellContext`c4$$ = 
              True; $CellContext`c5$$ = True; $CellContext`c6$$ = 
              True; $CellContext`c7$$ = True; $CellContext`c8$$ = 
              True; $CellContext`c9$$ = True; $CellContext`c10$$ = 
              True; $CellContext`c11$$ = True; $CellContext`c12$$ = True}, 
            Appearance -> "Palette"], 
           Button[
           "Ninguna", {$CellContext`c1$$ = False; $CellContext`c2$$ = 
              False; $CellContext`c3$$ = False; $CellContext`c4$$ = 
              False; $CellContext`c5$$ = False; $CellContext`c6$$ = 
              False; $CellContext`c7$$ = False; $CellContext`c8$$ = 
              False; $CellContext`c9$$ = False; $CellContext`c10$$ = 
              False; $CellContext`c11$$ = False; $CellContext`c12$$ = False}, 
            Appearance -> "Palette"]}}]}, 
      "Options" :> {AppearanceElements -> {}}, "DefaultOptions" :> {}],
     ImageSizeCache->{448., {286., 292.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{
  3.5403328921330147`*^9, 3.540333360488647*^9, 3.5405035440925703`*^9, {
   3.540503698703373*^9, 3.540503702107765*^9}, 3.5405040370369987`*^9},
 TextAlignment->Center],

Cell["\<\
Si mostramos \[UAcute]nicamente una cara junto con el dodecaedro exterior \
podremos apreciar su disposici\[OAcute]n respecto a \[EAcute]ste. Si \
mostramos las tres primeras caras podremos ver un v\[EAcute]rtice completo \
del gran dodecaedro estrellado. Observemos que los pentagramas est\[AAcute]n \
dibujados sin su pent\[AAcute]gono central, pero esto es por conveniencia, \
pues en realidad dicho pent\[AAcute]gono forma parte de la cara. Los pent\
\[AAcute]gonos interiores de las caras \[OpenCurlyDoubleQuote]encajan\
\[CloseCurlyDoubleQuote] en un icosaedro interior que puede hacerse visible \
en la figura. As\[IAcute], el gran dodecaedro estrellado puede verse como el \
resultado de pegar una pir\[AAcute]mide triangular sobre cada una de las \
caras de un icosaedro convexo, con la altura adecuada para que sus caras \
laterales formen pentagramas (planos). Notemos que los pent\[AAcute]gonos \
centrales forman un gran dodecaedro dentro de dicho icosaedro, el cual \
contiene a su vez un dodecaedro interior.\
\>", "Text",
 CellChangeTimes->{{3.5403328862718277`*^9, 3.5403328862739477`*^9}, {
  3.540333256183021*^9, 3.5403333090526943`*^9}, {3.5403334073137417`*^9, 
  3.540333508247072*^9}, {3.5403335552175503`*^9, 3.540333653361054*^9}, {
  3.5403336900604067`*^9, 3.540333748305582*^9}, {3.540333781205336*^9, 
  3.540333784242148*^9}, {3.5405029067520103`*^9, 3.540502906756092*^9}, {
  3.540504057664485*^9, 3.540504059433133*^9}}],

Cell[TextData[{
 "Por otra parte, los v\[EAcute]rtices del gran dodecaedro estrellado son \
tambi\[EAcute]n los v\[EAcute]rtices del dodecaedro inscrito al icosaedro \
exterior. Si en la figura mostramos \[UAcute]nicamente el dodecaedro exterior \
y una cara del gran dodecaedro estrellado podemos determinar \
f\[AAcute]cilmente la relaci\[OAcute]n entre el lado y el radio. En efecto, \
la arista ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " del gran dodecaedro estrellado es una diagonal de un pent\[AAcute]gono \
cuyo lado es una diagonal de una cara del dodecaedro. As\[IAcute] pues, la \
diagonal de dicha cara mide ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "/\[CapitalPhi] y el lado del dodecaedro mide ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "/",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[CapitalPhi]", 
    StyleBox["2",
     FontFamily->"Times",
     FontSize->9.939987182617188,
     FontSlant->"Plain"]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", luego el radio del dodecaedro (que es el mismo que el del gran dodecaedro \
estrellado) es"
}], "Text",
 CellChangeTimes->{{3.540502906891254*^9, 3.540502906893462*^9}, {
  3.540503584445324*^9, 3.540503850157345*^9}, {3.540504068652615*^9, 
  3.5405040827532177`*^9}}],

Cell[TextData[{
 StyleBox["R",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{
     SqrtBox[
      StyleBox["3",
       FontFamily->"Times",
       FontSize->12.779998779296875`,
       FontSlant->"Plain"]], "\[CapitalPhi]"}], 
    StyleBox["2",
     FontFamily->"Times",
     FontSize->12.779998779296875`,
     FontSlant->"Plain"]], TraditionalForm]],
  FontSize->18],
 StyleBox[" ",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   FractionBox[
    StyleBox["l",
     FontFamily->"Times"], 
    SuperscriptBox["\[CapitalPhi]", 
     StyleBox["2",
      FontFamily->"Times",
      FontSize->9,
      FontSlant->"Plain"]]], TraditionalForm]],
  FontSize->18],
 "= ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox[
     StyleBox["3",
      FontFamily->"Times",
      FontSize->12.779998779296875`,
      FontSlant->"Plain"]], 
    RowBox[{
     StyleBox["2",
      FontFamily->"Times",
      FontSize->12.779998779296875`,
      FontSlant->"Plain"], "\[CapitalPhi]"}]], TraditionalForm]],
  FontSize->18],
 StyleBox["l.",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.540503851141671*^9, 3.540503851821776*^9}, {
  3.5405038838868628`*^9, 3.540503950794108*^9}, {3.54050411364561*^9, 
  3.540504136730208*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Por otra parte, el icosaedro interior que muestra la figura tiene arista ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "/",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[CapitalPhi]", 
    StyleBox["3",
     FontFamily->"Times",
     FontSize->9.939987182617188,
     FontSlant->"Plain"]], TraditionalForm]]],
 ", que es la misma que la del gran dodecaedro determinado por dicho \
icosaedro, cuyo inradio (que es el mismo que el del gran dodecaedro \
estrellado) es"
}], "Text",
 CellChangeTimes->{{3.5405029072432528`*^9, 3.540502907245371*^9}, {
  3.54050439437481*^9, 3.5405044091164722`*^9}, {3.5405044661594477`*^9, 
  3.5405044704476*^9}, {3.5405045677607393`*^9, 3.5405045793739777`*^9}, {
  3.54050464170354*^9, 3.54050467152668*^9}, {3.540504701601465*^9, 
  3.5405047016074533`*^9}}],

Cell[TextData[{
 StyleBox["r",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "4"],
    FontFamily->"Times"], TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox[
     FractionBox[
      RowBox[{"10", "+", 
       RowBox[{"2", 
        SqrtBox["5"]}]}], "5"],
     FontFamily->"Times"]], TraditionalForm]],
  FontSize->18],
 StyleBox[" ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   FractionBox[
    StyleBox["l",
     FontFamily->"Times"], 
    SuperscriptBox["\[CapitalPhi]", "3"]], TraditionalForm]],
  FontSize->18],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox["1", "2"],
    FontFamily->"Times"], TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox[
     FractionBox[
      RowBox[{"25", "-", 
       RowBox[{"11", 
        SqrtBox["5"]}]}], "10"],
     FontFamily->"Times"]], TraditionalForm]],
  FontSize->18],
 StyleBox["l.",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"]
}], "Text",
 CellChangeTimes->{{3.54050470241463*^9, 3.540504704062518*^9}, {
  3.540504822358664*^9, 3.540504862761263*^9}, {3.5405791851443167`*^9, 
  3.540579210971746*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Si partimos de un icosaedro de arista unitaria, la pir\[AAcute]mide que le \
pegamos a cada cara tiene aristas laterales de longitud \[CapitalPhi]. Como \
el radio de la base es ",
 Cell[BoxData[
  FormBox[
   SqrtBox["3"], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox["/3",
  FontFamily->"Times"],
 ", su altura es"
}], "Text",
 CellChangeTimes->{{3.540332886423718*^9, 3.540332886425729*^9}, {
  3.540417123801453*^9, 3.540417179014982*^9}, {3.540417246569343*^9, 
  3.540417296496169*^9}, {3.540417329963471*^9, 3.540417331909999*^9}}],

Cell[TextData[{
 StyleBox["h",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{
     SuperscriptBox["\[CapitalPhi]", 
      StyleBox["2",
       FontFamily->"Times",
       FontSize->9.939987182617188,
       FontSlant->"Plain"]], "-", 
     StyleBox[
      RowBox[{"1", "/", "3"}],
      FontFamily->"Times"]}]], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox[
     FractionBox[
      RowBox[{"7", "+", 
       RowBox[{"3", 
        SqrtBox["5"]}]}], "6"],
     FontFamily->"Times",
     FontSize->18]], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.5404173342482347`*^9, 3.540417385641567*^9}, {
  3.5404175064377527`*^9, 3.540417531446066*^9}},
 TextAlignment->Center],

Cell["Su volumen es", "Text",
 CellChangeTimes->{{3.540579284353607*^9, 3.5405792859840813`*^9}, {
  3.540579616350313*^9, 3.540579618426985*^9}, {3.5405796503083143`*^9, 
  3.540579650310375*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   FractionBox["1", "3"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    SqrtBox["3"], "4"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    StyleBox[
     FractionBox[
      RowBox[{"7", "+", 
       RowBox[{"3", 
        SqrtBox["5"]}]}], "6"],
     FontFamily->"Times",
     FontSize->18]], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"3", "+", 
      SqrtBox["5"]}], "24"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "."
}], "Text",
 CellChangeTimes->{{3.5405796546630917`*^9, 3.540579663894606*^9}, {
  3.540579747184773*^9, 3.540579748844743*^9}, {3.54058187585973*^9, 
  3.54058189536263*^9}},
 TextAlignment->Center],

Cell["\<\
Por lo tanto, el volumen del gran dodecaedro estrellado es el de un icosaedro \
de arista unitaria m\[AAcute]s el de veinte de estas pir\[AAcute]mides:\
\>", "Text",
 CellChangeTimes->{{3.540332886567734*^9, 3.5403328865697603`*^9}, {
  3.540581937897069*^9, 3.540581995600581*^9}}],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"5", 
      SuperscriptBox["\[CapitalPhi]", "2"]}], 
     StyleBox["6",
      FontFamily->"Times",
      FontSize->12.779998779296875`,
      FontSlant->"Plain"]],
    FontFamily->"Times"], TraditionalForm]],
  FontSize->18],
 "+ ",
 StyleBox["20",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"3", "+", 
      SqrtBox["5"]}], "24"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]]],
 "= ",
 Cell[BoxData[
  FormBox[
   FractionBox["5", "4"], TraditionalForm]],
  FontSize->18],
 StyleBox["(3+",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox["5"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontSize->14],
 StyleBox[")",
  FontFamily->"Times"],
 StyleBox[".",
  FontFamily->"Times",
  FontSize->18]
}], "Text",
 CellChangeTimes->{{3.540581982319792*^9, 3.540581982321836*^9}, {
  3.540582027164839*^9, 3.540582058441661*^9}, {3.5405821615498953`*^9, 
  3.540582190317347*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "El volumen de un gran dodecaedro estrellado de arista ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " ser\[AAcute]:"
}], "Text",
 CellChangeTimes->{{3.540584041003065*^9, 3.540584053559841*^9}}],

Cell[TextData[{
 StyleBox["V",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " = ",
 Cell[BoxData[
  FormBox[
   FractionBox["5", "4"], TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    FractionBox[
     RowBox[{"3", "+", 
      SqrtBox["5"]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "\[CapitalPhi]"}], "+", "1"}], ")"}], "3"]],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SuperscriptBox["l", "3"],
    FontFamily->"Times",
    FontSize->18], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox["=", TraditionalForm]],
  FormatType->"TraditionalForm"],
 " ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"5", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"13", 
        SqrtBox["5"]}], "-", "29"}], ")"}]}], "4"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times",
  FontSize->18],
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["l", "3"], TraditionalForm]],
  FormatType->"TraditionalForm",
  FontFamily->"Times",
  FontSize->18],
 "."
}], "Text",
 CellChangeTimes->{{3.540584062897566*^9, 3.540584167309865*^9}, {
  3.540584252757132*^9, 3.540584311390625*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "Volviendo al gran dodecaedro estrellado de arista ",
 StyleBox["2\[CapitalPhi]+1",
  FontFamily->"Times"],
 ", la altura de una de sus caras triangulares es ",
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{
     SuperscriptBox["\[CapitalPhi]", "2"], "-", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "/", "2"}], ")"}], "2"]}]], TraditionalForm]],
  FontFamily->"Times"],
 "= ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]],
  FontSize->14],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"5", "+", 
     RowBox[{"2", 
      SqrtBox["5"]}]}]], TraditionalForm]],
  FontSize->14],
 ", luego la superficie lateral es ",
 StyleBox["15",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"5", "+", 
     RowBox[{"2", 
      SqrtBox["5"]}]}]], TraditionalForm]],
  FontFamily->"Times"],
 StyleBox[".",
  FontFamily->"Times"],
 " Para el gran dodecaedro estrellado de arista ",
 StyleBox["l",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es"
}], "Text",
 CellChangeTimes->{{3.5405876139173403`*^9, 3.540587673025131*^9}}],

Cell[TextData[{
 StyleBox["S",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " ",
 StyleBox["= ",
  FontFamily->"Times",
  FontSize->18],
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"15", 
     SqrtBox[
      RowBox[{"5", "+", 
       RowBox[{"2", 
        SqrtBox["5"]}]}]]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "\[CapitalPhi]"}], "+", "1"}], ")"}], "2"]], 
   TraditionalForm]],
  FontSize->18],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SuperscriptBox["l", "2"],
    FontFamily->"Times"], TraditionalForm]],
  FontSize->18],
 " = ",
 StyleBox["15",
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   SqrtBox[
    RowBox[{"85", "-", 
     RowBox[{"38", 
      SqrtBox["5"]}]}]], TraditionalForm]],
  FontFamily->"Times"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    SuperscriptBox["l", "2"],
    FontFamily->"Times"], TraditionalForm]],
  FontSize->18],
 "."
}], "Text",
 CellChangeTimes->{{3.540587673782192*^9, 3.540587674294286*^9}, {
  3.54058786413306*^9, 3.54058795315626*^9}},
 TextAlignment->Center],

Cell["\<\
Por \[UAcute]ltimo, si en la figura anterior mostramos dos caras contiguas \
del gran dodecaedro estrellado y el icosaedro interior, veremos que el \
\[AAcute]ngulo di\[EAcute]drico del gran dodecaedro estrellado es el mismo \
que el del gran dodecaedro, pues los pent\[AAcute]gonos centrales de las dos \
caras son caras contiguas del gran dodecaedro construido a partir del \
icosaedro.\
\>", "Text",
 CellChangeTimes->{{3.5405882255832663`*^9, 3.540588288980489*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Radio\"\>", "\<\"Inradio\"\>", "\<\"Volumen\"\>", "\<\"\
\[CapitalAAcute]rea\"\>", "\<\"\[CapitalAAcute]ngulo di\[EAcute]drico\"\>"},
    {
     StyleBox["\<\"\\!\\(\\*FormBox[FormBox[FractionBox[SqrtBox[\\n    \
StyleBox[\\\"3\\\",\\nFontFamily->\\\"Times\\\",\\nFontSize->12.\
779998779296875`,\\nFontSlant->\\\"Plain\\\"]], \\n   RowBox[{\\n    \
StyleBox[\\\"2\\\",\\nFontFamily->\\\"Times\\\",\\nFontSize->12.\
779998779296875`,\\nFontSlant->\\\"Plain\\\"], \\\"\[CapitalPhi]\\\"}]],\\n  \
TraditionalForm],\\n TraditionalForm]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*FormBox[\\n RowBox[{\\n  \
StyleBox[FractionBox[\\\"1\\\", \\\"2\\\"],\\nFontFamily->\\\"Times\\\"], \
SqrtBox[\\n   StyleBox[FractionBox[\\n     RowBox[{\\\"25\\\", \\\"-\\\", \\n \
     RowBox[{\\\"11\\\", SqrtBox[\\\"5\\\"]}]}], \
\\\"10\\\"],\\nFontFamily->\\\"Times\\\"]]}],\\n TraditionalForm]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(TraditionalForm\\`\\(TraditionalForm\\`\\(\
TraditionalForm\\`\\*FractionBox[\\(5 \\((13 \\*SqrtBox[\\(5\\)] - 29)\\)\\), \
\\(4\\)]\\)\\)\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18], 
     StyleBox["\<\"\\!\\(\\*\\nStyleBox[\\\"15\\\",\\nFontFamily->\\\"Times\\\
\"]\\)\\!\\(TraditionalForm\\`\\*SqrtBox[\\(85 - 38 \
\\*SqrtBox[\\(5\\)]\\)]\\)\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->14], 
     StyleBox["\<\"arccos[\\!\\(\\*FractionBox[SqrtBox[\\(5\\)], \\(5\\)]\\)]\
\"\>",
      StripOnInput->False,
      FontFamily->"Times",
      FontSize->18]}
   },
   AutoDelete->False,
   GridBoxDividers->{
    "Columns" -> {False, True, True, True, True}, "Rows" -> {False, True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.540588364116097*^9, {3.54058840433847*^9, 3.5405884721373568`*^9}},
 TextAlignment->Center],

Cell[TextData[StyleBox["LOS S\[CapitalOAcute]LIDOS DE KEPLER-POINSOT",
 FontSize->18,
 FontColor->RGBColor[0, 0, 1]]], "Subsection",
 CellFrame->{{0, 0}, {0, 2}},
 CellMargins->{{100, 100}, {16, 18}},
 CellChangeTimes->{{3.538515429422391*^9, 3.538515429424019*^9}, {
  3.538517083097238*^9, 3.538517086760803*^9}, {3.538772137916774*^9, 
  3.5387721418334713`*^9}, {3.5389433492789*^9, 3.538943354615024*^9}, {
  3.538944083654379*^9, 3.538944088838513*^9}, {3.5391065561537533`*^9, 
  3.5391065641036177`*^9}, {3.539110603199396*^9, 3.5391106061050386`*^9}, {
  3.539114155036748*^9, 3.5391141567297077`*^9}, {3.5391190486065063`*^9, 
  3.5391190499503193`*^9}, {3.539191580022891*^9, 3.539191581987825*^9}, {
  3.539194702212619*^9, 3.539194706217629*^9}, {3.539198553615024*^9, 
  3.5391985588123913`*^9}, {3.539255753070822*^9, 3.539255755378742*^9}, {
  3.539381764243767*^9, 3.539381768720518*^9}, {3.5394685624739428`*^9, 
  3.539468565705537*^9}, {3.5403214883881617`*^9, 3.540321493567947*^9}, {
  3.540588519864255*^9, 3.540588541927115*^9}},
 TextAlignment->Center,
 Hyphenation->False],

Cell[TextData[{
 "Kepler fue el primero en advertir que el peque\[NTilde]o y el gran \
dodecaedro estrellado pod\[IAcute]an verse como poliedros regulares \
admitiendo intersecciones entre caras, aunque las figuras en s\[IAcute] ya \
eran conocidas. Ambas figuras fueron redescubiertas por Louis Poinsot en el \
siglo XIX, quien observ\[OAcute] que lo mismo era v\[AAcute]lido para el gran \
dodecaedro y el gran icosaedro. Por ello, las cuatro figuras son conocidas \
como ",
 StyleBox["s\[OAcute]lidos de Kepler-Poinsot,",
  FontSlant->"Italic"],
 " y resultan ser los \[UAcute]nicos poliedros regulares no convexos. La \
figura siguiente los muestra a la vez que permite poner de manifiesto las \
figuras de sus v\[EAcute]rtices. Vemos que la notaci\[OAcute]n {c,v} para \
referirse al s\[OAcute]lido de cara {c} y figura {v} basta para distinguir un \
s\[OAcute]lido de Kepler-Poinsot de otro, as\[IAcute] como para distinguir \
los s\[OAcute]lidos plat\[OAcute]nicos de los s\[OAcute]lidos de \
Kepler-Poinsot (y, dado que son los \[UAcute]nicos poliedros regulares, para \
determinar completamente a cualquiera de ellos)."
}], "Text",
 CellChangeTimes->{{3.540588357144998*^9, 3.5405883571475973`*^9}, {
  3.540664937451388*^9, 3.540664944476775*^9}, {3.5406649814372387`*^9, 
  3.540665028685636*^9}, {3.540665067450235*^9, 3.540665165231127*^9}, {
  3.540670046534726*^9, 3.540670200164317*^9}, {3.5410754170360603`*^9, 
  3.5410754256023808`*^9}, {3.541091765211081*^9, 3.541091765742352*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`u$$], 0, "Figura"}, 0, 0.2}}, Typeset`size$$ = {
    712., {321.9375, 328.0625}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False, $CellContext`u$1616$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$1616$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Grid[{{
          Labeled[
           Graphics3D[{
             GrayLevel[0.7], 
             PolyhedronOperations`Truncate[
              PolyhedronData[
              "GreatDodecahedron", "Faces"], $CellContext`u$$]}, Lighting -> 
            "Neutral", Boxed -> False, ImageSize -> {300, 300}], 
           Style["Gran Dodecaedro {5,5/2}", 18]], 
          Labeled[
           Graphics3D[{{
              GrayLevel[0.7], 
              PolyhedronOperations`Truncate[
               PolyhedronData[
               "SmallStellatedDodecahedron", "Faces"], $CellContext`u$$]}}, 
            Lighting -> "Neutral", Boxed -> False, ImageSize -> {300, 300}], 
           Style["Peque\[NTilde]o Dodecaedro Estrellado {5/2,5}", 18]]}, {
          Labeled[
           Graphics3D[{{
              GrayLevel[0.7], 
              PolyhedronOperations`Truncate[
               PolyhedronData[
               "GreatIcosahedron", "Faces"], $CellContext`u$$]}}, Lighting -> 
            "Neutral", Boxed -> False, ImageSize -> {300, 300}], 
           Style["Gran Icosaedro {3,5/2}", 18]], 
          Labeled[
           Graphics3D[{{
              GrayLevel[0.7], 
              PolyhedronOperations`Truncate[
               PolyhedronData[
               "GreatStellatedDodecahedron", "Faces"], $CellContext`u$$]}}, 
            Lighting -> "Neutral", Boxed -> False, ImageSize -> {300, 300}], 
           Style["Gran Dodecaedro Estrellado {5/2,3}", 18]]}}], 
      "Specifications" :> {{{$CellContext`u$$, 0, "Figura"}, 0, 0.2, 
         AppearanceElements -> {}}}, "Options" :> {AppearanceElements -> {}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{757., {360., 366.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({PolyhedronOperations`Truncate[
         Pattern[PolyhedronOperations`Private`poly, 
          Blank[]], 
         PatternTest[
          Pattern[PolyhedronOperations`Private`ratio, 
           Blank[]], # == 0& ]] := PolyhedronOperations`Private`poly, 
       PolyhedronOperations`Truncate[
         Pattern[PolyhedronOperations`Private`ipoly, 
          Blank[]], 
         Optional[
          Pattern[PolyhedronOperations`Private`ratio, 
           Blank[]], 3/10]] := Condition[
         Block[{
          PolyhedronOperations`Private`pol, PolyhedronOperations`Private`res, 
           PolyhedronOperations`Private`reslist = {}, 
           PolyhedronOperations`Private`nratio = 
           N[PolyhedronOperations`Private`ratio], 
           PolyhedronOperations`Private`search, 
           PolyhedronOperations`Private`begin, 
           PolyhedronOperations`Private`val, 
           PolyhedronOperations`Private`$TruncList, 
           PolyhedronOperations`Private`$TruncHalfList, 
           PolyhedronOperations`Private`polygon}, 
          PolyhedronOperations`Private`poly = 
           ReplaceAll[
            PolyhedronOperations`Private`ipoly, {
             Pattern[PolyhedronOperations`Private`g, 
                Blank[GraphicsComplex]] :> ReplaceAll[
                PolyhedronOperations`Private`TruncateFace[
                PolyhedronOperations`Private`g, 
                 PolyhedronOperations`Private`ratio, False], Polygon -> 
                PolyhedronOperations`Private`polygon]}]; 
          PolyhedronOperations`Private`$TruncList = {}; 
          PolyhedronOperations`Private`$TruncHalfList = {}; 
          PolyhedronOperations`Private`pol = Flatten[
             ReplaceAll[PolyhedronOperations`Private`poly, Polygon[
                Pattern[PolyhedronOperations`Private`x, 
                 Blank[]]] :> 
              PolyhedronOperations`Private`TruncateFace[
               PolyhedronOperations`Private`x, 
                PolyhedronOperations`Private`nratio]]]; ReplaceAll[
            If[
            Length[PolyhedronOperations`Private`res] > 0, 
             PolyhedronOperations`Private`res = 
              Round[PolyhedronOperations`Private`$TruncList 100000000]/1.*^8; 
             PolyhedronOperations`Private`res = Sort[
                Flatten[
                 MapIndexed[{#, #2}& , PolyhedronOperations`Private`res, {3}],
                  2], OrderedQ[{
                  Part[#, 1], 
                  Part[#2, 1]}]& ]; PolyhedronOperations`Private`res = Join[{
                 Part[PolyhedronOperations`Private`res, {2, 1, 2}]}, 
                Partition[PolyhedronOperations`Private`res, 3, 1], {
                 Part[
                 PolyhedronOperations`Private`res, 
                  Length[PolyhedronOperations`Private`res] - {1, 0, 1}]}]; 
             PolyhedronOperations`Private`res = 
              Select[PolyhedronOperations`Private`res, Or[
                Part[#, 2, 1] == Part[#, 1, 1], Part[#, 2, 1] == 
                 Part[#, 3, 1]]& ]; 
             PolyhedronOperations`Private`res = Partition[
                Part[
                 Transpose[
                  Part[
                   Transpose[PolyhedronOperations`Private`res], 2]], 2], 2]; 
             While[PolyhedronOperations`Private`res =!= {}, 
               PolyhedronOperations`Private`search = ReplaceAll[{
                   Part[
                    First[PolyhedronOperations`Private`res], 2]}, {
                    Pattern[PolyhedronOperations`Private`a, 
                    Blank[]], 
                    Pattern[PolyhedronOperations`Private`b, 
                    Blank[]], 
                    Pattern[PolyhedronOperations`Private`c, 
                    Blank[]]} -> {
                   PolyhedronOperations`Private`a, 
                    PolyhedronOperations`Private`b, 
                    If[PolyhedronOperations`Private`c == 2, 1, 2]}]; 
               PolyhedronOperations`Private`begin = 
                PolyhedronOperations`Private`search; 
               PolyhedronOperations`Private`res = 
                Rest[PolyhedronOperations`Private`res]; 
               While[(PolyhedronOperations`Private`val = 
                  Select[PolyhedronOperations`Private`res, MemberQ[#, 
                    Part[PolyhedronOperations`Private`search, 1]]& , 
                    1]) =!= {}, 
                 PolyhedronOperations`Private`search = ReplaceAll[
                    Complement[
                    Part[PolyhedronOperations`Private`val, 1], 
                    PolyhedronOperations`Private`search], {
                    Pattern[PolyhedronOperations`Private`a, 
                    Blank[]], 
                    Pattern[PolyhedronOperations`Private`b, 
                    Blank[]], 
                    Pattern[PolyhedronOperations`Private`c, 
                    Blank[]]} -> {
                    PolyhedronOperations`Private`a, 
                    PolyhedronOperations`Private`b, 
                    If[PolyhedronOperations`Private`c == 2, 1, 2]}]; 
                 PolyhedronOperations`Private`begin = 
                  Join[PolyhedronOperations`Private`begin, 
                    PolyhedronOperations`Private`search]; 
                 PolyhedronOperations`Private`res = 
                  DeleteCases[PolyhedronOperations`Private`res, 
                    Part[PolyhedronOperations`Private`val, 1]]; Null]; 
               AppendTo[
                PolyhedronOperations`Private`reslist, 
                 PolyhedronOperations`Private`begin]; Null]; 
             If[PolyhedronOperations`Private`nratio === 0.5, 
               PolyhedronOperations`Private`reslist = 
                Apply[Part[PolyhedronOperations`Private`$TruncHalfList, 
                   SlotSequence[1]]& , PolyhedronOperations`Private`reslist, {
                  2}]; PolyhedronOperations`Private`pol = 
                ReplaceAll[PolyhedronOperations`Private`pol, Polygon[
                    Pattern[PolyhedronOperations`Private`x, 
                    Blank[]]] :> 
                  PolyhedronOperations`Private`combineSame[
                   PolyhedronOperations`Private`x]], 
               PolyhedronOperations`Private`reslist = 
               Apply[Part[PolyhedronOperations`Private`$TruncList, 
                  SlotSequence[1]]& , PolyhedronOperations`Private`reslist, {
                 2}]]; If[
              Head[PolyhedronOperations`Private`pol] === Graphics3D, 
               Join[
                Graphics3D[
                 Join[
                  First[PolyhedronOperations`Private`pol], 
                  Map[Polygon, PolyhedronOperations`Private`reslist]]], 
                Rest[PolyhedronOperations`Private`pol]], 
               Join[PolyhedronOperations`Private`pol, 
                Map[Polygon, PolyhedronOperations`Private`reslist]]], 
             PolyhedronOperations`Private`pol], {
            PolyhedronOperations`Private`polygon -> Polygon}]], 
         NumberQ[
          N[PolyhedronOperations`Private`ratio]]], 
       TagSet[PolyhedronOperations`Truncate, 
        MessageName[PolyhedronOperations`Truncate, "usage"], 
        "\!\(\*RowBox[{\" Truncate \", \"[\", StyleBox[\" expr \", \" TI \"], \
\"]\"}]\) truncates each edge of each polygon in graphics expression \
\!\(\*StyleBox[\" expr \", \" TI \"]\).\n\!\(\*RowBox[{\" Truncate \", \"[\", \
RowBox[{StyleBox[\" expr \", \" TI \"], \",\", StyleBox[\" ratio \", \" TI \
\"]}], \"]\"}]\) truncates to the specified \!\(\*StyleBox[\" ratio \", \" TI \
\"]\) of the edge length."], PolyhedronOperations`Private`poly = 
       GraphicsComplex[{{0, 0, (-5)/Sqrt[50 - 10 Sqrt[5]]}, {
          0, 0, 5/Sqrt[50 - 10 Sqrt[5]]}, {-Sqrt[2/(5 - Sqrt[5])], 
           0, -(1/Sqrt[10 - 2 Sqrt[5]])}, {
           Sqrt[2/(5 - Sqrt[5])], 0, 1/Sqrt[10 - 2 Sqrt[5]]}, {(1 + Sqrt[5])/(
           2 Sqrt[10 - 2 Sqrt[5]]), (-1)/
           2, -(1/Sqrt[10 - 2 Sqrt[5]])}, {(1 + Sqrt[5])/(2 
           Sqrt[10 - 2 Sqrt[5]]), 1/
           2, -(1/Sqrt[10 - 2 Sqrt[5]])}, {(-(1 + Sqrt[5]))/(2 
           Sqrt[10 - 2 Sqrt[5]]), (-1)/2, 1/Sqrt[
           10 - 2 Sqrt[5]]}, {(-(1 + Sqrt[5]))/(2 Sqrt[10 - 2 Sqrt[5]]), 1/2, 
           1/Sqrt[10 - 2 Sqrt[5]]}, {(-(-1 + Sqrt[5]))/(2 
           Sqrt[10 - 2 Sqrt[5]]), (-Sqrt[(5 + Sqrt[5])/(5 - Sqrt[5])])/
           2, -(1/Sqrt[10 - 2 Sqrt[5]])}, {(-(-1 + Sqrt[5]))/(2 
           Sqrt[10 - 2 Sqrt[5]]), Sqrt[(5 + Sqrt[5])/(5 - Sqrt[5])]/
           2, -(1/Sqrt[10 - 2 Sqrt[5]])}, {(-1 + Sqrt[5])/(2 
           Sqrt[10 - 2 Sqrt[5]]), (-Sqrt[(5 + Sqrt[5])/(5 - Sqrt[5])])/2, 1/
           Sqrt[10 - 2 Sqrt[5]]}, {(-1 + Sqrt[5])/(2 Sqrt[10 - 2 Sqrt[5]]), 
           Sqrt[(5 + Sqrt[5])/(5 - Sqrt[5])]/2, 1/Sqrt[10 - 2 Sqrt[5]]}, {
          0.00814883223784657, 0.02507952682562337, 0.9347588518194605}, {
          0.2547167238217202, 0.783937467549324, 0.4416230686517131}, {
          0.23338280405441703`, 0.799437467549324, 
          0.42532540417601994`}, {-0.658708208230437, 0.5095795268256234, 
          0.42532540417601994`}, {-0.6668570404682835, 0.4845, 
          0.4416230686517131}, {-0.02133391976730319, 0.0155, 
          0.9347588518194605}, {-0.6881909602355867, 0.469, 
          0.42532540417601994`}, {-0.6881909602355867, -0.469, 
          0.42532540417601994`}, {-0.6668570404682835, -0.4845, 
          0.4416230686517131}, {-0.02133391976730319, -0.0155, 
          0.9347588518194605}, {-0.658708208230437, -0.5095795268256234, 
          0.42532540417601994`}, {0.23338280405441703`, -0.799437467549324, 
          0.42532540417601994`}, {0.2547167238217202, -0.783937467549324, 
          0.4416230686517131}, {0.00814883223784657, -0.02507952682562337, 
          0.9347588518194605}, {0.2810868988806335, -0.783937467549324, 
          0.42532540417601994`}, {0.8324294655309733, -0.02507952682562337, 
          0.42532540417601994`}, {0.8242806332931267, 0., 
          0.4416230686517131}, {0.026370175058913238`, 0., 
          0.9347588518194605}, {0.8324294655309733, 0.02507952682562337, 
          0.42532540417601994`}, {0.2810868988806335, 0.783937467549324, 
          0.42532540417601994`}, {
          0.658708208230437, -0.5095795268256234, -0.42532540417601994`}, \
{-0.23338280405441703`, -0.799437467549324, -0.42532540417601994`}, \
{-0.2547167238217202, -0.783937467549324, -0.4416230686517131}, \
{-0.00814883223784657, -0.02507952682562337, -0.9347588518194605}, {
          0.02133391976730319, -0.0155, -0.9347588518194605}, {
          0.6668570404682835, -0.4845, -0.4416230686517131}, {
          0.6881909602355867, 0.469, -0.42532540417601994`}, {
          0.6881909602355867, -0.469, -0.42532540417601994`}, {
          0.02133391976730319, 0.0155, -0.9347588518194605}, {
          0.6668570404682835, 
          0.4845, -0.4416230686517131}, {-0.23338280405441703`, 
          0.799437467549324, -0.42532540417601994`}, {0.658708208230437, 
          0.5095795268256234, -0.42532540417601994`}, {-0.00814883223784657, 
          0.02507952682562337, -0.9347588518194605}, {-0.2547167238217202, 
          0.783937467549324, -0.4416230686517131}, {-0.8324294655309733, 
          0.02507952682562337, -0.42532540417601994`}, {-0.2810868988806335, 
          0.783937467549324, -0.42532540417601994`}, {-0.026370175058913238`, 
          0., -0.9347588518194605}, {-0.8242806332931267, 
          0., -0.4416230686517131}, {-0.2810868988806335, -0.783937467549324, \
-0.42532540417601994`}, {-0.8324294655309733, -0.02507952682562337, \
-0.42532540417601994`}, {0.24656789158387366`, 0.8090169943749475, 
          0.3989552291171067}, {-0.24656789158387366`, 
          0.8090169943749475, -0.3989552291171067}, {-0.2760506435890234, 
          0.799437467549324, -0.3989552291171067}, {-0.6750058727061301, 
          0.5095795268256234, 0.3989552291171067}, {-0.6932272155271968, 
          0.4845, 0.3989552291171067}, {-0.8456145530604299, 
          0.0155, -0.3989552291171067}, {-0.8456145530604299, -0.0155, \
-0.3989552291171067}, {-0.6932272155271968, -0.4845, 
          0.3989552291171067}, {-0.6750058727061301, -0.5095795268256234, 
          0.3989552291171067}, {-0.2760506435890234, -0.799437467549324, \
-0.3989552291171067}, {-0.24656789158387366`, -0.8090169943749475, \
-0.3989552291171067}, {0.24656789158387366`, -0.8090169943749475, 
          0.3989552291171067}, {0.2760506435890234, -0.799437467549324, 
          0.3989552291171067}, {
          0.6750058727061301, -0.5095795268256234, -0.3989552291171067}, {
          0.6932272155271968, -0.4845, -0.3989552291171067}, {
          0.8456145530604299, -0.0155, 0.3989552291171067}, {
          0.8456145530604299, 0.0155, 0.3989552291171067}, {
          0.6932272155271968, 0.4845, -0.3989552291171067}, {
          0.6750058727061301, 0.5095795268256234, -0.3989552291171067}, {
          0.2760506435890234, 0.799437467549324, 0.3989552291171067}}, {
          
          PolyhedronOperations`Private`polygon[{{13, 14, 15, 16, 17, 18}, {18,
            17, 19, 20, 21, 22}, {22, 21, 23, 24, 25, 26}, {26, 25, 27, 28, 
           29, 30}, {30, 29, 31, 32, 14, 13}, {33, 34, 35, 36, 37, 38}, {39, 
           40, 38, 37, 41, 42}, {43, 44, 42, 41, 45, 46}, {47, 48, 46, 45, 49,
            50}, {51, 52, 50, 49, 36, 35}, {53, 54, 55, 56, 16, 15}, {57, 58, 
           59, 60, 20, 19}, {61, 62, 63, 64, 24, 23}, {65, 66, 67, 68, 28, 
           27}, {69, 70, 71, 72, 32, 31}, {66, 65, 64, 63, 34, 33}, {70, 69, 
           68, 67, 40, 39}, {54, 53, 72, 71, 44, 43}, {58, 57, 56, 55, 48, 
           47}, {62, 61, 60, 59, 52, 51}}], 
          
          PolyhedronOperations`Private`polygon[{{49, 45, 41, 37, 36}, {22, 26,
            30, 13, 18}, {52, 59, 58, 47, 50}, {68, 69, 31, 29, 28}, {40, 67, 
           66, 33, 38}, {44, 71, 70, 39, 42}, {60, 61, 23, 21, 20}, {56, 57, 
           19, 17, 16}, {63, 62, 51, 35, 34}, {48, 55, 54, 43, 46}, {64, 65, 
           27, 25, 24}, {32, 72, 53, 15, 14}}]}], 
       PolyhedronOperations`Private`$TruncList = {}, 
       PolyhedronOperations`Private`$TruncHalfList = {}, 
       PolyhedronOperations`Private`TruncateFace[
         Pattern[PolyhedronOperations`Private`face, 
          Blank[List]], 0.5] := 
       Block[{PolyhedronOperations`Private`array, 
          PolyhedronOperations`Private`array2}, 
         PolyhedronOperations`Private`array = 
          PolyhedronOperations`Private`truncList[
           PolyhedronOperations`Private`face, 0.49]; 
         AppendTo[PolyhedronOperations`Private`$TruncList, 
           Partition[
            RotateLeft[PolyhedronOperations`Private`array], 2]]; 
         PolyhedronOperations`Private`array2 = Flatten[
            Map[0.5 {
               Apply[Plus, #], 
               Apply[Plus, #]}& , 
             Partition[PolyhedronOperations`Private`array, 2]], 1]; 
         AppendTo[PolyhedronOperations`Private`$TruncHalfList, 
           Partition[
            RotateLeft[PolyhedronOperations`Private`array2], 2]]; 
         Polygon[PolyhedronOperations`Private`array]], 
       PolyhedronOperations`Private`TruncateFace[
         Pattern[PolyhedronOperations`Private`face, 
          Blank[List]], 
         Pattern[PolyhedronOperations`Private`ratio, 
          Blank[]]] := 
       Block[{PolyhedronOperations`Private`array}, 
         PolyhedronOperations`Private`array = 
          PolyhedronOperations`Private`truncList[
           PolyhedronOperations`Private`face, 
            PolyhedronOperations`Private`ratio]; 
         AppendTo[PolyhedronOperations`Private`$TruncList, 
           Partition[
            RotateLeft[PolyhedronOperations`Private`array], 2]]; 
         Polygon[PolyhedronOperations`Private`array]], 
       PolyhedronOperations`Private`TruncateFace[
         GraphicsComplex[
          Pattern[PolyhedronOperations`Private`ipts, 
           Blank[]], 
          Pattern[PolyhedronOperations`Private`iprims, 
           Blank[]], 
          Pattern[PolyhedronOperations`Private`opts, 
           BlankNullSequence[]]], 
         Pattern[PolyhedronOperations`Private`ratio, 
          Blank[]], 
         Pattern[PolyhedronOperations`Private`open, 
          Blank[]]] := 
       Block[{PolyhedronOperations`Private`index, 
          PolyhedronOperations`Private`newpts, 
          PolyhedronOperations`Private`count = 0, 
          PolyhedronOperations`Private`pts = 
          PolyhedronOperations`Private`ipts, 
          PolyhedronOperations`Private`prims = 
          PolyhedronOperations`Private`iprims, 
          PolyhedronOperations`Private`faces}, 
         PolyhedronOperations`Private`index[
            Pattern[PolyhedronOperations`Private`pt, 
             Blank[]]] := (
           PolyhedronOperations`Private`index[
            PolyhedronOperations`Private`pt] = (
            PolyhedronOperations`Private`newpts[
               PreIncrement[PolyhedronOperations`Private`count]] = 
             PolyhedronOperations`Private`pt; 
            PolyhedronOperations`Private`count)); 
         Map[PolyhedronOperations`Private`index, 
           PolyhedronOperations`Private`pts]; 
         PolyhedronOperations`Private`prims = 
          ReplaceAll[PolyhedronOperations`Private`prims, {Polygon[
               Pattern[PolyhedronOperations`Private`a, {
                 Repeated[{
                   BlankSequence[Integer]}]}]] :> Polygon[
               Map[PolyhedronOperations`Private`truncatePolygon[
                 Part[PolyhedronOperations`Private`pts, #], #, 
                 PolyhedronOperations`Private`ratio]& , 
                PolyhedronOperations`Private`a]], Polygon[
               Pattern[PolyhedronOperations`Private`a, {
                 BlankSequence[Integer]}]] :> Polygon[
               PolyhedronOperations`Private`truncatePolygon[
                Part[
                PolyhedronOperations`Private`pts, 
                 PolyhedronOperations`Private`a], 
                PolyhedronOperations`Private`a, 
                PolyhedronOperations`Private`ratio]]}]; If[
           Not[PolyhedronOperations`Private`open], 
           PolyhedronOperations`Private`faces = Join[
              Flatten[
               Cases[{PolyhedronOperations`Private`iprims}, Polygon[
                  Pattern[PolyhedronOperations`Private`a, {
                    Repeated[{
                    BlankSequence[Integer]}]}]] :> 
                PolyhedronOperations`Private`a, Infinity], 1], 
              Cases[{PolyhedronOperations`Private`iprims}, Polygon[
                 Pattern[PolyhedronOperations`Private`a, {
                   BlankSequence[Integer]}]] :> 
               PolyhedronOperations`Private`a, Infinity]]; 
           PolyhedronOperations`Private`prims = 
            Append[{PolyhedronOperations`Private`prims}, 
              Polygon[
               PolyhedronOperations`Private`newfaces[
               PolyhedronOperations`Private`ipts, 
                PolyhedronOperations`Private`faces, 
                PolyhedronOperations`Private`ratio]]]]; GraphicsComplex[
           Map[PolyhedronOperations`Private`newpts, 
            Range[PolyhedronOperations`Private`count]], 
           PolyhedronOperations`Private`prims]], 
       PolyhedronOperations`Private`truncList[
         Pattern[PolyhedronOperations`Private`face, 
          Blank[]], 0.5] := Map[0.5 Apply[Plus, #]& , 
         Join[
          Partition[PolyhedronOperations`Private`face, 2, 1], {{
            Last[PolyhedronOperations`Private`face], 
            First[PolyhedronOperations`Private`face]}}]], 
       PolyhedronOperations`Private`truncList[
         Pattern[PolyhedronOperations`Private`face, 
          Blank[]], 
         Pattern[PolyhedronOperations`Private`ratio, 
          Blank[]]] := Flatten[
         Map[{
          PolyhedronOperations`Private`ratio (Part[#, 2] - Part[#, 1]) + 
           Part[#, 1], (1 - PolyhedronOperations`Private`ratio) (Part[#, 2] - 
             Part[#, 1]) + Part[#, 1]}& , 
          Join[
           Partition[PolyhedronOperations`Private`face, 2, 1], {{
             Last[PolyhedronOperations`Private`face], 
             First[PolyhedronOperations`Private`face]}}]], 1], 
       PolyhedronOperations`Private`truncatePolygon[
         Pattern[PolyhedronOperations`Private`ptc, 
          Blank[]], 
         Pattern[PolyhedronOperations`Private`pti, 
          Blank[]], 
         Pattern[PolyhedronOperations`Private`ratio, 
          Blank[]]] := 
       Block[{PolyhedronOperations`Private`new}, 
         PolyhedronOperations`Private`new = 
          Partition[PolyhedronOperations`Private`ptc, 2, 1, 1]; 
         If[PolyhedronOperations`Private`ratio == 0.5, 
           PolyhedronOperations`Private`new = 
           Map[Mean, PolyhedronOperations`Private`new], 
           PolyhedronOperations`Private`new = Flatten[
             
             Apply[{PolyhedronOperations`Private`ratio #2 + (1 - 
                 PolyhedronOperations`Private`ratio) #, 
               PolyhedronOperations`Private`ratio # + (1 - 
                 PolyhedronOperations`Private`ratio) #2}& , 
              PolyhedronOperations`Private`new, {1}], 1]]; 
         Map[PolyhedronOperations`Private`index, 
           PolyhedronOperations`Private`new]], 
       PolyhedronOperations`Private`newfaces[
         Pattern[PolyhedronOperations`Private`points, 
          Blank[]], 
         Pattern[PolyhedronOperations`Private`faces, 
          Blank[]], 
         Pattern[PolyhedronOperations`Private`ratio, 
          Blank[]]] := 
       Block[{PolyhedronOperations`Private`edges, 
          PolyhedronOperations`Private`polys, 
          PolyhedronOperations`Private`corners}, 
         PolyhedronOperations`Private`corners = Flatten[
            Map[Partition[#, 3, 1, 1]& , PolyhedronOperations`Private`faces], 
            1]; PolyhedronOperations`Private`polys = Map[{#, 
             Cases[PolyhedronOperations`Private`corners, {
                Pattern[PolyhedronOperations`Private`a, 
                 Blank[]], #, 
                Pattern[PolyhedronOperations`Private`b, 
                 Blank[]]} :> (PolyhedronOperations`Private`a -> 
               PolyhedronOperations`Private`b), Infinity]}& , 
            Range[
             Length[PolyhedronOperations`Private`points]]]; 
         PolyhedronOperations`Private`polys = 
          DeleteCases[PolyhedronOperations`Private`polys, {
             Blank[], {}}]; 
         PolyhedronOperations`Private`polys = 
          Map[PolyhedronOperations`Private`organize, 
            PolyhedronOperations`Private`polys]; Apply[
           
           Function[{
            PolyhedronOperations`Private`center, 
             PolyhedronOperations`Private`face}, 
            Map[
            PolyhedronOperations`Private`index[(1 - 
                PolyhedronOperations`Private`ratio) 
               Part[PolyhedronOperations`Private`points, 
                 PolyhedronOperations`Private`center] + 
              PolyhedronOperations`Private`ratio 
               Part[PolyhedronOperations`Private`points, #]]& , 
             PolyhedronOperations`Private`face]], 
           PolyhedronOperations`Private`polys, 1]], 
       PolyhedronOperations`Private`organize[{
          Pattern[PolyhedronOperations`Private`i, 
           Blank[]], 
          Pattern[PolyhedronOperations`Private`pairs, 
           Blank[]]}] := {PolyhedronOperations`Private`i, 
         Reverse[
          NestList[ReplaceAll[#, PolyhedronOperations`Private`pairs]& , 
           First[
            First[PolyhedronOperations`Private`pairs]], 
           Length[PolyhedronOperations`Private`pairs] - 1]]}, 
       PolyhedronOperations`Private`combineSame[
         Pattern[PolyhedronOperations`Private`x, 
          Blank[List]]] := 
       Block[{PolyhedronOperations`Private`set}, 
         PolyhedronOperations`Private`set = 
          If[Norm[Part[PolyhedronOperations`Private`x, 2] - Part[
              PolyhedronOperations`Private`x, 1]] > 
            Norm[Part[PolyhedronOperations`Private`x, 3] - Part[
              PolyhedronOperations`Private`x, 2]], 
            RotateLeft[PolyhedronOperations`Private`x], 
            PolyhedronOperations`Private`x]; Polygon[
           Map[0.5 Apply[Plus, #]& , 
            Partition[PolyhedronOperations`Private`set, 2]]]]}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.540669377806034*^9, 3.5408002672110453`*^9},
 TextAlignment->Center],

Cell["\<\
Reunimos en una misma tabla los datos que hemos obtenido para los \
s\[OAcute]lidos plat\[OAcute]nicos y los de Kepler-Poinsot (correspondientes \
a poliedros de radio unitario):\
\>", "Text",
 CellChangeTimes->{{3.540669358890286*^9, 3.540669358892165*^9}, {
  3.540670210943235*^9, 3.540670210946664*^9}, {3.54067024549584*^9, 
  3.540670269244795*^9}, {3.540671082079171*^9, 3.540671101389249*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"\"\>", "\<\"C\"\>", "\<\"A\"\>", "\<\"V\"\>", "\<\"c\"\>", "\<\"v\"\
\>", "\<\"N\"\>", "\<\"E\"\>", "\<\"l\"\>", "\<\"r\"\>", "\<\"Vol\"\>", "\<\"\
\[CapitalAAcute]rea\"\>", "\<\"D\"\>"},
    {"\<\"Tetraedro\"\>", "4", "6", "4", "3", "3", "", "", "1.63299`", 
     "0.33333`", "0.5132`", 
     "4.6188`", "\<\"\\!\\(\\*SuperscriptBox[\\(70.52\\), \
\\(\[SmallCircle]\\)]\\)\"\>"},
    {"\<\"Hexaedro\"\>", "6", "12", "8", "4", "3", "", "", "1.1547`", 
     "0.57735`", "1.5396`", 
     "8", "\<\"\\!\\(\\*SuperscriptBox[\\(90\\), \
\\(\[SmallCircle]\\)]\\)\"\>"},
    {"\<\"Octaedro\"\>", "8", "12", "6", "3", "4", "", "", "1.41421`", 
     "0.57735`", "1.33333`", 
     "6.9282`", "\<\"\\!\\(\\*SuperscriptBox[\\(109.47\\), \
\\(\[SmallCircle]\\)]\\)\"\>"},
    {"\<\"Dodecaedro\"\>", "12", "30", "20", "5", "3", "", "", "0.71364`", 
     "0.79465`", "2.78516`", 
     "10.514`", "\<\"\\!\\(\\*SuperscriptBox[\\(116.56\\), \
\\(\[SmallCircle]\\)]\\)\"\>"},
    {"\<\"Icosaedro\"\>", "20", "30", "12", "3", "5", "", "", "1.0546`", 
     "0.79465`", "2.53615`", 
     "9.5745`", "\<\"\\!\\(\\*SuperscriptBox[\\(138.19\\), \
\\(\[SmallCircle]\\)]\\)\"\>"},
    {"\<\"Gran dodecaedro\"\>", "12", "30", "12", 
     "5", "\<\"5/2\"\>", "\<\"Dodecaedro\"\>", "\<\"Icosaedro\"\>", "1.0514`",
      "0.44721`", "1.79611`", 
     "12.0486`", "\<\"\\!\\(\\*SuperscriptBox[\\(63.43\\), \
\\(\[SmallCircle]\\)]\\)\"\>"},
    {"\<\"Peque\[NTilde]o dodecaedro estrellado\"\>", "12", "30", 
     "12", "\<\"5/2\"\>", "5", "\<\"Dodecaedro\"\>", "\<\"Icosaedro\"\>", 
     "1.7013`", "0.44721`", "1.11005`", 
     "7.4464`", "\<\"\\!\\(\\*SuperscriptBox[\\(116.56\\), \
\\(\[SmallCircle]\\)]\\)\"\>"},
    {"\<\"Gran icosaedro\"\>", "20", "30", "12", 
     "3", "\<\"5/2\"\>", "\<\"Icosaedro\"\>", "\<\"Icosaedro\"\>", "1.7013`", 
     "0.18759`", "0.73081`", 
     "11.6873`", "\<\"\\!\\(\\*SuperscriptBox[\\(41.81\\), \
\\(\[SmallCircle]\\)]\\)\"\>"},
    {"\<\"Gran dodecaedro estrellado\"\>", "12", "30", "20", "\<\"5/2\"\>", 
     "3", "\<\"Dodecaedro\"\>", "\<\"Dodecaedro\"\>", "1.8683`", "0.18759`", 
     "0.56156`", 
     "8.9805`", "\<\"\\!\\(\\*SuperscriptBox[\\(63.43\\), \
\\(\[SmallCircle]\\)]\\)\"\>"}
   },
   AutoDelete->False,
   GridBoxDividers->{
    "Columns" -> {
      False, True, False, False, True, False, True, False, True, True, True, 
       False, True, True}, 
     "Rows" -> {
      False, True, True, False, True, False, True, False, True, False, True}},
   
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.540670293718581*^9, {3.540670366096464*^9, 3.540670383476533*^9}, 
   3.540670426452302*^9, {3.54067047998956*^9, 3.5406705156116457`*^9}, 
   3.54067055422404*^9, 3.540670591221807*^9, 3.540671055605062*^9, 
   3.54067131014025*^9, {3.540671969499009*^9, 3.540672006234692*^9}, 
   3.540672106762772*^9, {3.540672191985694*^9, 3.5406722153278*^9}, 
   3.5406722870060797`*^9, 3.540672360227482*^9, 3.540672412118791*^9, 
   3.540672506926841*^9, 3.540672564654501*^9, 3.5406726211402063`*^9, 
   3.540672717413899*^9, 3.540672760040435*^9, {3.540672801459848*^9, 
   3.540672811052539*^9}, {3.540672957537795*^9, 3.540672985587399*^9}, 
   3.54067304775462*^9, {3.5406730852041407`*^9, 3.540673094427302*^9}, 
   3.540673135574374*^9, {3.540673193971084*^9, 3.540673236069845*^9}, 
   3.5406732751144323`*^9, 3.540675019874002*^9, 3.5406756355908127`*^9, 
   3.5406757132945337`*^9, 3.5406757851270027`*^9, 3.540676146756419*^9, {
   3.541092109251561*^9, 3.5410921233779793`*^9}, {3.54109215826497*^9, 
   3.541092166222823*^9}, {3.541092238744356*^9, 3.54109226105853*^9}, 
   3.5410923388797092`*^9, 3.54109238053095*^9, {3.5410969974212313`*^9, 
   3.5410970469172993`*^9}},
 TextAlignment->Center],

Cell[TextData[{
 "La tabla incluye una columna para el \[OpenCurlyDoubleQuote]n\[UAcute]cleo\
\[CloseCurlyDoubleQuote] y otra para la \[OpenCurlyDoubleQuote]envoltura\
\[CloseCurlyDoubleQuote] de cada s\[OAcute]lido de Kepler-Poinsot. El ",
 StyleBox["n\[UAcute]cleo",
  FontSlant->"Italic"],
 " es el poliedro convexo que determinan los planos de sus caras (el que ver\
\[IAcute]a alguien situado en su centro) y la ",
 StyleBox["envoltura",
  FontSlant->"Italic"],
 " es el menor poliedro convexo que lo contiene, cuyos v\[EAcute]rtices son \
los mismos que los del poliedro dado. En efecto, hemos visto que los v\
\[EAcute]rtices de todo s\[OAcute]lido de Kepler-Poinsot coinciden con los v\
\[EAcute]rtices de un s\[OAcute]lido plat\[OAcute]nico, y no es \
dif\[IAcute]cil comprobar el rec\[IAcute]proco:"
}], "Text",
 CellChangeTimes->{{3.541091815429566*^9, 3.541091815431263*^9}, {
  3.541092459776297*^9, 3.541092579597521*^9}, {3.541092667817336*^9, 
  3.541092700403455*^9}, {3.5410980964923973`*^9, 3.541098103680592*^9}}],

Cell[TextData[{
 StyleBox["Teorema 3.7",
  FontWeight->"Bold"],
 ": ",
 StyleBox["Los \[UAcute]nicos poliedros regulares cuyos v\[EAcute]rtices \
coinciden con los de un s\[OAcute]lido plat\[OAcute]nico son los propios s\
\[OAcute]lidos plat\[OAcute]nicos y los s\[OAcute]lidos de Kepler-Poinsot.",
  FontSlant->"Italic"]
}], "Text",
 CellMargins->{{12, 10}, {16, 16}},
 CellChangeTimes->{{3.541093926864724*^9, 3.5410939881113167`*^9}, 
   3.541178754702907*^9}],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": La prueba consiste simplemente en buscar entre los v\[EAcute]rtices de un \
s\[OAcute]lido plat\[OAcute]nico grupos que formen pol\[IAcute]gonos \
regulares que podamos tomar como caras de un poliedro regular, y para cada \
uno de ellos comprobar si tales pol\[IAcute]gonos realmente forman un \
poliedro. En el caso del tetraedro es claro que los \[UAcute]nicos pol\
\[IAcute]gonos que pueden formarse con sus cuatro v\[EAcute]rtices son sus \
cuatro caras, luego del tetraedro no obtenemos nada m\[AAcute]s que el \
tetraedro. "
}], "Text",
 CellChangeTimes->{{3.541091815581369*^9, 3.541091815583644*^9}, {
   3.541093991969347*^9, 3.5410939947983828`*^9}, 3.541094038959959*^9, {
   3.541094070231283*^9, 3.541094163816289*^9}}],

Cell["\<\
Consideremos ahora un cubo. (Notemos que estamos buscando configuraciones \
regulares dentro de un n\[UAcute]mero finito (y no muy grande) de \
posibilidades, as\[IAcute] que no entraremos en detalles a la hora de \
justificar que presentamos todos los casos posibles. Es algo que el lector \
puede constatar sin m\[AAcute]s que un poco de paciencia.) Es claro que, \
aparte de los cuadrados que forman sus caras, los \[UAcute]nicos \
pol\[IAcute]gonos regulares que podemos formar con sus v\[EAcute]rtices son \
los tri\[AAcute]ngulos equil\[AAcute]teros que muestra la figura siguiente, y \
con dichos tri\[AAcute]ngulos se forman tetraedros:\
\>", "Text",
 CellChangeTimes->{{3.541091815765258*^9, 3.54109181576751*^9}, {
  3.541094240962186*^9, 3.541094295929673*^9}, {3.541094326195973*^9, 
  3.541094410483151*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[0.2], Glow[
     GrayLevel[0.85]], 
    GeometricTransformation3DBox[
     GraphicsComplex3DBox[
      NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
        Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
        Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
        Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
        Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
        Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
        Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
        Rational[1, 2], Rational[1, 2], Rational[
         1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
       0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {
       0.5, 0.5, -0.5}, {0.5, 0.5, 0.5}}], 
      Polygon3DBox[{{8, 4, 2, 6}, {8, 6, 5, 7}, {8, 7, 3, 4}, {4, 3, 1, 2}, {
       1, 3, 7, 5}, {2, 1, 5, 6}}]], {{{2, 0, 0}, {0, 2, 0}, {0, 0, 2}}, {0, 
      0, 0}}]}, 
   {Opacity[0.7], Glow[
     GrayLevel[0.5]], Polygon3DBox[{{1, 1, 1}, {1, -1, -1}, {-1, 1, -1}}]}, 
   {Opacity[0.7], Glow[
     GrayLevel[0.5]], Polygon3DBox[{{1, 1, 1}, {1, -1, -1}, {-1, -1, 1}}]}, 
   {Opacity[0.7], Glow[
     GrayLevel[0.5]], 
    Polygon3DBox[{{-1, 1, -1}, {1, -1, -1}, {-1, -1, 1}}]}, 
   {Opacity[0.7], Glow[
     GrayLevel[0.5]], Polygon3DBox[{{1, 1, 1}, {-1, -1, 1}, {-1, 1, -1}}]}},
  Boxed->False,
  ImageSize->{169., Automatic},
  Lighting->None,
  ViewPoint->{2.6575191015450024`, -1.7479885739470475`, 1.1541785694917435`},
  
  ViewVertical->{0.2549727785272886, -0.12327346424933952`, 
   0.959058150073311}]], "Output",
 CellChangeTimes->{3.5410944435128937`*^9},
 TextAlignment->Center],

Cell["\<\
Con los v\[EAcute]rtices de un octaedro, aparte de sus caras, s\[OAcute]lo se \
pueden formar tres cuadrados que no forman un poliedro:\
\>", "Text",
 CellChangeTimes->{{3.5410918159092693`*^9, 3.5410918159116373`*^9}, {
  3.541094544517599*^9, 3.541094567573742*^9}}],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[
   NCache[{{-2^Rational[-1, 2], 0, 0}, {0, 2^Rational[-1, 2], 0}, {
     0, 0, -2^Rational[-1, 2]}, {0, 0, 2^Rational[-1, 2]}, {
     0, -2^Rational[-1, 2], 0}, {
     2^Rational[-1, 2], 0, 0}}, {{-0.7071067811865475, 0, 0}, {
     0, 0.7071067811865475, 0}, {0, 0, -0.7071067811865475}, {
     0, 0, 0.7071067811865475}, {0, -0.7071067811865475, 0}, {
     0.7071067811865475, 0, 0}}], 
   {GrayLevel[0.5], Opacity[1], 
    Polygon3DBox[{{1, 2, 6, 5}, {1, 3, 6, 4}, {2, 3, 5, 4}}]}],
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{339.19617146096016`, 312.329947290082},
  Lighting->"Neutral",
  ViewPoint->{1.559390080090953, -2.92883976760002, 0.6634758426940609},
  ViewVertical->{0.18704766020114272`, -0.37786271212094863`, 
   0.9067706124494104}]], "Output",
 CellChangeTimes->{3.541094942191728*^9},
 TextAlignment->Center],

Cell["\<\
En un dodecaedro hay cinco clases distintas de pol\[IAcute]gonos regulares \
(distintos de sus caras):\
\>", "Text",
 CellChangeTimes->{{3.541091816053247*^9, 3.541091816055523*^9}, {
  3.541094978626329*^9, 3.541095017065483*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     Graphics3DBox[
      {GrayLevel[0.8], Opacity[0.2], 
       GraphicsComplex3DBox[
        NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
           Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
          Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
          Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
          Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
           1, 2], Root[
           1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
            Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[-1, 2], (Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2]}, {(Rational[1, 4] + 
            Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
           1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
           Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
          Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}, {
          Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}, {
          Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
           0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2]}, {
          Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
           1 - 100 #^2 + 80 #^4& , 1, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
           1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
            Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
            Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
           0.2628655560595668}, {
          1.3763819204711736`, 
           0, -0.2628655560595668}, {-0.42532540417601994`, \
-1.3090169943749475`, 0.2628655560595668}, {-0.42532540417601994`, 
          1.3090169943749475`, 0.2628655560595668}, {
          1.1135163644116066`, -0.8090169943749475, 0.2628655560595668}, {
          1.1135163644116066`, 0.8090169943749475, 
          0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
          1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
          1.1135163644116066`}, {-0.6881909602355868, -0.5, \
-1.1135163644116068`}, {-0.6881909602355868, 0.5, -1.1135163644116068`}, {
          0.6881909602355868, -0.5, 1.1135163644116066`}, {0.6881909602355868,
           0.5, 1.1135163644116066`}, {
          0.85065080835204, 
           0, -1.1135163644116068`}, {-1.1135163644116068`, \
-0.8090169943749475, -0.2628655560595668}, {-1.1135163644116068`, 
          0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
           1.1135163644116066`}, {
          0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
          0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
          0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
          0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], {
         Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 
          19}, {11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 
          5, 19, 17, 13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 
          3, 14, 9}, {3, 7, 16, 1, 14}, {16, 8, 4, 15, 1}}], 
         {GrayLevel[0.5], Opacity[1], Polygon3DBox[{1, 8, 7}]}}]},
      Boxed->False,
      Lighting->"Neutral"], 
     Graphics3DBox[
      {GrayLevel[0.8], Opacity[0.2], 
       GraphicsComplex3DBox[
        NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
           Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
          Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
          Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
          Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
           1, 2], Root[
           1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
            Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[-1, 2], (Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2]}, {(Rational[1, 4] + 
            Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
           1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
           Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
          Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}, {
          Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}, {
          Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
           0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2]}, {
          Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
           1 - 100 #^2 + 80 #^4& , 1, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
           1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
            Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
            Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
           0.2628655560595668}, {
          1.3763819204711736`, 
           0, -0.2628655560595668}, {-0.42532540417601994`, \
-1.3090169943749475`, 0.2628655560595668}, {-0.42532540417601994`, 
          1.3090169943749475`, 0.2628655560595668}, {
          1.1135163644116066`, -0.8090169943749475, 0.2628655560595668}, {
          1.1135163644116066`, 0.8090169943749475, 
          0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
          1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
          1.1135163644116066`}, {-0.6881909602355868, -0.5, \
-1.1135163644116068`}, {-0.6881909602355868, 0.5, -1.1135163644116068`}, {
          0.6881909602355868, -0.5, 1.1135163644116066`}, {0.6881909602355868,
           0.5, 1.1135163644116066`}, {
          0.85065080835204, 
           0, -1.1135163644116068`}, {-1.1135163644116068`, \
-0.8090169943749475, -0.2628655560595668}, {-1.1135163644116068`, 
          0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
           1.1135163644116066`}, {
          0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
          0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
          0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
          0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], {
         Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 
          19}, {11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 
          5, 19, 17, 13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 
          3, 14, 9}, {3, 7, 16, 1, 14}, {16, 8, 4, 15, 1}}], 
         {GrayLevel[0.5], Opacity[1], Polygon3DBox[{1, 8, 11, 3}]}}]},
      Boxed->False,
      Lighting->"Neutral"], 
     Graphics3DBox[
      {GrayLevel[0.8], Opacity[0.2], 
       GraphicsComplex3DBox[
        NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
           Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
          Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
          Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
          Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
           1, 2], Root[
           1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
            Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[-1, 2], (Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2]}, {(Rational[1, 4] + 
            Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
           1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
           Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
          Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}, {
          Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}, {
          Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
           0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2]}, {
          Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
           1 - 100 #^2 + 80 #^4& , 1, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
           1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
            Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
            Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
           0.2628655560595668}, {
          1.3763819204711736`, 
           0, -0.2628655560595668}, {-0.42532540417601994`, \
-1.3090169943749475`, 0.2628655560595668}, {-0.42532540417601994`, 
          1.3090169943749475`, 0.2628655560595668}, {
          1.1135163644116066`, -0.8090169943749475, 0.2628655560595668}, {
          1.1135163644116066`, 0.8090169943749475, 
          0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
          1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
          1.1135163644116066`}, {-0.6881909602355868, -0.5, \
-1.1135163644116068`}, {-0.6881909602355868, 0.5, -1.1135163644116068`}, {
          0.6881909602355868, -0.5, 1.1135163644116066`}, {0.6881909602355868,
           0.5, 1.1135163644116066`}, {
          0.85065080835204, 
           0, -1.1135163644116068`}, {-1.1135163644116068`, \
-0.8090169943749475, -0.2628655560595668}, {-1.1135163644116068`, 
          0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
           1.1135163644116066`}, {
          0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
          0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
          0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
          0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], {
         Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 
          19}, {11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 
          5, 19, 17, 13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 
          3, 14, 9}, {3, 7, 16, 1, 14}, {16, 8, 4, 15, 1}}], 
         {GrayLevel[0.5], Opacity[1], Polygon3DBox[{2, 3, 4}]}}]},
      Boxed->False,
      Lighting->"Neutral"], 
     Graphics3DBox[
      {GrayLevel[0.8], Opacity[0.2], 
       GraphicsComplex3DBox[
        NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
           Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
          Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
          Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
          Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
           1, 2], Root[
           1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
            Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[-1, 2], (Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2]}, {(Rational[1, 4] + 
            Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
           1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
           Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
          Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}, {
          Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}, {
          Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
           0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2]}, {
          Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
           1 - 100 #^2 + 80 #^4& , 1, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
           1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
            Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
            Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
           0.2628655560595668}, {
          1.3763819204711736`, 
           0, -0.2628655560595668}, {-0.42532540417601994`, \
-1.3090169943749475`, 0.2628655560595668}, {-0.42532540417601994`, 
          1.3090169943749475`, 0.2628655560595668}, {
          1.1135163644116066`, -0.8090169943749475, 0.2628655560595668}, {
          1.1135163644116066`, 0.8090169943749475, 
          0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
          1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
          1.1135163644116066`}, {-0.6881909602355868, -0.5, \
-1.1135163644116068`}, {-0.6881909602355868, 0.5, -1.1135163644116068`}, {
          0.6881909602355868, -0.5, 1.1135163644116066`}, {0.6881909602355868,
           0.5, 1.1135163644116066`}, {
          0.85065080835204, 
           0, -1.1135163644116068`}, {-1.1135163644116068`, \
-0.8090169943749475, -0.2628655560595668}, {-1.1135163644116068`, 
          0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
           1.1135163644116066`}, {
          0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
          0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
          0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
          0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], {
         Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 
          19}, {11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 
          5, 19, 17, 13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 
          3, 14, 9}, {3, 7, 16, 1, 14}, {16, 8, 4, 15, 1}}], 
         {GrayLevel[0.5], Opacity[1], Polygon3DBox[{1, 3, 5, 6, 4}]}}]},
      AutomaticImageSize->True,
      Boxed->False,
      ImageSize->{171.10848584052133`, 158.69137044201193`},
      Lighting->"Neutral",
      ViewPoint->{1.2875767998158127`, -2.795081340291809, 
       1.4070061427472922`},
      ViewVertical->{0.10114125664365053`, -0.18510929039980434`, 
       1.2103226805854497`}], 
     Graphics3DBox[
      {GrayLevel[0.8], Opacity[0.2], 
       GraphicsComplex3DBox[
        NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
           Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 3, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
          Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
          Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
          Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
           1, 2], Root[
           1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
            Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[-1, 2], (Rational[5, 8] + 
            Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2]}, {(Rational[1, 4] + 
            Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
           1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
           Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
          Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}, {
          Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}, {
          Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
           0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2]}, {
          Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
           Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
           1 - 100 #^2 + 80 #^4& , 1, 0]}, {
          Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
           Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
           1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
            Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
            Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
           Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
           1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
           0.2628655560595668}, {
          1.3763819204711736`, 
           0, -0.2628655560595668}, {-0.42532540417601994`, \
-1.3090169943749475`, 0.2628655560595668}, {-0.42532540417601994`, 
          1.3090169943749475`, 0.2628655560595668}, {
          1.1135163644116066`, -0.8090169943749475, 0.2628655560595668}, {
          1.1135163644116066`, 0.8090169943749475, 
          0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
          1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
          1.1135163644116066`}, {-0.6881909602355868, -0.5, \
-1.1135163644116068`}, {-0.6881909602355868, 0.5, -1.1135163644116068`}, {
          0.6881909602355868, -0.5, 1.1135163644116066`}, {0.6881909602355868,
           0.5, 1.1135163644116066`}, {
          0.85065080835204, 
           0, -1.1135163644116068`}, {-1.1135163644116068`, \
-0.8090169943749475, -0.2628655560595668}, {-1.1135163644116068`, 
          0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
           1.1135163644116066`}, {
          0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
          0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
          0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
          0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], {
         Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 
          19}, {11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 
          5, 19, 17, 13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 
          3, 14, 9}, {3, 7, 16, 1, 14}, {16, 8, 4, 15, 1}}], 
         {GrayLevel[0.5], Opacity[1], Polygon3DBox[{1, 5, 4, 3, 6}]}}]},
      Boxed->False,
      Lighting->"Neutral"]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.541096433416201*^9, 3.541096601482861*^9, 
  3.5410966951889133`*^9},
 TextAlignment->Center],

Cell["\<\
Los tri\[AAcute]ngulos de la primera figura no forman poliedros, pues no hay \
tri\[AAcute]ngulos an\[AAcute]logos que compartan aristas con uno dado. Los \
cuadrados de la segunda figura forman cubos (v\[EAcute]ase la cuarta figura \
en la construcci\[OAcute]n del dodecaedro), los tri\[AAcute]ngulos de la \
tercera figura forman los tetraedros inscritos en los cubos que se forman con \
los cuadrados anteriores, los pent\[AAcute]gonos de la cuarta figura no \
forman ning\[UAcute]n poliedro, porque no hay otros que compartan aristas con \
uno dado. Por \[UAcute]ltimo, los pentagramas de la \[UAcute]ltima figura \
forman un gran icosaedro estrellado (sin m\[AAcute]s opci\[OAcute]n: al a\
\[NTilde]adir pentagramas an\[AAcute]logos que compartan las cinco aristas \
del pentagrama se\[NTilde]alado, y a su vez a\[NTilde]adir pentagramas que \
compartan las aristas libres de los nuevos pentagramas, y as\[IAcute] \
sucesivamente hasta cerrar el poliedro, lo que nos sale es un gran gran \
icosaedro estrellado).\
\>", "Text",
 CellChangeTimes->{{3.541091816213229*^9, 3.541091816215445*^9}, {
   3.541096528049768*^9, 3.5410965568562593`*^9}, {3.541096616002224*^9, 
   3.541096625040667*^9}, {3.5410967018848553`*^9, 3.5410969123154*^9}, {
   3.541097089430876*^9, 3.5410970895249557`*^9}, {3.5410971606958523`*^9, 
   3.541097199958745*^9}, 3.541098015089242*^9}],

Cell["\<\
En un icosaedro s\[OAcute]lo hay tres clases de pol\[IAcute]gonos regulares:\
\>", "Text",
 CellChangeTimes->{{3.541091816357215*^9, 3.54109181635948*^9}, {
  3.541097209919786*^9, 3.541097228214632*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {
     Graphics3DBox[
      {GrayLevel[0.8], Opacity[0.2], 
       GraphicsComplex3DBox[
        NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
          0, 0, 5 (50 - 10 5^Rational[1, 2])^
            Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
           0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
            Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
           Rational[-1, 2]}, {
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
            5^Rational[1, 2]), 
           Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
            5^Rational[1, 2]), Rational[
           1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
            5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
           Rational[-1, 2]}, {
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
            5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
           Rational[-1, 2]}, {
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
            5^Rational[1, 2]), 
           Rational[-1, 
             2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
            Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
            5^Rational[1, 2]), 
           Rational[
            1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
            Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
            5^Rational[1, 2]), 
           Rational[-1, 
             2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
            Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
            5^Rational[1, 2]), 
           Rational[
            1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
            Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
          0, 0, -0.9510565162951536}, {
          0, 0, 0.9510565162951536}, {-0.85065080835204, 
           0, -0.42532540417601994`}, {
          0.85065080835204, 0, 0.42532540417601994`}, {
          0.6881909602355868, -0.5, -0.42532540417601994`}, {
          0.6881909602355868, 
          0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
          0.42532540417601994`}, {-0.6881909602355868, 0.5, 
          0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
          0.8090169943749475, -0.42532540417601994`}, {
          0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
          0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], {
         Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 
          12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 
          10, 8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 9}, {
          6, 4, 5}, {10, 12, 6}, {3, 8, 10}, {9, 7, 3}}], 
         {GrayLevel[0.6], Opacity[1], Polygon3DBox[{{4, 12, 8, 7, 11}}]}}]},
      AutomaticImageSize->True,
      Boxed->False,
      ImageSize->{180.60394967577582`, 180.93015582810062`},
      Lighting->"Neutral",
      ViewPoint->{-2.4682330143164424`, 
       2.1930392350103327`, -0.7405435171167627},
      ViewVertical->{-0.3487347692813106, 
       0.2956947061797492, -0.916208725252727}], 
     Graphics3DBox[
      {GrayLevel[0.8], Opacity[0.2], 
       GraphicsComplex3DBox[
        NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
          0, 0, 5 (50 - 10 5^Rational[1, 2])^
            Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
           0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
            Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
           Rational[-1, 2]}, {
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
            5^Rational[1, 2]), 
           Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
            5^Rational[1, 2]), Rational[
           1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
            5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
           Rational[-1, 2]}, {
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
            5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
           Rational[-1, 2]}, {
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
            5^Rational[1, 2]), 
           Rational[-1, 
             2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
            Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
            5^Rational[1, 2]), 
           Rational[
            1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
            Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
            5^Rational[1, 2]), 
           Rational[-1, 
             2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
            Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
            5^Rational[1, 2]), 
           Rational[
            1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
            Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
          0, 0, -0.9510565162951536}, {
          0, 0, 0.9510565162951536}, {-0.85065080835204, 
           0, -0.42532540417601994`}, {
          0.85065080835204, 0, 0.42532540417601994`}, {
          0.6881909602355868, -0.5, -0.42532540417601994`}, {
          0.6881909602355868, 
          0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
          0.42532540417601994`}, {-0.6881909602355868, 0.5, 
          0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
          0.8090169943749475, -0.42532540417601994`}, {
          0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
          0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], {
         Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 
          12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 
          10, 8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 9}, {
          6, 4, 5}, {10, 12, 6}, {3, 8, 10}, {9, 7, 3}}], 
         {GrayLevel[0.6], Opacity[1], Polygon3DBox[{{4, 8, 11, 12, 7}}]}}]},
      AutomaticImageSize->True,
      Boxed->False,
      ImageSize->{179.79843676429215`, 219.79025109103964`},
      Lighting->"Neutral",
      ViewPoint->{0.045734015794639454`, 
       2.97511440285012, -1.6113977441193952`},
      ViewVertical->{-0.04058959569962287, 
       0.16059962272513575`, -0.9899588619926607}], 
     Graphics3DBox[
      {GrayLevel[0.8], Opacity[0.2], 
       GraphicsComplex3DBox[
        NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
          0, 0, 5 (50 - 10 5^Rational[1, 2])^
            Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
           0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
            Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
           Rational[-1, 2]}, {
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
            5^Rational[1, 2]), 
           Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
            5^Rational[1, 2]), Rational[
           1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
            5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
           Rational[-1, 2]}, {
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
            5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
           Rational[-1, 2]}, {
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
            5^Rational[1, 2]), 
           Rational[-1, 
             2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
            Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
            5^Rational[1, 2]), 
           Rational[
            1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
            Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
            5^Rational[1, 2]), 
           Rational[-1, 
             2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
            Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
          Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
            5^Rational[1, 2]), 
           Rational[
            1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
            Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
          0, 0, -0.9510565162951536}, {
          0, 0, 0.9510565162951536}, {-0.85065080835204, 
           0, -0.42532540417601994`}, {
          0.85065080835204, 0, 0.42532540417601994`}, {
          0.6881909602355868, -0.5, -0.42532540417601994`}, {
          0.6881909602355868, 
          0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
          0.42532540417601994`}, {-0.6881909602355868, 0.5, 
          0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
          0.8090169943749475, -0.42532540417601994`}, {
          0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
          0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], {
         Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 
          12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 
          10, 8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 9}, {
          6, 4, 5}, {10, 12, 6}, {3, 8, 10}, {9, 7, 3}}], 
         {GrayLevel[0.6], Opacity[1], Polygon3DBox[{{1, 4, 8}}]}}]},
      Boxed->False,
      Lighting->"Neutral"]}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.541097866383443*^9},
 TextAlignment->Center],

Cell["\<\
Los primeros forman un gran dodecaedro, los segundos un peque\[NTilde]o \
dodecaedro estrellado y los terceros un gran icosaedro.  \[FilledSmallSquare]\
\
\>", "Text",
 CellChangeTimes->{{3.5410918165012197`*^9, 3.541091816503529*^9}, {
  3.541097916303314*^9, 3.541097972382268*^9}}],

Cell["\<\
El hecho de que los n\[UAcute]cleos de los s\[OAcute]lidos de Kepler-Poinsot \
sean s\[OAcute]lidos plat\[OAcute]nicos se traduce en que los planos de las \
caras de todo s\[OAcute]lido de Kepler-Poinsot contienen a las caras de un s\
\[OAcute]lido plat\[OAcute]nico. Tambi\[EAcute]n se cumple el \
rec\[IAcute]proco:\
\>", "Text",
 CellChangeTimes->{{3.5410918166532383`*^9, 3.541091816655517*^9}, {
  3.541098068872899*^9, 3.5410980858555813`*^9}, {3.541098121041168*^9, 
  3.541098172136675*^9}}],

Cell[TextData[{
 StyleBox["Teorema 3.8",
  FontWeight->"Bold"],
 ": ",
 StyleBox["Los \[UAcute]nicos poliedros regulares cuyas caras est\[AAcute]n \
sobre las de un s\[OAcute]lido plat\[OAcute]nico son los propios \
s\[OAcute]lidos plat\[OAcute]nicos y los s\[OAcute]lidos de Kepler-Poinsot.",
  FontSlant->"Italic"]
}], "Text",
 CellMargins->{{12, 10}, {16, 16}},
 CellChangeTimes->{{3.541093926864724*^9, 3.5410939881113167`*^9}, {
   3.54109818746695*^9, 3.541098212857106*^9}, 3.5411787714414377`*^9}],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": En general, las caras de un poliedro son pol\[IAcute]gonos determinados \
por las intersecciones con un plano de los planos de las caras contiguas. Por \
lo tanto, ahora hemos de tomar cada s\[OAcute]lido plat\[OAcute]nico, \
prolongar el plano de una cara y estudiar las intersecciones con dicho plano \
de las prolongaciones de las dem\[AAcute]s caras, en busca de \
pol\[IAcute]gonos regulares. Si se forman pol\[IAcute]gonos regulares, habr\
\[AAcute] que ver si \[EAcute]stos se combinan para formar poliedros."
}], "Text",
 CellChangeTimes->{{3.541091816805254*^9, 3.541091816807616*^9}, {
  3.541098216928981*^9, 3.5410982272662086`*^9}, {3.5410982904540653`*^9, 
  3.5410984083714027`*^9}}],

Cell["\<\
Es obvio que, fijada una cara de un tetraedro, las otras tres caras la cortan \
entres rectas que forman un tri\[AAcute]ngulo: la propia cara del tetraedro, \
luego de un tetraedro s\[OAcute]lo obtenemos el propio tetraedro. Lo mismo \
sucede con el cubo, donde, fijada una cara, hay otra paralela que no la corta \
y otras cuatro que determinan la propia cara cuadrada del cubo.\
\>", "Text",
 CellChangeTimes->{{3.5410984091787*^9, 3.541098481635797*^9}}],

Cell["\<\
Consideremos ahora un octaedro:\
\>", "Text",
 CellChangeTimes->{{3.541091816957323*^9, 3.541091816959716*^9}, {
  3.5410998352985973`*^9, 3.5410998440057297`*^9}}],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0], 
   GraphicsComplex3DBox[
    NCache[{{0, 0, Rational[2, 3]^Rational[1, 2] + 
       Rational[-1, 2] 6^Rational[-1, 2]}, {
      Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], Rational[-1, 2] 
       6^Rational[-1, 2]}, {
      Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], Rational[-1, 2] 
       6^Rational[-1, 2]}, {
      3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}, {
      Rational[-1, 4] 3^Rational[-1, 2], Rational[-1, 4], 
       Rational[1, 2] (Rational[2, 3]^Rational[1, 2] - 6^Rational[-1, 2])}, {
      Rational[-1, 4] 3^Rational[-1, 2], Rational[1, 4], 
       Rational[1, 2] (Rational[2, 3]^Rational[1, 2] - 6^Rational[-1, 2])}, {
      Rational[1, 2] 3^Rational[-1, 2], 0, 
       Rational[1, 2] (Rational[2, 3]^Rational[1, 2] - 6^Rational[-1, 2])}, {
      Rational[-1, 2] 3^Rational[-1, 2], 0, Rational[-1, 2] 
       6^Rational[-1, 2]}, {
      Rational[1, 4] 3^Rational[-1, 2], Rational[-1, 4], Rational[-1, 2] 
       6^Rational[-1, 2]}, {
      Rational[1, 4] 3^Rational[-1, 2], Rational[1, 4], Rational[-1, 2] 
       6^Rational[-1, 2]}}, {{
      0, 0, 0.6123724356957945}, {-0.2886751345948129, -0.5, \
-0.20412414523193154`}, {-0.2886751345948129, 0.5, -0.20412414523193154`}, {
      0.5773502691896258, 
       0, -0.20412414523193154`}, {-0.14433756729740646`, -0.25, 
      0.20412414523193148`}, {-0.14433756729740646`, 0.25, 
      0.20412414523193148`}, {
      0.2886751345948129, 0, 0.20412414523193148`}, {-0.2886751345948129, 
       0, -0.20412414523193154`}, {
      0.14433756729740646`, -0.25, -0.20412414523193154`}, {
      0.14433756729740646`, 0.25, -0.20412414523193154`}}], {
     Line3DBox[{{2, 3, 4, 2, 1, 3, 1, 4}}], 
     {GrayLevel[0.6], Opacity[1], 
      Polygon3DBox[{{5, 6, 7}, {5, 8, 9}, {7, 9, 10}, {6, 8, 10}, {5, 6, 8}, {
       9, 10, 8}, {7, 6, 10}, {5, 7, 9}}]}}]},
  Boxed->False,
  ImageSize->{318.3400094229669, 348.},
  Lighting->"Neutral",
  ViewAngle->0.422316516018308,
  ViewCenter->{{0.5, 0.5, 0.5}, {0.5968619722708084, 0.508284263149019}},
  ViewPoint->{-2.6568989128440963`, 1.7926537446420967`, -1.0850256765388286`},
  ViewVertical->{-0.22722682731762067`, 
   0.17119033582435805`, -1.1823513726663828`}]], "Output",
 CellChangeTimes->{
  3.541099852360188*^9, 3.541103045090296*^9, {3.5411065114458857`*^9, 
   3.541106528959373*^9}},
 TextAlignment->Center],

Cell["\<\
Si nos fijamos en una de sus caras, vemos que hay otra paralela que no corta \
a su plano, tres caras contiguas que determinan en su plano el \
tri\[AAcute]ngulo correspondiente a la cara del octaedro, y los planos de las \
otras tres caras forman un tri\[AAcute]ngulo equil\[AAcute]tero que, \
combinado con tri\[AAcute]ngulos an\[AAcute]logos, forma un tetraedro. As\
\[IAcute] pues, del octaedro s\[OAcute]lo se obtiene el propio octaedro y el \
tetraedro.\
\>", "Text",
 CellChangeTimes->{{3.541091817117256*^9, 3.541091817119746*^9}, {
  3.5410999484530773`*^9, 3.54110003162848*^9}, {3.541100767974436*^9, 
  3.5411007715404377`*^9}}],

Cell["\<\
Consideramos ahora un dodecaedro y observamos que, fijada una cara, hay otra \
paralela que no proporciona ning\[UAcute]n corte, las cinco caras contiguas \
cortan al plano de la cara en las prolongaciones de sus lados, con lo que \
tenemos pent\[AAcute]gonos regulares que dan lugar al propio dodecaedro. Pero \
dichas prolongaciones de los lados forman tambi\[EAcute]n un pentagrama, y \
estos pentagramas constituyen las caras de un peque\[NTilde]o dodecaedro \
estrellado. (La justificaci\[OAcute]n de este hecho y de los hechos an\
\[AAcute]logos que indicaremos seguidamente se encuentra en la construcci\
\[OAcute]n del poliedro correspondiente, en este caso la del peque\[NTilde]o \
dodecaedro estrellado.)\
\>", "Text",
 CellChangeTimes->{{3.5410918172613573`*^9, 3.541091817263726*^9}, {
  3.5410985657653*^9, 3.541098565767473*^9}, {3.541103215200285*^9, 
  3.541103357207933*^9}, {3.541103601988068*^9, 3.5411036488751917`*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0.6], Opacity[1], 
    GraphicsComplex3DBox[
     NCache[{{Rational[
         1, 5] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
          Rational[1, 2] + (Rational[1, 4] + 
           Rational[1, 2] 5^Rational[-1, 2])^
          Rational[1, 2] + (Rational[5, 8] + 
           Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] + 
         Root[1 - 20 #^2 + 80 #^4& , 1, 0] + 
         Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
        Rational[1, 5] (Rational[-1, 2] + 
         Rational[1, 2] (-3 - 5^Rational[1, 2]) + 
         Rational[1, 2] (-1 - 5^Rational[1, 2])), 
        Rational[1, 5] (
         2 (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
         2 Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
       Rational[1, 5] (
         2 (Rational[1, 4] + Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2] + 
         Root[1 - 5 #^2 + 5 #^4& , 1, 0] + 
         2 Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
        Rational[1, 5] (Rational[1, 4] (-1 - 5^Rational[1, 2]) + 
         Rational[1, 4] (1 + 5^Rational[1, 2])), (Rational[5, 8] + 
         Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
       Rational[
         1, 5] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
          Rational[1, 2] + (Rational[1, 4] + 
           Rational[1, 2] 5^Rational[-1, 2])^
          Rational[1, 2] + (Rational[5, 8] + 
           Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2] + 
         Root[1 - 20 #^2 + 80 #^4& , 1, 0] + 
         Root[1 - 20 #^2 + 80 #^4& , 2, 0]), 
        Rational[1, 5] (Rational[1, 2] + 
         Rational[1, 2] (1 + 5^Rational[1, 2]) + 
         Rational[1, 2] (3 + 5^Rational[1, 2])), 
        Rational[1, 5] (
         2 (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
           Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
         2 Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
       Rational[
         1, 5] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
          Rational[1, 2] + (Rational[5, 8] + 
           Rational[11, 8] 5^Rational[-1, 2])^
          Rational[1, 2] + (1 + 2 5^Rational[-1, 2])^
          Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
          Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0]), 
        Rational[1, 5] (Rational[1, 2] (1 + 5^Rational[1, 2]) + 
         Rational[1, 4] (3 + 5^Rational[1, 2])), 
        Rational[1, 5] (2 Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
         2 Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
         Root[1 - 20 #^2 + 80 #^4& , 3, 0])}, {
       Rational[
         1, 5] ((Rational[1, 8] + Rational[1, 8] 5^Rational[-1, 2])^
          Rational[1, 2] + (Rational[5, 8] + 
           Rational[11, 8] 5^Rational[-1, 2])^
          Rational[1, 2] + (1 + 2 5^Rational[-1, 2])^
          Rational[1, 2] + (Rational[1, 10] (5 + 5^Rational[1, 2]))^
          Rational[1, 2] + Root[1 - 20 #^2 + 80 #^4& , 3, 0]), 
        Rational[1, 5] (Rational[1, 4] (-3 - 5^Rational[1, 2]) + 
         Rational[1, 2] (-1 - 5^Rational[1, 2])), 
        Rational[1, 5] (2 Root[1 - 100 #^2 + 80 #^4& , 1, 0] + 
         2 Root[1 - 20 #^2 + 80 #^4& , 2, 0] + 
         Root[1 - 20 #^2 + 80 #^4& , 3, 0])}}, {{
      0.3077683537175254, -0.947213595499958, 0.49797965697655605`}, {0., 0., 
      1.1135163644116066`}, {0.3077683537175254, 0.947213595499958, 
      0.49797965697655605`}, {0.8057480106940815, 
      0.5854101966249685, -0.49797965697655605`}, {
      0.8057480106940815, -0.5854101966249685, -0.49797965697655605`}}], 
     {GrayLevel[0], Line3DBox[{{1, 3, 5, 2, 4, 1, 5, 4, 3, 2, 1}}]}]}, 
   {GrayLevel[0.6], 
    GeometricTransformation3DBox[
     GraphicsComplex3DBox[
      NCache[{{-(1 + 2 5^Rational[-1, 2])^Rational[1, 2], 0, Root[
         1 - 20 #^2 + 80 #^4& , 3, 0]}, {(1 + 2 5^Rational[-1, 2])^
         Rational[1, 2], 0, Root[1 - 20 #^2 + 80 #^4& , 2, 0]}, {
        Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
         Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
         1 - 20 #^2 + 80 #^4& , 3, 0]}, {
        Root[1 - 20 #^2 + 80 #^4& , 1, 0], 
         Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
         1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
          Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
         1 - 20 #^2 + 80 #^4& , 3, 0]}, {(Rational[5, 8] + 
          Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
         1 - 20 #^2 + 80 #^4& , 3, 0]}, {
        Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
        Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[11, 8] 5^Rational[-1, 2])^Rational[1, 2]}, {
        Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], 
         Rational[-1, 2], Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
        Rational[-1, 2] (1 + 2 5^Rational[-1, 2])^Rational[1, 2], Rational[
         1, 2], Root[
         1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 4] + 
          Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], 
         Rational[-1, 2], (Rational[5, 8] + 
          Rational[11, 8] 5^Rational[-1, 2])^
         Rational[1, 2]}, {(Rational[1, 4] + 
          Rational[1, 2] 5^Rational[-1, 2])^Rational[1, 2], Rational[
         1, 2], (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
         Rational[1, 2]}, {(Rational[1, 10] (5 + 5^Rational[1, 2]))^
         Rational[1, 2], 0, Root[1 - 100 #^2 + 80 #^4& , 1, 0]}, {
        Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
         1 - 20 #^2 + 80 #^4& , 2, 0]}, {
        Root[1 - 100 #^2 + 80 #^4& , 1, 0], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
         1 - 20 #^2 + 80 #^4& , 2, 0]}, {
        Root[1 - 5 #^2 + 5 #^4& , 1, 0], 
         0, (Rational[5, 8] + Rational[11, 8] 5^Rational[-1, 2])^
         Rational[1, 2]}, {
        Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
         1 - 100 #^2 + 80 #^4& , 1, 0]}, {
        Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
         1 - 100 #^2 + 80 #^4& , 1, 0]}, {(Rational[1, 8] + 
          Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
         Rational[1, 4] (-3 - 5^Rational[1, 2]), Root[
         1 - 20 #^2 + 80 #^4& , 2, 0]}, {(Rational[1, 8] + 
          Rational[1, 8] 5^Rational[-1, 2])^Rational[1, 2], 
         Rational[1, 4] (3 + 5^Rational[1, 2]), Root[
         1 - 20 #^2 + 80 #^4& , 2, 0]}}, {{-1.3763819204711736`, 0, 
         0.2628655560595668}, {
        1.3763819204711736`, 
         0, -0.2628655560595668}, {-0.42532540417601994`, \
-1.3090169943749475`, 0.2628655560595668}, {-0.42532540417601994`, 
        1.3090169943749475`, 0.2628655560595668}, {
        1.1135163644116066`, -0.8090169943749475, 0.2628655560595668}, {
        1.1135163644116066`, 0.8090169943749475, 
        0.2628655560595668}, {-0.2628655560595668, -0.8090169943749475, 
        1.1135163644116066`}, {-0.2628655560595668, 0.8090169943749475, 
        1.1135163644116066`}, {-0.6881909602355868, -0.5, \
-1.1135163644116068`}, {-0.6881909602355868, 0.5, -1.1135163644116068`}, {
        0.6881909602355868, -0.5, 1.1135163644116066`}, {0.6881909602355868, 
        0.5, 1.1135163644116066`}, {
        0.85065080835204, 
         0, -1.1135163644116068`}, {-1.1135163644116068`, \
-0.8090169943749475, -0.2628655560595668}, {-1.1135163644116068`, 
        0.8090169943749475, -0.2628655560595668}, {-0.85065080835204, 0, 
         1.1135163644116066`}, {
        0.2628655560595668, -0.8090169943749475, -1.1135163644116068`}, {
        0.2628655560595668, 0.8090169943749475, -1.1135163644116068`}, {
        0.42532540417601994`, -1.3090169943749475`, -0.2628655560595668}, {
        0.42532540417601994`, 1.3090169943749475`, -0.2628655560595668}}], 
      Polygon3DBox[{{15, 10, 9, 14, 1}, {2, 6, 12, 11, 5}, {5, 11, 7, 3, 
       19}, {11, 12, 8, 16, 7}, {12, 6, 20, 4, 8}, {6, 2, 13, 18, 20}, {2, 5, 
       19, 17, 13}, {4, 20, 18, 10, 15}, {18, 13, 17, 9, 10}, {17, 19, 3, 14, 
       9}, {3, 7, 16, 1, 14}, {16, 8, 4, 15, 1}}]], 
     NCache[{{{((10 + 2 5^Rational[1, 2])/(50 + 10 5^Rational[1, 2]))^
         Rational[1, 2], 0, 0}, {
        0, ((10 + 2 5^Rational[1, 2])/(50 + 10 5^Rational[1, 2]))^
         Rational[1, 2], 0}, {
        0, 0, ((10 + 2 5^Rational[1, 2])/(50 + 10 5^Rational[1, 2]))^
         Rational[1, 2]}}, 
       Center}, {{{0.4472135954999579, 0, 0}, {0, 0.4472135954999579, 0}, {
        0, 0, 0.4472135954999579}}, Center}]]}},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{397.6452485828659, 380.9355992341261},
  Lighting->"Neutral",
  ViewCenter->{{0.5, 0.5, 0.5}, {0.5154779451440332, 0.4791602635634835}},
  ViewPoint->{2.296364535821119, -1.1984938216069747`, -2.177228164017948},
  ViewVertical->{1.311516239836083, -0.07635374695546793, 
   0.1895386939260301}]], "Output",
 CellChangeTimes->{3.541103157679823*^9},
 TextAlignment->Center],

Cell["\<\
Por otra parte, las cinco caras no contiguas a la cara fijada forman otro \
pent\[AAcute]gono regular, y estos pent\[AAcute]gonos regulares forman un \
gran dodecaedro. Ahora bien, tambi\[EAcute]n podemos prolongar los lados de \
este pent\[AAcute]gono mayor y formar otro pentagrama (que no aparece en la \
figura), y estos pentagramas mayores forman un gran dodecaedro estrellado. No \
hay m\[AAcute]s posibilidades.\
\>", "Text",
 CellChangeTimes->{{3.541098565876114*^9, 3.541098565878631*^9}, {
  3.5411033837921667`*^9, 3.5411035006415453`*^9}, {3.541103548846859*^9, 
  3.54110355734628*^9}}],

Cell["\<\
El caso del icosaedro se visualiza f\[AAcute]cilmente con la figura \
siguiente, que hemos usado para estudiar el gran icosaedro:\
\>", "Text",
 CellChangeTimes->{{3.541098566092082*^9, 3.541098566094558*^9}, {
  3.541103881094656*^9, 3.5411040237588367`*^9}, {3.541104083856525*^9, 
  3.54110415018476*^9}, {3.541104528310328*^9, 3.5411045384357862`*^9}, {
  3.541104723999731*^9, 3.541104747918223*^9}}],

Cell[BoxData[
 GraphicsBox[{
   GraphicsComplexBox[
    NCache[{{Rational[-1, 2] - GoldenRatio, Rational[1, 2] 
       3^Rational[1, 2] (1 + 2 GoldenRatio)}, {
      Rational[1, 2] + GoldenRatio, Rational[1, 2] 
       3^Rational[1, 2] (1 + 2 GoldenRatio)}, {0, 0}, {
      Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2] (1 + 2 GoldenRatio)}, {
      Rational[1, 2], Rational[1, 2] 3^Rational[1, 2] (1 + 2 GoldenRatio)}, {
      Rational[1, 2] GoldenRatio, Rational[1, 2] 3^Rational[1, 2] 
       GoldenRatio}, {
      Rational[-1, 2] GoldenRatio, Rational[1, 2] 3^Rational[1, 2] 
       GoldenRatio}, {
      Rational[1, 2] (1 + GoldenRatio), Rational[1, 2] 
       3^Rational[1, 2] (1 + GoldenRatio)}, {
      Rational[1, 2] (-1 - GoldenRatio), Rational[1, 2] 
       3^Rational[1, 2] (1 + GoldenRatio)}}, {{-2.118033988749895, 
      3.6685424806725857`}, {2.118033988749895, 3.6685424806725857`}, {0, 
      0}, {-0.5, 3.6685424806725857`}, {0.5, 3.6685424806725857`}, {
      0.8090169943749475, 1.4012585384440734`}, {-0.8090169943749475, 
      1.4012585384440734`}, {1.3090169943749475`, 
      2.267283942228512}, {-1.3090169943749475`, 2.267283942228512}}], 
    LineBox[{{1, 2, 3, 1}, {4, 6}, {5, 7}, {8, 9}, {2, 9}, {2, 7}, {1, 6}, {1,
       8}, {3, 4}, {5, 3}, {4, 8}, {5, 9}, {7, 8}, {5, 6}, {6, 9}, {7, 4}}]], 
   InsetBox[
    StyleBox["\<\"C\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {2.2, 3.8}], InsetBox[
    StyleBox["\<\"B\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {-2.2, 3.8}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(A\\), \\(1\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {-0.5, 3.8}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(A\\), \\(2\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {0.5, 3.8}], InsetBox[
    StyleBox["\<\"A\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {0, -0.1}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(B\\), \\(1\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {1.4, 2.25}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(C\\), \\(2\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {-1.4, 2.25}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(B\\), \\(2\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {0.95, 1.4}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SubscriptBox[\\(C\\), \\(1\\)]\\)\"\>",
     StripOnInput->False,
     FontFamily->"Times",
     FontSize->14], {-0.95, 1.4}]}]], "Output",
 CellChangeTimes->{{3.5411045752862864`*^9, 3.541104646876709*^9}, 
   3.5411046780663767`*^9, 3.54110594345684*^9},
 TextAlignment->Center],

Cell["\<\
Fijada una cara de un icosaedro (el tri\[AAcute]ngulo central de la figura), \
hay una cara paralela que no induce ning\[UAcute]n corte, y la figura muestra \
los cortes de las 18 caras restantes. Los \[UAcute]nicos pol\[IAcute]gonos \
regulares son:\
\>", "Text",
 CellChangeTimes->{{3.541098566228063*^9, 3.541098566230422*^9}, {
  3.541104752280292*^9, 3.5411047878464937`*^9}, {3.541104839987979*^9, 
  3.541104887425955*^9}, {3.5411051941493177`*^9, 3.541105277572535*^9}, {
  3.541105311495838*^9, 3.541105325469095*^9}, {3.5411055397775297`*^9, 
  3.541105539878275*^9}, {3.541106369235589*^9, 3.541106446400625*^9}, {
  3.54110656786856*^9, 3.5411066032265873`*^9}, {3.5411066524984007`*^9, 
  3.541106653650086*^9}}],

Cell[TextData[{
 "a)  El tri\[AAcute]ngulo exterior ",
 StyleBox["ABC,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " que da lugar a un gran icosaedro,"
}], "Text",
 CellChangeTimes->{{3.541098566228063*^9, 3.541098566230422*^9}, {
  3.541104752280292*^9, 3.5411047878464937`*^9}, {3.541104839987979*^9, 
  3.541104887425955*^9}, {3.5411051941493177`*^9, 3.541105277572535*^9}, {
  3.541105311495838*^9, 3.541105325469095*^9}, {3.5411055397775297`*^9, 
  3.541105539878275*^9}, {3.541106369235589*^9, 3.541106446400625*^9}, {
  3.54110656786856*^9, 3.5411066032265873`*^9}, {3.5411066524984007`*^9, 
  3.541106662586259*^9}}],

Cell[TextData[{
 "b) Dos tri\[AAcute]ngulos ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times",
     FontSize->18], "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["B",
     FontFamily->"Times",
     FontSize->18], "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["C",
     FontFamily->"Times",
     FontSize->18], "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "y ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["A",
     FontFamily->"Times",
     FontSize->18], "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["B",
     FontFamily->"Times",
     FontSize->18], "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["C",
     FontFamily->"Times",
     FontSize->18], "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", que generan un tetraedro, como puede verse en la primera figura de la \
secci\[OAcute]n correspondiente al gran dodecaedro estrellado mostrando las \
caras ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["c",
     FontFamily->"Times",
     FontSize->18], "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["c",
     FontFamily->"Times",
     FontSize->18], "8"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["c",
     FontFamily->"Times",
     FontSize->18], "13"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["c",
     FontFamily->"Times",
     FontSize->18], "19"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", "
}], "Text",
 CellChangeTimes->{{3.541098566228063*^9, 3.541098566230422*^9}, {
  3.541104752280292*^9, 3.5411047878464937`*^9}, {3.541104839987979*^9, 
  3.541104887425955*^9}, {3.5411051941493177`*^9, 3.541105277572535*^9}, {
  3.541105311495838*^9, 3.541105325469095*^9}, {3.5411055397775297`*^9, 
  3.541105539878275*^9}, {3.541106369235589*^9, 3.541106446400625*^9}, {
  3.54110656786856*^9, 3.5411066032265873`*^9}, {3.5411066524984007`*^9, 
  3.5411066690822353`*^9}, {3.541106973690102*^9, 3.541106973831305*^9}}],

Cell["\<\
c) Otros dos tri\[AAcute]ngulos menores, que resultan de unir los puntos \
medios de los lados de los anteriores, y que dan lugar a octaedros, \
concretamente a los octaedros que contienen los tetraedros del caso b) tal y \
como indica la primera figura de esta demostraci\[OAcute]n,\
\>", "Text",
 CellChangeTimes->{{3.541106669834405*^9, 3.541106670186172*^9}, {
  3.541106706386777*^9, 3.541106807223225*^9}, {3.5411069768711777`*^9, 
  3.5411069771189213`*^9}}],

Cell["\<\
d) El tri\[AAcute]ngulo interior, que no es sino la cara de icosaedro de \
partida. No hay m\[AAcute]s posibilidades.  \[FilledSquare]\
\>", "Text",
 CellChangeTimes->{{3.54110680803583*^9, 3.541106841282691*^9}}],

Cell["\<\
Cauchy demostr\[OAcute] el teorema siguiente a partir del teorema 3.8 y \
Bertrand a partir del teorema 3.7. Vamos a exponer las dos demostraciones. \
\>", "Text",
 CellMargins->{{12, 10}, {3, 16}},
 CellChangeTimes->{{3.541098566228063*^9, 3.541098566230422*^9}, {
  3.541104752280292*^9, 3.5411047878464937`*^9}, {3.541104839987979*^9, 
  3.541104887425955*^9}, {3.5411051941493177`*^9, 3.541105277572535*^9}, {
  3.541105311495838*^9, 3.541105325469095*^9}, {3.5411055397775297`*^9, 
  3.541105539878275*^9}, {3.541106369235589*^9, 3.541106393968444*^9}, {
  3.541107043657881*^9, 3.541107046638419*^9}, {3.541107205248723*^9, 
  3.541107228456752*^9}, {3.541112301470089*^9, 3.5411125056241913`*^9}, {
  3.541144657507285*^9, 3.541144678071781*^9}, {3.5411787859184837`*^9, 
  3.541178788294189*^9}}],

Cell[TextData[{
 StyleBox["Teorema 3.9 (Cauchy-Bertrand)",
  FontWeight->"Bold"],
 ": ",
 StyleBox["Los \[UAcute]nicos poliedros regulares son los s\[OAcute]lidos \
plat\[OAcute]nicos y los s\[OAcute]lidos de Kepler-Poinsot.",
  FontSlant->"Italic"]
}], "Text",
 CellMargins->{{12, 10}, {16, 16}},
 CellChangeTimes->{{3.541093926864724*^9, 3.5410939881113167`*^9}, {
  3.54109818746695*^9, 3.541098212857106*^9}, {3.541107088434844*^9, 
  3.54110711839966*^9}, {3.5411071708018103`*^9, 3.541107184313016*^9}, {
  3.5411123125350027`*^9, 3.541112330006627*^9}, {3.541144689035808*^9, 
  3.541144691071948*^9}, {3.5411787982556887`*^9, 3.541178811516523*^9}}],

Cell[TextData[{
 StyleBox["Demostraci\[OAcute]n",
  FontVariations->{"Underline"->True}],
 ": Sea ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " un poliedro regular (que podemos suponer no convexo). La prueba de Cauchy \
se basa en que todas las caras de un poliedro regular est\[AAcute]n a una \
misma distancia no nula de su centro, luego \[EAcute]stas limitan un n\
\[UAcute]cleo convexo en su interior al que llamaremos ",
 StyleBox["N",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". De este modo, ",
 StyleBox["N",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un poliedro convexo tal que las caras de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " son prolongaciones de las caras de ",
 StyleBox["N",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". Si demostramos que ",
 StyleBox["N",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un s\[OAcute]lido plat\[OAcute]nico, el teorema 3.8 implicar\[AAcute] \
que ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es un s\[OAcute]lido de Kepler-Poinsot."
}], "Text",
 CellChangeTimes->{{3.54114469646313*^9, 3.541144696465152*^9}, {
  3.5411470710641117`*^9, 3.541147146046238*^9}, {3.541147197270775*^9, 
  3.5411472619917097`*^9}, {3.5411473765078497`*^9, 3.541147426752282*^9}, {
  3.541178944148385*^9, 3.541178969242174*^9}}],

Cell[TextData[{
 "Puesto que las simetr\[IAcute]as de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " transforman ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " en el mismo poliedro, es obvio que tambi\[EAcute]n dejan invariante a ",
 StyleBox["N,",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " (puesto que ",
 StyleBox["N",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] determinado por ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 "), es decir, toda simetr\[IAcute]a de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es una simetr\[IAcute]a de ",
 StyleBox["N",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ". Cada cara de ",
 StyleBox["N",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " est\[AAcute] contenida en una cara de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 ", luego una simetr\[IAcute]a de ",
 StyleBox["P",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " que transforme una cara en otra, hace corresponder tambi\[EAcute]n las \
caras de ",
 StyleBox["N",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " contenidas en ellas. Esto implica que ",
 StyleBox["N",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " es transitivo para caras, luego en particular todas sus caras son iguales. \
Ahora usamos un teorema que demostraremos en la secci\[OAcute]n siguiente \
(teorema 4.3): todo poliedro convexo debe tener al menos una cara triangular, \
cuadrangular o pentagonal. Como ",
 StyleBox["N",
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"],
 " tiene todas sus caras iguale