// Programa de calculo de raices por diversos metodos
#include <cmath>
#include <iomanip>
#include <iostream>
using namespace std;
//prec:tolerancia en el calculo en la raiz
// fprec:valor maximo de la funcion en el valor aceptado para la raiz
// numiter:numero maximo de iteraciones
const double    prec = 1.e-8, fprec = 1.e-8;
const int       nprec = 10, nwidth = 16;
const int       numiter = 100;
const char     *tab = "\t";
//f: funcion, fd: derivada.
double          f(double x);
double          fd(double x);
int             biseccion(double, double);
int             biseccion2(double, double);
int             secante(double, double);
int             regulafalsi(double, double);
int             newton(double);
int             muller(double, double);
//Definicion de la funcion y derivadas
double f(double x)
{
    //funcion
  return pow(x,5) - pow(x,4) - 5*pow(x,3) + 5*pow(x,2) + 6*x - 6;
}

double fd(double x)
{
    //primera derivada
  return 5*pow(x,4) - 4*pow(x,3) - 15*pow(x,2) + 10*x + 6;
}

int main()
{
    /* Programa para comparar diversos mtodos de calculo de raices */
    //Poner los puntos de horquillado;
    //x0, x1 puntos de partida
    double          x0 = -2.,  x1 = -1.5;
    //Descomentar los metodos que se deseen utilizar
     biseccion(x0, x1);
     biseccion2(x0, x1);
     secante(x0, x1);
     regulafalsi(x0, x1);
     newton(x1);
     muller(x0,x1);
     return 0;
}
int biseccion(double x0, double x1)
{
    double          f(double x);
    cout << "    Metodo Biseccion" << endl;
    cout.precision(nprec);
    cout << " iteracion" << "             x  " << "  f(x)  " << endl;
    int             n = 1;
    double          x2, f0, f1, f2;
    f0 = f(x0);
    f1 = f(x1);
    f2=f1;

    if (f0 * f1 >= 0) {
        cout << " no hay raiz entre x0 y x1" << endl;
        return 0;
    }
    while (abs(x0 - x1) >= prec) {
        if (n >= numiter) {
            cout << " numero maximo de iteraciones excedido en biseccion"
              << endl;
            return 1;
        }
        x2 = (x0 + x1) / 2;
        f2 = f(x2);
        cout << setw(10) << n << "   " << setw(10) << x2 << "  "
          << f2 << endl;
        if (f2 * f0 < 0) {
            x1 = x2;
            f1 = f2;
        }
        if (f2 * f1 < 0) {
            x0 = x2;
            f0 = f2;
        }
        if(f2==0){
        break;
        n++;
	  }
        n++;
    }
    cout << "biseccion     " << n - 1 << "  iteraciones   " << "raiz= "
        << setprecision(nprec) << setw(nwidth) << x2 <<
         " funcion= " << f2 << endl<<endl<<endl;
    return 0;
}

int biseccion2(double x0, double x1)
{
    double          f(double x);
    int             n = 1;
    double          f0 = f(x0), f1 = f(x1), x2 = x1, f2;
    cout << "    Metodo Biseccion 2" << endl;

    if (f0 * f1 >= 0) {
        cout << " no hay raiz entre x0 y x1" << endl;
        return 0;
    }
    while (abs(x0 - x1) >= prec || abs(0.5 * (f0 + f1)) >= fprec) {
        if(n>=numiter) {
	    cout<<"numero maximo de iteraciones excedido en biseccion 2"<<endl;
            return 1;
        }
        x2 = (x0 + x1) / 2;
        f2 = f(x2);
        if (f2 * f1 < 0) {
            x0 = x2;
            f0 = f2;
        }
        if (f2 * f0 < 0) {
            x1 = x2;
            f1 = f2;
        }
	if(f2==0){
        break;
        n++;
	}
        n++;
    }

    cout << "biseccion 2    " << n - 1 << "  iteraciones   "
	 << "raiz= " << x2 << " funcion= " << f2 << endl<<endl<<endl;
    return 0;
}

int regulafalsi(double x0, double x1)
{
    double          f(double x);
    int             n = 1;
    double          x2 = 0,  x2old=1;
    cout << "    Metodo Regula Falsi" << endl;
    cout.precision(nprec);
    cout << " iteracion" << "             x  " << "  f(x)  " << endl;
    double f0=f(x0), f1=f(x1), f2=1.;
    if (f0 * f1 >= 0) {
        cout << " no hay raiz entre x0 y x1" << endl;
        return 0;
    }
    while ((abs(f2) >= fprec)||(abs(x2-x2old)>prec)) {
        if (n >= numiter) {
            cout << " numero maximo de iteraciones excedido en regulafalsi" << endl;
            return 1;
        }
        x2old=x2;
        x2 = x1 - f1 * (x1 - x0) / (f1 - f0);
        f2=f(x2);
        cout << setw(10) << n << "   " << setw(10) << x2 <<
             "  " << f2 << endl;
        if (f2 * f0 < 0){
            x1 = x2;
            f1=f2;
	}
        if (f2 * f1 < 0){
	    f0=f2;
            x0 = x2;
	}
        if (f2==0){
        break;
        n++;
        }
        n++;
    }
    cout << "regulafalsi   " << n - 1 << "  iteraciones   "
          << "raiz= " << x2 <<
        " funcion= " << f2 << endl<<endl<<endl;
    return 0;
}

int secante(double x0, double x1)
{
    double          f(double x);
    cout << "    Metodo secante" << endl;
    cout.precision(nprec);
    cout << "   x0= " << x0 << " x1= " << x1 << endl;
    cout << " iteracion" << "             x  " << "  f(x)  " << endl;
    int             n = 1;
    double          x2 = 0;
    double f0=f(x0), f1=f(x1), f2=1;
    while ((abs(f2) >= fprec)||abs(x2-x1)>=prec) {
        if(n>=numiter) {
	    cout<<"numero maximo de iteraciones excedido en secante"<<endl;
            return 1;
        }
        x2 = x1 - f1 * (x1 - x0) / (f1 - f0);
        f2=f(x2);
        cout << setw(10) << n << "   " << setw(10) << x2 << "  " 
          << f2 << endl;
        x0 = x1;
        x1 = x2;
        f0=f1;
        f1=f2;
        n++;
    }
    cout << "secante       " << n - 1 << "  iteraciones   " 
      << "raiz= " << x2 << " funcion= " << f2 << endl<<endl<<endl;
    return 0;
}

int newton(double x1)
{
    int             n = 0;
    double          x2 = x1+10;
    double          f1 = f(x1);
    cout << "    Metodo de Newton" << endl;
    cout.precision(nprec);
    cout << " iteracion" << "             x  " << "  f(x)  " << endl;
    cout << setw(10) << 0 << "   " << setw(10) << x1 <<
         "  " << f1 << endl;
    while ((abs(f1) >= fprec)||abs(x2-x1)>=prec) {
      if(n>=numiter) {
	cout<<"numero maximo de iteraciones excedido en newton"<<endl;
        return 1;
        }
        x2 = x1 - f1 / fd(x1);
        x1 = x2;
        f1 = f(x1);
        cout << setw(10) << n+1 << "   " << setw(10) <<
             x1 << "  " << f1 << endl;
        n++;
    }
    cout << "newton        " << n  << "  iteraciones   " <<
      "raiz= " << x1 << " funcion= " << f1 << endl<<endl<<endl;
    return 0;
}


int muller(double x0, double x1)
{
    double          f(double x);
    cout << "    Metodo Muller" << endl;
    cout.precision(nprec);
    cout << " iteracion" << "             x  " << "  f(x)  " << endl;

    int             n = 1;
    double          x2 = 0, x3 = 0;
    double          f0 = f(x0), f1 = f(x1), f2 = f1, a, b, c, d, h;
    if (f0*f1>0){
      cout<<"No hay raiz en [x0,x1]"<<endl;
      return 1;
    }
    x2 = x1 - f1 * (x1 - x0) / (f1 - f0);
    f2 = f(x2);
    cout << setw(10) << n << "   " << setw(10) << x2 <<
        "  " << f2 << endl;
    while ((abs(f2) >= fprec)||abs(x2-x1)>=prec) {
        if (n >= numiter) {
            cout << " numero maximo de iteraciones excedido en muller" << endl;
            return 2;
        }
        a = (x1 - x0) * f2 + (x0 - x2) * f1 + (x2 - x1) * f0;
        a = a / ((x2 - x1) * (x1 - x0) * (x1 - x0));
        b = (x1 - x0) * (2 * x2 - x1 - x0) * f2
         - (x2 - x0) * (x2 - x0) * f1 + (x2 - x1) * (x2 - x1) * f0;
        b = b / ((x2 - x1) * (x1 - x0) * (x1 - x0));
        c = (x2 - x0) * f2 / (x1 - x0);
        d = sqrt(b * b - 4 * a * c);
        if (b > 0)
            h = -2 * c / (b + d);
        else
            h = -2 * c / (b - d);
        x3 = x2 + h;
        x0 = x1;
        f0 = f1;
        x1 = x2;
        f1 = f2;
        x2 = x3;
        f2 = f(x2);
        cout << setw(10) << n+1 << "   " << setw(10) << x2 
            << "  " << f2 << endl;
        n++;
    }
    cout << "muller       " << n  << "  iteraciones   " <<
            "raiz= " << x2 << " funcion= " << f2 << endl<<endl<<endl;
    return 0;
}
