#include <cmath>
#include <iostream>
#include <iomanip>
#include <vector>
typedef double Real;
using namespace std;
typedef Real(*func) (Real);

template < class T > inline T derval(func F, T x, T h, int ord)
{
//Devuelve el valor de la derivada de F de orden ord
    switch (ord) {
        case 1:
            return (F(x + h) - F(x - h)) / (2 * h);
            break;
        case 2:
            return (F(x + h) - 2. * F(x) + F(x - h)) / (h * h);
            break;
        case 3:
            return (F(x + 2. * h) - 2. * F(x + h) + 2. * F(x - h) - F(x - 2. * h)) / (2. * h * h * h);
            break;
        case 4:
            return (F(x + 2. * h) - 4 * F(x + h) + 6 * F(x) - 4 * F(x - h) + F(x - 2. * h)) / (h * h * h * h);
            break;
        default:
            cout << "orden de la derivada = " << ord << "  invalido" << endl;
    }
}


template < class T > vector < T > deriv(func F, T x, T h, T eps, int nprec, int ord)
{
    if (nprec == 0)
        nprec = 6;
    vector < T > der;
    int k = 1;
    int n = 1;

//Derivada.Primera fila;
    T   deri = derval(F, x, h, ord);
    int nwidth = nprec + int (log10(deri)) + 4;

    der.push_back(deri);
    T   delta = 1;

    cout <<  " h = " <<  setprecision(nprec) << h << "  Derivada  orden " << ord << setw(nwidth) << setprecision(nprec)<< " =  "  << deri << endl << endl;
    while (delta > eps) {
        h = h / 2;
//Calculo de la derivada con h / 2
        deri = derval(F, x, h, ord);
        cout << " h = "  << h << "  Derivada orden  " << ord << setw(nwidth)
            << setprecision(nprec) << " =  " << deri << endl;
//Relleno de la fila n + 1
        der.push_back(deri);
        int index = n * (n + 1) / 2;

        for (int i = 0; i < n; i++) {
            deri = (pow(4., i + 1) * der[index + i] - der[index + i - n]) / (pow(4., i + 1) - 1);
            der.push_back(deri);
        }
        cout << endl;
        delta = abs(deri - der[index - 1]);
//cout << "delta= " << delta << endl;
        if (n > 10) {
            cout << "maximo numero de iteraciones" << endl;
            break;
        }
        n++;
    }

//impresion del triangulo de Richardson
    int nn = der.size();
    int nk = 1;
    int index = 0;

    while (nn > 0) {
        for (int j = index; j < index + nk; j++)
            cout << setw(nwidth) << setprecision(nprec)
                << der[j] << " ";
        cout << endl;
        index += nk;
        nk++;
        nn -= nk;
    }
    return der;
}


template < class T > inline T f(T x)
{
    return exp(x);
}


int
main()
{
//precision de resultados
    int mm = 18;

//LLamada a deriv
    Real eps = 1.e-7;
    Real x = 1.;
    Real h = 0.2;

    vector < Real > der = deriv < Real > (f < Real >, x, h, eps, mm, 1);
    int n = der.size();

//Impresion de resultados
    cout << " Derivada = " << der[n - 1] << endl;
    cout << "Valor exacto = " << exp(1.) << endl;

    cout << endl << endl << endl;

    der = deriv < Real > (f < Real >, x, h, eps, mm, 2);
    n = der.size();
//Impresion de resultados
    cout << " Derivada = " << der[n - 1] << endl;
    cout << "Valor exacto = " << exp(1.) << endl;

    cout << endl << endl << endl;

    der = deriv < Real > (f < Real >, x, h, eps, mm, 3);
    n = der.size();
//Impresion de resultados
    cout << " Derivada = " << der[n - 1] << endl;
    cout << "Valor exacto = " << exp(1.) << endl;

    cout << endl << endl << endl;

    der = deriv < Real > (f < Real >, x, h, eps, mm, 4);
    n = der.size();
//Impresion de resultados
    cout << " Derivada = " << der[n - 1] << endl;
    cout << "Valor exacto = " << exp(1.) << endl;

    return 0;
}
