#include <iostream>
#include <iomanip>
#include <cmath>
#include <vector>
using namespace std;

//Programa de integracion en 3 d recursivo;
// Siguiendo el metodo de Numerical Recipes


typedef double Real;
typedef Real(*func) (Real);

//permite definir la precision del programa
static Real xmax;
//variable global xmin = -xmax

// Real y1(const Real), y2(const Real) :curvas superiores e inferiores
// Real z1(const Real, const Real): superficie inferior
// Real z2(const Real, const Real): superficie superior
Real xglob, yglob;

//variables globales
Real z1(const Real x, const Real y)
{
    return -sqrt(xmax * xmax - x * x - y * y);
}


Real
z2(const Real x, const Real y)
{
    return sqrt(xmax * xmax - x * x - y * y);
}


Real
y1(const Real x)
{
    return -sqrt(xmax * xmax - x * x);
}


Real
y2(const Real x)
{
    return sqrt(xmax * xmax - x * x);
}


Real
fun(const Real x, const Real y, const Real z)
{
    return x * x + y * y + z * z;
//funcin a integrar
}


//Regla de integracion 1 d; tiene como argumento una funcion de 1 variable
Real gausslegendre(Real func1(const Real), const Real a, const Real b)
{
//Metodo gaussiano.Es mas eficiente
    static const Real x[] = {
        0.1488743389816312, 0.4333953941292472, 0.6794095682990244,
        0.8650633666889845, 0.9739065285171717
    };
    static const Real w[] = {
        0.2955242247147529, 0.2692667193099963, 0.2190863625159821,
        0.1494513491505806, 0.0666713443086881
    };
    int j;
    Real xr, xm, dx, s;

    xm = 0.5 * (b + a);
    xr = 0.5 * (b - a);
    s = 0;
    for (j = 0; j < 5; j++) {
        dx = xr * x[j];
        s += w[j] * (func1(xm + dx) + func1(xm - dx));
    }
    return s *= xr;
}


Real simpson(Real func1(const Real), const Real a, const Real b)
{

//Simpson 2 N intervalos
    int N = 10;
    Real h = (b - a) / (2 * N);
    Real xm, s;

//Las raices cuadrados no definidas si x < 0. Resrar e - 15 en bordes
    s = func1(a + 1.e-15) + 4. * func1(b - h) + func1(b - 1.e-15);
    xm = a + h;
    for (int j = 1; j < N; j++) {
        s += (4 * func1(xm) + 2 * func1(xm + h));
        xm += 2 * h;
    }
//cout << a << " " << b << "  " << s << "  " << h << endl;
    return s *= h / 3;
}


template < class T > T romberg(Real F(const Real), T a, T b, T eps, int nprec)
{
    if (nprec == 0)
        nprec = 6;
    vector < T > romb;
    int k = 1;
    int n = 1;
    T   h = (b - a);
    T   S = (F(a + 1.e-15) + F(b - 1.e-15));
    T   trap = S * h / 2;
    int nwidth = nprec + int (log10(trap)) + 4;

//regla trapezoidal de dos puntos.Primera fila;
    romb.push_back(trap);
    T   delta = 10.;

    while (delta > eps) {
        h = h / 2;
//Calculo de la regla trapezoidal con el doble de intervalos
// utilizando T_2N = (T_N + M_N) / 2
        T sum = T(0);

//Calculo de M_N
        for (int j = 0; j < k; j++) {
            sum = sum + 2 * F(a + (2 * j + 1) * h);
        }
        S = (S + sum);
        trap = S * h / 2;
        k *= 2;

//Relleno de la fila n + 1
        romb.push_back(trap);
        int index = n * (n + 1) / 2;

        for (int i = 0; i < n; i++) {
            trap = (pow(4., i + 1) * romb[index + i] - romb[index + i - n]) / (pow(4., i + 1) - 1);
            romb.push_back(trap);
        }
        delta = abs(trap - romb[index - 1]);
        n++;
    }

    return trap;
}


Real integ1d(Real func1(const Real), const Real a, const Real b)
{
    Real eps = 1.e-7;

//return gausslegendre(func1, a, b);
//permite seleccionar el metodo deseado en 1 d
    return romberg < Real > (func1, a, b, eps, 10);
//return simpson(func1, a, b);
}


//Llamada recursiva integ3d->f1->f2->f3->func
Real f3(const Real z)
{
    return fun(xglob, yglob, z);
}


Real
f2(const Real y)
{
    yglob = y;
    return integ1d(f3, z1(xglob, y), z2(xglob, y));
}


Real
f1(const Real x)
{
    xglob = x;
    return integ1d(f2, y1(x), y2(x));
}


Real integ3d(Real fun(const Real, const Real, const Real), const Real x1,
const Real x2)
{
    return integ1d(f1, x1, x2);
}


//fin ciclo recursivo

int
main(void)
{
    const int nradio = 10;

//numero de radios para calcular V
    const Real PI = 3.141592653589793238;
    Real xmin, s;

    cout << "Integral de r**2 en volumen esfera" << endl << endl;
    cout << setw(11) << "radio" << setw(13) << "INTEG3D";
    cout << setw(12) << "exacto" << endl << endl;
    cout << fixed << setprecision(6);
    for (int i = 0; i < nradio; i++) {
        xmax = 0.1 * (i + 1);
        xmin = -xmax;
        s = integ3d(fun, xmin, xmax);
        cout << setw(12) << xmax << setw(13) << s;
        cout << setw(12) << 4.0 * PI * pow(xmax, Real(5.0)) / 5.0 << endl;
    }
    return 0;
}
