#include <cmath>
#include <iostream>
#include <iomanip>
#include <vector>
typedef double Real;
using namespace std;
typedef Real(*func) (Real);

template < class T > vector < T > romberg(func F, T a, T b, T eps, int nprec)
{
    if (nprec == 0)
        nprec = 6;
    vector < T > romb;
    int k = 1;
    int n = 1;
    T   h = (b - a);
    T   S = (F(a) + F(b));
    T   trap = S * h / 2;
    int nwidth = nprec + int (log10(trap)) + 4;

//regla trapezoidal de dos puntos.Primera fila;
    romb.push_back(trap);
    T   delta = 10.;

    cout << "Trapezoidal  " << k << " subintervalos=" << setw(nwidth)
        << setprecision(nprec) << trap << endl;
    while (delta > eps) {
        h = h / 2;
//Calculo de la regla trapezoidal con el doble de intervalos
// utilizando T_2N = (T_N + M_N) / 2
        T sum = T(0);
//Calculo de M_N
        for (int j = 0; j < k; j++) {
            sum = sum + 2 * F(a + (2 * j + 1) * h);
        }
        S = (S + sum);
        trap = S * h / 2;
        k *= 2;
        cout << "Trapezoidal  " << k << " subintervalos=" << setw(nwidth)
            << setprecision(nprec) << trap << endl;
//Relleno de la fila n + 1
        romb.push_back(trap);
        int index = n * (n + 1) / 2;

        for (int i = 0; i < n; i++) {
            trap = (pow(4., i + 1) * romb[index + i] - romb[index + i - n]) / (pow(4., i + 1) - 1);
            romb.push_back(trap);
        }
        cout << endl;
        delta = abs(trap - romb[index - 1]);
//cout << "delta= " << delta << endl;
        n++;
    }

//impresion del triangulo de Romberg
    int nn = romb.size();
    int nk = 1;
    int index = 0;

    while (nn > 0) {
        for (int j = index; j < index + nk; j++)
            cout << setw(nwidth) << setprecision(nprec)
                << romb[j] << " ";
        cout << endl;
        index += nk;
        nk++;
        nn -= nk;
    }
    return romb;
}


template < class T > inline T f(T x)
{
    return exp(x);
}


int
main()
{
//precision de resultados
    int mm = 18;

//LLamada a Romberg
    vector < Real > romb = romberg < Real > (f < Real >, 0, 1, 1.e-13, mm);
    int n = romb.size();

//Impresion de resultados
    cout << " Integral por Romberg = " << romb[n - 1] << endl;
    cout << " Estima del error = "<<abs(romb[n-1]-romb[n-2])<<endl;
    cout << "Valor exacto = " << exp(1.) - 1. << endl;
    return 0;
}
