#include <cmath>
#include <iostream>
#include <iomanip>
#include <vector>
typedef double Real;
using namespace std;
typedef Real(*func) (Real);

template < class T > inline T f(T x)
{
//Definir aqui la funcion a integrar
    return exp(x);
}


Real
simpson(func F, Real a, Real b, int n)
{
//Para obtener n subintervalos h = (b - a) / n
    Real h = (b - a) / n;
    Real Suma = (F(a) + F(b));
    int N = n / 2;

    for (int j = 0; j < N - 1; j++) {
        Suma = Suma + 4 * F(a + (2 * j + 1) * h) + 2 * F(a + (2 * j + 2) * h);
    }
    Suma = Suma + 4 * F(a + (2 * N - 1) * h);
    Real Integral = Suma * h / 3;

    cout << "Simpson  " << n << " subintervalos= " << setw(20) <<
        setprecision(18) << Integral << endl;
    return Integral;
}


int
main()
{
//precision de resultados(eps) y numero de cifras impresas(mm)
    int ncifras = 18;
    int nintervalos = 200;

    cout << "Entrar numero subintrervalos" << endl;
    cin >> nintervalos;
    if (2 * (nintervalos / 2) != nintervalos) {
        cout << "Error. El numero se subintervalos debe ser par" << endl;
        cout << "Entrar numero subintrervalos" << endl;
        cin >> nintervalos;
    }
//Limites inferior y superior
    Real a = 0;
    Real b = 1.;

//LLamada a Simpson
    Real Simpson = simpson(f, a, b, nintervalos);
//Impresion de resultados
    Real integral = exp(1.) - 1.;
    cout << " Integral regla Simpson = " << Simpson << endl;
    cout << "Valor exacto = " << integral << endl;
    cout << " Error  = " << abs(integral - Simpson) << endl;
    return 0;
}
