#include <cmath>
#include <iostream>
#include <iomanip>
#include <vector>
typedef double Real;
using namespace std;
typedef Real(*func) (Real);

template < class T > vector < T > simpson(func F, T a, T b, T eps, int nprec)
{
    if (nprec == 0)
        nprec = 6;
    vector < T > simp;
    int k = 1;
    int n = 1;
    T   h = (b - a);
    T   S = (F(a) + F(b));
    T   trap = S * h / 2;
    int nwidth = nprec + int (log10(trap)) + 4;

//regla trapezoidal de dos puntos.Primera fila;
    T   delta = 1.;
    T   oldtrap = trap;
    T   simpson, oldsimpson = T(0);

    while (delta > eps) {
        h = h / 2;
//Calculo de la regla trapezoidal con el doble de intervalos
// utilizando T_2N = (T_N + M_N) / 2
        T sum = T(0);
//Calculo de M_N
        for (int j = 0; j < k; j++) {
            sum = sum + 2 * F(a + (2 * j + 1) * h);
        }
//trap regla trapezoidal con 2 N subintervalos
        S = S + sum;
        trap = S * h / 2;
        k *= 2;
//cout << "Trapezoidal  " << k << " subintervalos=" << setw(nwidth)
// <<setprecision(nprec) << trap << endl;
//Calculo de Simpson como S_2N = (4 T_2N - T_N) / 3
        simpson = (4 * trap - oldtrap) / 3;
        cout << "Simpson  " << k << " subintervalos=" << setw(nwidth)
            << setprecision(nprec) << simpson << endl;
        delta = abs(simpson - oldsimpson);
        oldsimpson = simpson;
        oldtrap = trap;
        simp.push_back(simpson);
        n++;
    }

    return simp;
}


template < class T > inline T f(T x)
{
//Definir aqui la funcion a integrar
    return exp(x);
}


int
main()
{
//precision de resultados(eps) y numero de cifras impresas(mm)
    int ncifras = 18;
    Real eps = 1.e-12;

//Limites inferior y superior
    Real a = 0;
    Real b = 1.;

//LLamada a Simpson
// vsimpson vector con las sucesivas iteraciones de Simpson
    vector < Real > vsimpson = simpson < Real > (f < Real >, a, b, eps, ncifras);
    int n = vsimpson.size();

//Impresion de resultados
    Real integral = exp(1) - 1;
    cout << " Integral regla Simpson = " << vsimpson[n - 1] << endl;
    cout << pow(2., n) << " subintervalos; " << n << " iteraciones" << endl;
    cout << " Error  estimado= " << abs(vsimpson[n - 1] - vsimpson[n - 2]) << endl;
    cout << "Valor exacto = " << integral << endl;
    cout << " Error real = " << abs(integral - vsimpson[n - 1]) << endl;
    return 0;
}
