#include <cmath>
#include <iostream>
#include <iomanip>
#include <vector>
typedef double Real;
using namespace std;
typedef Real(*func) (Real);

template < class T > inline T f(T x)
{
//Definir aqui la funcion a integrar
    return exp(x);
}


double
trap(func F, Real a, Real b, int n)
{
    Real h = (b - a) / n;
    Real S = (F(a) + F(b));

    for (int j = 1; j < n; j++) {
        S = S + 2 * F(a + j * h);
    }
    Real Integral = S * h / 2;

    cout << "Trapezoidal  " << n << " subintervalos=" << setw(20)
        << setprecision(18) << Integral << endl;

    return Integral;
}


int
main()
{
    int nintervalos = 200;

    cout << "Entrar numero subintervalos" << endl;
    cin >> nintervalos;

//Limites inferior y superior
    Real a = 0;
    Real b = 1.;

//LLamada a trap
    Real trapezoidal = trap(f, a, b, nintervalos);
//Impresion de resultados
    Real integral = exp(1.) - 1.;
    cout << " Integral regla trapezoidal = " << trapezoidal << endl;
    cout << "Valor exacto = " << integral << endl;
    cout << " Error  = " << abs(integral - trapezoidal) << endl;
    return 0;
}
