#include <cmath>
#include <iostream>
#include <iomanip>
#include <vector>
typedef double Real;
using namespace std;
typedef Real(*func) (Real);

template < class T > vector < T > trapezoidal(func F, T a, T b, T eps, int nprec)
{
    if (nprec == 0)
        nprec = 6;
    vector < T > trapz;
    int k = 1;
    int n = 1;
    T   h = (b - a);
    T   S = (F(a) + F(b));
    T   trap = S * h / 2;
    int nwidth = nprec + int (log10(trap)) + 4;

//regla trapezoidal de dos puntos.Primera fila;
    trapz.push_back(trap);
    T   delta = 1.;
    T   oldtrap = trap;

    cout << "Trapezoidal  " << k << " subintervalos=" << setw(nwidth)
        << setprecision(nprec) << trap << endl;
    while (delta > eps) {
        h = h / 2;
//Calculo de la regla trapezoidal con el doble de intervalos
// utilizando T_2N = (T_N + M_N) / 2
        T sum = T(0);
//Calculo de M_N
        for (int j = 0; j < k; j++) {
            sum = sum + 2 * F(a + (2 * j + 1) * h);
        }
        S = (S + sum);
        trap = S * h / 2;
        k *= 2;
        cout << "Trapezoidal  " << k << " subintervalos=" << setw(nwidth)
            << setprecision(nprec) << trap << endl;
        delta = abs(trap - oldtrap);
        oldtrap = trap;
        trapz.push_back(trap);
        n++;
    }

    return trapz;
}


template < class T > inline T f(T x)
{
    return exp(x);
}


int
main()
{
//precision de resultados
    int mm = 18;

//LLamada a Trapezoidal
    Real a = 0., b = 1.;;
    Real eps = 1.e-13;

    vector < Real > trap = trapezoidal < Real > (f < Real >, a, b, eps, mm);
    int n = trap.size();

//Impresion de resultados
    Real integral = exp(1.) - 1.;
    cout << " Integral regla Trapezoidal = " << trap[n - 1] << endl;
    cout << pow(2., n) << " subintervalos; " << n << " iteraciones" << endl;
    cout << " Error  estimado= " << abs(trap[n - 1] - trap[n - 2]) << endl;
    cout << "Valor exacto = " << integral << endl;
    cout << " Error real = " << abs(integral - trap[n - 1]) << endl;
    return 0;
}
