//Programa de ajuste por  serie trigonometrica
//Compilar con
// g++ -I. -I./templates -o fourier fourier.cpp chi2.cpp gnuplot_i_calnum.cc
//ejecutar fourier<fourier.d
#include "gnuplot_i_calnum.h"
#define SLEEP_LGTH 10
#include <iostream>
#include <cmath>
#include <iomanip>
#include <fstream>
#include "templates.h"
#include "chi2.h"



using namespace std;
typedef  double Real;
Real const pi=4*atan(1.);

//Calculo de las funciones trigonometricas en el conjunto de puntos

template<class T> 
Vector<Vector<T> > fourier(const Vector<T>&  x, const Vector<T>& y,const Vector<T>& sigma,  const int& m)
{
//Devuelve m vectores de dimension n que contienen los valores
// de los m funciones trigonometricas   sobre n puntos
//Pares cosenos, impares senos


int n=x.size();
 int odd =n-2*(n/2);
 
 
 int nfun=m; //numero funciones calculadas. Impar salvo m=n
 if((odd==0)&&(m<n)) nfun=m;
 if((odd==0)&&(m==n)) nfun=m;
 Vector<Vector<T> > trig(nfun, Vector<T>(n)); 
//trig  vector de vectores conteniendo funciones trigonometricas en puntos datos
trig[0]=Vector<T>(n,T(1.));
 cout<<trig[0]<<endl;
 cout<<trig[0]*trig[0]<<endl;

 Vector<T> vtemp(n),vtemp2(n); //temporales cos y sin


 for(int i=1; i<nfun ; i=i+2) {
  int k=(i+1)/2;
 for(int j=0;j<n;j++) {  
  vtemp(j+1)=cos(2*pi*j*k/n);
  vtemp2(j+1)=sin(2*pi*j*k/n); }
  trig[i]=Vector<T> (vtemp);
  if(i+1<nfun) trig[i+1]=Vector<T> (vtemp2);

   }
 if((odd==0)&&(m==n)){
for(int j=0;j<n;j++) vtemp(j+1)=cos(pi*j);
 trig[m]=Vector<T> (vtemp);}

return trig;
}


int  main(){

//Fichero de datos "F.d"
//ifstream fin("F.d");
int n;
int m;

//Leer numero de funciones  m (numero de parametros) 
cin>>m;
 int nfun=m; 
 
 cout<<nfun << " funciones"<<endl;
 int odd = nfun - 2*(nfun/2);
 cout<< "odd= "<<odd<<endl;

//Declaracion de vector de coeficientes, de covarianzas y vector
// de terminos independientes
Vector<Real>  a(nfun);


//Definir vectores de puntos y de errores
Vector<Real> x;
Vector<Real> y;
Vector<Real> sigma;

//Leer puntos
 cin>>x>>y>>sigma;
 n=x.size();
 cout<<n<<endl;
 Real Period=abs(x[n-1]-x[0])*Real(n)/(n-1); //Periodo acaba despues x[n-1]
 
 for (int i= 0; i<n; i++) if(sigma[i]==0) sigma[i]=1.;

// Verificar  que la lectura es correcta 
cout<<"Puntos experimentales"<<endl<<"     x    "<<"       y     "<<
 "      sigma  " <<endl;
for (int j=0;j<n; j++)
    cout<<setw(10)<<x[j]<<"   "<<setw(10)<<y[j]<<"   "<<setw(10)<<
    sigma[j]<<"   "<<endl;  
cout <<endl;

//si sigma=0. ponemos sigma=1. Puntos sin error. Minimos cuadrados.
for (int i= 0; i<n; i++) if(sigma[i]==0) sigma[i]=1.;

//Creamos un vector de vectores para almacenar cada una de las funciones
Vector<Vector<Real> > ftrigonom(m,Vector<Real>(n));
 ftrigonom=fourier<Real>(x,y,sigma,m);

 /* 
//Comprobacion de ortogonalidad
 for (int i=0; i<nfun;i++) {
   for (int j=0;j<=i;j++) cout<<"  "<<i<<"  "<<j<<"  "
<<ftrigonom[i]*ftrigonom[j];
   cout<<endl;
   }
 */   

//Calcular vector de  coeficientes a[i]

for(int i=0;i<nfun;i++){
   
    a[i]=2./n*ftrigonom[i]*y; 
    } 
    

// Imprimir   coeficientes 
cout<<"Vector de coeficientes"<<endl<<a<<endl;

// Calculo de los errores de los parametros

//Calculo funcion en puntos datos

Vector<Real> fun(n,Real(0));
 fun=a[0]/2*ftrigonom[0];
 int nfun1=2*(nfun/2); //nfun1=nfun nfun par

   for (int i=1;i<nfun-1;i++) fun+=a[i]*ftrigonom[i];
   if(nfun1<nfun)
   fun += a[nfun-1]*ftrigonom[nfun-1];
   else if((nfun1 == nfun)&&(nfun<n)) fun += a[nfun-1]*ftrigonom[nfun-1];
   else if((nfun1 == nfun)&&(nfun==n)) fun += a[nfun-1]/2*ftrigonom[nfun-1];

cout<<"Puntos ajustados="<< fun<<endl;

//Calculo de chi2
Real chi2=normsq((fun -y)/sigma);
Real nu=n-m;
Real chi2nu=chi2/nu;
Real chi2p = Chi2P(chi2,nu);
cout<<"chi2= "<<chi2<<"  chi2/nu=  "<<chi2nu<<" Prob(chi2/nu)= "<<chi2p<<endl;
// cout<<"odd="<<odd<<endl;


//Dibujo puntos con su error y funcion ajustada
 int ndib=n*10;
 double deltax=Period/(ndib-1);
 Vector<Real> xx(ndib),yy(ndib);
 for(int i=0;i<ndib;i++)
   xx[i]=x[0]+i*deltax;

 for(int i=0;i<ndib;i++){
   yy[i]=a[0]/2;
  
 if(odd == 1) {
   for(int j=1;j<nfun-1;j=j+2){
   int  k=(j+1)/2;
     yy[i]=yy[i] + a[j]*cos(2*pi*k*(xx[i]-xx[0])/Period) +
                  a[j+1]*sin(2*pi*k*(xx[i]-xx[0])/Period);}
   }
   else if(odd == 0){ 
   for(int j=1;j<nfun-1;j=j+2){
   int  k=(j+1)/2;
     yy[i]=yy[i]+a[j]*cos(2*pi*k*(xx[i]-xx[0])/Period)+
           a[j+1]*sin(2*pi*k*(xx[i]-xx[0])/Period);
      }
   
if (nfun<n) {
     int k=nfun/2;
    yy[i]=yy[i]+a[nfun-1]*cos(2*pi*k*(xx[i]-xx[0])/Period);
    }
     
   else if (nfun==n) yy[i]=yy[i]+a[nfun-1]/2.*cos(pi*n*(xx[i]-xx[0])/Period);
   }
 }
 

Gnuplot g1 = Gnuplot();
    g1.set_style("points");
    g1.plot_xy(x,y,"datos");
    g1.plot_xy(x,fun,"fourier discreta");
    g1.set_style("lines");
    g1.plot_xy(xx,yy,"fourier discreta ");

   sleep(100);

return 0;
}  
