// Lotka-Volterra- Program to compute the trajectories of the Lotka-Volterra
// equations using the adaptive Runge-Kutta method.
//Compilar con g++ -I.  rk4.cpp rka.cpp  lotkark.cpp Lotka-Volterra.cpp -o lotka
#include "NumMeth.h"
using namespace std;

void lotkark(double x[], double t, double param[], double deriv[]);
void rka( double x[], int nX, double t, double tau, double err,
  void (*derivsRK)(double x[], double t, double param[], double deriv[]), 
  double param[]);         
         
int main() {

  //* Set initial state x,y,z and parameters a, b, c, d, e 
  cout << "Enter initial state (x,y)" << endl;
  double x; cout << "x = "; cin >> x;
  double y; cout << "y = "; cin >> y;
  const int nState = 3;       // Number of elements in state
  double state[nState+1];
  state[1] = x;  state[2] = y;  
  double a= 10;  
  double b = 1.e-5;   // Parameter b
  double c = 0.1;     // Parameter c
  double d = 10;  
  double e = 0.1;   // Parameter e
  

  double param[5+1];      // Vector of parameters passed to rka
  param[1] = a;  param[2] = b; param[3] = c; param[4] = d; param[5] = e;
  double tau = 1.0;     // Initial guess for the timestep
  double err = 1.e-3;   // Error tolerance

  //* Loop over the desired number of steps
  double time = 0;
  cout << "Enter number of steps: ";
  int iStep, nStep;  cin >> nStep;
  double *tplot, *tauplot, *xplot, *yplot, *zplot;   
  tplot = new double [nStep+1];  tauplot = new double [nStep+1];
  xplot = new double [nStep+1];  // Plotting variables
  yplot = new double [nStep+1];  
  for( iStep=1; iStep<=nStep; iStep++ ) {
  
    //* Record values for plotting
    x = state[1]; y = state[2]; 
    tplot[iStep] = time;  tauplot[iStep] = tau;       
    xplot[iStep] = x;  yplot[iStep] = y; 
    if( (iStep % 50) < 1 )
     cout << "Finished " << iStep << " steps out of "
          << nStep << endl;

    //* Find new state using adaptive Runge-Kutta
    rka(state,nState,time,tau,err,lotkark,param);
  }

  //* Print max and min time step returned by rka
  double maxTau = tauplot[2], minTau = tauplot[2];
  int i;
  for( i=3; i<=nStep; i++ ) {
    maxTau = (maxTau > tauplot[i]) ? maxTau:tauplot[i];
    minTau = (minTau < tauplot[i]) ? minTau:tauplot[i];
  }
  cout << "Adaptive time step: Max = " << maxTau << 
                            "  Min = " << minTau << endl;
  
  // Find the location of the three steady states
  double x_ss[3+1], y_ss[3+1];
  x_ss[1] = 0;              y_ss[1] = 0;       
  x_ss[2] = d/e;  y_ss[2] = a/c-b*d/(c*e);
  
  //* Print out the plotting variables: 
  //    tplot, xplot, yplot,  x_ss, y_ss
  ofstream tplotOut("tplot.txt"), xplotOut("xplot.txt"), 
	       yplotOut("yplot.txt"), 
           p_ssOut("p_ss.txt"),  
            totalplot("lotka_plot.txt");
  for( i=1; i<=nStep; i++ ) {
    tplotOut << tplot[i] << endl;
    xplotOut << xplot[i] << endl;
    yplotOut << yplot[i] << endl;
    totalplot << tplot[i]<<"  "<< 
        xplot[i] <<"  "<< yplot[i]<<"  "<< endl;
  }
  for( i=1; i<=2; i++ ) {
    p_ssOut << x_ss[i] <<"  " << y_ss[i] << endl;
  }

  delete [] tplot, tauplot, xplot, yplot; // Release memory

}
