#include "NumMeth.h"
using namespace std;
void lotkark(double X[], double t, double param[], double deriv[]) {
//  Returns right-hand side of Lorenz model ODEs
//  Inputs
//    X      State vector [x y]
//    t      Time (not used)
//    param  Parameters [a b c d e ]
//  Output
//    deriv  Derivatives [dx/dt dy/dt ]

  //* For clarity, unravel input vectors
  double x = X[1]; double y = X[2];
  double a = param[1]; double b = param[2]; double c = param[3];
  double d = param[4]; double e = param[5];

  //* Return the derivatives [dx/dt dy/dt]
  deriv[1] = (a-b*x-c*y)*x;
  deriv[2] = (-d+e*x)*y;
  return;
}
