#include <cmath>
using namespace std;
void rkck(double  y[], const double dydx[], const int   nX,  const double  t,
	const double h, double  yerr[],
	  void derivs(double [] , double,  const double  [],
 double []),const double  []) ;     
void rkqs(double y[], const int n, double dydx[], double x, 
const double htry,
	const double eps, double yscal[], double hdid, double hnext,
	  void derivs(double[], const double, double[], double[]), double param[])
{
	const double SAFETY=0.9, PGROW=-0.2, PSHRNK=-0.25, ERRCON=1.89e-4;
	double errmax,h,htemp,xnew;
	h=htry;
	double yerr[n],ytemp[n];
	for (;;) {
	  rkck(y,dydx,n,x,h,yerr,derivs,param);
		errmax=0.0;
		for (int i=1;i<=n;i++) errmax=MAX(errmax,fabs(yerr[i]/yscal[i]));
		errmax /= eps;
		if (errmax <= 1.0) break;
		htemp=SAFETY*h*pow(errmax,PSHRNK);
		h=(h >= 0.0 ? MAX(htemp,0.1*h) : MIN(htemp,0.1*h));
		xnew=x+h;
		if (xnew == x) nrerror("stepsize underflow in rkqs");
	}
	if (errmax > ERRCON) hnext=SAFETY*h*pow(errmax,PGROW);
	else hnext=5.0*h;
	x += (hdid=h);
	for (int i=1;i<=n;i++) y[i]=ytemp[i];
}
