/*
 * Decompiled with CFR 0.152.
 */
package jmadem;

import jason.asSyntax.Atom;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Term;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jmadem.Allocation;
import jmadem.Cuf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionData {
    private static int id_generator = 1;
    private int id = id_generator;
    private Vector<Atom> agents;
    private Vector<Allocation> allocations;
    private Vector<Atom> utilityFunctions;
    private ConcurrentMap<Atom, Float> utilityWeights;
    private ConcurrentMap<Atom, Float> personalWeights;
    private Cuf welfare;
    private ConcurrentMap<Atom, Vector<Float>> utilityValues;

    DecisionData(Vector<Atom> ags, Vector<Allocation> allocs, Vector<Atom> uFuncs, ConcurrentMap<Atom, Float> pW, ConcurrentMap<Atom, Float> uW, Cuf sw) {
        id_generator = id_generator == Integer.MAX_VALUE ? 1 : ++id_generator;
        this.agents = ags;
        this.allocations = allocs;
        this.utilityFunctions = uFuncs;
        this.personalWeights = new ConcurrentHashMap<Atom, Float>();
        for (Map.Entry element : pW.entrySet()) {
            this.personalWeights.put((Atom)((Atom)element.getKey()).clone(), new Float(((Float)element.getValue()).floatValue()));
        }
        this.utilityWeights = new ConcurrentHashMap<Atom, Float>();
        for (Map.Entry element : uW.entrySet()) {
            this.utilityWeights.put((Atom)((Atom)element.getKey()).clone(), new Float(((Float)element.getValue()).floatValue()));
        }
        this.welfare = sw;
        this.utilityValues = new ConcurrentHashMap<Atom, Vector<Float>>();
    }

    public int getId() {
        return this.id;
    }

    public void addBid(String bidder, List<Term> uValues) {
        Vector<Float> uV = new Vector<Float>();
        Iterator<Term> it = uValues.iterator();
        while (it.hasNext()) {
            uV.add(new Float(((NumberTermImpl)it.next()).solve()));
        }
        this.utilityValues.put(new Atom(bidder), uV);
    }

    public boolean areAllBidsReceived() {
        return this.agents.size() == this.utilityValues.size();
    }

    public Vector<Atom> getAgents() {
        return this.agents;
    }

    public ConcurrentMap<Atom, Float> getPersonalWeights() {
        return this.personalWeights;
    }

    public Vector<Allocation> getAllocations() {
        return this.allocations;
    }

    public Vector<Atom> getUtilityFunctions() {
        return this.utilityFunctions;
    }

    public ConcurrentMap<Atom, Float> getUtilityWeights() {
        return this.utilityWeights;
    }

    public Cuf getWelfare() {
        return this.welfare;
    }

    public ConcurrentMap<Atom, Vector<Float>> getUtilityValues() {
        return this.utilityValues;
    }
}

