/*
 * Decompiled with CFR 0.152.
 */
package jmadem;

import jason.JasonException;
import jason.architecture.AgArch;
import jason.asSemantics.Message;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Atom;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Literal;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Term;
import jason.mas2j.ClassParameters;
import jason.runtime.Settings;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import jmadem.Allocation;
import jmadem.Cuf;
import jmadem.DecisionData;
import jmadem.UtilityFunctionException;
import jmadem.UtilityFunctionInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MADeMAgArch
extends AgArch {
    private Logger logger = Logger.getLogger(MADeMAgArch.class.getName());
    private String agName;
    private ConcurrentMap<Atom, UtilityFunctionInt> utilityFunctions = new ConcurrentHashMap<Atom, UtilityFunctionInt>();
    private ConcurrentMap<Atom, Float> utilityWeights = new ConcurrentHashMap<Atom, Float>();
    private ConcurrentMap<Atom, Float> personalWeights = new ConcurrentHashMap<Atom, Float>();
    private Cuf welfare;
    private int tout;
    private ConcurrentMap<Integer, DecisionData> mademData = new ConcurrentHashMap<Integer, DecisionData>();

    public void initAg(String agClass, ClassParameters bbPars, String asSrc, Settings stts) throws JasonException {
        super.initAg(agClass, bbPars, asSrc, stts);
        this.agName = this.getAgName();
        this.logger = Logger.getLogger(String.valueOf(MADeMAgArch.class.getName()) + "." + this.agName);
        this.welfare = Cuf.ELITIST;
        this.tout = 10000;
    }

    public boolean addUtilityFunction(String uFuncName) {
        UtilityFunctionInt u = null;
        try {
            u = (UtilityFunctionInt)Class.forName(uFuncName).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (this.utilityFunctions.put(new Atom(u.getId()), u) != null) {
            this.logger.info("Utility function \"" + u.getId() + "\" has been updated.");
        } else {
            this.logger.fine("Utility function \"" + u.getId() + "\" has been registered.");
        }
        return true;
    }

    public boolean removeUtilityFunction(String uFuncName) {
        return this.utilityFunctions.remove(new Atom(uFuncName)) == null;
    }

    public Set<Atom> getUtilityFunctionNames() {
        return this.utilityFunctions.keySet();
    }

    public int startMADeMDecision(ListTermImpl ags, ListTermImpl allocs, ListTermImpl uFuncs) {
        return this.startMADeMDecision(ags, allocs, uFuncs, this.personalWeights, this.utilityWeights, this.welfare, this.tout);
    }

    public int startMADeMDecision(ListTermImpl ags, ListTermImpl allocs, ListTermImpl uFuncs, ConcurrentMap<Atom, Float> pW, ConcurrentMap<Atom, Float> uW, Cuf sw, int tout) {
        Vector<Atom> v_ags = new Vector<Atom>();
        Vector<Allocation> v_allocs = new Vector<Allocation>();
        Vector<Atom> v_uFuncs = new Vector<Atom>();
        Iterator it = ags.getAsList().iterator();
        while (it.hasNext()) {
            v_ags.add((Atom)it.next());
        }
        it = allocs.iterator();
        while (it.hasNext()) {
            v_allocs.add(new Allocation((ListTermImpl)it.next()));
        }
        it = uFuncs.iterator();
        while (it.hasNext()) {
            v_uFuncs.add((Atom)it.next());
        }
        DecisionData decision = new DecisionData(v_ags, v_allocs, v_uFuncs, pW, uW, sw);
        this.mademData.put(new Integer(decision.getId()), decision);
        Literal auction = ASSyntax.createLiteral((String)"madem_auction", (Term[])new Term[0]);
        auction.addTerm((Term)new NumberTermImpl((double)decision.getId()));
        auction.addTerm((Term)allocs);
        auction.addTerm((Term)uFuncs);
        this.logger.fine("Auction message: " + auction);
        Message msg = new Message("tell", this.agName, this.agName, (Object)auction);
        int i = 0;
        while (i < v_ags.size()) {
            if (v_ags.get(i).toString().equals(this.agName)) {
                this.logger.fine("Obtaining personal preferences for " + auction);
                this.bid(this.agName, auction);
            } else {
                msg.setReceiver(v_ags.get(i).toString());
                try {
                    this.sendMsg(msg);
                }
                catch (Exception e) {
                    this.logger.severe("Error sending message \"" + msg + "\" while starting MADeM.");
                    e.printStackTrace();
                    this.mademData.remove(new Integer(decision.getId()));
                    return -1;
                }
                this.logger.fine("Auctioned message sent to " + v_ags.get(i));
            }
            ++i;
        }
        if (v_ags.size() != 0) {
            Timer timer = new Timer();
            timer.schedule((TimerTask)new BidTimeout(decision.getId()), tout);
        } else {
            this.winnerDeterminationProblem(decision.getId());
        }
        return decision.getId();
    }

    public void checkMail() {
        super.checkMail();
        Iterator i = this.getTS().getC().getMailBox().iterator();
        while (i.hasNext()) {
            Message m = (Message)i.next();
            Object body = m.getPropCont();
            if (body instanceof Literal && ((Literal)body).getFunctor().equals("madem_auction")) {
                i.remove();
                this.bid(m.getSender(), (Literal)body);
            }
            if (!(body instanceof Literal) || !((Literal)body).getFunctor().equals("madem_bid")) continue;
            i.remove();
            this.processBid(m.getSender(), (Literal)body);
        }
    }

    public boolean setTimeout(int new_tout) {
        if (new_tout > 0) {
            this.tout = new_tout;
            return true;
        }
        return false;
    }

    public int getTimeout() {
        return this.tout;
    }

    public void setWelfare(Cuf new_sw) {
        this.welfare = new_sw;
    }

    public String getWelfare() {
        return this.welfare.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPersonalWeights(ConcurrentMap<Atom, Float> new_pw) {
        ConcurrentMap<Atom, Float> concurrentMap = this.personalWeights;
        synchronized (concurrentMap) {
            this.personalWeights.putAll(new_pw);
        }
        return true;
    }

    public ConcurrentMap<Atom, Float> getPersonalWeights() {
        return this.personalWeights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setUtilityWeights(ConcurrentMap<Atom, Float> new_uw) {
        ConcurrentMap<Atom, Float> concurrentMap = this.utilityWeights;
        synchronized (concurrentMap) {
            this.utilityWeights.putAll(new_uw);
        }
        return true;
    }

    public ConcurrentMap<Atom, Float> getUtilityWeights() {
        return this.utilityWeights;
    }

    public void bid(String auctioneer, Literal madem_auction) {
        float utilityValue = 0.0f;
        Literal bidResult = ASSyntax.createLiteral((String)"madem_bid", (Term[])new Term[0]);
        bidResult.addTerm(madem_auction.getTerm(0));
        List allocs = ((ListTermImpl)madem_auction.getTerm(1)).getAsList();
        ListTermImpl uFuncs = (ListTermImpl)madem_auction.getTerm(2);
        ListTermImpl uValues = new ListTermImpl();
        int i = 0;
        while (i < allocs.size()) {
            Allocation alloc = new Allocation((ListTermImpl)allocs.get(i));
            Iterator it_uFuncs = uFuncs.iterator();
            while (it_uFuncs.hasNext()) {
                utilityValue = this.getUtility(auctioneer, alloc, (Atom)it_uFuncs.next());
                uValues.add((Term)new NumberTermImpl((double)utilityValue));
            }
            ++i;
        }
        bidResult.addTerm((Term)uValues);
        if (this.agName.equals(auctioneer)) {
            this.processBid(this.agName, bidResult);
        } else {
            Message msg = new Message("tell", this.agName, auctioneer, (Object)bidResult);
            try {
                this.sendMsg(msg);
            }
            catch (Exception e) {
                this.logger.severe("Error sending message \"" + msg + "\" while bidding.");
                e.printStackTrace();
            }
        }
    }

    public void processBid(String bidder, Literal madem_bid) {
        int id_decision = (int)((NumberTermImpl)madem_bid.getTerm(0)).solve();
        DecisionData decisionData = (DecisionData)this.mademData.get(new Integer(id_decision));
        if (decisionData != null) {
            decisionData.addBid(bidder, ((ListTermImpl)madem_bid.getTerm(1)).getAsList());
            if (decisionData.areAllBidsReceived()) {
                this.winnerDeterminationProblem(id_decision);
            }
        }
    }

    public float getUtility(String auctioneer, Allocation allocation, Atom uFunc) {
        float utility = 0.0f;
        UtilityFunctionInt utilityFunction = (UtilityFunctionInt)this.utilityFunctions.get(uFunc);
        if (utilityFunction != null) {
            try {
                utility = utilityFunction.computeUtility(auctioneer, allocation, this);
            }
            catch (UtilityFunctionException e) {
                this.logger.warning("Error computing utility function for the allocation \"" + (Object)((Object)allocation) + "\".");
                e.printStackTrace();
            }
        } else {
            this.logger.warning("Utility function \"" + uFunc + "\" can not be computed. It seems not to be registered.");
        }
        return utility;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void winnerDeterminationProblem(int id_decision) {
        float socialWelfare;
        int i;
        Float w;
        Vector uValues = new Vector();
        DecisionData decision = null;
        ConcurrentMap<Integer, DecisionData> concurrentMap = this.mademData;
        synchronized (concurrentMap) {
            decision = (DecisionData)this.mademData.remove(id_decision);
        }
        if (decision == null) {
            return;
        }
        this.logger.severe("Starting Winner Determination Problem.");
        Vector<Atom> agents = decision.getAgents();
        ConcurrentHashMap personalWeights = (ConcurrentHashMap)decision.getPersonalWeights();
        Vector<Allocation> allocs = decision.getAllocations();
        Vector<Atom> uFuncs = decision.getUtilityFunctions();
        ConcurrentHashMap utilityWeights = (ConcurrentHashMap)decision.getUtilityWeights();
        ConcurrentHashMap utilityValues = (ConcurrentHashMap)decision.getUtilityValues();
        Cuf welfare = decision.getWelfare();
        this.logger.fine("Agents: " + agents);
        this.logger.fine("Personal Weights: " + personalWeights);
        this.logger.fine("Allocations: " + allocs);
        this.logger.fine("Utility Functions: " + uFuncs);
        this.logger.fine("Utility Weights: " + utilityWeights);
        this.logger.fine("Welfare: " + (Object)((Object)welfare));
        this.logger.fine("Utility Values (agent = [Allocations X UtilityFunctions]):\n" + utilityValues);
        for (Map.Entry element : utilityValues.entrySet()) {
            uValues = (Vector)element.getValue();
            w = (Float)personalWeights.get(element.getKey());
            if (w == null) continue;
            i = 0;
            while (i < uValues.size()) {
                uValues.set(i, Float.valueOf(w.floatValue() * ((Float)uValues.get(i)).floatValue()));
                ++i;
            }
        }
        this.logger.fine("Weighted Utility Values (agent = [Allocations X UtilityFunctions*PersonalWeights]):\n" + utilityValues);
        float[][] utilityWinners = new float[uFuncs.size()][3];
        Vector agentBids = null;
        i = 0;
        while (i < uFuncs.size()) {
            utilityWinners[i][1] = -1.0f;
            utilityWinners[i][0] = -1.0f;
            int j = 0;
            while (j < allocs.size()) {
                socialWelfare = ((Float)((Vector)utilityValues.get(agents.get(0))).get(j * uFuncs.size() + i)).floatValue();
                int k = 1;
                while (k < agents.size()) {
                    agentBids = (Vector)utilityValues.get(agents.get(k));
                    float utilityValue = agentBids != null ? ((Float)agentBids.get(j * uFuncs.size() + i)).floatValue() : 0.0f;
                    switch (welfare) {
                        case UTILITARIAN: {
                            socialWelfare += utilityValue;
                            break;
                        }
                        case EGALITARIAN: {
                            if (!(socialWelfare > utilityValue)) break;
                            socialWelfare = utilityValue;
                            break;
                        }
                        case ELITIST: {
                            if (!(socialWelfare < utilityValue)) break;
                            socialWelfare = utilityValue;
                            break;
                        }
                        case NASH: {
                            socialWelfare *= utilityValue;
                            break;
                        }
                    }
                    ++k;
                }
                if (socialWelfare >= utilityWinners[i][1]) {
                    utilityWinners[i][0] = j;
                    utilityWinners[i][1] = socialWelfare;
                }
                ++j;
            }
            this.logger.fine("Winner of utility " + uFuncs.get(i) + ": [" + (Object)((Object)allocs.get((int)utilityWinners[i][0])) + ", " + utilityWinners[i][1] + "]");
            ++i;
        }
        float[] mademWinner = new float[4];
        mademWinner[2] = -1.0f;
        mademWinner[1] = -1.0f;
        mademWinner[0] = -1.0f;
        i = 0;
        while (i < uFuncs.size()) {
            w = (Float)utilityWeights.get(uFuncs.get(i));
            socialWelfare = w == null ? utilityWinners[i][1] : utilityWinners[i][1] * w.floatValue();
            if (socialWelfare >= mademWinner[1]) {
                mademWinner[0] = utilityWinners[i][0];
                mademWinner[1] = socialWelfare;
                mademWinner[2] = i;
            }
            ++i;
        }
        this.logger.fine("Madem Winner " + uFuncs.get((int)mademWinner[2]) + ": [" + (Object)((Object)allocs.get((int)mademWinner[0])) + ", " + mademWinner[1] + "]");
        Literal l = ASSyntax.createLiteral((String)"madem_result", (Term[])new Term[0]);
        l.addTerm((Term)new NumberTermImpl((double)id_decision));
        if (mademWinner[1] != 0.0f) {
            l.addTerm((Term)allocs.get((int)mademWinner[0]));
        } else {
            l.addTerm((Term)new Atom("none"));
        }
        this.logger.fine("Add believe: " + l);
        try {
            this.getTS().getAg().addBel(l);
        }
        catch (Exception e) {
            this.logger.warning("Error adding believe " + l);
            e.printStackTrace();
        }
        this.logger.fine("Ending Winner Determination Problem.");
    }

    class BidTimeout
    extends TimerTask {
        int id_decision;

        public BidTimeout(int id) {
            this.id_decision = id;
        }

        public void run() {
            if (MADeMAgArch.this.mademData.containsKey(this.id_decision)) {
                MADeMAgArch.this.logger.fine("Bid timeout reached for decision \"" + this.id_decision);
                MADeMAgArch.this.winnerDeterminationProblem(this.id_decision);
            }
        }
    }
}

