/*
 * Decompiled with CFR 0.152.
 */
package jmadem;

import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Atom;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Literal;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import jmadem.Cuf;
import jmadem.MADeMAgArch;

public class launch_specific_decision
extends DefaultInternalAction {
    private static final long serialVersionUID = -5768570347409861849L;
    Logger logger = Logger.getLogger(launch_specific_decision.class.getName());

    public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception {
        try {
            Term agentsTerm = args[0];
            if (agentsTerm instanceof VarTerm) {
                agentsTerm = ((VarTerm)agentsTerm).getValue();
            }
            ListTermImpl ags = (ListTermImpl)agentsTerm;
            Term allocsTerm = args[1];
            if (allocsTerm instanceof VarTerm) {
                allocsTerm = ((VarTerm)allocsTerm).getValue();
            }
            ListTermImpl allocs = (ListTermImpl)allocsTerm;
            Term uFuncsTerm = args[2];
            if (uFuncsTerm instanceof VarTerm) {
                uFuncsTerm = ((VarTerm)uFuncsTerm).getValue();
            }
            ListTermImpl uFuncs = (ListTermImpl)uFuncsTerm;
            ConcurrentHashMap<Atom, Float> personalWeights = new ConcurrentHashMap<Atom, Float>();
            ConcurrentHashMap<Atom, Float> utilityWeights = new ConcurrentHashMap<Atom, Float>();
            Term pwTerm = args[3];
            if (pwTerm instanceof VarTerm) {
                pwTerm = ((VarTerm)pwTerm).getValue();
            }
            Iterator it = ((ListTermImpl)pwTerm).iterator();
            while (it.hasNext()) {
                List pair = ((ListTermImpl)it.next()).getAsList();
                personalWeights.put((Atom)pair.get(0), new Float(((NumberTermImpl)pair.get(1)).solve()));
            }
            Term uwTerm = args[4];
            if (uwTerm instanceof VarTerm) {
                uwTerm = ((VarTerm)uwTerm).getValue();
            }
            it = ((ListTermImpl)uwTerm).iterator();
            while (it.hasNext()) {
                List pair = ((ListTermImpl)it.next()).getAsList();
                utilityWeights.put((Atom)pair.get(0), new Float(((NumberTermImpl)pair.get(1)).solve()));
            }
            Term welfareTerm = args[5];
            if (welfareTerm instanceof VarTerm) {
                welfareTerm = ((VarTerm)welfareTerm).getValue();
            }
            String name_welfare = ((Literal)welfareTerm).toString().toUpperCase();
            Cuf w = Enum.valueOf(Cuf.class, name_welfare);
            Term toutTerm = args[6];
            if (toutTerm instanceof VarTerm) {
                toutTerm = ((VarTerm)toutTerm).getValue();
            }
            int tout = Float.valueOf((float)((NumberTermImpl)toutTerm).solve()).intValue();
            if (allocs.size() == 0) {
                this.logger.severe("Error reading parameters: Allocations cannot be empty.");
                return false;
            }
            if (uFuncs.size() == 0) {
                this.logger.severe("Error reading parameters: Utility Functions cannot be empty.");
                return false;
            }
            if (ags.size() != personalWeights.size()) {
                this.logger.severe("Error reading parameters: Agents and Personal Weights mismatch.");
                return false;
            }
            if (uFuncs.size() != utilityWeights.size()) {
                this.logger.severe("Error reading parameters: Utility Functions and Utility Weights mismatch.");
                return false;
            }
            MADeMAgArch agArch = (MADeMAgArch)ts.getUserAgArch();
            int id_decision = agArch.startMADeMDecision(ags, allocs, uFuncs, personalWeights, utilityWeights, w, tout);
            if (id_decision == -1) {
                return false;
            }
            return un.unifies(args[7], (Term)new NumberTermImpl((double)id_decision));
        }
        catch (Exception e) {
            this.logger.severe("Error reading parameters for starting MADeM.");
            e.printStackTrace();
            return false;
        }
    }
}

