/*
 * Decompiled with CFR 0.152.
 */
package jason;

import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.InternalAction;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Atom;
import jason.asSyntax.ListTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Term;

public class JasonException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final Term WRONG_ARGS = new Atom("wrong_arguments");
    public static final Term UNKNOW_ERROR = new Atom("unknown");
    private static final Term defaultError = new Atom("internal_action");
    private Term error = defaultError;
    private ListTerm errorAnnots = null;

    public JasonException() {
    }

    public JasonException(String msg) {
        super(msg);
    }

    public JasonException(String msg, Term error) {
        super(msg);
        this.error = error;
    }

    public JasonException(String msg, Exception cause) {
        super(msg);
        this.initCause(cause);
    }

    public JasonException(String msg, Term error, Exception cause) {
        super(msg);
        this.initCause(cause);
        this.error = error;
    }

    public void addErrorAnnot(Term t) {
        if (this.errorAnnots == null) {
            this.errorAnnots = new ListTermImpl();
        }
        this.errorAnnots.append(t);
    }

    public ListTerm getErrorTerms() {
        ListTerm e2 = JasonException.createBasicErrorAnnots(this.error, this.getMessage());
        if (this.errorAnnots != null) {
            e2.concat(this.errorAnnots.cloneLT());
        }
        return e2;
    }

    public static JasonException createWrongArgumentNb(DefaultInternalAction ia) {
        String msg = ia.getMinArgs() == ia.getMaxArgs() ? (ia.getMinArgs() == 1 ? " One argument is expected." : " " + ia.getMinArgs() + " arguments are expected.") : " From " + ia.getMinArgs() + " to " + ia.getMaxArgs() + " arguments are expected.";
        return new JasonException("The internal action '" + ia.getClass().getSimpleName() + "' has not received the required number of argument(s)." + msg, WRONG_ARGS);
    }

    public static JasonException createWrongArgument(InternalAction ia, String reason) {
        return new JasonException("Wrong argument for internal action '" + ia.getClass().getSimpleName() + "': " + reason, WRONG_ARGS);
    }

    public static ListTerm createBasicErrorAnnots(String id, String msg) {
        return JasonException.createBasicErrorAnnots(new Atom(id), msg);
    }

    public static ListTerm createBasicErrorAnnots(Term id, String msg) {
        return ASSyntax.createList(ASSyntax.createStructure("error", id), ASSyntax.createStructure("error_msg", ASSyntax.createString(msg)));
    }
}

