/*
 * Decompiled with CFR 0.152.
 */
package jason.asSemantics;

import jason.JasonException;
import jason.RevisionFailedException;
import jason.architecture.AgArch;
import jason.asSemantics.ActionExec;
import jason.asSemantics.ArithFunction;
import jason.asSemantics.Circumstance;
import jason.asSemantics.Event;
import jason.asSemantics.Intention;
import jason.asSemantics.InternalAction;
import jason.asSemantics.Message;
import jason.asSemantics.Option;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Literal;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.Plan;
import jason.asSyntax.PlanLibrary;
import jason.asSyntax.Rule;
import jason.asSyntax.Trigger;
import jason.asSyntax.directives.FunctionRegister;
import jason.asSyntax.parser.ParseException;
import jason.asSyntax.parser.as2j;
import jason.bb.BeliefBase;
import jason.bb.DefaultBeliefBase;
import jason.functions.Count;
import jason.functions.RuleToFunction;
import jason.runtime.Settings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agent {
    protected BeliefBase bb = new DefaultBeliefBase();
    protected PlanLibrary pl = new PlanLibrary();
    protected TransitionSystem ts = null;
    protected String aslSource = null;
    private List<Literal> initialGoals = new ArrayList<Literal>();
    private List<Literal> initialBels = new ArrayList<Literal>();
    private Map<String, InternalAction> internalActions = new HashMap<String, InternalAction>();
    private Map<String, ArithFunction> functions = new HashMap<String, ArithFunction>();
    private boolean hasCustomSelOp = true;
    private ScheduledExecutorService scheduler = null;
    protected Logger logger = Logger.getLogger(Agent.class.getName());
    static DocumentBuilder builder = null;

    public Agent() {
        this.checkCustomSelectOption();
    }

    public void initAg(String asSrc) throws JasonException {
        try {
            this.initDefaultFunctions();
            boolean parsingOk = true;
            if (asSrc != null) {
                asSrc = asSrc.replaceAll("\\\\", "/");
                this.setASLSrc(asSrc);
                if (asSrc.startsWith("ClassResource:")) {
                    this.parseAS(Agent.class.getResource(asSrc.substring("ClassResource:".length())).openStream());
                } else {
                    try {
                        parsingOk = this.parseAS(new URL(asSrc));
                    }
                    catch (MalformedURLException e2) {
                        parsingOk = this.parseAS(new File(asSrc));
                    }
                }
            }
            if (parsingOk) {
                this.addInitialBelsInBB();
                this.addInitialGoalsInTS();
            }
            if (JasonException.class.getResource("/asl/kqmlPlans.asl") != null) {
                this.setASLSrc("kqmlPlans.asl");
                this.parseAS(JasonException.class.getResource("/asl/kqmlPlans.asl"));
                this.setASLSrc(asSrc);
            } else {
                this.logger.warning("The kqmlPlans.asl was not found!");
            }
        }
        catch (Exception e3) {
            this.logger.log(Level.SEVERE, "Error creating customised Agent class!", e3);
            throw new JasonException("Error creating customised Agent class! - " + e3);
        }
    }

    public TransitionSystem initAg(AgArch arch, BeliefBase bb, String asSrc, Settings stts) throws JasonException {
        try {
            if (bb != null) {
                this.setBB(bb);
            }
            new TransitionSystem(this, new Circumstance(), stts, arch);
            this.initAg(asSrc);
            return this.ts;
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error creating the agent class!", e2);
            throw new JasonException("Error creating the agent class! - " + e2);
        }
    }

    public void stopAg() {
        this.bb.stop();
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    public Agent clone(AgArch arch) {
        Agent a = new Agent();
        a.setLogger(arch);
        a.logger.setLevel(this.getTS().getSettings().logLevel());
        a.bb = (BeliefBase)this.bb.clone();
        a.pl = (PlanLibrary)this.pl.clone();
        a.aslSource = this.aslSource;
        a.initDefaultFunctions();
        a.setTS(new TransitionSystem(a, (Circumstance)this.getTS().getC().clone(), this.getTS().getSettings(), arch));
        return a;
    }

    public void setLogger(AgArch arch) {
        if (arch != null) {
            this.logger = Logger.getLogger(String.valueOf(Agent.class.getName()) + "." + arch.getAgName());
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ScheduledExecutorService getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = Executors.newScheduledThreadPool(2);
        }
        return this.scheduler;
    }

    public String getASLSrc() {
        return this.aslSource;
    }

    public void setASLSrc(String file) {
        if (file != null && file.startsWith("./")) {
            file = file.substring(2);
        }
        this.aslSource = file;
    }

    public boolean parseAS(URL asURL) {
        try {
            this.parseAS(asURL.openStream());
            this.logger.fine("as2j: AgentSpeak program '" + asURL + "' parsed successfully!");
            return true;
        }
        catch (IOException e2) {
            this.logger.log(Level.SEVERE, "as2j: the AgentSpeak source file '" + asURL + "' was not found!");
        }
        catch (ParseException e3) {
            this.logger.log(Level.SEVERE, "as2j: parsing error: " + e3.getMessage());
        }
        catch (Exception e4) {
            this.logger.log(Level.SEVERE, "as2j: error parsing \"" + asURL + "\"", e4);
        }
        return false;
    }

    public boolean parseAS(File asFile) {
        try {
            this.parseAS(new FileInputStream(asFile));
            this.logger.fine("as2j: AgentSpeak program '" + asFile + "' parsed successfully!");
            return true;
        }
        catch (FileNotFoundException e2) {
            this.logger.log(Level.SEVERE, "as2j: the AgentSpeak source file '" + asFile + "' was not found!");
        }
        catch (ParseException e3) {
            this.logger.log(Level.SEVERE, "as2j: parsing error:" + e3.getMessage());
        }
        catch (Exception e4) {
            this.logger.log(Level.SEVERE, "as2j: error parsing \"" + asFile + "\"", e4);
        }
        return false;
    }

    public void parseAS(InputStream asIn) throws ParseException, JasonException {
        as2j parser = new as2j(asIn);
        parser.agent(this);
    }

    public void parseAS(Reader asIn) throws ParseException, JasonException {
        as2j parser = new as2j(asIn);
        parser.agent(this);
    }

    public InternalAction getIA(String iaName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        InternalAction objIA;
        if (iaName.charAt(0) == '.') {
            iaName = "jason.stdlib" + iaName;
        }
        if ((objIA = this.internalActions.get(iaName)) == null) {
            Class<?> iaclass = Class.forName(iaName);
            try {
                Method create = iaclass.getMethod("create", null);
                objIA = (InternalAction)create.invoke(null, null);
            }
            catch (Exception e2) {
                objIA = (InternalAction)iaclass.newInstance();
            }
            this.internalActions.put(iaName, objIA);
        }
        return objIA;
    }

    public void initDefaultFunctions() {
        this.addFunction(Count.class, false);
    }

    public void addFunction(Class<? extends ArithFunction> c) {
        this.addFunction(c, true);
    }

    private void addFunction(Class<? extends ArithFunction> c, boolean user) {
        try {
            ArithFunction af = c.newInstance();
            String error = null;
            if (user) {
                error = FunctionRegister.checkFunctionName(af.getName());
            }
            if (error != null) {
                this.logger.warning(error);
            } else {
                this.functions.put(af.getName(), af);
            }
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error registering function " + c.getName(), e2);
        }
    }

    public void addFunction(String function, int arity, String literal2) {
        try {
            String error = FunctionRegister.checkFunctionName(function);
            if (error != null) {
                this.logger.warning(error);
            } else {
                this.functions.put(function, new RuleToFunction(literal2, arity));
            }
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error registering function " + literal2, e2);
        }
    }

    public ArithFunction getFunction(String function, int arity) {
        ArithFunction af = this.functions.get(function);
        if (af == null || !af.checkArity(arity)) {
            af = FunctionRegister.getFunction(function, arity);
        }
        if (af != null && af.checkArity(arity)) {
            return af;
        }
        return null;
    }

    public void addInitialGoal(Literal g) {
        this.initialGoals.add(g);
    }

    public void addInitialBel(Literal b) {
        this.initialBels.add(b);
    }

    public List<Literal> getInitialBels() {
        return this.initialBels;
    }

    public void addInitialBelsInBB() throws RevisionFailedException {
        int i = this.initialBels.size() - 1;
        while (i >= 0) {
            Literal b = this.initialBels.get(i);
            if (!b.isRule() && !b.isGround()) {
                b = new Rule(b, (LogicalFormula)Literal.LTrue);
            }
            b.apply(new Unifier());
            if (b.isRule()) {
                this.getBB().add(b);
            } else {
                this.addBel(b);
            }
            --i;
        }
        this.initialBels.clear();
    }

    public void addInitialGoalsInTS() {
        for (Literal g : this.initialGoals) {
            g.makeVarsAnnon();
            if (!g.hasSource()) {
                g.addAnnot(BeliefBase.TSelf);
            }
            this.getTS().getC().addAchvGoal(g, Intention.EmptyInt);
        }
    }

    public void importComponents(Agent a) throws JasonException {
        if (a != null) {
            for (Literal b : a.initialBels) {
                this.addInitialBel(b);
            }
            for (Literal g : a.initialGoals) {
                this.addInitialGoal(g);
            }
            for (Plan p : a.getPL()) {
                this.getPL().add(p, false);
            }
        }
    }

    public boolean socAcc(Message m) {
        return true;
    }

    public Event selectEvent(Queue<Event> events) {
        return events.poll();
    }

    public Option selectOption(List<Option> options) {
        if (options != null && !options.isEmpty()) {
            return options.remove(0);
        }
        return null;
    }

    public Intention selectIntention(Queue<Intention> intentions) {
        return intentions.poll();
    }

    public Message selectMessage(Queue<Message> messages) {
        return messages.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionExec selectAction(List<ActionExec> actList) {
        List<ActionExec> list2 = actList;
        synchronized (list2) {
            Iterator<ActionExec> i = actList.iterator();
            while (i.hasNext()) {
                ActionExec a = i.next();
                if (a.getIntention().isSuspended()) continue;
                i.remove();
                return a;
            }
        }
        return null;
    }

    public void setTS(TransitionSystem ts) {
        this.ts = ts;
        this.setLogger(ts.getUserAgArch());
        this.logger.setLevel(ts.getSettings().logLevel());
    }

    public TransitionSystem getTS() {
        return this.ts;
    }

    public void setBB(BeliefBase bb) {
        this.bb = bb;
    }

    public BeliefBase getBB() {
        return this.bb;
    }

    public void setPL(PlanLibrary pl) {
        this.pl = pl;
    }

    public PlanLibrary getPL() {
        return this.pl;
    }

    public void buf(List<Literal> percepts) {
        if (percepts == null) {
            return;
        }
        Iterator<Literal> perceptsInBB = this.getBB().getPercepts();
        while (perceptsInBB.hasNext()) {
            Literal l = perceptsInBB.next();
            boolean wasPerceived = false;
            Iterator<Literal> ip = percepts.iterator();
            while (ip.hasNext()) {
                Literal t = ip.next();
                if (!l.equalsAsStructure(t) || l.negated() != t.negated()) continue;
                wasPerceived = true;
                if (l.hasAnnot()) break;
                ip.remove();
                break;
            }
            if (wasPerceived) continue;
            perceptsInBB.remove();
            Trigger te = new Trigger(Trigger.TEOperator.del, Trigger.TEType.belief, l);
            if (!this.ts.getC().hasListener() && !this.pl.hasCandidatePlan(te)) continue;
            l = l.copy();
            l.clearAnnots();
            l.addAnnot(BeliefBase.TPercept);
            te.setLiteral(l);
            this.ts.getC().addEvent(new Event(te, Intention.EmptyInt));
        }
        for (Literal lp : percepts) {
            try {
                lp = lp.copy();
                lp.addAnnot(BeliefBase.TPercept);
                if (!this.getBB().add(lp)) continue;
                Trigger te = new Trigger(Trigger.TEOperator.add, Trigger.TEType.belief, lp);
                this.ts.updateEvents(new Event(te, Intention.EmptyInt));
            }
            catch (Exception e2) {
                this.logger.log(Level.SEVERE, "Error adding percetion " + lp, e2);
            }
        }
    }

    public boolean believes(LogicalFormula bel, Unifier un) {
        try {
            Iterator<Unifier> iun = bel.logicalConsequence(this, un);
            if (iun != null && iun.hasNext()) {
                un.compose(iun.next());
                return true;
            }
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "** Error in method believes(" + bel + "," + un + ").", e2);
        }
        return false;
    }

    public Literal findBel(Literal bel, Unifier un) {
        Iterator<Literal> relB = this.bb.getCandidateBeliefs(bel, un);
        if (relB != null) {
            while (relB.hasNext()) {
                Literal b = relB.next();
                if (b.isRule() || !un.unifies(bel, b)) continue;
                return b;
            }
        }
        return null;
    }

    public List<Literal>[] brf(Literal beliefToAdd, Literal beliefToDel, Intention i) throws RevisionFailedException {
        List[] result;
        block12: {
            result = null;
            try {
                if (beliefToAdd != null) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("adding belief " + beliefToAdd);
                    }
                    if (this.getBB().add(beliefToAdd)) {
                        result = new List[]{Collections.singletonList(beliefToAdd), Collections.emptyList()};
                    }
                }
                if (beliefToDel == null) break block12;
                Unifier u = null;
                try {
                    u = i.peek().unif;
                }
                catch (Exception e2) {
                    u = new Unifier();
                }
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("doing brf for " + beliefToDel + " in BB=" + this.believes(beliefToDel, u));
                }
                if (this.believes(beliefToDel, u)) {
                    beliefToDel.apply(u);
                    if (this.getBB().remove(beliefToDel)) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("Removed:" + beliefToDel);
                        }
                        if (result == null) {
                            result = new List[]{Collections.emptyList(), Collections.singletonList(beliefToDel)};
                        }
                    }
                }
            }
            catch (Exception e3) {
                this.logger.log(Level.WARNING, "Error at BRF.", e3);
            }
        }
        return result;
    }

    public boolean addBel(Literal bel) throws RevisionFailedException {
        List<Literal>[] result;
        if (!bel.hasSource()) {
            bel.addAnnot(BeliefBase.TSelf);
        }
        if ((result = this.brf(bel, null, Intention.EmptyInt)) != null && this.ts != null) {
            this.ts.updateEvents(result, Intention.EmptyInt);
            return true;
        }
        return false;
    }

    public boolean delBel(Literal bel) throws RevisionFailedException {
        List<Literal>[] result;
        if (!bel.hasSource()) {
            bel.addAnnot(BeliefBase.TSelf);
        }
        if ((result = this.brf(null, bel, Intention.EmptyInt)) != null && this.ts != null) {
            this.ts.updateEvents(result, Intention.EmptyInt);
            return true;
        }
        return false;
    }

    public void abolish(Literal bel, Unifier un) throws RevisionFailedException {
        Iterator<Literal> il;
        ArrayList<Literal> toDel = new ArrayList<Literal>();
        if (un == null) {
            un = new Unifier();
        }
        if ((il = this.getBB().getCandidateBeliefs(bel, un)) != null) {
            while (il.hasNext()) {
                Literal inBB = il.next();
                if (inBB.isRule() || !un.clone().unifiesNoUndo(bel, inBB)) continue;
                toDel.add(inBB);
            }
        }
        for (Literal l : toDel) {
            this.delBel(l);
        }
    }

    private void checkCustomSelectOption() {
        this.hasCustomSelOp = false;
        Method[] methodArray = this.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (!m.getDeclaringClass().equals(Agent.class) && m.getName().equals("selectOption")) {
                this.hasCustomSelOp = true;
            }
            ++n2;
        }
    }

    public boolean hasCustomSelectOption() {
        return this.hasCustomSelOp;
    }

    public Document getAgState() {
        if (builder == null) {
            try {
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (Exception e2) {
                this.logger.log(Level.SEVERE, "Error creating XML builder\n");
                return null;
            }
        }
        Document document = builder.newDocument();
        document.appendChild(document.createProcessingInstruction("xml-stylesheet", "href='http://jason.sf.net/xml/agInspection.xsl' type='text/xsl' "));
        Element ag = this.getAsDOM(document);
        document.appendChild(ag);
        ag.appendChild(this.ts.getC().getAsDOM(document));
        return document;
    }

    public String toString() {
        return "Agent " + this.getASLSrc();
    }

    public Element getAsDOM(Document document) {
        Element ag = document.createElement("agent");
        ag.setAttribute("name", this.ts.getUserAgArch().getAgName());
        ag.setAttribute("cycle", "" + this.ts.getUserAgArch().getCycleNumber());
        ag.appendChild(this.bb.getAsDOM(document));
        return ag;
    }

    public Document getAgProgram() {
        if (builder == null) {
            try {
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (Exception e2) {
                this.logger.log(Level.SEVERE, "Error creating XML builder\n");
                return null;
            }
        }
        Document document = builder.newDocument();
        Element ag = document.createElement("agent");
        if (this.getASLSrc() != null && this.getASLSrc().length() > 0) {
            ag.setAttribute("source", this.getASLSrc());
        }
        ag.appendChild(this.bb.getAsDOM(document));
        ag.appendChild(this.pl.getAsDOM(document));
        document.appendChild(ag);
        return document;
    }
}

