/*
 * Decompiled with CFR 0.152.
 */
package jason.asSemantics;

import jason.JasonException;
import jason.asSemantics.Circumstance;
import jason.asSemantics.Intention;
import jason.asSemantics.InternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.Term;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public abstract class ConcurrentInternalAction
implements InternalAction {
    private static int actcount = 0;

    public boolean canBeUsedInContext() {
        return false;
    }

    public boolean suspendIntention() {
        return true;
    }

    public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception {
        return false;
    }

    public String suspendInt(final TransitionSystem ts, String basekey, int timeout) {
        final String key = String.valueOf(basekey) + "/" + actcount++;
        final Circumstance C = ts.getC();
        Intention i = C.getSelectedIntention();
        i.setSuspended(true);
        C.getPendingIntentions().put(key, i);
        if (timeout > 0) {
            ts.getAg().getScheduler().schedule(new Runnable(){

                public void run() {
                    if (C.getPendingIntentions().get(key) != null) {
                        ConcurrentInternalAction.this.timeout(ts, key);
                    }
                }
            }, (long)timeout, TimeUnit.MILLISECONDS);
        }
        return key;
    }

    public void startInternalAction(TransitionSystem ts, Runnable code) {
        ts.getAg().getScheduler().execute(code);
    }

    public abstract void timeout(TransitionSystem var1, String var2);

    public void resumeInt(TransitionSystem ts, String intentionKey) {
        this.resume(ts, intentionKey, false);
    }

    public void failInt(TransitionSystem ts, String intentionKey) {
        this.resume(ts, intentionKey, true);
    }

    private synchronized void resume(TransitionSystem ts, String intentionKey, boolean abort) {
        Circumstance C = ts.getC();
        Intention pi2 = C.getPendingIntentions().remove(intentionKey);
        if (pi2 != null) {
            pi2.setSuspended(false);
            try {
                if (abort) {
                    ts.generateGoalDeletion(pi2, null);
                } else {
                    pi2.peek().removeCurrentStep();
                    ts.applyClrInt(pi2);
                    C.addIntention(pi2);
                }
            }
            catch (JasonException e2) {
                ts.getLogger().log(Level.SEVERE, "Error resuming intention", e2);
            }
            ts.getUserAgArch().getArchInfraTier().wake();
        }
    }
}

