/*
 * Decompiled with CFR 0.152.
 */
package jason.asSemantics;

import jason.asSemantics.Option;
import jason.asSemantics.Unifier;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Plan;
import jason.asSyntax.PlanBody;
import jason.asSyntax.PlanBodyImpl;
import jason.asSyntax.StringTermImpl;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IntendedMeans
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Unifier unif = null;
    protected Plan plan;
    private Trigger trigger;

    public IntendedMeans(Option opt, Trigger te) {
        this.plan = opt.getPlan().cloneOnlyBody();
        this.unif = opt.getUnifier();
        if (te == null) {
            this.trigger = this.plan.getTrigger();
        } else {
            this.trigger = te.clone();
            this.trigger.getLiteral().apply(this.unif);
        }
    }

    private IntendedMeans() {
    }

    public Term removeCurrentStep() {
        PlanBody current = this.plan.getBody();
        if (current.isEmptyBody()) {
            return null;
        }
        return current.removeBody(0);
    }

    public PlanBody getCurrentStep() {
        return this.plan.getBody();
    }

    public Plan getPlan() {
        return this.plan;
    }

    public void setUnif(Unifier unif) {
        this.unif = unif;
    }

    public Unifier getUnif() {
        return this.unif;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(Trigger tr) {
        this.trigger = tr;
    }

    public boolean isAtomic() {
        return this.plan != null && this.plan.isAtomic();
    }

    public boolean isFinished() {
        return this.plan.getBody().isEmptyBody();
    }

    public boolean isGoalAdd() {
        return this.trigger.isAddition() && this.trigger.isGoal();
    }

    public Object clone() {
        IntendedMeans c = new IntendedMeans();
        c.unif = this.unif.clone();
        c.plan = (Plan)this.plan.clone();
        c.trigger = this.trigger.clone();
        return c;
    }

    public String toString() {
        return this.plan + " / " + this.unif;
    }

    public Term getAsTerm() {
        Structure im = new Structure("im");
        im.addTerm(new StringTermImpl(this.plan.getLabel().toString()));
        if (this.plan.getBody() instanceof PlanBodyImpl) {
            ListTermImpl lt = new ListTermImpl();
            for (PlanBody bd : (PlanBodyImpl)this.plan.getBody()) {
                PlanBody c = (PlanBody)bd.clone();
                c.apply(this.unif);
                lt.add(new StringTermImpl(String.valueOf(c.getBodyType().toString()) + c.getBodyTerm()));
            }
            im.addTerm(lt);
        }
        return im;
    }

    public Element getAsDOM(Document document) {
        Element eim = document.createElement("intended-means");
        eim.setAttribute("trigger", this.trigger.toString());
        if (this.plan != null) {
            eim.appendChild(this.plan.getAsDOM(document));
        }
        if (this.unif != null && this.unif.size() > 0) {
            eim.appendChild(this.unif.getAsDOM(document));
        }
        return eim;
    }
}

