/*
 * Decompiled with CFR 0.152.
 */
package jason.asSemantics;

import jason.JasonException;
import jason.RevisionFailedException;
import jason.architecture.AgArch;
import jason.asSemantics.ActionExec;
import jason.asSemantics.Agent;
import jason.asSemantics.Circumstance;
import jason.asSemantics.Event;
import jason.asSemantics.IntendedMeans;
import jason.asSemantics.Intention;
import jason.asSemantics.InternalAction;
import jason.asSemantics.Message;
import jason.asSemantics.Option;
import jason.asSemantics.Unifier;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Atom;
import jason.asSyntax.DefaultTerm;
import jason.asSyntax.InternalActionLiteral;
import jason.asSyntax.ListTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Literal;
import jason.asSyntax.LiteralImpl;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Plan;
import jason.asSyntax.PlanBody;
import jason.asSyntax.PlanLibrary;
import jason.asSyntax.StringTermImpl;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import jason.asSyntax.parser.ParseException;
import jason.bb.BeliefBase;
import jason.runtime.Settings;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionSystem {
    private Logger logger = null;
    private Agent ag = null;
    private AgArch agArch = null;
    private Circumstance C = null;
    private Settings setts = null;
    private State step = State.StartRC;
    private int nrcslbr;
    private TransitionSystem confP;
    private TransitionSystem conf;
    private static final Atom aNOCODE = new Atom("no_code");

    public TransitionSystem(Agent a, Circumstance c, Settings s, AgArch ar) {
        this.ag = a;
        this.C = c;
        this.agArch = ar;
        this.setts = s == null ? new Settings() : s;
        if (this.C == null) {
            this.C = new Circumstance();
        }
        this.conf = this.confP = this;
        this.nrcslbr = this.setts.nrcbp();
        this.setLogger(this.agArch);
        if (this.setts != null) {
            this.logger.setLevel(this.setts.logLevel());
        }
        if (a != null) {
            a.setTS(this);
        }
        if (ar != null) {
            ar.setTS(this);
        }
    }

    public void setLogger(AgArch arch) {
        this.logger = arch != null ? Logger.getLogger(String.valueOf(TransitionSystem.class.getName()) + "." + arch.getAgName()) : Logger.getLogger(TransitionSystem.class.getName());
    }

    private void applySemanticRule() throws JasonException {
        switch (this.step) {
            case StartRC: {
                this.applyProcMsg();
                break;
            }
            case SelEv: {
                this.applySelEv();
                break;
            }
            case RelPl: {
                this.applyRelPl();
                break;
            }
            case ApplPl: {
                this.applyApplPl();
                break;
            }
            case SelAppl: {
                this.applySelAppl();
                break;
            }
            case FindOp: {
                this.applyFindOp();
                break;
            }
            case AddIM: {
                this.applyAddIM();
                break;
            }
            case ProcAct: {
                this.applyProcAct();
                break;
            }
            case SelInt: {
                this.applySelInt();
                break;
            }
            case ExecInt: {
                this.applyExecInt();
                break;
            }
            case ClrInt: {
                this.confP.step = State.StartRC;
                this.applyClrInt(this.conf.C.SI);
            }
        }
    }

    private void applyProcMsg() throws JasonException {
        this.confP.step = State.SelEv;
        if (!this.conf.C.MB.isEmpty()) {
            Message m = this.conf.ag.selectMessage(this.conf.C.MB);
            if (m == null) {
                return;
            }
            Term content = null;
            if (m.getPropCont() instanceof Term) {
                content = (Term)m.getPropCont();
            } else {
                try {
                    content = ASSyntax.parseTerm(m.getPropCont().toString());
                }
                catch (ParseException e2) {
                    this.logger.warning("The content of the message '" + m.getPropCont() + "' is not a term!");
                    return;
                }
            }
            Intention intention = null;
            if (m.getInReplyTo() != null) {
                intention = this.getC().getPendingIntentions().remove(m.getInReplyTo());
            }
            if (intention != null) {
                Structure send2 = (Structure)intention.peek().removeCurrentStep();
                if (m.isUnTell()) {
                    content = send2.getTerm(1).toString().equals("askOne") ? Literal.LFalse : new ListTermImpl();
                }
                if (intention.peek().getUnif().unifies(send2.getTerm(3), content)) {
                    this.getC().addIntention(intention);
                } else {
                    this.generateGoalDeletion(intention, JasonException.createBasicErrorAnnots("ask_failed", "reply of an ask message does not unify with forth argument of .send"));
                }
            } else if (this.conf.ag.socAcc(m)) {
                Literal received = new LiteralImpl("kqml_received").addTerms(new Atom(m.getSender()), new Atom(m.getIlForce()), content, new Atom(m.getMsgId()));
                this.updateEvents(new Event(new Trigger(Trigger.TEOperator.add, Trigger.TEType.achieve, received), Intention.EmptyInt));
            }
        }
    }

    private void applySelEv() throws JasonException {
        if (this.C.hasAtomicIntention()) {
            this.confP.step = State.SelInt;
            return;
        }
        if (this.conf.C.hasEvent()) {
            this.confP.C.SE = this.C.removeAtomicEvent();
            if (this.confP.C.SE != null) {
                this.confP.step = State.RelPl;
                return;
            }
            this.confP.C.SE = this.conf.ag.selectEvent(this.confP.C.getEvents());
            if (this.confP.C.SE != null) {
                this.confP.step = this.ag.hasCustomSelectOption() || this.setts.verbose() == 2 ? State.RelPl : State.FindOp;
                return;
            }
        }
        this.confP.step = State.ProcAct;
    }

    private void applyRelPl() throws JasonException {
        this.confP.C.RP = this.relevantPlans(this.conf.C.SE.trigger);
        if (this.confP.C.RP != null || this.setts.retrieve()) {
            this.confP.step = State.ApplPl;
        } else {
            this.applyRelApplPlRule2("relevant");
        }
    }

    private void applyApplPl() throws JasonException {
        this.confP.C.AP = this.applicablePlans(this.confP.C.RP);
        if (this.confP.C.AP != null || this.setts.retrieve()) {
            this.confP.step = State.SelAppl;
        } else {
            this.applyRelApplPlRule2("applicable");
        }
    }

    private void applyRelApplPlRule2(String m) throws JasonException {
        this.confP.step = State.ProcAct;
        if (this.conf.C.SE.trigger.isGoal()) {
            String msg = "Found a goal for which there is no " + m + " plan:" + this.conf.C.SE;
            if (!this.generateGoalDeletionFromEvent(JasonException.createBasicErrorAnnots("no_" + m, msg))) {
                this.logger.warning(msg);
            }
        } else if (this.conf.C.SE.isInternal()) {
            this.confP.C.SI = this.conf.C.SE.intention;
            this.updateIntention();
        } else if (this.setts.requeue()) {
            this.confP.C.addEvent(this.conf.C.SE);
        } else {
            this.confP.step = State.SelEv;
        }
    }

    private void applySelAppl() throws JasonException {
        this.confP.C.SO = this.conf.ag.selectOption(this.confP.C.AP);
        if (this.confP.C.SO != null) {
            this.confP.step = State.AddIM;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Selected option " + this.confP.C.SO + " for event " + this.confP.C.SE);
            }
        } else {
            this.logger.fine("** selectOption returned null!");
            this.generateGoalDeletionFromEvent(JasonException.createBasicErrorAnnots("no_option", "selectOption returned null"));
            this.confP.step = State.ProcAct;
        }
    }

    private void applyFindOp() throws JasonException {
        this.confP.step = State.AddIM;
        List<Plan> candidateRPs = this.conf.ag.pl.getCandidatePlans(this.conf.C.SE.trigger);
        if (candidateRPs != null) {
            for (Plan pl : candidateRPs) {
                Unifier relUn = pl.isRelevant(this.conf.C.SE.trigger);
                if (relUn == null) continue;
                LogicalFormula context = pl.getContext();
                if (context == null) {
                    this.confP.C.SO = new Option(pl, relUn);
                    return;
                }
                Iterator<Unifier> r = context.logicalConsequence(this.ag, relUn);
                if (r == null || !r.hasNext()) continue;
                this.confP.C.SO = new Option(pl, r.next());
                return;
            }
            this.applyRelApplPlRule2("applicable");
        } else {
            this.applyRelApplPlRule2("relevant");
        }
    }

    private void applyAddIM() throws JasonException {
        IntendedMeans im = new IntendedMeans(this.conf.C.SO, this.conf.C.SE.getTrigger());
        if (this.conf.C.SE.intention == Intention.EmptyInt) {
            Intention intention = new Intention();
            intention.push(im);
            this.confP.C.addIntention(intention);
        } else {
            this.confP.C.SE.intention.push(im);
            this.confP.C.addIntention(this.confP.C.SE.intention);
        }
        this.confP.step = State.ProcAct;
    }

    private void applyProcAct() throws JasonException {
        ActionExec a;
        this.confP.step = State.SelInt;
        if (this.conf.C.hasFeedbackAction() && (a = this.conf.ag.selectAction(this.conf.C.getFeedbackActions())) != null) {
            this.confP.C.SI = a.getIntention();
            if (this.C.getPendingActions().remove(a.getIntention().getId()) != null) {
                if (a.getResult()) {
                    this.updateIntention();
                    this.applyClrInt(this.confP.C.SI);
                } else {
                    this.generateGoalDeletion(this.conf.C.SI, JasonException.createBasicErrorAnnots("action_failed", ""));
                }
            } else {
                this.applyProcAct();
            }
        }
    }

    private void applySelInt() throws JasonException {
        this.confP.step = State.ExecInt;
        this.confP.C.SI = this.C.removeAtomicIntention();
        if (this.confP.C.SI != null) {
            return;
        }
        if (this.conf.C.hasIntention()) {
            this.confP.C.SI = this.conf.ag.selectIntention(this.conf.C.getIntentions());
            if (this.confP.C.SI != null) {
                return;
            }
        }
        this.confP.step = State.StartRC;
    }

    private void applyExecInt() throws JasonException {
        this.confP.step = State.ClrInt;
        if (this.conf.C.SI.isFinished()) {
            return;
        }
        IntendedMeans im = this.conf.C.SI.peek();
        if (im.isFinished()) {
            this.updateIntention();
            return;
        }
        Unifier u = im.unif;
        PlanBody h = im.getCurrentStep();
        h.apply(u);
        Literal body = null;
        Term bTerm = h.getBodyTerm();
        if (bTerm instanceof Literal) {
            body = (Literal)bTerm;
        }
        switch (h.getBodyType()) {
            case action: {
                this.confP.C.A = new ActionExec(body, this.conf.C.SI);
                break;
            }
            case internalAction: {
                boolean ok = false;
                ListTerm errorAnnots = null;
                try {
                    InternalAction ia = ((InternalActionLiteral)bTerm).getIA(this.ag);
                    Object oresult = ia.execute(this, u, body.getTermsArray());
                    if (oresult != null) {
                        Iterator iu;
                        boolean bl = ok = oresult instanceof Boolean && (Boolean)oresult != false;
                        if (!ok && oresult instanceof Iterator && (iu = (Iterator)oresult).hasNext()) {
                            im.unif = (Unifier)iu.next();
                            ok = true;
                        }
                        if (!ok) {
                            errorAnnots = JasonException.createBasicErrorAnnots("ia_failed", "");
                        }
                    }
                    if (ok && !ia.suspendIntention()) {
                        this.updateIntention();
                    }
                }
                catch (JasonException e2) {
                    errorAnnots = e2.getErrorTerms();
                    if (!this.generateGoalDeletion(this.conf.C.SI, errorAnnots)) {
                        this.logger.log(Level.SEVERE, String.valueOf(body.getErrorMsg()) + ": " + e2.getMessage());
                    }
                    ok = true;
                }
                catch (Exception e3) {
                    if (body == null) {
                        this.logger.log(Level.SEVERE, "Selected an intention with null body in '" + h + "' and IM " + im, e3);
                    }
                    this.logger.log(Level.SEVERE, String.valueOf(body.getErrorMsg()) + ": " + e3.getMessage(), e3);
                }
                if (ok) break;
                this.generateGoalDeletion(this.conf.C.SI, errorAnnots);
                break;
            }
            case constraint: {
                Iterator<Unifier> iu = ((LogicalFormula)bTerm).logicalConsequence(this.ag, u);
                if (iu.hasNext()) {
                    im.unif = iu.next();
                    this.updateIntention();
                    break;
                }
                String msg = "Constraint " + h + " was not satisfied (" + h.getSrcInfo() + ").";
                this.generateGoalDeletion(this.conf.C.SI, JasonException.createBasicErrorAnnots(new Atom("constraint_failed"), msg));
                this.logger.fine(msg);
                break;
            }
            case achieve: {
                if (!body.hasSource()) {
                    body.addAnnot(BeliefBase.TSelf);
                }
                body = body.copy();
                body.makeVarsAnnon(u);
                this.conf.C.addAchvGoal(body, this.conf.C.SI);
                this.confP.step = State.StartRC;
                break;
            }
            case achieveNF: {
                if (!body.hasSource()) {
                    body.addAnnot(BeliefBase.TSelf);
                }
                body = body.copy();
                body.makeVarsAnnon(u);
                this.conf.C.addAchvGoal(body, Intention.EmptyInt);
                this.updateIntention();
                break;
            }
            case test: {
                LogicalFormula f = (LogicalFormula)bTerm;
                if (this.conf.ag.believes(f, u)) {
                    this.updateIntention();
                    break;
                }
                boolean fail2 = true;
                if (f instanceof Literal && (body = (Literal)f.clone()).isLiteral()) {
                    body.makeVarsAnnon(u);
                    Trigger te = new Trigger(Trigger.TEOperator.add, Trigger.TEType.test, body);
                    if (this.ag.getPL().hasCandidatePlan(te)) {
                        Event evt = new Event(te, this.conf.C.SI);
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("Test Goal '" + h + "' failed as simple query. Generating internal event for it: " + te);
                        }
                        this.conf.C.addEvent(evt);
                        this.confP.step = State.StartRC;
                        fail2 = false;
                    }
                }
                if (!fail2) break;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Test '" + h + "' failed (" + h.getSrcInfo() + ").");
                }
                this.generateGoalDeletion(this.conf.C.SI, null);
                break;
            }
            case delAddBel: {
                if (!body.hasSource()) {
                    body.addAnnot(BeliefBase.TSelf);
                }
                Literal bc = (Literal)body.clone();
                bc.makeTermsAnnon();
                try {
                    List<Literal>[] result = this.ag.brf(null, bc, this.conf.C.SI);
                    if (result != null) {
                        this.updateEvents(result, Intention.EmptyInt);
                    }
                }
                catch (RevisionFailedException re) {
                    this.generateGoalDeletion(this.conf.C.SI, null);
                    break;
                }
            }
            case addBel: {
                if (!body.hasSource()) {
                    body.addAnnot(BeliefBase.TSelf);
                }
                Intention newfocus = Intention.EmptyInt;
                if (this.setts.sameFocus()) {
                    newfocus = this.conf.C.SI;
                }
                body.makeVarsAnnon(u);
                try {
                    List<Literal>[] result = this.ag.brf(body, null, this.conf.C.SI);
                    if (result != null) {
                        this.updateEvents(result, newfocus);
                        if (this.setts.sameFocus()) break;
                        this.updateIntention();
                        break;
                    }
                    this.updateIntention();
                }
                catch (RevisionFailedException re) {
                    this.generateGoalDeletion(this.conf.C.SI, null);
                }
                break;
            }
            case delBel: {
                if (!body.hasSource()) {
                    body.addAnnot(BeliefBase.TSelf);
                }
                Intention newfocus = Intention.EmptyInt;
                if (this.setts.sameFocus()) {
                    newfocus = this.conf.C.SI;
                }
                try {
                    List<Literal>[] result = this.ag.brf(null, body, this.conf.C.SI);
                    if (result != null) {
                        this.updateEvents(result, newfocus);
                        if (this.setts.sameFocus()) break;
                        this.updateIntention();
                        break;
                    }
                    this.updateIntention();
                    break;
                }
                catch (RevisionFailedException re) {
                    this.generateGoalDeletion(this.conf.C.SI, null);
                }
            }
        }
    }

    public void applyClrInt(Intention i) throws JasonException {
        while (i != null) {
            if (i.isFinished()) {
                this.confP.C.removeIntention(i);
                return;
            }
            IntendedMeans im = i.peek();
            if (!im.isFinished()) {
                return;
            }
            IntendedMeans topIM = i.pop();
            Literal topLiteral = topIM.getTrigger().getLiteral();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Returning from IM " + topIM.getPlan().getLabel() + ", te=" + topIM.getPlan().getTrigger());
            }
            if (im.getTrigger().isGoal() && !im.getTrigger().isAddition() && i.size() > 0) {
                im = i.peek();
                if (im.isFinished() || !im.unif.unifies(im.getCurrentStep().getBodyTerm(), topLiteral)) {
                    im = i.pop();
                }
                while (i.size() > 0 && !im.unif.unifies(im.getTrigger().getLiteral(), topLiteral) && !im.unif.unifies(im.getCurrentStep().getBodyTerm(), topLiteral)) {
                    im = i.pop();
                }
            }
            if (i.isFinished() || (im = i.peek()).isFinished()) continue;
            topLiteral.apply(topIM.unif);
            im.unif.unifies(im.removeCurrentStep(), topLiteral);
        }
        return;
    }

    public List<Option> relevantPlans(Trigger teP) throws JasonException {
        Trigger te = teP.clone();
        LinkedList<Option> rp = null;
        List<Plan> candidateRPs = this.conf.ag.pl.getCandidatePlans(te);
        if (candidateRPs != null) {
            for (Plan pl : candidateRPs) {
                Unifier relUn = pl.isRelevant(te);
                if (relUn == null) continue;
                if (rp == null) {
                    rp = new LinkedList<Option>();
                }
                rp.add(new Option(pl, relUn));
            }
        }
        return rp;
    }

    public List<Option> applicablePlans(List<Option> rp) throws JasonException {
        LinkedList<Option> ap = null;
        if (rp != null) {
            block0: for (Option opt : rp) {
                LogicalFormula context = opt.getPlan().getContext();
                if (context == null) {
                    if (ap == null) {
                        ap = new LinkedList<Option>();
                    }
                    ap.add(opt);
                    continue;
                }
                boolean allUnifs = opt.getPlan().isAllUnifs();
                Iterator<Unifier> r = context.logicalConsequence(this.ag, opt.getUnifier());
                if (r == null) continue;
                while (r.hasNext()) {
                    opt.setUnifier(r.next());
                    if (ap == null) {
                        ap = new LinkedList();
                    }
                    ap.add(opt);
                    if (!allUnifs) continue block0;
                    if (!r.hasNext()) continue;
                    opt = new Option(opt.getPlan(), null);
                }
            }
        }
        return ap;
    }

    public void updateEvents(List<Literal>[] result, Intention focus) {
        Trigger te;
        if (result == null) {
            return;
        }
        for (Literal ladd : result[0]) {
            te = new Trigger(Trigger.TEOperator.add, Trigger.TEType.belief, ladd);
            this.updateEvents(new Event(te, focus));
            focus = Intention.EmptyInt;
        }
        for (Literal lrem : result[1]) {
            te = new Trigger(Trigger.TEOperator.del, Trigger.TEType.belief, lrem);
            this.updateEvents(new Event(te, focus));
            focus = Intention.EmptyInt;
        }
    }

    public void updateEvents(Event e2) {
        if (e2.isInternal() || this.C.hasListener() || this.ag.getPL().hasCandidatePlan(e2.trigger)) {
            this.C.addEvent(e2);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Added event " + e2);
            }
        }
    }

    private void updateIntention() {
        if (!this.conf.C.SI.isFinished()) {
            IntendedMeans im = this.conf.C.SI.peek();
            im.removeCurrentStep();
            this.confP.C.addIntention(this.conf.C.SI);
        } else {
            this.logger.fine("trying to update a finished intention!");
        }
    }

    public boolean generateGoalDeletion(Intention i, List<Term> failAnnots) throws JasonException {
        boolean failEeventGenerated = false;
        IntendedMeans im = i.peek();
        if (im.isGoalAdd()) {
            Event failEvent = this.findEventForFailure(i, im.getTrigger());
            if (failEvent != null) {
                TransitionSystem.setDefaultFailureAnnots(failEvent, im.getCurrentStep().getBodyTerm(), failAnnots);
                this.confP.C.addEvent(failEvent);
                failEeventGenerated = true;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Generating goal deletion " + failEvent.getTrigger() + " from goal: " + im.getTrigger());
                }
            } else {
                this.logger.warning("No failure event was generated for " + im.getTrigger());
            }
        } else if (this.setts.requeue()) {
            im = i.get(0);
            this.confP.C.addExternalEv(im.getTrigger());
        } else {
            this.logger.warning("Could not finish intention: " + i);
        }
        return failEeventGenerated;
    }

    private boolean generateGoalDeletionFromEvent(List<Term> failAnnots) throws JasonException {
        Event ev = this.conf.C.SE;
        if (ev == null) {
            this.logger.warning("** It was not possible to generate a goal deletion event because SE is null! " + this.conf.C);
            return false;
        }
        Trigger tevent = ev.trigger;
        boolean failEeventGenerated = false;
        if (tevent.isAddition() && tevent.isGoal()) {
            Event failEvent = this.findEventForFailure(ev.intention, tevent);
            if (failEvent != null) {
                TransitionSystem.setDefaultFailureAnnots(failEvent, tevent.getLiteral(), failAnnots);
                this.confP.C.addEvent(failEvent);
                failEeventGenerated = true;
            } else {
                this.logger.warning("No fail event was generated for " + ev.getTrigger());
            }
        } else if (ev.isInternal()) {
            this.logger.warning("Could not finish intention:\n" + ev.intention);
        } else if (this.setts.requeue()) {
            this.confP.C.addEvent(ev);
            this.logger.warning("Requeing external event: " + ev);
        } else {
            this.logger.warning("Discarding external event: " + ev);
        }
        return failEeventGenerated;
    }

    public Event findEventForFailure(Intention i, Trigger tevent) {
        Trigger failTrigger = new Trigger(Trigger.TEOperator.del, tevent.getType(), tevent.getLiteral());
        if (i != Intention.EmptyInt) {
            ListIterator<IntendedMeans> ii = i.iterator();
            while (!this.getAg().getPL().hasCandidatePlan(failTrigger) && ii.hasPrevious()) {
                IntendedMeans im = ii.previous();
                tevent = im.getTrigger();
                failTrigger = new Trigger(Trigger.TEOperator.del, tevent.getType(), tevent.getLiteral());
            }
        }
        if (tevent.isGoal() && this.getAg().getPL().hasCandidatePlan(failTrigger)) {
            return new Event(failTrigger.clone(), i);
        }
        return null;
    }

    private static void setDefaultFailureAnnots(Event failEvent, Term body, List<Term> failAnnots) {
        if (failAnnots == null) {
            failAnnots = JasonException.createBasicErrorAnnots(JasonException.UNKNOW_ERROR, "");
        }
        Literal eventLiteral = failEvent.getTrigger().getLiteral();
        eventLiteral.addAnnots(failAnnots);
        Literal bodyterm = aNOCODE;
        DefaultTerm codesrc = aNOCODE;
        DefaultTerm codeline = aNOCODE;
        if (body != null && body instanceof Literal && (bodyterm = (Literal)body).getSrcInfo() != null) {
            if (bodyterm.getSrcInfo().getSrcFile() != null) {
                codesrc = new StringTermImpl(bodyterm.getSrcInfo().getSrcFile());
            }
            codeline = new NumberTermImpl(bodyterm.getSrcInfo().getSrcLine());
        }
        if (eventLiteral.getAnnots("code").isEmpty()) {
            eventLiteral.addAnnot(ASSyntax.createStructure("code", bodyterm));
        }
        if (eventLiteral.getAnnots("code_src").isEmpty()) {
            eventLiteral.addAnnot(ASSyntax.createStructure("code_src", codesrc));
        }
        if (eventLiteral.getAnnots("code_line").isEmpty()) {
            eventLiteral.addAnnot(ASSyntax.createStructure("code_line", codeline));
        }
    }

    public boolean canSleep() {
        return !this.conf.C.hasEvent() && !this.conf.C.hasIntention() && this.conf.C.MB.isEmpty() && !this.conf.C.hasFeedbackAction() && this.agArch.canSleep();
    }

    public void reasoningCycle() {
        try {
            this.C.reset();
            if (this.nrcslbr >= this.setts.nrcbp()) {
                this.nrcslbr = 0;
                this.ag.buf(this.agArch.perceive());
                this.agArch.checkMail();
            }
            ++this.nrcslbr;
            if (this.canSleep()) {
                if (this.ag.pl.getIdlePlans() != null) {
                    this.logger.fine("generating idle event");
                    this.C.addExternalEv(PlanLibrary.TE_IDLE);
                } else {
                    this.agArch.sleep();
                    return;
                }
            }
            this.step = State.StartRC;
            do {
                if (!this.agArch.isRunning()) {
                    return;
                }
                this.applySemanticRule();
            } while (this.step != State.StartRC);
            ActionExec action = this.C.getAction();
            if (action != null) {
                this.C.getPendingActions().put(action.getIntention().getId(), action);
                this.agArch.act(action, this.C.getFeedbackActions());
            }
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "*** ERROR in the transition system. " + this.conf.C + "\nCreating a new C!", e2);
            this.conf.C.create();
        }
    }

    public Agent getAg() {
        return this.ag;
    }

    public Circumstance getC() {
        return this.C;
    }

    public State getStep() {
        return this.step;
    }

    public Settings getSettings() {
        return this.setts;
    }

    public AgArch getUserAgArch() {
        return this.agArch;
    }

    public Logger getLogger() {
        return this.logger;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        StartRC,
        SelEv,
        RelPl,
        ApplPl,
        SelAppl,
        FindOp,
        AddIM,
        ProcAct,
        SelInt,
        ExecInt,
        ClrInt;

    }
}

