/*
 * Decompiled with CFR 0.152.
 */
package jason.asSemantics;

import jason.asSyntax.Literal;
import jason.asSyntax.Pred;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import jason.asSyntax.VarTerm;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Unifier
implements Cloneable {
    private static Logger logger = Logger.getLogger(Unifier.class.getName());
    protected HashMap<VarTerm, Term> function = new HashMap();

    public void apply(Term t) {
        t.apply(this);
    }

    public void apply(Pred p) {
        p.apply(this);
    }

    public Term get(String var) {
        return this.get(new VarTerm(var));
    }

    public Term get(VarTerm vtp) {
        Term vl = this.function.get(vtp);
        if (vl != null && vl.isVar()) {
            return this.get((VarTerm)vl);
        }
        return vl;
    }

    public boolean unifies(Trigger te1, Trigger te2) {
        return te1.sameType(te2) && this.unifies(te1.getLiteral(), te2.getLiteral());
    }

    public boolean unifiesNoUndo(Trigger te1, Trigger te2) {
        return te1.sameType(te2) && this.unifiesNoUndo(te1.getLiteral(), te2.getLiteral());
    }

    public boolean unifies(Term t1, Term t2) {
        HashMap cfunction = (HashMap)this.function.clone();
        if (this.unifiesNoUndo(t1, t2)) {
            return true;
        }
        this.function = cfunction;
        return false;
    }

    public boolean unifiesNoUndo(Term t1g, Term t2g) {
        boolean ok;
        Pred np1 = null;
        Pred np2 = null;
        if (t1g instanceof Pred && t2g instanceof Pred) {
            np1 = (Pred)t1g;
            np2 = (Pred)t2g;
            if ((np1.isVar() && np1.hasAnnot() || np2.isVar() && np2.hasAnnot()) && !np1.hasSubsetAnnot(np2, this)) {
                return false;
            }
        }
        if ((ok = this.unifyTerms(t1g, t2g)) && np1 != null) {
            Term np2vl;
            Pred pvl;
            Term np1vl;
            if (np1.isVar() && np1.hasAnnot() && (np1vl = this.function.get((VarTerm)(np1 = this.deref((VarTerm)np1)))) != null && np1vl.isPred()) {
                pvl = (Pred)np1vl.clone();
                pvl.clearAnnots();
                this.bind((VarTerm)np1, pvl);
            }
            if (np2.isVar() && np2.hasAnnot() && (np2vl = this.function.get((VarTerm)(np2 = this.deref((VarTerm)np2)))) != null && np2vl.isPred()) {
                pvl = (Pred)np2vl.clone();
                pvl.clearAnnots();
                this.bind((VarTerm)np2, pvl);
            }
        }
        return ok;
    }

    protected boolean unifyTerms(Term t1g, Term t2g) {
        if (t1g.isArithExpr()) {
            t1g = t1g.clone();
            t1g.apply(this);
        }
        if (t2g.isArithExpr()) {
            t2g = t2g.clone();
            t2g.apply(this);
        }
        boolean t1gisvar = t1g.isVar();
        boolean t2gisvar = t2g.isVar();
        if (t1gisvar || t2gisvar) {
            Term t2vl;
            VarTerm t1gv = t1gisvar ? this.deref((VarTerm)t1g) : null;
            VarTerm t2gv = t2gisvar ? this.deref((VarTerm)t2g) : null;
            Term t1vl = t1gisvar ? this.function.get(t1gv) : t1g;
            Term term = t2vl = t2gisvar ? this.function.get(t2gv) : t2g;
            if (t1vl != null && t2vl != null) {
                return this.unifiesNoUndo(t1vl, t2vl);
            }
            if (t1vl != null) {
                this.bind(t2gv, t1vl);
            } else if (t2vl != null) {
                this.bind(t1gv, t2vl);
            } else {
                this.bind(t1gv, t2gv);
            }
            return true;
        }
        if (!t1g.isLiteral() || !t2g.isLiteral()) {
            return t1g.equals(t2g);
        }
        Literal t1s = (Literal)t1g;
        Literal t2s = (Literal)t2g;
        int ts = t1s.getArity();
        if (ts != t2s.getArity()) {
            return false;
        }
        if (t1s.negated() != t2s.negated()) {
            return false;
        }
        if (!t1s.getFunctor().equals(t2s.getFunctor())) {
            return false;
        }
        int i = 0;
        while (i < ts) {
            if (!this.unifiesNoUndo(t1s.getTerm(i), t2s.getTerm(i))) {
                return false;
            }
            ++i;
        }
        return t1s.hasSubsetAnnot(t2s, this);
    }

    public VarTerm deref(VarTerm v) {
        Term vl = this.function.get(v);
        VarTerm first = v;
        while (vl != null && vl.isVar()) {
            v = (VarTerm)vl;
            vl = this.function.get(v);
        }
        if (first != v) {
            this.function.put(first, v);
        }
        return v;
    }

    public void bind(VarTerm vt1, VarTerm vt2) {
        int comp = vt1.compareTo(vt2);
        if (comp < 0) {
            this.function.put((VarTerm)vt1.clone(), vt2);
        } else if (comp > 0) {
            this.function.put((VarTerm)vt2.clone(), vt1);
        }
    }

    private void bind(VarTerm vt, Term vl) {
        this.function.put((VarTerm)vt.clone(), vl);
    }

    public void clear() {
        this.function.clear();
    }

    public String toString() {
        return this.function.toString();
    }

    public int size() {
        return this.function.size();
    }

    public void compose(Unifier u) {
        for (VarTerm k : u.function.keySet()) {
            this.function.put((VarTerm)k.clone(), u.function.get(k).clone());
        }
    }

    public Unifier clone() {
        try {
            Unifier newUn = new Unifier();
            newUn.function = (HashMap)this.function.clone();
            return newUn;
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error cloning unifier.", e2);
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Unifier) {
            return this.function.equals(((Unifier)o).function);
        }
        return false;
    }

    public Element getAsDOM(Document document) {
        Element u = document.createElement("unifier");
        for (VarTerm v : this.function.keySet()) {
            Element ev = v.getAsDOM(document);
            Element vl = document.createElement("value");
            vl.appendChild(this.function.get(v).getAsDOM(document));
            Element map = document.createElement("map");
            map.appendChild(ev);
            map.appendChild(vl);
            u.appendChild(map);
        }
        return u;
    }
}

