/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSyntax.Atom;
import jason.asSyntax.ListTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Literal;
import jason.asSyntax.LiteralImpl;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Plan;
import jason.asSyntax.PlanBody;
import jason.asSyntax.StringTerm;
import jason.asSyntax.StringTermImpl;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import jason.asSyntax.VarTerm;
import jason.asSyntax.parser.ParseException;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASSyntax {
    public static Literal createLiteral(String functor, Term ... terms) {
        return new LiteralImpl(functor).addTerms(terms);
    }

    public static Literal createLiteral(boolean positive, String functor, Term ... terms) {
        return new LiteralImpl(positive, functor).addTerms(terms);
    }

    public static Structure createStructure(String functor, Term ... terms) {
        int size = terms == null || terms.length == 0 ? 3 : terms.length;
        return (Structure)new Structure(functor, size).addTerms(terms);
    }

    public static Atom createAtom(String functor) {
        return new Atom(functor);
    }

    public static NumberTerm createNumber(double vl) {
        return new NumberTermImpl(vl);
    }

    public static StringTerm createString(String s) {
        return new StringTermImpl(s);
    }

    public static VarTerm createVar(String functor) {
        return new VarTerm(functor);
    }

    public static ListTerm createList(Term ... terms) {
        ListTermImpl l;
        ListTerm tail = l = new ListTermImpl();
        Term[] termArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            tail = tail.append(t);
            ++n2;
        }
        return l;
    }

    public static ListTerm createList(Collection<Term> terms) {
        ListTermImpl l;
        ListTerm tail = l = new ListTermImpl();
        for (Term t : terms) {
            tail = tail.append(t);
        }
        return l;
    }

    public static Literal parseLiteral(String sLiteral) throws ParseException {
        return new as2j(new StringReader(sLiteral)).literal();
    }

    public static NumberTerm parseNumber(String number2) throws NumberFormatException {
        return new NumberTermImpl(Double.parseDouble(number2));
    }

    public static Structure parseStructure(String sTerm) throws ParseException {
        Term t = new as2j(new StringReader(sTerm)).term();
        if (t instanceof Structure) {
            return (Structure)t;
        }
        return new Structure((Literal)t);
    }

    public static Term parseTerm(String sTerm) throws ParseException {
        return new as2j(new StringReader(sTerm)).term();
    }

    public static Plan parsePlan(String sPlan) throws ParseException {
        return new as2j(new StringReader(sPlan)).plan();
    }

    public static Trigger parseTrigger(String sTe) throws ParseException {
        return new as2j(new StringReader(sTe)).trigger();
    }

    public static ListTerm parseList(String sList) throws ParseException {
        return new as2j(new StringReader(sList)).list();
    }

    public static LogicalFormula parseFormula(String sExpr) throws ParseException {
        return (LogicalFormula)new as2j(new StringReader(sExpr)).log_expr();
    }

    public static PlanBody parsePlanBody(String sExpr) throws ParseException {
        return new as2j(new StringReader(sExpr)).plan_body();
    }
}

