/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Agent;
import jason.asSemantics.ArithFunction;
import jason.asSemantics.Unifier;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ArithFunctionTerm
extends Structure
implements NumberTerm {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ArithFunctionTerm.class.getName());
    private NumberTerm value = null;
    private ArithFunction function = null;
    private Agent agent = null;

    public ArithFunctionTerm(String functor, int termsSize) {
        super(functor, termsSize);
    }

    public ArithFunctionTerm(ArithFunction function) {
        super(function.getName(), 2);
        this.function = function;
    }

    public ArithFunctionTerm(ArithFunctionTerm af) {
        super(af);
        this.value = af.value;
        this.function = af.function;
        this.agent = af.agent;
    }

    public NumberTerm getValue() {
        return this.value;
    }

    public boolean isNumeric() {
        return true;
    }

    public boolean isAtom() {
        return false;
    }

    public boolean isStructure() {
        return false;
    }

    public boolean isArithExpr() {
        return !this.isEvaluated();
    }

    public boolean isEvaluated() {
        return this.value != null;
    }

    public boolean isGround() {
        return this.isEvaluated() || super.isGround();
    }

    public boolean isUnary() {
        return this.getArity() == 1;
    }

    public boolean apply(Unifier u) {
        if (this.isEvaluated()) {
            return false;
        }
        super.apply(u);
        if (this.function != null && this.function.allowUngroundTerms() || this.isGround()) {
            try {
                this.value = new NumberTermImpl(this.solve());
                return true;
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, String.valueOf(this.getErrorMsg()) + " -- " + e2);
            }
        }
        return false;
    }

    public void setAgent(Agent ag) {
        this.agent = ag;
    }

    public double solve() {
        if (this.isEvaluated()) {
            return this.value.solve();
        }
        if (this.function != null) {
            try {
                return this.function.evaluate(this.agent == null ? null : this.agent.getTS(), this.getTermsArray());
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, String.valueOf(this.getErrorMsg()) + " -- error in evaluate!", e2);
            }
        } else {
            logger.log(Level.SEVERE, String.valueOf(this.getErrorMsg()) + " -- the function can not be evalutated, it has no function assigned to it!", new Exception());
        }
        return 0.0;
    }

    public boolean checkArity(int a) {
        return this.function != null && this.function.checkArity(a);
    }

    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (this.isEvaluated()) {
            return this.value.equals(t);
        }
        return super.equals(t);
    }

    public int compareTo(Term o) {
        NumberTerm st;
        block4: {
            st = (NumberTerm)o;
            if (!(this.solve() > st.solve())) break block4;
            return 1;
        }
        try {
            if (this.solve() < st.solve()) {
                return -1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    protected int calcHashCode() {
        if (this.isEvaluated()) {
            return this.value.hashCode();
        }
        return super.calcHashCode();
    }

    public String toString() {
        if (this.isEvaluated()) {
            return this.value.toString();
        }
        return super.toString();
    }

    public String getErrorMsg() {
        return "Error in '" + this + "' (" + super.getErrorMsg() + ")";
    }

    public NumberTerm clone() {
        if (this.isEvaluated()) {
            return this.value;
        }
        return new ArithFunctionTerm(this);
    }

    public Element getAsDOM(Document document) {
        if (this.isEvaluated()) {
            return this.value.getAsDOM(document);
        }
        Element u = document.createElement("expression");
        u.setAttribute("type", "arithmetic");
        Element r = document.createElement("right");
        r.appendChild(super.getAsDOM(document));
        u.appendChild(r);
        return u;
    }
}

