/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSyntax.ListTerm;
import jason.asSyntax.Literal;
import jason.asSyntax.Term;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Atom
extends Literal {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(Atom.class.getName());
    private final String functor;

    public Atom(String functor) {
        if (functor == null) {
            logger.log(Level.WARNING, "A structure functor should not be null!", new Exception());
        }
        this.functor = functor;
    }

    public Atom(Literal l) {
        this.functor = l.getFunctor();
        this.predicateIndicatorCache = l.predicateIndicatorCache;
        this.hashCodeCache = l.hashCodeCache;
        this.srcInfo = l.srcInfo;
    }

    public String getFunctor() {
        return this.functor;
    }

    public Term clone() {
        return this;
    }

    public boolean isAtom() {
        return true;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Atom) {
            Atom a = (Atom)o;
            return a.isAtom() && this.getFunctor().equals(a.getFunctor());
        }
        return false;
    }

    public int compareTo(Term t) {
        if (t.isNumeric()) {
            return 1;
        }
        if (this.isList() && !t.isList()) {
            return 1;
        }
        if (!this.isList() && t.isList()) {
            return -1;
        }
        if (this.isList() && t.isList()) {
            int l2s;
            ListTerm l1 = (ListTerm)((Object)this);
            ListTerm l2 = (ListTerm)t;
            int l1s = l1.size();
            if (l1s > (l2s = l2.size())) {
                return 1;
            }
            if (l2s > l1s) {
                return -1;
            }
            return 0;
        }
        if (t instanceof Atom) {
            Atom tAsAtom = (Atom)t;
            return this.getFunctor().compareTo(tAsAtom.getFunctor());
        }
        return super.compareTo(t);
    }

    protected int calcHashCode() {
        return this.getFunctor().hashCode();
    }

    public String toString() {
        return this.functor;
    }

    public Element getAsDOM(Document document) {
        Element u = document.createElement("structure");
        u.setAttribute("functor", this.getFunctor());
        return u;
    }
}

